"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/recharts-scale";
exports.ids = ["vendor-chunks/recharts-scale"];
exports.modules = {

/***/ "(ssr)/./node_modules/recharts-scale/lib/getNiceTickValues.js":
/*!**************************************************************!*\
  !*** ./node_modules/recharts-scale/lib/getNiceTickValues.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.getTickValuesFixedDomain = exports.getTickValues = exports.getNiceTickValues = void 0;\n\nvar _decimal = _interopRequireDefault(__webpack_require__(/*! decimal.js-light */ \"(ssr)/./node_modules/decimal.js-light/decimal.js\"));\n\nvar _utils = __webpack_require__(/*! ./util/utils */ \"(ssr)/./node_modules/recharts-scale/lib/util/utils.js\");\n\nvar _arithmetic = _interopRequireDefault(__webpack_require__(/*! ./util/arithmetic */ \"(ssr)/./node_modules/recharts-scale/lib/util/arithmetic.js\"));\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && Symbol.iterator in Object(iter)) return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _iterableToArrayLimit(arr, i) { if (typeof Symbol === \"undefined\" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n/**\n * Calculate a interval of a minimum value and a maximum value\n *\n * @param  {Number} min       The minimum value\n * @param  {Number} max       The maximum value\n * @return {Array} An interval\n */\nfunction getValidInterval(_ref) {\n  var _ref2 = _slicedToArray(_ref, 2),\n      min = _ref2[0],\n      max = _ref2[1];\n\n  var validMin = min,\n      validMax = max; // exchange\n\n  if (min > max) {\n    validMin = max;\n    validMax = min;\n  }\n\n  return [validMin, validMax];\n}\n/**\n * Calculate the step which is easy to understand between ticks, like 10, 20, 25\n *\n * @param  {Decimal} roughStep        The rough step calculated by deviding the\n * difference by the tickCount\n * @param  {Boolean} allowDecimals    Allow the ticks to be decimals or not\n * @param  {Integer} correctionFactor A correction factor\n * @return {Decimal} The step which is easy to understand between two ticks\n */\n\n\nfunction getFormatStep(roughStep, allowDecimals, correctionFactor) {\n  if (roughStep.lte(0)) {\n    return new _decimal.default(0);\n  }\n\n  var digitCount = _arithmetic.default.getDigitCount(roughStep.toNumber()); // The ratio between the rough step and the smallest number which has a bigger\n  // order of magnitudes than the rough step\n\n\n  var digitCountValue = new _decimal.default(10).pow(digitCount);\n  var stepRatio = roughStep.div(digitCountValue); // When an integer and a float multiplied, the accuracy of result may be wrong\n\n  var stepRatioScale = digitCount !== 1 ? 0.05 : 0.1;\n  var amendStepRatio = new _decimal.default(Math.ceil(stepRatio.div(stepRatioScale).toNumber())).add(correctionFactor).mul(stepRatioScale);\n  var formatStep = amendStepRatio.mul(digitCountValue);\n  return allowDecimals ? formatStep : new _decimal.default(Math.ceil(formatStep));\n}\n/**\n * calculate the ticks when the minimum value equals to the maximum value\n *\n * @param  {Number}  value         The minimum valuue which is also the maximum value\n * @param  {Integer} tickCount     The count of ticks\n * @param  {Boolean} allowDecimals Allow the ticks to be decimals or not\n * @return {Array}                 ticks\n */\n\n\nfunction getTickOfSingleValue(value, tickCount, allowDecimals) {\n  var step = 1; // calculate the middle value of ticks\n\n  var middle = new _decimal.default(value);\n\n  if (!middle.isint() && allowDecimals) {\n    var absVal = Math.abs(value);\n\n    if (absVal < 1) {\n      // The step should be a float number when the difference is smaller than 1\n      step = new _decimal.default(10).pow(_arithmetic.default.getDigitCount(value) - 1);\n      middle = new _decimal.default(Math.floor(middle.div(step).toNumber())).mul(step);\n    } else if (absVal > 1) {\n      // Return the maximum integer which is smaller than 'value' when 'value' is greater than 1\n      middle = new _decimal.default(Math.floor(value));\n    }\n  } else if (value === 0) {\n    middle = new _decimal.default(Math.floor((tickCount - 1) / 2));\n  } else if (!allowDecimals) {\n    middle = new _decimal.default(Math.floor(value));\n  }\n\n  var middleIndex = Math.floor((tickCount - 1) / 2);\n  var fn = (0, _utils.compose)((0, _utils.map)(function (n) {\n    return middle.add(new _decimal.default(n - middleIndex).mul(step)).toNumber();\n  }), _utils.range);\n  return fn(0, tickCount);\n}\n/**\n * Calculate the step\n *\n * @param  {Number}  min              The minimum value of an interval\n * @param  {Number}  max              The maximum value of an interval\n * @param  {Integer} tickCount        The count of ticks\n * @param  {Boolean} allowDecimals    Allow the ticks to be decimals or not\n * @param  {Number}  correctionFactor A correction factor\n * @return {Object}  The step, minimum value of ticks, maximum value of ticks\n */\n\n\nfunction calculateStep(min, max, tickCount, allowDecimals) {\n  var correctionFactor = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;\n\n  // dirty hack (for recharts' test)\n  if (!Number.isFinite((max - min) / (tickCount - 1))) {\n    return {\n      step: new _decimal.default(0),\n      tickMin: new _decimal.default(0),\n      tickMax: new _decimal.default(0)\n    };\n  } // The step which is easy to understand between two ticks\n\n\n  var step = getFormatStep(new _decimal.default(max).sub(min).div(tickCount - 1), allowDecimals, correctionFactor); // A medial value of ticks\n\n  var middle; // When 0 is inside the interval, 0 should be a tick\n\n  if (min <= 0 && max >= 0) {\n    middle = new _decimal.default(0);\n  } else {\n    // calculate the middle value\n    middle = new _decimal.default(min).add(max).div(2); // minus modulo value\n\n    middle = middle.sub(new _decimal.default(middle).mod(step));\n  }\n\n  var belowCount = Math.ceil(middle.sub(min).div(step).toNumber());\n  var upCount = Math.ceil(new _decimal.default(max).sub(middle).div(step).toNumber());\n  var scaleCount = belowCount + upCount + 1;\n\n  if (scaleCount > tickCount) {\n    // When more ticks need to cover the interval, step should be bigger.\n    return calculateStep(min, max, tickCount, allowDecimals, correctionFactor + 1);\n  }\n\n  if (scaleCount < tickCount) {\n    // When less ticks can cover the interval, we should add some additional ticks\n    upCount = max > 0 ? upCount + (tickCount - scaleCount) : upCount;\n    belowCount = max > 0 ? belowCount : belowCount + (tickCount - scaleCount);\n  }\n\n  return {\n    step: step,\n    tickMin: middle.sub(new _decimal.default(belowCount).mul(step)),\n    tickMax: middle.add(new _decimal.default(upCount).mul(step))\n  };\n}\n/**\n * Calculate the ticks of an interval, the count of ticks will be guraranteed\n *\n * @param  {Number}  min, max      min: The minimum value, max: The maximum value\n * @param  {Integer} tickCount     The count of ticks\n * @param  {Boolean} allowDecimals Allow the ticks to be decimals or not\n * @return {Array}   ticks\n */\n\n\nfunction getNiceTickValuesFn(_ref3) {\n  var _ref4 = _slicedToArray(_ref3, 2),\n      min = _ref4[0],\n      max = _ref4[1];\n\n  var tickCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 6;\n  var allowDecimals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;\n  // More than two ticks should be return\n  var count = Math.max(tickCount, 2);\n\n  var _getValidInterval = getValidInterval([min, max]),\n      _getValidInterval2 = _slicedToArray(_getValidInterval, 2),\n      cormin = _getValidInterval2[0],\n      cormax = _getValidInterval2[1];\n\n  if (cormin === -Infinity || cormax === Infinity) {\n    var _values = cormax === Infinity ? [cormin].concat(_toConsumableArray((0, _utils.range)(0, tickCount - 1).map(function () {\n      return Infinity;\n    }))) : [].concat(_toConsumableArray((0, _utils.range)(0, tickCount - 1).map(function () {\n      return -Infinity;\n    })), [cormax]);\n\n    return min > max ? (0, _utils.reverse)(_values) : _values;\n  }\n\n  if (cormin === cormax) {\n    return getTickOfSingleValue(cormin, tickCount, allowDecimals);\n  } // Get the step between two ticks\n\n\n  var _calculateStep = calculateStep(cormin, cormax, count, allowDecimals),\n      step = _calculateStep.step,\n      tickMin = _calculateStep.tickMin,\n      tickMax = _calculateStep.tickMax;\n\n  var values = _arithmetic.default.rangeStep(tickMin, tickMax.add(new _decimal.default(0.1).mul(step)), step);\n\n  return min > max ? (0, _utils.reverse)(values) : values;\n}\n/**\n * Calculate the ticks of an interval, the count of ticks won't be guraranteed\n *\n * @param  {Number}  min, max      min: The minimum value, max: The maximum value\n * @param  {Integer} tickCount     The count of ticks\n * @param  {Boolean} allowDecimals Allow the ticks to be decimals or not\n * @return {Array}   ticks\n */\n\n\nfunction getTickValuesFn(_ref5) {\n  var _ref6 = _slicedToArray(_ref5, 2),\n      min = _ref6[0],\n      max = _ref6[1];\n\n  var tickCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 6;\n  var allowDecimals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;\n  // More than two ticks should be return\n  var count = Math.max(tickCount, 2);\n\n  var _getValidInterval3 = getValidInterval([min, max]),\n      _getValidInterval4 = _slicedToArray(_getValidInterval3, 2),\n      cormin = _getValidInterval4[0],\n      cormax = _getValidInterval4[1];\n\n  if (cormin === -Infinity || cormax === Infinity) {\n    return [min, max];\n  }\n\n  if (cormin === cormax) {\n    return getTickOfSingleValue(cormin, tickCount, allowDecimals);\n  }\n\n  var step = getFormatStep(new _decimal.default(cormax).sub(cormin).div(count - 1), allowDecimals, 0);\n  var fn = (0, _utils.compose)((0, _utils.map)(function (n) {\n    return new _decimal.default(cormin).add(new _decimal.default(n).mul(step)).toNumber();\n  }), _utils.range);\n  var values = fn(0, count).filter(function (entry) {\n    return entry >= cormin && entry <= cormax;\n  });\n  return min > max ? (0, _utils.reverse)(values) : values;\n}\n/**\n * Calculate the ticks of an interval, the count of ticks won't be guraranteed,\n * but the domain will be guaranteed\n *\n * @param  {Number}  min, max      min: The minimum value, max: The maximum value\n * @param  {Integer} tickCount     The count of ticks\n * @param  {Boolean} allowDecimals Allow the ticks to be decimals or not\n * @return {Array}   ticks\n */\n\n\nfunction getTickValuesFixedDomainFn(_ref7, tickCount) {\n  var _ref8 = _slicedToArray(_ref7, 2),\n      min = _ref8[0],\n      max = _ref8[1];\n\n  var allowDecimals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;\n\n  // More than two ticks should be return\n  var _getValidInterval5 = getValidInterval([min, max]),\n      _getValidInterval6 = _slicedToArray(_getValidInterval5, 2),\n      cormin = _getValidInterval6[0],\n      cormax = _getValidInterval6[1];\n\n  if (cormin === -Infinity || cormax === Infinity) {\n    return [min, max];\n  }\n\n  if (cormin === cormax) {\n    return [cormin];\n  }\n\n  var count = Math.max(tickCount, 2);\n  var step = getFormatStep(new _decimal.default(cormax).sub(cormin).div(count - 1), allowDecimals, 0);\n  var values = [].concat(_toConsumableArray(_arithmetic.default.rangeStep(new _decimal.default(cormin), new _decimal.default(cormax).sub(new _decimal.default(0.99).mul(step)), step)), [cormax]);\n  return min > max ? (0, _utils.reverse)(values) : values;\n}\n\nvar getNiceTickValues = (0, _utils.memoize)(getNiceTickValuesFn);\nexports.getNiceTickValues = getNiceTickValues;\nvar getTickValues = (0, _utils.memoize)(getTickValuesFn);\nexports.getTickValues = getTickValues;\nvar getTickValuesFixedDomain = (0, _utils.memoize)(getTickValuesFixedDomainFn);\nexports.getTickValuesFixedDomain = getTickValuesFixedDomain;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/recharts-scale/lib/getNiceTickValues.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/recharts-scale/lib/index.js":
/*!**************************************************!*\
  !*** ./node_modules/recharts-scale/lib/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nObject.defineProperty(exports, \"getTickValues\", ({\n  enumerable: true,\n  get: function get() {\n    return _getNiceTickValues.getTickValues;\n  }\n}));\nObject.defineProperty(exports, \"getNiceTickValues\", ({\n  enumerable: true,\n  get: function get() {\n    return _getNiceTickValues.getNiceTickValues;\n  }\n}));\nObject.defineProperty(exports, \"getTickValuesFixedDomain\", ({\n  enumerable: true,\n  get: function get() {\n    return _getNiceTickValues.getTickValuesFixedDomain;\n  }\n}));\n\nvar _getNiceTickValues = __webpack_require__(/*! ./getNiceTickValues */ \"(ssr)/./node_modules/recharts-scale/lib/getNiceTickValues.js\");//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvcmVjaGFydHMtc2NhbGUvbGliL2luZGV4LmpzIiwibWFwcGluZ3MiOiJBQUFhOztBQUViLDhDQUE2QztBQUM3QztBQUNBLENBQUMsRUFBQztBQUNGLGlEQUFnRDtBQUNoRDtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBQUMsRUFBQztBQUNGLHFEQUFvRDtBQUNwRDtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBQUMsRUFBQztBQUNGLDREQUEyRDtBQUMzRDtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBQUMsRUFBQzs7QUFFRix5QkFBeUIsbUJBQU8sQ0FBQyx5RkFBcUIiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9uZXh0anMvLi9ub2RlX21vZHVsZXMvcmVjaGFydHMtc2NhbGUvbGliL2luZGV4LmpzPzc5OGEiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5cbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwge1xuICB2YWx1ZTogdHJ1ZVxufSk7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJnZXRUaWNrVmFsdWVzXCIsIHtcbiAgZW51bWVyYWJsZTogdHJ1ZSxcbiAgZ2V0OiBmdW5jdGlvbiBnZXQoKSB7XG4gICAgcmV0dXJuIF9nZXROaWNlVGlja1ZhbHVlcy5nZXRUaWNrVmFsdWVzO1xuICB9XG59KTtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcImdldE5pY2VUaWNrVmFsdWVzXCIsIHtcbiAgZW51bWVyYWJsZTogdHJ1ZSxcbiAgZ2V0OiBmdW5jdGlvbiBnZXQoKSB7XG4gICAgcmV0dXJuIF9nZXROaWNlVGlja1ZhbHVlcy5nZXROaWNlVGlja1ZhbHVlcztcbiAgfVxufSk7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJnZXRUaWNrVmFsdWVzRml4ZWREb21haW5cIiwge1xuICBlbnVtZXJhYmxlOiB0cnVlLFxuICBnZXQ6IGZ1bmN0aW9uIGdldCgpIHtcbiAgICByZXR1cm4gX2dldE5pY2VUaWNrVmFsdWVzLmdldFRpY2tWYWx1ZXNGaXhlZERvbWFpbjtcbiAgfVxufSk7XG5cbnZhciBfZ2V0TmljZVRpY2tWYWx1ZXMgPSByZXF1aXJlKFwiLi9nZXROaWNlVGlja1ZhbHVlc1wiKTsiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/recharts-scale/lib/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/recharts-scale/lib/util/arithmetic.js":
/*!************************************************************!*\
  !*** ./node_modules/recharts-scale/lib/util/arithmetic.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports[\"default\"] = void 0;\n\nvar _decimal = _interopRequireDefault(__webpack_require__(/*! decimal.js-light */ \"(ssr)/./node_modules/decimal.js-light/decimal.js\"));\n\nvar _utils = __webpack_require__(/*! ./utils */ \"(ssr)/./node_modules/recharts-scale/lib/util/utils.js\");\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/**\n * @fileOverview 一些公用的运算方法\n * @author xile611\n * @date 2015-09-17\n */\n\n/**\n * 获取数值的位数\n * 其中绝对值属于区间[0.1, 1)， 得到的值为0\n * 绝对值属于区间[0.01, 0.1)，得到的位数为 -1\n * 绝对值属于区间[0.001, 0.01)，得到的位数为 -2\n *\n * @param  {Number} value 数值\n * @return {Integer} 位数\n */\nfunction getDigitCount(value) {\n  var result;\n\n  if (value === 0) {\n    result = 1;\n  } else {\n    result = Math.floor(new _decimal.default(value).abs().log(10).toNumber()) + 1;\n  }\n\n  return result;\n}\n/**\n * 按照固定的步长获取[start, end)这个区间的数据\n * 并且需要处理js计算精度的问题\n *\n * @param  {Decimal} start 起点\n * @param  {Decimal} end   终点，不包含该值\n * @param  {Decimal} step  步长\n * @return {Array}         若干数值\n */\n\n\nfunction rangeStep(start, end, step) {\n  var num = new _decimal.default(start);\n  var i = 0;\n  var result = []; // magic number to prevent infinite loop\n\n  while (num.lt(end) && i < 100000) {\n    result.push(num.toNumber());\n    num = num.add(step);\n    i++;\n  }\n\n  return result;\n}\n/**\n * 对数值进行线性插值\n *\n * @param  {Number} a  定义域的极点\n * @param  {Number} b  定义域的极点\n * @param  {Number} t  [0, 1]内的某个值\n * @return {Number}    定义域内的某个值\n */\n\n\nvar interpolateNumber = (0, _utils.curry)(function (a, b, t) {\n  var newA = +a;\n  var newB = +b;\n  return newA + t * (newB - newA);\n});\n/**\n * 线性插值的逆运算\n *\n * @param  {Number} a 定义域的极点\n * @param  {Number} b 定义域的极点\n * @param  {Number} x 可以认为是插值后的一个输出值\n * @return {Number}   当x在 a ~ b这个范围内时，返回值属于[0, 1]\n */\n\nvar uninterpolateNumber = (0, _utils.curry)(function (a, b, x) {\n  var diff = b - +a;\n  diff = diff || Infinity;\n  return (x - a) / diff;\n});\n/**\n * 线性插值的逆运算，并且有截断的操作\n *\n * @param  {Number} a 定义域的极点\n * @param  {Number} b 定义域的极点\n * @param  {Number} x 可以认为是插值后的一个输出值\n * @return {Number}   当x在 a ~ b这个区间内时，返回值属于[0, 1]，\n * 当x不在 a ~ b这个区间时，会截断到 a ~ b 这个区间\n */\n\nvar uninterpolateTruncation = (0, _utils.curry)(function (a, b, x) {\n  var diff = b - +a;\n  diff = diff || Infinity;\n  return Math.max(0, Math.min(1, (x - a) / diff));\n});\nvar _default = {\n  rangeStep: rangeStep,\n  getDigitCount: getDigitCount,\n  interpolateNumber: interpolateNumber,\n  uninterpolateNumber: uninterpolateNumber,\n  uninterpolateTruncation: uninterpolateTruncation\n};\nexports[\"default\"] = _default;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/recharts-scale/lib/util/arithmetic.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/recharts-scale/lib/util/utils.js":
/*!*******************************************************!*\
  !*** ./node_modules/recharts-scale/lib/util/utils.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports) => {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.memoize = exports.reverse = exports.compose = exports.map = exports.range = exports.curry = exports.PLACE_HOLDER = void 0;\n\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && Symbol.iterator in Object(iter)) return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nvar identity = function identity(i) {\n  return i;\n};\n\nvar PLACE_HOLDER = {\n  '@@functional/placeholder': true\n};\nexports.PLACE_HOLDER = PLACE_HOLDER;\n\nvar isPlaceHolder = function isPlaceHolder(val) {\n  return val === PLACE_HOLDER;\n};\n\nvar curry0 = function curry0(fn) {\n  return function _curried() {\n    if (arguments.length === 0 || arguments.length === 1 && isPlaceHolder(arguments.length <= 0 ? undefined : arguments[0])) {\n      return _curried;\n    }\n\n    return fn.apply(void 0, arguments);\n  };\n};\n\nvar curryN = function curryN(n, fn) {\n  if (n === 1) {\n    return fn;\n  }\n\n  return curry0(function () {\n    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n      args[_key] = arguments[_key];\n    }\n\n    var argsLength = args.filter(function (arg) {\n      return arg !== PLACE_HOLDER;\n    }).length;\n\n    if (argsLength >= n) {\n      return fn.apply(void 0, args);\n    }\n\n    return curryN(n - argsLength, curry0(function () {\n      for (var _len2 = arguments.length, restArgs = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n        restArgs[_key2] = arguments[_key2];\n      }\n\n      var newArgs = args.map(function (arg) {\n        return isPlaceHolder(arg) ? restArgs.shift() : arg;\n      });\n      return fn.apply(void 0, _toConsumableArray(newArgs).concat(restArgs));\n    }));\n  });\n};\n\nvar curry = function curry(fn) {\n  return curryN(fn.length, fn);\n};\n\nexports.curry = curry;\n\nvar range = function range(begin, end) {\n  var arr = [];\n\n  for (var i = begin; i < end; ++i) {\n    arr[i - begin] = i;\n  }\n\n  return arr;\n};\n\nexports.range = range;\nvar map = curry(function (fn, arr) {\n  if (Array.isArray(arr)) {\n    return arr.map(fn);\n  }\n\n  return Object.keys(arr).map(function (key) {\n    return arr[key];\n  }).map(fn);\n});\nexports.map = map;\n\nvar compose = function compose() {\n  for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {\n    args[_key3] = arguments[_key3];\n  }\n\n  if (!args.length) {\n    return identity;\n  }\n\n  var fns = args.reverse(); // first function can receive multiply arguments\n\n  var firstFn = fns[0];\n  var tailsFn = fns.slice(1);\n  return function () {\n    return tailsFn.reduce(function (res, fn) {\n      return fn(res);\n    }, firstFn.apply(void 0, arguments));\n  };\n};\n\nexports.compose = compose;\n\nvar reverse = function reverse(arr) {\n  if (Array.isArray(arr)) {\n    return arr.reverse();\n  } // can be string\n\n\n  return arr.split('').reverse.join('');\n};\n\nexports.reverse = reverse;\n\nvar memoize = function memoize(fn) {\n  var lastArgs = null;\n  var lastResult = null;\n  return function () {\n    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {\n      args[_key4] = arguments[_key4];\n    }\n\n    if (lastArgs && args.every(function (val, i) {\n      return val === lastArgs[i];\n    })) {\n      return lastResult;\n    }\n\n    lastArgs = args;\n    lastResult = fn.apply(void 0, args);\n    return lastResult;\n  };\n};\n\nexports.memoize = memoize;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvcmVjaGFydHMtc2NhbGUvbGliL3V0aWwvdXRpbHMuanMiLCJtYXBwaW5ncyI6IkFBQWE7O0FBRWIsOENBQTZDO0FBQzdDO0FBQ0EsQ0FBQyxFQUFDO0FBQ0YsZUFBZSxHQUFHLGVBQWUsR0FBRyxlQUFlLEdBQUcsV0FBVyxHQUFHLGFBQWEsR0FBRyxhQUFhLEdBQUcsb0JBQW9COztBQUV4SCxtQ0FBbUM7O0FBRW5DLGdDQUFnQzs7QUFFaEMsa0RBQWtELGdCQUFnQixnRUFBZ0Usd0RBQXdELDZEQUE2RCxzREFBc0Q7O0FBRTdTLGtDQUFrQzs7QUFFbEMsbUNBQW1DOztBQUVuQyx1Q0FBdUMsdURBQXVELHVDQUF1QyxTQUFTLE9BQU8sb0JBQW9COztBQUV6SztBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0Esb0JBQW9COztBQUVwQjtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSx3RUFBd0UsYUFBYTtBQUNyRjtBQUNBOztBQUVBO0FBQ0E7QUFDQSxLQUFLOztBQUVMO0FBQ0E7QUFDQTs7QUFFQTtBQUNBLGlGQUFpRixlQUFlO0FBQ2hHO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBLEtBQUs7QUFDTCxHQUFHO0FBQ0g7O0FBRUE7QUFDQTtBQUNBOztBQUVBLGFBQWE7O0FBRWI7QUFDQTs7QUFFQSxzQkFBc0IsU0FBUztBQUMvQjtBQUNBOztBQUVBO0FBQ0E7O0FBRUEsYUFBYTtBQUNiO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxHQUFHO0FBQ0gsQ0FBQztBQUNELFdBQVc7O0FBRVg7QUFDQSx5RUFBeUUsZUFBZTtBQUN4RjtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSw0QkFBNEI7O0FBRTVCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTs7QUFFQSxlQUFlOztBQUVmO0FBQ0E7QUFDQTtBQUNBLElBQUk7OztBQUdKO0FBQ0E7O0FBRUEsZUFBZTs7QUFFZjtBQUNBO0FBQ0E7QUFDQTtBQUNBLDJFQUEyRSxlQUFlO0FBQzFGO0FBQ0E7O0FBRUE7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsZUFBZSIsInNvdXJjZXMiOlsid2VicGFjazovL25leHRqcy8uL25vZGVfbW9kdWxlcy9yZWNoYXJ0cy1zY2FsZS9saWIvdXRpbC91dGlscy5qcz8wZjczIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuXG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHtcbiAgdmFsdWU6IHRydWVcbn0pO1xuZXhwb3J0cy5tZW1vaXplID0gZXhwb3J0cy5yZXZlcnNlID0gZXhwb3J0cy5jb21wb3NlID0gZXhwb3J0cy5tYXAgPSBleHBvcnRzLnJhbmdlID0gZXhwb3J0cy5jdXJyeSA9IGV4cG9ydHMuUExBQ0VfSE9MREVSID0gdm9pZCAwO1xuXG5mdW5jdGlvbiBfdG9Db25zdW1hYmxlQXJyYXkoYXJyKSB7IHJldHVybiBfYXJyYXlXaXRob3V0SG9sZXMoYXJyKSB8fCBfaXRlcmFibGVUb0FycmF5KGFycikgfHwgX3Vuc3VwcG9ydGVkSXRlcmFibGVUb0FycmF5KGFycikgfHwgX25vbkl0ZXJhYmxlU3ByZWFkKCk7IH1cblxuZnVuY3Rpb24gX25vbkl0ZXJhYmxlU3ByZWFkKCkgeyB0aHJvdyBuZXcgVHlwZUVycm9yKFwiSW52YWxpZCBhdHRlbXB0IHRvIHNwcmVhZCBub24taXRlcmFibGUgaW5zdGFuY2UuXFxuSW4gb3JkZXIgdG8gYmUgaXRlcmFibGUsIG5vbi1hcnJheSBvYmplY3RzIG11c3QgaGF2ZSBhIFtTeW1ib2wuaXRlcmF0b3JdKCkgbWV0aG9kLlwiKTsgfVxuXG5mdW5jdGlvbiBfdW5zdXBwb3J0ZWRJdGVyYWJsZVRvQXJyYXkobywgbWluTGVuKSB7IGlmICghbykgcmV0dXJuOyBpZiAodHlwZW9mIG8gPT09IFwic3RyaW5nXCIpIHJldHVybiBfYXJyYXlMaWtlVG9BcnJheShvLCBtaW5MZW4pOyB2YXIgbiA9IE9iamVjdC5wcm90b3R5cGUudG9TdHJpbmcuY2FsbChvKS5zbGljZSg4LCAtMSk7IGlmIChuID09PSBcIk9iamVjdFwiICYmIG8uY29uc3RydWN0b3IpIG4gPSBvLmNvbnN0cnVjdG9yLm5hbWU7IGlmIChuID09PSBcIk1hcFwiIHx8IG4gPT09IFwiU2V0XCIpIHJldHVybiBBcnJheS5mcm9tKG8pOyBpZiAobiA9PT0gXCJBcmd1bWVudHNcIiB8fCAvXig/OlVpfEkpbnQoPzo4fDE2fDMyKSg/OkNsYW1wZWQpP0FycmF5JC8udGVzdChuKSkgcmV0dXJuIF9hcnJheUxpa2VUb0FycmF5KG8sIG1pbkxlbik7IH1cblxuZnVuY3Rpb24gX2l0ZXJhYmxlVG9BcnJheShpdGVyKSB7IGlmICh0eXBlb2YgU3ltYm9sICE9PSBcInVuZGVmaW5lZFwiICYmIFN5bWJvbC5pdGVyYXRvciBpbiBPYmplY3QoaXRlcikpIHJldHVybiBBcnJheS5mcm9tKGl0ZXIpOyB9XG5cbmZ1bmN0aW9uIF9hcnJheVdpdGhvdXRIb2xlcyhhcnIpIHsgaWYgKEFycmF5LmlzQXJyYXkoYXJyKSkgcmV0dXJuIF9hcnJheUxpa2VUb0FycmF5KGFycik7IH1cblxuZnVuY3Rpb24gX2FycmF5TGlrZVRvQXJyYXkoYXJyLCBsZW4pIHsgaWYgKGxlbiA9PSBudWxsIHx8IGxlbiA+IGFyci5sZW5ndGgpIGxlbiA9IGFyci5sZW5ndGg7IGZvciAodmFyIGkgPSAwLCBhcnIyID0gbmV3IEFycmF5KGxlbik7IGkgPCBsZW47IGkrKykgeyBhcnIyW2ldID0gYXJyW2ldOyB9IHJldHVybiBhcnIyOyB9XG5cbnZhciBpZGVudGl0eSA9IGZ1bmN0aW9uIGlkZW50aXR5KGkpIHtcbiAgcmV0dXJuIGk7XG59O1xuXG52YXIgUExBQ0VfSE9MREVSID0ge1xuICAnQEBmdW5jdGlvbmFsL3BsYWNlaG9sZGVyJzogdHJ1ZVxufTtcbmV4cG9ydHMuUExBQ0VfSE9MREVSID0gUExBQ0VfSE9MREVSO1xuXG52YXIgaXNQbGFjZUhvbGRlciA9IGZ1bmN0aW9uIGlzUGxhY2VIb2xkZXIodmFsKSB7XG4gIHJldHVybiB2YWwgPT09IFBMQUNFX0hPTERFUjtcbn07XG5cbnZhciBjdXJyeTAgPSBmdW5jdGlvbiBjdXJyeTAoZm4pIHtcbiAgcmV0dXJuIGZ1bmN0aW9uIF9jdXJyaWVkKCkge1xuICAgIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSAwIHx8IGFyZ3VtZW50cy5sZW5ndGggPT09IDEgJiYgaXNQbGFjZUhvbGRlcihhcmd1bWVudHMubGVuZ3RoIDw9IDAgPyB1bmRlZmluZWQgOiBhcmd1bWVudHNbMF0pKSB7XG4gICAgICByZXR1cm4gX2N1cnJpZWQ7XG4gICAgfVxuXG4gICAgcmV0dXJuIGZuLmFwcGx5KHZvaWQgMCwgYXJndW1lbnRzKTtcbiAgfTtcbn07XG5cbnZhciBjdXJyeU4gPSBmdW5jdGlvbiBjdXJyeU4obiwgZm4pIHtcbiAgaWYgKG4gPT09IDEpIHtcbiAgICByZXR1cm4gZm47XG4gIH1cblxuICByZXR1cm4gY3VycnkwKGZ1bmN0aW9uICgpIHtcbiAgICBmb3IgKHZhciBfbGVuID0gYXJndW1lbnRzLmxlbmd0aCwgYXJncyA9IG5ldyBBcnJheShfbGVuKSwgX2tleSA9IDA7IF9rZXkgPCBfbGVuOyBfa2V5KyspIHtcbiAgICAgIGFyZ3NbX2tleV0gPSBhcmd1bWVudHNbX2tleV07XG4gICAgfVxuXG4gICAgdmFyIGFyZ3NMZW5ndGggPSBhcmdzLmZpbHRlcihmdW5jdGlvbiAoYXJnKSB7XG4gICAgICByZXR1cm4gYXJnICE9PSBQTEFDRV9IT0xERVI7XG4gICAgfSkubGVuZ3RoO1xuXG4gICAgaWYgKGFyZ3NMZW5ndGggPj0gbikge1xuICAgICAgcmV0dXJuIGZuLmFwcGx5KHZvaWQgMCwgYXJncyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIGN1cnJ5TihuIC0gYXJnc0xlbmd0aCwgY3VycnkwKGZ1bmN0aW9uICgpIHtcbiAgICAgIGZvciAodmFyIF9sZW4yID0gYXJndW1lbnRzLmxlbmd0aCwgcmVzdEFyZ3MgPSBuZXcgQXJyYXkoX2xlbjIpLCBfa2V5MiA9IDA7IF9rZXkyIDwgX2xlbjI7IF9rZXkyKyspIHtcbiAgICAgICAgcmVzdEFyZ3NbX2tleTJdID0gYXJndW1lbnRzW19rZXkyXTtcbiAgICAgIH1cblxuICAgICAgdmFyIG5ld0FyZ3MgPSBhcmdzLm1hcChmdW5jdGlvbiAoYXJnKSB7XG4gICAgICAgIHJldHVybiBpc1BsYWNlSG9sZGVyKGFyZykgPyByZXN0QXJncy5zaGlmdCgpIDogYXJnO1xuICAgICAgfSk7XG4gICAgICByZXR1cm4gZm4uYXBwbHkodm9pZCAwLCBfdG9Db25zdW1hYmxlQXJyYXkobmV3QXJncykuY29uY2F0KHJlc3RBcmdzKSk7XG4gICAgfSkpO1xuICB9KTtcbn07XG5cbnZhciBjdXJyeSA9IGZ1bmN0aW9uIGN1cnJ5KGZuKSB7XG4gIHJldHVybiBjdXJyeU4oZm4ubGVuZ3RoLCBmbik7XG59O1xuXG5leHBvcnRzLmN1cnJ5ID0gY3Vycnk7XG5cbnZhciByYW5nZSA9IGZ1bmN0aW9uIHJhbmdlKGJlZ2luLCBlbmQpIHtcbiAgdmFyIGFyciA9IFtdO1xuXG4gIGZvciAodmFyIGkgPSBiZWdpbjsgaSA8IGVuZDsgKytpKSB7XG4gICAgYXJyW2kgLSBiZWdpbl0gPSBpO1xuICB9XG5cbiAgcmV0dXJuIGFycjtcbn07XG5cbmV4cG9ydHMucmFuZ2UgPSByYW5nZTtcbnZhciBtYXAgPSBjdXJyeShmdW5jdGlvbiAoZm4sIGFycikge1xuICBpZiAoQXJyYXkuaXNBcnJheShhcnIpKSB7XG4gICAgcmV0dXJuIGFyci5tYXAoZm4pO1xuICB9XG5cbiAgcmV0dXJuIE9iamVjdC5rZXlzKGFycikubWFwKGZ1bmN0aW9uIChrZXkpIHtcbiAgICByZXR1cm4gYXJyW2tleV07XG4gIH0pLm1hcChmbik7XG59KTtcbmV4cG9ydHMubWFwID0gbWFwO1xuXG52YXIgY29tcG9zZSA9IGZ1bmN0aW9uIGNvbXBvc2UoKSB7XG4gIGZvciAodmFyIF9sZW4zID0gYXJndW1lbnRzLmxlbmd0aCwgYXJncyA9IG5ldyBBcnJheShfbGVuMyksIF9rZXkzID0gMDsgX2tleTMgPCBfbGVuMzsgX2tleTMrKykge1xuICAgIGFyZ3NbX2tleTNdID0gYXJndW1lbnRzW19rZXkzXTtcbiAgfVxuXG4gIGlmICghYXJncy5sZW5ndGgpIHtcbiAgICByZXR1cm4gaWRlbnRpdHk7XG4gIH1cblxuICB2YXIgZm5zID0gYXJncy5yZXZlcnNlKCk7IC8vIGZpcnN0IGZ1bmN0aW9uIGNhbiByZWNlaXZlIG11bHRpcGx5IGFyZ3VtZW50c1xuXG4gIHZhciBmaXJzdEZuID0gZm5zWzBdO1xuICB2YXIgdGFpbHNGbiA9IGZucy5zbGljZSgxKTtcbiAgcmV0dXJuIGZ1bmN0aW9uICgpIHtcbiAgICByZXR1cm4gdGFpbHNGbi5yZWR1Y2UoZnVuY3Rpb24gKHJlcywgZm4pIHtcbiAgICAgIHJldHVybiBmbihyZXMpO1xuICAgIH0sIGZpcnN0Rm4uYXBwbHkodm9pZCAwLCBhcmd1bWVudHMpKTtcbiAgfTtcbn07XG5cbmV4cG9ydHMuY29tcG9zZSA9IGNvbXBvc2U7XG5cbnZhciByZXZlcnNlID0gZnVuY3Rpb24gcmV2ZXJzZShhcnIpIHtcbiAgaWYgKEFycmF5LmlzQXJyYXkoYXJyKSkge1xuICAgIHJldHVybiBhcnIucmV2ZXJzZSgpO1xuICB9IC8vIGNhbiBiZSBzdHJpbmdcblxuXG4gIHJldHVybiBhcnIuc3BsaXQoJycpLnJldmVyc2Uuam9pbignJyk7XG59O1xuXG5leHBvcnRzLnJldmVyc2UgPSByZXZlcnNlO1xuXG52YXIgbWVtb2l6ZSA9IGZ1bmN0aW9uIG1lbW9pemUoZm4pIHtcbiAgdmFyIGxhc3RBcmdzID0gbnVsbDtcbiAgdmFyIGxhc3RSZXN1bHQgPSBudWxsO1xuICByZXR1cm4gZnVuY3Rpb24gKCkge1xuICAgIGZvciAodmFyIF9sZW40ID0gYXJndW1lbnRzLmxlbmd0aCwgYXJncyA9IG5ldyBBcnJheShfbGVuNCksIF9rZXk0ID0gMDsgX2tleTQgPCBfbGVuNDsgX2tleTQrKykge1xuICAgICAgYXJnc1tfa2V5NF0gPSBhcmd1bWVudHNbX2tleTRdO1xuICAgIH1cblxuICAgIGlmIChsYXN0QXJncyAmJiBhcmdzLmV2ZXJ5KGZ1bmN0aW9uICh2YWwsIGkpIHtcbiAgICAgIHJldHVybiB2YWwgPT09IGxhc3RBcmdzW2ldO1xuICAgIH0pKSB7XG4gICAgICByZXR1cm4gbGFzdFJlc3VsdDtcbiAgICB9XG5cbiAgICBsYXN0QXJncyA9IGFyZ3M7XG4gICAgbGFzdFJlc3VsdCA9IGZuLmFwcGx5KHZvaWQgMCwgYXJncyk7XG4gICAgcmV0dXJuIGxhc3RSZXN1bHQ7XG4gIH07XG59O1xuXG5leHBvcnRzLm1lbW9pemUgPSBtZW1vaXplOyJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/recharts-scale/lib/util/utils.js\n");

/***/ })

};
;