import Image from 'next/image';
import Link from 'next/link';

export default function Meiwa5sSoonPage() {
  return (
    <main className="flex min-h-screen items-center justify-center bg-gray-50 px-6">
      <div className="max-w-xl text-center">
        <h1 className="text-3xl font-semibold text-gray-900">Meiwa 5S</h1>
        <p className="mt-4 text-lg text-gray-600">
          Esta página estará disponible próximamente.
        </p>
        <Link
          href="/meiwa-core"
          className="mt-8 inline-flex items-center justify-center gap-3 rounded-full bg-white px-6 py-3 text-sm font-semibold text-gray-900 shadow-md transition hover:-translate-y-0.5 hover:shadow-lg"
        >
          <Image
            src="/meiwa-core.png"
            alt="Logo Meiwa Core"
            width={32}
            height={32}
            className="h-8 w-8 object-contain"
          />
          Volver a Meiwa Core
        </Link>
      </div>
    </main>
  );
}