import Image from "next/image";
import Link from "next/link";
import { CalendarDays, FileText, Globe2, MapPin } from "lucide-react";
import { SGIDashboardLayout } from "@/components/dashboard/sgi-dashboard-layout";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";

const timeline = [
  {
    year: "1979",
    title: "Fundación en Japón (MMJ)",
    description:
      "Meiwa Mold inicia operaciones en Kawagoe-cho, Mie-gun, con moldes de acero para inyección de aluminio.",
  },
  {
    year: "1997",
    title: "Inicio en Tailandia (MMT)",
    description:
      "Se abre Meiwa Mold Thailand para operar moldes de acero para inyección de plástico.",
  },
  {
    year: "2002",
    title: "Meiwa Mold Indonesia (MMI)",
    description:
      "Se funda la operación en Indonesia y se obtiene la certificación ISO 14001.",
  },
  {
    year: "2011",
    title: "Meiwa Mold China (MMC)",
    description:
      "Se establece Meiwa Mold China (Changshu) para ampliar la presencia en Asia.",
  },
  {
    year: "2016",
    title: "Meiwa Mold México (MMX)",
    description:
      "Se inaugura la planta en México y un año después inicia producción local.",
  },
  {
    year: "2021",
    title: "Meiwa Mold International (MMIT)",
    description:
      "Se crea la oficina corporativa en Knoxville, Tennessee, USA.",
  },
];

const locations = [
  {
    country: "Japón",
    detail: "Mie · Planta",
    highlight: true,
  },
  {
    country: "China",
    detail: "Changshu · Planta",
    highlight: true,
  },
  {
    country: "Tailandia",
    detail: "Chonburi · Planta",
    highlight: true,
  },
  {
    country: "Indonesia",
    detail: "Bekasi · 2 plantas",
    highlight: true,
  },
  {
    country: "México",
    detail: "Aguascalientes · Planta",
    highlight: true,
  },
  {
    country: "Estados Unidos",
    detail: "Tennessee · Oficina",
    highlight: false,
  },
];

const contextCards = [
  {
    title: "Comprensión de la organización y de su contexto",
    description:
      "Análisis de cuestiones externas e internas que influyen en el desempeño ambiental de la organización.",
    href: "https://meiwamoldcom-my.sharepoint.com/:x:/g/personal/s-sasaki_meiwamold_com/IQDT4L5JbfadTrYrbW3b6uP0ARFAZ120vXGQDa34t0wF0bo?e=tPou4g",
  },
  {
    title: "Comprensión de las necesidades y expectativas de las partes interesadas",
    description:
      "Identificación de partes interesadas clave y sus expectativas frente al SGA.",
    href: "https://meiwamoldcom-my.sharepoint.com/:x:/g/personal/s-sasaki_meiwamold_com/IQBLQS-h8wCPTZlmOTYOjU3GAdkxzZRA2v8M35KUObykzO4?e=zD4b23",
  },
  {
    title: "Determinación del alcance del sistema de gestión ambiental",
    description:
      "Definición del alcance, límites y procesos cubiertos por el sistema de gestión ambiental.",
    href: "https://meiwamoldcom-my.sharepoint.com/:x:/g/personal/s-sasaki_meiwamold_com/IQCGw_ow_xCpT71Qnzl0Zy_eAU7vVK_k0vVzwyC-fS0d0mY?e=M6PAaH",
  },
  {
    title: "Mapa de procesos ambientales",
    description:
      "Visión global de los procesos ambientales y su interacción dentro del SGA.",
    href: "https://meiwamoldcom-my.sharepoint.com/:x:/g/personal/s-sasaki_meiwamold_com/IQBn-dXQIP2vS64S7Tjjr5zFATd-VhZsthjnEI9Jokmt33A?e=HhEMnm",
  },
];

export default function ContextPage() {
  return (
    <SGIDashboardLayout>
      <div className="min-h-screen space-y-12 bg-gradient-to-br from-slate-50 via-white to-emerald-50">
        <section className="relative overflow-hidden rounded-3xl border border-emerald-100 bg-white">
          <div className="absolute inset-0 bg-gradient-to-r from-emerald-500/10 to-sky-500/10" />
          <div className="relative px-6 py-12 sm:px-10">
            <p className="text-xs font-semibold uppercase tracking-[0.5em] text-emerald-600">
              MEIWA MOLD MEXICO
            </p>
            <h1 className="mt-4 text-3xl font-bold text-gray-900 sm:text-4xl">
              Contexto organizacional
            </h1>
            <p className="mt-4 max-w-8xl text-base text-gray-600 sm:text-lg">
              Meiwa Mold México es una empresa dedicada a la fabricación de moldes de acero para
              inyección de aluminio perteneciente a Meiwa Group que cuenta con instalaciones
              distribuidas en cuatro países de Asia y dos en América. Nos destacamos por nuestro
              conocimiento y capacidad técnica, brindando desde la concepción básica de los moldes
              hasta el análisis de soluciones especializadas para nuestros clientes.
            </p>

          </div>
        </section>

        <section className="space-y-6">
          <div className="flex items-center gap-3">
            <div className="flex h-10 w-10 items-center justify-center rounded-full bg-emerald-100 text-emerald-600">
              <Globe2 className="h-5 w-5" />
            </div>
            <div>
              <h2 className="text-2xl font-semibold text-gray-900">
                Presencia de MEIWA GROUP en el mundo
              </h2>
              <p className="text-gray-600">
                Distribución de plantas y oficina corporativa en Asia y América.
              </p>
            </div>
          </div>

          <div className="grid gap-6 lg:grid-cols-[1.4fr_1fr]">
            <Card className="overflow-hidden border-emerald-100">
              <CardContent className="p-0">
                <div className="relative aspect-[4/3] w-full">
                  <Image
                    src="/meiwa-sgi/context/world-map.png"
                    alt="Mapa de presencia de MEIWA GROUP en el mundo"
                    fill
                    className="object-cover"
                    priority
                  />
                </div>
              </CardContent>
            </Card>

            <Card className="border-gray-200">
              <CardHeader>
                <CardTitle className="text-lg">Sitios globales</CardTitle>
              </CardHeader>
              <CardContent className="space-y-4">
                {locations.map((location) => (
                  <div key={location.country} className="flex items-start gap-3">
                    <div
                      className={`mt-1 flex h-8 w-8 items-center justify-center rounded-full text-white ${
                        location.highlight ? "bg-emerald-500" : "bg-sky-500"
                      }`}
                    >
                      <MapPin className="h-4 w-4" />
                    </div>
                    <div>
                      <p className="text-sm font-semibold text-gray-900">{location.country}</p>
                      <p className="text-sm text-gray-500">{location.detail}</p>
                    </div>
                  </div>
                ))}
                <div className="rounded-2xl border border-emerald-100 bg-emerald-50 px-4 py-4">
                  <p className="text-xs font-semibold uppercase text-emerald-600">
                    Cobertura actual
                  </p>
                  <p className="mt-1 text-sm font-semibold text-emerald-900">
                    6 plantas manufactureras · 1 oficina corporativa
                  </p>
                </div>
              </CardContent>
            </Card>
          </div>
        </section>

        <section className="space-y-6">
          <div className="flex items-center gap-3">
            <div className="flex h-10 w-10 items-center justify-center rounded-full bg-emerald-100 text-emerald-600">
              <CalendarDays className="h-5 w-5" />
            </div>
            <div>
              <h2 className="text-2xl font-semibold text-gray-900">Historia</h2>
              <p className="text-gray-600">Línea de tiempo de hitos clave en la expansión global.</p>
            </div>
          </div>

          <div className="grid gap-4 lg:grid-cols-6">
            {timeline.map((item) => (
              <Card key={item.year} className="border-gray-200">
                <CardHeader className="space-y-2">
                  <span className="text-xs font-semibold uppercase tracking-[0.3em] text-emerald-600">
                    {item.year}
                  </span>
                  <CardTitle className="text-base">{item.title}</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-sm text-gray-600">{item.description}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </section>

        <section className="space-y-6">
          <div className="flex items-center gap-3">
            <div className="flex h-10 w-10 items-center justify-center rounded-full bg-emerald-100 text-emerald-600">
              <FileText className="h-5 w-5" />
            </div>
            <div>
              <h2 className="text-2xl font-semibold text-gray-900">Documentos clave MEIWA MOLD MEXICO</h2>
              <p className="text-gray-600">
                Acceso rápido a los archivos relacionados con el contexto del sistema de gestión
                ambiental.
              </p>
            </div>
          </div>

          <div className="grid gap-6 md:grid-cols-2">
            {contextCards.map((card) => (
              <Card key={card.title} className="border-gray-200">
                <CardHeader>
                  <CardTitle className="text-lg">{card.title}</CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <p className="text-sm text-gray-600">{card.description}</p>
                  <Button asChild variant="outline">
                    <Link href={card.href} target="_blank" rel="noreferrer">
                      Ver archivo
                    </Link>
                  </Button>
                </CardContent>
              </Card>
            ))}
          </div>
        </section>
      </div>
    </SGIDashboardLayout>
  );
}