"use client";

import { useEffect, useState } from "react";
import Link from "next/link";
import Image from "next/image";
import { useRouter } from "next/navigation";
import MeiwaTasksLogo from '@/app/meiwa-core/LOGO/LOGOMTMS.png';
import MeiwaSgiLogo from '@/app/meiwa-core/LOGO/LOGOMEIWASGI.png';
import Meiwa5sLogo from '@/app/meiwa-core/LOGO/LOGOMEIWA5S.png';
import MeiwaPointsLogo from "@/public/meiwa-points-logo.png";
import CoreLogoImage from "@/public/meiwa-core.png";
import { getClientPortalAuth, isMeiwaCorePortalAuth } from "@/app/client-portal-auth";

const options = [
  {
    title: "MEIWA TASKS",
    description: "Gestión de tareas y seguimiento diario.",
    href: "/meiwa-core/dashboard",
    accent: "from-blue-500 to-indigo-600",
    logo: {
      src: MeiwaTasksLogo,
      alt: "Logo Meiwa Tasks",
      className: "h-16 w-16",
    },
  },
  {
    title: "MEIWA SGI",
    description: "Sistema de gestión integral y procesos.",
    href: "/meiwa-core/meiwa-sgi",
    accent: "from-emerald-500 to-lime-600",
    logo: {
      src: MeiwaSgiLogo,
      alt: "Logo Meiwa SGI",
      className: "h-16 w-16",
    },
  },
  {
    title: "MEIWA 5S",
    description: "Orden, limpieza y disciplina para el entorno laboral.",
    href: "/meiwa-core/meiwa-5s",
    accent: "from-red-600 to-pink-500",
    logo: {
      src: Meiwa5sLogo,
      alt: "Logo Meiwa 5S",
      className: "h-16 w-16",
    },
  },
  {
    title: "MEIWA POINTS",
    description: "Puntos, recompensas y motivación para el equipo.",
    href: "/meiwa-core/meiwa-points",
    accent: "from-indigo-500 via-purple-500 to-pink-400",
    logo: {
      src: MeiwaPointsLogo,
      alt: "Logo Meiwa Points",
      className: "h-16 w-16",
    },
  },  
];

export default function SelectorPage() {
  const router = useRouter();
  const [portalAuthorized, setPortalAuthorized] = useState(false);

  useEffect(() => {
    const portalAuth = getClientPortalAuth();
    if (!isMeiwaCorePortalAuth(portalAuth)) {
      router.replace("/client-authlog");
      return;
    }
    setPortalAuthorized(true);
  }, [router]);

  if (!portalAuthorized) {
    return (
      <div className="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-50 to-indigo-100">
        <div className="animate-spin rounded-full h-32 w-32 border-b-2 border-blue-600"></div>
      </div>
    );
  }

  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50">
      <div className="relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-r from-blue-600 to-purple-600 opacity-10" />
        <div className="relative max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 pt-20 pb-16">
          <div className="text-center">
            <div className="flex flex-col items-center gap-6 mb-8">
              <Image
                src={CoreLogoImage}
                alt="Logo Meiwa Core"
                width={200}
                height={200}
                className="h-40 w-40 sm:h-52 sm:w-52 object-contain"
                priority
              />
              <p className="text-sm sm:text-base font-semibold tracking-[0.5em] text-gray-700">
                MEIWA CORE
              </p>
            </div>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Elige el sistema que deseas utilizar para continuar.
            </p>
          </div>
        </div>
      </div>

      <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 pb-20">
        <div className="space-y-6">
          {options.map((option) => (
            <Link
              key={option.title}
              href={option.href}
              className="group block"
              aria-label={`Ir a ${option.title}`}
            >
              <div className="flex flex-col sm:flex-row items-center gap-6 rounded-3xl bg-white/80 shadow-lg backdrop-blur-sm px-8 py-8 transition-all duration-300 group-hover:-translate-y-1 group-hover:shadow-2xl group-hover:bg-white">
                <div className="flex-shrink-0">
                  <div
                    className={`h-28 w-28 rounded-full bg-gradient-to-br ${option.accent} flex items-center justify-center shadow-lg`}
                  >
                    <div className="h-20 w-20 rounded-full bg-white flex items-center justify-center">
                      <Image
                        src={option.logo.src}
                        alt={option.logo.alt}
                        width={64}
                        height={64}
                        className={`${option.logo.className} object-contain`}
                      />
                    </div>
                  </div>
                </div>
                <div className="text-center sm:text-left flex-1">
                  <h2 className="text-3xl font-semibold text-gray-900">{option.title}</h2>
                  <p className="text-gray-600 mt-2 text-lg">{option.description}</p>
                </div>
                <div className="text-sm font-semibold uppercase tracking-widest px-4 py-2 rounded-full bg-gray-100 text-gray-700 transition-colors duration-300 group-hover:bg-gray-900 group-hover:text-white">
                  Entrar
                </div>
              </div>
            </Link>
          ))}
        </div>
      </div>

      <footer className="bg-gray-900 text-white py-12">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <div className="flex items-center justify-center mb-4">
              <Image
                src={CoreLogoImage}
                alt="Meiwa Core logo"
                width={36}
                height={36}
                className="h-9 w-9 object-contain mr-2"
              />
              <span className="text-2xl font-bold">MEIWA CORE</span>
            </div>
            <p className="text-gray-400 mb-4">MEIWAMOLD MEXICO S.A. DE C.V.</p>
            <p className="text-gray-500 text-sm">
              2026 © MEIWA CORE | TODOS LOS DERECHOS RESERVADOS
            </p>
          </div>
        </div>
      </footer>
    </div>
  );
}