import Image from 'next/image';
import Link from 'next/link';

export default function HomePage() {
  return (
    <div className="min-h-screen bg-gradient-to-b from-yellow-50 via-gray-100 to-gray-200 text-gray-900">
      <header className="px-6 py-10">
        <div className="mx-auto flex max-w-6xl flex-col items-center gap-6 text-center">
          <div className="rounded-3xl bg-black/90 p-6 shadow-xl">
            <Image
              src="/SEKNUM-logo2.png"
              alt="SEKNUM"
              width={220}
              height={220}
              priority
              className="h-40 w-40 object-contain sm:h-48 sm:w-48"
            />
          </div>
          <div className="space-y-4">
            <p className="text-sm font-semibold uppercase tracking-[0.3em] text-gray-500">
              SEKNUM
            </p>
            <h1 className="text-4xl font-bold text-gray-900 sm:text-5xl">
              Conecta, analiza y avanza con SEKNUM
            </h1>
            <p className="mx-auto max-w-2xl text-base text-gray-600 sm:text-lg">
              Centraliza tus procesos con información clara, accesos seguros y una experiencia personalizada
              enfocada en resultados.
            </p>
          </div>
          <div className="flex flex-col items-center gap-4 sm:flex-row">
            <Link
              href="/client-authlog"
              className="inline-flex items-center justify-center rounded-full bg-yellow-400 px-8 py-3 text-base font-semibold text-black shadow-lg transition hover:bg-yellow-300"
            >
              Acceso a la plataforma
            </Link>
            <span className="text-sm text-gray-500">
              Accede a tu panel con tu cuenta autorizada.
            </span>
          </div>
        </div>
      </header>

      <section className="mx-auto flex max-w-6xl flex-col gap-6 px-6 pb-16 sm:flex-row">
        <div className="flex-1 rounded-2xl border border-gray-200 bg-white/80 p-6 shadow-sm">
          <h2 className="text-xl font-semibold text-gray-900">Visibilidad total</h2>
          <p className="mt-2 text-sm text-gray-600">
            Mantén el control con indicadores claros, dashboards ágiles y seguimiento continuo.
          </p>
        </div>
        <div className="flex-1 rounded-2xl border border-gray-200 bg-white/80 p-6 shadow-sm">
          <h2 className="text-xl font-semibold text-gray-900">Colaboración segura</h2>
          <p className="mt-2 text-sm text-gray-600">
            Espacios confiables para equipos que necesitan compartir datos críticos.
          </p>
        </div>
        <div className="flex-1 rounded-2xl border border-gray-200 bg-white/80 p-6 shadow-sm">
          <h2 className="text-xl font-semibold text-gray-900">Automatización inteligente</h2>
          <p className="mt-2 text-sm text-gray-600">
            Reduce tiempos con flujos optimizados y alertas configurables.
          </p>
        </div>
      </section>

      <footer className="mt-auto border-t border-gray-300 bg-black text-gray-200">
        <div className="mx-auto flex max-w-6xl flex-col items-center justify-between gap-4 px-6 py-8 sm:flex-row">
          <div className="flex items-center gap-3">
            <div className="rounded-full bg-black-400 p-2">
              <Image
                src="/SEKNUM-logo2.png"
                alt="SEKNUM"
                width={40}
                height={40}
                className="h-8 w-8 object-contain"
              />
            </div>
            <div>
              <p className="text-sm font-semibold text-white">SEKNUM</p>
              <p className="text-xs text-gray-400">Soluciones integrales para equipos modernos.</p>
            </div>
          </div>
          <p className="text-xs text-gray-400">© 2026 SEKNUM. Todos los derechos reservados.</p>
        </div>
      </footer>
    </div>
  );
}