"use client";

import { useState } from 'react';
import { useRouter } from 'next/navigation';
import Image from 'next/image';
import { supabase } from '@/lib/supabase';
import { Button } from '@/components/ui/button';
import { Sheet, SheetContent, SheetTrigger } from '@/components/ui/sheet';
import {
  LogOut,
  Menu,
  User,
} from 'lucide-react';
import { toast } from 'sonner';
import MeiwaSgiLogo from '@/app/meiwa-core/LOGO/LOGOMEIWASGI.png';
import CoreLogoImage from '@/public/meiwa-core.png';
import { sgiNavigation } from '@/lib/sgi-navigation';

export function SGIDashboardLayout({ children }: { children: React.ReactNode }) {
  const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false);
  const router = useRouter();

  const handleLogout = async () => {
    await supabase.auth.signOut();
    toast.success('Sesión cerrada correctamente');
    router.push('/');
  };

  const navItems = sgiNavigation;

  const Sidebar = () => (
    <div className="flex flex-col h-full">
      <div className="flex items-center gap-2 p-6 border-b">
        <div className="p-2 bg-white-600 rounded-lg">
          <Image 
            src={MeiwaSgiLogo} 
            alt="Meiwa Task Management System logo" 
            width={250} 
            height={250}
            priority            
            className="h-30 w-50 object-contain"
          />
        </div>
        <span className="text-xl font-bold text-gray-900">MEIWA SGI</span>
      </div>

      <div className="px-6 pb-4">
        <Button
          variant="outline"
          className="w-full center-start gap-3"
          onClick={() => router.push('/meiwa-core/selector')}
        >
          <Image
            src={CoreLogoImage}
            alt="Meiwa Core logo"
            width={24}
            height={24}
            className="h-6 w-6 object-contain"
          />
          MEIWA CORE
        </Button>
      </div>
          <nav className="flex-1 p-4">
            <ul className="space-y-2">
              {navItems.map((item) => (
                <li key={item.name}>
                  <button
                    type="button"
                    onClick={() => router.push(item.href)}
                    className="flex w-full items-center gap-3 px-3 py-2 rounded-md text-gray-700 hover:text-blue-600 hover:bg-blue-50 transition-colors text-left"
                  >
                    <item.icon className="h-5 w-5" />
                    {item.name}
                  </button>
                </li>
              ))}
            </ul>
          </nav>
      
      <div className="p-4 border-t">
        <div className="space-y-2">
          <Button 
            variant="ghost" 
            className="w-full justify-start gap-3"
            onClick={() => router.push('/meiwa-core/meiwa-sgi/profile')}
          >
            <User className="h-5 w-5" />
            Perfil
          </Button>
          <Button 
            variant="ghost" 
            className="w-full justify-start gap-3 text-red-600 hover:text-red-700 hover:bg-red-50"
            onClick={handleLogout}
          >
            <LogOut className="h-5 w-5" />
            Cerrar Sesión
          </Button>
        </div>
      </div>
    </div>
  );

  return (
    <div className="flex h-screen bg-gray-50">
      {/* Desktop Sidebar */}
      <div className="hidden md:flex w-64 bg-white shadow-sm">
        <Sidebar />
      </div>

      {/* Mobile Menu */}
      <Sheet open={isMobileMenuOpen} onOpenChange={setIsMobileMenuOpen}>
        <SheetTrigger asChild>
          <Button 
            variant="ghost" 
            size="icon"
            className="md:hidden fixed top-4 left-4 z-50"
          >
            <Menu className="h-6 w-6" />
          </Button>
        </SheetTrigger>
        <SheetContent side="left" className="w-64 p-0">
          <Sidebar />
        </SheetContent>
      </Sheet>

      {/* Main Content */}
      <div className="flex-1 flex flex-col overflow-hidden">
        <main className="flex-1 overflow-auto p-6">
          {children}
        </main>
      </div>
    </div>
  );
}