import { createClient } from '@supabase/supabase-js';

const supabaseUrl = process.env.NEXT_PUBLIC_SUPABASE_URL ?? 'https://sairwwvgqgjmcfdsfchv.supabase.co';
const supabaseAnonKey = process.env.NEXT_PUBLIC_SUPABASE_ANON_KEY ?? 'sb_publishable_18ytFKk-TNO2hqoTIUipjg_6wmqRCO4';

export const supabase = createClient(supabaseUrl, supabaseAnonKey);

export type Database = {
  public: {
    Tables: {
      tasks: {
        Row: {
          id: string;
          title: string;
          description: string | null;
          completed: boolean;
          priority: 'low' | 'medium' | 'high';
          link_url: string | null;          
          due_date: string | null;
          recurrence_pattern: string | null;
          recurrence_interval: number | null;
          recurrence_end_date: string | null;
          parent_task_id: string | null;          
          created_at: string;
          updated_at: string;
          user_id: string;
        };
        Insert: {
          id?: string;
          title: string;
          description?: string | null;
          completed?: boolean;
          priority?: 'low' | 'medium' | 'high';
          link_url?: string | null;          
          due_date?: string | null;
          recurrence_pattern?: string | null;
          recurrence_interval?: number | null;
          recurrence_end_date?: string | null;
          parent_task_id?: string | null;          
          created_at?: string;
          updated_at?: string;
          user_id: string;
        };
        Update: {
          id?: string;
          title?: string;
          description?: string | null;
          completed?: boolean;
          priority?: 'low' | 'medium' | 'high';

          link_url?: string | null;          
          due_date?: string | null;
          recurrence_pattern?: string | null;
          recurrence_interval?: number | null;
          recurrence_end_date?: string | null;
          parent_task_id?: string | null;          
          created_at?: string;
          updated_at?: string;
          user_id?: string;
        };
      };
      profiles: {
        Row: {
          id: string;
          full_name: string | null;
          email: string | null;
          avatar_url: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id: string;
          full_name?: string | null;
          email?: string | null;
          avatar_url?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          full_name?: string | null;
          email?: string | null;
          avatar_url?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      mp_rewards: {
        Row: {
          id: string;
          name: string;
          description: string | null;
          points_value: number;
          stock_available: number;
          image_url: string | null;
          storage_path: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          name: string;
          description?: string | null;
          points_value: number;
          stock_available?: number;
          image_url?: string | null;
          storage_path?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          name?: string;
          description?: string | null;
          points_value?: number;
          stock_available?: number;
          image_url?: string | null;
          storage_path?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      mp_user_status: {
        Row: {
          id: string;
          user_id: string;
          status: string;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          user_id: string;
          status?: string;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          user_id?: string;
          status?: string;
          created_at?: string;
          updated_at?: string;
        };
      };
      mp_activities: {
        Row: {
          id: string;
          date: string | null;
          name: string;
          description: string | null;
          points_value: number;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          date?: string | null;
          name: string;
          description?: string | null;
          points_value: number;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          date?: string | null;
          name?: string;
          description?: string | null;
          points_value?: number;
          created_at?: string;
          updated_at?: string;
        };
      };
      mp_allocations: {
        Row: {
          id: string;
          user_id: string;
          activity_id: string;
          points: number;
          assigned_at: string;
          assigned_by: string | null;
          comment: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          user_id: string;
          activity_id: string;
          points: number;
          assigned_at?: string;
          assigned_by?: string | null;
          comment?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          user_id?: string;
          activity_id?: string;
          points?: number;
          assigned_at?: string;
          assigned_by?: string | null;
          comment?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      mp_redemptions: {
        Row: {
          id: string;
          user_id: string;
          reward_id: string;
          points: number;
          stock_before: number;
          stock_after: number;
          status: string;
          requested_at: string;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          user_id: string;
          reward_id: string;
          points: number;
          stock_before: number;
          stock_after: number;
          status?: string;
          requested_at?: string;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          user_id?: string;
          reward_id?: string;
          points?: number;
          stock_before?: number;
          stock_after?: number;
          status?: string;
          requested_at?: string;
          created_at?: string;
          updated_at?: string;
        };
      };      
      competence_results: {
        Row: {
          id: string;
          user_id: string;
          department: string | null;
          position: string | null;
          env_score: number | null;
          quality_score: number | null;
          safety_score: number | null;
          s5_score: number | null;
          incidents_score: number | null;
          productivity_score: number | null;
          general_eval_score: number | null;
          kpi_training_score: number | null;
          overall_score: number | null;
          period: string | null;
          evaluation_date: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          user_id: string;
          department?: string | null;
          position?: string | null;
          env_score?: number | null;
          quality_score?: number | null;
          safety_score?: number | null;
          s5_score?: number | null;
          incidents_score?: number | null;
          productivity_score?: number | null;
          general_eval_score?: number | null;
          kpi_training_score?: number | null;
          overall_score?: number | null;
          period?: string | null;
          evaluation_date?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          user_id?: string;
          department?: string | null;
          position?: string | null;
          env_score?: number | null;
          quality_score?: number | null;
          safety_score?: number | null;
          s5_score?: number | null;
          incidents_score?: number | null;
          productivity_score?: number | null;
          general_eval_score?: number | null;
          kpi_training_score?: number | null;
          overall_score?: number | null;
          period?: string | null;
          evaluation_date?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      sgi_pages: {
        Row: {
          id: string;
          name: string;
          path: string;
          created_at: string;
        };
        Insert: {
          id?: string;
          name: string;
          path: string;
          created_at?: string;
        };
        Update: {
          id?: string;
          name?: string;
          path?: string;
          created_at?: string;
        };
      };
      sgi_admin_permissions: {
        Row: {
          id: string;
          user_id: string;
          page_id: string;
          created_at: string;
        };
        Insert: {
          id?: string;
          user_id: string;
          page_id: string;
          created_at?: string;
        };
        Update: {
          id?: string;
          user_id?: string;
          page_id?: string;
          created_at?: string;
        };
      };
      client_portals: {
        Row: {
          id: string;
          client_name: string;
          description: string | null;
          plan: string;
          client_code: string;
          home_page: string;
          is_active: boolean | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          client_name: string;
          description?: string | null;
          plan: string;
          client_code: string;
          home_page: string;
          is_active?: boolean | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          client_name?: string;
          description?: string | null;
          plan?: string;
          client_code?: string;
          home_page?: string;
          is_active?: boolean | null;
          created_at?: string;
          updated_at?: string;
        };
      };      
      lifecycle_matrix: {
        Row: {
          id: string;
          lifecycle_phase: string;
          process_type: 'internal' | 'external';
          main_inputs: string | null;
          main_outputs: string | null;
          influence_control: 'influence' | 'control';
          order_index: number | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          lifecycle_phase: string;
          process_type: 'internal' | 'external';
          main_inputs?: string | null;
          main_outputs?: string | null;
          influence_control: 'influence' | 'control';
          order_index?: number | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          lifecycle_phase?: string;
          process_type?: 'internal' | 'external';
          main_inputs?: string | null;
          main_outputs?: string | null;
          influence_control?: 'influence' | 'control';
          order_index?: number | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      environmental_aspects: {
        Row: {
          id: string;
          aspect: string;
          element: string | null;
          process_activity: string | null;
          impact_normal: string | null;
          impact_abnormal: string | null;
          impact_emergency: string | null;
          operational_control: string | null;
          control_responsible_area: string | null;
          emergency_plan_link: string | null;
          technical_instructions_link: string | null;
          magnitude_m: number | null;
          control_influence_fci: number | null;
          legal_requirement_rl: number | null;
          frequency_f: number | null;
          extension_e: number | null;
          expected_value_ve: number | null;
          is_significant: boolean | null;
          created_by: string | null;
          updated_by: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          aspect: string;
          element?: string | null;
          process_activity?: string | null;
          impact_normal?: string | null;
          impact_abnormal?: string | null;
          impact_emergency?: string | null;
          operational_control?: string | null;
          control_responsible_area?: string | null;
          emergency_plan_link?: string | null;
          technical_instructions_link?: string | null;
          magnitude_m?: number | null;
          control_influence_fci?: number | null;
          legal_requirement_rl?: number | null;
          frequency_f?: number | null;
          extension_e?: number | null;
          expected_value_ve?: number | null;
          is_significant?: boolean | null;
          created_by?: string | null;
          updated_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          aspect?: string;
          element?: string | null;
          process_activity?: string | null;
          impact_normal?: string | null;
          impact_abnormal?: string | null;
          impact_emergency?: string | null;
          operational_control?: string | null;
          control_responsible_area?: string | null;
          emergency_plan_link?: string | null;
          technical_instructions_link?: string | null;
          magnitude_m?: number | null;
          control_influence_fci?: number | null;
          legal_requirement_rl?: number | null;
          frequency_f?: number | null;
          extension_e?: number | null;
          expected_value_ve?: number | null;
          is_significant?: boolean | null;
          created_by?: string | null;
          updated_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      aspect_lifecycle_links: {
        Row: {
          id: string;
          aspect_id: string;
          lifecycle_id: string;
          created_at: string;
        };
        Insert: {
          id?: string;
          aspect_id: string;
          lifecycle_id: string;
          created_at?: string;
        };
        Update: {
          id?: string;
          aspect_id?: string;
          lifecycle_id?: string;
          created_at?: string;
        };
      };
      sgm_processes: {
        Row: {
          id: string;
          process_name: string;
          is_active: boolean | null;
          created_at: string;
          updated_at: string | null;
        };
        Insert: {
          id?: string;
          process_name: string;
          is_active?: boolean | null;
          created_at?: string;
          updated_at?: string | null;
        };
        Update: {
          id?: string;
          process_name?: string;
          is_active?: boolean | null;
          created_at?: string;
          updated_at?: string | null;
        };
      };
      sgm_resources: {
        Row: {
          id: string;
          category: string | null;
          resource_type: 'human' | 'financial' | 'technical' | 'organizational';
          resource_name: string;
          management_system_use: string;
          process_activity: string | null;
          responsible: string | null;
          evidence_url: string | null;
          evidence_path: string | null;
          status: 'current' | 'improving' | 'implementing' | 'to_update';
          is_critical: boolean | null;
          linked_to_legal: boolean | null;
          created_at: string;
          updated_at: string | null;
          created_by: string | null;
          updated_by: string | null;
        };
        Insert: {
          id?: string;
          category?: string | null;
          resource_type: 'human' | 'financial' | 'technical' | 'organizational';
          resource_name: string;
          management_system_use: string;
          process_activity?: string | null;
          responsible?: string | null;
          evidence_url?: string | null;
          evidence_path?: string | null;
          status: 'current' | 'improving' | 'implementing' | 'to_update';
          is_critical?: boolean | null;
          linked_to_legal?: boolean | null;
          created_at?: string;
          updated_at?: string | null;
          created_by?: string | null;
          updated_by?: string | null;
        };
        Update: {
          id?: string;
          category?: string | null;
          resource_type?: 'human' | 'financial' | 'technical' | 'organizational';
          resource_name?: string;
          management_system_use?: string;
          process_activity?: string | null;
          responsible?: string | null;
          evidence_url?: string | null;
          evidence_path?: string | null;
          status?: 'current' | 'improving' | 'implementing' | 'to_update';
          is_critical?: boolean | null;
          linked_to_legal?: boolean | null;
          created_at?: string;
          updated_at?: string | null;
          created_by?: string | null;
          updated_by?: string | null;
        };
      };
      communication_matrix: {
        Row: {
          id: string;
          category: string;
          communication_type: string;
          what_to_communicate: string;
          when_to_communicate: string;
          who_to_communicate: string;
          how_to_communicate: string;
          who_communicates: string;
          followup_responsible: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          category: string;
          communication_type: string;
          what_to_communicate: string;
          when_to_communicate: string;
          who_to_communicate: string;
          how_to_communicate: string;
          who_communicates: string;
          followup_responsible?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          category?: string;
          communication_type?: string;
          what_to_communicate?: string;
          when_to_communicate?: string;
          who_to_communicate?: string;
          how_to_communicate?: string;
          who_communicates?: string;
          followup_responsible?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      communications_posts: {
        Row: {
          id: string;
          title: string;
          category: string;
          summary: string | null;
          content: string | null;
          publish_date: string | null;
          status: 'draft' | 'published' | 'archived';
          created_by: string | null;
          created_at: string;
          updated_at: string;
          valid_from: string | null;
          valid_to: string | null;
        };
        Insert: {
          id?: string;
          title: string;
          category: string;
          summary?: string | null;
          content?: string | null;
          publish_date?: string | null;
          status?: 'draft' | 'published' | 'archived';
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
          valid_from?: string | null;
          valid_to?: string | null;
        };
        Update: {
          id?: string;
          title?: string;
          category?: string;
          summary?: string | null;
          content?: string | null;
          publish_date?: string | null;
          status?: 'draft' | 'published' | 'archived';
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
          valid_from?: string | null;
          valid_to?: string | null;
        };
      };
      communications_attachments: {
        Row: {
          id: string;
          post_id: string;
          file_name: string;
          file_path: string;
          file_type: string | null;
          uploaded_at: string;
        };
        Insert: {
          id?: string;
          post_id: string;
          file_name: string;
          file_path: string;
          file_type?: string | null;
          uploaded_at?: string;
        };
        Update: {
          id?: string;
          post_id?: string;
          file_name?: string;
          file_path?: string;
          file_type?: string | null;
          uploaded_at?: string;
        };
      };
      communication_incidents: {
        Row: {
          id: string;
          created_at: string;
          created_by: string | null;
          source_type: string;
          source_other_detail: string | null;
          stakeholder: string;
          classification: 'complaint' | 'suggestion' | 'report' | 'other';
          description: string;
          evidence_url: string | null;
          action_plan: string | null;
          plan_owner: string | null;
          target_date: string | null;
          start_date: string | null;
          close_date: string | null;
          result: string | null;
          confirmation_date: string | null;
          status: 'unassigned' | 'planned' | 'in_progress' | 'completed' | 'confirmed' | 'overdue' | null;
          updated_at: string;
          updated_by: string | null;
        };
        Insert: {
          id?: string;
          created_at?: string;
          created_by?: string | null;
          source_type: string;
          source_other_detail?: string | null;
          stakeholder: string;
          classification: 'complaint' | 'suggestion' | 'report' | 'other';
          description: string;
          evidence_url?: string | null;
          action_plan?: string | null;
          plan_owner?: string | null;
          target_date?: string | null;
          start_date?: string | null;
          close_date?: string | null;
          result?: string | null;
          confirmation_date?: string | null;
          status?: 'unassigned' | 'planned' | 'in_progress' | 'completed' | 'confirmed' | 'overdue' | null;
          updated_at?: string;
          updated_by?: string | null;
        };
        Update: {
          id?: string;
          created_at?: string;
          created_by?: string | null;
          source_type?: string;
          source_other_detail?: string | null;
          stakeholder?: string;
          classification?: 'complaint' | 'suggestion' | 'report' | 'other';
          description?: string;
          evidence_url?: string | null;
          action_plan?: string | null;
          plan_owner?: string | null;
          target_date?: string | null;
          start_date?: string | null;
          close_date?: string | null;
          result?: string | null;
          confirmation_date?: string | null;
          status?: 'unassigned' | 'planned' | 'in_progress' | 'completed' | 'confirmed' | 'overdue' | null;
          updated_at?: string;
          updated_by?: string | null;
        };
      };
      document_control: {
        Row: {
          id: string;
          category: string | null;
          concept: string;
          doc_type: string;
          department: string;
          classification: string;
          sequence_by_type: number;
          last_revision_number: number | null;
          doc_code: string;
          doc_name: string;
          responsible: string | null;
          doc_link: string | null;
          target_date: string | null;
          start_date: string | null;
          issue_date: string | null;
          status: string | null;
          last_review_date: string | null;
          last_change_summary: string | null;
          created_at: string;
          updated_at: string | null;
          created_by: string | null;
          updated_by: string | null;
        };
        Insert: {
          id?: string;
          category?: string | null;
          concept: string;
          doc_type: string;
          department: string;
          classification: string;
          sequence_by_type: number;
          last_revision_number?: number | null;
          doc_code: string;
          doc_name: string;
          responsible?: string | null;
          doc_link?: string | null;
          target_date?: string | null;
          start_date?: string | null;
          issue_date?: string | null;
          status?: string | null;
          last_review_date?: string | null;
          last_change_summary?: string | null;
          created_at?: string;
          updated_at?: string | null;
          created_by?: string | null;
          updated_by?: string | null;
        };
        Update: {
          id?: string;
          category?: string | null;
          concept?: string;
          doc_type?: string;
          department?: string;
          classification?: string;
          sequence_by_type?: number;
          last_revision_number?: number | null;
          doc_code?: string;
          doc_name?: string;
          responsible?: string | null;
          doc_link?: string | null;
          target_date?: string | null;
          start_date?: string | null;
          issue_date?: string | null;
          status?: string | null;
          last_review_date?: string | null;
          last_change_summary?: string | null;
          created_at?: string;
          updated_at?: string | null;
          created_by?: string | null;
          updated_by?: string | null;
        };
      };
      document_control_revisions: {
        Row: {
          id: string;
          document_id: string;
          revision_number: number;
          revision_date: string;
          change_summary: string;
          created_at: string;
          created_by: string | null;
        };
        Insert: {
          id?: string;
          document_id: string;
          revision_number: number;
          revision_date: string;
          change_summary: string;
          created_at?: string;
          created_by?: string | null;
        };
        Update: {
          id?: string;
          document_id?: string;
          revision_number?: number;
          revision_date?: string;
          change_summary?: string;
          created_at?: string;
          created_by?: string | null;
        };
      };
      awareness_modules: {
        Row: {
          id: string;
          title: string;
          description: string | null;
          category: string;
          points_available: number;
          pass_score: number | null;          
          order_index: number | null;
          is_active: boolean | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          title: string;
          description?: string | null;
          category: string;
          points_available: number;
          pass_score?: number | null;          
          order_index?: number | null;
          is_active?: boolean | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          title?: string;
          description?: string | null;
          category?: string;
          points_available?: number;
          pass_score?: number | null;          
          order_index?: number | null;
          is_active?: boolean | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      awareness_lessons: {
        Row: {
          id: string;
          module_id: string;
          title: string;
          content_blocks: unknown;
          order_index: number | null;
          is_active: boolean | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          module_id: string;
          title: string;          
          content_blocks?: unknown;
          order_index?: number | null;
          is_active?: boolean | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          module_id?: string;
          title?: string;
          content_blocks?: unknown;
          order_index?: number | null;
          is_active?: boolean | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      awareness_quizzes: {
        Row: {
          id: string;
          module_id: string;
          quiz_json: unknown;
          max_score: number;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          module_id: string;
          quiz_json: unknown;
          max_score?: number;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          module_id?: string;
          quiz_json?: unknown;
          max_score?: number;          
          created_at?: string;
          updated_at?: string;
        };
      };
      awareness_user_module_progress: {
        Row: {
          id: string;
          user_id: string;
          module_id: string;
          status: "not_started" | "in_progress" | "completed";
          start_date: string | null;
          end_date: string | null;
          progress_percent: number | null;
          final_score: number | null;
          attempts_count: number | null;
          points_obtained: number | null;
          last_updated_at: string | null;
          created_at: string | null;
        };
        Insert: {
          id?: string;
          user_id: string;
          module_id: string;
          status: "not_started" | "in_progress" | "completed";
          start_date?: string | null;
          end_date?: string | null;
          progress_percent?: number | null;
          final_score?: number | null;
          attempts_count?: number | null;
          points_obtained?: number | null;
          last_updated_at?: string | null;
          created_at?: string | null;
        };
        Update: {
          id?: string;
          user_id?: string;
          module_id?: string;
          status?: "not_started" | "in_progress" | "completed";
          start_date?: string | null;
          end_date?: string | null;
          progress_percent?: number | null;
          final_score?: number | null;
          attempts_count?: number | null;
          points_obtained?: number | null;
          last_updated_at?: string | null;
          created_at?: string | null;
        };
      };
      awareness_user_lesson_views: {
        Row: {
          id: string;
          user_id: string;
          lesson_id: string;
          viewed_at: string | null;
          created_at: string | null;
        };
        Insert: {
          id?: string;
          user_id: string;
          lesson_id: string;
          viewed_at?: string | null;
          created_at?: string | null;
        };
        Update: {
          id?: string;
          user_id?: string;
          lesson_id?: string;
          viewed_at?: string | null;
          created_at?: string | null;
        };
      };
      env_risk_opportunities: {
        Row: {
          id: string;
          type: "risk" | "opportunity";
          title: string;
          description: string | null;
          source: "aspect" | "legal" | "4_1" | "4_2" | "emergency";
          environmental_aspect: string | null;
          linked_to_legal: boolean | null;
          current_controls: string;
          p_initial: number | null;
          i_initial: number | null;
          action_plan: string | null;
          action_owner: string | null;
          commitment_date: string | null;
          action_status: "open" | "in_progress" | "closed" | null;
          closure_date: string | null;
          evidence_urls: string | null;
          p_residual: number | null;
          i_residual: number | null;
          last_updated_at: string | null;
          next_review_date: string | null;
          created_at: string;
        };
        Insert: {
          id?: string;
          type: "risk" | "opportunity";
          title: string;
          description?: string | null;
          source: "aspect" | "legal" | "4_1" | "4_2" | "emergency";
          environmental_aspect?: string | null;
          linked_to_legal?: boolean | null;
          current_controls: string;
          p_initial?: number | null;
          i_initial?: number | null;
          action_plan?: string | null;
          action_owner?: string | null;
          commitment_date?: string | null;
          action_status?: "open" | "in_progress" | "closed" | null;
          closure_date?: string | null;
          evidence_urls?: string | null;
          p_residual?: number | null;
          i_residual?: number | null;
          last_updated_at?: string | null;
          next_review_date?: string | null;
          created_at?: string;
        };
        Update: {
          id?: string;
          type?: "risk" | "opportunity";
          title?: string;
          description?: string | null;
          source?: "aspect" | "legal" | "4_1" | "4_2" | "emergency";
          environmental_aspect?: string | null;
          linked_to_legal?: boolean | null;
          current_controls?: string;
          p_initial?: number | null;
          i_initial?: number | null;
          action_plan?: string | null;
          action_owner?: string | null;
          commitment_date?: string | null;
          action_status?: "open" | "in_progress" | "closed" | null;
          closure_date?: string | null;
          evidence_urls?: string | null;
          p_residual?: number | null;
          i_residual?: number | null;
          last_updated_at?: string | null;
          next_review_date?: string | null;
          created_at?: string;
        };
      };
      internal_audit_sessions: {
        Row: {
          id: string;
          user_id: string;
          audit_date: string;
          auditors: string[];
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          user_id: string;
          audit_date?: string;
          auditors?: string[];
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          user_id?: string;
          audit_date?: string;
          auditors?: string[];
          created_at?: string;
          updated_at?: string;
        };
      };
      internal_audit_responses: {
        Row: {
          id: string;
          session_id: string;
          section_id: string;
          group_title: string;
          question: string;
          response: string;
          classification: string;
          comment: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          session_id: string;
          section_id: string;
          group_title: string;
          question: string;
          response: string;
          classification: string;
          comment?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          session_id?: string;
          section_id?: string;
          group_title?: string;
          question?: string;
          response?: string;
          classification?: string;
          comment?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      nc_corrective_actions: {
        Row: {
          id: string;
          source: "audit" | "manual";
          audit_session_id: string | null;
          audit_response_id: string | null;
          created_at: string;
          category: string | null;
          auditors: string | null;
          question: string | null;
          answer: string | null;
          classification: string | null;
          comments: string | null;
          root_cause_analysis: string | null;
          action_plan: string | null;
          implementation_owner: string | null;
          target_implementation_date: string | null;
          start_date: string | null;
          end_date: string | null;
          evidence_url: string | null;
          result: string | null;
          result_comment: string | null;
          review_date: string | null;
          status: string | null;
          updated_at: string | null;
          updated_by: string | null;
        };
        Insert: {
          id?: string;
          source?: "audit" | "manual";
          audit_session_id?: string | null;
          audit_response_id?: string | null;
          created_at?: string;
          category?: string | null;
          auditors?: string | null;
          question?: string | null;
          answer?: string | null;
          classification?: string | null;
          comments?: string | null;
          root_cause_analysis?: string | null;
          action_plan?: string | null;
          implementation_owner?: string | null;
          target_implementation_date?: string | null;
          start_date?: string | null;
          end_date?: string | null;
          evidence_url?: string | null;
          result?: string | null;
          result_comment?: string | null;
          review_date?: string | null;
          status?: string | null;
          updated_at?: string | null;
          updated_by?: string | null;
        };
        Update: {
          id?: string;
          source?: "audit" | "manual";
          audit_session_id?: string | null;
          audit_response_id?: string | null;
          created_at?: string;
          category?: string | null;
          auditors?: string | null;
          question?: string | null;
          answer?: string | null;
          classification?: string | null;
          comments?: string | null;
          root_cause_analysis?: string | null;
          action_plan?: string | null;
          implementation_owner?: string | null;
          target_implementation_date?: string | null;
          start_date?: string | null;
          end_date?: string | null;
          evidence_url?: string | null;
          result?: string | null;
          result_comment?: string | null;
          review_date?: string | null;
          status?: string | null;
          updated_at?: string | null;
          updated_by?: string | null;
        };
      };
      action_plan_matrix: {
        Row: {
          id: string;
          action_id: string;
          created_at: string | null;
          source: string | null;
          classification: string;
          description: string;
          comments: string | null;
          root_cause_analysis: string | null;
          action_plan: string | null;
          owner: string | null;
          target_date: string | null;
          start_date: string | null;
          end_date: string | null;
          evidence_url: string | null;
          result: "Conformidad" | "No conformidad" | null;
          result_comment: string | null;
          review_date: string | null;
          status:
            | "COMPLETO"
            | "RETRASADO"
            | "EN PROCESO"
            | "PLANEADO"
            | "SIN ASIGNAR"
            | "REABIERTO"
            | null;
          updated_at: string | null;
          updated_by: string | null;
        };
        Insert: {
          id?: string;
          action_id: string;
          created_at?: string | null;
          source?: string | null;
          classification: string;
          description: string;
          comments?: string | null;
          root_cause_analysis?: string | null;
          action_plan?: string | null;
          owner?: string | null;
          target_date?: string | null;
          start_date?: string | null;
          end_date?: string | null;
          evidence_url?: string | null;
          result?: "Conformidad" | "No conformidad" | null;
          result_comment?: string | null;
          review_date?: string | null;
          status?:
            | "COMPLETO"
            | "RETRASADO"
            | "EN PROCESO"
            | "PLANEADO"
            | "SIN ASIGNAR"
            | "REABIERTO"
            | null;
          updated_at?: string | null;
          updated_by?: string | null;
        };
        Update: {
          id?: string;
          action_id?: string;
          created_at?: string | null;
          source?: string | null;
          classification?: string;
          description?: string;
          comments?: string | null;
          root_cause_analysis?: string | null;
          action_plan?: string | null;
          owner?: string | null;
          target_date?: string | null;
          start_date?: string | null;
          end_date?: string | null;
          evidence_url?: string | null;
          result?: "Conformidad" | "No conformidad" | null;
          result_comment?: string | null;
          review_date?: string | null;
          status?:
            | "COMPLETO"
            | "RETRASADO"
            | "EN PROCESO"
            | "PLANEADO"
            | "SIN ASIGNAR"
            | "REABIERTO"
            | null;
          updated_at?: string | null;
          updated_by?: string | null;
        };
      };      
      objectives: {
        Row: {
          id: string;
          objective_type: string | null;
          policy_excerpt_id: string | null;
          policy_excerpt: string | null;
          objective_id: string | null;
          objective_title: string | null;
          objective_elements: string | null;
          indicator: string | null;
          target: string | null;
          target_indicator_value: number | null;
          current_indicator_value: number | null;
          target_date: string | null;
          responsible: string | null;
          review_frequency: string | null;
          action_plans: string | null;
          resources: string | null;
          status: string | null;
          countermeasures: string | null;
          last_updated_at: string | null;
          next_review_date: string | null;
          created_at: string;
        };
        Insert: {
          id?: string;
          objective_type?: string | null;
          policy_excerpt_id?: string | null;
          policy_excerpt?: string | null;
          objective_id?: string | null;
          objective_title?: string | null;
          objective_elements?: string | null;
          indicator?: string | null;
          target?: string | null;
          target_indicator_value?: number | null;
          current_indicator_value?: number | null;
          target_date?: string | null;
          responsible?: string | null;
          review_frequency?: string | null;
          action_plans?: string | null;
          resources?: string | null;
          status?: string | null;
          countermeasures?: string | null;
          last_updated_at?: string | null;
          next_review_date?: string | null;
          created_at?: string;
        };
        Update: {
          id?: string;
          objective_type?: string | null;
          policy_excerpt_id?: string | null;
          policy_excerpt?: string | null;
          objective_id?: string | null;
          objective_title?: string | null;
          objective_elements?: string | null;
          indicator?: string | null;
          target?: string | null;
          target_indicator_value?: number | null;
          current_indicator_value?: number | null;
          target_date?: string | null;
          responsible?: string | null;
          review_frequency?: string | null;
          action_plans?: string | null;
          resources?: string | null;
          status?: string | null;
          countermeasures?: string | null;
          last_updated_at?: string | null;
          next_review_date?: string | null;
          created_at?: string;
        };
      };
      sga_action_plan: {
        Row: {
          id: string;
          action_code: string;
          source_type: "aspect" | "legal" | "other" | "risk" | "opportunity" | "manual";
          source_table: string | null;
          source_id: string | null;
          action_description: string;
          objective_id: string | null;
          owner: string | null;
          responsible_area: string | null;
          due_date: string | null;
          start_date: string | null;
          end_date: string | null;
          status: "unassigned" | "planned" | "in_progress" | "completed" | "delayed";
          priority: "high" | "medium" | "low" | null;
          technology_options: string | null;
          financial_requirements: string | null;
          operational_requirements: string | null;
          business_requirements: string | null;
          effectiveness_indicator: string | null;
          effectiveness_evidence: string | null;
          effectiveness_review_date: string | null;
          effectiveness_result: string | null;
          notes: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          action_code: string;
          source_type: "aspect" | "legal" | "other" | "risk" | "opportunity" | "manual";
          source_table?: string | null;
          source_id?: string | null;
          action_description: string;
          objective_id?: string | null;
          owner?: string | null;
          responsible_area?: string | null;
          due_date?: string | null;
          start_date?: string | null;
          end_date?: string | null;
          status?: "unassigned" | "planned" | "in_progress" | "completed" | "delayed";
          priority?: "high" | "medium" | "low" | null;
          technology_options?: string | null;
          financial_requirements?: string | null;
          operational_requirements?: string | null;
          business_requirements?: string | null;
          effectiveness_indicator?: string | null;
          effectiveness_evidence?: string | null;
          effectiveness_review_date?: string | null;
          effectiveness_result?: string | null;
          notes?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          action_code?: string;
          source_type?: "aspect" | "legal" | "other" | "risk" | "opportunity" | "manual";
          source_table?: string | null;
          source_id?: string | null;
          action_description?: string;
          objective_id?: string | null;
          owner?: string | null;
          responsible_area?: string | null;
          due_date?: string | null;
          start_date?: string | null;
          end_date?: string | null;
          status?: "unassigned" | "planned" | "in_progress" | "completed" | "delayed";
          priority?: "high" | "medium" | "low" | null;
          technology_options?: string | null;
          financial_requirements?: string | null;
          operational_requirements?: string | null;
          business_requirements?: string | null;
          effectiveness_indicator?: string | null;
          effectiveness_evidence?: string | null;
          effectiveness_review_date?: string | null;
          effectiveness_result?: string | null;
          notes?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      team_members: {
        Row: {
          id: string;
          owner_id: string;
          member_id: string;
          email: string;
          role: string | null;
          status: 'pending' | 'active' | 'removed';
          created_at: string;
          team_id: string;          
        };
        Insert: {
          id?: string;
          owner_id: string;
          member_id: string;
          email: string;
          role?: string | null;
          status?: 'pending' | 'active' | 'removed';
          created_at?: string;
          team_id: string;
        };
        Update: {
          id?: string;
          owner_id?: string;
          member_id?: string;
          email?: string;
          role?: string | null;
          status?: 'pending' | 'active' | 'removed';
          created_at?: string;
          team_id?: string;
        };
      };
      team_tasks: {
        Row: {
          id: string;
          member_id: string;
          assigned_by: string;
          title: string;
          description: string | null;
          status: 'pending' | 'in_progress' | 'completed';
          priority: 'low' | 'medium' | 'high';
          link_url: string | null;
          due_date: string | null;
          recurrence_pattern: string | null;
          recurrence_interval: number | null;
          recurrence_end_date: string | null;
          team_id: string | null;          
          created_at: string;
        };
        Insert: {
          id?: string;
          member_id: string;
          assigned_by: string;
          title: string;
          description?: string | null;
          status?: 'pending' | 'in_progress' | 'completed';
          priority?: 'low' | 'medium' | 'high';
          link_url?: string | null;
          due_date?: string | null;
          recurrence_pattern?: string | null;
          recurrence_interval?: number | null;
          recurrence_end_date?: string | null;
          team_id?: string | null;          
          created_at?: string;
        };
        Update: {
          id?: string;
          member_id?: string;
          assigned_by?: string;
          title?: string;
          description?: string | null;
          status?: 'pending' | 'in_progress' | 'completed';
          priority?: 'low' | 'medium' | 'high';
          link_url?: string | null;
          due_date?: string | null;
          recurrence_pattern?: string | null;
          recurrence_interval?: number | null;
          recurrence_end_date?: string | null;
          team_id?: string | null;          
          created_at?: string;
        };
      };
      leadership_org: {
        Row: {
          id: string;
          full_name: string;
          position: string;
          role: string;
          responsibilities: string | null;
          photo_url: string | null;
          commitment_letter_url: string | null;
          parent_id: string | null;
          sort_order: number;
          category: string | null;          
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          full_name: string;
          position: string;
          role: string;
          responsibilities?: string | null;
          photo_url?: string | null;
          commitment_letter_url?: string | null;
          parent_id?: string | null;
          sort_order?: number;
          category?: string | null;          
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          full_name?: string;
          position?: string;
          role?: string;
          responsibilities?: string | null;
          photo_url?: string | null;
          commitment_letter_url?: string | null;
          parent_id?: string | null;
          sort_order?: number;
          category?: string | null;          
          created_at?: string;
          updated_at?: string;
        };
      };
      rsu_registro_docs: {
        Row: {
          id: string;
          title: string;
          description: string | null;
          href: string;
          created_at: string;
          updated_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          title: string;
          description?: string | null;
          href: string;
          created_at?: string;
          updated_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          title?: string;
          description?: string | null;
          href?: string;
          created_at?: string;
          updated_at?: string;
          created_by?: string;
        };
      };
      rsu_permits: {
        Row: {
          id: string;
          title: string;
          description: string | null;
          href: string;
          created_at: string;
          updated_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          title: string;
          description?: string | null;
          href: string;
          created_at?: string;
          updated_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          title?: string;
          description?: string | null;
          href?: string;
          created_at?: string;
          updated_at?: string;
          created_by?: string;
        };
      };
      rsu_ingresos: {
        Row: {
          id: string;
          residuo: string;
          fecha: string;
          departamento: string;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          residuo: string;
          fecha: string;
          departamento: string;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          residuo?: string;
          fecha?: string;
          departamento?: string;
          created_at?: string;
          created_by?: string;
        };
      };
      rsu_salidas: {
        Row: {
          id: string;
          residuo: string;
          fecha: string;
          cantidad: string;
          registro_ambiental: string | null;
          responsable: string | null;
          transportista: string | null;
          autorizacion_transporte: string | null;
          responsable_transporte: string | null;
          destino_final: string | null;
          autorizacion_destino_final: string | null;
          responsable_destino_final: string | null;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          residuo: string;
          fecha: string;
          cantidad: string;
          registro_ambiental?: string | null;
          responsable?: string | null;
          transportista?: string | null;
          autorizacion_transporte?: string | null;
          responsable_transporte?: string | null;
          destino_final?: string | null;
          autorizacion_destino_final?: string | null;
          responsable_destino_final?: string | null;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          residuo?: string;
          fecha?: string;
          cantidad?: string;
          registro_ambiental?: string | null;
          responsable?: string | null;
          transportista?: string | null;
          autorizacion_transporte?: string | null;
          responsable_transporte?: string | null;
          destino_final?: string | null;
          autorizacion_destino_final?: string | null;
          responsable_destino_final?: string | null;
          created_at?: string;
          created_by?: string;
        };
      };
      rsu_files: {
        Row: {
          id: string;
          file_name: string;
          file_type: "factura" | "manifiesto";
          file_date: string;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          file_name: string;
          file_type: "factura" | "manifiesto";
          file_date: string;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          file_name?: string;
          file_type?: "factura" | "manifiesto";
          file_date?: string;
          created_at?: string;
          created_by?: string;
        };
      };
      rme_registro_docs: {
        Row: {
          id: string;
          title: string;
          description: string | null;
          href: string;
          created_at: string;
          updated_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          title: string;
          description?: string | null;
          href: string;
          created_at?: string;
          updated_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          title?: string;
          description?: string | null;
          href?: string;
          created_at?: string;
          updated_at?: string;
          created_by?: string;
        };
      };
      rme_permits: {
        Row: {
          id: string;
          title: string;
          description: string | null;
          href: string;
          created_at: string;
          updated_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          title: string;
          description?: string | null;
          href: string;
          created_at?: string;
          updated_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          title?: string;
          description?: string | null;
          href?: string;
          created_at?: string;
          updated_at?: string;
          created_by?: string;
        };
      };
      rme_ingresos: {
        Row: {
          id: string;
          residuo: string;
          fecha: string;
          cantidad_kg: string;
          codigo_peligrosidad: string;
          area_proceso: string;
          responsable: string;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          residuo: string;
          fecha: string;
          cantidad_kg: string;
          codigo_peligrosidad: string;
          area_proceso: string;
          responsable: string;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          residuo?: string;
          fecha?: string;
          cantidad_kg?: string;
          codigo_peligrosidad?: string;
          area_proceso?: string;
          responsable?: string;
          created_at?: string;
          created_by?: string;
        };
      };
      rme_salidas: {
        Row: {
          id: string;
          residuo: string;
          fecha: string;
          cantidad: string;
          codigo_peligrosidad: string | null;
          numero_manifiesto: string | null;
          registro_ambiental: string | null;
          responsable: string | null;
          transportista: string | null;
          autorizacion_transporte: string | null;
          responsable_transporte: string | null;
          destino_final: string | null;
          autorizacion_destino_final: string | null;
          responsable_destino_final: string | null;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          residuo: string;
          fecha: string;
          cantidad: string;
          codigo_peligrosidad?: string | null;
          numero_manifiesto?: string | null;
          registro_ambiental?: string | null;
          responsable?: string | null;
          transportista?: string | null;
          autorizacion_transporte?: string | null;
          responsable_transporte?: string | null;
          destino_final?: string | null;
          autorizacion_destino_final?: string | null;
          responsable_destino_final?: string | null;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          residuo?: string;
          fecha?: string;
          cantidad?: string;
          codigo_peligrosidad?: string | null;
          numero_manifiesto?: string | null;
          registro_ambiental?: string | null;
          responsable?: string | null;
          transportista?: string | null;
          autorizacion_transporte?: string | null;
          responsable_transporte?: string | null;
          destino_final?: string | null;
          autorizacion_destino_final?: string | null;
          responsable_destino_final?: string | null;
          created_at?: string;
          created_by?: string;
        };
      };
      rme_files: {
        Row: {
          id: string;
          file_name: string;
          file_type: "factura" | "manifiesto";
          file_date: string;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          file_name: string;
          file_type: "factura" | "manifiesto";
          file_date: string;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          file_name?: string;
          file_type?: "factura" | "manifiesto";
          file_date?: string;
          created_at?: string;
          created_by?: string;
        };
      };
      rp_registro_docs: {
        Row: {
          id: string;
          title: string;
          description: string | null;
          href: string;
          created_at: string;
          updated_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          title: string;
          description?: string | null;
          href: string;
          created_at?: string;
          updated_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          title?: string;
          description?: string | null;
          href?: string;
          created_at?: string;
          updated_at?: string;
          created_by?: string;
        };
      };
      rp_permits: {
        Row: {
          id: string;
          title: string;
          description: string | null;
          href: string;
          created_at: string;
          updated_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          title: string;
          description?: string | null;
          href: string;
          created_at?: string;
          updated_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          title?: string;
          description?: string | null;
          href?: string;
          created_at?: string;
          updated_at?: string;
          created_by?: string;
        };
      };
      rp_ingresos: {
        Row: {
          id: string;
          residuo: string;
          fecha: string;
          cantidad_kg: string;
          codigo_peligrosidad: string;
          area_proceso: string;
          responsable: string;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          residuo: string;
          fecha: string;
          cantidad_kg: string;
          codigo_peligrosidad: string;
          area_proceso: string;
          responsable: string;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          residuo?: string;
          fecha?: string;
          cantidad_kg?: string;
          codigo_peligrosidad?: string;
          area_proceso?: string;
          responsable?: string;
          created_at?: string;
          created_by?: string;
        };
      };
      rp_salidas: {
        Row: {
          id: string;
          residuo: string;
          fecha: string;
          cantidad: string;
          codigo_peligrosidad: string | null;
          numero_manifiesto: string | null;
          registro_ambiental: string | null;
          responsable: string | null;
          transportista: string | null;
          autorizacion_transporte: string | null;
          responsable_transporte: string | null;
          destino_final: string | null;
          autorizacion_destino_final: string | null;
          responsable_destino_final: string | null;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          residuo: string;
          fecha: string;
          cantidad: string;
          codigo_peligrosidad?: string | null;
          numero_manifiesto?: string | null;
          registro_ambiental?: string | null;
          responsable?: string | null;
          transportista?: string | null;
          autorizacion_transporte?: string | null;
          responsable_transporte?: string | null;
          destino_final?: string | null;
          autorizacion_destino_final?: string | null;
          responsable_destino_final?: string | null;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          residuo?: string;
          fecha?: string;
          cantidad?: string;
          codigo_peligrosidad?: string | null;
          numero_manifiesto?: string | null;
          registro_ambiental?: string | null;
          responsable?: string | null;
          transportista?: string | null;
          autorizacion_transporte?: string | null;
          responsable_transporte?: string | null;
          destino_final?: string | null;
          autorizacion_destino_final?: string | null;
          responsable_destino_final?: string | null;
          created_at?: string;
          created_by?: string;
        };
      };
      rp_files: {
        Row: {
          id: string;
          file_name: string;
          file_type: "factura" | "manifiesto";
          file_date: string;
          created_at: string;
          created_by: string;
        };
        Insert: {
          id?: string;
          file_name: string;
          file_type: "factura" | "manifiesto";
          file_date: string;
          created_at?: string;
          created_by: string;
        };
        Update: {
          id?: string;
          file_name?: string;
          file_type?: "factura" | "manifiesto";
          file_date?: string;
          created_at?: string;
          created_by?: string;
        };
      };
      energy_records: {
        Row: {
          id: string;
          date: string;
          month: string;
          year: number;
          generation_kwh: number;
          consumption_kwh: number;
          energy_acquired_cfe_kwh: number;
          energy_sold_cfe_kwh: number;
          cfe_bill: number;
          kiwapower_rate: number;
          replacement_rate: number;
          cfe_rate: number;
          created_by: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          date: string;
          month: string;
          year: number;
          generation_kwh: number;
          consumption_kwh: number;
          energy_acquired_cfe_kwh: number;
          energy_sold_cfe_kwh: number;
          cfe_bill: number;
          kiwapower_rate: number;
          replacement_rate: number;
          cfe_rate: number;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          date?: string;
          month?: string;
          year?: number;
          generation_kwh?: number;
          consumption_kwh?: number;
          energy_acquired_cfe_kwh?: number;
          energy_sold_cfe_kwh?: number;
          cfe_bill?: number;
          kiwapower_rate?: number;
          replacement_rate?: number;
          cfe_rate?: number;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      water_records: {
        Row: {
          id: string;
          type: "Red" | "RO";
          date: string;
          month: string | null;
          year: number | null;
          quantity_m3: number;
          quantity_liters: number | null;
          unit_cost: number;
          total_cost: number | null;
          provider: string;
          invoice_url: string | null;
          created_by: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          type: "Red" | "RO";
          date: string;
          month?: string | null;
          year?: number | null;
          quantity_m3: number;
          quantity_liters?: number | null;
          unit_cost: number;
          total_cost?: number | null;
          provider: string;
          invoice_url?: string | null;
          created_by: string;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          type?: "Red" | "RO";
          date?: string;
          month?: string | null;
          year?: number | null;
          quantity_m3?: number;
          quantity_liters?: number | null;
          unit_cost?: number;
          total_cost?: number | null;
          provider?: string;
          invoice_url?: string | null;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      fuel_gasoline_records: {
        Row: {
          id: string;
          date: string;
          month: string | null;
          year: number | null;
          budget: number;
          fuel_type: "Magna" | "Diesel" | "Premium";
          average_cost_per_liter: number;
          equivalent_liters: number;
          notes: string | null;
          created_by: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          date: string;
          month?: string | null;
          year?: number | null;
          budget: number;
          fuel_type: "Magna" | "Diesel" | "Premium";
          average_cost_per_liter: number;
          equivalent_liters: number;
          notes?: string | null;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          date?: string;
          month?: string | null;
          year?: number | null;
          budget?: number;
          fuel_type?: "Magna" | "Diesel" | "Premium";
          average_cost_per_liter?: number;
          equivalent_liters?: number;
          notes?: string | null;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      fuel_gas_records: {
        Row: {
          id: string;
          date: string;
          month: string | null;
          year: number | null;
          gas_type: string;
          tank_capacity: number;
          capacity_unit: "L" | "kg";
          quantity: number;
          total_liters: number;
          unit_cost: number;
          cost_unit: "Por litro" | "Por unidad";
          total_cost: number;
          provider: string;
          created_by: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          date: string;
          month?: string | null;
          year?: number | null;
          gas_type: string;
          tank_capacity: number;
          capacity_unit: "L" | "kg";
          quantity: number;
          total_liters: number;
          unit_cost: number;
          cost_unit: "Por litro" | "Por unidad";
          total_cost: number;
          provider: string;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          date?: string;
          month?: string | null;
          year?: number | null;
          gas_type?: string;
          tank_capacity?: number;
          capacity_unit?: "L" | "kg";
          quantity?: number;
          total_liters?: number;
          unit_cost?: number;
          cost_unit?: "Por litro" | "Por unidad";
          total_cost?: number;
          provider?: string;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      suppliers: {
        Row: {
          id: string;
          name: string;
          contact_email_or_contact: string | null;
          material_type: string | null;
          location: string | null;
          purchase_type: 'direct' | 'indirect' | 'direct_indirect';
          created_at: string;
        };
        Insert: {
          id?: string;
          name: string;
          contact_email_or_contact?: string | null;
          material_type?: string | null;
          location?: string | null;
          purchase_type: 'direct' | 'indirect' | 'direct_indirect';
          created_at?: string;
        };
        Update: {
          id?: string;
          name?: string;
          contact_email_or_contact?: string | null;
          material_type?: string | null;
          location?: string | null;
          purchase_type?: 'direct' | 'indirect' | 'direct_indirect';
          created_at?: string;
        };
      };
      supplier_evaluations: {
        Row: {
          id: string;
          supplier_id: string;
          evaluation_date: string;
          year: number;
          quarter: 1 | 2 | 3 | 4;
          env_cert: boolean;
          env_rse: boolean;
          env_policy: boolean;
          env_score: number;
          tech_spec_score: number;
          delivery_score: number;
          cost_score: number;
          payment_terms_score: number;
          quality_certs_score: number;
          final_score: number;
          status: 'APROBADO' | 'REPROBADO';
          notes: string | null;
          created_by: string | null;
          created_at: string;
        };
        Insert: {
          id?: string;
          supplier_id: string;
          evaluation_date: string;
          year: number;
          quarter: 1 | 2 | 3 | 4;
          env_cert?: boolean;
          env_rse?: boolean;
          env_policy?: boolean;
          env_score: number;
          tech_spec_score: number;
          delivery_score: number;
          cost_score: number;
          payment_terms_score: number;
          quality_certs_score: number;
          final_score: number;
          status: 'APROBADO' | 'REPROBADO';
          notes?: string | null;
          created_by?: string | null;
          created_at?: string;
        };
        Update: {
          id?: string;
          supplier_id?: string;
          evaluation_date?: string;
          year?: number;
          quarter?: 1 | 2 | 3 | 4;
          env_cert?: boolean;
          env_rse?: boolean;
          env_policy?: boolean;
          env_score?: number;
          tech_spec_score?: number;
          delivery_score?: number;
          cost_score?: number;
          payment_terms_score?: number;
          quality_certs_score?: number;
          final_score?: number;
          status?: 'APROBADO' | 'REPROBADO';
          notes?: string | null;
          created_by?: string | null;
          created_at?: string;
        };
      };      
      indicators_yearly: {
        Row: {
          id: string;
          indicator_type: "environment" | "quality" | "safety";
          year: number | null;
          policy_id: string | null;
          objective_id: string | null;
          concept: string | null;
          element: string | null;
          indicator: string | null;
          pic: string | null;
          info_updater: string | null;
          jan: number | null;
          feb: number | null;
          mar: number | null;
          apr: number | null;
          may: number | null;
          jun: number | null;
          jul: number | null;
          aug: number | null;
          sep: number | null;
          oct: number | null;
          nov: number | null;
          dec: number | null;
          annual_sum_target: number | null;
          annual_average_target: number | null;
          compliance: boolean | null;
          last_updated_at: string | null;
          last_updated_by: string | null;
          created_at: string;
        };
        Insert: {
          id?: string;
          indicator_type: "environment" | "quality" | "safety";
          year?: number | null;
          policy_id?: string | null;
          objective_id?: string | null;
          concept?: string | null;
          element?: string | null;
          indicator?: string | null;
          pic?: string | null;
          info_updater?: string | null;
          jan?: number | null;
          feb?: number | null;
          mar?: number | null;
          apr?: number | null;
          may?: number | null;
          jun?: number | null;
          jul?: number | null;
          aug?: number | null;
          sep?: number | null;
          oct?: number | null;
          nov?: number | null;
          dec?: number | null;
          annual_sum_target?: number | null;
          annual_average_target?: number | null;
          compliance?: boolean | null;
          last_updated_at?: string | null;
          last_updated_by?: string | null;
          created_at?: string;
        };
        Update: {
          id?: string;
          indicator_type?: "environment" | "quality" | "safety";
          year?: number | null;
          policy_id?: string | null;
          objective_id?: string | null;
          concept?: string | null;
          element?: string | null;
          indicator?: string | null;
          pic?: string | null;
          info_updater?: string | null;
          jan?: number | null;
          feb?: number | null;
          mar?: number | null;
          apr?: number | null;
          may?: number | null;
          jun?: number | null;
          jul?: number | null;
          aug?: number | null;
          sep?: number | null;
          oct?: number | null;
          nov?: number | null;
          dec?: number | null;
          annual_sum_target?: number | null;
          annual_average_target?: number | null;
          compliance?: boolean | null;
          last_updated_at?: string | null;
          last_updated_by?: string | null;
          created_at?: string;
        };
      };
      legal_requirements: {
        Row: {
          id: string;
          requirement_id: string;
          type: string;
          article: string;
          title: string;
          description: string;
          environmental_aspect: string | null;
          verification_frequency: string;
          compliance_status: string;
          evidence_url: string | null;
          retention_time: string | null;
          responsible_area: string;
          followup_responsible: string;
          required_action: string | null;
          commitment_date: string | null;
          action_status: string | null;
          closure_date: string | null;
          last_updated_at: string | null;
          next_update_date: string | null;
          created_at: string;
        };
        Insert: {
          id?: string;
          requirement_id: string;
          type: string;
          article: string;
          title: string;
          description?: string;
          environmental_aspect?: string | null;
          verification_frequency: string;
          compliance_status: string;
          evidence_url?: string | null;
          retention_time?: string | null;
          responsible_area: string;
          followup_responsible: string;
          required_action?: string | null;
          commitment_date?: string | null;
          action_status?: string | null;
          closure_date?: string | null;
          last_updated_at?: string | null;
          next_update_date?: string | null;
          created_at?: string;
        };
        Update: {
          id?: string;
          requirement_id?: string;
          type?: string;
          article?: string;
          title?: string;
          description?: string;
          environmental_aspect?: string | null;
          verification_frequency?: string;
          compliance_status?: string;
          evidence_url?: string | null;
          retention_time?: string | null;
          responsible_area?: string;
          followup_responsible?: string;
          required_action?: string | null;
          commitment_date?: string | null;
          action_status?: string | null;
          closure_date?: string | null;
          last_updated_at?: string | null;
          next_update_date?: string | null;
          created_at?: string;
        };
      };
      quality_qir: {
        Row: {
          id: string;
          qir_number: number;
          date: string | null;
          detected_by_department: string | null;
          job_number: string | null;
          part_name: string | null;
          job_name: string | null;
          defect_type: string | null;
          defect_detail: string | null;
          corrective_action: string | null;
          time_man_ds: number | null;
          time_man_pe: number | null;
          time_man_p1: number | null;
          time_cnc: number | null;
          time_edm: number | null;
          time_wc: number | null;
          time_mm: number | null;
          time_lathe: number | null;
          time_man_ins: number | null;
          time_cmm: number | null;
          time_keyence: number | null;
          time_man_p2: number | null;
          time_oven: number | null;
          time_welding: number | null;
          time_man_commercial: number | null;
          material_cost: number | null;
          lost_cost: number | null;
          error_person: string | null;
          factor_identification: string | null;
          responsible_area: string | null;
          document_type: string | null;
          scope: string | null;
          material_classification: "Stock" | "Scrap" | null;
          sent_to_stock_or_scrap_date: string | null;
          why_why_sent_date: string | null;
          countermeasure: string | null;
          socialization: string | null;
          application: string | null;
          application_job_number: string | null;
          qc_delay: string | null;
          standard_delay: string | null;
          socialization_delay: string | null;
          application_delay: string | null;
          created_by: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          qir_number?: number;
          date?: string | null;
          detected_by_department?: string | null;
          job_number?: string | null;
          part_name?: string | null;
          job_name?: string | null;
          defect_type?: string | null;
          defect_detail?: string | null;
          corrective_action?: string | null;
          time_man_ds?: number | null;
          time_man_pe?: number | null;
          time_man_p1?: number | null;
          time_cnc?: number | null;
          time_edm?: number | null;
          time_wc?: number | null;
          time_mm?: number | null;
          time_lathe?: number | null;
          time_man_ins?: number | null;
          time_cmm?: number | null;
          time_keyence?: number | null;
          time_man_p2?: number | null;
          time_oven?: number | null;
          time_welding?: number | null;
          time_man_commercial?: number | null;
          material_cost?: number | null;
          lost_cost?: number | null;
          error_person?: string | null;
          factor_identification?: string | null;
          responsible_area?: string | null;
          document_type?: string | null;
          scope?: string | null;
          material_classification?: "Stock" | "Scrap" | null;
          sent_to_stock_or_scrap_date?: string | null;
          why_why_sent_date?: string | null;
          countermeasure?: string | null;
          socialization?: string | null;
          application?: string | null;
          application_job_number?: string | null;
          qc_delay?: string | null;
          standard_delay?: string | null;
          socialization_delay?: string | null;
          application_delay?: string | null;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          qir_number?: number;
          date?: string | null;
          detected_by_department?: string | null;
          job_number?: string | null;
          part_name?: string | null;
          job_name?: string | null;
          defect_type?: string | null;
          defect_detail?: string | null;
          corrective_action?: string | null;
          time_man_ds?: number | null;
          time_man_pe?: number | null;
          time_man_p1?: number | null;
          time_cnc?: number | null;
          time_edm?: number | null;
          time_wc?: number | null;
          time_mm?: number | null;
          time_lathe?: number | null;
          time_man_ins?: number | null;
          time_cmm?: number | null;
          time_keyence?: number | null;
          time_man_p2?: number | null;
          time_oven?: number | null;
          time_welding?: number | null;
          time_man_commercial?: number | null;
          material_cost?: number | null;
          lost_cost?: number | null;
          error_person?: string | null;
          factor_identification?: string | null;
          responsible_area?: string | null;
          document_type?: string | null;
          scope?: string | null;
          material_classification?: "Stock" | "Scrap" | null;
          sent_to_stock_or_scrap_date?: string | null;
          why_why_sent_date?: string | null;
          countermeasure?: string | null;
          socialization?: string | null;
          application?: string | null;
          application_job_number?: string | null;
          qc_delay?: string | null;
          standard_delay?: string | null;
          socialization_delay?: string | null;
          application_delay?: string | null;
          created_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      quality_stock: {
        Row: {
          id: string;
          qir_id: string | null;
          qir_number: number | null;
          qir_date: string | null;
          stock_entry_date: string | null;
          original_job_number: string | null;
          material_type: string | null;
          size_l: number | null;
          size_w: number | null;
          size_h: number | null;
          volume_cm3: number | null;
          approx_weight: number | null;
          destination: "retrabajo" | "scrap" | "stock" | null;
          new_job_number: string | null;
          status: string | null;
          stock_exit_date: string | null;
          comments: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          qir_id?: string | null;
          qir_number?: number | null;
          qir_date?: string | null;
          stock_entry_date?: string | null;
          original_job_number?: string | null;
          material_type?: string | null;
          size_l?: number | null;
          size_w?: number | null;
          size_h?: number | null;
          volume_cm3?: number | null;
          approx_weight?: number | null;
          destination?: "retrabajo" | "scrap" | "stock" | null;
          new_job_number?: string | null;
          status?: string | null;
          stock_exit_date?: string | null;
          comments?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          qir_id?: string | null;
          qir_number?: number | null;
          qir_date?: string | null;
          stock_entry_date?: string | null;
          original_job_number?: string | null;
          material_type?: string | null;
          size_l?: number | null;
          size_w?: number | null;
          size_h?: number | null;
          volume_cm3?: number | null;
          approx_weight?: number | null;
          destination?: "retrabajo" | "scrap" | "stock" | null;
          new_job_number?: string | null;
          status?: string | null;
          stock_exit_date?: string | null;
          comments?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      quality_scrap: {
        Row: {
          id: string;
          qir_id: string | null;
          stock_id: string | null;
          qir_number: number | null;
          qir_date: string | null;
          stock_entry_date: string | null;
          original_job_number: string | null;
          material_type: string | null;
          size_l: number | null;
          size_w: number | null;
          size_h: number | null;
          volume_cm3: number | null;
          approx_weight: number | null;
          destination: string | null;
          scrap_exit_date: string | null;
          comments: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          qir_id?: string | null;
          stock_id?: string | null;
          qir_number?: number | null;
          qir_date?: string | null;
          stock_entry_date?: string | null;
          original_job_number?: string | null;
          material_type?: string | null;
          size_l?: number | null;
          size_w?: number | null;
          size_h?: number | null;
          volume_cm3?: number | null;
          approx_weight?: number | null;
          destination?: string | null;
          scrap_exit_date?: string | null;
          comments?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          qir_id?: string | null;
          stock_id?: string | null;
          qir_number?: number | null;
          qir_date?: string | null;
          stock_entry_date?: string | null;
          original_job_number?: string | null;
          material_type?: string | null;
          size_l?: number | null;
          size_w?: number | null;
          size_h?: number | null;
          volume_cm3?: number | null;
          approx_weight?: number | null;
          destination?: string | null;
          scrap_exit_date?: string | null;
          comments?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };          
      continuous_improvement_register: {
        Row: {
          id: string;
          date: string | null;
          source_type: string;
          description: string;
          action_implemented: string | null;
          responsible: string | null;
          target_date: string | null;
          close_date: string | null;
          evidence_url: string | null;
          expected_result: string | null;
          achieved_result: string | null;
          status: string;
          source_table: string | null;
          source_id: string | null;
          created_by: string | null;
          updated_by: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          date?: string | null;
          source_type: string;
          description: string;
          action_implemented?: string | null;
          responsible?: string | null;
          target_date?: string | null;
          close_date?: string | null;
          evidence_url?: string | null;
          expected_result?: string | null;
          achieved_result?: string | null;
          status?: string;
          source_table?: string | null;
          source_id?: string | null;
          created_by?: string | null;
          updated_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          date?: string | null;
          source_type?: string;
          description?: string;
          action_implemented?: string | null;
          responsible?: string | null;
          target_date?: string | null;
          close_date?: string | null;
          evidence_url?: string | null;
          expected_result?: string | null;
          achieved_result?: string | null;
          status?: string;
          source_table?: string | null;
          source_id?: string | null;
          created_by?: string | null;
          updated_by?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      management_review_sessions: {
        Row: {
          id: string;
          session_code: string | null;
          review_date: string | null;
          period_start: string | null;
          period_end: string | null;
          participants: string | null;
          prepared_by: string | null;
          status: string | null;
          general_conclusions: string | null;
          strategic_implications: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          session_code?: string | null;
          review_date?: string | null;
          period_start?: string | null;
          period_end?: string | null;
          participants?: string | null;
          prepared_by?: string | null;
          status?: string | null;
          general_conclusions?: string | null;
          strategic_implications?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          session_code?: string | null;
          review_date?: string | null;
          period_start?: string | null;
          period_end?: string | null;
          participants?: string | null;
          prepared_by?: string | null;
          status?: string | null;
          general_conclusions?: string | null;
          strategic_implications?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      management_review_inputs: {
        Row: {
          id: string;
          session_id: string;
          input_key: string;
          summary_snapshot: Record<string, unknown> | null;
          management_comment: string | null;
          evidence_link: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          session_id: string;
          input_key: string;
          summary_snapshot?: Record<string, unknown> | null;
          management_comment?: string | null;
          evidence_link?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          session_id?: string;
          input_key?: string;
          summary_snapshot?: Record<string, unknown> | null;
          management_comment?: string | null;
          evidence_link?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };
      management_review_outputs: {
        Row: {
          id: string;
          session_id: string;
          output_key: string;
          decision_text: string;
          responsible: string | null;
          due_date: string | null;
          action_link: string | null;
          status: string | null;
          evidence_link: string | null;
          created_at: string;
          updated_at: string;
        };
        Insert: {
          id?: string;
          session_id: string;
          output_key: string;
          decision_text: string;
          responsible?: string | null;
          due_date?: string | null;
          action_link?: string | null;
          status?: string | null;
          evidence_link?: string | null;
          created_at?: string;
          updated_at?: string;
        };
        Update: {
          id?: string;
          session_id?: string;
          output_key?: string;
          decision_text?: string;
          responsible?: string | null;
          due_date?: string | null;
          action_link?: string | null;
          status?: string | null;
          evidence_link?: string | null;
          created_at?: string;
          updated_at?: string;
        };
      };      
    };
    Views: {
      mp_user_points_summary: {
        Row: {
          user_id: string;
          points_earned: number;
          points_spent: number;
          points_available: number;
        };
      };
    };    
  };
};
