/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 675:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}


/***/ }),

/***/ 4:
/***/ ((module) => {

/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Bit reading helpers
*/

var BROTLI_READ_SIZE = 4096;
var BROTLI_IBUF_SIZE =  (2 * BROTLI_READ_SIZE + 32);
var BROTLI_IBUF_MASK =  (2 * BROTLI_READ_SIZE - 1);

var kBitMask = new Uint32Array([
  0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, 32767,
  65535, 131071, 262143, 524287, 1048575, 2097151, 4194303, 8388607, 16777215
]);

/* Input byte buffer, consist of a ringbuffer and a "slack" region where */
/* bytes from the start of the ringbuffer are copied. */
function BrotliBitReader(input) {
  this.buf_ = new Uint8Array(BROTLI_IBUF_SIZE);
  this.input_ = input;    /* input callback */
  
  this.reset();
}

BrotliBitReader.READ_SIZE = BROTLI_READ_SIZE;
BrotliBitReader.IBUF_MASK = BROTLI_IBUF_MASK;

BrotliBitReader.prototype.reset = function() {
  this.buf_ptr_ = 0;      /* next input will write here */
  this.val_ = 0;          /* pre-fetched bits */
  this.pos_ = 0;          /* byte position in stream */
  this.bit_pos_ = 0;      /* current bit-reading position in val_ */
  this.bit_end_pos_ = 0;  /* bit-reading end position from LSB of val_ */
  this.eos_ = 0;          /* input stream is finished */
  
  this.readMoreInput();
  for (var i = 0; i < 4; i++) {
    this.val_ |= this.buf_[this.pos_] << (8 * i);
    ++this.pos_;
  }
  
  return this.bit_end_pos_ > 0;
};

/* Fills up the input ringbuffer by calling the input callback.

   Does nothing if there are at least 32 bytes present after current position.

   Returns 0 if either:
    - the input callback returned an error, or
    - there is no more input and the position is past the end of the stream.

   After encountering the end of the input stream, 32 additional zero bytes are
   copied to the ringbuffer, therefore it is safe to call this function after
   every 32 bytes of input is read.
*/
BrotliBitReader.prototype.readMoreInput = function() {
  if (this.bit_end_pos_ > 256) {
    return;
  } else if (this.eos_) {
    if (this.bit_pos_ > this.bit_end_pos_)
      throw new Error('Unexpected end of input ' + this.bit_pos_ + ' ' + this.bit_end_pos_);
  } else {
    var dst = this.buf_ptr_;
    var bytes_read = this.input_.read(this.buf_, dst, BROTLI_READ_SIZE);
    if (bytes_read < 0) {
      throw new Error('Unexpected end of input');
    }
    
    if (bytes_read < BROTLI_READ_SIZE) {
      this.eos_ = 1;
      /* Store 32 bytes of zero after the stream end. */
      for (var p = 0; p < 32; p++)
        this.buf_[dst + bytes_read + p] = 0;
    }
    
    if (dst === 0) {
      /* Copy the head of the ringbuffer to the slack region. */
      for (var p = 0; p < 32; p++)
        this.buf_[(BROTLI_READ_SIZE << 1) + p] = this.buf_[p];

      this.buf_ptr_ = BROTLI_READ_SIZE;
    } else {
      this.buf_ptr_ = 0;
    }
    
    this.bit_end_pos_ += bytes_read << 3;
  }
};

/* Guarantees that there are at least 24 bits in the buffer. */
BrotliBitReader.prototype.fillBitWindow = function() {    
  while (this.bit_pos_ >= 8) {
    this.val_ >>>= 8;
    this.val_ |= this.buf_[this.pos_ & BROTLI_IBUF_MASK] << 24;
    ++this.pos_;
    this.bit_pos_ = this.bit_pos_ - 8 >>> 0;
    this.bit_end_pos_ = this.bit_end_pos_ - 8 >>> 0;
  }
};

/* Reads the specified number of bits from Read Buffer. */
BrotliBitReader.prototype.readBits = function(n_bits) {
  if (32 - this.bit_pos_ < n_bits) {
    this.fillBitWindow();
  }
  
  var val = ((this.val_ >>> this.bit_pos_) & kBitMask[n_bits]);
  this.bit_pos_ += n_bits;
  return val;
};

module.exports = BrotliBitReader;


/***/ }),

/***/ 864:
/***/ ((__unused_webpack_module, exports) => {

/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Lookup table to map the previous two bytes to a context id.

   There are four different context modeling modes defined here:
     CONTEXT_LSB6: context id is the least significant 6 bits of the last byte,
     CONTEXT_MSB6: context id is the most significant 6 bits of the last byte,
     CONTEXT_UTF8: second-order context model tuned for UTF8-encoded text,
     CONTEXT_SIGNED: second-order context model tuned for signed integers.

   The context id for the UTF8 context model is calculated as follows. If p1
   and p2 are the previous two bytes, we calcualte the context as

     context = kContextLookup[p1] | kContextLookup[p2 + 256].

   If the previous two bytes are ASCII characters (i.e. < 128), this will be
   equivalent to

     context = 4 * context1(p1) + context2(p2),

   where context1 is based on the previous byte in the following way:

     0  : non-ASCII control
     1  : \t, \n, \r
     2  : space
     3  : other punctuation
     4  : " '
     5  : %
     6  : ( < [ {
     7  : ) > ] }
     8  : , ; :
     9  : .
     10 : =
     11 : number
     12 : upper-case vowel
     13 : upper-case consonant
     14 : lower-case vowel
     15 : lower-case consonant

   and context2 is based on the second last byte:

     0 : control, space
     1 : punctuation
     2 : upper-case letter, number
     3 : lower-case letter

   If the last byte is ASCII, and the second last byte is not (in a valid UTF8
   stream it will be a continuation byte, value between 128 and 191), the
   context is the same as if the second last byte was an ASCII control or space.

   If the last byte is a UTF8 lead byte (value >= 192), then the next byte will
   be a continuation byte and the context id is 2 or 3 depending on the LSB of
   the last byte and to a lesser extent on the second last byte if it is ASCII.

   If the last byte is a UTF8 continuation byte, the second last byte can be:
     - continuation byte: the next byte is probably ASCII or lead byte (assuming
       4-byte UTF8 characters are rare) and the context id is 0 or 1.
     - lead byte (192 - 207): next byte is ASCII or lead byte, context is 0 or 1
     - lead byte (208 - 255): next byte is continuation byte, context is 2 or 3

   The possible value combinations of the previous two bytes, the range of
   context ids and the type of the next byte is summarized in the table below:

   |--------\-----------------------------------------------------------------|
   |         \                         Last byte                              |
   | Second   \---------------------------------------------------------------|
   | last byte \    ASCII            |   cont. byte        |   lead byte      |
   |            \   (0-127)          |   (128-191)         |   (192-)         |
   |=============|===================|=====================|==================|
   |  ASCII      | next: ASCII/lead  |  not valid          |  next: cont.     |
   |  (0-127)    | context: 4 - 63   |                     |  context: 2 - 3  |
   |-------------|-------------------|---------------------|------------------|
   |  cont. byte | next: ASCII/lead  |  next: ASCII/lead   |  next: cont.     |
   |  (128-191)  | context: 4 - 63   |  context: 0 - 1     |  context: 2 - 3  |
   |-------------|-------------------|---------------------|------------------|
   |  lead byte  | not valid         |  next: ASCII/lead   |  not valid       |
   |  (192-207)  |                   |  context: 0 - 1     |                  |
   |-------------|-------------------|---------------------|------------------|
   |  lead byte  | not valid         |  next: cont.        |  not valid       |
   |  (208-)     |                   |  context: 2 - 3     |                  |
   |-------------|-------------------|---------------------|------------------|

   The context id for the signed context mode is calculated as:

     context = (kContextLookup[512 + p1] << 3) | kContextLookup[512 + p2].

   For any context modeling modes, the context ids can be calculated by |-ing
   together two lookups from one table using context model dependent offsets:

     context = kContextLookup[offset1 + p1] | kContextLookup[offset2 + p2].

   where offset1 and offset2 are dependent on the context mode.
*/

var CONTEXT_LSB6         = 0;
var CONTEXT_MSB6         = 1;
var CONTEXT_UTF8         = 2;
var CONTEXT_SIGNED       = 3;

/* Common context lookup table for all context modes. */
exports.lookup = new Uint8Array([
  /* CONTEXT_UTF8, last byte. */
  /* ASCII range. */
   0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  4,  0,  0,  4,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   8, 12, 16, 12, 12, 20, 12, 16, 24, 28, 12, 12, 32, 12, 36, 12,
  44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 32, 32, 24, 40, 28, 12,
  12, 48, 52, 52, 52, 48, 52, 52, 52, 48, 52, 52, 52, 52, 52, 48,
  52, 52, 52, 52, 52, 48, 52, 52, 52, 52, 52, 24, 12, 28, 12, 12,
  12, 56, 60, 60, 60, 56, 60, 60, 60, 56, 60, 60, 60, 60, 60, 56,
  60, 60, 60, 60, 60, 56, 60, 60, 60, 60, 60, 24, 12, 28, 12,  0,
  /* UTF8 continuation byte range. */
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  /* UTF8 lead byte range. */
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  /* CONTEXT_UTF8 second last byte. */
  /* ASCII range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1,
  1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 0,
  /* UTF8 continuation byte range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  /* UTF8 lead byte range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  /* CONTEXT_SIGNED, second last byte. */
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7,
  /* CONTEXT_SIGNED, last byte, same as the above values shifted by 3 bits. */
   0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56,
  /* CONTEXT_LSB6, last byte. */
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
  /* CONTEXT_MSB6, last byte. */
   0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
   4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
   8,  8,  8,  8,  9,  9,  9,  9, 10, 10, 10, 10, 11, 11, 11, 11,
  12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15,
  16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19,
  20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23,
  24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27,
  28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31,
  32, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35,
  36, 36, 36, 36, 37, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 39,
  40, 40, 40, 40, 41, 41, 41, 41, 42, 42, 42, 42, 43, 43, 43, 43,
  44, 44, 44, 44, 45, 45, 45, 45, 46, 46, 46, 46, 47, 47, 47, 47,
  48, 48, 48, 48, 49, 49, 49, 49, 50, 50, 50, 50, 51, 51, 51, 51,
  52, 52, 52, 52, 53, 53, 53, 53, 54, 54, 54, 54, 55, 55, 55, 55,
  56, 56, 56, 56, 57, 57, 57, 57, 58, 58, 58, 58, 59, 59, 59, 59,
  60, 60, 60, 60, 61, 61, 61, 61, 62, 62, 62, 62, 63, 63, 63, 63,
  /* CONTEXT_{M,L}SB6, second last byte, */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
]);

exports.lookupOffsets = new Uint16Array([
  /* CONTEXT_LSB6 */
  1024, 1536,
  /* CONTEXT_MSB6 */
  1280, 1536,
  /* CONTEXT_UTF8 */
  0, 256,
  /* CONTEXT_SIGNED */
  768, 512,
]);


/***/ }),

/***/ 328:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

var __webpack_unused_export__;
/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

var BrotliInput = (__nccwpck_require__(586)/* .BrotliInput */ .g);
var BrotliOutput = (__nccwpck_require__(586)/* .BrotliOutput */ .j);
var BrotliBitReader = __nccwpck_require__(4);
var BrotliDictionary = __nccwpck_require__(244);
var HuffmanCode = (__nccwpck_require__(343)/* .HuffmanCode */ .h);
var BrotliBuildHuffmanTable = (__nccwpck_require__(343)/* .BrotliBuildHuffmanTable */ .g);
var Context = __nccwpck_require__(864);
var Prefix = __nccwpck_require__(899);
var Transform = __nccwpck_require__(253);

var kDefaultCodeLength = 8;
var kCodeLengthRepeatCode = 16;
var kNumLiteralCodes = 256;
var kNumInsertAndCopyCodes = 704;
var kNumBlockLengthCodes = 26;
var kLiteralContextBits = 6;
var kDistanceContextBits = 2;

var HUFFMAN_TABLE_BITS = 8;
var HUFFMAN_TABLE_MASK = 0xff;
/* Maximum possible Huffman table size for an alphabet size of 704, max code
 * length 15 and root table bits 8. */
var HUFFMAN_MAX_TABLE_SIZE = 1080;

var CODE_LENGTH_CODES = 18;
var kCodeLengthCodeOrder = new Uint8Array([
  1, 2, 3, 4, 0, 5, 17, 6, 16, 7, 8, 9, 10, 11, 12, 13, 14, 15,
]);

var NUM_DISTANCE_SHORT_CODES = 16;
var kDistanceShortCodeIndexOffset = new Uint8Array([
  3, 2, 1, 0, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2
]);

var kDistanceShortCodeValueOffset = new Int8Array([
  0, 0, 0, 0, -1, 1, -2, 2, -3, 3, -1, 1, -2, 2, -3, 3
]);

var kMaxHuffmanTableSize = new Uint16Array([
  256, 402, 436, 468, 500, 534, 566, 598, 630, 662, 694, 726, 758, 790, 822,
  854, 886, 920, 952, 984, 1016, 1048, 1080
]);

function DecodeWindowBits(br) {
  var n;
  if (br.readBits(1) === 0) {
    return 16;
  }
  
  n = br.readBits(3);
  if (n > 0) {
    return 17 + n;
  }
  
  n = br.readBits(3);
  if (n > 0) {
    return 8 + n;
  }
  
  return 17;
}

/* Decodes a number in the range [0..255], by reading 1 - 11 bits. */
function DecodeVarLenUint8(br) {
  if (br.readBits(1)) {
    var nbits = br.readBits(3);
    if (nbits === 0) {
      return 1;
    } else {
      return br.readBits(nbits) + (1 << nbits);
    }
  }
  return 0;
}

function MetaBlockLength() {
  this.meta_block_length = 0;
  this.input_end = 0;
  this.is_uncompressed = 0;
  this.is_metadata = false;
}

function DecodeMetaBlockLength(br) {
  var out = new MetaBlockLength;  
  var size_nibbles;
  var size_bytes;
  var i;
  
  out.input_end = br.readBits(1);
  if (out.input_end && br.readBits(1)) {
    return out;
  }
  
  size_nibbles = br.readBits(2) + 4;
  if (size_nibbles === 7) {
    out.is_metadata = true;
    
    if (br.readBits(1) !== 0)
      throw new Error('Invalid reserved bit');
    
    size_bytes = br.readBits(2);
    if (size_bytes === 0)
      return out;
    
    for (i = 0; i < size_bytes; i++) {
      var next_byte = br.readBits(8);
      if (i + 1 === size_bytes && size_bytes > 1 && next_byte === 0)
        throw new Error('Invalid size byte');
      
      out.meta_block_length |= next_byte << (i * 8);
    }
  } else {
    for (i = 0; i < size_nibbles; ++i) {
      var next_nibble = br.readBits(4);
      if (i + 1 === size_nibbles && size_nibbles > 4 && next_nibble === 0)
        throw new Error('Invalid size nibble');
      
      out.meta_block_length |= next_nibble << (i * 4);
    }
  }
  
  ++out.meta_block_length;
  
  if (!out.input_end && !out.is_metadata) {
    out.is_uncompressed = br.readBits(1);
  }
  
  return out;
}

/* Decodes the next Huffman code from bit-stream. */
function ReadSymbol(table, index, br) {
  var start_index = index;
  
  var nbits;
  br.fillBitWindow();
  index += (br.val_ >>> br.bit_pos_) & HUFFMAN_TABLE_MASK;
  nbits = table[index].bits - HUFFMAN_TABLE_BITS;
  if (nbits > 0) {
    br.bit_pos_ += HUFFMAN_TABLE_BITS;
    index += table[index].value;
    index += (br.val_ >>> br.bit_pos_) & ((1 << nbits) - 1);
  }
  br.bit_pos_ += table[index].bits;
  return table[index].value;
}

function ReadHuffmanCodeLengths(code_length_code_lengths, num_symbols, code_lengths, br) {
  var symbol = 0;
  var prev_code_len = kDefaultCodeLength;
  var repeat = 0;
  var repeat_code_len = 0;
  var space = 32768;
  
  var table = [];
  for (var i = 0; i < 32; i++)
    table.push(new HuffmanCode(0, 0));
  
  BrotliBuildHuffmanTable(table, 0, 5, code_length_code_lengths, CODE_LENGTH_CODES);

  while (symbol < num_symbols && space > 0) {
    var p = 0;
    var code_len;
    
    br.readMoreInput();
    br.fillBitWindow();
    p += (br.val_ >>> br.bit_pos_) & 31;
    br.bit_pos_ += table[p].bits;
    code_len = table[p].value & 0xff;
    if (code_len < kCodeLengthRepeatCode) {
      repeat = 0;
      code_lengths[symbol++] = code_len;
      if (code_len !== 0) {
        prev_code_len = code_len;
        space -= 32768 >> code_len;
      }
    } else {
      var extra_bits = code_len - 14;
      var old_repeat;
      var repeat_delta;
      var new_len = 0;
      if (code_len === kCodeLengthRepeatCode) {
        new_len = prev_code_len;
      }
      if (repeat_code_len !== new_len) {
        repeat = 0;
        repeat_code_len = new_len;
      }
      old_repeat = repeat;
      if (repeat > 0) {
        repeat -= 2;
        repeat <<= extra_bits;
      }
      repeat += br.readBits(extra_bits) + 3;
      repeat_delta = repeat - old_repeat;
      if (symbol + repeat_delta > num_symbols) {
        throw new Error('[ReadHuffmanCodeLengths] symbol + repeat_delta > num_symbols');
      }
      
      for (var x = 0; x < repeat_delta; x++)
        code_lengths[symbol + x] = repeat_code_len;
      
      symbol += repeat_delta;
      
      if (repeat_code_len !== 0) {
        space -= repeat_delta << (15 - repeat_code_len);
      }
    }
  }
  if (space !== 0) {
    throw new Error("[ReadHuffmanCodeLengths] space = " + space);
  }
  
  for (; symbol < num_symbols; symbol++)
    code_lengths[symbol] = 0;
}

function ReadHuffmanCode(alphabet_size, tables, table, br) {
  var table_size = 0;
  var simple_code_or_skip;
  var code_lengths = new Uint8Array(alphabet_size);
  
  br.readMoreInput();
  
  /* simple_code_or_skip is used as follows:
     1 for simple code;
     0 for no skipping, 2 skips 2 code lengths, 3 skips 3 code lengths */
  simple_code_or_skip = br.readBits(2);
  if (simple_code_or_skip === 1) {
    /* Read symbols, codes & code lengths directly. */
    var i;
    var max_bits_counter = alphabet_size - 1;
    var max_bits = 0;
    var symbols = new Int32Array(4);
    var num_symbols = br.readBits(2) + 1;
    while (max_bits_counter) {
      max_bits_counter >>= 1;
      ++max_bits;
    }

    for (i = 0; i < num_symbols; ++i) {
      symbols[i] = br.readBits(max_bits) % alphabet_size;
      code_lengths[symbols[i]] = 2;
    }
    code_lengths[symbols[0]] = 1;
    switch (num_symbols) {
      case 1:
        break;
      case 3:
        if ((symbols[0] === symbols[1]) ||
            (symbols[0] === symbols[2]) ||
            (symbols[1] === symbols[2])) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        break;
      case 2:
        if (symbols[0] === symbols[1]) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        
        code_lengths[symbols[1]] = 1;
        break;
      case 4:
        if ((symbols[0] === symbols[1]) ||
            (symbols[0] === symbols[2]) ||
            (symbols[0] === symbols[3]) ||
            (symbols[1] === symbols[2]) ||
            (symbols[1] === symbols[3]) ||
            (symbols[2] === symbols[3])) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        
        if (br.readBits(1)) {
          code_lengths[symbols[2]] = 3;
          code_lengths[symbols[3]] = 3;
        } else {
          code_lengths[symbols[0]] = 2;
        }
        break;
    }
  } else {  /* Decode Huffman-coded code lengths. */
    var i;
    var code_length_code_lengths = new Uint8Array(CODE_LENGTH_CODES);
    var space = 32;
    var num_codes = 0;
    /* Static Huffman code for the code length code lengths */
    var huff = [
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(3, 2), 
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(4, 1),
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(3, 2), 
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(4, 5)
    ];
    for (i = simple_code_or_skip; i < CODE_LENGTH_CODES && space > 0; ++i) {
      var code_len_idx = kCodeLengthCodeOrder[i];
      var p = 0;
      var v;
      br.fillBitWindow();
      p += (br.val_ >>> br.bit_pos_) & 15;
      br.bit_pos_ += huff[p].bits;
      v = huff[p].value;
      code_length_code_lengths[code_len_idx] = v;
      if (v !== 0) {
        space -= (32 >> v);
        ++num_codes;
      }
    }
    
    if (!(num_codes === 1 || space === 0))
      throw new Error('[ReadHuffmanCode] invalid num_codes or space');
    
    ReadHuffmanCodeLengths(code_length_code_lengths, alphabet_size, code_lengths, br);
  }
  
  table_size = BrotliBuildHuffmanTable(tables, table, HUFFMAN_TABLE_BITS, code_lengths, alphabet_size);
  
  if (table_size === 0) {
    throw new Error("[ReadHuffmanCode] BuildHuffmanTable failed: ");
  }
  
  return table_size;
}

function ReadBlockLength(table, index, br) {
  var code;
  var nbits;
  code = ReadSymbol(table, index, br);
  nbits = Prefix.kBlockLengthPrefixCode[code].nbits;
  return Prefix.kBlockLengthPrefixCode[code].offset + br.readBits(nbits);
}

function TranslateShortCodes(code, ringbuffer, index) {
  var val;
  if (code < NUM_DISTANCE_SHORT_CODES) {
    index += kDistanceShortCodeIndexOffset[code];
    index &= 3;
    val = ringbuffer[index] + kDistanceShortCodeValueOffset[code];
  } else {
    val = code - NUM_DISTANCE_SHORT_CODES + 1;
  }
  return val;
}

function MoveToFront(v, index) {
  var value = v[index];
  var i = index;
  for (; i; --i) v[i] = v[i - 1];
  v[0] = value;
}

function InverseMoveToFrontTransform(v, v_len) {
  var mtf = new Uint8Array(256);
  var i;
  for (i = 0; i < 256; ++i) {
    mtf[i] = i;
  }
  for (i = 0; i < v_len; ++i) {
    var index = v[i];
    v[i] = mtf[index];
    if (index) MoveToFront(mtf, index);
  }
}

/* Contains a collection of huffman trees with the same alphabet size. */
function HuffmanTreeGroup(alphabet_size, num_htrees) {
  this.alphabet_size = alphabet_size;
  this.num_htrees = num_htrees;
  this.codes = new Array(num_htrees + num_htrees * kMaxHuffmanTableSize[(alphabet_size + 31) >>> 5]);  
  this.htrees = new Uint32Array(num_htrees);
}

HuffmanTreeGroup.prototype.decode = function(br) {
  var i;
  var table_size;
  var next = 0;
  for (i = 0; i < this.num_htrees; ++i) {
    this.htrees[i] = next;
    table_size = ReadHuffmanCode(this.alphabet_size, this.codes, next, br);
    next += table_size;
  }
};

function DecodeContextMap(context_map_size, br) {
  var out = { num_htrees: null, context_map: null };
  var use_rle_for_zeros;
  var max_run_length_prefix = 0;
  var table;
  var i;
  
  br.readMoreInput();
  var num_htrees = out.num_htrees = DecodeVarLenUint8(br) + 1;

  var context_map = out.context_map = new Uint8Array(context_map_size);
  if (num_htrees <= 1) {
    return out;
  }

  use_rle_for_zeros = br.readBits(1);
  if (use_rle_for_zeros) {
    max_run_length_prefix = br.readBits(4) + 1;
  }
  
  table = [];
  for (i = 0; i < HUFFMAN_MAX_TABLE_SIZE; i++) {
    table[i] = new HuffmanCode(0, 0);
  }
  
  ReadHuffmanCode(num_htrees + max_run_length_prefix, table, 0, br);
  
  for (i = 0; i < context_map_size;) {
    var code;

    br.readMoreInput();
    code = ReadSymbol(table, 0, br);
    if (code === 0) {
      context_map[i] = 0;
      ++i;
    } else if (code <= max_run_length_prefix) {
      var reps = 1 + (1 << code) + br.readBits(code);
      while (--reps) {
        if (i >= context_map_size) {
          throw new Error("[DecodeContextMap] i >= context_map_size");
        }
        context_map[i] = 0;
        ++i;
      }
    } else {
      context_map[i] = code - max_run_length_prefix;
      ++i;
    }
  }
  if (br.readBits(1)) {
    InverseMoveToFrontTransform(context_map, context_map_size);
  }
  
  return out;
}

function DecodeBlockType(max_block_type, trees, tree_type, block_types, ringbuffers, indexes, br) {
  var ringbuffer = tree_type * 2;
  var index = tree_type;
  var type_code = ReadSymbol(trees, tree_type * HUFFMAN_MAX_TABLE_SIZE, br);
  var block_type;
  if (type_code === 0) {
    block_type = ringbuffers[ringbuffer + (indexes[index] & 1)];
  } else if (type_code === 1) {
    block_type = ringbuffers[ringbuffer + ((indexes[index] - 1) & 1)] + 1;
  } else {
    block_type = type_code - 2;
  }
  if (block_type >= max_block_type) {
    block_type -= max_block_type;
  }
  block_types[tree_type] = block_type;
  ringbuffers[ringbuffer + (indexes[index] & 1)] = block_type;
  ++indexes[index];
}

function CopyUncompressedBlockToOutput(output, len, pos, ringbuffer, ringbuffer_mask, br) {
  var rb_size = ringbuffer_mask + 1;
  var rb_pos = pos & ringbuffer_mask;
  var br_pos = br.pos_ & BrotliBitReader.IBUF_MASK;
  var nbytes;

  /* For short lengths copy byte-by-byte */
  if (len < 8 || br.bit_pos_ + (len << 3) < br.bit_end_pos_) {
    while (len-- > 0) {
      br.readMoreInput();
      ringbuffer[rb_pos++] = br.readBits(8);
      if (rb_pos === rb_size) {
        output.write(ringbuffer, rb_size);
        rb_pos = 0;
      }
    }
    return;
  }

  if (br.bit_end_pos_ < 32) {
    throw new Error('[CopyUncompressedBlockToOutput] br.bit_end_pos_ < 32');
  }

  /* Copy remaining 0-4 bytes from br.val_ to ringbuffer. */
  while (br.bit_pos_ < 32) {
    ringbuffer[rb_pos] = (br.val_ >>> br.bit_pos_);
    br.bit_pos_ += 8;
    ++rb_pos;
    --len;
  }

  /* Copy remaining bytes from br.buf_ to ringbuffer. */
  nbytes = (br.bit_end_pos_ - br.bit_pos_) >> 3;
  if (br_pos + nbytes > BrotliBitReader.IBUF_MASK) {
    var tail = BrotliBitReader.IBUF_MASK + 1 - br_pos;
    for (var x = 0; x < tail; x++)
      ringbuffer[rb_pos + x] = br.buf_[br_pos + x];
    
    nbytes -= tail;
    rb_pos += tail;
    len -= tail;
    br_pos = 0;
  }

  for (var x = 0; x < nbytes; x++)
    ringbuffer[rb_pos + x] = br.buf_[br_pos + x];
  
  rb_pos += nbytes;
  len -= nbytes;

  /* If we wrote past the logical end of the ringbuffer, copy the tail of the
     ringbuffer to its beginning and flush the ringbuffer to the output. */
  if (rb_pos >= rb_size) {
    output.write(ringbuffer, rb_size);
    rb_pos -= rb_size;    
    for (var x = 0; x < rb_pos; x++)
      ringbuffer[x] = ringbuffer[rb_size + x];
  }

  /* If we have more to copy than the remaining size of the ringbuffer, then we
     first fill the ringbuffer from the input and then flush the ringbuffer to
     the output */
  while (rb_pos + len >= rb_size) {
    nbytes = rb_size - rb_pos;
    if (br.input_.read(ringbuffer, rb_pos, nbytes) < nbytes) {
      throw new Error('[CopyUncompressedBlockToOutput] not enough bytes');
    }
    output.write(ringbuffer, rb_size);
    len -= nbytes;
    rb_pos = 0;
  }

  /* Copy straight from the input onto the ringbuffer. The ringbuffer will be
     flushed to the output at a later time. */
  if (br.input_.read(ringbuffer, rb_pos, len) < len) {
    throw new Error('[CopyUncompressedBlockToOutput] not enough bytes');
  }

  /* Restore the state of the bit reader. */
  br.reset();
}

/* Advances the bit reader position to the next byte boundary and verifies
   that any skipped bits are set to zero. */
function JumpToByteBoundary(br) {
  var new_bit_pos = (br.bit_pos_ + 7) & ~7;
  var pad_bits = br.readBits(new_bit_pos - br.bit_pos_);
  return pad_bits == 0;
}

function BrotliDecompressedSize(buffer) {
  var input = new BrotliInput(buffer);
  var br = new BrotliBitReader(input);
  DecodeWindowBits(br);
  var out = DecodeMetaBlockLength(br);
  return out.meta_block_length;
}

__webpack_unused_export__ = BrotliDecompressedSize;

function BrotliDecompressBuffer(buffer, output_size) {
  var input = new BrotliInput(buffer);
  
  if (output_size == null) {
    output_size = BrotliDecompressedSize(buffer);
  }
  
  var output_buffer = new Uint8Array(output_size);
  var output = new BrotliOutput(output_buffer);
  
  BrotliDecompress(input, output);
  
  if (output.pos < output.buffer.length) {
    output.buffer = output.buffer.subarray(0, output.pos);
  }
  
  return output.buffer;
}

exports.BrotliDecompressBuffer = BrotliDecompressBuffer;

function BrotliDecompress(input, output) {
  var i;
  var pos = 0;
  var input_end = 0;
  var window_bits = 0;
  var max_backward_distance;
  var max_distance = 0;
  var ringbuffer_size;
  var ringbuffer_mask;
  var ringbuffer;
  var ringbuffer_end;
  /* This ring buffer holds a few past copy distances that will be used by */
  /* some special distance codes. */
  var dist_rb = [ 16, 15, 11, 4 ];
  var dist_rb_idx = 0;
  /* The previous 2 bytes used for context. */
  var prev_byte1 = 0;
  var prev_byte2 = 0;
  var hgroup = [new HuffmanTreeGroup(0, 0), new HuffmanTreeGroup(0, 0), new HuffmanTreeGroup(0, 0)];
  var block_type_trees;
  var block_len_trees;
  var br;

  /* We need the slack region for the following reasons:
       - always doing two 8-byte copies for fast backward copying
       - transforms
       - flushing the input ringbuffer when decoding uncompressed blocks */
  var kRingBufferWriteAheadSlack = 128 + BrotliBitReader.READ_SIZE;

  br = new BrotliBitReader(input);

  /* Decode window size. */
  window_bits = DecodeWindowBits(br);
  max_backward_distance = (1 << window_bits) - 16;

  ringbuffer_size = 1 << window_bits;
  ringbuffer_mask = ringbuffer_size - 1;
  ringbuffer = new Uint8Array(ringbuffer_size + kRingBufferWriteAheadSlack + BrotliDictionary.maxDictionaryWordLength);
  ringbuffer_end = ringbuffer_size;

  block_type_trees = [];
  block_len_trees = [];
  for (var x = 0; x < 3 * HUFFMAN_MAX_TABLE_SIZE; x++) {
    block_type_trees[x] = new HuffmanCode(0, 0);
    block_len_trees[x] = new HuffmanCode(0, 0);
  }

  while (!input_end) {
    var meta_block_remaining_len = 0;
    var is_uncompressed;
    var block_length = [ 1 << 28, 1 << 28, 1 << 28 ];
    var block_type = [ 0 ];
    var num_block_types = [ 1, 1, 1 ];
    var block_type_rb = [ 0, 1, 0, 1, 0, 1 ];
    var block_type_rb_index = [ 0 ];
    var distance_postfix_bits;
    var num_direct_distance_codes;
    var distance_postfix_mask;
    var num_distance_codes;
    var context_map = null;
    var context_modes = null;
    var num_literal_htrees;
    var dist_context_map = null;
    var num_dist_htrees;
    var context_offset = 0;
    var context_map_slice = null;
    var literal_htree_index = 0;
    var dist_context_offset = 0;
    var dist_context_map_slice = null;
    var dist_htree_index = 0;
    var context_lookup_offset1 = 0;
    var context_lookup_offset2 = 0;
    var context_mode;
    var htree_command;

    for (i = 0; i < 3; ++i) {
      hgroup[i].codes = null;
      hgroup[i].htrees = null;
    }

    br.readMoreInput();
    
    var _out = DecodeMetaBlockLength(br);
    meta_block_remaining_len = _out.meta_block_length;
    if (pos + meta_block_remaining_len > output.buffer.length) {
      /* We need to grow the output buffer to fit the additional data. */
      var tmp = new Uint8Array( pos + meta_block_remaining_len );
      tmp.set( output.buffer );
      output.buffer = tmp;
    }    
    input_end = _out.input_end;
    is_uncompressed = _out.is_uncompressed;
    
    if (_out.is_metadata) {
      JumpToByteBoundary(br);
      
      for (; meta_block_remaining_len > 0; --meta_block_remaining_len) {
        br.readMoreInput();
        /* Read one byte and ignore it. */
        br.readBits(8);
      }
      
      continue;
    }
    
    if (meta_block_remaining_len === 0) {
      continue;
    }
    
    if (is_uncompressed) {
      br.bit_pos_ = (br.bit_pos_ + 7) & ~7;
      CopyUncompressedBlockToOutput(output, meta_block_remaining_len, pos,
                                    ringbuffer, ringbuffer_mask, br);
      pos += meta_block_remaining_len;
      continue;
    }
    
    for (i = 0; i < 3; ++i) {
      num_block_types[i] = DecodeVarLenUint8(br) + 1;
      if (num_block_types[i] >= 2) {
        ReadHuffmanCode(num_block_types[i] + 2, block_type_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        ReadHuffmanCode(kNumBlockLengthCodes, block_len_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        block_length[i] = ReadBlockLength(block_len_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        block_type_rb_index[i] = 1;
      }
    }
    
    br.readMoreInput();
    
    distance_postfix_bits = br.readBits(2);
    num_direct_distance_codes = NUM_DISTANCE_SHORT_CODES + (br.readBits(4) << distance_postfix_bits);
    distance_postfix_mask = (1 << distance_postfix_bits) - 1;
    num_distance_codes = (num_direct_distance_codes + (48 << distance_postfix_bits));
    context_modes = new Uint8Array(num_block_types[0]);

    for (i = 0; i < num_block_types[0]; ++i) {
       br.readMoreInput();
       context_modes[i] = (br.readBits(2) << 1);
    }
    
    var _o1 = DecodeContextMap(num_block_types[0] << kLiteralContextBits, br);
    num_literal_htrees = _o1.num_htrees;
    context_map = _o1.context_map;
    
    var _o2 = DecodeContextMap(num_block_types[2] << kDistanceContextBits, br);
    num_dist_htrees = _o2.num_htrees;
    dist_context_map = _o2.context_map;
    
    hgroup[0] = new HuffmanTreeGroup(kNumLiteralCodes, num_literal_htrees);
    hgroup[1] = new HuffmanTreeGroup(kNumInsertAndCopyCodes, num_block_types[1]);
    hgroup[2] = new HuffmanTreeGroup(num_distance_codes, num_dist_htrees);

    for (i = 0; i < 3; ++i) {
      hgroup[i].decode(br);
    }

    context_map_slice = 0;
    dist_context_map_slice = 0;
    context_mode = context_modes[block_type[0]];
    context_lookup_offset1 = Context.lookupOffsets[context_mode];
    context_lookup_offset2 = Context.lookupOffsets[context_mode + 1];
    htree_command = hgroup[1].htrees[0];

    while (meta_block_remaining_len > 0) {
      var cmd_code;
      var range_idx;
      var insert_code;
      var copy_code;
      var insert_length;
      var copy_length;
      var distance_code;
      var distance;
      var context;
      var j;
      var copy_dst;

      br.readMoreInput();
      
      if (block_length[1] === 0) {
        DecodeBlockType(num_block_types[1],
                        block_type_trees, 1, block_type, block_type_rb,
                        block_type_rb_index, br);
        block_length[1] = ReadBlockLength(block_len_trees, HUFFMAN_MAX_TABLE_SIZE, br);
        htree_command = hgroup[1].htrees[block_type[1]];
      }
      --block_length[1];
      cmd_code = ReadSymbol(hgroup[1].codes, htree_command, br);
      range_idx = cmd_code >> 6;
      if (range_idx >= 2) {
        range_idx -= 2;
        distance_code = -1;
      } else {
        distance_code = 0;
      }
      insert_code = Prefix.kInsertRangeLut[range_idx] + ((cmd_code >> 3) & 7);
      copy_code = Prefix.kCopyRangeLut[range_idx] + (cmd_code & 7);
      insert_length = Prefix.kInsertLengthPrefixCode[insert_code].offset +
          br.readBits(Prefix.kInsertLengthPrefixCode[insert_code].nbits);
      copy_length = Prefix.kCopyLengthPrefixCode[copy_code].offset +
          br.readBits(Prefix.kCopyLengthPrefixCode[copy_code].nbits);
      prev_byte1 = ringbuffer[pos-1 & ringbuffer_mask];
      prev_byte2 = ringbuffer[pos-2 & ringbuffer_mask];
      for (j = 0; j < insert_length; ++j) {
        br.readMoreInput();

        if (block_length[0] === 0) {
          DecodeBlockType(num_block_types[0],
                          block_type_trees, 0, block_type, block_type_rb,
                          block_type_rb_index, br);
          block_length[0] = ReadBlockLength(block_len_trees, 0, br);
          context_offset = block_type[0] << kLiteralContextBits;
          context_map_slice = context_offset;
          context_mode = context_modes[block_type[0]];
          context_lookup_offset1 = Context.lookupOffsets[context_mode];
          context_lookup_offset2 = Context.lookupOffsets[context_mode + 1];
        }
        context = (Context.lookup[context_lookup_offset1 + prev_byte1] |
                   Context.lookup[context_lookup_offset2 + prev_byte2]);
        literal_htree_index = context_map[context_map_slice + context];
        --block_length[0];
        prev_byte2 = prev_byte1;
        prev_byte1 = ReadSymbol(hgroup[0].codes, hgroup[0].htrees[literal_htree_index], br);
        ringbuffer[pos & ringbuffer_mask] = prev_byte1;
        if ((pos & ringbuffer_mask) === ringbuffer_mask) {
          output.write(ringbuffer, ringbuffer_size);
        }
        ++pos;
      }
      meta_block_remaining_len -= insert_length;
      if (meta_block_remaining_len <= 0) break;

      if (distance_code < 0) {
        var context;
        
        br.readMoreInput();
        if (block_length[2] === 0) {
          DecodeBlockType(num_block_types[2],
                          block_type_trees, 2, block_type, block_type_rb,
                          block_type_rb_index, br);
          block_length[2] = ReadBlockLength(block_len_trees, 2 * HUFFMAN_MAX_TABLE_SIZE, br);
          dist_context_offset = block_type[2] << kDistanceContextBits;
          dist_context_map_slice = dist_context_offset;
        }
        --block_length[2];
        context = (copy_length > 4 ? 3 : copy_length - 2) & 0xff;
        dist_htree_index = dist_context_map[dist_context_map_slice + context];
        distance_code = ReadSymbol(hgroup[2].codes, hgroup[2].htrees[dist_htree_index], br);
        if (distance_code >= num_direct_distance_codes) {
          var nbits;
          var postfix;
          var offset;
          distance_code -= num_direct_distance_codes;
          postfix = distance_code & distance_postfix_mask;
          distance_code >>= distance_postfix_bits;
          nbits = (distance_code >> 1) + 1;
          offset = ((2 + (distance_code & 1)) << nbits) - 4;
          distance_code = num_direct_distance_codes +
              ((offset + br.readBits(nbits)) <<
               distance_postfix_bits) + postfix;
        }
      }

      /* Convert the distance code to the actual distance by possibly looking */
      /* up past distnaces from the ringbuffer. */
      distance = TranslateShortCodes(distance_code, dist_rb, dist_rb_idx);
      if (distance < 0) {
        throw new Error('[BrotliDecompress] invalid distance');
      }

      if (pos < max_backward_distance &&
          max_distance !== max_backward_distance) {
        max_distance = pos;
      } else {
        max_distance = max_backward_distance;
      }

      copy_dst = pos & ringbuffer_mask;

      if (distance > max_distance) {
        if (copy_length >= BrotliDictionary.minDictionaryWordLength &&
            copy_length <= BrotliDictionary.maxDictionaryWordLength) {
          var offset = BrotliDictionary.offsetsByLength[copy_length];
          var word_id = distance - max_distance - 1;
          var shift = BrotliDictionary.sizeBitsByLength[copy_length];
          var mask = (1 << shift) - 1;
          var word_idx = word_id & mask;
          var transform_idx = word_id >> shift;
          offset += word_idx * copy_length;
          if (transform_idx < Transform.kNumTransforms) {
            var len = Transform.transformDictionaryWord(ringbuffer, copy_dst, offset, copy_length, transform_idx);
            copy_dst += len;
            pos += len;
            meta_block_remaining_len -= len;
            if (copy_dst >= ringbuffer_end) {
              output.write(ringbuffer, ringbuffer_size);
              
              for (var _x = 0; _x < (copy_dst - ringbuffer_end); _x++)
                ringbuffer[_x] = ringbuffer[ringbuffer_end + _x];
            }
          } else {
            throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
              " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
          }
        } else {
          throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
            " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
        }
      } else {
        if (distance_code > 0) {
          dist_rb[dist_rb_idx & 3] = distance;
          ++dist_rb_idx;
        }

        if (copy_length > meta_block_remaining_len) {
          throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
            " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
        }

        for (j = 0; j < copy_length; ++j) {
          ringbuffer[pos & ringbuffer_mask] = ringbuffer[(pos - distance) & ringbuffer_mask];
          if ((pos & ringbuffer_mask) === ringbuffer_mask) {
            output.write(ringbuffer, ringbuffer_size);
          }
          ++pos;
          --meta_block_remaining_len;
        }
      }

      /* When we get here, we must have inserted at least one literal and */
      /* made a copy of at least length two, therefore accessing the last 2 */
      /* bytes is valid. */
      prev_byte1 = ringbuffer[(pos - 1) & ringbuffer_mask];
      prev_byte2 = ringbuffer[(pos - 2) & ringbuffer_mask];
    }

    /* Protect pos from overflow, wrap it around at every GB of input data */
    pos &= 0x3fffffff;
  }

  output.write(ringbuffer, pos & ringbuffer_mask);
}

__webpack_unused_export__ = BrotliDecompress;

BrotliDictionary.init();


/***/ }),

/***/ 613:
/***/ ((__unused_webpack_module, exports) => {

/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Collection of static dictionary words.
*/

exports.dictionary = new Uint8Array([
  0x74, 0x69, 0x6d, 0x65, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x66, 0x65, 0x6c,
  0x65, 0x66, 0x74, 0x62, 0x61, 0x63, 0x6b, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x61,
  0x74, 0x61, 0x73, 0x68, 0x6f, 0x77, 0x6f, 0x6e, 0x6c, 0x79, 0x73, 0x69, 0x74,
  0x65, 0x63, 0x69, 0x74, 0x79, 0x6f, 0x70, 0x65, 0x6e, 0x6a, 0x75, 0x73, 0x74,
  0x6c, 0x69, 0x6b, 0x65, 0x66, 0x72, 0x65, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x74,
  0x65, 0x78, 0x74, 0x79, 0x65, 0x61, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x62, 0x6f,
  0x64, 0x79, 0x6c, 0x6f, 0x76, 0x65, 0x66, 0x6f, 0x72, 0x6d, 0x62, 0x6f, 0x6f,
  0x6b, 0x70, 0x6c, 0x61, 0x79, 0x6c, 0x69, 0x76, 0x65, 0x6c, 0x69, 0x6e, 0x65,
  0x68, 0x65, 0x6c, 0x70, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6d,
  0x6f, 0x72, 0x65, 0x77, 0x6f, 0x72, 0x64, 0x6c, 0x6f, 0x6e, 0x67, 0x74, 0x68,
  0x65, 0x6d, 0x76, 0x69, 0x65, 0x77, 0x66, 0x69, 0x6e, 0x64, 0x70, 0x61, 0x67,
  0x65, 0x64, 0x61, 0x79, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x68, 0x65, 0x61, 0x64,
  0x74, 0x65, 0x72, 0x6d, 0x65, 0x61, 0x63, 0x68, 0x61, 0x72, 0x65, 0x61, 0x66,
  0x72, 0x6f, 0x6d, 0x74, 0x72, 0x75, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x62,
  0x6c, 0x65, 0x75, 0x70, 0x6f, 0x6e, 0x68, 0x69, 0x67, 0x68, 0x64, 0x61, 0x74,
  0x65, 0x6c, 0x61, 0x6e, 0x64, 0x6e, 0x65, 0x77, 0x73, 0x65, 0x76, 0x65, 0x6e,
  0x6e, 0x65, 0x78, 0x74, 0x63, 0x61, 0x73, 0x65, 0x62, 0x6f, 0x74, 0x68, 0x70,
  0x6f, 0x73, 0x74, 0x75, 0x73, 0x65, 0x64, 0x6d, 0x61, 0x64, 0x65, 0x68, 0x61,
  0x6e, 0x64, 0x68, 0x65, 0x72, 0x65, 0x77, 0x68, 0x61, 0x74, 0x6e, 0x61, 0x6d,
  0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x62, 0x6c, 0x6f, 0x67, 0x73, 0x69, 0x7a, 0x65,
  0x62, 0x61, 0x73, 0x65, 0x68, 0x65, 0x6c, 0x64, 0x6d, 0x61, 0x6b, 0x65, 0x6d,
  0x61, 0x69, 0x6e, 0x75, 0x73, 0x65, 0x72, 0x27, 0x29, 0x20, 0x2b, 0x68, 0x6f,
  0x6c, 0x64, 0x65, 0x6e, 0x64, 0x73, 0x77, 0x69, 0x74, 0x68, 0x4e, 0x65, 0x77,
  0x73, 0x72, 0x65, 0x61, 0x64, 0x77, 0x65, 0x72, 0x65, 0x73, 0x69, 0x67, 0x6e,
  0x74, 0x61, 0x6b, 0x65, 0x68, 0x61, 0x76, 0x65, 0x67, 0x61, 0x6d, 0x65, 0x73,
  0x65, 0x65, 0x6e, 0x63, 0x61, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68, 0x77, 0x65,
  0x6c, 0x6c, 0x70, 0x6c, 0x75, 0x73, 0x6d, 0x65, 0x6e, 0x75, 0x66, 0x69, 0x6c,
  0x6d, 0x70, 0x61, 0x72, 0x74, 0x6a, 0x6f, 0x69, 0x6e, 0x74, 0x68, 0x69, 0x73,
  0x6c, 0x69, 0x73, 0x74, 0x67, 0x6f, 0x6f, 0x64, 0x6e, 0x65, 0x65, 0x64, 0x77,
  0x61, 0x79, 0x73, 0x77, 0x65, 0x73, 0x74, 0x6a, 0x6f, 0x62, 0x73, 0x6d, 0x69,
  0x6e, 0x64, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x6f, 0x67, 0x6f, 0x72, 0x69, 0x63,
  0x68, 0x75, 0x73, 0x65, 0x73, 0x6c, 0x61, 0x73, 0x74, 0x74, 0x65, 0x61, 0x6d,
  0x61, 0x72, 0x6d, 0x79, 0x66, 0x6f, 0x6f, 0x64, 0x6b, 0x69, 0x6e, 0x67, 0x77,
  0x69, 0x6c, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x77, 0x61, 0x72, 0x64, 0x62, 0x65,
  0x73, 0x74, 0x66, 0x69, 0x72, 0x65, 0x50, 0x61, 0x67, 0x65, 0x6b, 0x6e, 0x6f,
  0x77, 0x61, 0x77, 0x61, 0x79, 0x2e, 0x70, 0x6e, 0x67, 0x6d, 0x6f, 0x76, 0x65,
  0x74, 0x68, 0x61, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x67, 0x69, 0x76, 0x65, 0x73,
  0x65, 0x6c, 0x66, 0x6e, 0x6f, 0x74, 0x65, 0x6d, 0x75, 0x63, 0x68, 0x66, 0x65,
  0x65, 0x64, 0x6d, 0x61, 0x6e, 0x79, 0x72, 0x6f, 0x63, 0x6b, 0x69, 0x63, 0x6f,
  0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x6c, 0x6f, 0x6f, 0x6b, 0x68, 0x69, 0x64, 0x65,
  0x64, 0x69, 0x65, 0x64, 0x48, 0x6f, 0x6d, 0x65, 0x72, 0x75, 0x6c, 0x65, 0x68,
  0x6f, 0x73, 0x74, 0x61, 0x6a, 0x61, 0x78, 0x69, 0x6e, 0x66, 0x6f, 0x63, 0x6c,
  0x75, 0x62, 0x6c, 0x61, 0x77, 0x73, 0x6c, 0x65, 0x73, 0x73, 0x68, 0x61, 0x6c,
  0x66, 0x73, 0x6f, 0x6d, 0x65, 0x73, 0x75, 0x63, 0x68, 0x7a, 0x6f, 0x6e, 0x65,
  0x31, 0x30, 0x30, 0x25, 0x6f, 0x6e, 0x65, 0x73, 0x63, 0x61, 0x72, 0x65, 0x54,
  0x69, 0x6d, 0x65, 0x72, 0x61, 0x63, 0x65, 0x62, 0x6c, 0x75, 0x65, 0x66, 0x6f,
  0x75, 0x72, 0x77, 0x65, 0x65, 0x6b, 0x66, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x70,
  0x65, 0x67, 0x61, 0x76, 0x65, 0x68, 0x61, 0x72, 0x64, 0x6c, 0x6f, 0x73, 0x74,
  0x77, 0x68, 0x65, 0x6e, 0x70, 0x61, 0x72, 0x6b, 0x6b, 0x65, 0x70, 0x74, 0x70,
  0x61, 0x73, 0x73, 0x73, 0x68, 0x69, 0x70, 0x72, 0x6f, 0x6f, 0x6d, 0x48, 0x54,
  0x4d, 0x4c, 0x70, 0x6c, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x6f, 0x6e,
  0x65, 0x73, 0x61, 0x76, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x66, 0x6c, 0x61, 0x67,
  0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x6f, 0x6c, 0x64, 0x66, 0x69, 0x76, 0x65, 0x74,
  0x6f, 0x6f, 0x6b, 0x72, 0x61, 0x74, 0x65, 0x74, 0x6f, 0x77, 0x6e, 0x6a, 0x75,
  0x6d, 0x70, 0x74, 0x68, 0x75, 0x73, 0x64, 0x61, 0x72, 0x6b, 0x63, 0x61, 0x72,
  0x64, 0x66, 0x69, 0x6c, 0x65, 0x66, 0x65, 0x61, 0x72, 0x73, 0x74, 0x61, 0x79,
  0x6b, 0x69, 0x6c, 0x6c, 0x74, 0x68, 0x61, 0x74, 0x66, 0x61, 0x6c, 0x6c, 0x61,
  0x75, 0x74, 0x6f, 0x65, 0x76, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x6d, 0x74, 0x61,
  0x6c, 0x6b, 0x73, 0x68, 0x6f, 0x70, 0x76, 0x6f, 0x74, 0x65, 0x64, 0x65, 0x65,
  0x70, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x65, 0x73, 0x74, 0x74, 0x75, 0x72, 0x6e,
  0x62, 0x6f, 0x72, 0x6e, 0x62, 0x61, 0x6e, 0x64, 0x66, 0x65, 0x6c, 0x6c, 0x72,
  0x6f, 0x73, 0x65, 0x75, 0x72, 0x6c, 0x28, 0x73, 0x6b, 0x69, 0x6e, 0x72, 0x6f,
  0x6c, 0x65, 0x63, 0x6f, 0x6d, 0x65, 0x61, 0x63, 0x74, 0x73, 0x61, 0x67, 0x65,
  0x73, 0x6d, 0x65, 0x65, 0x74, 0x67, 0x6f, 0x6c, 0x64, 0x2e, 0x6a, 0x70, 0x67,
  0x69, 0x74, 0x65, 0x6d, 0x76, 0x61, 0x72, 0x79, 0x66, 0x65, 0x6c, 0x74, 0x74,
  0x68, 0x65, 0x6e, 0x73, 0x65, 0x6e, 0x64, 0x64, 0x72, 0x6f, 0x70, 0x56, 0x69,
  0x65, 0x77, 0x63, 0x6f, 0x70, 0x79, 0x31, 0x2e, 0x30, 0x22, 0x3c, 0x2f, 0x61,
  0x3e, 0x73, 0x74, 0x6f, 0x70, 0x65, 0x6c, 0x73, 0x65, 0x6c, 0x69, 0x65, 0x73,
  0x74, 0x6f, 0x75, 0x72, 0x70, 0x61, 0x63, 0x6b, 0x2e, 0x67, 0x69, 0x66, 0x70,
  0x61, 0x73, 0x74, 0x63, 0x73, 0x73, 0x3f, 0x67, 0x72, 0x61, 0x79, 0x6d, 0x65,
  0x61, 0x6e, 0x26, 0x67, 0x74, 0x3b, 0x72, 0x69, 0x64, 0x65, 0x73, 0x68, 0x6f,
  0x74, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x61, 0x69, 0x64, 0x72, 0x6f, 0x61, 0x64,
  0x76, 0x61, 0x72, 0x20, 0x66, 0x65, 0x65, 0x6c, 0x6a, 0x6f, 0x68, 0x6e, 0x72,
  0x69, 0x63, 0x6b, 0x70, 0x6f, 0x72, 0x74, 0x66, 0x61, 0x73, 0x74, 0x27, 0x55,
  0x41, 0x2d, 0x64, 0x65, 0x61, 0x64, 0x3c, 0x2f, 0x62, 0x3e, 0x70, 0x6f, 0x6f,
  0x72, 0x62, 0x69, 0x6c, 0x6c, 0x74, 0x79, 0x70, 0x65, 0x55, 0x2e, 0x53, 0x2e,
  0x77, 0x6f, 0x6f, 0x64, 0x6d, 0x75, 0x73, 0x74, 0x32, 0x70, 0x78, 0x3b, 0x49,
  0x6e, 0x66, 0x6f, 0x72, 0x61, 0x6e, 0x6b, 0x77, 0x69, 0x64, 0x65, 0x77, 0x61,
  0x6e, 0x74, 0x77, 0x61, 0x6c, 0x6c, 0x6c, 0x65, 0x61, 0x64, 0x5b, 0x30, 0x5d,
  0x3b, 0x70, 0x61, 0x75, 0x6c, 0x77, 0x61, 0x76, 0x65, 0x73, 0x75, 0x72, 0x65,
  0x24, 0x28, 0x27, 0x23, 0x77, 0x61, 0x69, 0x74, 0x6d, 0x61, 0x73, 0x73, 0x61,
  0x72, 0x6d, 0x73, 0x67, 0x6f, 0x65, 0x73, 0x67, 0x61, 0x69, 0x6e, 0x6c, 0x61,
  0x6e, 0x67, 0x70, 0x61, 0x69, 0x64, 0x21, 0x2d, 0x2d, 0x20, 0x6c, 0x6f, 0x63,
  0x6b, 0x75, 0x6e, 0x69, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x77, 0x61, 0x6c, 0x6b,
  0x66, 0x69, 0x72, 0x6d, 0x77, 0x69, 0x66, 0x65, 0x78, 0x6d, 0x6c, 0x22, 0x73,
  0x6f, 0x6e, 0x67, 0x74, 0x65, 0x73, 0x74, 0x32, 0x30, 0x70, 0x78, 0x6b, 0x69,
  0x6e, 0x64, 0x72, 0x6f, 0x77, 0x73, 0x74, 0x6f, 0x6f, 0x6c, 0x66, 0x6f, 0x6e,
  0x74, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x61, 0x66, 0x65, 0x73, 0x74, 0x61, 0x72,
  0x6d, 0x61, 0x70, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x61, 0x69, 0x6e, 0x66,
  0x6c, 0x6f, 0x77, 0x62, 0x61, 0x62, 0x79, 0x73, 0x70, 0x61, 0x6e, 0x73, 0x61,
  0x79, 0x73, 0x34, 0x70, 0x78, 0x3b, 0x36, 0x70, 0x78, 0x3b, 0x61, 0x72, 0x74,
  0x73, 0x66, 0x6f, 0x6f, 0x74, 0x72, 0x65, 0x61, 0x6c, 0x77, 0x69, 0x6b, 0x69,
  0x68, 0x65, 0x61, 0x74, 0x73, 0x74, 0x65, 0x70, 0x74, 0x72, 0x69, 0x70, 0x6f,
  0x72, 0x67, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x77, 0x65, 0x61, 0x6b, 0x74, 0x6f,
  0x6c, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x63, 0x61, 0x73, 0x74, 0x66, 0x61, 0x6e,
  0x73, 0x62, 0x61, 0x6e, 0x6b, 0x76, 0x65, 0x72, 0x79, 0x72, 0x75, 0x6e, 0x73,
  0x6a, 0x75, 0x6c, 0x79, 0x74, 0x61, 0x73, 0x6b, 0x31, 0x70, 0x78, 0x3b, 0x67,
  0x6f, 0x61, 0x6c, 0x67, 0x72, 0x65, 0x77, 0x73, 0x6c, 0x6f, 0x77, 0x65, 0x64,
  0x67, 0x65, 0x69, 0x64, 0x3d, 0x22, 0x73, 0x65, 0x74, 0x73, 0x35, 0x70, 0x78,
  0x3b, 0x2e, 0x6a, 0x73, 0x3f, 0x34, 0x30, 0x70, 0x78, 0x69, 0x66, 0x20, 0x28,
  0x73, 0x6f, 0x6f, 0x6e, 0x73, 0x65, 0x61, 0x74, 0x6e, 0x6f, 0x6e, 0x65, 0x74,
  0x75, 0x62, 0x65, 0x7a, 0x65, 0x72, 0x6f, 0x73, 0x65, 0x6e, 0x74, 0x72, 0x65,
  0x65, 0x64, 0x66, 0x61, 0x63, 0x74, 0x69, 0x6e, 0x74, 0x6f, 0x67, 0x69, 0x66,
  0x74, 0x68, 0x61, 0x72, 0x6d, 0x31, 0x38, 0x70, 0x78, 0x63, 0x61, 0x6d, 0x65,
  0x68, 0x69, 0x6c, 0x6c, 0x62, 0x6f, 0x6c, 0x64, 0x7a, 0x6f, 0x6f, 0x6d, 0x76,
  0x6f, 0x69, 0x64, 0x65, 0x61, 0x73, 0x79, 0x72, 0x69, 0x6e, 0x67, 0x66, 0x69,
  0x6c, 0x6c, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x69, 0x74, 0x63, 0x6f, 0x73,
  0x74, 0x33, 0x70, 0x78, 0x3b, 0x6a, 0x61, 0x63, 0x6b, 0x74, 0x61, 0x67, 0x73,
  0x62, 0x69, 0x74, 0x73, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x69, 0x74, 0x6b,
  0x6e, 0x65, 0x77, 0x6e, 0x65, 0x61, 0x72, 0x3c, 0x21, 0x2d, 0x2d, 0x67, 0x72,
  0x6f, 0x77, 0x4a, 0x53, 0x4f, 0x4e, 0x64, 0x75, 0x74, 0x79, 0x4e, 0x61, 0x6d,
  0x65, 0x73, 0x61, 0x6c, 0x65, 0x79, 0x6f, 0x75, 0x20, 0x6c, 0x6f, 0x74, 0x73,
  0x70, 0x61, 0x69, 0x6e, 0x6a, 0x61, 0x7a, 0x7a, 0x63, 0x6f, 0x6c, 0x64, 0x65,
  0x79, 0x65, 0x73, 0x66, 0x69, 0x73, 0x68, 0x77, 0x77, 0x77, 0x2e, 0x72, 0x69,
  0x73, 0x6b, 0x74, 0x61, 0x62, 0x73, 0x70, 0x72, 0x65, 0x76, 0x31, 0x30, 0x70,
  0x78, 0x72, 0x69, 0x73, 0x65, 0x32, 0x35, 0x70, 0x78, 0x42, 0x6c, 0x75, 0x65,
  0x64, 0x69, 0x6e, 0x67, 0x33, 0x30, 0x30, 0x2c, 0x62, 0x61, 0x6c, 0x6c, 0x66,
  0x6f, 0x72, 0x64, 0x65, 0x61, 0x72, 0x6e, 0x77, 0x69, 0x6c, 0x64, 0x62, 0x6f,
  0x78, 0x2e, 0x66, 0x61, 0x69, 0x72, 0x6c, 0x61, 0x63, 0x6b, 0x76, 0x65, 0x72,
  0x73, 0x70, 0x61, 0x69, 0x72, 0x6a, 0x75, 0x6e, 0x65, 0x74, 0x65, 0x63, 0x68,
  0x69, 0x66, 0x28, 0x21, 0x70, 0x69, 0x63, 0x6b, 0x65, 0x76, 0x69, 0x6c, 0x24,
  0x28, 0x22, 0x23, 0x77, 0x61, 0x72, 0x6d, 0x6c, 0x6f, 0x72, 0x64, 0x64, 0x6f,
  0x65, 0x73, 0x70, 0x75, 0x6c, 0x6c, 0x2c, 0x30, 0x30, 0x30, 0x69, 0x64, 0x65,
  0x61, 0x64, 0x72, 0x61, 0x77, 0x68, 0x75, 0x67, 0x65, 0x73, 0x70, 0x6f, 0x74,
  0x66, 0x75, 0x6e, 0x64, 0x62, 0x75, 0x72, 0x6e, 0x68, 0x72, 0x65, 0x66, 0x63,
  0x65, 0x6c, 0x6c, 0x6b, 0x65, 0x79, 0x73, 0x74, 0x69, 0x63, 0x6b, 0x68, 0x6f,
  0x75, 0x72, 0x6c, 0x6f, 0x73, 0x73, 0x66, 0x75, 0x65, 0x6c, 0x31, 0x32, 0x70,
  0x78, 0x73, 0x75, 0x69, 0x74, 0x64, 0x65, 0x61, 0x6c, 0x52, 0x53, 0x53, 0x22,
  0x61, 0x67, 0x65, 0x64, 0x67, 0x72, 0x65, 0x79, 0x47, 0x45, 0x54, 0x22, 0x65,
  0x61, 0x73, 0x65, 0x61, 0x69, 0x6d, 0x73, 0x67, 0x69, 0x72, 0x6c, 0x61, 0x69,
  0x64, 0x73, 0x38, 0x70, 0x78, 0x3b, 0x6e, 0x61, 0x76, 0x79, 0x67, 0x72, 0x69,
  0x64, 0x74, 0x69, 0x70, 0x73, 0x23, 0x39, 0x39, 0x39, 0x77, 0x61, 0x72, 0x73,
  0x6c, 0x61, 0x64, 0x79, 0x63, 0x61, 0x72, 0x73, 0x29, 0x3b, 0x20, 0x7d, 0x70,
  0x68, 0x70, 0x3f, 0x68, 0x65, 0x6c, 0x6c, 0x74, 0x61, 0x6c, 0x6c, 0x77, 0x68,
  0x6f, 0x6d, 0x7a, 0x68, 0x3a, 0xe5, 0x2a, 0x2f, 0x0d, 0x0a, 0x20, 0x31, 0x30,
  0x30, 0x68, 0x61, 0x6c, 0x6c, 0x2e, 0x0a, 0x0a, 0x41, 0x37, 0x70, 0x78, 0x3b,
  0x70, 0x75, 0x73, 0x68, 0x63, 0x68, 0x61, 0x74, 0x30, 0x70, 0x78, 0x3b, 0x63,
  0x72, 0x65, 0x77, 0x2a, 0x2f, 0x3c, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x37, 0x35,
  0x70, 0x78, 0x66, 0x6c, 0x61, 0x74, 0x72, 0x61, 0x72, 0x65, 0x20, 0x26, 0x26,
  0x20, 0x74, 0x65, 0x6c, 0x6c, 0x63, 0x61, 0x6d, 0x70, 0x6f, 0x6e, 0x74, 0x6f,
  0x6c, 0x61, 0x69, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x73, 0x6b, 0x69, 0x70, 0x74,
  0x65, 0x6e, 0x74, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x61, 0x6c, 0x65, 0x67, 0x65,
  0x74, 0x73, 0x70, 0x6c, 0x6f, 0x74, 0x34, 0x30, 0x30, 0x2c, 0x0d, 0x0a, 0x0d,
  0x0a, 0x63, 0x6f, 0x6f, 0x6c, 0x66, 0x65, 0x65, 0x74, 0x2e, 0x70, 0x68, 0x70,
  0x3c, 0x62, 0x72, 0x3e, 0x65, 0x72, 0x69, 0x63, 0x6d, 0x6f, 0x73, 0x74, 0x67,
  0x75, 0x69, 0x64, 0x62, 0x65, 0x6c, 0x6c, 0x64, 0x65, 0x73, 0x63, 0x68, 0x61,
  0x69, 0x72, 0x6d, 0x61, 0x74, 0x68, 0x61, 0x74, 0x6f, 0x6d, 0x2f, 0x69, 0x6d,
  0x67, 0x26, 0x23, 0x38, 0x32, 0x6c, 0x75, 0x63, 0x6b, 0x63, 0x65, 0x6e, 0x74,
  0x30, 0x30, 0x30, 0x3b, 0x74, 0x69, 0x6e, 0x79, 0x67, 0x6f, 0x6e, 0x65, 0x68,
  0x74, 0x6d, 0x6c, 0x73, 0x65, 0x6c, 0x6c, 0x64, 0x72, 0x75, 0x67, 0x46, 0x52,
  0x45, 0x45, 0x6e, 0x6f, 0x64, 0x65, 0x6e, 0x69, 0x63, 0x6b, 0x3f, 0x69, 0x64,
  0x3d, 0x6c, 0x6f, 0x73, 0x65, 0x6e, 0x75, 0x6c, 0x6c, 0x76, 0x61, 0x73, 0x74,
  0x77, 0x69, 0x6e, 0x64, 0x52, 0x53, 0x53, 0x20, 0x77, 0x65, 0x61, 0x72, 0x72,
  0x65, 0x6c, 0x79, 0x62, 0x65, 0x65, 0x6e, 0x73, 0x61, 0x6d, 0x65, 0x64, 0x75,
  0x6b, 0x65, 0x6e, 0x61, 0x73, 0x61, 0x63, 0x61, 0x70, 0x65, 0x77, 0x69, 0x73,
  0x68, 0x67, 0x75, 0x6c, 0x66, 0x54, 0x32, 0x33, 0x3a, 0x68, 0x69, 0x74, 0x73,
  0x73, 0x6c, 0x6f, 0x74, 0x67, 0x61, 0x74, 0x65, 0x6b, 0x69, 0x63, 0x6b, 0x62,
  0x6c, 0x75, 0x72, 0x74, 0x68, 0x65, 0x79, 0x31, 0x35, 0x70, 0x78, 0x27, 0x27,
  0x29, 0x3b, 0x29, 0x3b, 0x22, 0x3e, 0x6d, 0x73, 0x69, 0x65, 0x77, 0x69, 0x6e,
  0x73, 0x62, 0x69, 0x72, 0x64, 0x73, 0x6f, 0x72, 0x74, 0x62, 0x65, 0x74, 0x61,
  0x73, 0x65, 0x65, 0x6b, 0x54, 0x31, 0x38, 0x3a, 0x6f, 0x72, 0x64, 0x73, 0x74,
  0x72, 0x65, 0x65, 0x6d, 0x61, 0x6c, 0x6c, 0x36, 0x30, 0x70, 0x78, 0x66, 0x61,
  0x72, 0x6d, 0xe2, 0x80, 0x99, 0x73, 0x62, 0x6f, 0x79, 0x73, 0x5b, 0x30, 0x5d,
  0x2e, 0x27, 0x29, 0x3b, 0x22, 0x50, 0x4f, 0x53, 0x54, 0x62, 0x65, 0x61, 0x72,
  0x6b, 0x69, 0x64, 0x73, 0x29, 0x3b, 0x7d, 0x7d, 0x6d, 0x61, 0x72, 0x79, 0x74,
  0x65, 0x6e, 0x64, 0x28, 0x55, 0x4b, 0x29, 0x71, 0x75, 0x61, 0x64, 0x7a, 0x68,
  0x3a, 0xe6, 0x2d, 0x73, 0x69, 0x7a, 0x2d, 0x2d, 0x2d, 0x2d, 0x70, 0x72, 0x6f,
  0x70, 0x27, 0x29, 0x3b, 0x0d, 0x6c, 0x69, 0x66, 0x74, 0x54, 0x31, 0x39, 0x3a,
  0x76, 0x69, 0x63, 0x65, 0x61, 0x6e, 0x64, 0x79, 0x64, 0x65, 0x62, 0x74, 0x3e,
  0x52, 0x53, 0x53, 0x70, 0x6f, 0x6f, 0x6c, 0x6e, 0x65, 0x63, 0x6b, 0x62, 0x6c,
  0x6f, 0x77, 0x54, 0x31, 0x36, 0x3a, 0x64, 0x6f, 0x6f, 0x72, 0x65, 0x76, 0x61,
  0x6c, 0x54, 0x31, 0x37, 0x3a, 0x6c, 0x65, 0x74, 0x73, 0x66, 0x61, 0x69, 0x6c,
  0x6f, 0x72, 0x61, 0x6c, 0x70, 0x6f, 0x6c, 0x6c, 0x6e, 0x6f, 0x76, 0x61, 0x63,
  0x6f, 0x6c, 0x73, 0x67, 0x65, 0x6e, 0x65, 0x20, 0xe2, 0x80, 0x94, 0x73, 0x6f,
  0x66, 0x74, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x69, 0x6c, 0x6c, 0x72, 0x6f, 0x73,
  0x73, 0x3c, 0x68, 0x33, 0x3e, 0x70, 0x6f, 0x75, 0x72, 0x66, 0x61, 0x64, 0x65,
  0x70, 0x69, 0x6e, 0x6b, 0x3c, 0x74, 0x72, 0x3e, 0x6d, 0x69, 0x6e, 0x69, 0x29,
  0x7c, 0x21, 0x28, 0x6d, 0x69, 0x6e, 0x65, 0x7a, 0x68, 0x3a, 0xe8, 0x62, 0x61,
  0x72, 0x73, 0x68, 0x65, 0x61, 0x72, 0x30, 0x30, 0x29, 0x3b, 0x6d, 0x69, 0x6c,
  0x6b, 0x20, 0x2d, 0x2d, 0x3e, 0x69, 0x72, 0x6f, 0x6e, 0x66, 0x72, 0x65, 0x64,
  0x64, 0x69, 0x73, 0x6b, 0x77, 0x65, 0x6e, 0x74, 0x73, 0x6f, 0x69, 0x6c, 0x70,
  0x75, 0x74, 0x73, 0x2f, 0x6a, 0x73, 0x2f, 0x68, 0x6f, 0x6c, 0x79, 0x54, 0x32,
  0x32, 0x3a, 0x49, 0x53, 0x42, 0x4e, 0x54, 0x32, 0x30, 0x3a, 0x61, 0x64, 0x61,
  0x6d, 0x73, 0x65, 0x65, 0x73, 0x3c, 0x68, 0x32, 0x3e, 0x6a, 0x73, 0x6f, 0x6e,
  0x27, 0x2c, 0x20, 0x27, 0x63, 0x6f, 0x6e, 0x74, 0x54, 0x32, 0x31, 0x3a, 0x20,
  0x52, 0x53, 0x53, 0x6c, 0x6f, 0x6f, 0x70, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x6f,
  0x6f, 0x6e, 0x3c, 0x2f, 0x70, 0x3e, 0x73, 0x6f, 0x75, 0x6c, 0x4c, 0x49, 0x4e,
  0x45, 0x66, 0x6f, 0x72, 0x74, 0x63, 0x61, 0x72, 0x74, 0x54, 0x31, 0x34, 0x3a,
  0x3c, 0x68, 0x31, 0x3e, 0x38, 0x30, 0x70, 0x78, 0x21, 0x2d, 0x2d, 0x3c, 0x39,
  0x70, 0x78, 0x3b, 0x54, 0x30, 0x34, 0x3a, 0x6d, 0x69, 0x6b, 0x65, 0x3a, 0x34,
  0x36, 0x5a, 0x6e, 0x69, 0x63, 0x65, 0x69, 0x6e, 0x63, 0x68, 0x59, 0x6f, 0x72,
  0x6b, 0x72, 0x69, 0x63, 0x65, 0x7a, 0x68, 0x3a, 0xe4, 0x27, 0x29, 0x29, 0x3b,
  0x70, 0x75, 0x72, 0x65, 0x6d, 0x61, 0x67, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74,
  0x6f, 0x6e, 0x65, 0x62, 0x6f, 0x6e, 0x64, 0x3a, 0x33, 0x37, 0x5a, 0x5f, 0x6f,
  0x66, 0x5f, 0x27, 0x5d, 0x29, 0x3b, 0x30, 0x30, 0x30, 0x2c, 0x7a, 0x68, 0x3a,
  0xe7, 0x74, 0x61, 0x6e, 0x6b, 0x79, 0x61, 0x72, 0x64, 0x62, 0x6f, 0x77, 0x6c,
  0x62, 0x75, 0x73, 0x68, 0x3a, 0x35, 0x36, 0x5a, 0x4a, 0x61, 0x76, 0x61, 0x33,
  0x30, 0x70, 0x78, 0x0a, 0x7c, 0x7d, 0x0a, 0x25, 0x43, 0x33, 0x25, 0x3a, 0x33,
  0x34, 0x5a, 0x6a, 0x65, 0x66, 0x66, 0x45, 0x58, 0x50, 0x49, 0x63, 0x61, 0x73,
  0x68, 0x76, 0x69, 0x73, 0x61, 0x67, 0x6f, 0x6c, 0x66, 0x73, 0x6e, 0x6f, 0x77,
  0x7a, 0x68, 0x3a, 0xe9, 0x71, 0x75, 0x65, 0x72, 0x2e, 0x63, 0x73, 0x73, 0x73,
  0x69, 0x63, 0x6b, 0x6d, 0x65, 0x61, 0x74, 0x6d, 0x69, 0x6e, 0x2e, 0x62, 0x69,
  0x6e, 0x64, 0x64, 0x65, 0x6c, 0x6c, 0x68, 0x69, 0x72, 0x65, 0x70, 0x69, 0x63,
  0x73, 0x72, 0x65, 0x6e, 0x74, 0x3a, 0x33, 0x36, 0x5a, 0x48, 0x54, 0x54, 0x50,
  0x2d, 0x32, 0x30, 0x31, 0x66, 0x6f, 0x74, 0x6f, 0x77, 0x6f, 0x6c, 0x66, 0x45,
  0x4e, 0x44, 0x20, 0x78, 0x62, 0x6f, 0x78, 0x3a, 0x35, 0x34, 0x5a, 0x42, 0x4f,
  0x44, 0x59, 0x64, 0x69, 0x63, 0x6b, 0x3b, 0x0a, 0x7d, 0x0a, 0x65, 0x78, 0x69,
  0x74, 0x3a, 0x33, 0x35, 0x5a, 0x76, 0x61, 0x72, 0x73, 0x62, 0x65, 0x61, 0x74,
  0x27, 0x7d, 0x29, 0x3b, 0x64, 0x69, 0x65, 0x74, 0x39, 0x39, 0x39, 0x3b, 0x61,
  0x6e, 0x6e, 0x65, 0x7d, 0x7d, 0x3c, 0x2f, 0x5b, 0x69, 0x5d, 0x2e, 0x4c, 0x61,
  0x6e, 0x67, 0x6b, 0x6d, 0xc2, 0xb2, 0x77, 0x69, 0x72, 0x65, 0x74, 0x6f, 0x79,
  0x73, 0x61, 0x64, 0x64, 0x73, 0x73, 0x65, 0x61, 0x6c, 0x61, 0x6c, 0x65, 0x78,
  0x3b, 0x0a, 0x09, 0x7d, 0x65, 0x63, 0x68, 0x6f, 0x6e, 0x69, 0x6e, 0x65, 0x2e,
  0x6f, 0x72, 0x67, 0x30, 0x30, 0x35, 0x29, 0x74, 0x6f, 0x6e, 0x79, 0x6a, 0x65,
  0x77, 0x73, 0x73, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x67, 0x73, 0x72, 0x6f, 0x6f,
  0x66, 0x30, 0x30, 0x30, 0x29, 0x20, 0x32, 0x30, 0x30, 0x77, 0x69, 0x6e, 0x65,
  0x67, 0x65, 0x61, 0x72, 0x64, 0x6f, 0x67, 0x73, 0x62, 0x6f, 0x6f, 0x74, 0x67,
  0x61, 0x72, 0x79, 0x63, 0x75, 0x74, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x74, 0x65,
  0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x78, 0x6d, 0x6c, 0x63, 0x6f, 0x63,
  0x6b, 0x67, 0x61, 0x6e, 0x67, 0x24, 0x28, 0x27, 0x2e, 0x35, 0x30, 0x70, 0x78,
  0x50, 0x68, 0x2e, 0x44, 0x6d, 0x69, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x6e, 0x6c,
  0x6f, 0x61, 0x6e, 0x64, 0x65, 0x73, 0x6b, 0x6d, 0x69, 0x6c, 0x65, 0x72, 0x79,
  0x61, 0x6e, 0x75, 0x6e, 0x69, 0x78, 0x64, 0x69, 0x73, 0x63, 0x29, 0x3b, 0x7d,
  0x0a, 0x64, 0x75, 0x73, 0x74, 0x63, 0x6c, 0x69, 0x70, 0x29, 0x2e, 0x0a, 0x0a,
  0x37, 0x30, 0x70, 0x78, 0x2d, 0x32, 0x30, 0x30, 0x44, 0x56, 0x44, 0x73, 0x37,
  0x5d, 0x3e, 0x3c, 0x74, 0x61, 0x70, 0x65, 0x64, 0x65, 0x6d, 0x6f, 0x69, 0x2b,
  0x2b, 0x29, 0x77, 0x61, 0x67, 0x65, 0x65, 0x75, 0x72, 0x6f, 0x70, 0x68, 0x69,
  0x6c, 0x6f, 0x70, 0x74, 0x73, 0x68, 0x6f, 0x6c, 0x65, 0x46, 0x41, 0x51, 0x73,
  0x61, 0x73, 0x69, 0x6e, 0x2d, 0x32, 0x36, 0x54, 0x6c, 0x61, 0x62, 0x73, 0x70,
  0x65, 0x74, 0x73, 0x55, 0x52, 0x4c, 0x20, 0x62, 0x75, 0x6c, 0x6b, 0x63, 0x6f,
  0x6f, 0x6b, 0x3b, 0x7d, 0x0d, 0x0a, 0x48, 0x45, 0x41, 0x44, 0x5b, 0x30, 0x5d,
  0x29, 0x61, 0x62, 0x62, 0x72, 0x6a, 0x75, 0x61, 0x6e, 0x28, 0x31, 0x39, 0x38,
  0x6c, 0x65, 0x73, 0x68, 0x74, 0x77, 0x69, 0x6e, 0x3c, 0x2f, 0x69, 0x3e, 0x73,
  0x6f, 0x6e, 0x79, 0x67, 0x75, 0x79, 0x73, 0x66, 0x75, 0x63, 0x6b, 0x70, 0x69,
  0x70, 0x65, 0x7c, 0x2d, 0x0a, 0x21, 0x30, 0x30, 0x32, 0x29, 0x6e, 0x64, 0x6f,
  0x77, 0x5b, 0x31, 0x5d, 0x3b, 0x5b, 0x5d, 0x3b, 0x0a, 0x4c, 0x6f, 0x67, 0x20,
  0x73, 0x61, 0x6c, 0x74, 0x0d, 0x0a, 0x09, 0x09, 0x62, 0x61, 0x6e, 0x67, 0x74,
  0x72, 0x69, 0x6d, 0x62, 0x61, 0x74, 0x68, 0x29, 0x7b, 0x0d, 0x0a, 0x30, 0x30,
  0x70, 0x78, 0x0a, 0x7d, 0x29, 0x3b, 0x6b, 0x6f, 0x3a, 0xec, 0x66, 0x65, 0x65,
  0x73, 0x61, 0x64, 0x3e, 0x0d, 0x73, 0x3a, 0x2f, 0x2f, 0x20, 0x5b, 0x5d, 0x3b,
  0x74, 0x6f, 0x6c, 0x6c, 0x70, 0x6c, 0x75, 0x67, 0x28, 0x29, 0x7b, 0x0a, 0x7b,
  0x0d, 0x0a, 0x20, 0x2e, 0x6a, 0x73, 0x27, 0x32, 0x30, 0x30, 0x70, 0x64, 0x75,
  0x61, 0x6c, 0x62, 0x6f, 0x61, 0x74, 0x2e, 0x4a, 0x50, 0x47, 0x29, 0x3b, 0x0a,
  0x7d, 0x71, 0x75, 0x6f, 0x74, 0x29, 0x3b, 0x0a, 0x0a, 0x27, 0x29, 0x3b, 0x0a,
  0x0d, 0x0a, 0x7d, 0x0d, 0x32, 0x30, 0x31, 0x34, 0x32, 0x30, 0x31, 0x35, 0x32,
  0x30, 0x31, 0x36, 0x32, 0x30, 0x31, 0x37, 0x32, 0x30, 0x31, 0x38, 0x32, 0x30,
  0x31, 0x39, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x31, 0x32, 0x30, 0x32,
  0x32, 0x32, 0x30, 0x32, 0x33, 0x32, 0x30, 0x32, 0x34, 0x32, 0x30, 0x32, 0x35,
  0x32, 0x30, 0x32, 0x36, 0x32, 0x30, 0x32, 0x37, 0x32, 0x30, 0x32, 0x38, 0x32,
  0x30, 0x32, 0x39, 0x32, 0x30, 0x33, 0x30, 0x32, 0x30, 0x33, 0x31, 0x32, 0x30,
  0x33, 0x32, 0x32, 0x30, 0x33, 0x33, 0x32, 0x30, 0x33, 0x34, 0x32, 0x30, 0x33,
  0x35, 0x32, 0x30, 0x33, 0x36, 0x32, 0x30, 0x33, 0x37, 0x32, 0x30, 0x31, 0x33,
  0x32, 0x30, 0x31, 0x32, 0x32, 0x30, 0x31, 0x31, 0x32, 0x30, 0x31, 0x30, 0x32,
  0x30, 0x30, 0x39, 0x32, 0x30, 0x30, 0x38, 0x32, 0x30, 0x30, 0x37, 0x32, 0x30,
  0x30, 0x36, 0x32, 0x30, 0x30, 0x35, 0x32, 0x30, 0x30, 0x34, 0x32, 0x30, 0x30,
  0x33, 0x32, 0x30, 0x30, 0x32, 0x32, 0x30, 0x30, 0x31, 0x32, 0x30, 0x30, 0x30,
  0x31, 0x39, 0x39, 0x39, 0x31, 0x39, 0x39, 0x38, 0x31, 0x39, 0x39, 0x37, 0x31,
  0x39, 0x39, 0x36, 0x31, 0x39, 0x39, 0x35, 0x31, 0x39, 0x39, 0x34, 0x31, 0x39,
  0x39, 0x33, 0x31, 0x39, 0x39, 0x32, 0x31, 0x39, 0x39, 0x31, 0x31, 0x39, 0x39,
  0x30, 0x31, 0x39, 0x38, 0x39, 0x31, 0x39, 0x38, 0x38, 0x31, 0x39, 0x38, 0x37,
  0x31, 0x39, 0x38, 0x36, 0x31, 0x39, 0x38, 0x35, 0x31, 0x39, 0x38, 0x34, 0x31,
  0x39, 0x38, 0x33, 0x31, 0x39, 0x38, 0x32, 0x31, 0x39, 0x38, 0x31, 0x31, 0x39,
  0x38, 0x30, 0x31, 0x39, 0x37, 0x39, 0x31, 0x39, 0x37, 0x38, 0x31, 0x39, 0x37,
  0x37, 0x31, 0x39, 0x37, 0x36, 0x31, 0x39, 0x37, 0x35, 0x31, 0x39, 0x37, 0x34,
  0x31, 0x39, 0x37, 0x33, 0x31, 0x39, 0x37, 0x32, 0x31, 0x39, 0x37, 0x31, 0x31,
  0x39, 0x37, 0x30, 0x31, 0x39, 0x36, 0x39, 0x31, 0x39, 0x36, 0x38, 0x31, 0x39,
  0x36, 0x37, 0x31, 0x39, 0x36, 0x36, 0x31, 0x39, 0x36, 0x35, 0x31, 0x39, 0x36,
  0x34, 0x31, 0x39, 0x36, 0x33, 0x31, 0x39, 0x36, 0x32, 0x31, 0x39, 0x36, 0x31,
  0x31, 0x39, 0x36, 0x30, 0x31, 0x39, 0x35, 0x39, 0x31, 0x39, 0x35, 0x38, 0x31,
  0x39, 0x35, 0x37, 0x31, 0x39, 0x35, 0x36, 0x31, 0x39, 0x35, 0x35, 0x31, 0x39,
  0x35, 0x34, 0x31, 0x39, 0x35, 0x33, 0x31, 0x39, 0x35, 0x32, 0x31, 0x39, 0x35,
  0x31, 0x31, 0x39, 0x35, 0x30, 0x31, 0x30, 0x30, 0x30, 0x31, 0x30, 0x32, 0x34,
  0x31, 0x33, 0x39, 0x34, 0x30, 0x30, 0x30, 0x30, 0x39, 0x39, 0x39, 0x39, 0x63,
  0x6f, 0x6d, 0x6f, 0x6d, 0xc3, 0xa1, 0x73, 0x65, 0x73, 0x74, 0x65, 0x65, 0x73,
  0x74, 0x61, 0x70, 0x65, 0x72, 0x6f, 0x74, 0x6f, 0x64, 0x6f, 0x68, 0x61, 0x63,
  0x65, 0x63, 0x61, 0x64, 0x61, 0x61, 0xc3, 0xb1, 0x6f, 0x62, 0x69, 0x65, 0x6e,
  0x64, 0xc3, 0xad, 0x61, 0x61, 0x73, 0xc3, 0xad, 0x76, 0x69, 0x64, 0x61, 0x63,
  0x61, 0x73, 0x6f, 0x6f, 0x74, 0x72, 0x6f, 0x66, 0x6f, 0x72, 0x6f, 0x73, 0x6f,
  0x6c, 0x6f, 0x6f, 0x74, 0x72, 0x61, 0x63, 0x75, 0x61, 0x6c, 0x64, 0x69, 0x6a,
  0x6f, 0x73, 0x69, 0x64, 0x6f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x69, 0x70, 0x6f,
  0x74, 0x65, 0x6d, 0x61, 0x64, 0x65, 0x62, 0x65, 0x61, 0x6c, 0x67, 0x6f, 0x71,
  0x75, 0xc3, 0xa9, 0x65, 0x73, 0x74, 0x6f, 0x6e, 0x61, 0x64, 0x61, 0x74, 0x72,
  0x65, 0x73, 0x70, 0x6f, 0x63, 0x6f, 0x63, 0x61, 0x73, 0x61, 0x62, 0x61, 0x6a,
  0x6f, 0x74, 0x6f, 0x64, 0x61, 0x73, 0x69, 0x6e, 0x6f, 0x61, 0x67, 0x75, 0x61,
  0x70, 0x75, 0x65, 0x73, 0x75, 0x6e, 0x6f, 0x73, 0x61, 0x6e, 0x74, 0x65, 0x64,
  0x69, 0x63, 0x65, 0x6c, 0x75, 0x69, 0x73, 0x65, 0x6c, 0x6c, 0x61, 0x6d, 0x61,
  0x79, 0x6f, 0x7a, 0x6f, 0x6e, 0x61, 0x61, 0x6d, 0x6f, 0x72, 0x70, 0x69, 0x73,
  0x6f, 0x6f, 0x62, 0x72, 0x61, 0x63, 0x6c, 0x69, 0x63, 0x65, 0x6c, 0x6c, 0x6f,
  0x64, 0x69, 0x6f, 0x73, 0x68, 0x6f, 0x72, 0x61, 0x63, 0x61, 0x73, 0x69, 0xd0,
  0xb7, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x80,
  0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x83, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0,
  0xb5, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xb7,
  0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd0,
  0xb6, 0xd0, 0xb5, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x85, 0xd0, 0x9d,
  0xd0, 0xb0, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xbc, 0xd1,
  0x8b, 0xd0, 0x92, 0xd1, 0x8b, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x8b,
  0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0x9d, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0,
  0x9f, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xa0,
  0xd0, 0xa4, 0xd0, 0x9d, 0xd0, 0xb5, 0xd0, 0x9c, 0xd1, 0x8b, 0xd1, 0x82, 0xd1,
  0x8b, 0xd0, 0x9e, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb4, 0xd0, 0xb0,
  0xd0, 0x97, 0xd0, 0xb0, 0xd0, 0x94, 0xd0, 0xb0, 0xd0, 0x9d, 0xd1, 0x83, 0xd0,
  0x9e, 0xd0, 0xb1, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0x98, 0xd0, 0xb7, 0xd0, 0xb5,
  0xd0, 0xb9, 0xd0, 0xbd, 0xd1, 0x83, 0xd0, 0xbc, 0xd0, 0xbc, 0xd0, 0xa2, 0xd1,
  0x8b, 0xd1, 0x83, 0xd0, 0xb6, 0xd9, 0x81, 0xd9, 0x8a, 0xd8, 0xa3, 0xd9, 0x86,
  0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 0x83, 0xd9, 0x84, 0xd8,
  0xa3, 0xd9, 0x88, 0xd8, 0xb1, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x81,
  0xd9, 0x89, 0xd9, 0x87, 0xd9, 0x88, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x84, 0xd9,
  0x83, 0xd8, 0xa7, 0xd9, 0x88, 0xd9, 0x84, 0xd9, 0x87, 0xd8, 0xa8, 0xd8, 0xb3,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa5, 0xd9, 0x86, 0xd9, 0x87, 0xd9, 0x8a, 0xd8,
  0xa3, 0xd9, 0x8a, 0xd9, 0x82, 0xd8, 0xaf, 0xd9, 0x87, 0xd9, 0x84, 0xd8, 0xab,
  0xd9, 0x85, 0xd8, 0xa8, 0xd9, 0x87, 0xd9, 0x84, 0xd9, 0x88, 0xd9, 0x84, 0xd9,
  0x8a, 0xd8, 0xa8, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x8a, 0xd8, 0xa8, 0xd9, 0x83,
  0xd8, 0xb4, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa3, 0xd9, 0x85, 0xd9,
  0x86, 0xd8, 0xaa, 0xd8, 0xa8, 0xd9, 0x8a, 0xd9, 0x84, 0xd9, 0x86, 0xd8, 0xad,
  0xd8, 0xa8, 0xd9, 0x87, 0xd9, 0x85, 0xd9, 0x85, 0xd8, 0xb4, 0xd9, 0x88, 0xd8,
  0xb4, 0x66, 0x69, 0x72, 0x73, 0x74, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x6c, 0x69,
  0x67, 0x68, 0x74, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x6d, 0x65, 0x64, 0x69, 0x61,
  0x77, 0x68, 0x69, 0x74, 0x65, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x62, 0x6c, 0x61,
  0x63, 0x6b, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x62,
  0x6f, 0x6f, 0x6b, 0x73, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x75, 0x73, 0x69,
  0x63, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x70, 0x6f,
  0x69, 0x6e, 0x74, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x6c, 0x65, 0x76, 0x65, 0x6c,
  0x74, 0x61, 0x62, 0x6c, 0x65, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x68, 0x6f, 0x75,
  0x73, 0x65, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x79,
  0x65, 0x61, 0x72, 0x73, 0x73, 0x74, 0x61, 0x74, 0x65, 0x74, 0x6f, 0x64, 0x61,
  0x79, 0x77, 0x61, 0x74, 0x65, 0x72, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x64, 0x65, 0x61, 0x74, 0x68, 0x70, 0x6f, 0x77, 0x65, 0x72,
  0x70, 0x68, 0x6f, 0x6e, 0x65, 0x6e, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x72,
  0x6f, 0x72, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x74,
  0x65, 0x72, 0x6d, 0x73, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x74, 0x6f, 0x6f, 0x6c,
  0x73, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x74, 0x69,
  0x6d, 0x65, 0x73, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x77, 0x6f, 0x72, 0x64, 0x73,
  0x67, 0x61, 0x6d, 0x65, 0x73, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x70, 0x61,
  0x63, 0x65, 0x66, 0x6f, 0x63, 0x75, 0x73, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x6d,
  0x6f, 0x64, 0x65, 0x6c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x67, 0x75, 0x69, 0x64,
  0x65, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x77, 0x6f,
  0x6d, 0x65, 0x6e, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x6d, 0x6f, 0x6e, 0x65, 0x79,
  0x69, 0x6d, 0x61, 0x67, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x79, 0x6f, 0x75,
  0x6e, 0x67, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x63,
  0x6f, 0x6c, 0x6f, 0x72, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x66, 0x72, 0x6f, 0x6e,
  0x74, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x77, 0x61, 0x74, 0x63, 0x68, 0x66, 0x6f,
  0x72, 0x63, 0x65, 0x70, 0x72, 0x69, 0x63, 0x65, 0x72, 0x75, 0x6c, 0x65, 0x73,
  0x62, 0x65, 0x67, 0x69, 0x6e, 0x61, 0x66, 0x74, 0x65, 0x72, 0x76, 0x69, 0x73,
  0x69, 0x74, 0x69, 0x73, 0x73, 0x75, 0x65, 0x61, 0x72, 0x65, 0x61, 0x73, 0x62,
  0x65, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x74, 0x6f, 0x74, 0x61,
  0x6c, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x70, 0x72,
  0x69, 0x6e, 0x74, 0x70, 0x72, 0x65, 0x73, 0x73, 0x62, 0x75, 0x69, 0x6c, 0x74,
  0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x73, 0x70, 0x65, 0x65, 0x64, 0x73, 0x74, 0x75,
  0x64, 0x79, 0x74, 0x72, 0x61, 0x64, 0x65, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x73,
  0x65, 0x6e, 0x73, 0x65, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x77,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x61, 0x64,
  0x64, 0x65, 0x64, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x6d, 0x6f, 0x76, 0x65, 0x64,
  0x74, 0x61, 0x6b, 0x65, 0x6e, 0x61, 0x62, 0x6f, 0x76, 0x65, 0x66, 0x6c, 0x61,
  0x73, 0x68, 0x66, 0x69, 0x78, 0x65, 0x64, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x73, 0x63, 0x68, 0x65, 0x63,
  0x6b, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x72, 0x69, 0x76, 0x65, 0x72, 0x69, 0x74,
  0x65, 0x6d, 0x73, 0x71, 0x75, 0x69, 0x63, 0x6b, 0x73, 0x68, 0x61, 0x70, 0x65,
  0x68, 0x75, 0x6d, 0x61, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x67, 0x6f, 0x69,
  0x6e, 0x67, 0x6d, 0x6f, 0x76, 0x69, 0x65, 0x74, 0x68, 0x69, 0x72, 0x64, 0x62,
  0x61, 0x73, 0x69, 0x63, 0x70, 0x65, 0x61, 0x63, 0x65, 0x73, 0x74, 0x61, 0x67,
  0x65, 0x77, 0x69, 0x64, 0x74, 0x68, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x69, 0x64,
  0x65, 0x61, 0x73, 0x77, 0x72, 0x6f, 0x74, 0x65, 0x70, 0x61, 0x67, 0x65, 0x73,
  0x75, 0x73, 0x65, 0x72, 0x73, 0x64, 0x72, 0x69, 0x76, 0x65, 0x73, 0x74, 0x6f,
  0x72, 0x65, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x76,
  0x6f, 0x69, 0x63, 0x65, 0x73, 0x69, 0x74, 0x65, 0x73, 0x6d, 0x6f, 0x6e, 0x74,
  0x68, 0x77, 0x68, 0x65, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x77, 0x68,
  0x69, 0x63, 0x68, 0x65, 0x61, 0x72, 0x74, 0x68, 0x66, 0x6f, 0x72, 0x75, 0x6d,
  0x74, 0x68, 0x72, 0x65, 0x65, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x70, 0x61, 0x72,
  0x74, 0x79, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x6c,
  0x69, 0x76, 0x65, 0x73, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x6c, 0x61, 0x79, 0x65,
  0x72, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x75, 0x73,
  0x61, 0x67, 0x65, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x63, 0x6f, 0x75, 0x72, 0x74,
  0x79, 0x6f, 0x75, 0x72, 0x20, 0x62, 0x69, 0x72, 0x74, 0x68, 0x70, 0x6f, 0x70,
  0x75, 0x70, 0x74, 0x79, 0x70, 0x65, 0x73, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x49,
  0x6d, 0x61, 0x67, 0x65, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x75, 0x70, 0x70, 0x65,
  0x72, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x65, 0x76, 0x65, 0x72, 0x79, 0x73, 0x68,
  0x6f, 0x77, 0x73, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x65, 0x78, 0x74, 0x72, 0x61,
  0x6d, 0x61, 0x74, 0x63, 0x68, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x6b, 0x6e, 0x6f,
  0x77, 0x6e, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x62, 0x65, 0x67, 0x61, 0x6e, 0x73,
  0x75, 0x70, 0x65, 0x72, 0x70, 0x61, 0x70, 0x65, 0x72, 0x6e, 0x6f, 0x72, 0x74,
  0x68, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x6e, 0x61,
  0x6d, 0x65, 0x64, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x54, 0x65, 0x72, 0x6d, 0x73,
  0x70, 0x61, 0x72, 0x74, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x62, 0x72, 0x61,
  0x6e, 0x64, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x77, 0x6f, 0x6d, 0x61, 0x6e, 0x66,
  0x61, 0x6c, 0x73, 0x65, 0x72, 0x65, 0x61, 0x64, 0x79, 0x61, 0x75, 0x64, 0x69,
  0x6f, 0x74, 0x61, 0x6b, 0x65, 0x73, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x2e, 0x63,
  0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x64, 0x63, 0x61, 0x73, 0x65, 0x73,
  0x64, 0x61, 0x69, 0x6c, 0x79, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x67, 0x72, 0x65,
  0x61, 0x74, 0x6a, 0x75, 0x64, 0x67, 0x65, 0x74, 0x68, 0x6f, 0x73, 0x65, 0x75,
  0x6e, 0x69, 0x74, 0x73, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x62, 0x72, 0x6f, 0x61,
  0x64, 0x63, 0x6f, 0x61, 0x73, 0x74, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x70,
  0x70, 0x6c, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x63, 0x79, 0x63, 0x6c, 0x65,
  0x73, 0x63, 0x65, 0x6e, 0x65, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x63, 0x6c, 0x69,
  0x63, 0x6b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x71, 0x75, 0x65, 0x65, 0x6e, 0x70,
  0x69, 0x65, 0x63, 0x65, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x66, 0x72, 0x61, 0x6d,
  0x65, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x6c, 0x69,
  0x6d, 0x69, 0x74, 0x63, 0x61, 0x63, 0x68, 0x65, 0x63, 0x69, 0x76, 0x69, 0x6c,
  0x73, 0x63, 0x61, 0x6c, 0x65, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x74, 0x68, 0x65,
  0x6d, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x74, 0x6f, 0x75, 0x63, 0x68, 0x62,
  0x6f, 0x75, 0x6e, 0x64, 0x72, 0x6f, 0x79, 0x61, 0x6c, 0x61, 0x73, 0x6b, 0x65,
  0x64, 0x77, 0x68, 0x6f, 0x6c, 0x65, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x73, 0x74,
  0x6f, 0x63, 0x6b, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x66, 0x61, 0x69, 0x74, 0x68,
  0x68, 0x65, 0x61, 0x72, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x6f, 0x66, 0x66,
  0x65, 0x72, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x6d,
  0x69, 0x67, 0x68, 0x74, 0x61, 0x6c, 0x62, 0x75, 0x6d, 0x74, 0x68, 0x69, 0x6e,
  0x6b, 0x62, 0x6c, 0x6f, 0x6f, 0x64, 0x61, 0x72, 0x72, 0x61, 0x79, 0x6d, 0x61,
  0x6a, 0x6f, 0x72, 0x74, 0x72, 0x75, 0x73, 0x74, 0x63, 0x61, 0x6e, 0x6f, 0x6e,
  0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x76, 0x61, 0x6c,
  0x69, 0x64, 0x73, 0x74, 0x6f, 0x6e, 0x65, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x4c,
  0x6f, 0x67, 0x69, 0x6e, 0x68, 0x61, 0x70, 0x70, 0x79, 0x6f, 0x63, 0x63, 0x75,
  0x72, 0x6c, 0x65, 0x66, 0x74, 0x3a, 0x66, 0x72, 0x65, 0x73, 0x68, 0x71, 0x75,
  0x69, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x6d, 0x73, 0x67, 0x72, 0x61, 0x64, 0x65,
  0x6e, 0x65, 0x65, 0x64, 0x73, 0x75, 0x72, 0x62, 0x61, 0x6e, 0x66, 0x69, 0x67,
  0x68, 0x74, 0x62, 0x61, 0x73, 0x69, 0x73, 0x68, 0x6f, 0x76, 0x65, 0x72, 0x61,
  0x75, 0x74, 0x6f, 0x3b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x68, 0x74, 0x6d,
  0x6c, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x59, 0x6f,
  0x75, 0x72, 0x20, 0x73, 0x6c, 0x69, 0x64, 0x65, 0x74, 0x6f, 0x70, 0x69, 0x63,
  0x62, 0x72, 0x6f, 0x77, 0x6e, 0x61, 0x6c, 0x6f, 0x6e, 0x65, 0x64, 0x72, 0x61,
  0x77, 0x6e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x72, 0x65, 0x61, 0x63, 0x68, 0x52,
  0x69, 0x67, 0x68, 0x74, 0x64, 0x61, 0x74, 0x65, 0x73, 0x6d, 0x61, 0x72, 0x63,
  0x68, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x67, 0x6f, 0x6f, 0x64, 0x73, 0x4c, 0x69,
  0x6e, 0x6b, 0x73, 0x64, 0x6f, 0x75, 0x62, 0x74, 0x61, 0x73, 0x79, 0x6e, 0x63,
  0x74, 0x68, 0x75, 0x6d, 0x62, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x63, 0x68, 0x69,
  0x65, 0x66, 0x79, 0x6f, 0x75, 0x74, 0x68, 0x6e, 0x6f, 0x76, 0x65, 0x6c, 0x31,
  0x30, 0x70, 0x78, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x75, 0x6e, 0x74, 0x69,
  0x6c, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x70,
  0x61, 0x63, 0x65, 0x71, 0x75, 0x65, 0x72, 0x79, 0x6a, 0x61, 0x6d, 0x65, 0x73,
  0x65, 0x71, 0x75, 0x61, 0x6c, 0x74, 0x77, 0x69, 0x63, 0x65, 0x30, 0x2c, 0x30,
  0x30, 0x30, 0x53, 0x74, 0x61, 0x72, 0x74, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x73,
  0x6f, 0x6e, 0x67, 0x73, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x73, 0x68, 0x69, 0x66, 0x74, 0x77, 0x6f, 0x72, 0x74, 0x68, 0x70, 0x6f,
  0x73, 0x74, 0x73, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x77, 0x65, 0x65, 0x6b, 0x73,
  0x61, 0x76, 0x6f, 0x69, 0x64, 0x74, 0x68, 0x65, 0x73, 0x65, 0x6d, 0x69, 0x6c,
  0x65, 0x73, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x61,
  0x6c, 0x70, 0x68, 0x61, 0x70, 0x6c, 0x61, 0x6e, 0x74, 0x6d, 0x61, 0x72, 0x6b,
  0x73, 0x72, 0x61, 0x74, 0x65, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x63, 0x6c,
  0x61, 0x69, 0x6d, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x74, 0x65, 0x78, 0x74, 0x73,
  0x73, 0x74, 0x61, 0x72, 0x73, 0x77, 0x72, 0x6f, 0x6e, 0x67, 0x3c, 0x2f, 0x68,
  0x33, 0x3e, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x6d,
  0x75, 0x6c, 0x74, 0x69, 0x68, 0x65, 0x61, 0x72, 0x64, 0x50, 0x6f, 0x77, 0x65,
  0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x6f,
  0x6c, 0x69, 0x64, 0x28, 0x74, 0x68, 0x69, 0x73, 0x62, 0x72, 0x69, 0x6e, 0x67,
  0x73, 0x68, 0x69, 0x70, 0x73, 0x73, 0x74, 0x61, 0x66, 0x66, 0x74, 0x72, 0x69,
  0x65, 0x64, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x66,
  0x61, 0x63, 0x74, 0x73, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x69, 0x73,
  0x20, 0x2f, 0x2f, 0x2d, 0x2d, 0x3e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x65, 0x67,
  0x79, 0x70, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x31, 0x35, 0x70, 0x78, 0x3b,
  0x45, 0x6d, 0x61, 0x69, 0x6c, 0x74, 0x72, 0x75, 0x65, 0x22, 0x63, 0x72, 0x6f,
  0x73, 0x73, 0x73, 0x70, 0x65, 0x6e, 0x74, 0x62, 0x6c, 0x6f, 0x67, 0x73, 0x62,
  0x6f, 0x78, 0x22, 0x3e, 0x6e, 0x6f, 0x74, 0x65, 0x64, 0x6c, 0x65, 0x61, 0x76,
  0x65, 0x63, 0x68, 0x69, 0x6e, 0x61, 0x73, 0x69, 0x7a, 0x65, 0x73, 0x67, 0x75,
  0x65, 0x73, 0x74, 0x3c, 0x2f, 0x68, 0x34, 0x3e, 0x72, 0x6f, 0x62, 0x6f, 0x74,
  0x68, 0x65, 0x61, 0x76, 0x79, 0x74, 0x72, 0x75, 0x65, 0x2c, 0x73, 0x65, 0x76,
  0x65, 0x6e, 0x67, 0x72, 0x61, 0x6e, 0x64, 0x63, 0x72, 0x69, 0x6d, 0x65, 0x73,
  0x69, 0x67, 0x6e, 0x73, 0x61, 0x77, 0x61, 0x72, 0x65, 0x64, 0x61, 0x6e, 0x63,
  0x65, 0x70, 0x68, 0x61, 0x73, 0x65, 0x3e, 0x3c, 0x21, 0x2d, 0x2d, 0x65, 0x6e,
  0x5f, 0x55, 0x53, 0x26, 0x23, 0x33, 0x39, 0x3b, 0x32, 0x30, 0x30, 0x70, 0x78,
  0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x6e, 0x6a,
  0x6f, 0x79, 0x61, 0x6a, 0x61, 0x78, 0x2e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x6d, 0x69, 0x74, 0x68, 0x55, 0x2e, 0x53, 0x2e, 0x20, 0x68, 0x6f, 0x6c, 0x64,
  0x73, 0x70, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x61,
  0x76, 0x22, 0x3e, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x63, 0x6f, 0x72, 0x65,
  0x63, 0x6f, 0x6d, 0x65, 0x73, 0x64, 0x6f, 0x69, 0x6e, 0x67, 0x70, 0x72, 0x69,
  0x6f, 0x72, 0x53, 0x68, 0x61, 0x72, 0x65, 0x31, 0x39, 0x39, 0x30, 0x73, 0x72,
  0x6f, 0x6d, 0x61, 0x6e, 0x6c, 0x69, 0x73, 0x74, 0x73, 0x6a, 0x61, 0x70, 0x61,
  0x6e, 0x66, 0x61, 0x6c, 0x6c, 0x73, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x6f, 0x77,
  0x6e, 0x65, 0x72, 0x61, 0x67, 0x72, 0x65, 0x65, 0x3c, 0x2f, 0x68, 0x32, 0x3e,
  0x61, 0x62, 0x75, 0x73, 0x65, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x6f, 0x70, 0x65,
  0x72, 0x61, 0x22, 0x2d, 0x2f, 0x2f, 0x57, 0x63, 0x61, 0x72, 0x64, 0x73, 0x68,
  0x69, 0x6c, 0x6c, 0x73, 0x74, 0x65, 0x61, 0x6d, 0x73, 0x50, 0x68, 0x6f, 0x74,
  0x6f, 0x74, 0x72, 0x75, 0x74, 0x68, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x2e, 0x70,
  0x68, 0x70, 0x3f, 0x73, 0x61, 0x69, 0x6e, 0x74, 0x6d, 0x65, 0x74, 0x61, 0x6c,
  0x6c, 0x6f, 0x75, 0x69, 0x73, 0x6d, 0x65, 0x61, 0x6e, 0x74, 0x70, 0x72, 0x6f,
  0x6f, 0x66, 0x62, 0x72, 0x69, 0x65, 0x66, 0x72, 0x6f, 0x77, 0x22, 0x3e, 0x67,
  0x65, 0x6e, 0x72, 0x65, 0x74, 0x72, 0x75, 0x63, 0x6b, 0x6c, 0x6f, 0x6f, 0x6b,
  0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x2e, 0x6e,
  0x65, 0x74, 0x2f, 0x2d, 0x2d, 0x3e, 0x0a, 0x3c, 0x74, 0x72, 0x79, 0x20, 0x7b,
  0x0a, 0x76, 0x61, 0x72, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x73, 0x63, 0x6f, 0x73,
  0x74, 0x73, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x61, 0x64, 0x75, 0x6c, 0x74, 0x71,
  0x75, 0x65, 0x73, 0x74, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x6c, 0x61, 0x62, 0x6f,
  0x72, 0x68, 0x65, 0x6c, 0x70, 0x73, 0x63, 0x61, 0x75, 0x73, 0x65, 0x6d, 0x61,
  0x67, 0x69, 0x63, 0x6d, 0x6f, 0x74, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x69, 0x72,
  0x32, 0x35, 0x30, 0x70, 0x78, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x73, 0x74, 0x65,
  0x70, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x63, 0x6f, 0x75, 0x6c, 0x64, 0x67,
  0x6c, 0x61, 0x73, 0x73, 0x73, 0x69, 0x64, 0x65, 0x73, 0x66, 0x75, 0x6e, 0x64,
  0x73, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x61, 0x77, 0x61, 0x72, 0x64, 0x6d, 0x6f,
  0x75, 0x74, 0x68, 0x6d, 0x6f, 0x76, 0x65, 0x73, 0x70, 0x61, 0x72, 0x69, 0x73,
  0x67, 0x69, 0x76, 0x65, 0x73, 0x64, 0x75, 0x74, 0x63, 0x68, 0x74, 0x65, 0x78,
  0x61, 0x73, 0x66, 0x72, 0x75, 0x69, 0x74, 0x6e, 0x75, 0x6c, 0x6c, 0x2c, 0x7c,
  0x7c, 0x5b, 0x5d, 0x3b, 0x74, 0x6f, 0x70, 0x22, 0x3e, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x50, 0x4f, 0x53, 0x54, 0x22, 0x6f, 0x63, 0x65, 0x61, 0x6e, 0x3c, 0x62,
  0x72, 0x2f, 0x3e, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x73, 0x70, 0x65, 0x61, 0x6b,
  0x64, 0x65, 0x70, 0x74, 0x68, 0x20, 0x73, 0x69, 0x7a, 0x65, 0x62, 0x61, 0x6e,
  0x6b, 0x73, 0x63, 0x61, 0x74, 0x63, 0x68, 0x63, 0x68, 0x61, 0x72, 0x74, 0x32,
  0x30, 0x70, 0x78, 0x3b, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x64, 0x65, 0x61, 0x6c,
  0x73, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x35, 0x30, 0x70, 0x78, 0x3b, 0x75, 0x72,
  0x6c, 0x3d, 0x22, 0x70, 0x61, 0x72, 0x6b, 0x73, 0x6d, 0x6f, 0x75, 0x73, 0x65,
  0x4d, 0x6f, 0x73, 0x74, 0x20, 0x2e, 0x2e, 0x2e, 0x3c, 0x2f, 0x61, 0x6d, 0x6f,
  0x6e, 0x67, 0x62, 0x72, 0x61, 0x69, 0x6e, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x6e,
  0x6f, 0x6e, 0x65, 0x3b, 0x62, 0x61, 0x73, 0x65, 0x64, 0x63, 0x61, 0x72, 0x72,
  0x79, 0x64, 0x72, 0x61, 0x66, 0x74, 0x72, 0x65, 0x66, 0x65, 0x72, 0x70, 0x61,
  0x67, 0x65, 0x5f, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x6d, 0x65, 0x74, 0x65, 0x72,
  0x64, 0x65, 0x6c, 0x61, 0x79, 0x64, 0x72, 0x65, 0x61, 0x6d, 0x70, 0x72, 0x6f,
  0x76, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x74, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x64,
  0x72, 0x75, 0x67, 0x73, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x61, 0x70, 0x72, 0x69,
  0x6c, 0x69, 0x64, 0x65, 0x61, 0x6c, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x65, 0x78,
  0x61, 0x63, 0x74, 0x66, 0x6f, 0x72, 0x74, 0x68, 0x63, 0x6f, 0x64, 0x65, 0x73,
  0x6c, 0x6f, 0x67, 0x69, 0x63, 0x56, 0x69, 0x65, 0x77, 0x20, 0x73, 0x65, 0x65,
  0x6d, 0x73, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x20,
  0x28, 0x32, 0x30, 0x30, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x6e,
  0x6b, 0x67, 0x6f, 0x61, 0x6c, 0x73, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x67, 0x72,
  0x65, 0x65, 0x6b, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x72, 0x69, 0x6e, 0x67, 0x73,
  0x72, 0x61, 0x74, 0x65, 0x64, 0x33, 0x30, 0x70, 0x78, 0x3b, 0x77, 0x68, 0x6f,
  0x73, 0x65, 0x70, 0x61, 0x72, 0x73, 0x65, 0x28, 0x29, 0x3b, 0x22, 0x20, 0x42,
  0x6c, 0x6f, 0x63, 0x6b, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x6a, 0x6f, 0x6e, 0x65,
  0x73, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x27, 0x29, 0x3b, 0x22, 0x3e, 0x29, 0x3b,
  0x69, 0x66, 0x28, 0x2d, 0x6c, 0x65, 0x66, 0x74, 0x64, 0x61, 0x76, 0x69, 0x64,
  0x68, 0x6f, 0x72, 0x73, 0x65, 0x46, 0x6f, 0x63, 0x75, 0x73, 0x72, 0x61, 0x69,
  0x73, 0x65, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x3c, 0x2f, 0x65, 0x6d, 0x3e, 0x62, 0x61, 0x72, 0x22,
  0x3e, 0x2e, 0x73, 0x72, 0x63, 0x3d, 0x74, 0x6f, 0x77, 0x65, 0x72, 0x61, 0x6c,
  0x74, 0x3d, 0x22, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x68, 0x65, 0x6e, 0x72, 0x79,
  0x32, 0x34, 0x70, 0x78, 0x3b, 0x73, 0x65, 0x74, 0x75, 0x70, 0x69, 0x74, 0x61,
  0x6c, 0x79, 0x73, 0x68, 0x61, 0x72, 0x70, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x74,
  0x61, 0x73, 0x74, 0x65, 0x77, 0x61, 0x6e, 0x74, 0x73, 0x74, 0x68, 0x69, 0x73,
  0x2e, 0x72, 0x65, 0x73, 0x65, 0x74, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x67, 0x69,
  0x72, 0x6c, 0x73, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x31, 0x30, 0x30, 0x25, 0x3b,
  0x63, 0x6c, 0x75, 0x62, 0x73, 0x73, 0x74, 0x75, 0x66, 0x66, 0x62, 0x69, 0x62,
  0x6c, 0x65, 0x76, 0x6f, 0x74, 0x65, 0x73, 0x20, 0x31, 0x30, 0x30, 0x30, 0x6b,
  0x6f, 0x72, 0x65, 0x61, 0x7d, 0x29, 0x3b, 0x0d, 0x0a, 0x62, 0x61, 0x6e, 0x64,
  0x73, 0x71, 0x75, 0x65, 0x75, 0x65, 0x3d, 0x20, 0x7b, 0x7d, 0x3b, 0x38, 0x30,
  0x70, 0x78, 0x3b, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x7b, 0x0d, 0x0a, 0x09, 0x09,
  0x61, 0x68, 0x65, 0x61, 0x64, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x72, 0x69,
  0x73, 0x68, 0x6c, 0x69, 0x6b, 0x65, 0x20, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x73,
  0x74, 0x61, 0x74, 0x73, 0x46, 0x6f, 0x72, 0x6d, 0x22, 0x79, 0x61, 0x68, 0x6f,
  0x6f, 0x29, 0x5b, 0x30, 0x5d, 0x3b, 0x41, 0x62, 0x6f, 0x75, 0x74, 0x66, 0x69,
  0x6e, 0x64, 0x73, 0x3c, 0x2f, 0x68, 0x31, 0x3e, 0x64, 0x65, 0x62, 0x75, 0x67,
  0x74, 0x61, 0x73, 0x6b, 0x73, 0x55, 0x52, 0x4c, 0x20, 0x3d, 0x63, 0x65, 0x6c,
  0x6c, 0x73, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x31, 0x32, 0x70, 0x78, 0x3b, 0x70,
  0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x6c, 0x6c, 0x73, 0x74, 0x75, 0x72, 0x6e,
  0x73, 0x30, 0x78, 0x36, 0x30, 0x30, 0x2e, 0x6a, 0x70, 0x67, 0x22, 0x73, 0x70,
  0x61, 0x69, 0x6e, 0x62, 0x65, 0x61, 0x63, 0x68, 0x74, 0x61, 0x78, 0x65, 0x73,
  0x6d, 0x69, 0x63, 0x72, 0x6f, 0x61, 0x6e, 0x67, 0x65, 0x6c, 0x2d, 0x2d, 0x3e,
  0x3c, 0x2f, 0x67, 0x69, 0x66, 0x74, 0x73, 0x73, 0x74, 0x65, 0x76, 0x65, 0x2d,
  0x6c, 0x69, 0x6e, 0x6b, 0x62, 0x6f, 0x64, 0x79, 0x2e, 0x7d, 0x29, 0x3b, 0x0a,
  0x09, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x28, 0x31, 0x39, 0x39, 0x46, 0x41,
  0x51, 0x3c, 0x2f, 0x72, 0x6f, 0x67, 0x65, 0x72, 0x66, 0x72, 0x61, 0x6e, 0x6b,
  0x43, 0x6c, 0x61, 0x73, 0x73, 0x32, 0x38, 0x70, 0x78, 0x3b, 0x66, 0x65, 0x65,
  0x64, 0x73, 0x3c, 0x68, 0x31, 0x3e, 0x3c, 0x73, 0x63, 0x6f, 0x74, 0x74, 0x74,
  0x65, 0x73, 0x74, 0x73, 0x32, 0x32, 0x70, 0x78, 0x3b, 0x64, 0x72, 0x69, 0x6e,
  0x6b, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x6c, 0x65, 0x77, 0x69, 0x73, 0x73, 0x68,
  0x61, 0x6c, 0x6c, 0x23, 0x30, 0x33, 0x39, 0x3b, 0x20, 0x66, 0x6f, 0x72, 0x20,
  0x6c, 0x6f, 0x76, 0x65, 0x64, 0x77, 0x61, 0x73, 0x74, 0x65, 0x30, 0x30, 0x70,
  0x78, 0x3b, 0x6a, 0x61, 0x3a, 0xe3, 0x82, 0x73, 0x69, 0x6d, 0x6f, 0x6e, 0x3c,
  0x66, 0x6f, 0x6e, 0x74, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x6d, 0x65, 0x65, 0x74,
  0x73, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x68, 0x65, 0x61, 0x70, 0x74, 0x69,
  0x67, 0x68, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x29, 0x20, 0x21, 0x3d, 0x20,
  0x64, 0x72, 0x65, 0x73, 0x73, 0x63, 0x6c, 0x69, 0x70, 0x73, 0x72, 0x6f, 0x6f,
  0x6d, 0x73, 0x6f, 0x6e, 0x6b, 0x65, 0x79, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x6d,
  0x61, 0x69, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x20, 0x70, 0x6c, 0x61, 0x74,
  0x65, 0x66, 0x75, 0x6e, 0x6e, 0x79, 0x74, 0x72, 0x65, 0x65, 0x73, 0x63, 0x6f,
  0x6d, 0x2f, 0x22, 0x31, 0x2e, 0x6a, 0x70, 0x67, 0x77, 0x6d, 0x6f, 0x64, 0x65,
  0x70, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x54, 0x41, 0x52, 0x54, 0x6c, 0x65, 0x66,
  0x74, 0x20, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x2c, 0x20, 0x32, 0x30, 0x31, 0x29,
  0x3b, 0x0a, 0x7d, 0x0a, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x69, 0x72, 0x75,
  0x73, 0x63, 0x68, 0x61, 0x69, 0x72, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x77, 0x6f,
  0x72, 0x73, 0x74, 0x50, 0x61, 0x67, 0x65, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x70, 0x61, 0x74, 0x63, 0x68, 0x3c, 0x21, 0x2d, 0x2d, 0x0a, 0x6f, 0x2d, 0x63,
  0x61, 0x63, 0x66, 0x69, 0x72, 0x6d, 0x73, 0x74, 0x6f, 0x75, 0x72, 0x73, 0x2c,
  0x30, 0x30, 0x30, 0x20, 0x61, 0x73, 0x69, 0x61, 0x6e, 0x69, 0x2b, 0x2b, 0x29,
  0x7b, 0x61, 0x64, 0x6f, 0x62, 0x65, 0x27, 0x29, 0x5b, 0x30, 0x5d, 0x69, 0x64,
  0x3d, 0x31, 0x30, 0x62, 0x6f, 0x74, 0x68, 0x3b, 0x6d, 0x65, 0x6e, 0x75, 0x20,
  0x2e, 0x32, 0x2e, 0x6d, 0x69, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x6b, 0x65, 0x76,
  0x69, 0x6e, 0x63, 0x6f, 0x61, 0x63, 0x68, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x62,
  0x72, 0x75, 0x63, 0x65, 0x32, 0x2e, 0x6a, 0x70, 0x67, 0x55, 0x52, 0x4c, 0x29,
  0x2b, 0x2e, 0x6a, 0x70, 0x67, 0x7c, 0x73, 0x75, 0x69, 0x74, 0x65, 0x73, 0x6c,
  0x69, 0x63, 0x65, 0x68, 0x61, 0x72, 0x72, 0x79, 0x31, 0x32, 0x30, 0x22, 0x20,
  0x73, 0x77, 0x65, 0x65, 0x74, 0x74, 0x72, 0x3e, 0x0d, 0x0a, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x64, 0x69, 0x65, 0x67, 0x6f, 0x70, 0x61, 0x67, 0x65, 0x20, 0x73,
  0x77, 0x69, 0x73, 0x73, 0x2d, 0x2d, 0x3e, 0x0a, 0x0a, 0x23, 0x66, 0x66, 0x66,
  0x3b, 0x22, 0x3e, 0x4c, 0x6f, 0x67, 0x2e, 0x63, 0x6f, 0x6d, 0x22, 0x74, 0x72,
  0x65, 0x61, 0x74, 0x73, 0x68, 0x65, 0x65, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
  0x31, 0x34, 0x70, 0x78, 0x3b, 0x73, 0x6c, 0x65, 0x65, 0x70, 0x6e, 0x74, 0x65,
  0x6e, 0x74, 0x66, 0x69, 0x6c, 0x65, 0x64, 0x6a, 0x61, 0x3a, 0xe3, 0x83, 0x69,
  0x64, 0x3d, 0x22, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x77, 0x6f, 0x72, 0x73,
  0x65, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2d, 0x62, 0x6f, 0x78, 0x2d, 0x64, 0x65,
  0x6c, 0x74, 0x61, 0x0a, 0x26, 0x6c, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x73,
  0x3a, 0x34, 0x38, 0x5a, 0x3c, 0x64, 0x61, 0x74, 0x61, 0x2d, 0x72, 0x75, 0x72,
  0x61, 0x6c, 0x3c, 0x2f, 0x61, 0x3e, 0x20, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x62,
  0x61, 0x6b, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x70, 0x73, 0x3d, 0x20, 0x22, 0x22,
  0x3b, 0x70, 0x68, 0x70, 0x22, 0x3e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x31, 0x33,
  0x70, 0x78, 0x3b, 0x62, 0x72, 0x69, 0x61, 0x6e, 0x68, 0x65, 0x6c, 0x6c, 0x6f,
  0x73, 0x69, 0x7a, 0x65, 0x3d, 0x6f, 0x3d, 0x25, 0x32, 0x46, 0x20, 0x6a, 0x6f,
  0x69, 0x6e, 0x6d, 0x61, 0x79, 0x62, 0x65, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x69,
  0x6d, 0x67, 0x22, 0x3e, 0x2c, 0x20, 0x66, 0x6a, 0x73, 0x69, 0x6d, 0x67, 0x22,
  0x20, 0x22, 0x29, 0x5b, 0x30, 0x5d, 0x4d, 0x54, 0x6f, 0x70, 0x42, 0x54, 0x79,
  0x70, 0x65, 0x22, 0x6e, 0x65, 0x77, 0x6c, 0x79, 0x44, 0x61, 0x6e, 0x73, 0x6b,
  0x63, 0x7a, 0x65, 0x63, 0x68, 0x74, 0x72, 0x61, 0x69, 0x6c, 0x6b, 0x6e, 0x6f,
  0x77, 0x73, 0x3c, 0x2f, 0x68, 0x35, 0x3e, 0x66, 0x61, 0x71, 0x22, 0x3e, 0x7a,
  0x68, 0x2d, 0x63, 0x6e, 0x31, 0x30, 0x29, 0x3b, 0x0a, 0x2d, 0x31, 0x22, 0x29,
  0x3b, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x62, 0x6c, 0x75, 0x65, 0x73, 0x74, 0x72,
  0x75, 0x6c, 0x79, 0x64, 0x61, 0x76, 0x69, 0x73, 0x2e, 0x6a, 0x73, 0x27, 0x3b,
  0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x73, 0x74, 0x65, 0x65, 0x6c, 0x20, 0x79, 0x6f,
  0x75, 0x20, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6a,
  0x65, 0x73, 0x75, 0x73, 0x31, 0x30, 0x30, 0x25, 0x20, 0x6d, 0x65, 0x6e, 0x75,
  0x2e, 0x0d, 0x0a, 0x09, 0x0d, 0x0a, 0x77, 0x61, 0x6c, 0x65, 0x73, 0x72, 0x69,
  0x73, 0x6b, 0x73, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x64, 0x64, 0x69, 0x6e, 0x67,
  0x62, 0x2d, 0x6c, 0x69, 0x6b, 0x74, 0x65, 0x61, 0x63, 0x68, 0x67, 0x69, 0x66,
  0x22, 0x20, 0x76, 0x65, 0x67, 0x61, 0x73, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x65,
  0x65, 0x73, 0x74, 0x69, 0x73, 0x68, 0x71, 0x69, 0x70, 0x73, 0x75, 0x6f, 0x6d,
  0x69, 0x73, 0x6f, 0x62, 0x72, 0x65, 0x64, 0x65, 0x73, 0x64, 0x65, 0x65, 0x6e,
  0x74, 0x72, 0x65, 0x74, 0x6f, 0x64, 0x6f, 0x73, 0x70, 0x75, 0x65, 0x64, 0x65,
  0x61, 0xc3, 0xb1, 0x6f, 0x73, 0x65, 0x73, 0x74, 0xc3, 0xa1, 0x74, 0x69, 0x65,
  0x6e, 0x65, 0x68, 0x61, 0x73, 0x74, 0x61, 0x6f, 0x74, 0x72, 0x6f, 0x73, 0x70,
  0x61, 0x72, 0x74, 0x65, 0x64, 0x6f, 0x6e, 0x64, 0x65, 0x6e, 0x75, 0x65, 0x76,
  0x6f, 0x68, 0x61, 0x63, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6d, 0x69,
  0x73, 0x6d, 0x6f, 0x6d, 0x65, 0x6a, 0x6f, 0x72, 0x6d, 0x75, 0x6e, 0x64, 0x6f,
  0x61, 0x71, 0x75, 0xc3, 0xad, 0x64, 0xc3, 0xad, 0x61, 0x73, 0x73, 0xc3, 0xb3,
  0x6c, 0x6f, 0x61, 0x79, 0x75, 0x64, 0x61, 0x66, 0x65, 0x63, 0x68, 0x61, 0x74,
  0x6f, 0x64, 0x61, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x6f, 0x6d, 0x65, 0x6e, 0x6f,
  0x73, 0x64, 0x61, 0x74, 0x6f, 0x73, 0x6f, 0x74, 0x72, 0x61, 0x73, 0x73, 0x69,
  0x74, 0x69, 0x6f, 0x6d, 0x75, 0x63, 0x68, 0x6f, 0x61, 0x68, 0x6f, 0x72, 0x61,
  0x6c, 0x75, 0x67, 0x61, 0x72, 0x6d, 0x61, 0x79, 0x6f, 0x72, 0x65, 0x73, 0x74,
  0x6f, 0x73, 0x68, 0x6f, 0x72, 0x61, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x61,
  0x6e, 0x74, 0x65, 0x73, 0x66, 0x6f, 0x74, 0x6f, 0x73, 0x65, 0x73, 0x74, 0x61,
  0x73, 0x70, 0x61, 0xc3, 0xad, 0x73, 0x6e, 0x75, 0x65, 0x76, 0x61, 0x73, 0x61,
  0x6c, 0x75, 0x64, 0x66, 0x6f, 0x72, 0x6f, 0x73, 0x6d, 0x65, 0x64, 0x69, 0x6f,
  0x71, 0x75, 0x69, 0x65, 0x6e, 0x6d, 0x65, 0x73, 0x65, 0x73, 0x70, 0x6f, 0x64,
  0x65, 0x72, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x72, 0xc3, 0xa1, 0x76,
  0x65, 0x63, 0x65, 0x73, 0x64, 0x65, 0x63, 0x69, 0x72, 0x6a, 0x6f, 0x73, 0xc3,
  0xa9, 0x65, 0x73, 0x74, 0x61, 0x72, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x72,
  0x75, 0x70, 0x6f, 0x68, 0x65, 0x63, 0x68, 0x6f, 0x65, 0x6c, 0x6c, 0x6f, 0x73,
  0x74, 0x65, 0x6e, 0x67, 0x6f, 0x61, 0x6d, 0x69, 0x67, 0x6f, 0x63, 0x6f, 0x73,
  0x61, 0x73, 0x6e, 0x69, 0x76, 0x65, 0x6c, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6d,
  0x69, 0x73, 0x6d, 0x61, 0x61, 0x69, 0x72, 0x65, 0x73, 0x6a, 0x75, 0x6c, 0x69,
  0x6f, 0x74, 0x65, 0x6d, 0x61, 0x73, 0x68, 0x61, 0x63, 0x69, 0x61, 0x66, 0x61,
  0x76, 0x6f, 0x72, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x6c, 0x69, 0x62, 0x72, 0x65,
  0x70, 0x75, 0x6e, 0x74, 0x6f, 0x62, 0x75, 0x65, 0x6e, 0x6f, 0x61, 0x75, 0x74,
  0x6f, 0x72, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x62, 0x75, 0x65, 0x6e, 0x61, 0x74,
  0x65, 0x78, 0x74, 0x6f, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x73, 0x61, 0x62, 0x65,
  0x72, 0x6c, 0x69, 0x73, 0x74, 0x61, 0x6c, 0x75, 0x65, 0x67, 0x6f, 0x63, 0xc3,
  0xb3, 0x6d, 0x6f, 0x65, 0x6e, 0x65, 0x72, 0x6f, 0x6a, 0x75, 0x65, 0x67, 0x6f,
  0x70, 0x65, 0x72, 0xc3, 0xba, 0x68, 0x61, 0x62, 0x65, 0x72, 0x65, 0x73, 0x74,
  0x6f, 0x79, 0x6e, 0x75, 0x6e, 0x63, 0x61, 0x6d, 0x75, 0x6a, 0x65, 0x72, 0x76,
  0x61, 0x6c, 0x6f, 0x72, 0x66, 0x75, 0x65, 0x72, 0x61, 0x6c, 0x69, 0x62, 0x72,
  0x6f, 0x67, 0x75, 0x73, 0x74, 0x61, 0x69, 0x67, 0x75, 0x61, 0x6c, 0x76, 0x6f,
  0x74, 0x6f, 0x73, 0x63, 0x61, 0x73, 0x6f, 0x73, 0x67, 0x75, 0xc3, 0xad, 0x61,
  0x70, 0x75, 0x65, 0x64, 0x6f, 0x73, 0x6f, 0x6d, 0x6f, 0x73, 0x61, 0x76, 0x69,
  0x73, 0x6f, 0x75, 0x73, 0x74, 0x65, 0x64, 0x64, 0x65, 0x62, 0x65, 0x6e, 0x6e,
  0x6f, 0x63, 0x68, 0x65, 0x62, 0x75, 0x73, 0x63, 0x61, 0x66, 0x61, 0x6c, 0x74,
  0x61, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x73, 0x65, 0x72, 0x69, 0x65, 0x64, 0x69,
  0x63, 0x68, 0x6f, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x63, 0x6c, 0x61, 0x76, 0x65,
  0x63, 0x61, 0x73, 0x61, 0x73, 0x6c, 0x65, 0xc3, 0xb3, 0x6e, 0x70, 0x6c, 0x61,
  0x7a, 0x6f, 0x6c, 0x61, 0x72, 0x67, 0x6f, 0x6f, 0x62, 0x72, 0x61, 0x73, 0x76,
  0x69, 0x73, 0x74, 0x61, 0x61, 0x70, 0x6f, 0x79, 0x6f, 0x6a, 0x75, 0x6e, 0x74,
  0x6f, 0x74, 0x72, 0x61, 0x74, 0x61, 0x76, 0x69, 0x73, 0x74, 0x6f, 0x63, 0x72,
  0x65, 0x61, 0x72, 0x63, 0x61, 0x6d, 0x70, 0x6f, 0x68, 0x65, 0x6d, 0x6f, 0x73,
  0x63, 0x69, 0x6e, 0x63, 0x6f, 0x63, 0x61, 0x72, 0x67, 0x6f, 0x70, 0x69, 0x73,
  0x6f, 0x73, 0x6f, 0x72, 0x64, 0x65, 0x6e, 0x68, 0x61, 0x63, 0x65, 0x6e, 0xc3,
  0xa1, 0x72, 0x65, 0x61, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x72,
  0x6f, 0x63, 0x65, 0x72, 0x63, 0x61, 0x70, 0x75, 0x65, 0x64, 0x61, 0x70, 0x61,
  0x70, 0x65, 0x6c, 0x6d, 0x65, 0x6e, 0x6f, 0x72, 0xc3, 0xba, 0x74, 0x69, 0x6c,
  0x63, 0x6c, 0x61, 0x72, 0x6f, 0x6a, 0x6f, 0x72, 0x67, 0x65, 0x63, 0x61, 0x6c,
  0x6c, 0x65, 0x70, 0x6f, 0x6e, 0x65, 0x72, 0x74, 0x61, 0x72, 0x64, 0x65, 0x6e,
  0x61, 0x64, 0x69, 0x65, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x73, 0x69, 0x67, 0x75,
  0x65, 0x65, 0x6c, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6c, 0x6f, 0x63, 0x6f,
  0x63, 0x68, 0x65, 0x6d, 0x6f, 0x74, 0x6f, 0x73, 0x6d, 0x61, 0x64, 0x72, 0x65,
  0x63, 0x6c, 0x61, 0x73, 0x65, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x6e, 0x69, 0xc3,
  0xb1, 0x6f, 0x71, 0x75, 0x65, 0x64, 0x61, 0x70, 0x61, 0x73, 0x61, 0x72, 0x62,
  0x61, 0x6e, 0x63, 0x6f, 0x68, 0x69, 0x6a, 0x6f, 0x73, 0x76, 0x69, 0x61, 0x6a,
  0x65, 0x70, 0x61, 0x62, 0x6c, 0x6f, 0xc3, 0xa9, 0x73, 0x74, 0x65, 0x76, 0x69,
  0x65, 0x6e, 0x65, 0x72, 0x65, 0x69, 0x6e, 0x6f, 0x64, 0x65, 0x6a, 0x61, 0x72,
  0x66, 0x6f, 0x6e, 0x64, 0x6f, 0x63, 0x61, 0x6e, 0x61, 0x6c, 0x6e, 0x6f, 0x72,
  0x74, 0x65, 0x6c, 0x65, 0x74, 0x72, 0x61, 0x63, 0x61, 0x75, 0x73, 0x61, 0x74,
  0x6f, 0x6d, 0x61, 0x72, 0x6d, 0x61, 0x6e, 0x6f, 0x73, 0x6c, 0x75, 0x6e, 0x65,
  0x73, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x76, 0x69, 0x6c, 0x6c, 0x61, 0x76, 0x65,
  0x6e, 0x64, 0x6f, 0x70, 0x65, 0x73, 0x61, 0x72, 0x74, 0x69, 0x70, 0x6f, 0x73,
  0x74, 0x65, 0x6e, 0x67, 0x61, 0x6d, 0x61, 0x72, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
  0x76, 0x61, 0x70, 0x61, 0x64, 0x72, 0x65, 0x75, 0x6e, 0x69, 0x64, 0x6f, 0x76,
  0x61, 0x6d, 0x6f, 0x73, 0x7a, 0x6f, 0x6e, 0x61, 0x73, 0x61, 0x6d, 0x62, 0x6f,
  0x73, 0x62, 0x61, 0x6e, 0x64, 0x61, 0x6d, 0x61, 0x72, 0x69, 0x61, 0x61, 0x62,
  0x75, 0x73, 0x6f, 0x6d, 0x75, 0x63, 0x68, 0x61, 0x73, 0x75, 0x62, 0x69, 0x72,
  0x72, 0x69, 0x6f, 0x6a, 0x61, 0x76, 0x69, 0x76, 0x69, 0x72, 0x67, 0x72, 0x61,
  0x64, 0x6f, 0x63, 0x68, 0x69, 0x63, 0x61, 0x61, 0x6c, 0x6c, 0xc3, 0xad, 0x6a,
  0x6f, 0x76, 0x65, 0x6e, 0x64, 0x69, 0x63, 0x68, 0x61, 0x65, 0x73, 0x74, 0x61,
  0x6e, 0x74, 0x61, 0x6c, 0x65, 0x73, 0x73, 0x61, 0x6c, 0x69, 0x72, 0x73, 0x75,
  0x65, 0x6c, 0x6f, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x66, 0x69, 0x6e, 0x65, 0x73,
  0x6c, 0x6c, 0x61, 0x6d, 0x61, 0x62, 0x75, 0x73, 0x63, 0x6f, 0xc3, 0xa9, 0x73,
  0x74, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x61, 0x6e, 0x65, 0x67, 0x72, 0x6f, 0x70,
  0x6c, 0x61, 0x7a, 0x61, 0x68, 0x75, 0x6d, 0x6f, 0x72, 0x70, 0x61, 0x67, 0x61,
  0x72, 0x6a, 0x75, 0x6e, 0x74, 0x61, 0x64, 0x6f, 0x62, 0x6c, 0x65, 0x69, 0x73,
  0x6c, 0x61, 0x73, 0x62, 0x6f, 0x6c, 0x73, 0x61, 0x62, 0x61, 0xc3, 0xb1, 0x6f,
  0x68, 0x61, 0x62, 0x6c, 0x61, 0x6c, 0x75, 0x63, 0x68, 0x61, 0xc3, 0x81, 0x72,
  0x65, 0x61, 0x64, 0x69, 0x63, 0x65, 0x6e, 0x6a, 0x75, 0x67, 0x61, 0x72, 0x6e,
  0x6f, 0x74, 0x61, 0x73, 0x76, 0x61, 0x6c, 0x6c, 0x65, 0x61, 0x6c, 0x6c, 0xc3,
  0xa1, 0x63, 0x61, 0x72, 0x67, 0x61, 0x64, 0x6f, 0x6c, 0x6f, 0x72, 0x61, 0x62,
  0x61, 0x6a, 0x6f, 0x65, 0x73, 0x74, 0xc3, 0xa9, 0x67, 0x75, 0x73, 0x74, 0x6f,
  0x6d, 0x65, 0x6e, 0x74, 0x65, 0x6d, 0x61, 0x72, 0x69, 0x6f, 0x66, 0x69, 0x72,
  0x6d, 0x61, 0x63, 0x6f, 0x73, 0x74, 0x6f, 0x66, 0x69, 0x63, 0x68, 0x61, 0x70,
  0x6c, 0x61, 0x74, 0x61, 0x68, 0x6f, 0x67, 0x61, 0x72, 0x61, 0x72, 0x74, 0x65,
  0x73, 0x6c, 0x65, 0x79, 0x65, 0x73, 0x61, 0x71, 0x75, 0x65, 0x6c, 0x6d, 0x75,
  0x73, 0x65, 0x6f, 0x62, 0x61, 0x73, 0x65, 0x73, 0x70, 0x6f, 0x63, 0x6f, 0x73,
  0x6d, 0x69, 0x74, 0x61, 0x64, 0x63, 0x69, 0x65, 0x6c, 0x6f, 0x63, 0x68, 0x69,
  0x63, 0x6f, 0x6d, 0x69, 0x65, 0x64, 0x6f, 0x67, 0x61, 0x6e, 0x61, 0x72, 0x73,
  0x61, 0x6e, 0x74, 0x6f, 0x65, 0x74, 0x61, 0x70, 0x61, 0x64, 0x65, 0x62, 0x65,
  0x73, 0x70, 0x6c, 0x61, 0x79, 0x61, 0x72, 0x65, 0x64, 0x65, 0x73, 0x73, 0x69,
  0x65, 0x74, 0x65, 0x63, 0x6f, 0x72, 0x74, 0x65, 0x63, 0x6f, 0x72, 0x65, 0x61,
  0x64, 0x75, 0x64, 0x61, 0x73, 0x64, 0x65, 0x73, 0x65, 0x6f, 0x76, 0x69, 0x65,
  0x6a, 0x6f, 0x64, 0x65, 0x73, 0x65, 0x61, 0x61, 0x67, 0x75, 0x61, 0x73, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x63, 0x6f,
  0x6d, 0x6d, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x76, 0x65,
  0x6e, 0x74, 0x73, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x73, 0x79, 0x73, 0x74,
  0x65, 0x6d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x61, 0x6e, 0x6e, 0x65,
  0x72, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x73, 0x63, 0x72, 0x6f, 0x6c, 0x6c,
  0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x6d,
  0x65, 0x64, 0x69, 0x75, 0x6d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x75,
  0x6d, 0x62, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x65, 0x73,
  0x75, 0x6c, 0x74, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x73, 0x63, 0x72, 0x65,
  0x65, 0x6e, 0x63, 0x68, 0x6f, 0x6f, 0x73, 0x65, 0x6e, 0x6f, 0x72, 0x6d, 0x61,
  0x6c, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73,
  0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
  0x70, 0x72, 0x69, 0x6e, 0x67, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x6d, 0x6f,
  0x62, 0x69, 0x6c, 0x65, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x70, 0x68, 0x6f,
  0x74, 0x6f, 0x73, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x72, 0x65, 0x67, 0x69,
  0x6f, 0x6e, 0x69, 0x74, 0x73, 0x65, 0x6c, 0x66, 0x73, 0x6f, 0x63, 0x69, 0x61,
  0x6c, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
  0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x74,
  0x69, 0x74, 0x6c, 0x65, 0x3e, 0x65, 0x69, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x65,
  0x6e, 0x67, 0x74, 0x68, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x66, 0x72, 0x69,
  0x65, 0x6e, 0x64, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x61, 0x75, 0x74, 0x68,
  0x6f, 0x72, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x65, 0x76, 0x69, 0x65,
  0x77, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
  0x70, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x65,
  0x78, 0x70, 0x61, 0x6e, 0x64, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x66, 0x6f,
  0x72, 0x6d, 0x61, 0x74, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x70, 0x6f, 0x69,
  0x6e, 0x74, 0x73, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x70, 0x65, 0x72, 0x73,
  0x6f, 0x6e, 0x6c, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x73, 0x69, 0x67,
  0x6e, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x73, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x73,
  0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x6e, 0x61,
  0x74, 0x75, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x66, 0x69, 0x67,
  0x75, 0x72, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x63, 0x75, 0x73, 0x74,
  0x6f, 0x6d, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x6c, 0x65, 0x74, 0x74, 0x65,
  0x72, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74,
  0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x75,
  0x70, 0x6c, 0x6f, 0x61, 0x64, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x6d, 0x65,
  0x74, 0x68, 0x6f, 0x64, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x73, 0x63, 0x68,
  0x6f, 0x6f, 0x6c, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x73, 0x68, 0x61, 0x64,
  0x6f, 0x77, 0x64, 0x65, 0x62, 0x61, 0x74, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x65,
  0x73, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73,
  0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x6c, 0x65, 0x61, 0x67, 0x75, 0x65, 0x63,
  0x68, 0x72, 0x6f, 0x6d, 0x65, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6e, 0x6f,
  0x74, 0x69, 0x63, 0x65, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x64,
  0x69, 0x6e, 0x67, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x72, 0x65, 0x70, 0x6f,
  0x72, 0x74, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x71, 0x75, 0x61, 0x72,
  0x65, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73,
  0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x6f, 0x76, 0x69, 0x6e, 0x67, 0x6c,
  0x61, 0x74, 0x65, 0x73, 0x74, 0x77, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x46, 0x72,
  0x61, 0x6e, 0x63, 0x65, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x74, 0x72,
  0x6f, 0x6e, 0x67, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x4c, 0x6f, 0x6e, 0x64,
  0x6f, 0x6e, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x66, 0x6f, 0x72, 0x6d, 0x65,
  0x64, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65,
  0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x74, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x70,
  0x6c, 0x61, 0x63, 0x65, 0x73, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x74,
  0x61, 0x74, 0x69, 0x63, 0x63, 0x69, 0x74, 0x69, 0x65, 0x73, 0x73, 0x74, 0x72,
  0x65, 0x61, 0x6d, 0x79, 0x65, 0x6c, 0x6c, 0x6f, 0x77, 0x61, 0x74, 0x74, 0x61,
  0x63, 0x6b, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x66, 0x6c, 0x69, 0x67, 0x68,
  0x74, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x3e,
  0x6f, 0x70, 0x65, 0x6e, 0x65, 0x64, 0x75, 0x73, 0x65, 0x66, 0x75, 0x6c, 0x76,
  0x61, 0x6c, 0x6c, 0x65, 0x79, 0x63, 0x61, 0x75, 0x73, 0x65, 0x73, 0x6c, 0x65,
  0x61, 0x64, 0x65, 0x72, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x65, 0x63,
  0x6f, 0x6e, 0x64, 0x64, 0x61, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x70, 0x6f, 0x72,
  0x74, 0x73, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6e,
  0x67, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
  0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x73,
  0x74, 0x61, 0x74, 0x65, 0x73, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x65, 0x76, 0x69,
  0x73, 0x75, 0x61, 0x6c, 0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x76, 0x6f, 0x6c,
  0x75, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x6d, 0x75, 0x73, 0x65,
  0x75, 0x6d, 0x6d, 0x6f, 0x76, 0x69, 0x65, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e,
  0x74, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x6f, 0x73, 0x74, 0x6c, 0x79,
  0x6d, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x22, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x6d,
  0x61, 0x72, 0x6b, 0x65, 0x74, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x63, 0x68,
  0x61, 0x6e, 0x63, 0x65, 0x73, 0x75, 0x72, 0x76, 0x65, 0x79, 0x62, 0x65, 0x66,
  0x6f, 0x72, 0x65, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x6d, 0x6f, 0x6d, 0x65,
  0x6e, 0x74, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
  0x6e, 0x69, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72,
  0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x65,
  0x78, 0x69, 0x73, 0x74, 0x73, 0x6d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x45, 0x75,
  0x72, 0x6f, 0x70, 0x65, 0x67, 0x72, 0x6f, 0x77, 0x74, 0x68, 0x6c, 0x65, 0x67,
  0x61, 0x63, 0x79, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x65, 0x6e, 0x6f, 0x75,
  0x67, 0x68, 0x63, 0x61, 0x72, 0x65, 0x65, 0x72, 0x61, 0x6e, 0x73, 0x77, 0x65,
  0x72, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6c,
  0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72,
  0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x64, 0x74, 0x6f,
  0x70, 0x69, 0x63, 0x73, 0x63, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x66, 0x61, 0x74,
  0x68, 0x65, 0x72, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x69, 0x6d, 0x70,
  0x6c, 0x79, 0x72, 0x61, 0x69, 0x73, 0x65, 0x64, 0x65, 0x73, 0x63, 0x61, 0x70,
  0x65, 0x63, 0x68, 0x6f, 0x73, 0x65, 0x6e, 0x63, 0x68, 0x75, 0x72, 0x63, 0x68,
  0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x63,
  0x6f, 0x72, 0x6e, 0x65, 0x72, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x6d, 0x65,
  0x6d, 0x6f, 0x72, 0x79, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x70, 0x6f, 0x6c,
  0x69, 0x63, 0x65, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x4e, 0x75, 0x6d, 0x62,
  0x65, 0x72, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x6f, 0x66, 0x66, 0x65, 0x72,
  0x73, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64,
  0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x73,
  0x69, 0x6c, 0x76, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x64, 0x65,
  0x6c, 0x65, 0x74, 0x65, 0x62, 0x65, 0x74, 0x74, 0x65, 0x72, 0x62, 0x72, 0x6f,
  0x77, 0x73, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x47, 0x6c, 0x6f, 0x62,
  0x61, 0x6c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x77, 0x69, 0x64, 0x67, 0x65,
  0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
  0x6e, 0x6f, 0x77, 0x72, 0x61, 0x70, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x63,
  0x6c, 0x61, 0x69, 0x6d, 0x73, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x61,
  0x66, 0x65, 0x74, 0x79, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x70, 0x69,
  0x72, 0x69, 0x74, 0x2d, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x70, 0x72, 0x65,
  0x61, 0x64, 0x6d, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x6e, 0x65, 0x65, 0x64, 0x65,
  0x64, 0x72, 0x75, 0x73, 0x73, 0x69, 0x61, 0x70, 0x6c, 0x65, 0x61, 0x73, 0x65,
  0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x62,
  0x72, 0x6f, 0x6b, 0x65, 0x6e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x63, 0x68,
  0x61, 0x72, 0x67, 0x65, 0x64, 0x69, 0x76, 0x69, 0x64, 0x65, 0x66, 0x61, 0x63,
  0x74, 0x6f, 0x72, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x2d, 0x62, 0x61, 0x73,
  0x65, 0x64, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x79, 0x63, 0x6f, 0x6e, 0x66, 0x69,
  0x67, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x64,
  0x68, 0x65, 0x6c, 0x70, 0x65, 0x64, 0x43, 0x68, 0x75, 0x72, 0x63, 0x68, 0x69,
  0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x61, 0x6c,
  0x77, 0x61, 0x79, 0x73, 0x6c, 0x6f, 0x67, 0x6f, 0x22, 0x20, 0x62, 0x6f, 0x74,
  0x74, 0x6f, 0x6d, 0x6c, 0x69, 0x73, 0x74, 0x22, 0x3e, 0x29, 0x7b, 0x76, 0x61,
  0x72, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6f, 0x72, 0x61, 0x6e, 0x67,
  0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x75, 0x73, 0x68, 0x28,
  0x63, 0x6f, 0x75, 0x70, 0x6c, 0x65, 0x67, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x62,
  0x72, 0x69, 0x64, 0x67, 0x65, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x52, 0x65,
  0x76, 0x69, 0x65, 0x77, 0x74, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x76, 0x69, 0x73,
  0x69, 0x6f, 0x6e, 0x6c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x69,
  0x6e, 0x67, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x62, 0x65, 0x61, 0x75, 0x74,
  0x79, 0x74, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x66, 0x6f, 0x72, 0x67, 0x6f, 0x74,
  0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x61,
  0x6c, 0x6d, 0x6f, 0x73, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x64, 0x43, 0x68,
  0x61, 0x6e, 0x67, 0x65, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x74, 0x72,
  0x69, 0x6e, 0x67, 0x72, 0x65, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x6f, 0x62, 0x69,
  0x6c, 0x65, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x65, 0x73, 0x75, 0x70, 0x70, 0x6c,
  0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73,
  0x76, 0x69, 0x65, 0x77, 0x65, 0x64, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x63,
  0x6f, 0x75, 0x72, 0x73, 0x65, 0x41, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x69, 0x73,
  0x6c, 0x61, 0x6e, 0x64, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x63, 0x6f, 0x6f,
  0x6b, 0x69, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x6d, 0x61, 0x7a,
  0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x6e, 0x61, 0x64, 0x76, 0x69, 0x63,
  0x65, 0x69, 0x6e, 0x3c, 0x2f, 0x61, 0x3e, 0x3a, 0x20, 0x54, 0x68, 0x65, 0x20,
  0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x73, 0x42,
  0x45, 0x47, 0x49, 0x4e, 0x20, 0x4d, 0x65, 0x78, 0x69, 0x63, 0x6f, 0x73, 0x74,
  0x61, 0x72, 0x74, 0x73, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x68, 0x65, 0x69,
  0x67, 0x68, 0x74, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x73, 0x6c, 0x61,
  0x6e, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x45, 0x6d, 0x70, 0x69, 0x72,
  0x65, 0x53, 0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74,
  0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x6d,
  0x61, 0x6e, 0x75, 0x61, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x2e, 0x0a,
  0x0a, 0x4f, 0x6e, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x6d, 0x65, 0x6e,
  0x75, 0x22, 0x3e, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x61, 0x77, 0x61, 0x72,
  0x64, 0x73, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x69, 0x6d, 0x70, 0x6f, 0x72,
  0x74, 0x4f, 0x66, 0x66, 0x69, 0x63, 0x65, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64,
  0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x73, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
  0x70, 0x6f, 0x72, 0x74, 0x73, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x77, 0x65,
  0x65, 0x6b, 0x6c, 0x79, 0x20, 0x28, 0x65, 0x2e, 0x67, 0x2e, 0x62, 0x65, 0x68,
  0x69, 0x6e, 0x64, 0x64, 0x6f, 0x63, 0x74, 0x6f, 0x72, 0x6c, 0x6f, 0x67, 0x67,
  0x65, 0x64, 0x75, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x3c, 0x2f, 0x62, 0x3e, 0x3c,
  0x2f, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x73, 0x70, 0x6c, 0x61, 0x6e, 0x74, 0x73,
  0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x73, 0x74, 0x69,
  0x73, 0x73, 0x75, 0x65, 0x64, 0x33, 0x30, 0x30, 0x70, 0x78, 0x7c, 0x63, 0x61,
  0x6e, 0x61, 0x64, 0x61, 0x61, 0x67, 0x65, 0x6e, 0x63, 0x79, 0x73, 0x63, 0x68,
  0x65, 0x6d, 0x65, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x42, 0x72, 0x61, 0x7a,
  0x69, 0x6c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x6c, 0x6f, 0x67, 0x6f, 0x22,
  0x3e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x2d, 0x73, 0x63, 0x61, 0x6c, 0x65,
  0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x6d,
  0x61, 0x72, 0x69, 0x6e, 0x65, 0x46, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x63, 0x61,
  0x6d, 0x65, 0x72, 0x61, 0x3c, 0x2f, 0x68, 0x31, 0x3e, 0x0a, 0x5f, 0x66, 0x6f,
  0x72, 0x6d, 0x22, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x73, 0x74, 0x72, 0x65,
  0x73, 0x73, 0x22, 0x20, 0x2f, 0x3e, 0x0d, 0x0a, 0x2e, 0x67, 0x69, 0x66, 0x22,
  0x20, 0x6f, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72,
  0x4f, 0x78, 0x66, 0x6f, 0x72, 0x64, 0x73, 0x69, 0x73, 0x74, 0x65, 0x72, 0x73,
  0x75, 0x72, 0x76, 0x69, 0x76, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x66, 0x65,
  0x6d, 0x61, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x73, 0x69, 0x7a,
  0x65, 0x3d, 0x22, 0x61, 0x70, 0x70, 0x65, 0x61, 0x6c, 0x74, 0x65, 0x78, 0x74,
  0x22, 0x3e, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x74, 0x68, 0x61, 0x6e, 0x6b,
  0x73, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64,
  0x61, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x61, 0x6e, 0x79, 0x6f, 0x6e, 0x65, 0x41,
  0x66, 0x72, 0x69, 0x63, 0x61, 0x61, 0x67, 0x72, 0x65, 0x65, 0x64, 0x72, 0x65,
  0x63, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x3c, 0x62, 0x72,
  0x20, 0x2f, 0x3e, 0x77, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x70, 0x72, 0x69, 0x63,
  0x65, 0x73, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x7c, 0x7c, 0x20, 0x7b, 0x7d,
  0x3b, 0x6d, 0x61, 0x69, 0x6e, 0x22, 0x3e, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
  0x73, 0x75, 0x6e, 0x64, 0x61, 0x79, 0x77, 0x72, 0x61, 0x70, 0x22, 0x3e, 0x66,
  0x61, 0x69, 0x6c, 0x65, 0x64, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x6d, 0x69,
  0x6e, 0x75, 0x74, 0x65, 0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x71, 0x75, 0x6f,
  0x74, 0x65, 0x73, 0x31, 0x35, 0x30, 0x70, 0x78, 0x7c, 0x65, 0x73, 0x74, 0x61,
  0x74, 0x65, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x65, 0x6d, 0x61, 0x69, 0x6c,
  0x22, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x72, 0x69, 0x67, 0x68, 0x74, 0x3b,
  0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x31,
  0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x73, 0x69, 0x67, 0x6e, 0x75, 0x70, 0x70, 0x72,
  0x69, 0x6e, 0x63, 0x65, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x3a, 0x2e, 0x70, 0x6e,
  0x67, 0x22, 0x20, 0x66, 0x6f, 0x72, 0x75, 0x6d, 0x2e, 0x41, 0x63, 0x63, 0x65,
  0x73, 0x73, 0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x73, 0x6f, 0x75, 0x6e, 0x64,
  0x73, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x73, 0x6c, 0x69, 0x64, 0x65, 0x72, 0x55, 0x54, 0x46, 0x2d, 0x38, 0x22, 0x26,
  0x61, 0x6d, 0x70, 0x3b, 0x20, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x2e, 0x20,
  0x57, 0x69, 0x74, 0x68, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x6f, 0x77, 0x6e,
  0x65, 0x72, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x70, 0x72, 0x6f, 0x66,
  0x69, 0x74, 0x6a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x61, 0x6e, 0x6e, 0x75, 0x61,
  0x6c, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x62, 0x6f, 0x75, 0x67, 0x68, 0x74,
  0x66, 0x61, 0x6d, 0x6f, 0x75, 0x73, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x6c,
  0x6f, 0x6e, 0x67, 0x65, 0x72, 0x69, 0x2b, 0x2b, 0x29, 0x20, 0x7b, 0x69, 0x73,
  0x72, 0x61, 0x65, 0x6c, 0x73, 0x61, 0x79, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x63,
  0x69, 0x64, 0x65, 0x68, 0x6f, 0x6d, 0x65, 0x22, 0x3e, 0x68, 0x65, 0x61, 0x64,
  0x65, 0x72, 0x65, 0x6e, 0x73, 0x75, 0x72, 0x65, 0x62, 0x72, 0x61, 0x6e, 0x63,
  0x68, 0x70, 0x69, 0x65, 0x63, 0x65, 0x73, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x3b,
  0x73, 0x74, 0x61, 0x74, 0x65, 0x64, 0x74, 0x6f, 0x70, 0x22, 0x3e, 0x3c, 0x72,
  0x61, 0x63, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x2d, 0x2d,
  0x26, 0x67, 0x74, 0x3b, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x73, 0x65, 0x78,
  0x75, 0x61, 0x6c, 0x62, 0x75, 0x72, 0x65, 0x61, 0x75, 0x2e, 0x6a, 0x70, 0x67,
  0x22, 0x20, 0x31, 0x30, 0x2c, 0x30, 0x30, 0x30, 0x6f, 0x62, 0x74, 0x61, 0x69,
  0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x73, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
  0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x63, 0x6f, 0x6d, 0x65, 0x64, 0x79, 0x6d,
  0x65, 0x6e, 0x75, 0x22, 0x20, 0x6c, 0x79, 0x72, 0x69, 0x63, 0x73, 0x74, 0x6f,
  0x64, 0x61, 0x79, 0x2e, 0x69, 0x6e, 0x64, 0x65, 0x65, 0x64, 0x63, 0x6f, 0x75,
  0x6e, 0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x6f, 0x2e, 0x46, 0x61, 0x6d, 0x69,
  0x6c, 0x79, 0x6c, 0x6f, 0x6f, 0x6b, 0x65, 0x64, 0x4d, 0x61, 0x72, 0x6b, 0x65,
  0x74, 0x6c, 0x73, 0x65, 0x20, 0x69, 0x66, 0x50, 0x6c, 0x61, 0x79, 0x65, 0x72,
  0x74, 0x75, 0x72, 0x6b, 0x65, 0x79, 0x29, 0x3b, 0x76, 0x61, 0x72, 0x20, 0x66,
  0x6f, 0x72, 0x65, 0x73, 0x74, 0x67, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x65, 0x72,
  0x72, 0x6f, 0x72, 0x73, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x7d, 0x65, 0x6c,
  0x73, 0x65, 0x7b, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x42, 0x6c, 0x6f, 0x67,
  0x3c, 0x2f, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x6c, 0x6f, 0x67, 0x69, 0x6e,
  0x2e, 0x66, 0x61, 0x73, 0x74, 0x65, 0x72, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
  0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x31, 0x30, 0x70, 0x78, 0x20, 0x30, 0x70,
  0x72, 0x61, 0x67, 0x6d, 0x61, 0x66, 0x72, 0x69, 0x64, 0x61, 0x79, 0x6a, 0x75,
  0x6e, 0x69, 0x6f, 0x72, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x70, 0x6c, 0x61,
  0x63, 0x65, 0x64, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x73, 0x70, 0x6c, 0x75, 0x67,
  0x69, 0x6e, 0x35, 0x2c, 0x30, 0x30, 0x30, 0x20, 0x70, 0x61, 0x67, 0x65, 0x22,
  0x3e, 0x62, 0x6f, 0x73, 0x74, 0x6f, 0x6e, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x28,
  0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x74, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f,
  0x63, 0x6f, 0x75, 0x6e, 0x74, 0x66, 0x6f, 0x72, 0x75, 0x6d, 0x73, 0x73, 0x63,
  0x68, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2c, 0x66, 0x69, 0x6c,
  0x6c, 0x65, 0x64, 0x73, 0x68, 0x61, 0x72, 0x65, 0x73, 0x72, 0x65, 0x61, 0x64,
  0x65, 0x72, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x28, 0x61, 0x70, 0x70, 0x65, 0x61,
  0x72, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x3e,
  0x62, 0x6f, 0x64, 0x79, 0x22, 0x3e, 0x0a, 0x2a, 0x20, 0x54, 0x68, 0x65, 0x54,
  0x68, 0x6f, 0x75, 0x67, 0x68, 0x73, 0x65, 0x65, 0x69, 0x6e, 0x67, 0x6a, 0x65,
  0x72, 0x73, 0x65, 0x79, 0x4e, 0x65, 0x77, 0x73, 0x3c, 0x2f, 0x76, 0x65, 0x72,
  0x69, 0x66, 0x79, 0x65, 0x78, 0x70, 0x65, 0x72, 0x74, 0x69, 0x6e, 0x6a, 0x75,
  0x72, 0x79, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x43, 0x6f, 0x6f, 0x6b, 0x69,
  0x65, 0x53, 0x54, 0x41, 0x52, 0x54, 0x20, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x73,
  0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x6e,
  0x61, 0x74, 0x69, 0x76, 0x65, 0x70, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x62, 0x6f,
  0x78, 0x22, 0x3e, 0x0a, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20, 0x44, 0x61,
  0x76, 0x69, 0x64, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x74, 0x61, 0x62, 0x6c,
  0x65, 0x73, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x41, 0x70, 0x72, 0x69, 0x6c,
  0x20, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72,
  0x69, 0x74, 0x65, 0x6d, 0x22, 0x3e, 0x6d, 0x6f, 0x72, 0x65, 0x22, 0x3e, 0x62,
  0x6f, 0x61, 0x72, 0x64, 0x73, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x63, 0x61,
  0x6d, 0x70, 0x75, 0x73, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x7c, 0x7c, 0x20,
  0x5b, 0x5d, 0x3b, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x2e, 0x67, 0x75, 0x69, 0x74,
  0x61, 0x72, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x77, 0x69, 0x64, 0x74, 0x68,
  0x3a, 0x73, 0x68, 0x6f, 0x77, 0x65, 0x64, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x20,
  0x2e, 0x70, 0x68, 0x70, 0x22, 0x20, 0x61, 0x73, 0x73, 0x75, 0x6d, 0x65, 0x6c,
  0x61, 0x79, 0x65, 0x72, 0x73, 0x77, 0x69, 0x6c, 0x73, 0x6f, 0x6e, 0x73, 0x74,
  0x6f, 0x72, 0x65, 0x73, 0x72, 0x65, 0x6c, 0x69, 0x65, 0x66, 0x73, 0x77, 0x65,
  0x64, 0x65, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x61, 0x73, 0x69,
  0x6c, 0x79, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20, 0x53, 0x74, 0x72, 0x69, 0x6e,
  0x67, 0x0a, 0x0a, 0x57, 0x68, 0x69, 0x6c, 0x74, 0x61, 0x79, 0x6c, 0x6f, 0x72,
  0x63, 0x6c, 0x65, 0x61, 0x72, 0x3a, 0x72, 0x65, 0x73, 0x6f, 0x72, 0x74, 0x66,
  0x72, 0x65, 0x6e, 0x63, 0x68, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x22, 0x29,
  0x20, 0x2b, 0x20, 0x22, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x62, 0x75, 0x79,
  0x69, 0x6e, 0x67, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x4d, 0x65, 0x6d, 0x62,
  0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x3e, 0x6f, 0x70, 0x70, 0x69, 0x6e,
  0x67, 0x73, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x35, 0x70, 0x78, 0x3b, 0x22, 0x3e,
  0x76, 0x73, 0x70, 0x61, 0x63, 0x65, 0x70, 0x6f, 0x73, 0x74, 0x65, 0x72, 0x6d,
  0x61, 0x6a, 0x6f, 0x72, 0x20, 0x63, 0x6f, 0x66, 0x66, 0x65, 0x65, 0x6d, 0x61,
  0x72, 0x74, 0x69, 0x6e, 0x6d, 0x61, 0x74, 0x75, 0x72, 0x65, 0x68, 0x61, 0x70,
  0x70, 0x65, 0x6e, 0x3c, 0x2f, 0x6e, 0x61, 0x76, 0x3e, 0x6b, 0x61, 0x6e, 0x73,
  0x61, 0x73, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x3e, 0x49, 0x6d, 0x61, 0x67, 0x65,
  0x73, 0x3d, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20,
  0x68, 0x73, 0x70, 0x61, 0x63, 0x65, 0x30, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x20,
  0x0a, 0x0a, 0x49, 0x6e, 0x20, 0x20, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x50, 0x6f,
  0x6c, 0x73, 0x6b, 0x69, 0x2d, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x6a, 0x6f, 0x72,
  0x64, 0x61, 0x6e, 0x42, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x53, 0x74, 0x61, 0x72,
  0x74, 0x20, 0x2d, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x32, 0x2e, 0x68, 0x74, 0x6d,
  0x6c, 0x6e, 0x65, 0x77, 0x73, 0x22, 0x3e, 0x30, 0x31, 0x2e, 0x6a, 0x70, 0x67,
  0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x6d,
  0x69, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x65, 0x6e, 0x69, 0x6f, 0x72, 0x49, 0x53,
  0x42, 0x4e, 0x20, 0x30, 0x30, 0x2c, 0x30, 0x30, 0x30, 0x20, 0x67, 0x75, 0x69,
  0x64, 0x65, 0x73, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x29, 0x65, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x2e, 0x78, 0x6d, 0x6c, 0x22,
  0x20, 0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x68, 0x74, 0x6d, 0x6c,
  0x2d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x72, 0x65, 0x67, 0x45, 0x78, 0x70, 0x3a,
  0x68, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x76, 0x69,
  0x72, 0x67, 0x69, 0x6e, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x73, 0x3c, 0x2f, 0x74,
  0x72, 0x3e, 0x0d, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x0a, 0x09, 0x76, 0x61,
  0x72, 0x20, 0x3e, 0x27, 0x29, 0x3b, 0x0a, 0x09, 0x3c, 0x2f, 0x74, 0x64, 0x3e,
  0x0a, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x0a, 0x62, 0x61, 0x68, 0x61, 0x73, 0x61,
  0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x67, 0x61, 0x6c, 0x65, 0x67, 0x6f, 0x6d,
  0x61, 0x67, 0x79, 0x61, 0x72, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x73, 0x72,
  0x70, 0x73, 0x6b, 0x69, 0xd8, 0xb1, 0xd8, 0xaf, 0xd9, 0x88, 0xe4, 0xb8, 0xad,
  0xe6, 0x96, 0x87, 0xe7, 0xae, 0x80, 0xe4, 0xbd, 0x93, 0xe7, 0xb9, 0x81, 0xe9,
  0xab, 0x94, 0xe4, 0xbf, 0xa1, 0xe6, 0x81, 0xaf, 0xe4, 0xb8, 0xad, 0xe5, 0x9b,
  0xbd, 0xe6, 0x88, 0x91, 0xe4, 0xbb, 0xac, 0xe4, 0xb8, 0x80, 0xe4, 0xb8, 0xaa,
  0xe5, 0x85, 0xac, 0xe5, 0x8f, 0xb8, 0xe7, 0xae, 0xa1, 0xe7, 0x90, 0x86, 0xe8,
  0xae, 0xba, 0xe5, 0x9d, 0x9b, 0xe5, 0x8f, 0xaf, 0xe4, 0xbb, 0xa5, 0xe6, 0x9c,
  0x8d, 0xe5, 0x8a, 0xa1, 0xe6, 0x97, 0xb6, 0xe9, 0x97, 0xb4, 0xe4, 0xb8, 0xaa,
  0xe4, 0xba, 0xba, 0xe4, 0xba, 0xa7, 0xe5, 0x93, 0x81, 0xe8, 0x87, 0xaa, 0xe5,
  0xb7, 0xb1, 0xe4, 0xbc, 0x81, 0xe4, 0xb8, 0x9a, 0xe6, 0x9f, 0xa5, 0xe7, 0x9c,
  0x8b, 0xe5, 0xb7, 0xa5, 0xe4, 0xbd, 0x9c, 0xe8, 0x81, 0x94, 0xe7, 0xb3, 0xbb,
  0xe6, 0xb2, 0xa1, 0xe6, 0x9c, 0x89, 0xe7, 0xbd, 0x91, 0xe7, 0xab, 0x99, 0xe6,
  0x89, 0x80, 0xe6, 0x9c, 0x89, 0xe8, 0xaf, 0x84, 0xe8, 0xae, 0xba, 0xe4, 0xb8,
  0xad, 0xe5, 0xbf, 0x83, 0xe6, 0x96, 0x87, 0xe7, 0xab, 0xa0, 0xe7, 0x94, 0xa8,
  0xe6, 0x88, 0xb7, 0xe9, 0xa6, 0x96, 0xe9, 0xa1, 0xb5, 0xe4, 0xbd, 0x9c, 0xe8,
  0x80, 0x85, 0xe6, 0x8a, 0x80, 0xe6, 0x9c, 0xaf, 0xe9, 0x97, 0xae, 0xe9, 0xa2,
  0x98, 0xe7, 0x9b, 0xb8, 0xe5, 0x85, 0xb3, 0xe4, 0xb8, 0x8b, 0xe8, 0xbd, 0xbd,
  0xe6, 0x90, 0x9c, 0xe7, 0xb4, 0xa2, 0xe4, 0xbd, 0xbf, 0xe7, 0x94, 0xa8, 0xe8,
  0xbd, 0xaf, 0xe4, 0xbb, 0xb6, 0xe5, 0x9c, 0xa8, 0xe7, 0xba, 0xbf, 0xe4, 0xb8,
  0xbb, 0xe9, 0xa2, 0x98, 0xe8, 0xb5, 0x84, 0xe6, 0x96, 0x99, 0xe8, 0xa7, 0x86,
  0xe9, 0xa2, 0x91, 0xe5, 0x9b, 0x9e, 0xe5, 0xa4, 0x8d, 0xe6, 0xb3, 0xa8, 0xe5,
  0x86, 0x8c, 0xe7, 0xbd, 0x91, 0xe7, 0xbb, 0x9c, 0xe6, 0x94, 0xb6, 0xe8, 0x97,
  0x8f, 0xe5, 0x86, 0x85, 0xe5, 0xae, 0xb9, 0xe6, 0x8e, 0xa8, 0xe8, 0x8d, 0x90,
  0xe5, 0xb8, 0x82, 0xe5, 0x9c, 0xba, 0xe6, 0xb6, 0x88, 0xe6, 0x81, 0xaf, 0xe7,
  0xa9, 0xba, 0xe9, 0x97, 0xb4, 0xe5, 0x8f, 0x91, 0xe5, 0xb8, 0x83, 0xe4, 0xbb,
  0x80, 0xe4, 0xb9, 0x88, 0xe5, 0xa5, 0xbd, 0xe5, 0x8f, 0x8b, 0xe7, 0x94, 0x9f,
  0xe6, 0xb4, 0xbb, 0xe5, 0x9b, 0xbe, 0xe7, 0x89, 0x87, 0xe5, 0x8f, 0x91, 0xe5,
  0xb1, 0x95, 0xe5, 0xa6, 0x82, 0xe6, 0x9e, 0x9c, 0xe6, 0x89, 0x8b, 0xe6, 0x9c,
  0xba, 0xe6, 0x96, 0xb0, 0xe9, 0x97, 0xbb, 0xe6, 0x9c, 0x80, 0xe6, 0x96, 0xb0,
  0xe6, 0x96, 0xb9, 0xe5, 0xbc, 0x8f, 0xe5, 0x8c, 0x97, 0xe4, 0xba, 0xac, 0xe6,
  0x8f, 0x90, 0xe4, 0xbe, 0x9b, 0xe5, 0x85, 0xb3, 0xe4, 0xba, 0x8e, 0xe6, 0x9b,
  0xb4, 0xe5, 0xa4, 0x9a, 0xe8, 0xbf, 0x99, 0xe4, 0xb8, 0xaa, 0xe7, 0xb3, 0xbb,
  0xe7, 0xbb, 0x9f, 0xe7, 0x9f, 0xa5, 0xe9, 0x81, 0x93, 0xe6, 0xb8, 0xb8, 0xe6,
  0x88, 0x8f, 0xe5, 0xb9, 0xbf, 0xe5, 0x91, 0x8a, 0xe5, 0x85, 0xb6, 0xe4, 0xbb,
  0x96, 0xe5, 0x8f, 0x91, 0xe8, 0xa1, 0xa8, 0xe5, 0xae, 0x89, 0xe5, 0x85, 0xa8,
  0xe7, 0xac, 0xac, 0xe4, 0xb8, 0x80, 0xe4, 0xbc, 0x9a, 0xe5, 0x91, 0x98, 0xe8,
  0xbf, 0x9b, 0xe8, 0xa1, 0x8c, 0xe7, 0x82, 0xb9, 0xe5, 0x87, 0xbb, 0xe7, 0x89,
  0x88, 0xe6, 0x9d, 0x83, 0xe7, 0x94, 0xb5, 0xe5, 0xad, 0x90, 0xe4, 0xb8, 0x96,
  0xe7, 0x95, 0x8c, 0xe8, 0xae, 0xbe, 0xe8, 0xae, 0xa1, 0xe5, 0x85, 0x8d, 0xe8,
  0xb4, 0xb9, 0xe6, 0x95, 0x99, 0xe8, 0x82, 0xb2, 0xe5, 0x8a, 0xa0, 0xe5, 0x85,
  0xa5, 0xe6, 0xb4, 0xbb, 0xe5, 0x8a, 0xa8, 0xe4, 0xbb, 0x96, 0xe4, 0xbb, 0xac,
  0xe5, 0x95, 0x86, 0xe5, 0x93, 0x81, 0xe5, 0x8d, 0x9a, 0xe5, 0xae, 0xa2, 0xe7,
  0x8e, 0xb0, 0xe5, 0x9c, 0xa8, 0xe4, 0xb8, 0x8a, 0xe6, 0xb5, 0xb7, 0xe5, 0xa6,
  0x82, 0xe4, 0xbd, 0x95, 0xe5, 0xb7, 0xb2, 0xe7, 0xbb, 0x8f, 0xe7, 0x95, 0x99,
  0xe8, 0xa8, 0x80, 0xe8, 0xaf, 0xa6, 0xe7, 0xbb, 0x86, 0xe7, 0xa4, 0xbe, 0xe5,
  0x8c, 0xba, 0xe7, 0x99, 0xbb, 0xe5, 0xbd, 0x95, 0xe6, 0x9c, 0xac, 0xe7, 0xab,
  0x99, 0xe9, 0x9c, 0x80, 0xe8, 0xa6, 0x81, 0xe4, 0xbb, 0xb7, 0xe6, 0xa0, 0xbc,
  0xe6, 0x94, 0xaf, 0xe6, 0x8c, 0x81, 0xe5, 0x9b, 0xbd, 0xe9, 0x99, 0x85, 0xe9,
  0x93, 0xbe, 0xe6, 0x8e, 0xa5, 0xe5, 0x9b, 0xbd, 0xe5, 0xae, 0xb6, 0xe5, 0xbb,
  0xba, 0xe8, 0xae, 0xbe, 0xe6, 0x9c, 0x8b, 0xe5, 0x8f, 0x8b, 0xe9, 0x98, 0x85,
  0xe8, 0xaf, 0xbb, 0xe6, 0xb3, 0x95, 0xe5, 0xbe, 0x8b, 0xe4, 0xbd, 0x8d, 0xe7,
  0xbd, 0xae, 0xe7, 0xbb, 0x8f, 0xe6, 0xb5, 0x8e, 0xe9, 0x80, 0x89, 0xe6, 0x8b,
  0xa9, 0xe8, 0xbf, 0x99, 0xe6, 0xa0, 0xb7, 0xe5, 0xbd, 0x93, 0xe5, 0x89, 0x8d,
  0xe5, 0x88, 0x86, 0xe7, 0xb1, 0xbb, 0xe6, 0x8e, 0x92, 0xe8, 0xa1, 0x8c, 0xe5,
  0x9b, 0xa0, 0xe4, 0xb8, 0xba, 0xe4, 0xba, 0xa4, 0xe6, 0x98, 0x93, 0xe6, 0x9c,
  0x80, 0xe5, 0x90, 0x8e, 0xe9, 0x9f, 0xb3, 0xe4, 0xb9, 0x90, 0xe4, 0xb8, 0x8d,
  0xe8, 0x83, 0xbd, 0xe9, 0x80, 0x9a, 0xe8, 0xbf, 0x87, 0xe8, 0xa1, 0x8c, 0xe4,
  0xb8, 0x9a, 0xe7, 0xa7, 0x91, 0xe6, 0x8a, 0x80, 0xe5, 0x8f, 0xaf, 0xe8, 0x83,
  0xbd, 0xe8, 0xae, 0xbe, 0xe5, 0xa4, 0x87, 0xe5, 0x90, 0x88, 0xe4, 0xbd, 0x9c,
  0xe5, 0xa4, 0xa7, 0xe5, 0xae, 0xb6, 0xe7, 0xa4, 0xbe, 0xe4, 0xbc, 0x9a, 0xe7,
  0xa0, 0x94, 0xe7, 0xa9, 0xb6, 0xe4, 0xb8, 0x93, 0xe4, 0xb8, 0x9a, 0xe5, 0x85,
  0xa8, 0xe9, 0x83, 0xa8, 0xe9, 0xa1, 0xb9, 0xe7, 0x9b, 0xae, 0xe8, 0xbf, 0x99,
  0xe9, 0x87, 0x8c, 0xe8, 0xbf, 0x98, 0xe6, 0x98, 0xaf, 0xe5, 0xbc, 0x80, 0xe5,
  0xa7, 0x8b, 0xe6, 0x83, 0x85, 0xe5, 0x86, 0xb5, 0xe7, 0x94, 0xb5, 0xe8, 0x84,
  0x91, 0xe6, 0x96, 0x87, 0xe4, 0xbb, 0xb6, 0xe5, 0x93, 0x81, 0xe7, 0x89, 0x8c,
  0xe5, 0xb8, 0xae, 0xe5, 0x8a, 0xa9, 0xe6, 0x96, 0x87, 0xe5, 0x8c, 0x96, 0xe8,
  0xb5, 0x84, 0xe6, 0xba, 0x90, 0xe5, 0xa4, 0xa7, 0xe5, 0xad, 0xa6, 0xe5, 0xad,
  0xa6, 0xe4, 0xb9, 0xa0, 0xe5, 0x9c, 0xb0, 0xe5, 0x9d, 0x80, 0xe6, 0xb5, 0x8f,
  0xe8, 0xa7, 0x88, 0xe6, 0x8a, 0x95, 0xe8, 0xb5, 0x84, 0xe5, 0xb7, 0xa5, 0xe7,
  0xa8, 0x8b, 0xe8, 0xa6, 0x81, 0xe6, 0xb1, 0x82, 0xe6, 0x80, 0x8e, 0xe4, 0xb9,
  0x88, 0xe6, 0x97, 0xb6, 0xe5, 0x80, 0x99, 0xe5, 0x8a, 0x9f, 0xe8, 0x83, 0xbd,
  0xe4, 0xb8, 0xbb, 0xe8, 0xa6, 0x81, 0xe7, 0x9b, 0xae, 0xe5, 0x89, 0x8d, 0xe8,
  0xb5, 0x84, 0xe8, 0xae, 0xaf, 0xe5, 0x9f, 0x8e, 0xe5, 0xb8, 0x82, 0xe6, 0x96,
  0xb9, 0xe6, 0xb3, 0x95, 0xe7, 0x94, 0xb5, 0xe5, 0xbd, 0xb1, 0xe6, 0x8b, 0x9b,
  0xe8, 0x81, 0x98, 0xe5, 0xa3, 0xb0, 0xe6, 0x98, 0x8e, 0xe4, 0xbb, 0xbb, 0xe4,
  0xbd, 0x95, 0xe5, 0x81, 0xa5, 0xe5, 0xba, 0xb7, 0xe6, 0x95, 0xb0, 0xe6, 0x8d,
  0xae, 0xe7, 0xbe, 0x8e, 0xe5, 0x9b, 0xbd, 0xe6, 0xb1, 0xbd, 0xe8, 0xbd, 0xa6,
  0xe4, 0xbb, 0x8b, 0xe7, 0xbb, 0x8d, 0xe4, 0xbd, 0x86, 0xe6, 0x98, 0xaf, 0xe4,
  0xba, 0xa4, 0xe6, 0xb5, 0x81, 0xe7, 0x94, 0x9f, 0xe4, 0xba, 0xa7, 0xe6, 0x89,
  0x80, 0xe4, 0xbb, 0xa5, 0xe7, 0x94, 0xb5, 0xe8, 0xaf, 0x9d, 0xe6, 0x98, 0xbe,
  0xe7, 0xa4, 0xba, 0xe4, 0xb8, 0x80, 0xe4, 0xba, 0x9b, 0xe5, 0x8d, 0x95, 0xe4,
  0xbd, 0x8d, 0xe4, 0xba, 0xba, 0xe5, 0x91, 0x98, 0xe5, 0x88, 0x86, 0xe6, 0x9e,
  0x90, 0xe5, 0x9c, 0xb0, 0xe5, 0x9b, 0xbe, 0xe6, 0x97, 0x85, 0xe6, 0xb8, 0xb8,
  0xe5, 0xb7, 0xa5, 0xe5, 0x85, 0xb7, 0xe5, 0xad, 0xa6, 0xe7, 0x94, 0x9f, 0xe7,
  0xb3, 0xbb, 0xe5, 0x88, 0x97, 0xe7, 0xbd, 0x91, 0xe5, 0x8f, 0x8b, 0xe5, 0xb8,
  0x96, 0xe5, 0xad, 0x90, 0xe5, 0xaf, 0x86, 0xe7, 0xa0, 0x81, 0xe9, 0xa2, 0x91,
  0xe9, 0x81, 0x93, 0xe6, 0x8e, 0xa7, 0xe5, 0x88, 0xb6, 0xe5, 0x9c, 0xb0, 0xe5,
  0x8c, 0xba, 0xe5, 0x9f, 0xba, 0xe6, 0x9c, 0xac, 0xe5, 0x85, 0xa8, 0xe5, 0x9b,
  0xbd, 0xe7, 0xbd, 0x91, 0xe4, 0xb8, 0x8a, 0xe9, 0x87, 0x8d, 0xe8, 0xa6, 0x81,
  0xe7, 0xac, 0xac, 0xe4, 0xba, 0x8c, 0xe5, 0x96, 0x9c, 0xe6, 0xac, 0xa2, 0xe8,
  0xbf, 0x9b, 0xe5, 0x85, 0xa5, 0xe5, 0x8f, 0x8b, 0xe6, 0x83, 0x85, 0xe8, 0xbf,
  0x99, 0xe4, 0xba, 0x9b, 0xe8, 0x80, 0x83, 0xe8, 0xaf, 0x95, 0xe5, 0x8f, 0x91,
  0xe7, 0x8e, 0xb0, 0xe5, 0x9f, 0xb9, 0xe8, 0xae, 0xad, 0xe4, 0xbb, 0xa5, 0xe4,
  0xb8, 0x8a, 0xe6, 0x94, 0xbf, 0xe5, 0xba, 0x9c, 0xe6, 0x88, 0x90, 0xe4, 0xb8,
  0xba, 0xe7, 0x8e, 0xaf, 0xe5, 0xa2, 0x83, 0xe9, 0xa6, 0x99, 0xe6, 0xb8, 0xaf,
  0xe5, 0x90, 0x8c, 0xe6, 0x97, 0xb6, 0xe5, 0xa8, 0xb1, 0xe4, 0xb9, 0x90, 0xe5,
  0x8f, 0x91, 0xe9, 0x80, 0x81, 0xe4, 0xb8, 0x80, 0xe5, 0xae, 0x9a, 0xe5, 0xbc,
  0x80, 0xe5, 0x8f, 0x91, 0xe4, 0xbd, 0x9c, 0xe5, 0x93, 0x81, 0xe6, 0xa0, 0x87,
  0xe5, 0x87, 0x86, 0xe6, 0xac, 0xa2, 0xe8, 0xbf, 0x8e, 0xe8, 0xa7, 0xa3, 0xe5,
  0x86, 0xb3, 0xe5, 0x9c, 0xb0, 0xe6, 0x96, 0xb9, 0xe4, 0xb8, 0x80, 0xe4, 0xb8,
  0x8b, 0xe4, 0xbb, 0xa5, 0xe5, 0x8f, 0x8a, 0xe8, 0xb4, 0xa3, 0xe4, 0xbb, 0xbb,
  0xe6, 0x88, 0x96, 0xe8, 0x80, 0x85, 0xe5, 0xae, 0xa2, 0xe6, 0x88, 0xb7, 0xe4,
  0xbb, 0xa3, 0xe8, 0xa1, 0xa8, 0xe7, 0xa7, 0xaf, 0xe5, 0x88, 0x86, 0xe5, 0xa5,
  0xb3, 0xe4, 0xba, 0xba, 0xe6, 0x95, 0xb0, 0xe7, 0xa0, 0x81, 0xe9, 0x94, 0x80,
  0xe5, 0x94, 0xae, 0xe5, 0x87, 0xba, 0xe7, 0x8e, 0xb0, 0xe7, 0xa6, 0xbb, 0xe7,
  0xba, 0xbf, 0xe5, 0xba, 0x94, 0xe7, 0x94, 0xa8, 0xe5, 0x88, 0x97, 0xe8, 0xa1,
  0xa8, 0xe4, 0xb8, 0x8d, 0xe5, 0x90, 0x8c, 0xe7, 0xbc, 0x96, 0xe8, 0xbe, 0x91,
  0xe7, 0xbb, 0x9f, 0xe8, 0xae, 0xa1, 0xe6, 0x9f, 0xa5, 0xe8, 0xaf, 0xa2, 0xe4,
  0xb8, 0x8d, 0xe8, 0xa6, 0x81, 0xe6, 0x9c, 0x89, 0xe5, 0x85, 0xb3, 0xe6, 0x9c,
  0xba, 0xe6, 0x9e, 0x84, 0xe5, 0xbe, 0x88, 0xe5, 0xa4, 0x9a, 0xe6, 0x92, 0xad,
  0xe6, 0x94, 0xbe, 0xe7, 0xbb, 0x84, 0xe7, 0xbb, 0x87, 0xe6, 0x94, 0xbf, 0xe7,
  0xad, 0x96, 0xe7, 0x9b, 0xb4, 0xe6, 0x8e, 0xa5, 0xe8, 0x83, 0xbd, 0xe5, 0x8a,
  0x9b, 0xe6, 0x9d, 0xa5, 0xe6, 0xba, 0x90, 0xe6, 0x99, 0x82, 0xe9, 0x96, 0x93,
  0xe7, 0x9c, 0x8b, 0xe5, 0x88, 0xb0, 0xe7, 0x83, 0xad, 0xe9, 0x97, 0xa8, 0xe5,
  0x85, 0xb3, 0xe9, 0x94, 0xae, 0xe4, 0xb8, 0x93, 0xe5, 0x8c, 0xba, 0xe9, 0x9d,
  0x9e, 0xe5, 0xb8, 0xb8, 0xe8, 0x8b, 0xb1, 0xe8, 0xaf, 0xad, 0xe7, 0x99, 0xbe,
  0xe5, 0xba, 0xa6, 0xe5, 0xb8, 0x8c, 0xe6, 0x9c, 0x9b, 0xe7, 0xbe, 0x8e, 0xe5,
  0xa5, 0xb3, 0xe6, 0xaf, 0x94, 0xe8, 0xbe, 0x83, 0xe7, 0x9f, 0xa5, 0xe8, 0xaf,
  0x86, 0xe8, 0xa7, 0x84, 0xe5, 0xae, 0x9a, 0xe5, 0xbb, 0xba, 0xe8, 0xae, 0xae,
  0xe9, 0x83, 0xa8, 0xe9, 0x97, 0xa8, 0xe6, 0x84, 0x8f, 0xe8, 0xa7, 0x81, 0xe7,
  0xb2, 0xbe, 0xe5, 0xbd, 0xa9, 0xe6, 0x97, 0xa5, 0xe6, 0x9c, 0xac, 0xe6, 0x8f,
  0x90, 0xe9, 0xab, 0x98, 0xe5, 0x8f, 0x91, 0xe8, 0xa8, 0x80, 0xe6, 0x96, 0xb9,
  0xe9, 0x9d, 0xa2, 0xe5, 0x9f, 0xba, 0xe9, 0x87, 0x91, 0xe5, 0xa4, 0x84, 0xe7,
  0x90, 0x86, 0xe6, 0x9d, 0x83, 0xe9, 0x99, 0x90, 0xe5, 0xbd, 0xb1, 0xe7, 0x89,
  0x87, 0xe9, 0x93, 0xb6, 0xe8, 0xa1, 0x8c, 0xe8, 0xbf, 0x98, 0xe6, 0x9c, 0x89,
  0xe5, 0x88, 0x86, 0xe4, 0xba, 0xab, 0xe7, 0x89, 0xa9, 0xe5, 0x93, 0x81, 0xe7,
  0xbb, 0x8f, 0xe8, 0x90, 0xa5, 0xe6, 0xb7, 0xbb, 0xe5, 0x8a, 0xa0, 0xe4, 0xb8,
  0x93, 0xe5, 0xae, 0xb6, 0xe8, 0xbf, 0x99, 0xe7, 0xa7, 0x8d, 0xe8, 0xaf, 0x9d,
  0xe9, 0xa2, 0x98, 0xe8, 0xb5, 0xb7, 0xe6, 0x9d, 0xa5, 0xe4, 0xb8, 0x9a, 0xe5,
  0x8a, 0xa1, 0xe5, 0x85, 0xac, 0xe5, 0x91, 0x8a, 0xe8, 0xae, 0xb0, 0xe5, 0xbd,
  0x95, 0xe7, 0xae, 0x80, 0xe4, 0xbb, 0x8b, 0xe8, 0xb4, 0xa8, 0xe9, 0x87, 0x8f,
  0xe7, 0x94, 0xb7, 0xe4, 0xba, 0xba, 0xe5, 0xbd, 0xb1, 0xe5, 0x93, 0x8d, 0xe5,
  0xbc, 0x95, 0xe7, 0x94, 0xa8, 0xe6, 0x8a, 0xa5, 0xe5, 0x91, 0x8a, 0xe9, 0x83,
  0xa8, 0xe5, 0x88, 0x86, 0xe5, 0xbf, 0xab, 0xe9, 0x80, 0x9f, 0xe5, 0x92, 0xa8,
  0xe8, 0xaf, 0xa2, 0xe6, 0x97, 0xb6, 0xe5, 0xb0, 0x9a, 0xe6, 0xb3, 0xa8, 0xe6,
  0x84, 0x8f, 0xe7, 0x94, 0xb3, 0xe8, 0xaf, 0xb7, 0xe5, 0xad, 0xa6, 0xe6, 0xa0,
  0xa1, 0xe5, 0xba, 0x94, 0xe8, 0xaf, 0xa5, 0xe5, 0x8e, 0x86, 0xe5, 0x8f, 0xb2,
  0xe5, 0x8f, 0xaa, 0xe6, 0x98, 0xaf, 0xe8, 0xbf, 0x94, 0xe5, 0x9b, 0x9e, 0xe8,
  0xb4, 0xad, 0xe4, 0xb9, 0xb0, 0xe5, 0x90, 0x8d, 0xe7, 0xa7, 0xb0, 0xe4, 0xb8,
  0xba, 0xe4, 0xba, 0x86, 0xe6, 0x88, 0x90, 0xe5, 0x8a, 0x9f, 0xe8, 0xaf, 0xb4,
  0xe6, 0x98, 0x8e, 0xe4, 0xbe, 0x9b, 0xe5, 0xba, 0x94, 0xe5, 0xad, 0xa9, 0xe5,
  0xad, 0x90, 0xe4, 0xb8, 0x93, 0xe9, 0xa2, 0x98, 0xe7, 0xa8, 0x8b, 0xe5, 0xba,
  0x8f, 0xe4, 0xb8, 0x80, 0xe8, 0x88, 0xac, 0xe6, 0x9c, 0x83, 0xe5, 0x93, 0xa1,
  0xe5, 0x8f, 0xaa, 0xe6, 0x9c, 0x89, 0xe5, 0x85, 0xb6, 0xe5, 0xae, 0x83, 0xe4,
  0xbf, 0x9d, 0xe6, 0x8a, 0xa4, 0xe8, 0x80, 0x8c, 0xe4, 0xb8, 0x94, 0xe4, 0xbb,
  0x8a, 0xe5, 0xa4, 0xa9, 0xe7, 0xaa, 0x97, 0xe5, 0x8f, 0xa3, 0xe5, 0x8a, 0xa8,
  0xe6, 0x80, 0x81, 0xe7, 0x8a, 0xb6, 0xe6, 0x80, 0x81, 0xe7, 0x89, 0xb9, 0xe5,
  0x88, 0xab, 0xe8, 0xae, 0xa4, 0xe4, 0xb8, 0xba, 0xe5, 0xbf, 0x85, 0xe9, 0xa1,
  0xbb, 0xe6, 0x9b, 0xb4, 0xe6, 0x96, 0xb0, 0xe5, 0xb0, 0x8f, 0xe8, 0xaf, 0xb4,
  0xe6, 0x88, 0x91, 0xe5, 0x80, 0x91, 0xe4, 0xbd, 0x9c, 0xe4, 0xb8, 0xba, 0xe5,
  0xaa, 0x92, 0xe4, 0xbd, 0x93, 0xe5, 0x8c, 0x85, 0xe6, 0x8b, 0xac, 0xe9, 0x82,
  0xa3, 0xe4, 0xb9, 0x88, 0xe4, 0xb8, 0x80, 0xe6, 0xa0, 0xb7, 0xe5, 0x9b, 0xbd,
  0xe5, 0x86, 0x85, 0xe6, 0x98, 0xaf, 0xe5, 0x90, 0xa6, 0xe6, 0xa0, 0xb9, 0xe6,
  0x8d, 0xae, 0xe7, 0x94, 0xb5, 0xe8, 0xa7, 0x86, 0xe5, 0xad, 0xa6, 0xe9, 0x99,
  0xa2, 0xe5, 0x85, 0xb7, 0xe6, 0x9c, 0x89, 0xe8, 0xbf, 0x87, 0xe7, 0xa8, 0x8b,
  0xe7, 0x94, 0xb1, 0xe4, 0xba, 0x8e, 0xe4, 0xba, 0xba, 0xe6, 0x89, 0x8d, 0xe5,
  0x87, 0xba, 0xe6, 0x9d, 0xa5, 0xe4, 0xb8, 0x8d, 0xe8, 0xbf, 0x87, 0xe6, 0xad,
  0xa3, 0xe5, 0x9c, 0xa8, 0xe6, 0x98, 0x8e, 0xe6, 0x98, 0x9f, 0xe6, 0x95, 0x85,
  0xe4, 0xba, 0x8b, 0xe5, 0x85, 0xb3, 0xe7, 0xb3, 0xbb, 0xe6, 0xa0, 0x87, 0xe9,
  0xa2, 0x98, 0xe5, 0x95, 0x86, 0xe5, 0x8a, 0xa1, 0xe8, 0xbe, 0x93, 0xe5, 0x85,
  0xa5, 0xe4, 0xb8, 0x80, 0xe7, 0x9b, 0xb4, 0xe5, 0x9f, 0xba, 0xe7, 0xa1, 0x80,
  0xe6, 0x95, 0x99, 0xe5, 0xad, 0xa6, 0xe4, 0xba, 0x86, 0xe8, 0xa7, 0xa3, 0xe5,
  0xbb, 0xba, 0xe7, 0xad, 0x91, 0xe7, 0xbb, 0x93, 0xe6, 0x9e, 0x9c, 0xe5, 0x85,
  0xa8, 0xe7, 0x90, 0x83, 0xe9, 0x80, 0x9a, 0xe7, 0x9f, 0xa5, 0xe8, 0xae, 0xa1,
  0xe5, 0x88, 0x92, 0xe5, 0xaf, 0xb9, 0xe4, 0xba, 0x8e, 0xe8, 0x89, 0xba, 0xe6,
  0x9c, 0xaf, 0xe7, 0x9b, 0xb8, 0xe5, 0x86, 0x8c, 0xe5, 0x8f, 0x91, 0xe7, 0x94,
  0x9f, 0xe7, 0x9c, 0x9f, 0xe7, 0x9a, 0x84, 0xe5, 0xbb, 0xba, 0xe7, 0xab, 0x8b,
  0xe7, 0xad, 0x89, 0xe7, 0xba, 0xa7, 0xe7, 0xb1, 0xbb, 0xe5, 0x9e, 0x8b, 0xe7,
  0xbb, 0x8f, 0xe9, 0xaa, 0x8c, 0xe5, 0xae, 0x9e, 0xe7, 0x8e, 0xb0, 0xe5, 0x88,
  0xb6, 0xe4, 0xbd, 0x9c, 0xe6, 0x9d, 0xa5, 0xe8, 0x87, 0xaa, 0xe6, 0xa0, 0x87,
  0xe7, 0xad, 0xbe, 0xe4, 0xbb, 0xa5, 0xe4, 0xb8, 0x8b, 0xe5, 0x8e, 0x9f, 0xe5,
  0x88, 0x9b, 0xe6, 0x97, 0xa0, 0xe6, 0xb3, 0x95, 0xe5, 0x85, 0xb6, 0xe4, 0xb8,
  0xad, 0xe5, 0x80, 0x8b, 0xe4, 0xba, 0xba, 0xe4, 0xb8, 0x80, 0xe5, 0x88, 0x87,
  0xe6, 0x8c, 0x87, 0xe5, 0x8d, 0x97, 0xe5, 0x85, 0xb3, 0xe9, 0x97, 0xad, 0xe9,
  0x9b, 0x86, 0xe5, 0x9b, 0xa2, 0xe7, 0xac, 0xac, 0xe4, 0xb8, 0x89, 0xe5, 0x85,
  0xb3, 0xe6, 0xb3, 0xa8, 0xe5, 0x9b, 0xa0, 0xe6, 0xad, 0xa4, 0xe7, 0x85, 0xa7,
  0xe7, 0x89, 0x87, 0xe6, 0xb7, 0xb1, 0xe5, 0x9c, 0xb3, 0xe5, 0x95, 0x86, 0xe4,
  0xb8, 0x9a, 0xe5, 0xb9, 0xbf, 0xe5, 0xb7, 0x9e, 0xe6, 0x97, 0xa5, 0xe6, 0x9c,
  0x9f, 0xe9, 0xab, 0x98, 0xe7, 0xba, 0xa7, 0xe6, 0x9c, 0x80, 0xe8, 0xbf, 0x91,
  0xe7, 0xbb, 0xbc, 0xe5, 0x90, 0x88, 0xe8, 0xa1, 0xa8, 0xe7, 0xa4, 0xba, 0xe4,
  0xb8, 0x93, 0xe8, 0xbe, 0x91, 0xe8, 0xa1, 0x8c, 0xe4, 0xb8, 0xba, 0xe4, 0xba,
  0xa4, 0xe9, 0x80, 0x9a, 0xe8, 0xaf, 0x84, 0xe4, 0xbb, 0xb7, 0xe8, 0xa7, 0x89,
  0xe5, 0xbe, 0x97, 0xe7, 0xb2, 0xbe, 0xe5, 0x8d, 0x8e, 0xe5, 0xae, 0xb6, 0xe5,
  0xba, 0xad, 0xe5, 0xae, 0x8c, 0xe6, 0x88, 0x90, 0xe6, 0x84, 0x9f, 0xe8, 0xa7,
  0x89, 0xe5, 0xae, 0x89, 0xe8, 0xa3, 0x85, 0xe5, 0xbe, 0x97, 0xe5, 0x88, 0xb0,
  0xe9, 0x82, 0xae, 0xe4, 0xbb, 0xb6, 0xe5, 0x88, 0xb6, 0xe5, 0xba, 0xa6, 0xe9,
  0xa3, 0x9f, 0xe5, 0x93, 0x81, 0xe8, 0x99, 0xbd, 0xe7, 0x84, 0xb6, 0xe8, 0xbd,
  0xac, 0xe8, 0xbd, 0xbd, 0xe6, 0x8a, 0xa5, 0xe4, 0xbb, 0xb7, 0xe8, 0xae, 0xb0,
  0xe8, 0x80, 0x85, 0xe6, 0x96, 0xb9, 0xe6, 0xa1, 0x88, 0xe8, 0xa1, 0x8c, 0xe6,
  0x94, 0xbf, 0xe4, 0xba, 0xba, 0xe6, 0xb0, 0x91, 0xe7, 0x94, 0xa8, 0xe5, 0x93,
  0x81, 0xe4, 0xb8, 0x9c, 0xe8, 0xa5, 0xbf, 0xe6, 0x8f, 0x90, 0xe5, 0x87, 0xba,
  0xe9, 0x85, 0x92, 0xe5, 0xba, 0x97, 0xe7, 0x84, 0xb6, 0xe5, 0x90, 0x8e, 0xe4,
  0xbb, 0x98, 0xe6, 0xac, 0xbe, 0xe7, 0x83, 0xad, 0xe7, 0x82, 0xb9, 0xe4, 0xbb,
  0xa5, 0xe5, 0x89, 0x8d, 0xe5, 0xae, 0x8c, 0xe5, 0x85, 0xa8, 0xe5, 0x8f, 0x91,
  0xe5, 0xb8, 0x96, 0xe8, 0xae, 0xbe, 0xe7, 0xbd, 0xae, 0xe9, 0xa2, 0x86, 0xe5,
  0xaf, 0xbc, 0xe5, 0xb7, 0xa5, 0xe4, 0xb8, 0x9a, 0xe5, 0x8c, 0xbb, 0xe9, 0x99,
  0xa2, 0xe7, 0x9c, 0x8b, 0xe7, 0x9c, 0x8b, 0xe7, 0xbb, 0x8f, 0xe5, 0x85, 0xb8,
  0xe5, 0x8e, 0x9f, 0xe5, 0x9b, 0xa0, 0xe5, 0xb9, 0xb3, 0xe5, 0x8f, 0xb0, 0xe5,
  0x90, 0x84, 0xe7, 0xa7, 0x8d, 0xe5, 0xa2, 0x9e, 0xe5, 0x8a, 0xa0, 0xe6, 0x9d,
  0x90, 0xe6, 0x96, 0x99, 0xe6, 0x96, 0xb0, 0xe5, 0xa2, 0x9e, 0xe4, 0xb9, 0x8b,
  0xe5, 0x90, 0x8e, 0xe8, 0x81, 0x8c, 0xe4, 0xb8, 0x9a, 0xe6, 0x95, 0x88, 0xe6,
  0x9e, 0x9c, 0xe4, 0xbb, 0x8a, 0xe5, 0xb9, 0xb4, 0xe8, 0xae, 0xba, 0xe6, 0x96,
  0x87, 0xe6, 0x88, 0x91, 0xe5, 0x9b, 0xbd, 0xe5, 0x91, 0x8a, 0xe8, 0xaf, 0x89,
  0xe7, 0x89, 0x88, 0xe4, 0xb8, 0xbb, 0xe4, 0xbf, 0xae, 0xe6, 0x94, 0xb9, 0xe5,
  0x8f, 0x82, 0xe4, 0xb8, 0x8e, 0xe6, 0x89, 0x93, 0xe5, 0x8d, 0xb0, 0xe5, 0xbf,
  0xab, 0xe4, 0xb9, 0x90, 0xe6, 0x9c, 0xba, 0xe6, 0xa2, 0xb0, 0xe8, 0xa7, 0x82,
  0xe7, 0x82, 0xb9, 0xe5, 0xad, 0x98, 0xe5, 0x9c, 0xa8, 0xe7, 0xb2, 0xbe, 0xe7,
  0xa5, 0x9e, 0xe8, 0x8e, 0xb7, 0xe5, 0xbe, 0x97, 0xe5, 0x88, 0xa9, 0xe7, 0x94,
  0xa8, 0xe7, 0xbb, 0xa7, 0xe7, 0xbb, 0xad, 0xe4, 0xbd, 0xa0, 0xe4, 0xbb, 0xac,
  0xe8, 0xbf, 0x99, 0xe4, 0xb9, 0x88, 0xe6, 0xa8, 0xa1, 0xe5, 0xbc, 0x8f, 0xe8,
  0xaf, 0xad, 0xe8, 0xa8, 0x80, 0xe8, 0x83, 0xbd, 0xe5, 0xa4, 0x9f, 0xe9, 0x9b,
  0x85, 0xe8, 0x99, 0x8e, 0xe6, 0x93, 0x8d, 0xe4, 0xbd, 0x9c, 0xe9, 0xa3, 0x8e,
  0xe6, 0xa0, 0xbc, 0xe4, 0xb8, 0x80, 0xe8, 0xb5, 0xb7, 0xe7, 0xa7, 0x91, 0xe5,
  0xad, 0xa6, 0xe4, 0xbd, 0x93, 0xe8, 0x82, 0xb2, 0xe7, 0x9f, 0xad, 0xe4, 0xbf,
  0xa1, 0xe6, 0x9d, 0xa1, 0xe4, 0xbb, 0xb6, 0xe6, 0xb2, 0xbb, 0xe7, 0x96, 0x97,
  0xe8, 0xbf, 0x90, 0xe5, 0x8a, 0xa8, 0xe4, 0xba, 0xa7, 0xe4, 0xb8, 0x9a, 0xe4,
  0xbc, 0x9a, 0xe8, 0xae, 0xae, 0xe5, 0xaf, 0xbc, 0xe8, 0x88, 0xaa, 0xe5, 0x85,
  0x88, 0xe7, 0x94, 0x9f, 0xe8, 0x81, 0x94, 0xe7, 0x9b, 0x9f, 0xe5, 0x8f, 0xaf,
  0xe6, 0x98, 0xaf, 0xe5, 0x95, 0x8f, 0xe9, 0xa1, 0x8c, 0xe7, 0xbb, 0x93, 0xe6,
  0x9e, 0x84, 0xe4, 0xbd, 0x9c, 0xe7, 0x94, 0xa8, 0xe8, 0xb0, 0x83, 0xe6, 0x9f,
  0xa5, 0xe8, 0xb3, 0x87, 0xe6, 0x96, 0x99, 0xe8, 0x87, 0xaa, 0xe5, 0x8a, 0xa8,
  0xe8, 0xb4, 0x9f, 0xe8, 0xb4, 0xa3, 0xe5, 0x86, 0x9c, 0xe4, 0xb8, 0x9a, 0xe8,
  0xae, 0xbf, 0xe9, 0x97, 0xae, 0xe5, 0xae, 0x9e, 0xe6, 0x96, 0xbd, 0xe6, 0x8e,
  0xa5, 0xe5, 0x8f, 0x97, 0xe8, 0xae, 0xa8, 0xe8, 0xae, 0xba, 0xe9, 0x82, 0xa3,
  0xe4, 0xb8, 0xaa, 0xe5, 0x8f, 0x8d, 0xe9, 0xa6, 0x88, 0xe5, 0x8a, 0xa0, 0xe5,
  0xbc, 0xba, 0xe5, 0xa5, 0xb3, 0xe6, 0x80, 0xa7, 0xe8, 0x8c, 0x83, 0xe5, 0x9b,
  0xb4, 0xe6, 0x9c, 0x8d, 0xe5, 0x8b, 0x99, 0xe4, 0xbc, 0x91, 0xe9, 0x97, 0xb2,
  0xe4, 0xbb, 0x8a, 0xe6, 0x97, 0xa5, 0xe5, 0xae, 0xa2, 0xe6, 0x9c, 0x8d, 0xe8,
  0xa7, 0x80, 0xe7, 0x9c, 0x8b, 0xe5, 0x8f, 0x82, 0xe5, 0x8a, 0xa0, 0xe7, 0x9a,
  0x84, 0xe8, 0xaf, 0x9d, 0xe4, 0xb8, 0x80, 0xe7, 0x82, 0xb9, 0xe4, 0xbf, 0x9d,
  0xe8, 0xaf, 0x81, 0xe5, 0x9b, 0xbe, 0xe4, 0xb9, 0xa6, 0xe6, 0x9c, 0x89, 0xe6,
  0x95, 0x88, 0xe6, 0xb5, 0x8b, 0xe8, 0xaf, 0x95, 0xe7, 0xa7, 0xbb, 0xe5, 0x8a,
  0xa8, 0xe6, 0x89, 0x8d, 0xe8, 0x83, 0xbd, 0xe5, 0x86, 0xb3, 0xe5, 0xae, 0x9a,
  0xe8, 0x82, 0xa1, 0xe7, 0xa5, 0xa8, 0xe4, 0xb8, 0x8d, 0xe6, 0x96, 0xad, 0xe9,
  0x9c, 0x80, 0xe6, 0xb1, 0x82, 0xe4, 0xb8, 0x8d, 0xe5, 0xbe, 0x97, 0xe5, 0x8a,
  0x9e, 0xe6, 0xb3, 0x95, 0xe4, 0xb9, 0x8b, 0xe9, 0x97, 0xb4, 0xe9, 0x87, 0x87,
  0xe7, 0x94, 0xa8, 0xe8, 0x90, 0xa5, 0xe9, 0x94, 0x80, 0xe6, 0x8a, 0x95, 0xe8,
  0xaf, 0x89, 0xe7, 0x9b, 0xae, 0xe6, 0xa0, 0x87, 0xe7, 0x88, 0xb1, 0xe6, 0x83,
  0x85, 0xe6, 0x91, 0x84, 0xe5, 0xbd, 0xb1, 0xe6, 0x9c, 0x89, 0xe4, 0xba, 0x9b,
  0xe8, 0xa4, 0x87, 0xe8, 0xa3, 0xbd, 0xe6, 0x96, 0x87, 0xe5, 0xad, 0xa6, 0xe6,
  0x9c, 0xba, 0xe4, 0xbc, 0x9a, 0xe6, 0x95, 0xb0, 0xe5, 0xad, 0x97, 0xe8, 0xa3,
  0x85, 0xe4, 0xbf, 0xae, 0xe8, 0xb4, 0xad, 0xe7, 0x89, 0xa9, 0xe5, 0x86, 0x9c,
  0xe6, 0x9d, 0x91, 0xe5, 0x85, 0xa8, 0xe9, 0x9d, 0xa2, 0xe7, 0xb2, 0xbe, 0xe5,
  0x93, 0x81, 0xe5, 0x85, 0xb6, 0xe5, 0xae, 0x9e, 0xe4, 0xba, 0x8b, 0xe6, 0x83,
  0x85, 0xe6, 0xb0, 0xb4, 0xe5, 0xb9, 0xb3, 0xe6, 0x8f, 0x90, 0xe7, 0xa4, 0xba,
  0xe4, 0xb8, 0x8a, 0xe5, 0xb8, 0x82, 0xe8, 0xb0, 0xa2, 0xe8, 0xb0, 0xa2, 0xe6,
  0x99, 0xae, 0xe9, 0x80, 0x9a, 0xe6, 0x95, 0x99, 0xe5, 0xb8, 0x88, 0xe4, 0xb8,
  0x8a, 0xe4, 0xbc, 0xa0, 0xe7, 0xb1, 0xbb, 0xe5, 0x88, 0xab, 0xe6, 0xad, 0x8c,
  0xe6, 0x9b, 0xb2, 0xe6, 0x8b, 0xa5, 0xe6, 0x9c, 0x89, 0xe5, 0x88, 0x9b, 0xe6,
  0x96, 0xb0, 0xe9, 0x85, 0x8d, 0xe4, 0xbb, 0xb6, 0xe5, 0x8f, 0xaa, 0xe8, 0xa6,
  0x81, 0xe6, 0x97, 0xb6, 0xe4, 0xbb, 0xa3, 0xe8, 0xb3, 0x87, 0xe8, 0xa8, 0x8a,
  0xe8, 0xbe, 0xbe, 0xe5, 0x88, 0xb0, 0xe4, 0xba, 0xba, 0xe7, 0x94, 0x9f, 0xe8,
  0xae, 0xa2, 0xe9, 0x98, 0x85, 0xe8, 0x80, 0x81, 0xe5, 0xb8, 0x88, 0xe5, 0xb1,
  0x95, 0xe7, 0xa4, 0xba, 0xe5, 0xbf, 0x83, 0xe7, 0x90, 0x86, 0xe8, 0xb4, 0xb4,
  0xe5, 0xad, 0x90, 0xe7, 0xb6, 0xb2, 0xe7, 0xab, 0x99, 0xe4, 0xb8, 0xbb, 0xe9,
  0xa1, 0x8c, 0xe8, 0x87, 0xaa, 0xe7, 0x84, 0xb6, 0xe7, 0xba, 0xa7, 0xe5, 0x88,
  0xab, 0xe7, 0xae, 0x80, 0xe5, 0x8d, 0x95, 0xe6, 0x94, 0xb9, 0xe9, 0x9d, 0xa9,
  0xe9, 0x82, 0xa3, 0xe4, 0xba, 0x9b, 0xe6, 0x9d, 0xa5, 0xe8, 0xaf, 0xb4, 0xe6,
  0x89, 0x93, 0xe5, 0xbc, 0x80, 0xe4, 0xbb, 0xa3, 0xe7, 0xa0, 0x81, 0xe5, 0x88,
  0xa0, 0xe9, 0x99, 0xa4, 0xe8, 0xaf, 0x81, 0xe5, 0x88, 0xb8, 0xe8, 0x8a, 0x82,
  0xe7, 0x9b, 0xae, 0xe9, 0x87, 0x8d, 0xe7, 0x82, 0xb9, 0xe6, 0xac, 0xa1, 0xe6,
  0x95, 0xb8, 0xe5, 0xa4, 0x9a, 0xe5, 0xb0, 0x91, 0xe8, 0xa7, 0x84, 0xe5, 0x88,
  0x92, 0xe8, 0xb5, 0x84, 0xe9, 0x87, 0x91, 0xe6, 0x89, 0xbe, 0xe5, 0x88, 0xb0,
  0xe4, 0xbb, 0xa5, 0xe5, 0x90, 0x8e, 0xe5, 0xa4, 0xa7, 0xe5, 0x85, 0xa8, 0xe4,
  0xb8, 0xbb, 0xe9, 0xa1, 0xb5, 0xe6, 0x9c, 0x80, 0xe4, 0xbd, 0xb3, 0xe5, 0x9b,
  0x9e, 0xe7, 0xad, 0x94, 0xe5, 0xa4, 0xa9, 0xe4, 0xb8, 0x8b, 0xe4, 0xbf, 0x9d,
  0xe9, 0x9a, 0x9c, 0xe7, 0x8e, 0xb0, 0xe4, 0xbb, 0xa3, 0xe6, 0xa3, 0x80, 0xe6,
  0x9f, 0xa5, 0xe6, 0x8a, 0x95, 0xe7, 0xa5, 0xa8, 0xe5, 0xb0, 0x8f, 0xe6, 0x97,
  0xb6, 0xe6, 0xb2, 0x92, 0xe6, 0x9c, 0x89, 0xe6, 0xad, 0xa3, 0xe5, 0xb8, 0xb8,
  0xe7, 0x94, 0x9a, 0xe8, 0x87, 0xb3, 0xe4, 0xbb, 0xa3, 0xe7, 0x90, 0x86, 0xe7,
  0x9b, 0xae, 0xe5, 0xbd, 0x95, 0xe5, 0x85, 0xac, 0xe5, 0xbc, 0x80, 0xe5, 0xa4,
  0x8d, 0xe5, 0x88, 0xb6, 0xe9, 0x87, 0x91, 0xe8, 0x9e, 0x8d, 0xe5, 0xb9, 0xb8,
  0xe7, 0xa6, 0x8f, 0xe7, 0x89, 0x88, 0xe6, 0x9c, 0xac, 0xe5, 0xbd, 0xa2, 0xe6,
  0x88, 0x90, 0xe5, 0x87, 0x86, 0xe5, 0xa4, 0x87, 0xe8, 0xa1, 0x8c, 0xe6, 0x83,
  0x85, 0xe5, 0x9b, 0x9e, 0xe5, 0x88, 0xb0, 0xe6, 0x80, 0x9d, 0xe6, 0x83, 0xb3,
  0xe6, 0x80, 0x8e, 0xe6, 0xa0, 0xb7, 0xe5, 0x8d, 0x8f, 0xe8, 0xae, 0xae, 0xe8,
  0xae, 0xa4, 0xe8, 0xaf, 0x81, 0xe6, 0x9c, 0x80, 0xe5, 0xa5, 0xbd, 0xe4, 0xba,
  0xa7, 0xe7, 0x94, 0x9f, 0xe6, 0x8c, 0x89, 0xe7, 0x85, 0xa7, 0xe6, 0x9c, 0x8d,
  0xe8, 0xa3, 0x85, 0xe5, 0xb9, 0xbf, 0xe4, 0xb8, 0x9c, 0xe5, 0x8a, 0xa8, 0xe6,
  0xbc, 0xab, 0xe9, 0x87, 0x87, 0xe8, 0xb4, 0xad, 0xe6, 0x96, 0xb0, 0xe6, 0x89,
  0x8b, 0xe7, 0xbb, 0x84, 0xe5, 0x9b, 0xbe, 0xe9, 0x9d, 0xa2, 0xe6, 0x9d, 0xbf,
  0xe5, 0x8f, 0x82, 0xe8, 0x80, 0x83, 0xe6, 0x94, 0xbf, 0xe6, 0xb2, 0xbb, 0xe5,
  0xae, 0xb9, 0xe6, 0x98, 0x93, 0xe5, 0xa4, 0xa9, 0xe5, 0x9c, 0xb0, 0xe5, 0x8a,
  0xaa, 0xe5, 0x8a, 0x9b, 0xe4, 0xba, 0xba, 0xe4, 0xbb, 0xac, 0xe5, 0x8d, 0x87,
  0xe7, 0xba, 0xa7, 0xe9, 0x80, 0x9f, 0xe5, 0xba, 0xa6, 0xe4, 0xba, 0xba, 0xe7,
  0x89, 0xa9, 0xe8, 0xb0, 0x83, 0xe6, 0x95, 0xb4, 0xe6, 0xb5, 0x81, 0xe8, 0xa1,
  0x8c, 0xe9, 0x80, 0xa0, 0xe6, 0x88, 0x90, 0xe6, 0x96, 0x87, 0xe5, 0xad, 0x97,
  0xe9, 0x9f, 0xa9, 0xe5, 0x9b, 0xbd, 0xe8, 0xb4, 0xb8, 0xe6, 0x98, 0x93, 0xe5,
  0xbc, 0x80, 0xe5, 0xb1, 0x95, 0xe7, 0x9b, 0xb8, 0xe9, 0x97, 0x9c, 0xe8, 0xa1,
  0xa8, 0xe7, 0x8e, 0xb0, 0xe5, 0xbd, 0xb1, 0xe8, 0xa7, 0x86, 0xe5, 0xa6, 0x82,
  0xe6, 0xad, 0xa4, 0xe7, 0xbe, 0x8e, 0xe5, 0xae, 0xb9, 0xe5, 0xa4, 0xa7, 0xe5,
  0xb0, 0x8f, 0xe6, 0x8a, 0xa5, 0xe9, 0x81, 0x93, 0xe6, 0x9d, 0xa1, 0xe6, 0xac,
  0xbe, 0xe5, 0xbf, 0x83, 0xe6, 0x83, 0x85, 0xe8, 0xae, 0xb8, 0xe5, 0xa4, 0x9a,
  0xe6, 0xb3, 0x95, 0xe8, 0xa7, 0x84, 0xe5, 0xae, 0xb6, 0xe5, 0xb1, 0x85, 0xe4,
  0xb9, 0xa6, 0xe5, 0xba, 0x97, 0xe8, 0xbf, 0x9e, 0xe6, 0x8e, 0xa5, 0xe7, 0xab,
  0x8b, 0xe5, 0x8d, 0xb3, 0xe4, 0xb8, 0xbe, 0xe6, 0x8a, 0xa5, 0xe6, 0x8a, 0x80,
  0xe5, 0xb7, 0xa7, 0xe5, 0xa5, 0xa5, 0xe8, 0xbf, 0x90, 0xe7, 0x99, 0xbb, 0xe5,
  0x85, 0xa5, 0xe4, 0xbb, 0xa5, 0xe6, 0x9d, 0xa5, 0xe7, 0x90, 0x86, 0xe8, 0xae,
  0xba, 0xe4, 0xba, 0x8b, 0xe4, 0xbb, 0xb6, 0xe8, 0x87, 0xaa, 0xe7, 0x94, 0xb1,
  0xe4, 0xb8, 0xad, 0xe5, 0x8d, 0x8e, 0xe5, 0x8a, 0x9e, 0xe5, 0x85, 0xac, 0xe5,
  0xa6, 0x88, 0xe5, 0xa6, 0x88, 0xe7, 0x9c, 0x9f, 0xe6, 0xad, 0xa3, 0xe4, 0xb8,
  0x8d, 0xe9, 0x94, 0x99, 0xe5, 0x85, 0xa8, 0xe6, 0x96, 0x87, 0xe5, 0x90, 0x88,
  0xe5, 0x90, 0x8c, 0xe4, 0xbb, 0xb7, 0xe5, 0x80, 0xbc, 0xe5, 0x88, 0xab, 0xe4,
  0xba, 0xba, 0xe7, 0x9b, 0x91, 0xe7, 0x9d, 0xa3, 0xe5, 0x85, 0xb7, 0xe4, 0xbd,
  0x93, 0xe4, 0xb8, 0x96, 0xe7, 0xba, 0xaa, 0xe5, 0x9b, 0xa2, 0xe9, 0x98, 0x9f,
  0xe5, 0x88, 0x9b, 0xe4, 0xb8, 0x9a, 0xe6, 0x89, 0xbf, 0xe6, 0x8b, 0x85, 0xe5,
  0xa2, 0x9e, 0xe9, 0x95, 0xbf, 0xe6, 0x9c, 0x89, 0xe4, 0xba, 0xba, 0xe4, 0xbf,
  0x9d, 0xe6, 0x8c, 0x81, 0xe5, 0x95, 0x86, 0xe5, 0xae, 0xb6, 0xe7, 0xbb, 0xb4,
  0xe4, 0xbf, 0xae, 0xe5, 0x8f, 0xb0, 0xe6, 0xb9, 0xbe, 0xe5, 0xb7, 0xa6, 0xe5,
  0x8f, 0xb3, 0xe8, 0x82, 0xa1, 0xe4, 0xbb, 0xbd, 0xe7, 0xad, 0x94, 0xe6, 0xa1,
  0x88, 0xe5, 0xae, 0x9e, 0xe9, 0x99, 0x85, 0xe7, 0x94, 0xb5, 0xe4, 0xbf, 0xa1,
  0xe7, 0xbb, 0x8f, 0xe7, 0x90, 0x86, 0xe7, 0x94, 0x9f, 0xe5, 0x91, 0xbd, 0xe5,
  0xae, 0xa3, 0xe4, 0xbc, 0xa0, 0xe4, 0xbb, 0xbb, 0xe5, 0x8a, 0xa1, 0xe6, 0xad,
  0xa3, 0xe5, 0xbc, 0x8f, 0xe7, 0x89, 0xb9, 0xe8, 0x89, 0xb2, 0xe4, 0xb8, 0x8b,
  0xe6, 0x9d, 0xa5, 0xe5, 0x8d, 0x8f, 0xe4, 0xbc, 0x9a, 0xe5, 0x8f, 0xaa, 0xe8,
  0x83, 0xbd, 0xe5, 0xbd, 0x93, 0xe7, 0x84, 0xb6, 0xe9, 0x87, 0x8d, 0xe6, 0x96,
  0xb0, 0xe5, 0x85, 0xa7, 0xe5, 0xae, 0xb9, 0xe6, 0x8c, 0x87, 0xe5, 0xaf, 0xbc,
  0xe8, 0xbf, 0x90, 0xe8, 0xa1, 0x8c, 0xe6, 0x97, 0xa5, 0xe5, 0xbf, 0x97, 0xe8,
  0xb3, 0xa3, 0xe5, 0xae, 0xb6, 0xe8, 0xb6, 0x85, 0xe8, 0xbf, 0x87, 0xe5, 0x9c,
  0x9f, 0xe5, 0x9c, 0xb0, 0xe6, 0xb5, 0x99, 0xe6, 0xb1, 0x9f, 0xe6, 0x94, 0xaf,
  0xe4, 0xbb, 0x98, 0xe6, 0x8e, 0xa8, 0xe5, 0x87, 0xba, 0xe7, 0xab, 0x99, 0xe9,
  0x95, 0xbf, 0xe6, 0x9d, 0xad, 0xe5, 0xb7, 0x9e, 0xe6, 0x89, 0xa7, 0xe8, 0xa1,
  0x8c, 0xe5, 0x88, 0xb6, 0xe9, 0x80, 0xa0, 0xe4, 0xb9, 0x8b, 0xe4, 0xb8, 0x80,
  0xe6, 0x8e, 0xa8, 0xe5, 0xb9, 0xbf, 0xe7, 0x8e, 0xb0, 0xe5, 0x9c, 0xba, 0xe6,
  0x8f, 0x8f, 0xe8, 0xbf, 0xb0, 0xe5, 0x8f, 0x98, 0xe5, 0x8c, 0x96, 0xe4, 0xbc,
  0xa0, 0xe7, 0xbb, 0x9f, 0xe6, 0xad, 0x8c, 0xe6, 0x89, 0x8b, 0xe4, 0xbf, 0x9d,
  0xe9, 0x99, 0xa9, 0xe8, 0xaf, 0xbe, 0xe7, 0xa8, 0x8b, 0xe5, 0x8c, 0xbb, 0xe7,
  0x96, 0x97, 0xe7, 0xbb, 0x8f, 0xe8, 0xbf, 0x87, 0xe8, 0xbf, 0x87, 0xe5, 0x8e,
  0xbb, 0xe4, 0xb9, 0x8b, 0xe5, 0x89, 0x8d, 0xe6, 0x94, 0xb6, 0xe5, 0x85, 0xa5,
  0xe5, 0xb9, 0xb4, 0xe5, 0xba, 0xa6, 0xe6, 0x9d, 0x82, 0xe5, 0xbf, 0x97, 0xe7,
  0xbe, 0x8e, 0xe4, 0xb8, 0xbd, 0xe6, 0x9c, 0x80, 0xe9, 0xab, 0x98, 0xe7, 0x99,
  0xbb, 0xe9, 0x99, 0x86, 0xe6, 0x9c, 0xaa, 0xe6, 0x9d, 0xa5, 0xe5, 0x8a, 0xa0,
  0xe5, 0xb7, 0xa5, 0xe5, 0x85, 0x8d, 0xe8, 0xb4, 0xa3, 0xe6, 0x95, 0x99, 0xe7,
  0xa8, 0x8b, 0xe7, 0x89, 0x88, 0xe5, 0x9d, 0x97, 0xe8, 0xba, 0xab, 0xe4, 0xbd,
  0x93, 0xe9, 0x87, 0x8d, 0xe5, 0xba, 0x86, 0xe5, 0x87, 0xba, 0xe5, 0x94, 0xae,
  0xe6, 0x88, 0x90, 0xe6, 0x9c, 0xac, 0xe5, 0xbd, 0xa2, 0xe5, 0xbc, 0x8f, 0xe5,
  0x9c, 0x9f, 0xe8, 0xb1, 0x86, 0xe5, 0x87, 0xba, 0xe5, 0x83, 0xb9, 0xe4, 0xb8,
  0x9c, 0xe6, 0x96, 0xb9, 0xe9, 0x82, 0xae, 0xe7, 0xae, 0xb1, 0xe5, 0x8d, 0x97,
  0xe4, 0xba, 0xac, 0xe6, 0xb1, 0x82, 0xe8, 0x81, 0x8c, 0xe5, 0x8f, 0x96, 0xe5,
  0xbe, 0x97, 0xe8, 0x81, 0x8c, 0xe4, 0xbd, 0x8d, 0xe7, 0x9b, 0xb8, 0xe4, 0xbf,
  0xa1, 0xe9, 0xa1, 0xb5, 0xe9, 0x9d, 0xa2, 0xe5, 0x88, 0x86, 0xe9, 0x92, 0x9f,
  0xe7, 0xbd, 0x91, 0xe9, 0xa1, 0xb5, 0xe7, 0xa1, 0xae, 0xe5, 0xae, 0x9a, 0xe5,
  0x9b, 0xbe, 0xe4, 0xbe, 0x8b, 0xe7, 0xbd, 0x91, 0xe5, 0x9d, 0x80, 0xe7, 0xa7,
  0xaf, 0xe6, 0x9e, 0x81, 0xe9, 0x94, 0x99, 0xe8, 0xaf, 0xaf, 0xe7, 0x9b, 0xae,
  0xe7, 0x9a, 0x84, 0xe5, 0xae, 0x9d, 0xe8, 0xb4, 0x9d, 0xe6, 0x9c, 0xba, 0xe5,
  0x85, 0xb3, 0xe9, 0xa3, 0x8e, 0xe9, 0x99, 0xa9, 0xe6, 0x8e, 0x88, 0xe6, 0x9d,
  0x83, 0xe7, 0x97, 0x85, 0xe6, 0xaf, 0x92, 0xe5, 0xae, 0xa0, 0xe7, 0x89, 0xa9,
  0xe9, 0x99, 0xa4, 0xe4, 0xba, 0x86, 0xe8, 0xa9, 0x95, 0xe8, 0xab, 0x96, 0xe7,
  0x96, 0xbe, 0xe7, 0x97, 0x85, 0xe5, 0x8f, 0x8a, 0xe6, 0x97, 0xb6, 0xe6, 0xb1,
  0x82, 0xe8, 0xb4, 0xad, 0xe7, 0xab, 0x99, 0xe7, 0x82, 0xb9, 0xe5, 0x84, 0xbf,
  0xe7, 0xab, 0xa5, 0xe6, 0xaf, 0x8f, 0xe5, 0xa4, 0xa9, 0xe4, 0xb8, 0xad, 0xe5,
  0xa4, 0xae, 0xe8, 0xae, 0xa4, 0xe8, 0xaf, 0x86, 0xe6, 0xaf, 0x8f, 0xe4, 0xb8,
  0xaa, 0xe5, 0xa4, 0xa9, 0xe6, 0xb4, 0xa5, 0xe5, 0xad, 0x97, 0xe4, 0xbd, 0x93,
  0xe5, 0x8f, 0xb0, 0xe7, 0x81, 0xa3, 0xe7, 0xbb, 0xb4, 0xe6, 0x8a, 0xa4, 0xe6,
  0x9c, 0xac, 0xe9, 0xa1, 0xb5, 0xe4, 0xb8, 0xaa, 0xe6, 0x80, 0xa7, 0xe5, 0xae,
  0x98, 0xe6, 0x96, 0xb9, 0xe5, 0xb8, 0xb8, 0xe8, 0xa7, 0x81, 0xe7, 0x9b, 0xb8,
  0xe6, 0x9c, 0xba, 0xe6, 0x88, 0x98, 0xe7, 0x95, 0xa5, 0xe5, 0xba, 0x94, 0xe5,
  0xbd, 0x93, 0xe5, 0xbe, 0x8b, 0xe5, 0xb8, 0x88, 0xe6, 0x96, 0xb9, 0xe4, 0xbe,
  0xbf, 0xe6, 0xa0, 0xa1, 0xe5, 0x9b, 0xad, 0xe8, 0x82, 0xa1, 0xe5, 0xb8, 0x82,
  0xe6, 0x88, 0xbf, 0xe5, 0xb1, 0x8b, 0xe6, 0xa0, 0x8f, 0xe7, 0x9b, 0xae, 0xe5,
  0x91, 0x98, 0xe5, 0xb7, 0xa5, 0xe5, 0xaf, 0xbc, 0xe8, 0x87, 0xb4, 0xe7, 0xaa,
  0x81, 0xe7, 0x84, 0xb6, 0xe9, 0x81, 0x93, 0xe5, 0x85, 0xb7, 0xe6, 0x9c, 0xac,
  0xe7, 0xbd, 0x91, 0xe7, 0xbb, 0x93, 0xe5, 0x90, 0x88, 0xe6, 0xa1, 0xa3, 0xe6,
  0xa1, 0x88, 0xe5, 0x8a, 0xb3, 0xe5, 0x8a, 0xa8, 0xe5, 0x8f, 0xa6, 0xe5, 0xa4,
  0x96, 0xe7, 0xbe, 0x8e, 0xe5, 0x85, 0x83, 0xe5, 0xbc, 0x95, 0xe8, 0xb5, 0xb7,
  0xe6, 0x94, 0xb9, 0xe5, 0x8f, 0x98, 0xe7, 0xac, 0xac, 0xe5, 0x9b, 0x9b, 0xe4,
  0xbc, 0x9a, 0xe8, 0xae, 0xa1, 0xe8, 0xaa, 0xaa, 0xe6, 0x98, 0x8e, 0xe9, 0x9a,
  0x90, 0xe7, 0xa7, 0x81, 0xe5, 0xae, 0x9d, 0xe5, 0xae, 0x9d, 0xe8, 0xa7, 0x84,
  0xe8, 0x8c, 0x83, 0xe6, 0xb6, 0x88, 0xe8, 0xb4, 0xb9, 0xe5, 0x85, 0xb1, 0xe5,
  0x90, 0x8c, 0xe5, 0xbf, 0x98, 0xe8, 0xae, 0xb0, 0xe4, 0xbd, 0x93, 0xe7, 0xb3,
  0xbb, 0xe5, 0xb8, 0xa6, 0xe6, 0x9d, 0xa5, 0xe5, 0x90, 0x8d, 0xe5, 0xad, 0x97,
  0xe7, 0x99, 0xbc, 0xe8, 0xa1, 0xa8, 0xe5, 0xbc, 0x80, 0xe6, 0x94, 0xbe, 0xe5,
  0x8a, 0xa0, 0xe7, 0x9b, 0x9f, 0xe5, 0x8f, 0x97, 0xe5, 0x88, 0xb0, 0xe4, 0xba,
  0x8c, 0xe6, 0x89, 0x8b, 0xe5, 0xa4, 0xa7, 0xe9, 0x87, 0x8f, 0xe6, 0x88, 0x90,
  0xe4, 0xba, 0xba, 0xe6, 0x95, 0xb0, 0xe9, 0x87, 0x8f, 0xe5, 0x85, 0xb1, 0xe4,
  0xba, 0xab, 0xe5, 0x8c, 0xba, 0xe5, 0x9f, 0x9f, 0xe5, 0xa5, 0xb3, 0xe5, 0xad,
  0xa9, 0xe5, 0x8e, 0x9f, 0xe5, 0x88, 0x99, 0xe6, 0x89, 0x80, 0xe5, 0x9c, 0xa8,
  0xe7, 0xbb, 0x93, 0xe6, 0x9d, 0x9f, 0xe9, 0x80, 0x9a, 0xe4, 0xbf, 0xa1, 0xe8,
  0xb6, 0x85, 0xe7, 0xba, 0xa7, 0xe9, 0x85, 0x8d, 0xe7, 0xbd, 0xae, 0xe5, 0xbd,
  0x93, 0xe6, 0x97, 0xb6, 0xe4, 0xbc, 0x98, 0xe7, 0xa7, 0x80, 0xe6, 0x80, 0xa7,
  0xe6, 0x84, 0x9f, 0xe6, 0x88, 0xbf, 0xe4, 0xba, 0xa7, 0xe9, 0x81, 0x8a, 0xe6,
  0x88, 0xb2, 0xe5, 0x87, 0xba, 0xe5, 0x8f, 0xa3, 0xe6, 0x8f, 0x90, 0xe4, 0xba,
  0xa4, 0xe5, 0xb0, 0xb1, 0xe4, 0xb8, 0x9a, 0xe4, 0xbf, 0x9d, 0xe5, 0x81, 0xa5,
  0xe7, 0xa8, 0x8b, 0xe5, 0xba, 0xa6, 0xe5, 0x8f, 0x82, 0xe6, 0x95, 0xb0, 0xe4,
  0xba, 0x8b, 0xe4, 0xb8, 0x9a, 0xe6, 0x95, 0xb4, 0xe4, 0xb8, 0xaa, 0xe5, 0xb1,
  0xb1, 0xe4, 0xb8, 0x9c, 0xe6, 0x83, 0x85, 0xe6, 0x84, 0x9f, 0xe7, 0x89, 0xb9,
  0xe6, 0xae, 0x8a, 0xe5, 0x88, 0x86, 0xe9, 0xa1, 0x9e, 0xe6, 0x90, 0x9c, 0xe5,
  0xb0, 0x8b, 0xe5, 0xb1, 0x9e, 0xe4, 0xba, 0x8e, 0xe9, 0x97, 0xa8, 0xe6, 0x88,
  0xb7, 0xe8, 0xb4, 0xa2, 0xe5, 0x8a, 0xa1, 0xe5, 0xa3, 0xb0, 0xe9, 0x9f, 0xb3,
  0xe5, 0x8f, 0x8a, 0xe5, 0x85, 0xb6, 0xe8, 0xb4, 0xa2, 0xe7, 0xbb, 0x8f, 0xe5,
  0x9d, 0x9a, 0xe6, 0x8c, 0x81, 0xe5, 0xb9, 0xb2, 0xe9, 0x83, 0xa8, 0xe6, 0x88,
  0x90, 0xe7, 0xab, 0x8b, 0xe5, 0x88, 0xa9, 0xe7, 0x9b, 0x8a, 0xe8, 0x80, 0x83,
  0xe8, 0x99, 0x91, 0xe6, 0x88, 0x90, 0xe9, 0x83, 0xbd, 0xe5, 0x8c, 0x85, 0xe8,
  0xa3, 0x85, 0xe7, 0x94, 0xa8, 0xe6, 0x88, 0xb6, 0xe6, 0xaf, 0x94, 0xe8, 0xb5,
  0x9b, 0xe6, 0x96, 0x87, 0xe6, 0x98, 0x8e, 0xe6, 0x8b, 0x9b, 0xe5, 0x95, 0x86,
  0xe5, 0xae, 0x8c, 0xe6, 0x95, 0xb4, 0xe7, 0x9c, 0x9f, 0xe6, 0x98, 0xaf, 0xe7,
  0x9c, 0xbc, 0xe7, 0x9d, 0x9b, 0xe4, 0xbc, 0x99, 0xe4, 0xbc, 0xb4, 0xe5, 0xa8,
  0x81, 0xe6, 0x9c, 0x9b, 0xe9, 0xa2, 0x86, 0xe5, 0x9f, 0x9f, 0xe5, 0x8d, 0xab,
  0xe7, 0x94, 0x9f, 0xe4, 0xbc, 0x98, 0xe6, 0x83, 0xa0, 0xe8, 0xab, 0x96, 0xe5,
  0xa3, 0x87, 0xe5, 0x85, 0xac, 0xe5, 0x85, 0xb1, 0xe8, 0x89, 0xaf, 0xe5, 0xa5,
  0xbd, 0xe5, 0x85, 0x85, 0xe5, 0x88, 0x86, 0xe7, 0xac, 0xa6, 0xe5, 0x90, 0x88,
  0xe9, 0x99, 0x84, 0xe4, 0xbb, 0xb6, 0xe7, 0x89, 0xb9, 0xe7, 0x82, 0xb9, 0xe4,
  0xb8, 0x8d, 0xe5, 0x8f, 0xaf, 0xe8, 0x8b, 0xb1, 0xe6, 0x96, 0x87, 0xe8, 0xb5,
  0x84, 0xe4, 0xba, 0xa7, 0xe6, 0xa0, 0xb9, 0xe6, 0x9c, 0xac, 0xe6, 0x98, 0x8e,
  0xe6, 0x98, 0xbe, 0xe5, 0xaf, 0x86, 0xe7, 0xa2, 0xbc, 0xe5, 0x85, 0xac, 0xe4,
  0xbc, 0x97, 0xe6, 0xb0, 0x91, 0xe6, 0x97, 0x8f, 0xe6, 0x9b, 0xb4, 0xe5, 0x8a,
  0xa0, 0xe4, 0xba, 0xab, 0xe5, 0x8f, 0x97, 0xe5, 0x90, 0x8c, 0xe5, 0xad, 0xa6,
  0xe5, 0x90, 0xaf, 0xe5, 0x8a, 0xa8, 0xe9, 0x80, 0x82, 0xe5, 0x90, 0x88, 0xe5,
  0x8e, 0x9f, 0xe6, 0x9d, 0xa5, 0xe9, 0x97, 0xae, 0xe7, 0xad, 0x94, 0xe6, 0x9c,
  0xac, 0xe6, 0x96, 0x87, 0xe7, 0xbe, 0x8e, 0xe9, 0xa3, 0x9f, 0xe7, 0xbb, 0xbf,
  0xe8, 0x89, 0xb2, 0xe7, 0xa8, 0xb3, 0xe5, 0xae, 0x9a, 0xe7, 0xbb, 0x88, 0xe4,
  0xba, 0x8e, 0xe7, 0x94, 0x9f, 0xe7, 0x89, 0xa9, 0xe4, 0xbe, 0x9b, 0xe6, 0xb1,
  0x82, 0xe6, 0x90, 0x9c, 0xe7, 0x8b, 0x90, 0xe5, 0x8a, 0x9b, 0xe9, 0x87, 0x8f,
  0xe4, 0xb8, 0xa5, 0xe9, 0x87, 0x8d, 0xe6, 0xb0, 0xb8, 0xe8, 0xbf, 0x9c, 0xe5,
  0x86, 0x99, 0xe7, 0x9c, 0x9f, 0xe6, 0x9c, 0x89, 0xe9, 0x99, 0x90, 0xe7, 0xab,
  0x9e, 0xe4, 0xba, 0x89, 0xe5, 0xaf, 0xb9, 0xe8, 0xb1, 0xa1, 0xe8, 0xb4, 0xb9,
  0xe7, 0x94, 0xa8, 0xe4, 0xb8, 0x8d, 0xe5, 0xa5, 0xbd, 0xe7, 0xbb, 0x9d, 0xe5,
  0xaf, 0xb9, 0xe5, 0x8d, 0x81, 0xe5, 0x88, 0x86, 0xe4, 0xbf, 0x83, 0xe8, 0xbf,
  0x9b, 0xe7, 0x82, 0xb9, 0xe8, 0xaf, 0x84, 0xe5, 0xbd, 0xb1, 0xe9, 0x9f, 0xb3,
  0xe4, 0xbc, 0x98, 0xe5, 0x8a, 0xbf, 0xe4, 0xb8, 0x8d, 0xe5, 0xb0, 0x91, 0xe6,
  0xac, 0xa3, 0xe8, 0xb5, 0x8f, 0xe5, 0xb9, 0xb6, 0xe4, 0xb8, 0x94, 0xe6, 0x9c,
  0x89, 0xe7, 0x82, 0xb9, 0xe6, 0x96, 0xb9, 0xe5, 0x90, 0x91, 0xe5, 0x85, 0xa8,
  0xe6, 0x96, 0xb0, 0xe4, 0xbf, 0xa1, 0xe7, 0x94, 0xa8, 0xe8, 0xae, 0xbe, 0xe6,
  0x96, 0xbd, 0xe5, 0xbd, 0xa2, 0xe8, 0xb1, 0xa1, 0xe8, 0xb5, 0x84, 0xe6, 0xa0,
  0xbc, 0xe7, 0xaa, 0x81, 0xe7, 0xa0, 0xb4, 0xe9, 0x9a, 0x8f, 0xe7, 0x9d, 0x80,
  0xe9, 0x87, 0x8d, 0xe5, 0xa4, 0xa7, 0xe4, 0xba, 0x8e, 0xe6, 0x98, 0xaf, 0xe6,
  0xaf, 0x95, 0xe4, 0xb8, 0x9a, 0xe6, 0x99, 0xba, 0xe8, 0x83, 0xbd, 0xe5, 0x8c,
  0x96, 0xe5, 0xb7, 0xa5, 0xe5, 0xae, 0x8c, 0xe7, 0xbe, 0x8e, 0xe5, 0x95, 0x86,
  0xe5, 0x9f, 0x8e, 0xe7, 0xbb, 0x9f, 0xe4, 0xb8, 0x80, 0xe5, 0x87, 0xba, 0xe7,
  0x89, 0x88, 0xe6, 0x89, 0x93, 0xe9, 0x80, 0xa0, 0xe7, 0x94, 0xa2, 0xe5, 0x93,
  0x81, 0xe6, 0xa6, 0x82, 0xe5, 0x86, 0xb5, 0xe7, 0x94, 0xa8, 0xe4, 0xba, 0x8e,
  0xe4, 0xbf, 0x9d, 0xe7, 0x95, 0x99, 0xe5, 0x9b, 0xa0, 0xe7, 0xb4, 0xa0, 0xe4,
  0xb8, 0xad, 0xe5, 0x9c, 0x8b, 0xe5, 0xad, 0x98, 0xe5, 0x82, 0xa8, 0xe8, 0xb4,
  0xb4, 0xe5, 0x9b, 0xbe, 0xe6, 0x9c, 0x80, 0xe6, 0x84, 0x9b, 0xe9, 0x95, 0xbf,
  0xe6, 0x9c, 0x9f, 0xe5, 0x8f, 0xa3, 0xe4, 0xbb, 0xb7, 0xe7, 0x90, 0x86, 0xe8,
  0xb4, 0xa2, 0xe5, 0x9f, 0xba, 0xe5, 0x9c, 0xb0, 0xe5, 0xae, 0x89, 0xe6, 0x8e,
  0x92, 0xe6, 0xad, 0xa6, 0xe6, 0xb1, 0x89, 0xe9, 0x87, 0x8c, 0xe9, 0x9d, 0xa2,
  0xe5, 0x88, 0x9b, 0xe5, 0xbb, 0xba, 0xe5, 0xa4, 0xa9, 0xe7, 0xa9, 0xba, 0xe9,
  0xa6, 0x96, 0xe5, 0x85, 0x88, 0xe5, 0xae, 0x8c, 0xe5, 0x96, 0x84, 0xe9, 0xa9,
  0xb1, 0xe5, 0x8a, 0xa8, 0xe4, 0xb8, 0x8b, 0xe9, 0x9d, 0xa2, 0xe4, 0xb8, 0x8d,
  0xe5, 0x86, 0x8d, 0xe8, 0xaf, 0x9a, 0xe4, 0xbf, 0xa1, 0xe6, 0x84, 0x8f, 0xe4,
  0xb9, 0x89, 0xe9, 0x98, 0xb3, 0xe5, 0x85, 0x89, 0xe8, 0x8b, 0xb1, 0xe5, 0x9b,
  0xbd, 0xe6, 0xbc, 0x82, 0xe4, 0xba, 0xae, 0xe5, 0x86, 0x9b, 0xe4, 0xba, 0x8b,
  0xe7, 0x8e, 0xa9, 0xe5, 0xae, 0xb6, 0xe7, 0xbe, 0xa4, 0xe4, 0xbc, 0x97, 0xe5,
  0x86, 0x9c, 0xe6, 0xb0, 0x91, 0xe5, 0x8d, 0xb3, 0xe5, 0x8f, 0xaf, 0xe5, 0x90,
  0x8d, 0xe7, 0xa8, 0xb1, 0xe5, 0xae, 0xb6, 0xe5, 0x85, 0xb7, 0xe5, 0x8a, 0xa8,
  0xe7, 0x94, 0xbb, 0xe6, 0x83, 0xb3, 0xe5, 0x88, 0xb0, 0xe6, 0xb3, 0xa8, 0xe6,
  0x98, 0x8e, 0xe5, 0xb0, 0x8f, 0xe5, 0xad, 0xa6, 0xe6, 0x80, 0xa7, 0xe8, 0x83,
  0xbd, 0xe8, 0x80, 0x83, 0xe7, 0xa0, 0x94, 0xe7, 0xa1, 0xac, 0xe4, 0xbb, 0xb6,
  0xe8, 0xa7, 0x82, 0xe7, 0x9c, 0x8b, 0xe6, 0xb8, 0x85, 0xe6, 0xa5, 0x9a, 0xe6,
  0x90, 0x9e, 0xe7, 0xac, 0x91, 0xe9, 0xa6, 0x96, 0xe9, 0xa0, 0x81, 0xe9, 0xbb,
  0x84, 0xe9, 0x87, 0x91, 0xe9, 0x80, 0x82, 0xe7, 0x94, 0xa8, 0xe6, 0xb1, 0x9f,
  0xe8, 0x8b, 0x8f, 0xe7, 0x9c, 0x9f, 0xe5, 0xae, 0x9e, 0xe4, 0xb8, 0xbb, 0xe7,
  0xae, 0xa1, 0xe9, 0x98, 0xb6, 0xe6, 0xae, 0xb5, 0xe8, 0xa8, 0xbb, 0xe5, 0x86,
  0x8a, 0xe7, 0xbf, 0xbb, 0xe8, 0xaf, 0x91, 0xe6, 0x9d, 0x83, 0xe5, 0x88, 0xa9,
  0xe5, 0x81, 0x9a, 0xe5, 0xa5, 0xbd, 0xe4, 0xbc, 0xbc, 0xe4, 0xb9, 0x8e, 0xe9,
  0x80, 0x9a, 0xe8, 0xae, 0xaf, 0xe6, 0x96, 0xbd, 0xe5, 0xb7, 0xa5, 0xe7, 0x8b,
  0x80, 0xe6, 0x85, 0x8b, 0xe4, 0xb9, 0x9f, 0xe8, 0xae, 0xb8, 0xe7, 0x8e, 0xaf,
  0xe4, 0xbf, 0x9d, 0xe5, 0x9f, 0xb9, 0xe5, 0x85, 0xbb, 0xe6, 0xa6, 0x82, 0xe5,
  0xbf, 0xb5, 0xe5, 0xa4, 0xa7, 0xe5, 0x9e, 0x8b, 0xe6, 0x9c, 0xba, 0xe7, 0xa5,
  0xa8, 0xe7, 0x90, 0x86, 0xe8, 0xa7, 0xa3, 0xe5, 0x8c, 0xbf, 0xe5, 0x90, 0x8d,
  0x63, 0x75, 0x61, 0x6e, 0x64, 0x6f, 0x65, 0x6e, 0x76, 0x69, 0x61, 0x72, 0x6d,
  0x61, 0x64, 0x72, 0x69, 0x64, 0x62, 0x75, 0x73, 0x63, 0x61, 0x72, 0x69, 0x6e,
  0x69, 0x63, 0x69, 0x6f, 0x74, 0x69, 0x65, 0x6d, 0x70, 0x6f, 0x70, 0x6f, 0x72,
  0x71, 0x75, 0x65, 0x63, 0x75, 0x65, 0x6e, 0x74, 0x61, 0x65, 0x73, 0x74, 0x61,
  0x64, 0x6f, 0x70, 0x75, 0x65, 0x64, 0x65, 0x6e, 0x6a, 0x75, 0x65, 0x67, 0x6f,
  0x73, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x65, 0x73, 0x74, 0xc3, 0xa1, 0x6e,
  0x6e, 0x6f, 0x6d, 0x62, 0x72, 0x65, 0x74, 0x69, 0x65, 0x6e, 0x65, 0x6e, 0x70,
  0x65, 0x72, 0x66, 0x69, 0x6c, 0x6d, 0x61, 0x6e, 0x65, 0x72, 0x61, 0x61, 0x6d,
  0x69, 0x67, 0x6f, 0x73, 0x63, 0x69, 0x75, 0x64, 0x61, 0x64, 0x63, 0x65, 0x6e,
  0x74, 0x72, 0x6f, 0x61, 0x75, 0x6e, 0x71, 0x75, 0x65, 0x70, 0x75, 0x65, 0x64,
  0x65, 0x73, 0x64, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70, 0x72, 0x69, 0x6d, 0x65,
  0x72, 0x70, 0x72, 0x65, 0x63, 0x69, 0x6f, 0x73, 0x65, 0x67, 0xc3, 0xba, 0x6e,
  0x62, 0x75, 0x65, 0x6e, 0x6f, 0x73, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x70,
  0x75, 0x6e, 0x74, 0x6f, 0x73, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x68, 0x61,
  0x62, 0xc3, 0xad, 0x61, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x6e, 0x75, 0x65,
  0x76, 0x6f, 0x73, 0x75, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x63, 0x61, 0x72, 0x6c,
  0x6f, 0x73, 0x65, 0x71, 0x75, 0x69, 0x70, 0x6f, 0x6e, 0x69, 0xc3, 0xb1, 0x6f,
  0x73, 0x6d, 0x75, 0x63, 0x68, 0x6f, 0x73, 0x61, 0x6c, 0x67, 0x75, 0x6e, 0x61,
  0x63, 0x6f, 0x72, 0x72, 0x65, 0x6f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x6e, 0x70,
  0x61, 0x72, 0x74, 0x69, 0x72, 0x61, 0x72, 0x72, 0x69, 0x62, 0x61, 0x6d, 0x61,
  0x72, 0xc3, 0xad, 0x61, 0x68, 0x6f, 0x6d, 0x62, 0x72, 0x65, 0x65, 0x6d, 0x70,
  0x6c, 0x65, 0x6f, 0x76, 0x65, 0x72, 0x64, 0x61, 0x64, 0x63, 0x61, 0x6d, 0x62,
  0x69, 0x6f, 0x6d, 0x75, 0x63, 0x68, 0x61, 0x73, 0x66, 0x75, 0x65, 0x72, 0x6f,
  0x6e, 0x70, 0x61, 0x73, 0x61, 0x64, 0x6f, 0x6c, 0xc3, 0xad, 0x6e, 0x65, 0x61,
  0x70, 0x61, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x75, 0x65, 0x76, 0x61, 0x73, 0x63,
  0x75, 0x72, 0x73, 0x6f, 0x73, 0x65, 0x73, 0x74, 0x61, 0x62, 0x61, 0x71, 0x75,
  0x69, 0x65, 0x72, 0x6f, 0x6c, 0x69, 0x62, 0x72, 0x6f, 0x73, 0x63, 0x75, 0x61,
  0x6e, 0x74, 0x6f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x6f, 0x6d, 0x69, 0x67, 0x75,
  0x65, 0x6c, 0x76, 0x61, 0x72, 0x69, 0x6f, 0x73, 0x63, 0x75, 0x61, 0x74, 0x72,
  0x6f, 0x74, 0x69, 0x65, 0x6e, 0x65, 0x73, 0x67, 0x72, 0x75, 0x70, 0x6f, 0x73,
  0x73, 0x65, 0x72, 0xc3, 0xa1, 0x6e, 0x65, 0x75, 0x72, 0x6f, 0x70, 0x61, 0x6d,
  0x65, 0x64, 0x69, 0x6f, 0x73, 0x66, 0x72, 0x65, 0x6e, 0x74, 0x65, 0x61, 0x63,
  0x65, 0x72, 0x63, 0x61, 0x64, 0x65, 0x6d, 0xc3, 0xa1, 0x73, 0x6f, 0x66, 0x65,
  0x72, 0x74, 0x61, 0x63, 0x6f, 0x63, 0x68, 0x65, 0x73, 0x6d, 0x6f, 0x64, 0x65,
  0x6c, 0x6f, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x6c, 0x65, 0x74, 0x72, 0x61,
  0x73, 0x61, 0x6c, 0x67, 0xc3, 0xba, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x61,
  0x63, 0x75, 0x61, 0x6c, 0x65, 0x73, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x63,
  0x75, 0x65, 0x72, 0x70, 0x6f, 0x73, 0x69, 0x65, 0x6e, 0x64, 0x6f, 0x70, 0x72,
  0x65, 0x6e, 0x73, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x61, 0x72, 0x76, 0x69, 0x61,
  0x6a, 0x65, 0x73, 0x64, 0x69, 0x6e, 0x65, 0x72, 0x6f, 0x6d, 0x75, 0x72, 0x63,
  0x69, 0x61, 0x70, 0x6f, 0x64, 0x72, 0xc3, 0xa1, 0x70, 0x75, 0x65, 0x73, 0x74,
  0x6f, 0x64, 0x69, 0x61, 0x72, 0x69, 0x6f, 0x70, 0x75, 0x65, 0x62, 0x6c, 0x6f,
  0x71, 0x75, 0x69, 0x65, 0x72, 0x65, 0x6d, 0x61, 0x6e, 0x75, 0x65, 0x6c, 0x70,
  0x72, 0x6f, 0x70, 0x69, 0x6f, 0x63, 0x72, 0x69, 0x73, 0x69, 0x73, 0x63, 0x69,
  0x65, 0x72, 0x74, 0x6f, 0x73, 0x65, 0x67, 0x75, 0x72, 0x6f, 0x6d, 0x75, 0x65,
  0x72, 0x74, 0x65, 0x66, 0x75, 0x65, 0x6e, 0x74, 0x65, 0x63, 0x65, 0x72, 0x72,
  0x61, 0x72, 0x67, 0x72, 0x61, 0x6e, 0x64, 0x65, 0x65, 0x66, 0x65, 0x63, 0x74,
  0x6f, 0x70, 0x61, 0x72, 0x74, 0x65, 0x73, 0x6d, 0x65, 0x64, 0x69, 0x64, 0x61,
  0x70, 0x72, 0x6f, 0x70, 0x69, 0x61, 0x6f, 0x66, 0x72, 0x65, 0x63, 0x65, 0x74,
  0x69, 0x65, 0x72, 0x72, 0x61, 0x65, 0x2d, 0x6d, 0x61, 0x69, 0x6c, 0x76, 0x61,
  0x72, 0x69, 0x61, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x73, 0x66, 0x75, 0x74,
  0x75, 0x72, 0x6f, 0x6f, 0x62, 0x6a, 0x65, 0x74, 0x6f, 0x73, 0x65, 0x67, 0x75,
  0x69, 0x72, 0x72, 0x69, 0x65, 0x73, 0x67, 0x6f, 0x6e, 0x6f, 0x72, 0x6d, 0x61,
  0x73, 0x6d, 0x69, 0x73, 0x6d, 0x6f, 0x73, 0xc3, 0xba, 0x6e, 0x69, 0x63, 0x6f,
  0x63, 0x61, 0x6d, 0x69, 0x6e, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x73, 0x72,
  0x61, 0x7a, 0xc3, 0xb3, 0x6e, 0x64, 0x65, 0x62, 0x69, 0x64, 0x6f, 0x70, 0x72,
  0x75, 0x65, 0x62, 0x61, 0x74, 0x6f, 0x6c, 0x65, 0x64, 0x6f, 0x74, 0x65, 0x6e,
  0xc3, 0xad, 0x61, 0x6a, 0x65, 0x73, 0xc3, 0xba, 0x73, 0x65, 0x73, 0x70, 0x65,
  0x72, 0x6f, 0x63, 0x6f, 0x63, 0x69, 0x6e, 0x61, 0x6f, 0x72, 0x69, 0x67, 0x65,
  0x6e, 0x74, 0x69, 0x65, 0x6e, 0x64, 0x61, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x6f,
  0x63, 0xc3, 0xa1, 0x64, 0x69, 0x7a, 0x68, 0x61, 0x62, 0x6c, 0x61, 0x72, 0x73,
  0x65, 0x72, 0xc3, 0xad, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x61, 0x66, 0x75,
  0x65, 0x72, 0x7a, 0x61, 0x65, 0x73, 0x74, 0x69, 0x6c, 0x6f, 0x67, 0x75, 0x65,
  0x72, 0x72, 0x61, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x72, 0xc3, 0xa9, 0x78, 0x69,
  0x74, 0x6f, 0x6c, 0xc3, 0xb3, 0x70, 0x65, 0x7a, 0x61, 0x67, 0x65, 0x6e, 0x64,
  0x61, 0x76, 0xc3, 0xad, 0x64, 0x65, 0x6f, 0x65, 0x76, 0x69, 0x74, 0x61, 0x72,
  0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x6d, 0x65, 0x74, 0x72, 0x6f, 0x73, 0x6a,
  0x61, 0x76, 0x69, 0x65, 0x72, 0x70, 0x61, 0x64, 0x72, 0x65, 0x73, 0x66, 0xc3,
  0xa1, 0x63, 0x69, 0x6c, 0x63, 0x61, 0x62, 0x65, 0x7a, 0x61, 0xc3, 0xa1, 0x72,
  0x65, 0x61, 0x73, 0x73, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x65, 0x6e, 0x76, 0xc3,
  0xad, 0x6f, 0x6a, 0x61, 0x70, 0xc3, 0xb3, 0x6e, 0x61, 0x62, 0x75, 0x73, 0x6f,
  0x73, 0x62, 0x69, 0x65, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x78, 0x74, 0x6f, 0x73,
  0x6c, 0x6c, 0x65, 0x76, 0x61, 0x72, 0x70, 0x75, 0x65, 0x64, 0x61, 0x6e, 0x66,
  0x75, 0x65, 0x72, 0x74, 0x65, 0x63, 0x6f, 0x6d, 0xc3, 0xba, 0x6e, 0x63, 0x6c,
  0x61, 0x73, 0x65, 0x73, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x6f, 0x74, 0x65, 0x6e,
  0x69, 0x64, 0x6f, 0x62, 0x69, 0x6c, 0x62, 0x61, 0x6f, 0x75, 0x6e, 0x69, 0x64,
  0x61, 0x64, 0x65, 0x73, 0x74, 0xc3, 0xa1, 0x73, 0x65, 0x64, 0x69, 0x74, 0x61,
  0x72, 0x63, 0x72, 0x65, 0x61, 0x64, 0x6f, 0xd0, 0xb4, 0xd0, 0xbb, 0xd1, 0x8f,
  0xd1, 0x87, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xba, 0xd0,
  0xb8, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb2,
  0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xbf, 0xd1,
  0x80, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xb5, 0xd1, 0x89,
  0xd0, 0xb5, 0xd1, 0x83, 0xd0, 0xb6, 0xd0, 0xb5, 0xd0, 0x9a, 0xd0, 0xb0, 0xd0,
  0xba, 0xd0, 0xb1, 0xd0, 0xb5, 0xd0, 0xb7, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xbb,
  0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0x92, 0xd1, 0x81, 0xd0, 0xb5, 0xd0,
  0xbf, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xad, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x82,
  0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xbd, 0xd0,
  0xb5, 0xd1, 0x82, 0xd0, 0xbb, 0xd0, 0xb5, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0,
  0xd0, 0xb7, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0,
  0xb5, 0xd0, 0xbc, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0x94, 0xd0, 0xbb, 0xd1, 0x8f,
  0xd0, 0x9f, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x81, 0xd0,
  0xbd, 0xd0, 0xb8, 0xd1, 0x85, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xba,
  0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb2, 0xd0,
  0xbe, 0xd1, 0x82, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xa1, 0xd0, 0xa8,
  0xd0, 0x90, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x8f, 0xd0, 0xa7, 0xd1, 0x82, 0xd0,
  0xbe, 0xd0, 0xb2, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xb0, 0xd0, 0xbc,
  0xd0, 0xb5, 0xd0, 0xbc, 0xd1, 0x83, 0xd0, 0xa2, 0xd0, 0xb0, 0xd0, 0xba, 0xd0,
  0xb4, 0xd0, 0xb2, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xbc, 0xd1, 0x8d,
  0xd1, 0x82, 0xd0, 0xb8, 0xd1, 0x8d, 0xd1, 0x82, 0xd1, 0x83, 0xd0, 0x92, 0xd0,
  0xb0, 0xd0, 0xbc, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80,
  0xd0, 0xbe, 0xd1, 0x82, 0xd1, 0x83, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0,
  0xb4, 0xd0, 0xb4, 0xd0, 0xbd, 0xd1, 0x8f, 0xd0, 0x92, 0xd0, 0xbe, 0xd1, 0x82,
  0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb9, 0xd0,
  0x92, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd1, 0x81,
  0xd0, 0xb0, 0xd0, 0xbc, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x82, 0xd1, 0x80, 0xd1,
  0x83, 0xd0, 0xb1, 0xd0, 0x9e, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb8,
  0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0x9e, 0xd0, 0x9e, 0xd0,
  0x9e, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x86, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xb0,
  0xd0, 0x9e, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xb4, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0, 0xb4,
  0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xbe, 0xd1, 0x81, 0xd1,
  0x83, 0xd0, 0xb4, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb9, 0xe0,
  0xa5, 0x88, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0x94, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xad, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x87,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0,
  0xa5, 0x8b, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x86, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb9,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xa5, 0xe0, 0xa4, 0xbe, 0x6a, 0x61, 0x67, 0x72, 0x61, 0x6e, 0xe0, 0xa4,
  0x86, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x85,
  0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0,
  0xa4, 0x88, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4,
  0x8f, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xa5, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa5, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0x98, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0x9c, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0x88, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0x95, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x93, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0x86, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa5, 0x80, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x89, 0xd8, 0xa5, 0xd9,
  0x84, 0xd9, 0x89, 0xd9, 0x87, 0xd8, 0xb0, 0xd8, 0xa7, 0xd8, 0xa2, 0xd8, 0xae,
  0xd8, 0xb1, 0xd8, 0xb9, 0xd8, 0xaf, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x89, 0xd9, 0x87, 0xd8, 0xb0, 0xd9, 0x87, 0xd8, 0xb5, 0xd9, 0x88, 0xd8, 0xb1,
  0xd8, 0xba, 0xd9, 0x8a, 0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x86, 0xd9,
  0x88, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xa8, 0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xb9,
  0xd8, 0xb1, 0xd8, 0xb6, 0xd8, 0xb0, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x87, 0xd9,
  0x86, 0xd8, 0xa7, 0xd9, 0x8a, 0xd9, 0x88, 0xd9, 0x85, 0xd9, 0x82, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x86, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x86, 0xd8, 0xad, 0xd8, 0xaa, 0xd9, 0x89,
  0xd9, 0x82, 0xd8, 0xa8, 0xd9, 0x84, 0xd9, 0x88, 0xd8, 0xad, 0xd8, 0xa9, 0xd8,
  0xa7, 0xd8, 0xae, 0xd8, 0xb1, 0xd9, 0x81, 0xd9, 0x82, 0xd8, 0xb7, 0xd8, 0xb9,
  0xd8, 0xa8, 0xd8, 0xaf, 0xd8, 0xb1, 0xd9, 0x83, 0xd9, 0x86, 0xd8, 0xa5, 0xd8,
  0xb0, 0xd8, 0xa7, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xa7, 0xd8, 0xad,
  0xd8, 0xaf, 0xd8, 0xa5, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x81, 0xd9, 0x8a, 0xd9,
  0x87, 0xd8, 0xa8, 0xd8, 0xb9, 0xd8, 0xb6, 0xd9, 0x83, 0xd9, 0x8a, 0xd9, 0x81,
  0xd8, 0xa8, 0xd8, 0xad, 0xd8, 0xab, 0xd9, 0x88, 0xd9, 0x85, 0xd9, 0x86, 0xd9,
  0x88, 0xd9, 0x87, 0xd9, 0x88, 0xd8, 0xa3, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xac,
  0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xb3, 0xd9,
  0x84, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 0x86, 0xd8, 0xaf, 0xd9, 0x84, 0xd9, 0x8a,
  0xd8, 0xb3, 0xd8, 0xb9, 0xd8, 0xa8, 0xd8, 0xb1, 0xd8, 0xb5, 0xd9, 0x84, 0xd9,
  0x89, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xb0, 0xd8, 0xa8, 0xd9, 0x87, 0xd8, 0xa7,
  0xd8, 0xa3, 0xd9, 0x86, 0xd9, 0x87, 0xd9, 0x85, 0xd8, 0xab, 0xd9, 0x84, 0xd9,
  0x83, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xad,
  0xd9, 0x8a, 0xd8, 0xab, 0xd9, 0x85, 0xd8, 0xb5, 0xd8, 0xb1, 0xd8, 0xb4, 0xd8,
  0xb1, 0xd8, 0xad, 0xd8, 0xad, 0xd9, 0x88, 0xd9, 0x84, 0xd9, 0x88, 0xd9, 0x81,
  0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xb0, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd9,
  0x84, 0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x86, 0xd8, 0xaa,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x81, 0xd8, 0xa3, 0xd8, 0xa8, 0xd9, 0x88, 0xd8,
  0xae, 0xd8, 0xa7, 0xd8, 0xb5, 0xd8, 0xa3, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7,
  0xd9, 0x86, 0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x8a, 0xd8, 0xb9, 0xd8,
  0xb6, 0xd9, 0x88, 0xd9, 0x88, 0xd9, 0x82, 0xd8, 0xaf, 0xd8, 0xa7, 0xd8, 0xa8,
  0xd9, 0x86, 0xd8, 0xae, 0xd9, 0x8a, 0xd8, 0xb1, 0xd8, 0xa8, 0xd9, 0x86, 0xd8,
  0xaa, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8, 0xa1,
  0xd9, 0x88, 0xd9, 0x87, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xa8, 0xd9, 0x88, 0xd9,
  0x82, 0xd8, 0xb5, 0xd8, 0xb5, 0xd9, 0x88, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xb1,
  0xd9, 0x82, 0xd9, 0x85, 0xd8, 0xa3, 0xd8, 0xad, 0xd8, 0xaf, 0xd9, 0x86, 0xd8,
  0xad, 0xd9, 0x86, 0xd8, 0xb9, 0xd8, 0xaf, 0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xa3,
  0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xad, 0xd8, 0xa9, 0xd9, 0x83, 0xd8, 0xaa, 0xd8,
  0xa8, 0xd8, 0xaf, 0xd9, 0x88, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xac, 0xd8, 0xa8,
  0xd9, 0x85, 0xd9, 0x86, 0xd9, 0x87, 0xd8, 0xaa, 0xd8, 0xad, 0xd8, 0xaa, 0xd8,
  0xac, 0xd9, 0x87, 0xd8, 0xa9, 0xd8, 0xb3, 0xd9, 0x86, 0xd8, 0xa9, 0xd9, 0x8a,
  0xd8, 0xaa, 0xd9, 0x85, 0xd9, 0x83, 0xd8, 0xb1, 0xd8, 0xa9, 0xd8, 0xba, 0xd8,
  0xb2, 0xd8, 0xa9, 0xd9, 0x86, 0xd9, 0x81, 0xd8, 0xb3, 0xd8, 0xa8, 0xd9, 0x8a,
  0xd8, 0xaa, 0xd9, 0x84, 0xd9, 0x84, 0xd9, 0x87, 0xd9, 0x84, 0xd9, 0x86, 0xd8,
  0xa7, 0xd8, 0xaa, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x82, 0xd9, 0x84, 0xd8, 0xa8,
  0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xb9, 0xd9, 0x86, 0xd9, 0x87, 0xd8,
  0xa3, 0xd9, 0x88, 0xd9, 0x84, 0xd8, 0xb4, 0xd9, 0x8a, 0xd8, 0xa1, 0xd9, 0x86,
  0xd9, 0x88, 0xd8, 0xb1, 0xd8, 0xa3, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x81, 0xd9,
  0x8a, 0xd9, 0x83, 0xd8, 0xa8, 0xd9, 0x83, 0xd9, 0x84, 0xd8, 0xb0, 0xd8, 0xa7,
  0xd8, 0xaa, 0xd8, 0xb1, 0xd8, 0xaa, 0xd8, 0xa8, 0xd8, 0xa8, 0xd8, 0xa3, 0xd9,
  0x86, 0xd9, 0x87, 0xd9, 0x85, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 0x83,
  0xd8, 0xa8, 0xd9, 0x8a, 0xd8, 0xb9, 0xd9, 0x81, 0xd9, 0x82, 0xd8, 0xaf, 0xd8,
  0xad, 0xd8, 0xb3, 0xd9, 0x86, 0xd9, 0x84, 0xd9, 0x87, 0xd9, 0x85, 0xd8, 0xb4,
  0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa3, 0xd9, 0x87, 0xd9, 0x84, 0xd8, 0xb4, 0xd9,
  0x87, 0xd8, 0xb1, 0xd9, 0x82, 0xd8, 0xb7, 0xd8, 0xb1, 0xd8, 0xb7, 0xd9, 0x84,
  0xd8, 0xa8, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x72, 0x76,
  0x69, 0x63, 0x65, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x68, 0x69, 0x6d,
  0x73, 0x65, 0x6c, 0x66, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x63, 0x6f,
  0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73,
  0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
  0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x61, 0x73, 0x68, 0x69, 0x6f,
  0x6e, 0x3c, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x63, 0x6f, 0x75, 0x6e, 0x74,
  0x72, 0x79, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x63, 0x72, 0x65, 0x61,
  0x74, 0x65, 0x64, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x72, 0x65, 0x73,
  0x75, 0x6c, 0x74, 0x73, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x70, 0x72,
  0x6f, 0x63, 0x65, 0x73, 0x73, 0x77, 0x72, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x6f,
  0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65,
  0x77, 0x65, 0x6c, 0x63, 0x6f, 0x6d, 0x65, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c,
  0x65, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
  0x72, 0x6b, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x64, 0x79, 0x6e, 0x61,
  0x6d, 0x69, 0x63, 0x62, 0x72, 0x6f, 0x77, 0x73, 0x65, 0x72, 0x70, 0x72, 0x69,
  0x76, 0x61, 0x63, 0x79, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x53, 0x65,
  0x72, 0x76, 0x69, 0x63, 0x65, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x64,
  0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
  0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74,
  0x65, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x66, 0x72, 0x69, 0x65, 0x6e,
  0x64, 0x73, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x77, 0x6f, 0x72, 0x6b,
  0x69, 0x6e, 0x67, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x6d, 0x69, 0x6c,
  0x6c, 0x69, 0x6f, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x77, 0x69,
  0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76,
  0x69, 0x73, 0x69, 0x74, 0x65, 0x64, 0x77, 0x65, 0x61, 0x74, 0x68, 0x65, 0x72,
  0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
  0x74, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x66, 0x6f, 0x72, 0x77, 0x61,
  0x72, 0x64, 0x79, 0x6f, 0x75, 0x20, 0x63, 0x61, 0x6e, 0x72, 0x65, 0x6d, 0x6f,
  0x76, 0x65, 0x64, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x63, 0x6f, 0x6e,
  0x74, 0x72, 0x6f, 0x6c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x63, 0x75,
  0x72, 0x72, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x6c,
  0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64,
  0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x66, 0x75, 0x72, 0x74, 0x68, 0x65,
  0x72, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x6d, 0x61, 0x63, 0x68, 0x69,
  0x6e, 0x65, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x70, 0x72, 0x69, 0x76,
  0x61, 0x74, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x70, 0x72, 0x6f,
  0x67, 0x72, 0x61, 0x6d, 0x73, 0x6f, 0x63, 0x69, 0x65, 0x74, 0x79, 0x6e, 0x75,
  0x6d, 0x62, 0x65, 0x72, 0x73, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x65,
  0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
  0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e,
  0x67, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x61, 0x72, 0x74, 0x6e,
  0x65, 0x72, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x70, 0x65, 0x72, 0x66,
  0x65, 0x63, 0x74, 0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x79, 0x73,
  0x74, 0x65, 0x6d, 0x73, 0x6b, 0x65, 0x65, 0x70, 0x69, 0x6e, 0x67, 0x63, 0x75,
  0x6c, 0x74, 0x75, 0x72, 0x65, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x2c, 0x6a,
  0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
  0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x26, 0x71, 0x75, 0x6f, 0x74,
  0x3b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x72, 0x65, 0x76, 0x69, 0x65,
  0x77, 0x73, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x67, 0x6c,
  0x69, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x74, 0x68, 0x72,
  0x6f, 0x75, 0x67, 0x68, 0x50, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x70,
  0x69, 0x6e, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x61,
  0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
  0x76, 0x69, 0x6c, 0x6c, 0x61, 0x67, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x69, 0x73,
  0x68, 0x67, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x79, 0x64, 0x65, 0x63, 0x6c, 0x69,
  0x6e, 0x65, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x6d, 0x69, 0x73, 0x73,
  0x69, 0x6f, 0x6e, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x71, 0x75, 0x61,
  0x6c, 0x69, 0x74, 0x79, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x67, 0x65,
  0x6e, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x70, 0x65, 0x63, 0x69, 0x65, 0x73, 0x73,
  0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65,
  0x72, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x72, 0x65, 0x70, 0x6f, 0x72,
  0x74, 0x73, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x73, 0x6d, 0x65, 0x6d, 0x62,
  0x65, 0x72, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x73,
  0x70, 0x75, 0x74, 0x65, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x72, 0x65, 0x78,
  0x70, 0x72, 0x65, 0x73, 0x73, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x70,
  0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72,
  0x6d, 0x61, 0x72, 0x72, 0x69, 0x65, 0x64, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69,
  0x63, 0x6c, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x63, 0x68, 0x61, 0x6e, 0x67,
  0x65, 0x64, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x76, 0x69, 0x63, 0x74,
  0x6f, 0x72, 0x79, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x72, 0x65, 0x61,
  0x73, 0x6f, 0x6e, 0x73, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x66, 0x65,
  0x61, 0x74, 0x75, 0x72, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x6d,
  0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x73, 0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x73,
  0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c,
  0x79, 0x65, 0x70, 0x69, 0x73, 0x6f, 0x64, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x69,
  0x6e, 0x67, 0x67, 0x72, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x6f, 0x62, 0x76, 0x69,
  0x6f, 0x75, 0x73, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x70, 0x72, 0x65,
  0x73, 0x65, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x2f,
  0x75, 0x6c, 0x3e, 0x0d, 0x0a, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x61,
  0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x63, 0x65, 0x72, 0x74, 0x61, 0x69, 0x6e,
  0x72, 0x65, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
  0x65, 0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x64, 0x65, 0x73, 0x6b, 0x74,
  0x6f, 0x70, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x65, 0x64, 0x70, 0x61, 0x74, 0x74,
  0x65, 0x72, 0x6e, 0x75, 0x6e, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x44, 0x69, 0x67,
  0x69, 0x74, 0x61, 0x6c, 0x63, 0x61, 0x70, 0x69, 0x74, 0x61, 0x6c, 0x57, 0x65,
  0x62, 0x73, 0x69, 0x74, 0x65, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x63,
  0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x64,
  0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x64, 0x65, 0x63, 0x61, 0x64, 0x65,
  0x73, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x26, 0x61, 0x6d, 0x70,
  0x3b, 0x20, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x73, 0x72, 0x65, 0x6c, 0x65,
  0x61, 0x73, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x67, 0x65, 0x74,
  0x74, 0x69, 0x6e, 0x67, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x6e, 0x6f,
  0x74, 0x68, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x63,
  0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x73,
  0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63,
  0x65, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x67,
  0x65, 0x73, 0x45, 0x6e, 0x67, 0x6c, 0x61, 0x6e, 0x64, 0x3d, 0x31, 0x26, 0x61,
  0x6d, 0x70, 0x3b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x3d, 0x20,
  0x6e, 0x65, 0x77, 0x20, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x75, 0x70,
  0x64, 0x61, 0x74, 0x65, 0x64, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x4e,
  0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
  0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
  0x67, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x67, 0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x62,
  0x61, 0x72, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x62, 0x65, 0x63, 0x61,
  0x75, 0x73, 0x65, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65, 0x75,
  0x74, 0x73, 0x63, 0x68, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x77, 0x6f,
  0x72, 0x6b, 0x65, 0x72, 0x73, 0x71, 0x75, 0x69, 0x63, 0x6b, 0x6c, 0x79, 0x62,
  0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x65, 0x78, 0x61, 0x63, 0x74, 0x6c, 0x79,
  0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x73, 0x65, 0x61, 0x73,
  0x65, 0x53, 0x6f, 0x63, 0x69, 0x65, 0x74, 0x79, 0x77, 0x65, 0x61, 0x70, 0x6f,
  0x6e, 0x73, 0x65, 0x78, 0x68, 0x69, 0x62, 0x69, 0x74, 0x26, 0x6c, 0x74, 0x3b,
  0x21, 0x2d, 0x2d, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x65, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x6f, 0x75,
  0x74, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x64,
  0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x28, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
  0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d,
  0x22, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x20, 0x6b, 0x69, 0x6c, 0x6c, 0x69,
  0x6e, 0x67, 0x73, 0x68, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x49, 0x74, 0x61, 0x6c,
  0x69, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x68, 0x65, 0x61,
  0x76, 0x69, 0x6c, 0x79, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x73, 0x2d, 0x31,
  0x27, 0x5d, 0x29, 0x3b, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x43,
  0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
  0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6e,
  0x67, 0x64, 0x72, 0x61, 0x77, 0x69, 0x6e, 0x67, 0x62, 0x69, 0x6c, 0x6c, 0x69,
  0x6f, 0x6e, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x47, 0x65, 0x72, 0x6d,
  0x61, 0x6e, 0x79, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x3c, 0x2f, 0x66,
  0x6f, 0x72, 0x6d, 0x3e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x77, 0x68,
  0x65, 0x74, 0x68, 0x65, 0x72, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x53,
  0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
  0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e,
  0x73, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x73, 0x74, 0x75, 0x6e, 0x69, 0x66, 0x6f,
  0x72, 0x6d, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79, 0x73, 0x69, 0x64, 0x65,
  0x62, 0x61, 0x72, 0x43, 0x68, 0x69, 0x63, 0x61, 0x67, 0x6f, 0x68, 0x6f, 0x6c,
  0x69, 0x64, 0x61, 0x79, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x70, 0x61,
  0x73, 0x73, 0x61, 0x67, 0x65, 0x2c, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x61,
  0x6e, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x66, 0x65, 0x65, 0x6c, 0x69, 0x6e, 0x67,
  0x61, 0x72, 0x72, 0x69, 0x76, 0x65, 0x64, 0x70, 0x61, 0x73, 0x73, 0x69, 0x6e,
  0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x72, 0x6f, 0x75, 0x67, 0x68,
  0x6c, 0x79, 0x2e, 0x0a, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x62, 0x75, 0x74, 0x20,
  0x6e, 0x6f, 0x74, 0x64, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x79, 0x42, 0x72, 0x69,
  0x74, 0x61, 0x69, 0x6e, 0x43, 0x68, 0x69, 0x6e, 0x65, 0x73, 0x65, 0x6c, 0x61,
  0x63, 0x6b, 0x20, 0x6f, 0x66, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x49,
  0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x22, 0x20, 0x64, 0x61, 0x74, 0x61, 0x2d,
  0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76,
  0x65, 0x74, 0x68, 0x61, 0x74, 0x20, 0x69, 0x73, 0x4c, 0x69, 0x62, 0x72, 0x61,
  0x72, 0x79, 0x68, 0x75, 0x73, 0x62, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x20, 0x66,
  0x61, 0x63, 0x74, 0x61, 0x66, 0x66, 0x61, 0x69, 0x72, 0x73, 0x43, 0x68, 0x61,
  0x72, 0x6c, 0x65, 0x73, 0x72, 0x61, 0x64, 0x69, 0x63, 0x61, 0x6c, 0x62, 0x72,
  0x6f, 0x75, 0x67, 0x68, 0x74, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x6c,
  0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22,
  0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72,
  0x73, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x70, 0x72, 0x65, 0x6d, 0x69,
  0x75, 0x6d, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x41, 0x6d, 0x65, 0x72,
  0x69, 0x63, 0x61, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5d, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x6e, 0x65,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x6c, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67,
  0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76,
  0x65, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x2d, 0x6d, 0x6f, 0x62, 0x69,
  0x6c, 0x65, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x77, 0x61, 0x6e, 0x74,
  0x20, 0x74, 0x6f, 0x6b, 0x69, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x46, 0x69, 0x72,
  0x65, 0x66, 0x6f, 0x78, 0x79, 0x6f, 0x75, 0x20, 0x61, 0x72, 0x65, 0x73, 0x69,
  0x6d, 0x69, 0x6c, 0x61, 0x72, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x64, 0x6d,
  0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67,
  0x72, 0x61, 0x70, 0x69, 0x64, 0x6c, 0x79, 0x63, 0x6c, 0x69, 0x6d, 0x61, 0x74,
  0x65, 0x6b, 0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x65, 0x6d, 0x65, 0x72, 0x67,
  0x65, 0x64, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x66, 0x6f, 0x75, 0x6e,
  0x64, 0x65, 0x64, 0x70, 0x69, 0x6f, 0x6e, 0x65, 0x65, 0x72, 0x66, 0x6f, 0x72,
  0x6d, 0x75, 0x6c, 0x61, 0x64, 0x79, 0x6e, 0x61, 0x73, 0x74, 0x79, 0x68, 0x6f,
  0x77, 0x20, 0x74, 0x6f, 0x20, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x72,
  0x65, 0x76, 0x65, 0x6e, 0x75, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x79,
  0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x62, 0x72, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x73, 0x6f, 0x6c, 0x64, 0x69, 0x65, 0x72, 0x6c, 0x61, 0x72, 0x67, 0x65,
  0x6c, 0x79, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x26, 0x71, 0x75,
  0x6f, 0x74, 0x3b, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x64, 0x77,
  0x61, 0x72, 0x64, 0x20, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f,
  0x62, 0x65, 0x72, 0x74, 0x20, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x73, 0x50,
  0x61, 0x63, 0x69, 0x66, 0x69, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x65, 0x64,
  0x75, 0x70, 0x20, 0x77, 0x69, 0x74, 0x68, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x3a, 0x77, 0x65, 0x20, 0x68, 0x61, 0x76, 0x65, 0x41, 0x6e, 0x67, 0x65, 0x6c,
  0x65, 0x73, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x65, 0x61,
  0x72, 0x63, 0x68, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x61, 0x63, 0x71,
  0x75, 0x69, 0x72, 0x65, 0x6d, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x67, 0x72,
  0x61, 0x6e, 0x74, 0x65, 0x64, 0x3a, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x74,
  0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x62, 0x69, 0x67, 0x67, 0x65, 0x73, 0x74,
  0x62, 0x65, 0x6e, 0x65, 0x66, 0x69, 0x74, 0x64, 0x72, 0x69, 0x76, 0x69, 0x6e,
  0x67, 0x53, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x6d, 0x69, 0x6e, 0x69, 0x6d,
  0x75, 0x6d, 0x70, 0x65, 0x72, 0x68, 0x61, 0x70, 0x73, 0x6d, 0x6f, 0x72, 0x6e,
  0x69, 0x6e, 0x67, 0x73, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x73, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x76, 0x61,
  0x72, 0x69, 0x61, 0x6e, 0x74, 0x20, 0x72, 0x6f, 0x6c, 0x65, 0x3d, 0x22, 0x6d,
  0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x61, 0x63, 0x68, 0x69, 0x65, 0x76, 0x65,
  0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e,
  0x74, 0x73, 0x6f, 0x6d, 0x65, 0x6f, 0x6e, 0x65, 0x65, 0x78, 0x74, 0x72, 0x65,
  0x6d, 0x65, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x62, 0x6f, 0x74, 0x74,
  0x6f, 0x6d, 0x3a, 0x65, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x61, 0x6c, 0x6c,
  0x20, 0x74, 0x68, 0x65, 0x73, 0x69, 0x74, 0x65, 0x6d, 0x61, 0x70, 0x65, 0x6e,
  0x67, 0x6c, 0x69, 0x73, 0x68, 0x77, 0x61, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x20,
  0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73,
  0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72,
  0x73, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x69, 0x6e,
  0x73, 0x74, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x7d, 0x29, 0x28, 0x29,
  0x3b, 0x0d, 0x0a, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x74, 0x72, 0x6f,
  0x75, 0x62, 0x6c, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x63, 0x6f,
  0x6d, 0x70, 0x61, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x70,
  0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73,
  0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x20, 0x27, 0x27, 0x54, 0x68, 0x65,
  0x20, 0x77, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x65, 0x78, 0x70, 0x6c, 0x6f,
  0x72, 0x65, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x64, 0x47, 0x61, 0x6c, 0x6c,
  0x65, 0x72, 0x79, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x61, 0x62, 0x69,
  0x6c, 0x69, 0x74, 0x79, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x63, 0x61,
  0x72, 0x65, 0x65, 0x72, 0x73, 0x29, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x63,
  0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x20,
  0x61, 0x6e, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65,
  0x64, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x20, 0x68, 0x61, 0x6e, 0x64, 0x6c,
  0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x63, 0x6f, 0x6e, 0x73,
  0x6f, 0x6c, 0x65, 0x45, 0x61, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x78, 0x70,
  0x6f, 0x72, 0x74, 0x73, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x68,
  0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x69, 0x6c, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x6e,
  0x65, 0x75, 0x74, 0x72, 0x61, 0x6c, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
  0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e,
  0x67, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x3e, 0x73, 0x65, 0x74, 0x74, 0x6c,
  0x65, 0x64, 0x77, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x63, 0x61, 0x75, 0x73,
  0x69, 0x6e, 0x67, 0x2d, 0x77, 0x65, 0x62, 0x6b, 0x69, 0x74, 0x63, 0x6c, 0x61,
  0x69, 0x6d, 0x65, 0x64, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x63, 0x65, 0x63, 0x68,
  0x61, 0x70, 0x74, 0x65, 0x72, 0x76, 0x69, 0x63, 0x74, 0x69, 0x6d, 0x73, 0x54,
  0x68, 0x6f, 0x6d, 0x61, 0x73, 0x20, 0x6d, 0x6f, 0x7a, 0x69, 0x6c, 0x6c, 0x61,
  0x70, 0x72, 0x6f, 0x6d, 0x69, 0x73, 0x65, 0x70, 0x61, 0x72, 0x74, 0x69, 0x65,
  0x73, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x75, 0x74, 0x73, 0x69,
  0x64, 0x65, 0x3a, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x2c, 0x68, 0x75, 0x6e, 0x64,
  0x72, 0x65, 0x64, 0x4f, 0x6c, 0x79, 0x6d, 0x70, 0x69, 0x63, 0x5f, 0x62, 0x75,
  0x74, 0x74, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x73, 0x72, 0x65,
  0x61, 0x63, 0x68, 0x65, 0x64, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x69, 0x63, 0x64,
  0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
  0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x61, 0x64, 0x6f, 0x70, 0x74, 0x65,
  0x64, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x65, 0x69, 0x74, 0x68,
  0x65, 0x72, 0x67, 0x72, 0x65, 0x61, 0x74, 0x6c, 0x79, 0x67, 0x72, 0x65, 0x61,
  0x74, 0x65, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x69, 0x6d, 0x70,
  0x72, 0x6f, 0x76, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x70,
  0x65, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x77,
  0x6f, 0x72, 0x73, 0x68, 0x69, 0x70, 0x66, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
  0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73,
  0x74, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61, 0x64, 0x75, 0x74, 0x69, 0x6c, 0x69,
  0x74, 0x79, 0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72, 0x43, 0x75, 0x6c, 0x74,
  0x75, 0x72, 0x65, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x63, 0x6c, 0x65,
  0x61, 0x72, 0x6c, 0x79, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x42, 0x72,
  0x6f, 0x77, 0x73, 0x65, 0x72, 0x6c, 0x69, 0x62, 0x65, 0x72, 0x61, 0x6c, 0x7d,
  0x20, 0x63, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
  0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x68, 0x69, 0x64, 0x65, 0x28, 0x29,
  0x3b, 0x46, 0x6c, 0x6f, 0x72, 0x69, 0x64, 0x61, 0x61, 0x6e, 0x73, 0x77, 0x65,
  0x72, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x45, 0x6d, 0x70, 0x65,
  0x72, 0x6f, 0x72, 0x64, 0x65, 0x66, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x65, 0x72,
  0x69, 0x6f, 0x75, 0x73, 0x66, 0x72, 0x65, 0x65, 0x64, 0x6f, 0x6d, 0x53, 0x65,
  0x76, 0x65, 0x72, 0x61, 0x6c, 0x2d, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x46,
  0x75, 0x72, 0x74, 0x68, 0x65, 0x72, 0x6f, 0x75, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x21, 0x3d, 0x20, 0x6e, 0x75, 0x6c, 0x6c, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x65,
  0x64, 0x44, 0x65, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x76, 0x6f, 0x69, 0x64, 0x28,
  0x30, 0x29, 0x2f, 0x61, 0x6c, 0x6c, 0x2e, 0x6a, 0x73, 0x70, 0x72, 0x65, 0x76,
  0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x65,
  0x70, 0x68, 0x65, 0x6e, 0x0a, 0x0a, 0x57, 0x68, 0x65, 0x6e, 0x20, 0x6f, 0x62,
  0x73, 0x65, 0x72, 0x76, 0x65, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x4d,
  0x6f, 0x64, 0x65, 0x72, 0x6e, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
  0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x73, 0x2e, 0x0a, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x0a, 0x0a, 0x4d, 0x61, 0x6e,
  0x79, 0x20, 0x61, 0x72, 0x74, 0x69, 0x73, 0x74, 0x73, 0x70, 0x6f, 0x77, 0x65,
  0x72, 0x65, 0x64, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x66, 0x69, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x74, 0x79, 0x70, 0x65, 0x20, 0x6f, 0x66, 0x6d, 0x65,
  0x64, 0x69, 0x63, 0x61, 0x6c, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x6f,
  0x70, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x63, 0x69, 0x6c,
  0x77, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x63,
  0x65, 0x47, 0x65, 0x6f, 0x72, 0x67, 0x65, 0x20, 0x42, 0x65, 0x6c, 0x67, 0x69,
  0x75, 0x6d, 0x2e, 0x2e, 0x2e, 0x3c, 0x2f, 0x61, 0x3e, 0x74, 0x77, 0x69, 0x74,
  0x74, 0x65, 0x72, 0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x79, 0x77, 0x61, 0x69,
  0x74, 0x69, 0x6e, 0x67, 0x77, 0x61, 0x72, 0x66, 0x61, 0x72, 0x65, 0x20, 0x4f,
  0x74, 0x68, 0x65, 0x72, 0x20, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x70,
  0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x75, 0x72, 0x76, 0x69, 0x76, 0x65, 0x73, 0x63, 0x68, 0x6f, 0x6c, 0x61,
  0x72, 0x3c, 0x2f, 0x70, 0x3e, 0x0d, 0x0a, 0x20, 0x43, 0x6f, 0x75, 0x6e, 0x74,
  0x72, 0x79, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64, 0x6c, 0x6f, 0x73, 0x73,
  0x20, 0x6f, 0x66, 0x6a, 0x75, 0x73, 0x74, 0x20, 0x61, 0x73, 0x47, 0x65, 0x6f,
  0x72, 0x67, 0x69, 0x61, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x3c, 0x68,
  0x65, 0x61, 0x64, 0x3e, 0x3c, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x31,
  0x27, 0x5d, 0x29, 0x3b, 0x0d, 0x0a, 0x69, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
  0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x3a, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x63, 0x61, 0x72, 0x72, 0x69,
  0x65, 0x64, 0x31, 0x30, 0x30, 0x2c, 0x30, 0x30, 0x30, 0x3c, 0x2f, 0x68, 0x33,
  0x3e, 0x0a, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x62, 0x65, 0x63,
  0x6f, 0x6d, 0x65, 0x73, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x20, 0x77, 0x65,
  0x64, 0x64, 0x69, 0x6e, 0x67, 0x30, 0x30, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x6d,
  0x6f, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x6f, 0x66, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x74, 0x65, 0x61, 0x63, 0x68, 0x65, 0x72, 0x68, 0x69, 0x67, 0x68, 0x6c, 0x79,
  0x20, 0x62, 0x69, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x6c, 0x69, 0x66, 0x65, 0x20,
  0x6f, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x72, 0x69, 0x73, 0x65,
  0x20, 0x6f, 0x66, 0x26, 0x72, 0x61, 0x71, 0x75, 0x6f, 0x3b, 0x70, 0x6c, 0x75,
  0x73, 0x6f, 0x6e, 0x65, 0x68, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x28, 0x74,
  0x68, 0x6f, 0x75, 0x67, 0x68, 0x44, 0x6f, 0x75, 0x67, 0x6c, 0x61, 0x73, 0x6a,
  0x6f, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x73,
  0x46, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x41, 0x6e, 0x63, 0x69, 0x65, 0x6e,
  0x74, 0x56, 0x69, 0x65, 0x74, 0x6e, 0x61, 0x6d, 0x76, 0x65, 0x68, 0x69, 0x63,
  0x6c, 0x65, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x63, 0x72, 0x79, 0x73,
  0x74, 0x61, 0x6c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x3d, 0x57, 0x69, 0x6e,
  0x64, 0x6f, 0x77, 0x73, 0x65, 0x6e, 0x6a, 0x6f, 0x79, 0x65, 0x64, 0x61, 0x20,
  0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x61, 0x73, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x3c,
  0x61, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x66, 0x6f, 0x72, 0x65, 0x69, 0x67, 0x6e,
  0x20, 0x41, 0x6c, 0x6c, 0x20, 0x72, 0x69, 0x68, 0x6f, 0x77, 0x20, 0x74, 0x68,
  0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x72, 0x65, 0x74, 0x69, 0x72,
  0x65, 0x64, 0x68, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x68, 0x69, 0x64, 0x64,
  0x65, 0x6e, 0x3b, 0x62, 0x61, 0x74, 0x74, 0x6c, 0x65, 0x73, 0x73, 0x65, 0x65,
  0x6b, 0x69, 0x6e, 0x67, 0x63, 0x61, 0x62, 0x69, 0x6e, 0x65, 0x74, 0x77, 0x61,
  0x73, 0x20, 0x6e, 0x6f, 0x74, 0x6c, 0x6f, 0x6f, 0x6b, 0x20, 0x61, 0x74, 0x63,
  0x6f, 0x6e, 0x64, 0x75, 0x63, 0x74, 0x67, 0x65, 0x74, 0x20, 0x74, 0x68, 0x65,
  0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x68, 0x61, 0x70, 0x70, 0x65, 0x6e,
  0x73, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x61, 0x3a, 0x68, 0x6f, 0x76,
  0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x20, 0x46, 0x72, 0x65, 0x6e,
  0x63, 0x68, 0x20, 0x6c, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x74, 0x79, 0x70,
  0x69, 0x63, 0x61, 0x6c, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x65, 0x6e,
  0x65, 0x6d, 0x69, 0x65, 0x73, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x69, 0x66, 0x67,
  0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x64, 0x65, 0x63, 0x69, 0x64, 0x65, 0x64,
  0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63,
  0x68, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x66, 0x73, 0x2d, 0x69, 0x6d, 0x61, 0x67,
  0x65, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x73, 0x74, 0x61, 0x74,
  0x69, 0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x22, 0x3e, 0x63, 0x6f, 0x6e,
  0x76, 0x65, 0x72, 0x74, 0x76, 0x69, 0x6f, 0x6c, 0x65, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x65, 0x72, 0x65, 0x64, 0x66, 0x69, 0x72, 0x73, 0x74, 0x22, 0x3e, 0x63,
  0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x46, 0x69, 0x6e, 0x6c, 0x61, 0x6e, 0x64,
  0x63, 0x68, 0x65, 0x6d, 0x69, 0x73, 0x74, 0x73, 0x68, 0x65, 0x20, 0x77, 0x61,
  0x73, 0x31, 0x30, 0x70, 0x78, 0x3b, 0x22, 0x3e, 0x61, 0x73, 0x20, 0x73, 0x75,
  0x63, 0x68, 0x64, 0x69, 0x76, 0x69, 0x64, 0x65, 0x64, 0x3c, 0x2f, 0x73, 0x70,
  0x61, 0x6e, 0x3e, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x6e,
  0x65, 0x20, 0x6f, 0x66, 0x61, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x79,
  0x73, 0x74, 0x65, 0x72, 0x79, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x66,
  0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x64, 0x75, 0x65, 0x20, 0x74, 0x6f, 0x20,
  0x72, 0x61, 0x69, 0x6c, 0x77, 0x61, 0x79, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x67,
  0x65, 0x6d, 0x6f, 0x6e, 0x73, 0x74, 0x65, 0x72, 0x64, 0x65, 0x73, 0x63, 0x65,
  0x6e, 0x74, 0x69, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6e, 0x75, 0x63, 0x6c,
  0x65, 0x61, 0x72, 0x4a, 0x65, 0x77, 0x69, 0x73, 0x68, 0x20, 0x70, 0x72, 0x6f,
  0x74, 0x65, 0x73, 0x74, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x66, 0x6c,
  0x6f, 0x77, 0x65, 0x72, 0x73, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x72,
  0x65, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x20,
  0x77, 0x68, 0x6f, 0x20, 0x77, 0x61, 0x73, 0x6c, 0x65, 0x63, 0x74, 0x75, 0x72,
  0x65, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x75, 0x69, 0x63, 0x69,
  0x64, 0x65, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x70, 0x65, 0x72, 0x69,
  0x6f, 0x64, 0x73, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x73, 0x53, 0x6f, 0x63,
  0x69, 0x61, 0x6c, 0x20, 0x66, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x63, 0x6f,
  0x6d, 0x62, 0x69, 0x6e, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x77,
  0x69, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x3c, 0x62, 0x72, 0x20, 0x2f, 0x3e, 0x3c,
  0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x61, 0x74, 0x75, 0x72, 0x61,
  0x6c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x63, 0x6f, 0x6f, 0x6b, 0x69,
  0x65, 0x73, 0x6f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x72, 0x65, 0x73, 0x6f,
  0x6c, 0x76, 0x65, 0x53, 0x77, 0x65, 0x64, 0x69, 0x73, 0x68, 0x62, 0x72, 0x69,
  0x65, 0x66, 0x6c, 0x79, 0x50, 0x65, 0x72, 0x73, 0x69, 0x61, 0x6e, 0x73, 0x6f,
  0x20, 0x6d, 0x75, 0x63, 0x68, 0x43, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x64,
  0x65, 0x70, 0x69, 0x63, 0x74, 0x73, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73,
  0x68, 0x6f, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x73, 0x6e, 0x65, 0x78, 0x74, 0x20, 0x74, 0x6f, 0x62, 0x65, 0x61, 0x72, 0x69,
  0x6e, 0x67, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x76, 0x69,
  0x73, 0x65, 0x64, 0x6a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x28, 0x2d, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3a, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x3e, 0x74, 0x6f,
  0x6f, 0x6c, 0x74, 0x69, 0x70, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x64,
  0x65, 0x73, 0x69, 0x67, 0x6e, 0x73, 0x54, 0x75, 0x72, 0x6b, 0x69, 0x73, 0x68,
  0x79, 0x6f, 0x75, 0x6e, 0x67, 0x65, 0x72, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68,
  0x28, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x0a, 0x0a, 0x62, 0x75, 0x72, 0x6e, 0x69,
  0x6e, 0x67, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x65, 0x67, 0x72,
  0x65, 0x65, 0x73, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x52, 0x69, 0x63,
  0x68, 0x61, 0x72, 0x64, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x6c, 0x79, 0x70, 0x6c,
  0x61, 0x73, 0x74, 0x69, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3c,
  0x2f, 0x74, 0x72, 0x3e, 0x0d, 0x0a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23,
  0x75, 0x6c, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x70, 0x6f, 0x73, 0x73, 0x65, 0x73,
  0x73, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x68, 0x79, 0x73, 0x69,
  0x63, 0x73, 0x66, 0x61, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x65, 0x78, 0x65, 0x63,
  0x75, 0x74, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x73, 0x74, 0x6c, 0x69, 0x6e,
  0x6b, 0x20, 0x74, 0x6f, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x3c, 0x62,
  0x72, 0x20, 0x2f, 0x3e, 0x0a, 0x3a, 0x20, 0x74, 0x72, 0x75, 0x65, 0x2c, 0x63,
  0x68, 0x61, 0x72, 0x74, 0x65, 0x72, 0x74, 0x6f, 0x75, 0x72, 0x69, 0x73, 0x6d,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x63, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x65,
  0x64, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x3c, 0x2f, 0x68, 0x31, 0x3e,
  0x0d, 0x0a, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x3f, 0x78, 0x6d, 0x6c,
  0x20, 0x76, 0x65, 0x68, 0x65, 0x6c, 0x70, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x61,
  0x6d, 0x6f, 0x6e, 0x64, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x61, 0x69,
  0x72, 0x6c, 0x69, 0x6e, 0x65, 0x65, 0x6e, 0x64, 0x20, 0x2d, 0x2d, 0x3e, 0x29,
  0x2e, 0x61, 0x74, 0x74, 0x72, 0x28, 0x72, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
  0x68, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x23, 0x66, 0x66, 0x66, 0x66, 0x66,
  0x66, 0x72, 0x65, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x56, 0x69, 0x6e, 0x63, 0x65,
  0x6e, 0x74, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x20, 0x73, 0x72, 0x63,
  0x3d, 0x22, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x64, 0x65, 0x73,
  0x70, 0x69, 0x74, 0x65, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x65, 0x74, 0x65,
  0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x68,
  0x65, 0x6c, 0x64, 0x20, 0x69, 0x6e, 0x4a, 0x6f, 0x73, 0x65, 0x70, 0x68, 0x20,
  0x74, 0x68, 0x65, 0x61, 0x74, 0x72, 0x65, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74,
  0x73, 0x3c, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3e, 0x61, 0x20, 0x6c, 0x61, 0x72,
  0x67, 0x65, 0x64, 0x6f, 0x65, 0x73, 0x6e, 0x27, 0x74, 0x6c, 0x61, 0x74, 0x65,
  0x72, 0x2c, 0x20, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x66, 0x61, 0x76,
  0x69, 0x63, 0x6f, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x48, 0x75,
  0x6e, 0x67, 0x61, 0x72, 0x79, 0x41, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x73,
  0x65, 0x65, 0x20, 0x74, 0x68, 0x65, 0x73, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x4d, 0x69, 0x63, 0x68, 0x61, 0x65, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
  0x73, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x2c, 0x20, 0x61, 0x6e,
  0x64, 0x20, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x65, 0x26, 0x71, 0x75,
  0x6f, 0x74, 0x3b, 0x74, 0x72, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x66,
  0x74, 0x22, 0x3e, 0x0a, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x73, 0x47, 0x6f,
  0x6c, 0x64, 0x65, 0x6e, 0x20, 0x41, 0x66, 0x66, 0x61, 0x69, 0x72, 0x73, 0x67,
  0x72, 0x61, 0x6d, 0x6d, 0x61, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x69, 0x6e, 0x67,
  0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x69, 0x64, 0x65, 0x61, 0x20, 0x6f,
  0x66, 0x63, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x73,
  0x74, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x2e, 0x73, 0x72, 0x63,
  0x20, 0x3d, 0x20, 0x63, 0x61, 0x72, 0x74, 0x6f, 0x6f, 0x6e, 0x72, 0x65, 0x67,
  0x69, 0x73, 0x74, 0x72, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x73, 0x4d, 0x75,
  0x73, 0x6c, 0x69, 0x6d, 0x73, 0x57, 0x68, 0x61, 0x74, 0x20, 0x69, 0x73, 0x69,
  0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67,
  0x72, 0x65, 0x76, 0x65, 0x61, 0x6c, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x65, 0x64,
  0x2c, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x2f, 0x73, 0x68, 0x6f, 0x77,
  0x5f, 0x61, 0x6f, 0x75, 0x74, 0x64, 0x6f, 0x6f, 0x72, 0x65, 0x73, 0x63, 0x61,
  0x70, 0x65, 0x28, 0x41, 0x75, 0x73, 0x74, 0x72, 0x69, 0x61, 0x67, 0x65, 0x6e,
  0x65, 0x74, 0x69, 0x63, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2c, 0x49, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x48,
  0x65, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
  0x41, 0x63, 0x61, 0x64, 0x65, 0x6d, 0x79, 0x0a, 0x09, 0x09, 0x3c, 0x21, 0x2d,
  0x2d, 0x44, 0x61, 0x6e, 0x69, 0x65, 0x6c, 0x20, 0x62, 0x69, 0x6e, 0x64, 0x69,
  0x6e, 0x67, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x3e, 0x69, 0x6d, 0x70, 0x6f,
  0x73, 0x65, 0x64, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x41, 0x62, 0x72,
  0x61, 0x68, 0x61, 0x6d, 0x28, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x7b, 0x77,
  0x69, 0x64, 0x74, 0x68, 0x3a, 0x70, 0x75, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x29,
  0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x28, 0x7c, 0x7c, 0x20, 0x5b, 0x5d, 0x3b, 0x0a,
  0x44, 0x41, 0x54, 0x41, 0x5b, 0x20, 0x2a, 0x6b, 0x69, 0x74, 0x63, 0x68, 0x65,
  0x6e, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x64, 0x61, 0x63, 0x74, 0x75, 0x61,
  0x6c, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x6d, 0x61, 0x69, 0x6e,
  0x6c, 0x79, 0x20, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x27, 0x69, 0x6e, 0x73,
  0x74, 0x61, 0x6c, 0x6c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x74, 0x73, 0x69, 0x66,
  0x28, 0x74, 0x79, 0x70, 0x65, 0x49, 0x74, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x26,
  0x63, 0x6f, 0x70, 0x79, 0x3b, 0x20, 0x22, 0x3e, 0x54, 0x65, 0x72, 0x6d, 0x73,
  0x62, 0x6f, 0x72, 0x6e, 0x20, 0x69, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x65, 0x61, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x74, 0x61, 0x6c, 0x6b, 0x69,
  0x6e, 0x67, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x72, 0x6e, 0x67, 0x61, 0x69, 0x6e,
  0x65, 0x64, 0x20, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x67, 0x6a, 0x75, 0x73,
  0x74, 0x69, 0x66, 0x79, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x73, 0x66, 0x61,
  0x63, 0x74, 0x6f, 0x72, 0x79, 0x69, 0x74, 0x73, 0x20, 0x6f, 0x77, 0x6e, 0x61,
  0x73, 0x73, 0x61, 0x75, 0x6c, 0x74, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x64,
  0x6c, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x68, 0x69, 0x73, 0x20, 0x6f, 0x77,
  0x6e, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x22, 0x20, 0x72, 0x65, 0x6c,
  0x3d, 0x22, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x63, 0x6f, 0x6e, 0x63,
  0x65, 0x72, 0x74, 0x64, 0x69, 0x61, 0x67, 0x72, 0x61, 0x6d, 0x64, 0x6f, 0x6c,
  0x6c, 0x61, 0x72, 0x73, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x70, 0x68,
  0x70, 0x3f, 0x69, 0x64, 0x3d, 0x61, 0x6c, 0x63, 0x6f, 0x68, 0x6f, 0x6c, 0x29,
  0x3b, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x61,
  0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x76, 0x65, 0x73, 0x73, 0x65, 0x6c,
  0x73, 0x72, 0x65, 0x76, 0x69, 0x76, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65,
  0x73, 0x73, 0x61, 0x6d, 0x61, 0x74, 0x65, 0x75, 0x72, 0x61, 0x6e, 0x64, 0x72,
  0x6f, 0x69, 0x64, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x69, 0x6c, 0x6c,
  0x6e, 0x65, 0x73, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x69, 0x6e, 0x67, 0x63, 0x65,
  0x6e, 0x74, 0x65, 0x72, 0x73, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x79, 0x6d,
  0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x75, 0x6e, 0x69, 0x66, 0x69, 0x65, 0x64,
  0x65, 0x78, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x73,
  0x65, 0x64, 0x69, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x0a, 0x09, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x73, 0x6c, 0x69, 0x6e, 0x6b,
  0x69, 0x6e, 0x67, 0x4c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x20, 0x42, 0x6f, 0x6f,
  0x6b, 0x20, 0x6f, 0x66, 0x65, 0x76, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x6d, 0x69,
  0x6e, 0x2e, 0x6a, 0x73, 0x3f, 0x61, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x6b,
  0x6f, 0x6e, 0x74, 0x61, 0x6b, 0x74, 0x74, 0x6f, 0x64, 0x61, 0x79, 0x27, 0x73,
  0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x3d, 0x77, 0x65, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x6c, 0x20, 0x52,
  0x69, 0x67, 0x3b, 0x0a, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x72, 0x61, 0x69, 0x73,
  0x69, 0x6e, 0x67, 0x20, 0x41, 0x6c, 0x73, 0x6f, 0x2c, 0x20, 0x63, 0x72, 0x75,
  0x63, 0x69, 0x61, 0x6c, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x22, 0x3e, 0x64, 0x65,
  0x63, 0x6c, 0x61, 0x72, 0x65, 0x2d, 0x2d, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x66,
  0x69, 0x72, 0x65, 0x66, 0x6f, 0x78, 0x61, 0x73, 0x20, 0x6d, 0x75, 0x63, 0x68,
  0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2c,
  0x20, 0x73, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20,
  0x3d, 0x20, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x74, 0x6f, 0x77, 0x61,
  0x72, 0x64, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x50, 0x72, 0x69,
  0x76, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x69, 0x67, 0x6e, 0x50, 0x72,
  0x65, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x56,
  0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73,
  0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x65,
  0x64, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x76, 0x65, 0x72,
  0x74, 0x79, 0x63, 0x68, 0x61, 0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x76, 0x69,
  0x6e, 0x67, 0x20, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x41, 0x6e, 0x74,
  0x68, 0x6f, 0x6e, 0x79, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x22, 0x20, 0x52, 0x65,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x45, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x72,
  0x65, 0x61, 0x63, 0x68, 0x65, 0x73, 0x63, 0x75, 0x74, 0x74, 0x69, 0x6e, 0x67,
  0x67, 0x72, 0x61, 0x76, 0x69, 0x74, 0x79, 0x6c, 0x69, 0x66, 0x65, 0x20, 0x69,
  0x6e, 0x43, 0x68, 0x61, 0x70, 0x74, 0x65, 0x72, 0x2d, 0x73, 0x68, 0x61, 0x64,
  0x6f, 0x77, 0x4e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3c, 0x2f, 0x74, 0x64,
  0x3e, 0x0d, 0x0a, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x74, 0x61,
  0x64, 0x69, 0x75, 0x6d, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x76, 0x61,
  0x72, 0x79, 0x69, 0x6e, 0x67, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x73, 0x68,
  0x65, 0x6c, 0x64, 0x20, 0x62, 0x79, 0x77, 0x68, 0x6f, 0x20, 0x61, 0x72, 0x65,
  0x77, 0x6f, 0x72, 0x6b, 0x20, 0x69, 0x6e, 0x66, 0x61, 0x63, 0x75, 0x6c, 0x74,
  0x79, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x77, 0x68, 0x6f, 0x20, 0x68,
  0x61, 0x64, 0x61, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x74, 0x6f, 0x77, 0x6e,
  0x20, 0x6f, 0x66, 0x0a, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x20, 0x27, 0x63, 0x6c,
  0x69, 0x63, 0x6b, 0x27, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x73, 0x6b, 0x65,
  0x79, 0x77, 0x6f, 0x72, 0x64, 0x69, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x63,
  0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x28, 0x74, 0x68, 0x69, 0x73, 0x29, 0x3b,
  0x41, 0x6e, 0x64, 0x72, 0x65, 0x77, 0x20, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65,
  0x20, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x6f, 0x72, 0x20, 0x6d, 0x6f,
  0x72, 0x65, 0x33, 0x30, 0x30, 0x70, 0x78, 0x3b, 0x20, 0x72, 0x65, 0x74, 0x75,
  0x72, 0x6e, 0x3b, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x70, 0x6c, 0x75,
  0x67, 0x69, 0x6e, 0x73, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x20, 0x68, 0x65,
  0x72, 0x73, 0x65, 0x6c, 0x66, 0x53, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46,
  0x65, 0x64, 0x65, 0x72, 0x61, 0x6c, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x65,
  0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x73, 0x65, 0x6e, 0x74, 0x20, 0x74,
  0x6f, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x63, 0x74, 0x72, 0x65,
  0x73, 0x73, 0x63, 0x6f, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x66, 0x69, 0x6e, 0x67,
  0x65, 0x72, 0x73, 0x44, 0x75, 0x6b, 0x65, 0x20, 0x6f, 0x66, 0x70, 0x65, 0x6f,
  0x70, 0x6c, 0x65, 0x2c, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x77, 0x68,
  0x61, 0x74, 0x20, 0x69, 0x73, 0x68, 0x61, 0x72, 0x6d, 0x6f, 0x6e, 0x79, 0x61,
  0x20, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x22, 0x3a, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x69, 0x6e, 0x20, 0x68, 0x69, 0x73, 0x20, 0x6d, 0x65, 0x6e, 0x75, 0x22, 0x3e,
  0x0a, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x6f, 0x66, 0x66, 0x69, 0x63,
  0x65, 0x72, 0x63, 0x6f, 0x75, 0x6e, 0x63, 0x69, 0x6c, 0x67, 0x61, 0x69, 0x6e,
  0x69, 0x6e, 0x67, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x69, 0x6e, 0x53, 0x75, 0x6d,
  0x6d, 0x61, 0x72, 0x79, 0x64, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x6c, 0x6f,
  0x79, 0x61, 0x6c, 0x74, 0x79, 0x66, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x61,
  0x6e, 0x64, 0x20, 0x77, 0x61, 0x73, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x6f, 0x72,
  0x73, 0x75, 0x70, 0x72, 0x65, 0x6d, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64,
  0x20, 0x68, 0x65, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x73, 0x73, 0x69,
  0x61, 0x6e, 0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x6c, 0x62, 0x65,
  0x72, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x65, 0x74,
  0x20, 0x6f, 0x66, 0x20, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x22, 0x3e, 0x2e, 0x61,
  0x70, 0x70, 0x65, 0x6e, 0x64, 0x64, 0x6f, 0x20, 0x77, 0x69, 0x74, 0x68, 0x66,
  0x65, 0x64, 0x65, 0x72, 0x61, 0x6c, 0x62, 0x61, 0x6e, 0x6b, 0x20, 0x6f, 0x66,
  0x62, 0x65, 0x6e, 0x65, 0x61, 0x74, 0x68, 0x44, 0x65, 0x73, 0x70, 0x69, 0x74,
  0x65, 0x43, 0x61, 0x70, 0x69, 0x74, 0x61, 0x6c, 0x67, 0x72, 0x6f, 0x75, 0x6e,
  0x64, 0x73, 0x29, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x65, 0x72, 0x63,
  0x65, 0x6e, 0x74, 0x69, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x63, 0x6c, 0x6f,
  0x73, 0x69, 0x6e, 0x67, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x49, 0x6e,
  0x73, 0x74, 0x65, 0x61, 0x64, 0x66, 0x69, 0x66, 0x74, 0x65, 0x65, 0x6e, 0x61,
  0x73, 0x20, 0x77, 0x65, 0x6c, 0x6c, 0x2e, 0x79, 0x61, 0x68, 0x6f, 0x6f, 0x2e,
  0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x66, 0x69, 0x67, 0x68, 0x74, 0x65,
  0x72, 0x6f, 0x62, 0x73, 0x63, 0x75, 0x72, 0x65, 0x72, 0x65, 0x66, 0x6c, 0x65,
  0x63, 0x74, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x3d, 0x20, 0x4d, 0x61,
  0x74, 0x68, 0x2e, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x6f, 0x6e, 0x6c,
  0x69, 0x6e, 0x65, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x61, 0x20,
  0x77, 0x68, 0x6f, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x79,
  0x65, 0x61, 0x72, 0x20, 0x6f, 0x66, 0x65, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20,
  0x62, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x69,
  0x74, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x20, 0x68, 0x6f, 0x6d, 0x65, 0x20,
  0x6f, 0x66, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x72, 0x65, 0x6e, 0x61,
  0x6d, 0x65, 0x64, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x68, 0x65, 0x61,
  0x74, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x63, 0x6c,
  0x6f, 0x75, 0x64, 0x66, 0x72, 0x77, 0x61, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x4d,
  0x61, 0x72, 0x63, 0x68, 0x20, 0x31, 0x6b, 0x6e, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x69, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x74, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65,
  0x6e, 0x6c, 0x65, 0x73, 0x73, 0x6f, 0x6e, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x65,
  0x73, 0x74, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x6b,
  0x73, 0x22, 0x3e, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x65, 0x64, 0x45, 0x4e, 0x44,
  0x20, 0x2d, 0x2d, 0x3e, 0x66, 0x61, 0x6d, 0x6f, 0x75, 0x73, 0x20, 0x61, 0x77,
  0x61, 0x72, 0x64, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x48,
  0x65, 0x61, 0x6c, 0x74, 0x68, 0x20, 0x66, 0x61, 0x69, 0x72, 0x6c, 0x79, 0x20,
  0x77, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x61,
  0x6c, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x65,
  0x74, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x3e, 0x73, 0x69, 0x6e, 0x67,
  0x69, 0x6e, 0x67, 0x66, 0x61, 0x72, 0x6d, 0x65, 0x72, 0x73, 0x42, 0x72, 0x61,
  0x73, 0x69, 0x6c, 0x29, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x72, 0x65,
  0x70, 0x6c, 0x61, 0x63, 0x65, 0x47, 0x72, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x66,
  0x6f, 0x6e, 0x74, 0x20, 0x63, 0x6f, 0x70, 0x75, 0x72, 0x73, 0x75, 0x65, 0x64,
  0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x75,
  0x70, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x62, 0x6f, 0x74, 0x68, 0x20,
  0x6f, 0x66, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x73, 0x61, 0x77, 0x20,
  0x74, 0x68, 0x65, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x65, 0x73, 0x63, 0x6f, 0x6c,
  0x6f, 0x75, 0x72, 0x73, 0x69, 0x66, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x77, 0x68,
  0x65, 0x6e, 0x20, 0x68, 0x65, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x70,
  0x75, 0x73, 0x68, 0x28, 0x66, 0x75, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x20,
  0x55, 0x54, 0x46, 0x2d, 0x38, 0x22, 0x3e, 0x46, 0x61, 0x6e, 0x74, 0x61, 0x73,
  0x79, 0x69, 0x6e, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x6a, 0x75, 0x72,
  0x65, 0x64, 0x55, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x66, 0x61, 0x72, 0x6d,
  0x69, 0x6e, 0x67, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x6f, 0x62, 0x6a,
  0x65, 0x63, 0x74, 0x20, 0x64, 0x65, 0x66, 0x65, 0x6e, 0x63, 0x65, 0x75, 0x73,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x65, 0x64, 0x69, 0x63, 0x61, 0x6c, 0x3c,
  0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x74,
  0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x6b, 0x65, 0x79, 0x43, 0x6f, 0x64,
  0x65, 0x73, 0x69, 0x78, 0x74, 0x65, 0x65, 0x6e, 0x49, 0x73, 0x6c, 0x61, 0x6d,
  0x69, 0x63, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x65, 0x6e, 0x74, 0x69,
  0x72, 0x65, 0x20, 0x77, 0x69, 0x64, 0x65, 0x6c, 0x79, 0x20, 0x61, 0x63, 0x74,
  0x69, 0x76, 0x65, 0x20, 0x28, 0x74, 0x79, 0x70, 0x65, 0x6f, 0x66, 0x6f, 0x6e,
  0x65, 0x20, 0x63, 0x61, 0x6e, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x20, 0x3d, 0x73,
  0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x73,
  0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x73, 0x74, 0x65, 0x72, 0x72, 0x61, 0x69,
  0x6e, 0x3c, 0x74, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x66, 0x75, 0x6e, 0x65, 0x72,
  0x61, 0x6c, 0x76, 0x69, 0x65, 0x77, 0x69, 0x6e, 0x67, 0x6d, 0x69, 0x64, 0x64,
  0x6c, 0x65, 0x20, 0x63, 0x72, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x70, 0x72, 0x6f,
  0x70, 0x68, 0x65, 0x74, 0x73, 0x68, 0x69, 0x66, 0x74, 0x65, 0x64, 0x64, 0x6f,
  0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x75, 0x73, 0x73, 0x65, 0x6c, 0x6c, 0x20,
  0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74,
  0x61, 0x6c, 0x67, 0x65, 0x62, 0x72, 0x61, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x6c,
  0x2d, 0x62, 0x75, 0x6c, 0x6b, 0x20, 0x6f, 0x66, 0x6d, 0x61, 0x6e, 0x20, 0x61,
  0x6e, 0x64, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x0a, 0x20, 0x68, 0x65, 0x20, 0x6c,
  0x65, 0x66, 0x74, 0x29, 0x2e, 0x76, 0x61, 0x6c, 0x28, 0x29, 0x66, 0x61, 0x6c,
  0x73, 0x65, 0x29, 0x3b, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x62, 0x61,
  0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x68, 0x6f, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x6e,
  0x61, 0x6d, 0x69, 0x6e, 0x67, 0x20, 0x41, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x61,
  0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x73, 0x29, 0x3b, 0x0a, 0x7d, 0x29, 0x3b,
  0x0a, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x20, 0x74, 0x75,
  0x72, 0x6e, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x73, 0x62, 0x65, 0x66, 0x6f,
  0x72, 0x65, 0x20, 0x42, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x63, 0x68, 0x61,
  0x72, 0x67, 0x65, 0x64, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x3e, 0x43, 0x61,
  0x70, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x65, 0x64, 0x67,
  0x6f, 0x64, 0x64, 0x65, 0x73, 0x73, 0x54, 0x61, 0x67, 0x20, 0x2d, 0x2d, 0x3e,
  0x41, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x62, 0x75, 0x74, 0x20, 0x77, 0x61,
  0x73, 0x52, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x70, 0x61, 0x74, 0x69, 0x65,
  0x6e, 0x74, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x69, 0x6e, 0x3d, 0x66, 0x61, 0x6c,
  0x73, 0x65, 0x26, 0x4c, 0x69, 0x6e, 0x63, 0x6f, 0x6c, 0x6e, 0x77, 0x65, 0x20,
  0x6b, 0x6e, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x4a, 0x75,
  0x64, 0x61, 0x69, 0x73, 0x6d, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x61,
  0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x27, 0x5d, 0x29, 0x3b, 0x0a, 0x20, 0x20,
  0x68, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x75, 0x6e, 0x63, 0x6c, 0x65, 0x61,
  0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x27, 0x2c, 0x62, 0x6f, 0x74, 0x68, 0x20,
  0x69, 0x6e, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x6c, 0x6c, 0x0a, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x68, 0x61, 0x72,
  0x64, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x6f,
  0x72, 0x74, 0x20, 0x6f, 0x66, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x73,
  0x74, 0x72, 0x65, 0x65, 0x74, 0x73, 0x42, 0x65, 0x72, 0x6e, 0x61, 0x72, 0x64,
  0x61, 0x73, 0x73, 0x65, 0x72, 0x74, 0x73, 0x74, 0x65, 0x6e, 0x64, 0x20, 0x74,
  0x6f, 0x66, 0x61, 0x6e, 0x74, 0x61, 0x73, 0x79, 0x64, 0x6f, 0x77, 0x6e, 0x20,
  0x69, 0x6e, 0x68, 0x61, 0x72, 0x62, 0x6f, 0x75, 0x72, 0x46, 0x72, 0x65, 0x65,
  0x64, 0x6f, 0x6d, 0x6a, 0x65, 0x77, 0x65, 0x6c, 0x72, 0x79, 0x2f, 0x61, 0x62,
  0x6f, 0x75, 0x74, 0x2e, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x6c, 0x65,
  0x67, 0x65, 0x6e, 0x64, 0x73, 0x69, 0x73, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x6d,
  0x6f, 0x64, 0x65, 0x72, 0x6e, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x6f, 0x6e,
  0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x74, 0x6f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x22,
  0x20, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x20, 0x70, 0x61, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x61, 0x6e, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x72, 0x61, 0x72, 0x65,
  0x6c, 0x79, 0x20, 0x61, 0x63, 0x72, 0x6f, 0x6e, 0x79, 0x6d, 0x64, 0x65, 0x6c,
  0x69, 0x76, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x30, 0x30,
  0x26, 0x61, 0x6d, 0x70, 0x3b, 0x61, 0x73, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x77,
  0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x2f, 0x2a, 0x20, 0x3c, 0x21, 0x5b, 0x43,
  0x74, 0x69, 0x74, 0x6c, 0x65, 0x20, 0x3d, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x6c, 0x6f, 0x77, 0x65, 0x73, 0x74, 0x20, 0x70, 0x69, 0x63, 0x6b, 0x65,
  0x64, 0x20, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x64, 0x75, 0x73, 0x65, 0x73,
  0x20, 0x6f, 0x66, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x73, 0x20, 0x50, 0x75,
  0x62, 0x6c, 0x69, 0x63, 0x4d, 0x61, 0x74, 0x74, 0x68, 0x65, 0x77, 0x74, 0x61,
  0x63, 0x74, 0x69, 0x63, 0x73, 0x64, 0x61, 0x6d, 0x61, 0x67, 0x65, 0x64, 0x77,
  0x61, 0x79, 0x20, 0x66, 0x6f, 0x72, 0x6c, 0x61, 0x77, 0x73, 0x20, 0x6f, 0x66,
  0x65, 0x61, 0x73, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x69, 0x6e, 0x64, 0x6f,
  0x77, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x20, 0x20, 0x73, 0x69, 0x6d, 0x70,
  0x6c, 0x65, 0x7d, 0x63, 0x61, 0x74, 0x63, 0x68, 0x28, 0x73, 0x65, 0x76, 0x65,
  0x6e, 0x74, 0x68, 0x69, 0x6e, 0x66, 0x6f, 0x62, 0x6f, 0x78, 0x77, 0x65, 0x6e,
  0x74, 0x20, 0x74, 0x6f, 0x70, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x63, 0x69,
  0x74, 0x69, 0x7a, 0x65, 0x6e, 0x49, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74, 0x72,
  0x65, 0x74, 0x72, 0x65, 0x61, 0x74, 0x2e, 0x20, 0x53, 0x6f, 0x6d, 0x65, 0x20,
  0x77, 0x77, 0x2e, 0x22, 0x29, 0x3b, 0x0a, 0x62, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
  0x67, 0x6d, 0x61, 0x69, 0x6c, 0x74, 0x6f, 0x3a, 0x6d, 0x61, 0x64, 0x65, 0x20,
  0x69, 0x6e, 0x2e, 0x20, 0x4d, 0x61, 0x6e, 0x79, 0x20, 0x63, 0x61, 0x72, 0x72,
  0x69, 0x65, 0x73, 0x7c, 0x7c, 0x7b, 0x7d, 0x3b, 0x77, 0x69, 0x77, 0x6f, 0x72,
  0x6b, 0x20, 0x6f, 0x66, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x64, 0x65,
  0x66, 0x65, 0x61, 0x74, 0x73, 0x66, 0x61, 0x76, 0x6f, 0x72, 0x65, 0x64, 0x6f,
  0x70, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x70, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61,
  0x75, 0x6e, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x73, 0x65, 0x6e, 0x64, 0x69, 0x6e,
  0x67, 0x6c, 0x65, 0x66, 0x74, 0x22, 0x3e, 0x3c, 0x63, 0x6f, 0x6d, 0x53, 0x63,
  0x6f, 0x72, 0x41, 0x6c, 0x6c, 0x20, 0x74, 0x68, 0x65, 0x6a, 0x51, 0x75, 0x65,
  0x72, 0x79, 0x2e, 0x74, 0x6f, 0x75, 0x72, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x61,
  0x73, 0x73, 0x69, 0x63, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x20, 0x57, 0x69,
  0x6c, 0x68, 0x65, 0x6c, 0x6d, 0x73, 0x75, 0x62, 0x75, 0x72, 0x62, 0x73, 0x67,
  0x65, 0x6e, 0x75, 0x69, 0x6e, 0x65, 0x62, 0x69, 0x73, 0x68, 0x6f, 0x70, 0x73,
  0x2e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x28, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
  0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x62, 0x6f, 0x64, 0x79, 0x20,
  0x6f, 0x66, 0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74,
  0x61, 0x63, 0x74, 0x73, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x6c, 0x65, 0x66,
  0x74, 0x20, 0x74, 0x6f, 0x63, 0x68, 0x69, 0x65, 0x66, 0x6c, 0x79, 0x2d, 0x68,
  0x69, 0x64, 0x64, 0x65, 0x6e, 0x2d, 0x62, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3c,
  0x2f, 0x6c, 0x69, 0x3e, 0x0a, 0x0a, 0x2e, 0x20, 0x57, 0x68, 0x65, 0x6e, 0x20,
  0x69, 0x6e, 0x20, 0x62, 0x6f, 0x74, 0x68, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73,
  0x73, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x61, 0x6c, 0x77, 0x61, 0x79,
  0x73, 0x20, 0x76, 0x69, 0x61, 0x20, 0x74, 0x68, 0x65, 0x73, 0x70, 0x61, 0xc3,
  0xb1, 0x6f, 0x6c, 0x77, 0x65, 0x6c, 0x66, 0x61, 0x72, 0x65, 0x72, 0x75, 0x6c,
  0x69, 0x6e, 0x67, 0x20, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x63, 0x61,
  0x70, 0x74, 0x61, 0x69, 0x6e, 0x68, 0x69, 0x73, 0x20, 0x73, 0x6f, 0x6e, 0x72,
  0x75, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x6f, 0x6b,
  0x69, 0x74, 0x73, 0x65, 0x6c, 0x66, 0x2c, 0x3d, 0x30, 0x26, 0x61, 0x6d, 0x70,
  0x3b, 0x28, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x73, 0x61, 0x6d, 0x70, 0x6c,
  0x65, 0x73, 0x74, 0x6f, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x63, 0x6f, 0x6d, 0x2f,
  0x70, 0x61, 0x67, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x20, 0x4b, 0x65, 0x6e,
  0x6e, 0x65, 0x64, 0x79, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x66, 0x75,
  0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x64, 0x42,
  0x65, 0x73, 0x69, 0x64, 0x65, 0x73, 0x2f, 0x2f, 0x2d, 0x2d, 0x3e, 0x3c, 0x2f,
  0x61, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x73, 0x65, 0x73, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x68, 0x69, 0x6d, 0x20, 0x74,
  0x6f, 0x20, 0x69, 0x74, 0x73, 0x20, 0x62, 0x79, 0x20, 0x63, 0x6f, 0x6d, 0x6d,
  0x6f, 0x6e, 0x2e, 0x6d, 0x69, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x74, 0x6f, 0x20,
  0x74, 0x61, 0x6b, 0x65, 0x77, 0x61, 0x79, 0x73, 0x20, 0x74, 0x6f, 0x73, 0x2e,
  0x6f, 0x72, 0x67, 0x2f, 0x6c, 0x61, 0x64, 0x76, 0x69, 0x73, 0x65, 0x64, 0x70,
  0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x3a,
  0x69, 0x66, 0x20, 0x74, 0x68, 0x65, 0x79, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72,
  0x73, 0x61, 0x20, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x48, 0x65, 0x72, 0x62, 0x65,
  0x72, 0x74, 0x73, 0x74, 0x72, 0x69, 0x6b, 0x65, 0x73, 0x20, 0x67, 0x72, 0x6f,
  0x75, 0x70, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x66, 0x6c, 0x69,
  0x67, 0x68, 0x74, 0x73, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x73, 0x6c,
  0x6f, 0x77, 0x6c, 0x79, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x65, 0x72, 0x20, 0x73,
  0x6f, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x3c, 0x2f, 0x70, 0x3e, 0x0a, 0x09, 0x09,
  0x69, 0x74, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x64,
  0x20, 0x72, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x75, 0x6c, 0x3e, 0x0d, 0x0a,
  0x20, 0x20, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x70, 0x61, 0x69, 0x72,
  0x20, 0x6f, 0x66, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x69, 0x74, 0x4b, 0x6f, 0x6e,
  0x74, 0x61, 0x6b, 0x74, 0x41, 0x6e, 0x74, 0x6f, 0x6e, 0x69, 0x6f, 0x68, 0x61,
  0x76, 0x69, 0x6e, 0x67, 0x20, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x20,
  0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
  0x74, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x22, 0x29, 0x2e, 0x63, 0x73, 0x73,
  0x28, 0x68, 0x6f, 0x73, 0x74, 0x69, 0x6c, 0x65, 0x6c, 0x65, 0x61, 0x64, 0x20,
  0x74, 0x6f, 0x6c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x20, 0x67, 0x72, 0x6f, 0x75,
  0x70, 0x73, 0x2c, 0x50, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x2d, 0x2d, 0x3e,
  0x0d, 0x0a, 0x0d, 0x0a, 0x20, 0x72, 0x6f, 0x77, 0x73, 0x3d, 0x22, 0x20, 0x6f,
  0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x3c,
  0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56,
  0x3e, 0x3c, 0x5c, 0x2f, 0x73, 0x63, 0x72, 0x73, 0x6f, 0x6c, 0x76, 0x69, 0x6e,
  0x67, 0x43, 0x68, 0x61, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x6c, 0x61, 0x76, 0x65,
  0x72, 0x79, 0x77, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x77, 0x68, 0x65, 0x72,
  0x65, 0x61, 0x73, 0x21, 0x3d, 0x20, 0x27, 0x75, 0x6e, 0x64, 0x66, 0x6f, 0x72,
  0x20, 0x61, 0x6c, 0x6c, 0x70, 0x61, 0x72, 0x74, 0x6c, 0x79, 0x20, 0x2d, 0x72,
  0x69, 0x67, 0x68, 0x74, 0x3a, 0x41, 0x72, 0x61, 0x62, 0x69, 0x61, 0x6e, 0x62,
  0x61, 0x63, 0x6b, 0x65, 0x64, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79,
  0x75, 0x6e, 0x69, 0x74, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65,
  0x2d, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x2c, 0x69, 0x73, 0x20, 0x68, 0x6f,
  0x6d, 0x65, 0x72, 0x69, 0x73, 0x6b, 0x20, 0x6f, 0x66, 0x64, 0x65, 0x73, 0x69,
  0x72, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x6e, 0x74, 0x6f, 0x6e, 0x63, 0x6f, 0x73,
  0x74, 0x20, 0x6f, 0x66, 0x61, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x62, 0x65,
  0x63, 0x6f, 0x6d, 0x65, 0x20, 0x6e, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x70,
  0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x4d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x20,
  0x65, 0x61, 0x64, 0x27, 0x29, 0x5b, 0x30, 0x43, 0x72, 0x69, 0x74, 0x69, 0x63,
  0x73, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x73, 0x3e, 0x26, 0x63, 0x6f, 0x70,
  0x79, 0x3b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x3e, 0x61, 0x73, 0x73, 0x65,
  0x6d, 0x62, 0x6c, 0x6d, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x70, 0x72, 0x65,
  0x73, 0x73, 0x65, 0x64, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x73,
  0x3a, 0x22, 0x20, 0x3f, 0x20, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x62,
  0x79, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x65, 0x72, 0x20,
  0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x65,
  0x64, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x68, 0x61, 0x64, 0x20, 0x74,
  0x68, 0x65, 0x70, 0x75, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x62, 0x75, 0x74, 0x20, 0x61, 0x72, 0x65, 0x70, 0x61, 0x72,
  0x74, 0x69, 0x61, 0x6c, 0x42, 0x61, 0x62, 0x79, 0x6c, 0x6f, 0x6e, 0x62, 0x6f,
  0x74, 0x74, 0x6f, 0x6d, 0x20, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x43,
  0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x69, 0x74, 0x73, 0x20, 0x75, 0x73, 0x65,
  0x41, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x63, 0x6f, 0x75, 0x72, 0x73, 0x65,
  0x73, 0x61, 0x20, 0x74, 0x68, 0x69, 0x72, 0x64, 0x64, 0x65, 0x6e, 0x6f, 0x74,
  0x65, 0x73, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x69, 0x6e, 0x48, 0x6f, 0x75, 0x73,
  0x74, 0x6f, 0x6e, 0x32, 0x30, 0x70, 0x78, 0x3b, 0x22, 0x3e, 0x61, 0x63, 0x63,
  0x75, 0x73, 0x65, 0x64, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x20, 0x67, 0x6f,
  0x61, 0x6c, 0x20, 0x6f, 0x66, 0x46, 0x61, 0x6d, 0x6f, 0x75, 0x73, 0x20, 0x29,
  0x2e, 0x62, 0x69, 0x6e, 0x64, 0x28, 0x70, 0x72, 0x69, 0x65, 0x73, 0x74, 0x73,
  0x20, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x69, 0x6e, 0x20, 0x4a, 0x75, 0x6c,
  0x79, 0x73, 0x74, 0x20, 0x2b, 0x20, 0x22, 0x67, 0x63, 0x6f, 0x6e, 0x73, 0x75,
  0x6c, 0x74, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x68, 0x65, 0x6c, 0x70,
  0x66, 0x75, 0x6c, 0x72, 0x65, 0x76, 0x69, 0x76, 0x65, 0x64, 0x69, 0x73, 0x20,
  0x76, 0x65, 0x72, 0x79, 0x72, 0x27, 0x2b, 0x27, 0x69, 0x70, 0x74, 0x6c, 0x6f,
  0x73, 0x69, 0x6e, 0x67, 0x20, 0x66, 0x65, 0x6d, 0x61, 0x6c, 0x65, 0x73, 0x69,
  0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73,
  0x64, 0x61, 0x79, 0x73, 0x20, 0x6f, 0x66, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61,
  0x6c, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x20, 0x3c, 0x6f, 0x62, 0x6a, 0x65,
  0x63, 0x74, 0x66, 0x6f, 0x72, 0x63, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x69,
  0x6e, 0x67, 0x28, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x09, 0x09, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x69, 0x73, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x2e, 0x20,
  0x20, 0x54, 0x68, 0x65, 0x20, 0x62, 0x61, 0x6c, 0x6c, 0x6f, 0x6f, 0x6e, 0x64,
  0x6f, 0x6e, 0x65, 0x20, 0x62, 0x79, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
  0x62, 0x67, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x6c, 0x61, 0x77, 0x20, 0x6f, 0x66,
  0x20, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x61, 0x61, 0x76, 0x6f, 0x69, 0x64,
  0x65, 0x64, 0x62, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x32, 0x70, 0x78, 0x20,
  0x33, 0x70, 0x78, 0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x66, 0x74,
  0x65, 0x72, 0x20, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x6d, 0x65,
  0x6e, 0x20, 0x61, 0x6e, 0x64, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2d, 0x3d,
  0x20, 0x74, 0x72, 0x75, 0x65, 0x3b, 0x66, 0x6f, 0x72, 0x20, 0x75, 0x73, 0x65,
  0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x2e, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e,
  0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x20, 0x3d, 0x66, 0x61, 0x6d, 0x69, 0x6c,
  0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x20, 0x26, 0x6e, 0x62,
  0x73, 0x70, 0x3b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x73, 0x65, 0x74, 0x65,
  0x72, 0x6e, 0x61, 0x6c, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x61, 0x73, 0x6e, 0x6f,
  0x74, 0x69, 0x63, 0x65, 0x64, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x73, 0x7d,
  0x29, 0x28, 0x29, 0x3b, 0x0a, 0x20, 0x69, 0x73, 0x20, 0x6d, 0x6f, 0x72, 0x65,
  0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x72,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x65, 0x77, 0x69, 0x73, 0x20, 0x6a, 0x75,
  0x73, 0x74, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x20, 0x53, 0x65, 0x61,
  0x72, 0x63, 0x68, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x77, 0x68, 0x79,
  0x20, 0x74, 0x68, 0x65, 0x73, 0x68, 0x69, 0x70, 0x70, 0x65, 0x64, 0x62, 0x72,
  0x3e, 0x3c, 0x62, 0x72, 0x3e, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x20, 0x68,
  0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x6f, 0x66,
  0x63, 0x75, 0x69, 0x73, 0x69, 0x6e, 0x65, 0x69, 0x73, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x61, 0x20, 0x76, 0x65, 0x72, 0x79, 0x20, 0x41, 0x64, 0x6d, 0x69, 0x72,
  0x61, 0x6c, 0x20, 0x66, 0x69, 0x78, 0x65, 0x64, 0x3b, 0x6e, 0x6f, 0x72, 0x6d,
  0x61, 0x6c, 0x20, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65,
  0x73, 0x73, 0x2c, 0x20, 0x6f, 0x6e, 0x74, 0x61, 0x72, 0x69, 0x6f, 0x63, 0x68,
  0x61, 0x72, 0x73, 0x65, 0x74, 0x74, 0x72, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x69,
  0x6e, 0x76, 0x61, 0x64, 0x65, 0x64, 0x3d, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22,
  0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x69, 0x73, 0x20, 0x6d, 0x6f, 0x73,
  0x74, 0x61, 0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6c,
  0x6c, 0x79, 0x66, 0x61, 0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x7d, 0x29, 0x3b, 0x0d,
  0x0a, 0x20, 0x20, 0x69, 0x6d, 0x6d, 0x65, 0x6e, 0x73, 0x65, 0x74, 0x69, 0x6d,
  0x65, 0x20, 0x69, 0x6e, 0x73, 0x65, 0x74, 0x20, 0x6f, 0x75, 0x74, 0x73, 0x61,
  0x74, 0x69, 0x73, 0x66, 0x79, 0x74, 0x6f, 0x20, 0x66, 0x69, 0x6e, 0x64, 0x64,
  0x6f, 0x77, 0x6e, 0x20, 0x74, 0x6f, 0x6c, 0x6f, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x50, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x69, 0x6e, 0x20, 0x4a, 0x75, 0x6e,
  0x65, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x75, 0x6d, 0x6e, 0x6f, 0x74, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x69, 0x73, 0x74,
  0x61, 0x6e, 0x74, 0x46, 0x69, 0x6e, 0x6e, 0x69, 0x73, 0x68, 0x73, 0x72, 0x63,
  0x20, 0x3d, 0x20, 0x28, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x20, 0x68, 0x65,
  0x6c, 0x70, 0x20, 0x6f, 0x66, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x20, 0x6c,
  0x61, 0x77, 0x20, 0x61, 0x6e, 0x64, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x65, 0x64,
  0x66, 0x6f, 0x72, 0x65, 0x73, 0x74, 0x73, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x6e,
  0x67, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x3e, 0x68, 0x65, 0x61, 0x64, 0x65,
  0x72, 0x2d, 0x77, 0x65, 0x6c, 0x6c, 0x20, 0x61, 0x73, 0x53, 0x74, 0x61, 0x6e,
  0x6c, 0x65, 0x79, 0x62, 0x72, 0x69, 0x64, 0x67, 0x65, 0x73, 0x2f, 0x67, 0x6c,
  0x6f, 0x62, 0x61, 0x6c, 0x43, 0x72, 0x6f, 0x61, 0x74, 0x69, 0x61, 0x20, 0x41,
  0x62, 0x6f, 0x75, 0x74, 0x20, 0x5b, 0x30, 0x5d, 0x3b, 0x0a, 0x20, 0x20, 0x69,
  0x74, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x65, 0x64,
  0x62, 0x65, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x29, 0x7b, 0x74, 0x68, 0x72, 0x6f,
  0x77, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x6c, 0x69, 0x67, 0x68, 0x74,
  0x65, 0x72, 0x65, 0x74, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x22, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x22, 0x6c, 0x69, 0x6b,
  0x65, 0x20, 0x61, 0x20, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x73, 0x6c, 0x69,
  0x76, 0x65, 0x20, 0x69, 0x6e, 0x61, 0x73, 0x20, 0x73, 0x65, 0x65, 0x6e, 0x70,
  0x72, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66,
  0x75, 0x62, 0x2d, 0x6c, 0x69, 0x6e, 0x6b, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74,
  0x73, 0x61, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x69, 0x6d, 0x61, 0x67, 0x65,
  0x22, 0x3e, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x66, 0x65, 0x65, 0x64,
  0x69, 0x6e, 0x67, 0x4e, 0x75, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x69, 0x6e, 0x66,
  0x6f, 0x72, 0x6d, 0x61, 0x74, 0x6f, 0x20, 0x68, 0x65, 0x6c, 0x70, 0x57, 0x6f,
  0x6d, 0x65, 0x6e, 0x27, 0x73, 0x4e, 0x65, 0x69, 0x74, 0x68, 0x65, 0x72, 0x4d,
  0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x69, 0x6e,
  0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x62, 0x79, 0x20, 0x6d, 0x61, 0x6e,
  0x79, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x6c, 0x61, 0x77, 0x73, 0x75,
  0x69, 0x74, 0x64, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2e, 0x70, 0x75, 0x73,
  0x68, 0x28, 0x7b, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x73, 0x69, 0x6d,
  0x70, 0x6c, 0x79, 0x20, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x2e, 0x63,
  0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x20, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x28, 0x6f,
  0x6c, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x75, 0x73, 0x2e, 0x6a, 0x73, 0x22, 0x3e,
  0x20, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x72, 0x20, 0x6f, 0x70, 0x65, 0x6e, 0x20,
  0x74, 0x6f, 0x21, 0x2d, 0x2d, 0x20, 0x65, 0x6e, 0x64, 0x6c, 0x69, 0x65, 0x73,
  0x20, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x3b, 0x0d, 0x0a, 0x20, 0x20, 0x6d, 0x61,
  0x72, 0x6b, 0x65, 0x74, 0x77, 0x68, 0x6f, 0x20, 0x69, 0x73, 0x20, 0x28, 0x22,
  0x44, 0x4f, 0x4d, 0x43, 0x6f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6f,
  0x6e, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x74, 0x79, 0x70, 0x65, 0x6f, 0x66, 0x20,
  0x4b, 0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x74,
  0x73, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x74, 0x6f, 0x20, 0x73, 0x68,
  0x6f, 0x77, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x64, 0x65,
  0x20, 0x69, 0x74, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x77, 0x65, 0x72,
  0x65, 0x20, 0x69, 0x6e, 0x6d, 0x69, 0x78, 0x74, 0x75, 0x72, 0x65, 0x70, 0x72,
  0x65, 0x63, 0x69, 0x73, 0x65, 0x61, 0x72, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x73,
  0x72, 0x63, 0x20, 0x3d, 0x20, 0x27, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x61, 0x20,
  0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x64, 0x42, 0x61, 0x70, 0x74, 0x69, 0x73,
  0x74, 0x76, 0x6f, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x0a, 0x09, 0x09, 0x76, 0x61,
  0x72, 0x20, 0x4d, 0x61, 0x72, 0x63, 0x68, 0x20, 0x32, 0x67, 0x72, 0x65, 0x77,
  0x20, 0x75, 0x70, 0x43, 0x6c, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x2e, 0x72, 0x65,
  0x6d, 0x6f, 0x76, 0x65, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x77, 0x61,
  0x79, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x66,
  0x61, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x61, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x20,
  0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3e, 0x74, 0x6f, 0x20, 0x77, 0x6f, 0x72,
  0x6b, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x73, 0x68, 0x61, 0x73, 0x20, 0x68,
  0x61, 0x64, 0x65, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x73, 0x68, 0x6f, 0x77,
  0x28, 0x29, 0x3b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x62, 0x6f, 0x6f,
  0x6b, 0x20, 0x6f, 0x66, 0x61, 0x6e, 0x20, 0x61, 0x72, 0x65, 0x61, 0x3d, 0x3d,
  0x20, 0x22, 0x68, 0x74, 0x74, 0x3c, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x0a,
  0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
  0x66, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x20, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
  0x2e, 0x72, 0x65, 0x6c, 0x79, 0x20, 0x6f, 0x6e, 0x68, 0x6f, 0x73, 0x74, 0x65,
  0x64, 0x20, 0x2e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x68, 0x65, 0x20, 0x77,
  0x65, 0x6e, 0x74, 0x62, 0x75, 0x74, 0x20, 0x66, 0x6f, 0x72, 0x73, 0x70, 0x72,
  0x65, 0x61, 0x64, 0x20, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x20, 0x61, 0x20,
  0x6d, 0x65, 0x61, 0x6e, 0x73, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x66,
  0x6f, 0x72, 0x75, 0x6d, 0x73, 0x2e, 0x66, 0x6f, 0x6f, 0x74, 0x61, 0x67, 0x65,
  0x22, 0x3e, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x43, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x73, 0x22, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x61, 0x73, 0x20, 0x68, 0x69,
  0x67, 0x68, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x73, 0x65, 0x2d, 0x2d, 0x3e, 0x3c,
  0x21, 0x2d, 0x2d, 0x66, 0x65, 0x6d, 0x61, 0x6c, 0x65, 0x20, 0x69, 0x73, 0x20,
  0x73, 0x65, 0x65, 0x6e, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x73, 0x65,
  0x74, 0x20, 0x74, 0x68, 0x65, 0x61, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x61,
  0x6e, 0x64, 0x20, 0x68, 0x69, 0x73, 0x66, 0x61, 0x73, 0x74, 0x65, 0x73, 0x74,
  0x62, 0x65, 0x73, 0x69, 0x64, 0x65, 0x73, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e,
  0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x22, 0x3e, 0x3c, 0x69, 0x6d,
  0x67, 0x20, 0x49, 0x6e, 0x66, 0x6f, 0x62, 0x6f, 0x78, 0x65, 0x76, 0x65, 0x6e,
  0x74, 0x73, 0x2c, 0x61, 0x20, 0x79, 0x6f, 0x75, 0x6e, 0x67, 0x61, 0x6e, 0x64,
  0x20, 0x61, 0x72, 0x65, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x20, 0x63, 0x68,
  0x65, 0x61, 0x70, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x61,
  0x6e, 0x64, 0x20, 0x68, 0x61, 0x73, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73,
  0x77, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x28, 0x6d, 0x6f, 0x73, 0x74, 0x6c,
  0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x66, 0x69, 0x6e, 0x64, 0x20,
  0x61, 0x20, 0x2d, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x69, 0x6e,
  0x63, 0x65, 0x20, 0x61, 0x72, 0x65, 0x61, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x72,
  0x65, 0x20, 0x6f, 0x66, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6e, 0x61,
  0x74, 0x75, 0x72, 0x65, 0x2c, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x6c, 0x79, 0x70,
  0x65, 0x72, 0x69, 0x6f, 0x64, 0x2c, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x66,
  0x6f, 0x72, 0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x64, 0x75, 0x63, 0x65,
  0x64, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x67, 0x6d, 0x69, 0x73, 0x73, 0x69,
  0x6c, 0x65, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x41, 0x67, 0x61, 0x69,
  0x6e, 0x73, 0x74, 0x74, 0x68, 0x65, 0x20, 0x77, 0x61, 0x79, 0x6b, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x70, 0x78, 0x3b, 0x22, 0x3e, 0x0d, 0x0a, 0x70, 0x75,
  0x73, 0x68, 0x65, 0x64, 0x20, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x6e,
  0x75, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x61, 0x69, 0x6e,
  0x49, 0x6e, 0x20, 0x74, 0x68, 0x69, 0x73, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x69,
  0x6e, 0x6f, 0x72, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x20,
  0x69, 0x73, 0x61, 0x6e, 0x64, 0x2c, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x6f, 0x77,
  0x6e, 0x65, 0x64, 0x49, 0x53, 0x42, 0x4e, 0x20, 0x30, 0x2d, 0x63, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x73, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x6d, 0x61,
  0x79, 0x20, 0x6e, 0x6f, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x20, 0x6c,
  0x61, 0x74, 0x65, 0x20, 0x69, 0x6e, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x63, 0x65,
  0x65, 0x6e, 0x61, 0x63, 0x74, 0x65, 0x64, 0x77, 0x69, 0x73, 0x68, 0x20, 0x74,
  0x6f, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x6c, 0x79, 0x63, 0x6f, 0x6f, 0x6c, 0x69,
  0x6e, 0x67, 0x6f, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x3d, 0x69, 0x74, 0x2e, 0x20,
  0x54, 0x68, 0x65, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x4d, 0x65, 0x6d,
  0x62, 0x65, 0x72, 0x73, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x20, 0x61, 0x73,
  0x73, 0x75, 0x6d, 0x65, 0x73, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0a, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x20, 0x6f, 0x6e, 0x65, 0x20,
  0x3d, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72,
  0x5f, 0x61, 0x20, 0x67, 0x6f, 0x6f, 0x64, 0x20, 0x72, 0x65, 0x6b, 0x6c, 0x61,
  0x6d, 0x61, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x2c, 0x74, 0x6f, 0x20, 0x74,
  0x68, 0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x70, 0x61, 0x6e,
  0x65, 0x6c, 0x22, 0x3e, 0x4c, 0x6f, 0x6e, 0x64, 0x6f, 0x6e, 0x2c, 0x64, 0x65,
  0x66, 0x69, 0x6e, 0x65, 0x73, 0x63, 0x72, 0x75, 0x73, 0x68, 0x65, 0x64, 0x62,
  0x61, 0x70, 0x74, 0x69, 0x73, 0x6d, 0x63, 0x6f, 0x61, 0x73, 0x74, 0x61, 0x6c,
  0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22,
  0x20, 0x6d, 0x6f, 0x76, 0x65, 0x20, 0x74, 0x6f, 0x6c, 0x6f, 0x73, 0x74, 0x20,
  0x69, 0x6e, 0x62, 0x65, 0x74, 0x74, 0x65, 0x72, 0x20, 0x69, 0x6d, 0x70, 0x6c,
  0x69, 0x65, 0x73, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x72, 0x79, 0x73, 0x65, 0x72,
  0x76, 0x65, 0x72, 0x73, 0x20, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x50, 0x65,
  0x72, 0x68, 0x61, 0x70, 0x73, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x66, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x6c, 0x61, 0x73, 0x74, 0x65, 0x64, 0x20, 0x72, 0x69, 0x73, 0x65, 0x20, 0x69,
  0x6e, 0x47, 0x65, 0x6e, 0x65, 0x73, 0x69, 0x73, 0x76, 0x69, 0x65, 0x77, 0x20,
  0x6f, 0x66, 0x72, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x73, 0x65, 0x65, 0x6d,
  0x20, 0x74, 0x6f, 0x62, 0x75, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x62, 0x61, 0x63,
  0x6b, 0x69, 0x6e, 0x67, 0x68, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x67, 0x69,
  0x76, 0x65, 0x6e, 0x20, 0x61, 0x67, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x63,
  0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x20, 0x6f, 0x66,
  0x20, 0x4c, 0x61, 0x74, 0x65, 0x72, 0x20, 0x61, 0x6c, 0x6c, 0x20, 0x62, 0x75,
  0x74, 0x48, 0x69, 0x67, 0x68, 0x77, 0x61, 0x79, 0x6f, 0x6e, 0x6c, 0x79, 0x20,
  0x62, 0x79, 0x73, 0x69, 0x67, 0x6e, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x20, 0x64,
  0x6f, 0x65, 0x73, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x73, 0x62, 0x61, 0x74,
  0x74, 0x65, 0x72, 0x79, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6c, 0x61, 0x73, 0x69,
  0x6e, 0x67, 0x6c, 0x65, 0x73, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x73, 0x69,
  0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x74, 0x61, 0x6b, 0x65, 0x20, 0x6f, 0x6e,
  0x72, 0x65, 0x66, 0x75, 0x73, 0x65, 0x64, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64,
  0x20, 0x3d, 0x55, 0x53, 0x26, 0x61, 0x6d, 0x70, 0x53, 0x65, 0x65, 0x20, 0x74,
  0x68, 0x65, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x62, 0x79, 0x20, 0x74,
  0x68, 0x69, 0x73, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x68, 0x65, 0x61,
  0x64, 0x20, 0x6f, 0x66, 0x3a, 0x68, 0x6f, 0x76, 0x65, 0x72, 0x2c, 0x6c, 0x65,
  0x73, 0x62, 0x69, 0x61, 0x6e, 0x73, 0x75, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x61,
  0x6e, 0x64, 0x20, 0x61, 0x6c, 0x6c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
  0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
  0x73, 0x48, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x2f, 0x70, 0x69, 0x78, 0x65,
  0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x6c,
  0x6f, 0x6e, 0x67, 0x72, 0x6f, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x6a, 0x6f, 0x69,
  0x6e, 0x74, 0x6c, 0x79, 0x73, 0x6b, 0x79, 0x73, 0x63, 0x72, 0x61, 0x55, 0x6e,
  0x69, 0x63, 0x6f, 0x64, 0x65, 0x62, 0x72, 0x20, 0x2f, 0x3e, 0x0d, 0x0a, 0x41,
  0x74, 0x6c, 0x61, 0x6e, 0x74, 0x61, 0x6e, 0x75, 0x63, 0x6c, 0x65, 0x75, 0x73,
  0x43, 0x6f, 0x75, 0x6e, 0x74, 0x79, 0x2c, 0x70, 0x75, 0x72, 0x65, 0x6c, 0x79,
  0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x3e, 0x65, 0x61, 0x73, 0x69, 0x6c,
  0x79, 0x20, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x20, 0x61, 0x6f, 0x6e, 0x63, 0x6c,
  0x69, 0x63, 0x6b, 0x61, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x70, 0x6f, 0x69,
  0x6e, 0x74, 0x65, 0x72, 0x68, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x65, 0x76,
  0x65, 0x6e, 0x74, 0x73, 0x20, 0x65, 0x6c, 0x73, 0x65, 0x20, 0x7b, 0x0a, 0x64,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6e, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x65,
  0x2c, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x6d, 0x61, 0x6e, 0x20, 0x77, 0x68,
  0x6f, 0x6f, 0x72, 0x67, 0x2f, 0x57, 0x65, 0x62, 0x6f, 0x6e, 0x65, 0x20, 0x61,
  0x6e, 0x64, 0x63, 0x61, 0x76, 0x61, 0x6c, 0x72, 0x79, 0x48, 0x65, 0x20, 0x64,
  0x69, 0x65, 0x64, 0x73, 0x65, 0x61, 0x74, 0x74, 0x6c, 0x65, 0x30, 0x30, 0x2c,
  0x30, 0x30, 0x30, 0x20, 0x7b, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x68, 0x61,
  0x76, 0x65, 0x20, 0x74, 0x6f, 0x69, 0x66, 0x28, 0x77, 0x69, 0x6e, 0x64, 0x61,
  0x6e, 0x64, 0x20, 0x69, 0x74, 0x73, 0x73, 0x6f, 0x6c, 0x65, 0x6c, 0x79, 0x20,
  0x6d, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x65,
  0x64, 0x44, 0x65, 0x74, 0x72, 0x6f, 0x69, 0x74, 0x61, 0x6d, 0x6f, 0x6e, 0x67,
  0x73, 0x74, 0x65, 0x69, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x6d,
  0x20, 0x69, 0x6e, 0x53, 0x65, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x73, 0x3c,
  0x2f, 0x61, 0x3e, 0x3c, 0x4b, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x46, 0x72,
  0x61, 0x6e, 0x63, 0x69, 0x73, 0x2d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x68,
  0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x61, 0x72, 0x74, 0x20, 0x61, 0x6e, 0x64,
  0x68, 0x69, 0x6d, 0x20, 0x61, 0x6e, 0x64, 0x75, 0x73, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x73, 0x63, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x61, 0x74, 0x20, 0x68, 0x6f,
  0x6d, 0x65, 0x74, 0x6f, 0x20, 0x68, 0x61, 0x76, 0x65, 0x72, 0x65, 0x6c, 0x61,
  0x74, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x66, 0x61, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x66, 0x66, 0x61, 0x6c, 0x6f, 0x6c, 0x69,
  0x6e, 0x6b, 0x22, 0x3e, 0x3c, 0x77, 0x68, 0x61, 0x74, 0x20, 0x68, 0x65, 0x66,
  0x72, 0x65, 0x65, 0x20, 0x74, 0x6f, 0x43, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66,
  0x63, 0x6f, 0x6d, 0x65, 0x20, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x74, 0x6f, 0x72,
  0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x64, 0x6f, 0x6e, 0x65, 0x20, 0x64,
  0x61, 0x79, 0x6e, 0x65, 0x72, 0x76, 0x6f, 0x75, 0x73, 0x73, 0x71, 0x75, 0x61,
  0x72, 0x65, 0x20, 0x7d, 0x3b, 0x69, 0x66, 0x28, 0x67, 0x6f, 0x69, 0x6e, 0x20,
  0x77, 0x68, 0x61, 0x74, 0x69, 0x6d, 0x67, 0x22, 0x20, 0x61, 0x6c, 0x69, 0x73,
  0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2f, 0x74,
  0x75, 0x65, 0x73, 0x64, 0x61, 0x79, 0x6c, 0x6f, 0x6f, 0x73, 0x65, 0x6c, 0x79,
  0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x73, 0x65, 0x78, 0x75, 0x61, 0x6c,
  0x20, 0x2d, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x75,
  0x6d, 0x22, 0x44, 0x4f, 0x20, 0x4e, 0x4f, 0x54, 0x20, 0x46, 0x72, 0x61, 0x6e,
  0x63, 0x65, 0x2c, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x77, 0x61, 0x72,
  0x20, 0x61, 0x6e, 0x64, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, 0x74, 0x61,
  0x6b, 0x65, 0x20, 0x61, 0x20, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x0d, 0x0a, 0x6d,
  0x61, 0x72, 0x6b, 0x65, 0x74, 0x2e, 0x68, 0x69, 0x67, 0x68, 0x77, 0x61, 0x79,
  0x64, 0x6f, 0x6e, 0x65, 0x20, 0x69, 0x6e, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
  0x79, 0x22, 0x6c, 0x61, 0x73, 0x74, 0x22, 0x3e, 0x6f, 0x62, 0x6c, 0x69, 0x67,
  0x65, 0x64, 0x72, 0x69, 0x73, 0x65, 0x20, 0x74, 0x6f, 0x22, 0x75, 0x6e, 0x64,
  0x65, 0x66, 0x69, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x45, 0x61,
  0x72, 0x6c, 0x79, 0x20, 0x70, 0x72, 0x61, 0x69, 0x73, 0x65, 0x64, 0x69, 0x6e,
  0x20, 0x69, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x68, 0x69, 0x73, 0x61,
  0x74, 0x68, 0x6c, 0x65, 0x74, 0x65, 0x4a, 0x75, 0x70, 0x69, 0x74, 0x65, 0x72,
  0x59, 0x61, 0x68, 0x6f, 0x6f, 0x21, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64,
  0x20, 0x73, 0x6f, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x72, 0x65, 0x61, 0x6c, 0x6c,
  0x79, 0x20, 0x73, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x61, 0x20, 0x77, 0x6f,
  0x6d, 0x61, 0x6e, 0x3f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x64, 0x69, 0x72,
  0x65, 0x63, 0x74, 0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x20, 0x62, 0x69,
  0x63, 0x79, 0x63, 0x6c, 0x65, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x64,
  0x61, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6e, 0x67,
  0x52, 0x61, 0x74, 0x68, 0x65, 0x72, 0x2c, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72,
  0x20, 0x4f, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6e,
  0x6f, 0x77, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2c, 0x20, 0x77, 0x68, 0x65, 0x6e,
  0x20, 0x61, 0x20, 0x70, 0x61, 0x79, 0x20, 0x66, 0x6f, 0x72, 0x6f, 0x6e, 0x20,
  0x74, 0x68, 0x69, 0x73, 0x2d, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x3e, 0x3b, 0x62,
  0x6f, 0x72, 0x64, 0x65, 0x72, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x61,
  0x6e, 0x6e, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x65, 0x77,
  0x70, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x22, 0x20,
  0x74, 0x61, 0x6b, 0x69, 0x6e, 0x20, 0x74, 0x6f, 0x61, 0x20, 0x62, 0x72, 0x69,
  0x65, 0x66, 0x28, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x67, 0x72, 0x6f, 0x75,
  0x70, 0x73, 0x2e, 0x3b, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x65, 0x6e, 0x7a,
  0x79, 0x6d, 0x65, 0x73, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x20, 0x69, 0x6e,
  0x20, 0x6c, 0x61, 0x74, 0x65, 0x7b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x74,
  0x68, 0x65, 0x72, 0x61, 0x70, 0x79, 0x61, 0x20, 0x70, 0x6f, 0x69, 0x6e, 0x74,
  0x62, 0x61, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x3e,
  0x0a, 0x28, 0x29, 0x3b, 0x22, 0x20, 0x72, 0x65, 0x61, 0x20, 0x70, 0x6c, 0x61,
  0x63, 0x65, 0x5c, 0x75, 0x30, 0x30, 0x33, 0x43, 0x61, 0x61, 0x62, 0x6f, 0x75,
  0x74, 0x20, 0x61, 0x74, 0x72, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x63, 0x63, 0x6f,
  0x75, 0x6e, 0x74, 0x20, 0x67, 0x69, 0x76, 0x65, 0x73, 0x20, 0x61, 0x3c, 0x53,
  0x43, 0x52, 0x49, 0x50, 0x54, 0x52, 0x61, 0x69, 0x6c, 0x77, 0x61, 0x79, 0x74,
  0x68, 0x65, 0x6d, 0x65, 0x73, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x62, 0x6f, 0x78,
  0x42, 0x79, 0x49, 0x64, 0x28, 0x22, 0x78, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x73,
  0x2c, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x69, 0x6e, 0x20, 0x73, 0x6f,
  0x6d, 0x65, 0x20, 0x69, 0x66, 0x20, 0x28, 0x77, 0x69, 0x63, 0x6f, 0x6d, 0x69,
  0x6e, 0x67, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x20, 0x55, 0x6e,
  0x64, 0x65, 0x72, 0x20, 0x62, 0x75, 0x74, 0x20, 0x68, 0x61, 0x73, 0x68, 0x61,
  0x6e, 0x64, 0x65, 0x64, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x62, 0x79, 0x74,
  0x68, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x66, 0x65, 0x61, 0x72, 0x20, 0x6f, 0x66,
  0x64, 0x65, 0x6e, 0x6f, 0x74, 0x65, 0x64, 0x2f, 0x69, 0x66, 0x72, 0x61, 0x6d,
  0x65, 0x6c, 0x65, 0x66, 0x74, 0x20, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x74, 0x61,
  0x67, 0x65, 0x69, 0x6e, 0x20, 0x65, 0x61, 0x63, 0x68, 0x61, 0x26, 0x71, 0x75,
  0x6f, 0x74, 0x3b, 0x62, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x49, 0x6e, 0x20,
  0x6d, 0x61, 0x6e, 0x79, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x67, 0x6f, 0x72, 0x65,
  0x67, 0x69, 0x6d, 0x65, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x3c,
  0x2f, 0x70, 0x3e, 0x0d, 0x0a, 0x3c, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x61,
  0x3b, 0x26, 0x67, 0x74, 0x3b, 0x3c, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
  0x73, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x61, 0x74, 0x6d, 0x6f, 0x73, 0x74, 0x6c,
  0x79, 0x20, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x72, 0x65, 0x20, 0x73, 0x69, 0x7a,
  0x65, 0x3d, 0x22, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x68, 0x61, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x70, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48, 0x6f,
  0x73, 0x74, 0x20, 0x3d, 0x20, 0x57, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x66,
  0x65, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x56, 0x61, 0x72, 0x69, 0x6f, 0x75, 0x73,
  0x3d, 0x5b, 0x5d, 0x3b, 0x28, 0x66, 0x75, 0x63, 0x61, 0x6d, 0x65, 0x72, 0x61,
  0x73, 0x2f, 0x3e, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x61, 0x63, 0x74, 0x73, 0x20,
  0x61, 0x73, 0x49, 0x6e, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x3e, 0x0d, 0x0a, 0x0d,
  0x0a, 0x3c, 0x21, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x73, 0x20, 0x3c, 0x62,
  0x72, 0x20, 0x2f, 0x3e, 0x42, 0x65, 0x69, 0x6a, 0x69, 0x6e, 0x67, 0x63, 0x61,
  0x74, 0x61, 0x6c, 0xc3, 0xa0, 0x64, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x65,
  0x75, 0x72, 0x6f, 0x70, 0x65, 0x75, 0x65, 0x75, 0x73, 0x6b, 0x61, 0x72, 0x61,
  0x67, 0x61, 0x65, 0x69, 0x6c, 0x67, 0x65, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b,
  0x61, 0x65, 0x73, 0x70, 0x61, 0xc3, 0xb1, 0x61, 0x6d, 0x65, 0x6e, 0x73, 0x61,
  0x6a, 0x65, 0x75, 0x73, 0x75, 0x61, 0x72, 0x69, 0x6f, 0x74, 0x72, 0x61, 0x62,
  0x61, 0x6a, 0x6f, 0x6d, 0xc3, 0xa9, 0x78, 0x69, 0x63, 0x6f, 0x70, 0xc3, 0xa1,
  0x67, 0x69, 0x6e, 0x61, 0x73, 0x69, 0x65, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x69,
  0x73, 0x74, 0x65, 0x6d, 0x61, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x64,
  0x75, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x61, 0xc3, 0xb1, 0x61, 0x64, 0x69, 0x72,
  0x65, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x61, 0x6d, 0x6f, 0x6d, 0x65, 0x6e, 0x74,
  0x6f, 0x6e, 0x75, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x70, 0x72, 0x69, 0x6d, 0x65,
  0x72, 0x61, 0x74, 0x72, 0x61, 0x76, 0xc3, 0xa9, 0x73, 0x67, 0x72, 0x61, 0x63,
  0x69, 0x61, 0x73, 0x6e, 0x75, 0x65, 0x73, 0x74, 0x72, 0x61, 0x70, 0x72, 0x6f,
  0x63, 0x65, 0x73, 0x6f, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x63, 0x61,
  0x6c, 0x69, 0x64, 0x61, 0x64, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6e,
  0xc3, 0xba, 0x6d, 0x65, 0x72, 0x6f, 0x61, 0x63, 0x75, 0x65, 0x72, 0x64, 0x6f,
  0x6d, 0xc3, 0xba, 0x73, 0x69, 0x63, 0x61, 0x6d, 0x69, 0x65, 0x6d, 0x62, 0x72,
  0x6f, 0x6f, 0x66, 0x65, 0x72, 0x74, 0x61, 0x73, 0x61, 0x6c, 0x67, 0x75, 0x6e,
  0x6f, 0x73, 0x70, 0x61, 0xc3, 0xad, 0x73, 0x65, 0x73, 0x65, 0x6a, 0x65, 0x6d,
  0x70, 0x6c, 0x6f, 0x64, 0x65, 0x72, 0x65, 0x63, 0x68, 0x6f, 0x61, 0x64, 0x65,
  0x6d, 0xc3, 0xa1, 0x73, 0x70, 0x72, 0x69, 0x76, 0x61, 0x64, 0x6f, 0x61, 0x67,
  0x72, 0x65, 0x67, 0x61, 0x72, 0x65, 0x6e, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70,
  0x6f, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x65, 0x73,
  0x73, 0x65, 0x76, 0x69, 0x6c, 0x6c, 0x61, 0x70, 0x72, 0x69, 0x6d, 0x65, 0x72,
  0x6f, 0xc3, 0xba, 0x6c, 0x74, 0x69, 0x6d, 0x6f, 0x65, 0x76, 0x65, 0x6e, 0x74,
  0x6f, 0x73, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x6f, 0x63, 0x75, 0x6c, 0x74,
  0x75, 0x72, 0x61, 0x6d, 0x75, 0x6a, 0x65, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
  0x72, 0x61, 0x64, 0x61, 0x61, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x6f, 0x65, 0x6d,
  0x62, 0x61, 0x72, 0x67, 0x6f, 0x6d, 0x65, 0x72, 0x63, 0x61, 0x64, 0x6f, 0x67,
  0x72, 0x61, 0x6e, 0x64, 0x65, 0x73, 0x65, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f,
  0x6d, 0x65, 0x6a, 0x6f, 0x72, 0x65, 0x73, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72,
  0x6f, 0x64, 0x69, 0x73, 0x65, 0xc3, 0xb1, 0x6f, 0x74, 0x75, 0x72, 0x69, 0x73,
  0x6d, 0x6f, 0x63, 0xc3, 0xb3, 0x64, 0x69, 0x67, 0x6f, 0x70, 0x6f, 0x72, 0x74,
  0x61, 0x64, 0x61, 0x65, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6f, 0x66, 0x61, 0x6d,
  0x69, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x74, 0x6f, 0x6e, 0x69, 0x6f, 0x70, 0x65,
  0x72, 0x6d, 0x69, 0x74, 0x65, 0x67, 0x75, 0x61, 0x72, 0x64, 0x61, 0x72, 0x61,
  0x6c, 0x67, 0x75, 0x6e, 0x61, 0x73, 0x70, 0x72, 0x65, 0x63, 0x69, 0x6f, 0x73,
  0x61, 0x6c, 0x67, 0x75, 0x69, 0x65, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x64,
  0x6f, 0x76, 0x69, 0x73, 0x69, 0x74, 0x61, 0x73, 0x74, 0xc3, 0xad, 0x74, 0x75,
  0x6c, 0x6f, 0x63, 0x6f, 0x6e, 0x6f, 0x63, 0x65, 0x72, 0x73, 0x65, 0x67, 0x75,
  0x6e, 0x64, 0x6f, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6a, 0x6f, 0x66, 0x72, 0x61,
  0x6e, 0x63, 0x69, 0x61, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x6f, 0x73, 0x73, 0x65,
  0x67, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x6e, 0x65, 0x6d, 0x6f, 0x73, 0x65,
  0x66, 0x65, 0x63, 0x74, 0x6f, 0x73, 0x6d, 0xc3, 0xa1, 0x6c, 0x61, 0x67, 0x61,
  0x73, 0x65, 0x73, 0x69, 0xc3, 0xb3, 0x6e, 0x72, 0x65, 0x76, 0x69, 0x73, 0x74,
  0x61, 0x67, 0x72, 0x61, 0x6e, 0x61, 0x64, 0x61, 0x63, 0x6f, 0x6d, 0x70, 0x72,
  0x61, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x6f, 0x67, 0x61, 0x72, 0x63,
  0xc3, 0xad, 0x61, 0x61, 0x63, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x65, 0x63, 0x75,
  0x61, 0x64, 0x6f, 0x72, 0x71, 0x75, 0x69, 0x65, 0x6e, 0x65, 0x73, 0x69, 0x6e,
  0x63, 0x6c, 0x75, 0x73, 0x6f, 0x64, 0x65, 0x62, 0x65, 0x72, 0xc3, 0xa1, 0x6d,
  0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x68, 0x6f, 0x6d, 0x62, 0x72, 0x65, 0x73,
  0x6d, 0x75, 0x65, 0x73, 0x74, 0x72, 0x61, 0x70, 0x6f, 0x64, 0x72, 0xc3, 0xad,
  0x61, 0x6d, 0x61, 0xc3, 0xb1, 0x61, 0x6e, 0x61, 0xc3, 0xba, 0x6c, 0x74, 0x69,
  0x6d, 0x61, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x6f, 0x73, 0x6f, 0x66, 0x69, 0x63,
  0x69, 0x61, 0x6c, 0x74, 0x61, 0x6d, 0x62, 0x69, 0x65, 0x6e, 0x6e, 0x69, 0x6e,
  0x67, 0xc3, 0xba, 0x6e, 0x73, 0x61, 0x6c, 0x75, 0x64, 0x6f, 0x73, 0x70, 0x6f,
  0x64, 0x65, 0x6d, 0x6f, 0x73, 0x6d, 0x65, 0x6a, 0x6f, 0x72, 0x61, 0x72, 0x70,
  0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65,
  0x73, 0x73, 0x68, 0x6f, 0x6d, 0x65, 0x70, 0x61, 0x67, 0x65, 0x73, 0x65, 0x63,
  0x75, 0x72, 0x69, 0x74, 0x79, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
  0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x63, 0x61, 0x6d, 0x70, 0x61,
  0x69, 0x67, 0x6e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x63, 0x61,
  0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
  0x6c, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x65,
  0x72, 0x76, 0x65, 0x64, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65,
  0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x66, 0x61, 0x76, 0x6f, 0x72, 0x69,
  0x74, 0x65, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x6d, 0x69, 0x6c,
  0x69, 0x74, 0x61, 0x72, 0x79, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79,
  0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x6d, 0x61, 0x74, 0x65, 0x72,
  0x69, 0x61, 0x6c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x7a, 0x2d,
  0x69, 0x6e, 0x64, 0x65, 0x78, 0x3a, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
  0x73, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x65, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x70,
  0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c,
  0x65, 0x73, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x6d, 0x6f, 0x76,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
  0x62, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x74,
  0x69, 0x63, 0x73, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x72, 0x65,
  0x6c, 0x69, 0x67, 0x69, 0x6f, 0x6e, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61,
  0x6c, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x72, 0x65, 0x67, 0x69,
  0x73, 0x74, 0x65, 0x72, 0x70, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x64,
  0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
  0x6f, 0x6c, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x65, 0x74,
  0x74, 0x69, 0x6e, 0x67, 0x73, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
  0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x6c, 0x65, 0x61, 0x72, 0x6e,
  0x69, 0x6e, 0x67, 0x61, 0x6e, 0x79, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x61, 0x62,
  0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
  0x73, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x6d, 0x61, 0x67, 0x61,
  0x7a, 0x69, 0x6e, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x74,
  0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x70, 0x72, 0x65, 0x73, 0x73, 0x75,
  0x72, 0x65, 0x76, 0x61, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x20, 0x3c, 0x73, 0x74,
  0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
  0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x74, 0x6f, 0x67, 0x65, 0x74,
  0x68, 0x65, 0x72, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x62, 0x65,
  0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
  0x64, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x64, 0x66, 0x6f, 0x6f, 0x74,
  0x62, 0x61, 0x6c, 0x6c, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c,
  0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e,
  0x63, 0x65, 0x72, 0x65, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x74, 0x72, 0x61,
  0x63, 0x6b, 0x69, 0x6e, 0x67, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
  0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x73, 0x74, 0x75, 0x64, 0x65,
  0x6e, 0x74, 0x73, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6c, 0x79, 0x66, 0x69,
  0x67, 0x68, 0x74, 0x69, 0x6e, 0x67, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72,
  0x6e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x66, 0x65, 0x73, 0x74,
  0x69, 0x76, 0x61, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x6c,
  0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
  0x65, 0x74, 0x64, 0x72, 0x6f, 0x70, 0x64, 0x6f, 0x77, 0x6e, 0x70, 0x72, 0x61,
  0x63, 0x74, 0x69, 0x63, 0x65, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x61, 0x72, 0x72, 0x69,
  0x61, 0x67, 0x65, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x70, 0x72,
  0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x73, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76,
  0x65, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x61, 0x6e, 0x61, 0x6c,
  0x79, 0x73, 0x69, 0x73, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x62,
  0x61, 0x6e, 0x6e, 0x65, 0x72, 0x22, 0x3e, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61,
  0x73, 0x65, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x72, 0x65, 0x67,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x76, 0x65,
  0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x62, 0x6f, 0x6f, 0x6b, 0x6d,
  0x61, 0x72, 0x6b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x72, 0x63, 0x68,
  0x65, 0x6d, 0x69, 0x63, 0x61, 0x6c, 0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f,
  0x6e, 0x63, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x73, 0x65, 0x70, 0x61,
  0x72, 0x61, 0x74, 0x65, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x63,
  0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x68, 0x61, 0x72, 0x64, 0x77, 0x61,
  0x72, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x64, 0x65, 0x6c,
  0x69, 0x76, 0x65, 0x72, 0x79, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e,
  0x6f, 0x62, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x3d, 0x20, 0x66, 0x61, 0x6c,
  0x73, 0x65, 0x3b, 0x66, 0x6f, 0x72, 0x28, 0x76, 0x61, 0x72, 0x20, 0x61, 0x63,
  0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
  0x79, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x69, 0x64, 0x65, 0x6e,
  0x74, 0x69, 0x74, 0x79, 0x61, 0x69, 0x72, 0x63, 0x72, 0x61, 0x66, 0x74, 0x65,
  0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73,
  0x65, 0x64, 0x64, 0x6f, 0x6d, 0x65, 0x73, 0x74, 0x69, 0x63, 0x69, 0x6e, 0x63,
  0x6c, 0x75, 0x64, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64,
  0x68, 0x6f, 0x73, 0x70, 0x69, 0x74, 0x61, 0x6c, 0x76, 0x65, 0x72, 0x74, 0x69,
  0x63, 0x61, 0x6c, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x61, 0x70,
  0x70, 0x72, 0x6f, 0x61, 0x63, 0x68, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
  0x73, 0x6c, 0x6f, 0x67, 0x6f, 0x22, 0x3e, 0x3c, 0x61, 0x64, 0x61, 0x75, 0x67,
  0x68, 0x74, 0x65, 0x72, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x22, 0x20, 0x63,
  0x75, 0x6c, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69,
  0x65, 0x73, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x61, 0x73, 0x73,
  0x65, 0x6d, 0x62, 0x6c, 0x79, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x66, 0x75, 0x6c,
  0x74, 0x65, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x66, 0x69, 0x6e, 0x69, 0x73,
  0x68, 0x65, 0x64, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x63, 0x72,
  0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x63, 0x67, 0x69, 0x2d, 0x62, 0x69, 0x6e,
  0x2f, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x72, 0x65, 0x71, 0x75,
  0x69, 0x72, 0x65, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x62,
  0x65, 0x63, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
  0x65, 0x73, 0x61, 0x63, 0x61, 0x64, 0x65, 0x6d, 0x69, 0x63, 0x65, 0x78, 0x65,
  0x72, 0x63, 0x69, 0x73, 0x65, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79,
  0x6d, 0x65, 0x64, 0x69, 0x63, 0x69, 0x6e, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x74,
  0x61, 0x6e, 0x74, 0x61, 0x63, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x4d, 0x61,
  0x67, 0x61, 0x7a, 0x69, 0x6e, 0x65, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
  0x74, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x62, 0x6f, 0x74, 0x74,
  0x6f, 0x6d, 0x22, 0x3e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x3a,
  0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64,
  0x65, 0x64, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x53, 0x6f, 0x66,
  0x74, 0x77, 0x61, 0x72, 0x65, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
  0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x6e,
  0x67, 0x74, 0x68, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x73, 0x6c,
  0x69, 0x67, 0x68, 0x74, 0x6c, 0x79, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x69, 0x6e,
  0x67, 0x74, 0x65, 0x78, 0x74, 0x61, 0x72, 0x65, 0x61, 0x63, 0x75, 0x72, 0x72,
  0x65, 0x6e, 0x63, 0x79, 0x65, 0x76, 0x65, 0x72, 0x79, 0x6f, 0x6e, 0x65, 0x73,
  0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
  0x65, 0x72, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x70, 0x72, 0x6f,
  0x64, 0x75, 0x63, 0x65, 0x64, 0x68, 0x65, 0x72, 0x69, 0x74, 0x61, 0x67, 0x65,
  0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x61, 0x62, 0x73, 0x6f, 0x6c,
  0x75, 0x74, 0x65, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x72, 0x65,
  0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x22,
  0x20, 0x76, 0x69, 0x6f, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x61, 0x6e, 0x79, 0x77,
  0x68, 0x65, 0x72, 0x65, 0x62, 0x65, 0x6e, 0x65, 0x66, 0x69, 0x74, 0x73, 0x6c,
  0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x64, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74,
  0x6c, 0x79, 0x61, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x66, 0x6f, 0x6c,
  0x6c, 0x6f, 0x77, 0x65, 0x64, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65,
  0x62, 0x75, 0x6c, 0x6c, 0x65, 0x74, 0x69, 0x6e, 0x69, 0x6e, 0x63, 0x6c, 0x75,
  0x64, 0x65, 0x64, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x64, 0x69, 0x6e,
  0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x24, 0x28, 0x74, 0x68, 0x69, 0x73, 0x29,
  0x2e, 0x72, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x3e, 0x3c, 0x74, 0x72,
  0x3e, 0x3c, 0x74, 0x64, 0x63, 0x6f, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x72,
  0x65, 0x63, 0x6f, 0x72, 0x64, 0x65, 0x64, 0x75, 0x6c, 0x74, 0x69, 0x6d, 0x61,
  0x74, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x3c, 0x75, 0x6c,
  0x20, 0x69, 0x64, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
  0x48, 0x6f, 0x6d, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x77, 0x65, 0x62, 0x73, 0x69,
  0x74, 0x65, 0x73, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x61, 0x6c,
  0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x72, 0x65, 0x6c,
  0x79, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x6d, 0x65, 0x73, 0x73,
  0x61, 0x67, 0x65, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x61,
  0x63, 0x74, 0x69, 0x76, 0x65, 0x22, 0x3e, 0x73, 0x6f, 0x6d, 0x65, 0x77, 0x68,
  0x61, 0x74, 0x76, 0x69, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x57, 0x65, 0x73,
  0x74, 0x65, 0x72, 0x6e, 0x20, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22,
  0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
  0x61, 0x63, 0x74, 0x76, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x44, 0x6f,
  0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74,
  0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3e, 0x0a, 0x6d, 0x65, 0x61, 0x73,
  0x75, 0x72, 0x65, 0x73, 0x77, 0x69, 0x64, 0x74, 0x68, 0x20, 0x3d, 0x20, 0x76,
  0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76,
  0x65, 0x64, 0x76, 0x69, 0x72, 0x67, 0x69, 0x6e, 0x69, 0x61, 0x6e, 0x6f, 0x72,
  0x6d, 0x61, 0x6c, 0x6c, 0x79, 0x68, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x65, 0x64,
  0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x73, 0x74, 0x61, 0x6e, 0x64,
  0x69, 0x6e, 0x67, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65,
  0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65,
  0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x61, 0x63, 0x63, 0x75,
  0x72, 0x61, 0x74, 0x65, 0x62, 0x69, 0x72, 0x74, 0x68, 0x64, 0x61, 0x79, 0x73,
  0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69,
  0x61, 0x6c, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x73, 0x63, 0x72, 0x69,
  0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x79,
  0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x6f,
  0x6e, 0x61, 0x6c, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x76, 0x61,
  0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x61, 0x63, 0x68, 0x69, 0x65, 0x76, 0x65,
  0x64, 0x2e, 0x6a, 0x70, 0x67, 0x22, 0x20, 0x2f, 0x3e, 0x6d, 0x61, 0x63, 0x68,
  0x69, 0x6e, 0x65, 0x73, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0a, 0x20, 0x20, 0x6b,
  0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64,
  0x6c, 0x79, 0x62, 0x72, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x6d,
  0x62, 0x69, 0x6e, 0x65, 0x64, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
  0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x65, 0x78, 0x70, 0x65, 0x63,
  0x74, 0x65, 0x64, 0x61, 0x64, 0x65, 0x71, 0x75, 0x61, 0x74, 0x65, 0x70, 0x61,
  0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x22,
  0x20, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x62, 0x6c, 0x65, 0x3c, 0x2f, 0x6c, 0x61,
  0x62, 0x65, 0x6c, 0x3e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x62,
  0x72, 0x69, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61,
  0x73, 0x65, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6f, 0x72, 0x70, 0x6c, 0x75,
  0x67, 0x69, 0x6e, 0x73, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x22, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x22, 0x20, 0x28, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x67, 0x72,
  0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e,
  0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6c, 0x61,
  0x79, 0x73, 0x69, 0x61, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x6d,
  0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x3b, 0x68, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x63, 0x68, 0x61,
  0x6e, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x74, 0x6f, 0x20,
  0x63, 0x61, 0x74, 0x68, 0x6f, 0x6c, 0x69, 0x63, 0x70, 0x61, 0x74, 0x74, 0x65,
  0x72, 0x6e, 0x73, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x20, 0x23, 0x67, 0x72,
  0x65, 0x61, 0x74, 0x65, 0x73, 0x74, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65,
  0x73, 0x72, 0x65, 0x6c, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x3c, 0x2f, 0x75, 0x6c,
  0x3e, 0x0a, 0x09, 0x09, 0x3c, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x20, 0x63,
  0x69, 0x74, 0x69, 0x7a, 0x65, 0x6e, 0x73, 0x63, 0x6c, 0x6f, 0x74, 0x68, 0x69,
  0x6e, 0x67, 0x77, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x3c, 0x6c, 0x69,
  0x20, 0x69, 0x64, 0x3d, 0x22, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,
  0x63, 0x61, 0x72, 0x72, 0x79, 0x69, 0x6e, 0x67, 0x73, 0x65, 0x6e, 0x74, 0x65,
  0x6e, 0x63, 0x65, 0x3c, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3e, 0x63, 0x6f,
  0x6e, 0x74, 0x72, 0x61, 0x73, 0x74, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e,
  0x67, 0x63, 0x61, 0x74, 0x63, 0x68, 0x28, 0x65, 0x29, 0x73, 0x6f, 0x75, 0x74,
  0x68, 0x65, 0x72, 0x6e, 0x4d, 0x69, 0x63, 0x68, 0x61, 0x65, 0x6c, 0x20, 0x6d,
  0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x63, 0x61, 0x72, 0x6f, 0x75, 0x73,
  0x65, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x69, 0x6f, 0x72, 0x2e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x28, 0x22,
  0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x74, 0x6f, 0x62,
  0x65, 0x72, 0x20, 0x29, 0x7b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x6d,
  0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x2d, 0x2d, 0x26, 0x67, 0x74, 0x3b, 0x0a,
  0x0a, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x63, 0x68, 0x61, 0x69,
  0x72, 0x6d, 0x61, 0x6e, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x20, 0x2f, 0x3e, 0x73,
  0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x69, 0x63, 0x68, 0x61, 0x72,
  0x64, 0x20, 0x77, 0x68, 0x61, 0x74, 0x65, 0x76, 0x65, 0x72, 0x70, 0x72, 0x6f,
  0x62, 0x61, 0x62, 0x6c, 0x79, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
  0x62, 0x61, 0x73, 0x65, 0x62, 0x61, 0x6c, 0x6c, 0x6a, 0x75, 0x64, 0x67, 0x6d,
  0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x2e, 0x63,
  0x73, 0x73, 0x22, 0x20, 0x2f, 0x3e, 0x20, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74,
  0x65, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x64, 0x65, 0x66, 0x61,
  0x75, 0x6c, 0x74, 0x22, 0x2f, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x0d, 0x0a, 0x65,
  0x6c, 0x65, 0x63, 0x74, 0x72, 0x69, 0x63, 0x73, 0x63, 0x6f, 0x74, 0x6c, 0x61,
  0x6e, 0x64, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x71, 0x75, 0x61,
  0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x20, 0x49, 0x53, 0x42, 0x4e, 0x20, 0x30,
  0x64, 0x69, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x61,
  0x6e, 0x63, 0x65, 0x2d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2d, 0x22, 0x20,
  0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72,
  0x73, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x73, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x73, 0x6d,
  0x69, 0x6e, 0x69, 0x73, 0x74, 0x65, 0x72, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x74, 0x61,
  0x6c, 0x69, 0x61, 0x6e, 0x6f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61,
  0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x6c, 0x79, 0x3a, 0x20, 0x27, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x27, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x27, 0x63, 0x6f,
  0x76, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x69, 0x6e,
  0x67, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x42, 0x72, 0x69, 0x74,
  0x69, 0x73, 0x68, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x46,
  0x61, 0x63, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x6f,
  0x75, 0x73, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x63, 0x6f, 0x6e,
  0x63, 0x65, 0x72, 0x6e, 0x73, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e,
  0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x76, 0x20, 0x69,
  0x64, 0x3d, 0x22, 0x57, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6d, 0x20, 0x70, 0x72,
  0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x73, 0x65, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x61, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x66,
  0x6c, 0x65, 0x78, 0x69, 0x62, 0x6c, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
  0x72, 0x79, 0x6c, 0x61, 0x77, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x3c, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x3d, 0x22,
  0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x6d, 0x61, 0x78, 0x69,
  0x6d, 0x75, 0x6d, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x3c, 0x2f,
  0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
  0x73, 0x68, 0x61, 0x6d, 0x69, 0x6c, 0x74, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72,
  0x65, 0x6e, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x63,
  0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x74, 0x68, 0x65, 0x6d, 0x65,
  0x73, 0x2f, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x6f, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x61, 0x6c,
  0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x22, 0x69, 0x6e, 0x74, 0x65, 0x72,
  0x76, 0x61, 0x6c, 0x77, 0x69, 0x72, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x65, 0x6e,
  0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x63, 0x69, 0x65,
  0x73, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x20, 0x6d, 0x65, 0x61, 0x73,
  0x75, 0x72, 0x65, 0x64, 0x74, 0x68, 0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64, 0x73,
  0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x26, 0x68, 0x65, 0x6c, 0x6c, 0x69,
  0x70, 0x3b, 0x6e, 0x65, 0x77, 0x20, 0x44, 0x61, 0x74, 0x65, 0x22, 0x20, 0x73,
  0x69, 0x7a, 0x65, 0x3d, 0x22, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65,
  0x6d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x22, 0x20, 0x22, 0x20, 0x2f, 0x3e, 0x3c,
  0x2f, 0x61, 0x3e, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x3e, 0x73, 0x65,
  0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61,
  0x6c, 0x6f, 0x76, 0x65, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x6f, 0x70, 0x69, 0x6e,
  0x69, 0x6f, 0x6e, 0x73, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x6f, 0x69, 0x73, 0x6c,
  0x69, 0x6e, 0x6b, 0x73, 0x22, 0x3e, 0x0a, 0x09, 0x3c, 0x74, 0x69, 0x74, 0x6c,
  0x65, 0x3e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x61, 0x74,
  0x75, 0x72, 0x64, 0x61, 0x79, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c,
  0x69, 0x74, 0x65, 0x6d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
  0x65, 0x65, 0x72, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x64, 0x65,
  0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
  0x6c, 0x3d, 0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x45, 0x73, 0x70, 0x61,
  0xc3, 0xb1, 0x6f, 0x6c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x73,
  0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x65, 0x72, 0x26, 0x71, 0x75, 0x6f,
  0x74, 0x3b, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x79, 0x6d,
  0x70, 0x74, 0x6f, 0x6d, 0x73, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x64,
  0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x69, 0x67, 0x68, 0x74,
  0x22, 0x3e, 0x3c, 0x70, 0x6c, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x73, 0x74,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
  0x2e, 0x6c, 0x65, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x20, 0x62, 0x6f, 0x72,
  0x64, 0x65, 0x72, 0x3d, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x63,
  0x65, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x3e, 0x2e, 0x0a, 0x0a, 0x53, 0x6f, 0x6d,
  0x65, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x73, 0x75, 0x69,
  0x74, 0x61, 0x62, 0x6c, 0x65, 0x62, 0x75, 0x6c, 0x67, 0x61, 0x72, 0x69, 0x61,
  0x2e, 0x73, 0x68, 0x6f, 0x77, 0x28, 0x29, 0x3b, 0x64, 0x65, 0x73, 0x69, 0x67,
  0x6e, 0x65, 0x64, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x63, 0x6f,
  0x6e, 0x63, 0x65, 0x70, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
  0x73, 0x77, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6d, 0x73, 0x4f, 0x72, 0x69, 0x67,
  0x69, 0x6e, 0x61, 0x6c, 0x22, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x73,
  0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x3e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
  0x6f, 0x72, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x61, 0x20, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x76, 0x69, 0x73,
  0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x0a, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x79, 0x6f,
  0x75, 0x72, 0x73, 0x65, 0x6c, 0x66, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
  0x20, 0x6d, 0x69, 0x63, 0x68, 0x69, 0x67, 0x61, 0x6e, 0x45, 0x6e, 0x67, 0x6c,
  0x69, 0x73, 0x68, 0x20, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x62, 0x69, 0x61, 0x70,
  0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x69,
  0x6e, 0x67, 0x64, 0x72, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x66, 0x61, 0x63,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64,
  0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x66, 0x69, 0x63,
  0x65, 0x72, 0x73, 0x52, 0x75, 0x73, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x67, 0x65,
  0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x2d, 0x38, 0x38, 0x35, 0x39, 0x2d, 0x31,
  0x22, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x66, 0x61, 0x6d, 0x69,
  0x6c, 0x69, 0x61, 0x72, 0x20, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x6d,
  0x61, 0x72, 0x67, 0x69, 0x6e, 0x3a, 0x30, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65,
  0x6e, 0x74, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x63, 0x6f, 0x6e,
  0x74, 0x61, 0x63, 0x74, 0x73, 0x2d, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x3e,
  0x70, 0x6f, 0x72, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x6c, 0x65, 0x6e, 0x67,
  0x74, 0x68, 0x20, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x69, 0x6e,
  0x76, 0x6f, 0x6c, 0x76, 0x65, 0x73, 0x61, 0x74, 0x6c, 0x61, 0x6e, 0x74, 0x69,
  0x63, 0x6f, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x3d, 0x22, 0x64, 0x65, 0x66, 0x61,
  0x75, 0x6c, 0x74, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x70,
  0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61,
  0x72, 0x79, 0x0a, 0x0a, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x67, 0x75, 0x69,
  0x64, 0x61, 0x6e, 0x63, 0x65, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x74, 0x64,
  0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x6d, 0x69, 0x64, 0x64, 0x6c,
  0x65, 0x22, 0x3e, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x64, 0x69,
  0x73, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x73, 0x63, 0x6f, 0x74, 0x74, 0x69, 0x73,
  0x68, 0x6a, 0x6f, 0x6e, 0x61, 0x74, 0x68, 0x61, 0x6e, 0x6d, 0x61, 0x6a, 0x6f,
  0x72, 0x69, 0x74, 0x79, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x63,
  0x6c, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x74, 0x68, 0x61, 0x69, 0x6c, 0x61,
  0x6e, 0x64, 0x74, 0x65, 0x61, 0x63, 0x68, 0x65, 0x72, 0x73, 0x3c, 0x68, 0x65,
  0x61, 0x64, 0x3e, 0x0a, 0x09, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64,
  0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x70, 0x6f, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x3b, 0x74, 0x6f, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x3c, 0x2f,
  0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x3e, 0x6f, 0x6b, 0x6c, 0x61, 0x68, 0x6f, 0x6d,
  0x61, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x76, 0x65,
  0x73, 0x74, 0x6f, 0x72, 0x30, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22, 0x68,
  0x6f, 0x6c, 0x69, 0x64, 0x61, 0x79, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
  0x63, 0x65, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x20, 0x28, 0x77,
  0x68, 0x69, 0x63, 0x68, 0x20, 0x2e, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20,
  0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x76, 0x69, 0x73, 0x69, 0x74,
  0x69, 0x6e, 0x67, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x72, 0x70, 0x72,
  0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22,
  0x20, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x22, 0x71, 0x75, 0x69, 0x63,
  0x6b, 0x6c, 0x79, 0x20, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x65,
  0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x3b, 0x72, 0x65, 0x74, 0x75, 0x72,
  0x6e, 0x20, 0x3b, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x20, 0x68, 0x65,
  0x69, 0x67, 0x68, 0x74, 0x3d, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
  0x2c, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x20, 0x63, 0x68, 0x65, 0x63,
  0x6b, 0x65, 0x64, 0x2e, 0x6d, 0x69, 0x6e, 0x2e, 0x6a, 0x73, 0x22, 0x6d, 0x61,
  0x67, 0x6e, 0x65, 0x74, 0x69, 0x63, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f,
  0x68, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x2e, 0x20, 0x57, 0x68,
  0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x75, 0x72, 0x73, 0x64, 0x61, 0x79, 0x64,
  0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x26, 0x65, 0x61, 0x63, 0x75, 0x74,
  0x65, 0x3b, 0x68, 0x61, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x76, 0x61,
  0x6c, 0x75, 0x61, 0x74, 0x65, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67,
  0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x61, 0x74, 0x69, 0x65,
  0x6e, 0x74, 0x73, 0x20, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x20, 0x63, 0x6f,
  0x6c, 0x6f, 0x72, 0x61, 0x64, 0x6f, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x22, 0x63, 0x61, 0x6d, 0x70, 0x62, 0x65, 0x6c, 0x6c, 0x3c, 0x21, 0x2d, 0x2d,
  0x20, 0x65, 0x6e, 0x64, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x3c,
  0x62, 0x72, 0x20, 0x2f, 0x3e, 0x0d, 0x0a, 0x5f, 0x70, 0x6f, 0x70, 0x75, 0x70,
  0x73, 0x7c, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2c, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x20, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x20,
  0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x20, 0x61, 0x73, 0x73, 0x69, 0x67,
  0x6e, 0x65, 0x64, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x3c, 0x62,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x6c, 0x65, 0x26, 0x71, 0x75, 0x6f, 0x74,
  0x3b, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x20, 0x43, 0x6f, 0x6d,
  0x70, 0x61, 0x6e, 0x79, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x3c,
  0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76,
  0x65, 0x73, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x6d, 0x61, 0x72,
  0x73, 0x68, 0x61, 0x6c, 0x6c, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x6c, 0x79, 0x29, 0x2e, 0x0a, 0x0a, 0x54,
  0x68, 0x65, 0x20, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x6d, 0x75,
  0x63, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e,
  0x0a, 0x22, 0x20, 0x64, 0x61, 0x74, 0x61, 0x2d, 0x73, 0x72, 0x74, 0x75, 0x67,
  0x75, 0xc3, 0xaa, 0x73, 0x73, 0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x54, 0x6f, 0x20,
  0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e,
  0x0d, 0x0a, 0x61, 0x74, 0x74, 0x6f, 0x72, 0x6e, 0x65, 0x79, 0x65, 0x6d, 0x70,
  0x68, 0x61, 0x73, 0x69, 0x73, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x6f, 0x72, 0x73,
  0x66, 0x61, 0x6e, 0x63, 0x79, 0x62, 0x6f, 0x78, 0x77, 0x6f, 0x72, 0x6c, 0x64,
  0x27, 0x73, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x68,
  0x65, 0x63, 0x6b, 0x65, 0x64, 0x3d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
  0x73, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x70, 0x78, 0x3b, 0x66,
  0x6f, 0x6e, 0x74, 0x2d, 0x20, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x6a,
  0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x73, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76,
  0x65, 0x64, 0x76, 0x61, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x68, 0x6f,
  0x6d, 0x70, 0x73, 0x6f, 0x6e, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x69, 0x6e, 0x67,
  0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69,
  0x61, 0x6c, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x30, 0x63, 0x68,
  0x65, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x3c, 0x2f, 0x74, 0x62, 0x6f, 0x64, 0x79,
  0x3e, 0x3c, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x20, 0x43, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x65, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x66, 0x69, 0x78, 0x0a,
  0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c,
  0x65, 0x20, 0x3c, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x69, 0x6e,
  0x64, 0x69, 0x6e, 0x67, 0x73, 0x72, 0x6f, 0x6c, 0x65, 0x20, 0x69, 0x6e, 0x20,
  0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x20, 0x4f, 0x63, 0x74, 0x6f,
  0x62, 0x65, 0x72, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x20, 0x65, 0x78,
  0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x20, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x6f, 0x70, 0x65, 0x72,
  0x61, 0x74, 0x65, 0x64, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x65,
  0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
  0x64, 0x73, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x20, 0x6e, 0x75,
  0x6d, 0x62, 0x65, 0x72, 0x73, 0x20, 0x20, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x6f, 0x6e, 0x53, 0x75, 0x62,
  0x6d, 0x69, 0x74, 0x6d, 0x61, 0x72, 0x79, 0x6c, 0x61, 0x6e, 0x64, 0x63, 0x6f,
  0x6c, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
  0x63, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x63, 0x74, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49, 0x6e, 0x61,
  0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x73, 0x69, 0x62, 0x6c, 0x69, 0x6e,
  0x67, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x73, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x29, 0x73, 0x2e, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20,
  0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x63, 0x68, 0x65, 0x63, 0x6b,
  0x62, 0x6f, 0x78, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x73, 0x70, 0x72,
  0x65, 0x67, 0x6e, 0x61, 0x6e, 0x74, 0x74, 0x6f, 0x6d, 0x6f, 0x72, 0x72, 0x6f,
  0x77, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x69, 0x63, 0x6f, 0x6e,
  0x2e, 0x70, 0x6e, 0x67, 0x6a, 0x61, 0x70, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x63,
  0x6f, 0x64, 0x65, 0x62, 0x61, 0x73, 0x65, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e,
  0x22, 0x3e, 0x67, 0x61, 0x6d, 0x62, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x75, 0x63,
  0x68, 0x20, 0x61, 0x73, 0x20, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20,
  0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x20, 0x6d, 0x69, 0x73, 0x73, 0x6f,
  0x75, 0x72, 0x69, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x74, 0x6f,
  0x70, 0x3a, 0x31, 0x70, 0x78, 0x20, 0x2e, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e,
  0x3e, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x77, 0x69, 0x64, 0x74,
  0x68, 0x3d, 0x22, 0x32, 0x6c, 0x61, 0x7a, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x6e,
  0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x75, 0x73, 0x65, 0x64, 0x20, 0x69,
  0x6e, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x22, 0x3e, 0x0a, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x2f,
  0x3c, 0x74, 0x72, 0x3e, 0x3c, 0x74, 0x64, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x3a, 0x32, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x63, 0x6f,
  0x75, 0x6e, 0x74, 0x72, 0x79, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
  0x20, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x22, 0x20, 0x26, 0x6c, 0x74, 0x3b,
  0x21, 0x2d, 0x2d, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x3e, 0x3c, 0x2f,
  0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d,
  0x3e, 0x0a, 0x28, 0xe7, 0xae, 0x80, 0xe4, 0xbd, 0x93, 0x29, 0x28, 0xe7, 0xb9,
  0x81, 0xe9, 0xab, 0x94, 0x29, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69,
  0x69, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x6f, 0x72, 0x6f, 0x6d, 0xc3, 0xa2,
  0x6e, 0xc4, 0x83, 0x74, 0xc3, 0xbc, 0x72, 0x6b, 0xc3, 0xa7, 0x65, 0xd8, 0xa7,
  0xd8, 0xb1, 0xd8, 0xaf, 0xd9, 0x88, 0x74, 0x61, 0x6d, 0x62, 0x69, 0xc3, 0xa9,
  0x6e, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x69, 0x61, 0x73, 0x6d, 0x65, 0x6e, 0x73,
  0x61, 0x6a, 0x65, 0x73, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x73, 0x64,
  0x65, 0x72, 0x65, 0x63, 0x68, 0x6f, 0x73, 0x6e, 0x61, 0x63, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x69, 0x6f, 0x63, 0x6f, 0x6e,
  0x74, 0x61, 0x63, 0x74, 0x6f, 0x75, 0x73, 0x75, 0x61, 0x72, 0x69, 0x6f, 0x73,
  0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x61, 0x67, 0x6f, 0x62, 0x69, 0x65,
  0x72, 0x6e, 0x6f, 0x65, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x61, 0x73, 0x61, 0x6e,
  0x75, 0x6e, 0x63, 0x69, 0x6f, 0x73, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x69,
  0x61, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x64, 0x65, 0x73, 0x70,
  0x75, 0xc3, 0xa9, 0x73, 0x64, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x73, 0x70,
  0x72, 0x6f, 0x79, 0x65, 0x63, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
  0x74, 0x6f, 0x70, 0xc3, 0xba, 0x62, 0x6c, 0x69, 0x63, 0x6f, 0x6e, 0x6f, 0x73,
  0x6f, 0x74, 0x72, 0x6f, 0x73, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x61,
  0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6d, 0x69, 0x6c, 0x6c, 0x6f,
  0x6e, 0x65, 0x73, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x74, 0x65, 0x70, 0x72,
  0x65, 0x67, 0x75, 0x6e, 0x74, 0x61, 0x61, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6f,
  0x72, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x73, 0x70, 0x72, 0x6f, 0x62,
  0x6c, 0x65, 0x6d, 0x61, 0x73, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x67, 0x6f, 0x6e,
  0x75, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x73, 0x6f, 0x70, 0x69, 0x6e, 0x69, 0xc3,
  0xb3, 0x6e, 0x69, 0x6d, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x72, 0x6d, 0x69, 0x65,
  0x6e, 0x74, 0x72, 0x61, 0x73, 0x61, 0x6d, 0xc3, 0xa9, 0x72, 0x69, 0x63, 0x61,
  0x76, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x6f, 0x72, 0x73, 0x6f, 0x63, 0x69, 0x65,
  0x64, 0x61, 0x64, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x65,
  0x61, 0x6c, 0x69, 0x7a, 0x61, 0x72, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
  0x6f, 0x70, 0x61, 0x6c, 0x61, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6e, 0x74, 0x65,
  0x72, 0xc3, 0xa9, 0x73, 0x65, 0x6e, 0x74, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x65,
  0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x6d, 0x69, 0x65, 0x6d, 0x62, 0x72,
  0x6f, 0x73, 0x72, 0x65, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x64, 0x63, 0xc3, 0xb3,
  0x72, 0x64, 0x6f, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x61, 0x67, 0x6f, 0x7a, 0x61,
  0x70, 0xc3, 0xa1, 0x67, 0x69, 0x6e, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61,
  0x6c, 0x65, 0x73, 0x62, 0x6c, 0x6f, 0x71, 0x75, 0x65, 0x61, 0x72, 0x67, 0x65,
  0x73, 0x74, 0x69, 0xc3, 0xb3, 0x6e, 0x61, 0x6c, 0x71, 0x75, 0x69, 0x6c, 0x65,
  0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6d, 0x61, 0x73, 0x63, 0x69, 0x65, 0x6e,
  0x63, 0x69, 0x61, 0x73, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x6f, 0x76,
  0x65, 0x72, 0x73, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x74, 0x61, 0x65, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x73, 0x70, 0xc3, 0xba,
  0x62, 0x6c, 0x69, 0x63, 0x61, 0x6f, 0x62, 0x6a, 0x65, 0x74, 0x69, 0x76, 0x6f,
  0x61, 0x6c, 0x69, 0x63, 0x61, 0x6e, 0x74, 0x65, 0x62, 0x75, 0x73, 0x63, 0x61,
  0x64, 0x6f, 0x72, 0x63, 0x61, 0x6e, 0x74, 0x69, 0x64, 0x61, 0x64, 0x65, 0x6e,
  0x74, 0x72, 0x61, 0x64, 0x61, 0x73, 0x61, 0x63, 0x63, 0x69, 0x6f, 0x6e, 0x65,
  0x73, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x6f, 0x73, 0x73, 0x75, 0x70, 0x65,
  0x72, 0x69, 0x6f, 0x72, 0x6d, 0x61, 0x79, 0x6f, 0x72, 0xc3, 0xad, 0x61, 0x61,
  0x6c, 0x65, 0x6d, 0x61, 0x6e, 0x69, 0x61, 0x66, 0x75, 0x6e, 0x63, 0x69, 0xc3,
  0xb3, 0x6e, 0xc3, 0xba, 0x6c, 0x74, 0x69, 0x6d, 0x6f, 0x73, 0x68, 0x61, 0x63,
  0x69, 0x65, 0x6e, 0x64, 0x6f, 0x61, 0x71, 0x75, 0x65, 0x6c, 0x6c, 0x6f, 0x73,
  0x65, 0x64, 0x69, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x66, 0x65, 0x72, 0x6e, 0x61,
  0x6e, 0x64, 0x6f, 0x61, 0x6d, 0x62, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x66, 0x61,
  0x63, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x6e, 0x75, 0x65, 0x73, 0x74, 0x72, 0x61,
  0x73, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x63,
  0x65, 0x73, 0x6f, 0x73, 0x62, 0x61, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x65, 0x70,
  0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
  0x61, 0x72, 0x63, 0x6f, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x6f, 0x70, 0x75, 0x62,
  0x6c, 0x69, 0x63, 0x61, 0x72, 0x63, 0x6f, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x6f,
  0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x6a, 0xc3, 0xb3, 0x76, 0x65,
  0x6e, 0x65, 0x73, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x74, 0xc3,
  0xa9, 0x63, 0x6e, 0x69, 0x63, 0x61, 0x63, 0x6f, 0x6e, 0x6a, 0x75, 0x6e, 0x74,
  0x6f, 0x65, 0x6e, 0x65, 0x72, 0x67, 0xc3, 0xad, 0x61, 0x74, 0x72, 0x61, 0x62,
  0x61, 0x6a, 0x61, 0x72, 0x61, 0x73, 0x74, 0x75, 0x72, 0x69, 0x61, 0x73, 0x72,
  0x65, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a,
  0x61, 0x72, 0x62, 0x6f, 0x6c, 0x65, 0x74, 0xc3, 0xad, 0x6e, 0x73, 0x61, 0x6c,
  0x76, 0x61, 0x64, 0x6f, 0x72, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x61,
  0x74, 0x72, 0x61, 0x62, 0x61, 0x6a, 0x6f, 0x73, 0x70, 0x72, 0x69, 0x6d, 0x65,
  0x72, 0x6f, 0x73, 0x6e, 0x65, 0x67, 0x6f, 0x63, 0x69, 0x6f, 0x73, 0x6c, 0x69,
  0x62, 0x65, 0x72, 0x74, 0x61, 0x64, 0x64, 0x65, 0x74, 0x61, 0x6c, 0x6c, 0x65,
  0x73, 0x70, 0x61, 0x6e, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x70, 0x72, 0xc3, 0xb3,
  0x78, 0x69, 0x6d, 0x6f, 0x61, 0x6c, 0x6d, 0x65, 0x72, 0xc3, 0xad, 0x61, 0x61,
  0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x65, 0x73, 0x71, 0x75, 0x69, 0xc3, 0xa9, 0x6e,
  0x65, 0x73, 0x63, 0x6f, 0x72, 0x61, 0x7a, 0xc3, 0xb3, 0x6e, 0x73, 0x65, 0x63,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x62, 0x75, 0x73, 0x63, 0x61, 0x6e, 0x64, 0x6f,
  0x6f, 0x70, 0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x65, 0x78, 0x74, 0x65, 0x72,
  0x69, 0x6f, 0x72, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x6f, 0x74, 0x6f,
  0x64, 0x61, 0x76, 0xc3, 0xad, 0x61, 0x67, 0x61, 0x6c, 0x65, 0x72, 0xc3, 0xad,
  0x61, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x69,
  0x63, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x63,
  0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x74, 0x61, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74,
  0x6f, 0x73, 0x63, 0x72, 0xc3, 0xad, 0x74, 0x69, 0x63, 0x61, 0x64, 0xc3, 0xb3,
  0x6c, 0x61, 0x72, 0x65, 0x73, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x63, 0x69, 0x61,
  0x64, 0x65, 0x62, 0x65, 0x72, 0xc3, 0xa1, 0x6e, 0x70, 0x65, 0x72, 0xc3, 0xad,
  0x6f, 0x64, 0x6f, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x69, 0x74, 0x61, 0x6d, 0x61,
  0x6e, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x70, 0x65, 0x71, 0x75, 0x65, 0xc3, 0xb1,
  0x6f, 0x72, 0x65, 0x63, 0x69, 0x62, 0x69, 0x64, 0x61, 0x74, 0x72, 0x69, 0x62,
  0x75, 0x6e, 0x61, 0x6c, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x66, 0x65, 0x63,
  0x61, 0x6e, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x61, 0x6e, 0x61, 0x72, 0x69,
  0x61, 0x73, 0x64, 0x65, 0x73, 0x63, 0x61, 0x72, 0x67, 0x61, 0x64, 0x69, 0x76,
  0x65, 0x72, 0x73, 0x6f, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x6f, 0x72, 0x63, 0x61,
  0x72, 0x65, 0x71, 0x75, 0x69, 0x65, 0x72, 0x65, 0x74, 0xc3, 0xa9, 0x63, 0x6e,
  0x69, 0x63, 0x6f, 0x64, 0x65, 0x62, 0x65, 0x72, 0xc3, 0xad, 0x61, 0x76, 0x69,
  0x76, 0x69, 0x65, 0x6e, 0x64, 0x61, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x7a, 0x61,
  0x73, 0x61, 0x64, 0x65, 0x6c, 0x61, 0x6e, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x63,
  0x69, 0x6f, 0x6e, 0x61, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6a, 0x6f, 0x73, 0x64,
  0x69, 0x66, 0xc3, 0xad, 0x63, 0x69, 0x6c, 0x63, 0x69, 0x75, 0x64, 0x61, 0x64,
  0x65, 0x73, 0x61, 0x6e, 0x74, 0x69, 0x67, 0x75, 0x61, 0x73, 0x61, 0x76, 0x61,
  0x6e, 0x7a, 0x61, 0x64, 0x61, 0x74, 0xc3, 0xa9, 0x72, 0x6d, 0x69, 0x6e, 0x6f,
  0x75, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x65, 0x73, 0x73, 0xc3, 0xa1, 0x6e, 0x63,
  0x68, 0x65, 0x7a, 0x63, 0x61, 0x6d, 0x70, 0x61, 0xc3, 0xb1, 0x61, 0x73, 0x6f,
  0x66, 0x74, 0x6f, 0x6e, 0x69, 0x63, 0x72, 0x65, 0x76, 0x69, 0x73, 0x74, 0x61,
  0x73, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x65, 0x6e, 0x65, 0x73, 0x65, 0x63, 0x74,
  0x6f, 0x72, 0x65, 0x73, 0x6d, 0x6f, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x73, 0x66,
  0x61, 0x63, 0x75, 0x6c, 0x74, 0x61, 0x64, 0x63, 0x72, 0xc3, 0xa9, 0x64, 0x69,
  0x74, 0x6f, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x73, 0x73, 0x75, 0x70,
  0x75, 0x65, 0x73, 0x74, 0x6f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x65, 0x73,
  0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x6f, 0x73, 0x70, 0x65, 0x71, 0x75, 0x65,
  0xc3, 0xb1, 0x61, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xb5,
  0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x82, 0xd1,
  0x8c, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x8b,
  0xd1, 0x82, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0,
  0x95, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb3,
  0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8f, 0xd0, 0xb2, 0xd1,
  0x81, 0xd0, 0xb5, 0xd1, 0x85, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb9,
  0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xb6, 0xd0, 0xb5, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0,
  0xbb, 0xd0, 0xb8, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd1, 0x83, 0xd0, 0xb4,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd1,
  0x82, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xbb, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb5,
  0xd0, 0xb1, 0xd1, 0x8f, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1,
  0x81, 0xd0, 0xb5, 0xd0, 0xb1, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb4,
  0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xb9, 0xd1, 0x82, 0xd1, 0x84, 0xd0,
  0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe,
  0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xb2, 0xd0,
  0xbe, 0xd0, 0xb9, 0xd0, 0xb8, 0xd0, 0xb3, 0xd1, 0x80, 0xd1, 0x8b, 0xd1, 0x82,
  0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xb5, 0xd0, 0xb2, 0xd1, 0x81, 0xd0, 0xb5, 0xd0,
  0xbc, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd1, 0x8e, 0xd0, 0xbb, 0xd0, 0xb8,
  0xd1, 0x88, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xb8, 0xd1, 0x85, 0xd0,
  0xbf, 0xd0, 0xbe, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xb5,
  0xd0, 0xb9, 0xd0, 0xb4, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0,
  0xb8, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xb1, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd1, 0x83, 0xd1, 0x85, 0xd0, 0xbe, 0xd1,
  0x82, 0xd1, 0x8f, 0xd0, 0xb4, 0xd0, 0xb2, 0xd1, 0x83, 0xd1, 0x85, 0xd1, 0x81,
  0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xbb, 0xd1, 0x8e, 0xd0, 0xb4, 0xd0,
  0xb8, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xb8,
  0xd1, 0x80, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xb1, 0xd1, 0x8f, 0xd1,
  0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xb2, 0xd0, 0xb8, 0xd0, 0xb4,
  0xd0, 0xb5, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1, 0x8d, 0xd1,
  0x82, 0xd0, 0xb8, 0xd0, 0xbc, 0xd1, 0x81, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x82,
  0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd1, 0x8b, 0xd1, 0x86, 0xd0, 0xb5, 0xd0,
  0xbd, 0xd1, 0x8b, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbb, 0xd0, 0xb2,
  0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x8c, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xb5, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb4, 0xd1, 0x8b, 0xd1, 0x82, 0xd0, 0xb5,
  0xd0, 0xb1, 0xd0, 0xb5, 0xd0, 0xb2, 0xd1, 0x8b, 0xd1, 0x88, 0xd0, 0xb5, 0xd0,
  0xbd, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xbf,
  0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x83, 0xd0, 0xbf, 0xd1,
  0x80, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x86, 0xd0, 0xb0,
  0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0,
  0xb4, 0xd1, 0x8b, 0xd0, 0xb7, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x8e, 0xd0, 0xbc,
  0xd0, 0xbe, 0xd0, 0xb3, 0xd1, 0x83, 0xd0, 0xb4, 0xd1, 0x80, 0xd1, 0x83, 0xd0,
  0xb3, 0xd0, 0xb2, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xb9, 0xd0, 0xb8, 0xd0, 0xb4,
  0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0,
  0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb,
  0xd0, 0xb0, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb5, 0xd1, 0x81, 0xd1,
  0x80, 0xd0, 0xbe, 0xd0, 0xba, 0xd0, 0xb8, 0xd1, 0x8e, 0xd0, 0xbd, 0xd1, 0x8f,
  0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x8c, 0xd0, 0x95, 0xd1, 0x81, 0xd1,
  0x82, 0xd1, 0x8c, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0, 0xb0, 0xd0, 0xbd,
  0xd0, 0xb0, 0xd1, 0x88, 0xd0, 0xb8, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x84, 0xd9,
  0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd9, 0x8a, 0xd8, 0xac, 0xd9, 0x85,
  0xd9, 0x8a, 0xd8, 0xb9, 0xd8, 0xae, 0xd8, 0xa7, 0xd8, 0xb5, 0xd8, 0xa9, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xb0, 0xd9, 0x8a, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x8a,
  0xd9, 0x87, 0xd8, 0xac, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xa2, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xaf,
  0xd8, 0xaa, 0xd8, 0xad, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xb5, 0xd9, 0x81, 0xd8,
  0xad, 0xd8, 0xa9, 0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x8a, 0xd9, 0x83, 0xd9, 0x88, 0xd9,
  0x86, 0xd8, 0xb4, 0xd8, 0xa8, 0xd9, 0x83, 0xd8, 0xa9, 0xd9, 0x81, 0xd9, 0x8a,
  0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xa8, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8,
  0xad, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xa1, 0xd8, 0xa3, 0xd9, 0x83, 0xd8, 0xab,
  0xd8, 0xb1, 0xd8, 0xae, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xad, 0xd8, 0xa8, 0xd8, 0xaf, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x84,
  0xd8, 0xaf, 0xd8, 0xb1, 0xd9, 0x88, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8, 0xb6, 0xd8,
  0xba, 0xd8, 0xb7, 0xd8, 0xaa, 0xd9, 0x83, 0xd9, 0x88, 0xd9, 0x86, 0xd9, 0x87,
  0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x83, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8, 0xad, 0xd8,
  0xa9, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb7, 0xd8, 0xa8, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x83, 0xd8,
  0xb4, 0xd9, 0x83, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x8a, 0xd9, 0x85, 0xd9, 0x83,
  0xd9, 0x86, 0xd9, 0x85, 0xd9, 0x86, 0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xb4, 0xd8,
  0xb1, 0xd9, 0x83, 0xd8, 0xa9, 0xd8, 0xb1, 0xd8, 0xa6, 0xd9, 0x8a, 0xd8, 0xb3,
  0xd9, 0x86, 0xd8, 0xb4, 0xd9, 0x8a, 0xd8, 0xb7, 0xd9, 0x85, 0xd8, 0xa7, 0xd8,
  0xb0, 0xd8, 0xa7, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x86, 0xd8, 0xb4,
  0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xaa, 0xd8, 0xb9, 0xd8, 0xa8, 0xd8,
  0xb1, 0xd8, 0xb1, 0xd8, 0xad, 0xd9, 0x85, 0xd8, 0xa9, 0xd9, 0x83, 0xd8, 0xa7,
  0xd9, 0x81, 0xd8, 0xa9, 0xd9, 0x8a, 0xd9, 0x82, 0xd9, 0x88, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xb2, 0xd9, 0x83, 0xd9, 0x84, 0xd9, 0x85,
  0xd8, 0xa9, 0xd8, 0xa3, 0xd8, 0xad, 0xd9, 0x85, 0xd8, 0xaf, 0xd9, 0x82, 0xd9,
  0x84, 0xd8, 0xa8, 0xd9, 0x8a, 0xd9, 0x8a, 0xd8, 0xb9, 0xd9, 0x86, 0xd9, 0x8a,
  0xd8, 0xb5, 0xd9, 0x88, 0xd8, 0xb1, 0xd8, 0xa9, 0xd8, 0xb7, 0xd8, 0xb1, 0xd9,
  0x8a, 0xd9, 0x82, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xac,
  0xd9, 0x88, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8, 0xae, 0xd8, 0xb1, 0xd9,
  0x89, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xa7, 0xd8, 0xa8,
  0xd8, 0xad, 0xd8, 0xab, 0xd8, 0xb9, 0xd8, 0xb1, 0xd9, 0x88, 0xd8, 0xb6, 0xd8,
  0xa8, 0xd8, 0xb4, 0xd9, 0x83, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb3, 0xd8, 0xac,
  0xd9, 0x84, 0xd8, 0xa8, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x86, 0xd8, 0xae, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xaf, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xa8,
  0xd9, 0x83, 0xd9, 0x84, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa8, 0xd8, 0xaf, 0xd9,
  0x88, 0xd9, 0x86, 0xd8, 0xa3, 0xd9, 0x8a, 0xd8, 0xb6, 0xd8, 0xa7, 0xd9, 0x8a,
  0xd9, 0x88, 0xd8, 0xac, 0xd8, 0xaf, 0xd9, 0x81, 0xd8, 0xb1, 0xd9, 0x8a, 0xd9,
  0x82, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa8, 0xd8, 0xaa, 0xd8, 0xa3, 0xd9, 0x81,
  0xd8, 0xb6, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb7, 0xd8, 0xa8, 0xd8, 0xae, 0xd8,
  0xa7, 0xd9, 0x83, 0xd8, 0xab, 0xd8, 0xb1, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xb1,
  0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x81, 0xd8, 0xb6, 0xd9, 0x84, 0xd8, 0xa7, 0xd8,
  0xad, 0xd9, 0x84, 0xd9, 0x89, 0xd9, 0x86, 0xd9, 0x81, 0xd8, 0xb3, 0xd9, 0x87,
  0xd8, 0xa3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xaf, 0xd9,
  0x88, 0xd8, 0xaf, 0xd8, 0xa3, 0xd9, 0x86, 0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xaf,
  0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9,
  0x86, 0xd9, 0x85, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xb6, 0xd8, 0xaa, 0xd8, 0xb9,
  0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xaf, 0xd8, 0xa7, 0xd8, 0xae, 0xd9, 0x84, 0xd9,
  0x85, 0xd9, 0x85, 0xd9, 0x83, 0xd9, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x02,
  0x00, 0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00,
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x06, 0x05, 0x04, 0x03,
  0x02, 0x01, 0x00, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x0f, 0x0e,
  0x0d, 0x0c, 0x0b, 0x0a, 0x09, 0x08, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
  0x17, 0x17, 0x16, 0x15, 0x14, 0x13, 0x12, 0x11, 0x10, 0x18, 0x19, 0x1a, 0x1b,
  0x1c, 0x1d, 0x1e, 0x1f, 0x1f, 0x1e, 0x1d, 0x1c, 0x1b, 0x1a, 0x19, 0x18, 0xff,
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0xff, 0xff, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0xff, 0xff, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00,
  0x07, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x63, 0x6f, 0x75,
  0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x65, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f,
  0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
  0x62, 0x6c, 0x65, 0x68, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x44,
  0x54, 0x44, 0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x6d, 0x61, 0x72, 0x6b, 0x65,
  0x74, 0x69, 0x6e, 0x67, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
  0x73, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x61, 0x64, 0x76,
  0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
  0x65, 0x72, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x3c, 0x2f,
  0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x3e, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61,
  0x6c, 0x69, 0x61, 0x22, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73,
  0x69, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f,
  0x72, 0x69, 0x74, 0x79, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x69, 0x6c, 0x79, 0x6f, 0x70, 0x65, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
  0x65, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x64, 0x61, 0x6e, 0x6f,
  0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x63, 0x6f,
  0x6d, 0x70, 0x61, 0x6e, 0x69, 0x65, 0x73, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
  0x75, 0x72, 0x65, 0x61, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22,
  0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22, 0x70, 0x6f, 0x74, 0x65, 0x6e,
  0x74, 0x69, 0x61, 0x6c, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x73, 0x65, 0x63, 0x6f,
  0x6e, 0x64, 0x61, 0x72, 0x79, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68,
  0x74, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x65, 0x78, 0x63,
  0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x3e, 0x0d, 0x0a, 0x73, 0x74,
  0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x74, 0x65, 0x6e, 0x74,
  0x69, 0x6f, 0x6e, 0x42, 0x69, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x79, 0x7d,
  0x20, 0x65, 0x6c, 0x73, 0x65, 0x20, 0x7b, 0x0a, 0x73, 0x6f, 0x6c, 0x75, 0x74,
  0x69, 0x6f, 0x6e, 0x73, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x74, 0x65, 0x6d, 0x70,
  0x6c, 0x61, 0x74, 0x65, 0x73, 0x64, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x6f, 0x75,
  0x73, 0x73, 0x61, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x74, 0x65, 0x64, 0x6f, 0x63,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
  0x65, 0x72, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x70, 0x72,
  0x6f, 0x74, 0x6f, 0x74, 0x79, 0x70, 0x65, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65,
  0x6e, 0x63, 0x65, 0x26, 0x72, 0x61, 0x71, 0x75, 0x6f, 0x3b, 0x3c, 0x2f, 0x65,
  0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x67, 0x65, 0x6e, 0x65, 0x72,
  0x61, 0x6c, 0x6c, 0x79, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
  0x62, 0x65, 0x61, 0x75, 0x74, 0x69, 0x66, 0x75, 0x6c, 0x74, 0x72, 0x61, 0x6e,
  0x73, 0x70, 0x6f, 0x72, 0x74, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x65,
  0x64, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x70, 0x72, 0x6f,
  0x6d, 0x69, 0x6e, 0x65, 0x6e, 0x74, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c, 0x4e, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x2e, 0x66, 0x6f, 0x63, 0x75, 0x73,
  0x28, 0x29, 0x3b, 0x6f, 0x76, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d,
  0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6e, 0x6e, 0x6f, 0x75,
  0x6e, 0x63, 0x65, 0x64, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x22, 0x3e, 0x0a,
  0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x6c, 0x65, 0x73, 0x73,
  0x20, 0x74, 0x68, 0x61, 0x6e, 0x65, 0x78, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x76,
  0x65, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x72, 0x61,
  0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x74, 0x65, 0x72, 0x72, 0x69, 0x74, 0x6f,
  0x72, 0x79, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x75,
  0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e,
  0x61, 0x6d, 0x65, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x69, 0x73, 0x6d, 0x74,
  0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6c, 0x73, 0x65, 0x77,
  0x68, 0x65, 0x72, 0x65, 0x41, 0x6c, 0x65, 0x78, 0x61, 0x6e, 0x64, 0x65, 0x72,
  0x61, 0x70, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x6d, 0x61, 0x74, 0x65,
  0x72, 0x69, 0x61, 0x6c, 0x73, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73,
  0x74, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x61, 0x66, 0x66,
  0x69, 0x6c, 0x69, 0x61, 0x74, 0x65, 0x3c, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
  0x6e, 0x3e, 0x74, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x64, 0x69,
  0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x2f, 0x64, 0x65, 0x66, 0x61, 0x75,
  0x6c, 0x74, 0x2e, 0x50, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x6f,
  0x6e, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x3d, 0x22, 0x62, 0x69, 0x6f, 0x67, 0x72,
  0x61, 0x70, 0x68, 0x79, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x77, 0x69, 0x73, 0x65,
  0x70, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x61, 0x6e,
  0xc3, 0xa7, 0x61, 0x69, 0x73, 0x48, 0x6f, 0x6c, 0x6c, 0x79, 0x77, 0x6f, 0x6f,
  0x64, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x61,
  0x6e, 0x64, 0x61, 0x72, 0x64, 0x73, 0x3c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3e, 0x0a, 0x72, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
  0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72,
  0x72, 0x65, 0x64, 0x43, 0x61, 0x6d, 0x62, 0x72, 0x69, 0x64, 0x67, 0x65, 0x6f,
  0x70, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x75, 0x73, 0x69, 0x6e,
  0x65, 0x73, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e,
  0x3e, 0x0a, 0x3c, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x70, 0x72, 0x65, 0x73,
  0x65, 0x6e, 0x74, 0x65, 0x64, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65,
  0x64, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x77, 0x6f, 0x72,
  0x6c, 0x64, 0x77, 0x69, 0x64, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
  0x63, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6e, 0x65,
  0x77, 0x73, 0x70, 0x61, 0x70, 0x65, 0x72, 0x3c, 0x2f, 0x74, 0x61, 0x62, 0x6c,
  0x65, 0x3e, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x6c,
  0x69, 0x6b, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x73, 0x73, 0x65, 0x6e,
  0x74, 0x69, 0x61, 0x6c, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
  0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x3d, 0x22, 0x2f, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x65,
  0x64, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x61, 0x72,
  0x73, 0x65, 0x49, 0x6e, 0x74, 0x28, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69,
  0x74, 0x79, 0x75, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x3c, 0x2f,
  0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x0a, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x73, 0x4e, 0x6f, 0x74, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x65,
  0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x70, 0x65, 0x72, 0x66, 0x6f,
  0x72, 0x6d, 0x65, 0x64, 0x74, 0x77, 0x6f, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73,
  0x53, 0x69, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x66, 0x6f, 0x72, 0x65, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x22,
  0x3e, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x69, 0x6e, 0x63,
  0x72, 0x65, 0x61, 0x73, 0x65, 0x64, 0x42, 0x61, 0x74, 0x74, 0x6c, 0x65, 0x20,
  0x6f, 0x66, 0x70, 0x65, 0x72, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x74, 0x72,
  0x79, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73,
  0x61, 0x72, 0x79, 0x70, 0x6f, 0x72, 0x74, 0x72, 0x61, 0x79, 0x65, 0x64, 0x65,
  0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6c, 0x69, 0x7a, 0x61,
  0x62, 0x65, 0x74, 0x68, 0x3c, 0x2f, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x3e,
  0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x69, 0x6e, 0x73, 0x75,
  0x72, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
  0x3b, 0x6c, 0x65, 0x67, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x47, 0x65, 0x6f,
  0x67, 0x72, 0x61, 0x70, 0x68, 0x79, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61,
  0x74, 0x65, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x73, 0x6f,
  0x6d, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
  0x65, 0x73, 0x2e, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x65, 0x64, 0x3c,
  0x2f, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x43, 0x6f, 0x6d, 0x6d, 0x75,
  0x6e, 0x69, 0x74, 0x79, 0x72, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x6f, 0x75, 0x73,
  0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6d, 0x6d,
  0x69, 0x74, 0x74, 0x65, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67,
  0x73, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x6e, 0x6f, 0x20,
  0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69,
  0x6e, 0x67, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x63, 0x61,
  0x6e, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x63, 0x79, 0x74, 0x79, 0x70, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x69,
  0x6e, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x74,
  0x69, 0x76, 0x65, 0x3b, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67,
  0x70, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x69, 0x74,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71, 0x75,
  0x65, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x69, 0x74, 0x20,
  0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e,
  0x63, 0x65, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x6c, 0x69, 0x6e, 0x65, 0x74, 0x68,
  0x69, 0x73, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x6c, 0x65, 0x70, 0x68,
  0x6f, 0x6e, 0x65, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x70,
  0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x65, 0x73, 0x61, 0x64, 0x76, 0x61, 0x6e,
  0x74, 0x61, 0x67, 0x65, 0x29, 0x3b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20,
  0x46, 0x6f, 0x72, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x76,
  0x69, 0x64, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x6d, 0x6f, 0x63, 0x72, 0x61, 0x63,
  0x79, 0x62, 0x6f, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x78, 0x74,
  0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x73, 0x75, 0x66, 0x66, 0x65, 0x72, 0x69,
  0x6e, 0x67, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x63, 0x6f,
  0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x73, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x73,
  0x61, 0x69, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x74, 0x20, 0x6d, 0x61,
  0x79, 0x20, 0x62, 0x65, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x3c, 0x2f,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x63, 0x68, 0x65,
  0x64, 0x75, 0x6c, 0x65, 0x64, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
  0x73, 0x3c, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x3e, 0x0a, 0x73, 0x75, 0x73,
  0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x3a,
  0x20, 0x30, 0x73, 0x70, 0x69, 0x72, 0x69, 0x74, 0x75, 0x61, 0x6c, 0x3c, 0x2f,
  0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x0a, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
  0x6f, 0x66, 0x74, 0x67, 0x72, 0x61, 0x64, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x64,
  0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x65, 0x64, 0x68, 0x65, 0x20, 0x62, 0x65,
  0x63, 0x61, 0x6d, 0x65, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x76, 0x65,
  0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6a, 0x73, 0x68, 0x6f, 0x75, 0x73,
  0x65, 0x68, 0x6f, 0x6c, 0x64, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65,
  0x64, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x64, 0x6c, 0x69, 0x74,
  0x65, 0x72, 0x61, 0x6c, 0x6c, 0x79, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79,
  0x65, 0x64, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x76, 0x61,
  0x72, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e,
  0x69, 0x6e, 0x67, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x63,
  0x65, 0x6e, 0x74, 0x75, 0x72, 0x69, 0x65, 0x73, 0x4a, 0x61, 0x70, 0x61, 0x6e,
  0x65, 0x73, 0x65, 0x20, 0x61, 0x6d, 0x6f, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
  0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x61, 0x6c, 0x67, 0x6f,
  0x72, 0x69, 0x74, 0x68, 0x6d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74,
  0x73, 0x72, 0x65, 0x62, 0x65, 0x6c, 0x6c, 0x69, 0x6f, 0x6e, 0x75, 0x6e, 0x64,
  0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x65, 0x6e, 0x63, 0x6f, 0x75, 0x72, 0x61,
  0x67, 0x65, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x69, 0x6e,
  0x76, 0x6f, 0x6c, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74,
  0x69, 0x76, 0x65, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x6c, 0x70,
  0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x28, 0x61, 0x6c, 0x74, 0x68,
  0x6f, 0x75, 0x67, 0x68, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x69, 0x6e, 0x67,
  0x63, 0x6f, 0x6e, 0x64, 0x75, 0x63, 0x74, 0x65, 0x64, 0x29, 0x2c, 0x20, 0x77,
  0x68, 0x69, 0x63, 0x68, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65,
  0x64, 0x2d, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x46, 0x65, 0x62,
  0x72, 0x75, 0x61, 0x72, 0x79, 0x20, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x6f, 0x75,
  0x73, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x63, 0x6f,
  0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x66, 0x72, 0x61, 0x67, 0x6d, 0x65,
  0x6e, 0x74, 0x73, 0x65, 0x78, 0x63, 0x65, 0x6c, 0x6c, 0x65, 0x6e, 0x74, 0x63,
  0x6f, 0x6c, 0x73, 0x70, 0x61, 0x6e, 0x3d, 0x22, 0x74, 0x65, 0x63, 0x68, 0x6e,
  0x69, 0x63, 0x61, 0x6c, 0x6e, 0x65, 0x61, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x20, 0x73, 0x6f, 0x75, 0x72,
  0x63, 0x65, 0x20, 0x6f, 0x66, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65,
  0x64, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x46, 0x61,
  0x63, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c,
  0x65, 0x20, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x65, 0x6c,
  0x65, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x66, 0x66, 0x65, 0x6e, 0x73,
  0x69, 0x76, 0x65, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x3e, 0x0a, 0x09, 0x73,
  0x70, 0x6f, 0x6e, 0x73, 0x6f, 0x72, 0x65, 0x64, 0x64, 0x6f, 0x63, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x2e, 0x6f, 0x72, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b,
  0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x74, 0x68, 0x6f, 0x73,
  0x65, 0x20, 0x77, 0x68, 0x6f, 0x6d, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x73, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x64, 0x69, 0x66,
  0x66, 0x69, 0x63, 0x75, 0x6c, 0x74, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74,
  0x65, 0x64, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x63, 0x6f,
  0x6e, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
  0x69, 0x6e, 0x67, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x2e,
  0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x28, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x69, 0x63, 0x61, 0x6c, 0x63, 0x6f, 0x61, 0x6c, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x64, 0x65, 0x63, 0x69,
  0x73, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
  0x74, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x65, 0x76, 0x6f,
  0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2d, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
  0x72, 0x22, 0x65, 0x6e, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x6f, 0x61, 0x6c,
  0x6f, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
  0x72, 0x65, 0x64, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x41,
  0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x70, 0x72, 0x6f, 0x74, 0x65,
  0x63, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20,
  0x3c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3e, 0x3c, 0x66, 0x75, 0x72, 0x6e,
  0x69, 0x74, 0x75, 0x72, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74,
  0x20, 0x20, 0x6f, 0x6e, 0x62, 0x6c, 0x75, 0x72, 0x3d, 0x22, 0x73, 0x75, 0x73,
  0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65,
  0x6e, 0x74, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x20, 0x4d, 0x6f,
  0x72, 0x65, 0x6f, 0x76, 0x65, 0x72, 0x2c, 0x61, 0x62, 0x6f, 0x6c, 0x69, 0x73,
  0x68, 0x65, 0x64, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x77,
  0x65, 0x72, 0x65, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x65, 0x6d, 0x6f, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6e, 0x63, 0x79,
  0x6e, 0x61, 0x72, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x61, 0x64, 0x76, 0x6f,
  0x63, 0x61, 0x74, 0x65, 0x73, 0x70, 0x78, 0x3b, 0x62, 0x6f, 0x72, 0x64, 0x65,
  0x72, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x64, 0x69, 0x72,
  0x3d, 0x22, 0x6c, 0x74, 0x72, 0x22, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65,
  0x65, 0x73, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x20, 0x73,
  0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73,
  0x73, 0x6f, 0x72, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x64,
  0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x53, 0x65, 0x70, 0x74, 0x65,
  0x6d, 0x62, 0x65, 0x72, 0x61, 0x64, 0x64, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x28,
  0x46, 0x61, 0x63, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x20, 0x73, 0x75, 0x67, 0x67,
  0x65, 0x73, 0x74, 0x65, 0x64, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x61, 0x74, 0x65,
  0x72, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x65, 0x6c, 0x61,
  0x62, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x74, 0x69, 0x6d,
  0x65, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x65, 0x63, 0x65,
  0x72, 0x74, 0x61, 0x69, 0x6e, 0x6c, 0x79, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
  0x6c, 0x65, 0x64, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x73, 0x4a,
  0x65, 0x72, 0x75, 0x73, 0x61, 0x6c, 0x65, 0x6d, 0x74, 0x68, 0x65, 0x79, 0x20,
  0x68, 0x61, 0x76, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67,
  0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x76,
  0x69, 0x6e, 0x63, 0x65, 0x73, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65,
  0x65, 0x61, 0x72, 0x62, 0x69, 0x74, 0x72, 0x61, 0x72, 0x79, 0x72, 0x65, 0x63,
  0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x77, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x70, 0x78, 0x3b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x74, 0x68,
  0x65, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
  0x6f, 0x75, 0x72, 0x57, 0x68, 0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x65, 0x65,
  0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x62, 0x65, 0x67, 0x61, 0x6e,
  0x20, 0x74, 0x6f, 0x20, 0x69, 0x74, 0x20, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65,
  0x6d, 0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x6d, 0x75, 0x73, 0x74,
  0x20, 0x68, 0x61, 0x76, 0x65, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61,
  0x6e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x65, 0x78, 0x74,
  0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x61,
  0x72, 0x79, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x6c, 0x79, 0x6f, 0x63,
  0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62,
  0x6c, 0x65, 0x73, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x70,
  0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x3c, 0x2f, 0x6c, 0x61, 0x62,
  0x65, 0x6c, 0x3e, 0x3c, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x6b, 0x69, 0x6e, 0x64,
  0x73, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x6f, 0x63, 0x69, 0x65, 0x74, 0x69, 0x65,
  0x73, 0x61, 0x6c, 0x6f, 0x6e, 0x67, 0x73, 0x69, 0x64, 0x65, 0x20, 0x2d, 0x2d,
  0x26, 0x67, 0x74, 0x3b, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x77, 0x65,
  0x73, 0x74, 0x74, 0x68, 0x65, 0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x72, 0x61,
  0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x61, 0x79, 0x20, 0x68, 0x61,
  0x76, 0x65, 0x20, 0x75, 0x6e, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x28, 0x73,
  0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 0x69, 0x6e, 0x22, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x2f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65,
  0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x65,
  0x20, 0x66, 0x72, 0x6f, 0x6d, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
  0x79, 0x62, 0x75, 0x72, 0x69, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x61, 0x20, 0x73,
  0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x74, 0x68, 0x65, 0x79, 0x20, 0x77, 0x65,
  0x72, 0x65, 0x3c, 0x2f, 0x66, 0x6f, 0x6e, 0x74, 0x3e, 0x3c, 0x2f, 0x4e, 0x6f,
  0x72, 0x77, 0x65, 0x67, 0x69, 0x61, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66,
  0x69, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x69, 0x6e, 0x67, 0x70,
  0x61, 0x73, 0x73, 0x65, 0x6e, 0x67, 0x65, 0x72, 0x28, 0x6e, 0x65, 0x77, 0x20,
  0x44, 0x61, 0x74, 0x65, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79,
  0x66, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x41, 0x66, 0x74, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x65, 0x71, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x72, 0x65, 0x67,
  0x75, 0x6c, 0x61, 0x72, 0x6c, 0x79, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
  0x65, 0x72, 0x61, 0x62, 0x6f, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x6c, 0x69,
  0x6e, 0x6b, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x70, 0x68, 0x65, 0x6e, 0x6f, 0x6d,
  0x65, 0x6e, 0x61, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x20, 0x6f, 0x66, 0x74,
  0x6f, 0x6f, 0x6c, 0x74, 0x69, 0x70, 0x22, 0x3e, 0x73, 0x75, 0x62, 0x73, 0x74,
  0x61, 0x6e, 0x63, 0x65, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
  0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x20, 0x6f, 0x66, 0x41, 0x6d, 0x6f, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65,
  0x64, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x73, 0x41, 0x69, 0x72,
  0x20, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20,
  0x6f, 0x66, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x69, 0x6d,
  0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6b, 0x69, 0x6e, 0x67,
  0x20, 0x69, 0x74, 0x70, 0x61, 0x69, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x63,
  0x6f, 0x6e, 0x71, 0x75, 0x65, 0x72, 0x65, 0x64, 0x61, 0x72, 0x65, 0x20, 0x73,
  0x74, 0x69, 0x6c, 0x6c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65,
  0x67, 0x72, 0x6f, 0x77, 0x74, 0x68, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x61, 0x64,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x61, 0x6e,
  0x20, 0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x6d, 0x6f, 0x6c,
  0x65, 0x63, 0x75, 0x6c, 0x65, 0x73, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x69,
  0x73, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x74,
  0x74, 0x72, 0x61, 0x63, 0x74, 0x65, 0x64, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x68,
  0x6f, 0x6f, 0x64, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x75, 0x73, 0x65, 0x64, 0x64,
  0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x73, 0x69, 0x6e, 0x67, 0x61,
  0x70, 0x6f, 0x72, 0x65, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x20, 0x6f, 0x66,
  0x66, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x66,
  0x6c, 0x69, 0x63, 0x74, 0x73, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x70, 0x3e,
  0x0a, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x77, 0x65, 0x72,
  0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x6e, 0x6f, 0x74, 0x65, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x45, 0x78,
  0x65, 0x63, 0x75, 0x74, 0x69, 0x76, 0x65, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x6d,
  0x6f, 0x72, 0x65, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x74, 0x6f, 0x63,
  0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x69, 0x61, 0x6e, 0x73,
  0x64, 0x65, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x70, 0x72, 0x69, 0x73,
  0x6f, 0x6e, 0x65, 0x72, 0x73, 0x61, 0x64, 0x76, 0x65, 0x6e, 0x74, 0x20, 0x6f,
  0x66, 0x55, 0x54, 0x46, 0x2d, 0x38, 0x22, 0x20, 0x2f, 0x3e, 0x3c, 0x21, 0x5b,
  0x43, 0x44, 0x41, 0x54, 0x41, 0x5b, 0x22, 0x3e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
  0x63, 0x74, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x20, 0x62, 0x67,
  0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3d, 0x22, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
  0x20, 0x6f, 0x66, 0x2e, 0x20, 0x49, 0x74, 0x20, 0x77, 0x61, 0x73, 0x20, 0x69,
  0x6e, 0x20, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x70, 0x65, 0x72, 0x6d, 0x69,
  0x74, 0x74, 0x65, 0x64, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
  0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x6f, 0x66, 0x66, 0x69,
  0x63, 0x69, 0x61, 0x6c, 0x73, 0x73, 0x65, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x6c,
  0x79, 0x2d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x69,
  0x74, 0x69, 0x61, 0x74, 0x65, 0x64, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x69,
  0x6e, 0x67, 0x6c, 0x6f, 0x6e, 0x67, 0x2d, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x66, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x63, 0x68, 0x20, 0x74,
  0x68, 0x61, 0x74, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x6d,
  0x61, 0x72, 0x6b, 0x65, 0x64, 0x20, 0x62, 0x79, 0x3c, 0x2f, 0x62, 0x75, 0x74,
  0x74, 0x6f, 0x6e, 0x3e, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x62, 0x75, 0x74, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73, 0x69, 0x6e, 0x63, 0x72,
  0x65, 0x61, 0x73, 0x65, 0x73, 0x64, 0x6f, 0x77, 0x6e, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x70,
  0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x2d, 0x2d, 0x3e, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x57, 0x69,
  0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x73,
  0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x77,
  0x61, 0x73, 0x20, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x56, 0x65, 0x6e, 0x65, 0x7a,
  0x75, 0x65, 0x6c, 0x61, 0x28, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x72, 0x6c, 0x79,
  0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x70, 0x65, 0x72, 0x73,
  0x6f, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x69,
  0x63, 0x66, 0x61, 0x76, 0x6f, 0x75, 0x72, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x76,
  0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6b, 0x69, 0x70, 0x65, 0x64,
  0x69, 0x61, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x65, 0x6e, 0x74, 0x76, 0x69,
  0x72, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20,
  0x77, 0x61, 0x73, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x6c, 0x65, 0x43,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x73, 0x68, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x61, 0x77, 0x61, 0x79,
  0x20, 0x66, 0x72, 0x6f, 0x6d, 0x6d, 0x6f, 0x6c, 0x65, 0x63, 0x75, 0x6c, 0x61,
  0x72, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x6c, 0x79, 0x64, 0x69, 0x73,
  0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x3e, 0x26,
  0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x2f, 0x49, 0x74, 0x20, 0x69, 0x73, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x77,
  0x69, 0x6c, 0x6c, 0x20, 0x68, 0x61, 0x76, 0x65, 0x6f, 0x72, 0x67, 0x61, 0x6e,
  0x69, 0x73, 0x6d, 0x73, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65,
  0x46, 0x72, 0x69, 0x65, 0x64, 0x72, 0x69, 0x63, 0x68, 0x77, 0x61, 0x73, 0x20,
  0x66, 0x69, 0x72, 0x73, 0x74, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79,
  0x20, 0x66, 0x61, 0x63, 0x74, 0x20, 0x74, 0x68, 0x61, 0x74, 0x66, 0x6f, 0x72,
  0x6d, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x69,
  0x6e, 0x67, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x70, 0x68,
  0x79, 0x73, 0x69, 0x63, 0x69, 0x73, 0x74, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x73,
  0x20, 0x69, 0x6e, 0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x73,
  0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x73, 0x70, 0x61, 0x6e, 0x20,
  0x69, 0x64, 0x3d, 0x22, 0x73, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x20, 0x74, 0x6f,
  0x62, 0x65, 0x6c, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x72, 0x76,
  0x69, 0x76, 0x69, 0x6e, 0x67, 0x7d, 0x3c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3e, 0x68, 0x69, 0x73, 0x20, 0x64, 0x65, 0x61, 0x74, 0x68, 0x61, 0x73, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x65, 0x78,
  0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x65, 0x77, 0x61, 0x73, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x61,
  0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x6c, 0x65, 0x76, 0x65, 0x6c,
  0x73, 0x20, 0x6f, 0x66, 0x6e, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x4f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x64, 0x69, 0x73, 0x6d,
  0x69, 0x73, 0x73, 0x65, 0x64, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x73,
  0x74, 0x72, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x73, 0x64, 0x75, 0x70,
  0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x73, 0x69,
  0x76, 0x65, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x61, 0x6c,
  0x6c, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x67, 0x61, 0x6c, 0x6c, 0x65, 0x72,
  0x69, 0x65, 0x73, 0x7b, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x67, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
  0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x69, 0x6d, 0x67, 0x20,
  0x61, 0x6c, 0x74, 0x3d, 0x22, 0x69, 0x6e, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x72,
  0x6e, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65, 0x6d, 0x65, 0x74,
  0x68, 0x6f, 0x64, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
  0x6e, 0x67, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x6e, 0x65,
  0x65, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x74, 0x68, 0x65, 0x20, 0x47, 0x72,
  0x65, 0x61, 0x74, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73,
  0x65, 0x65, 0x6d, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x76, 0x69, 0x65, 0x77, 0x65,
  0x64, 0x20, 0x61, 0x73, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x20, 0x6f, 0x6e,
  0x69, 0x64, 0x65, 0x61, 0x20, 0x74, 0x68, 0x61, 0x74, 0x74, 0x68, 0x65, 0x20,
  0x57, 0x6f, 0x72, 0x6c, 0x64, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x20, 0x6f,
  0x66, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x68, 0x65,
  0x73, 0x65, 0x20, 0x61, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
  0x22, 0x3e, 0x63, 0x61, 0x72, 0x65, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x6d, 0x61,
  0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65,
  0x20, 0x6f, 0x66, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x61,
  0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x70, 0x72, 0x65, 0x64, 0x69,
  0x63, 0x74, 0x65, 0x64, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x72, 0x69, 0x67, 0x68,
  0x74, 0x22, 0x3e, 0x0d, 0x0a, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x63,
  0x65, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e,
  0x74, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0x61, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x74,
  0x65, 0x6e, 0x20, 0x20, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x0d, 0x0a, 0x70, 0x72,
  0x6f, 0x62, 0x61, 0x62, 0x6c, 0x79, 0x20, 0x50, 0x72, 0x6f, 0x66, 0x65, 0x73,
  0x73, 0x6f, 0x72, 0x2d, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x22, 0x20, 0x72,
  0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x65, 0x64, 0x73, 0x61, 0x79, 0x73, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x68, 0x61, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65,
  0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x48, 0x75, 0x6e, 0x67,
  0x61, 0x72, 0x69, 0x61, 0x6e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x20, 0x6f,
  0x66, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x20, 0x61, 0x73, 0x55, 0x6e, 0x69,
  0x76, 0x65, 0x72, 0x73, 0x61, 0x6c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x66, 0x6f,
  0x72, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x69, 0x6e, 0x66, 0x65, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x67, 0x72, 0x65, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x68,
  0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c,
  0x61, 0x72, 0x22, 0x3e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x6f, 0x6e,
  0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x65, 0x6c, 0x65, 0x63,
  0x74, 0x6f, 0x72, 0x61, 0x6c, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x20, 0x6f,
  0x66, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x74,
  0x75, 0x72, 0x6e, 0x20, 0x74, 0x6f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65,
  0x63, 0x74, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6e, 0x70, 0x72,
  0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x20, 0x6c, 0x69, 0x76, 0x69, 0x6e, 0x67,
  0x20, 0x69, 0x6e, 0x65, 0x61, 0x73, 0x69, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x70,
  0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x0a, 0x26, 0x6c, 0x74, 0x3b,
  0x21, 0x2d, 0x2d, 0x20, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x20, 0x6f, 0x66,
  0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x77, 0x61, 0x73, 0x20,
  0x74, 0x61, 0x6b, 0x65, 0x6e, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x74, 0x68,
  0x65, 0x74, 0x6f, 0x6f, 0x6b, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x62, 0x65, 0x6c,
  0x69, 0x65, 0x66, 0x20, 0x69, 0x6e, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61,
  0x6e, 0x73, 0x61, 0x73, 0x20, 0x66, 0x61, 0x72, 0x20, 0x61, 0x73, 0x70, 0x72,
  0x65, 0x76, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x77,
  0x69, 0x74, 0x68, 0x61, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x3c,
  0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x65, 0x74, 0x43, 0x68, 0x72, 0x69, 0x73,
  0x74, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64,
  0x0a, 0x0a, 0x49, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x63, 0x6b,
  0x20, 0x69, 0x6e, 0x74, 0x6f, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x61, 0x73,
  0x74, 0x6d, 0x61, 0x67, 0x61, 0x7a, 0x69, 0x6e, 0x65, 0x73, 0x3e, 0x3c, 0x73,
  0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74,
  0x65, 0x65, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x67, 0x72,
  0x6f, 0x75, 0x70, 0x73, 0x20, 0x6f, 0x66, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x61,
  0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x73, 0x20, 0x66,
  0x69, 0x72, 0x73, 0x74, 0x74, 0x68, 0x65, 0x69, 0x72, 0x20, 0x6f, 0x77, 0x6e,
  0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x61, 0x6e, 0x20, 0x6f,
  0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61,
  0x6e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x65, 0x64, 0x69, 0x73,
  0x74, 0x72, 0x69, 0x63, 0x74, 0x73, 0x77, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x73,
  0x69, 0x6e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x3b, 0x20,
  0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x20, 0x69, 0x6e, 0x68, 0x61, 0x62, 0x69,
  0x74, 0x65, 0x64, 0x53, 0x6f, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x4a,
  0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x20, 0x31, 0x3c, 0x2f, 0x66, 0x6f, 0x6f,
  0x74, 0x65, 0x72, 0x3e, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x6c, 0x79,
  0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20,
  0x73, 0x61, 0x6d, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,
  0x20, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x20, 0x54, 0x68, 0x65,
  0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x2e, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
  0x3b, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x65,
  0x61, 0x6c, 0x20, 0x77, 0x69, 0x74, 0x68, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x63,
  0x6f, 0x6e, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x69, 0x6e, 0x64, 0x65, 0x78,
  0x2e, 0x70, 0x68, 0x70, 0x61, 0x73, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b,
  0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x20, 0x69, 0x6e, 0x72, 0x65, 0x63, 0x65,
  0x6e, 0x74, 0x6c, 0x79, 0x2c, 0x66, 0x65, 0x77, 0x20, 0x79, 0x65, 0x61, 0x72,
  0x73, 0x77, 0x65, 0x72, 0x65, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x0a, 0x3c, 0x68,
  0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c, 0x65, 0x64, 0x69, 0x74, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x61, 0x72, 0x65, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x63, 0x69,
  0x74, 0x69, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
  0x6b, 0x65, 0x79, 0x63, 0x6f, 0x6e, 0x64, 0x65, 0x6d, 0x6e, 0x65, 0x64, 0x61,
  0x6c, 0x73, 0x6f, 0x20, 0x68, 0x61, 0x76, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69,
  0x63, 0x65, 0x73, 0x2c, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x20, 0x6f, 0x66,
  0x53, 0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x76,
  0x65, 0x72, 0x74, 0x65, 0x64, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x6d, 0x69, 0x6e,
  0x69, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3c, 0x2f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
  0x74, 0x3e, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73, 0x20, 0x61, 0x20,
  0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
  0x63, 0x65, 0x73, 0x61, 0x64, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x54,
  0x68, 0x65, 0x79, 0x20, 0x77, 0x65, 0x72, 0x65, 0x61, 0x6e, 0x79, 0x20, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
  0x65, 0x6e, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x75, 0x63, 0x68,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x72, 0x65, 0x66, 0x6c, 0x65, 0x63, 0x74, 0x65,
  0x64, 0x77, 0x61, 0x73, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x6f, 0x72, 0x69,
  0x67, 0x69, 0x6e, 0x61, 0x6c, 0x20, 0x61, 0x20, 0x74, 0x79, 0x70, 0x69, 0x63,
  0x61, 0x6c, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x79, 0x65, 0x6e,
  0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x75, 0x6c, 0x64, 0x20,
  0x6e, 0x6f, 0x74, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x77,
  0x65, 0x64, 0x6e, 0x65, 0x73, 0x64, 0x61, 0x79, 0x74, 0x68, 0x65, 0x20, 0x74,
  0x68, 0x69, 0x72, 0x64, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
  0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x20, 0x32, 0x77, 0x68, 0x61, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x79, 0x61, 0x20, 0x63, 0x65, 0x72, 0x74, 0x61, 0x69,
  0x6e, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x72, 0x6f,
  0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x68,
  0x69, 0x73, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61, 0x73, 0x74, 0x20, 0x63, 0x6f,
  0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x22, 0x3e, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x64,
  0x65, 0x70, 0x65, 0x6e, 0x64, 0x20, 0x6f, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63,
  0x68, 0x22, 0x3e, 0x0a, 0x70, 0x69, 0x65, 0x63, 0x65, 0x73, 0x20, 0x6f, 0x66,
  0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x63, 0x65, 0x74, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x73, 0x65,
  0x65, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x68, 0x61, 0x73, 0x20, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e,
  0x20, 0x3c, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x3e, 0x67, 0x69,
  0x76, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72,
  0x69, 0x61, 0x6e, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x22, 0x3e, 0x70,
  0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x30, 0x76, 0x69, 0x65, 0x77, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68, 0x65, 0x72, 0x2c,
  0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x77, 0x61, 0x73, 0x20,
  0x66, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x75, 0x62, 0x73, 0x65, 0x74, 0x20, 0x6f,
  0x66, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x20, 0x6f, 0x6e, 0x63, 0x68, 0x69,
  0x6c, 0x64, 0x72, 0x65, 0x6e, 0x2c, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x20,
  0x6f, 0x66, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x70, 0x6f,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x65,
  0x64, 0x6c, 0x79, 0x43, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x77,
  0x61, 0x73, 0x20, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x20, 0x61,
  0x66, 0x74, 0x65, 0x72, 0x61, 0x72, 0x65, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e,
  0x77, 0x61, 0x73, 0x20, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x73, 0x63, 0x72, 0x6f,
  0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x20, 0x6f,
  0x66, 0x6d, 0x61, 0x6b, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x75, 0x63,
  0x68, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61,
  0x6e, 0x73, 0x2e, 0x0a, 0x0a, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x2c, 0x20,
  0x62, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x4d, 0x75, 0x73, 0x65, 0x75, 0x6d,
  0x20, 0x6f, 0x66, 0x6c, 0x6f, 0x75, 0x69, 0x73, 0x69, 0x61, 0x6e, 0x61, 0x28,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x69, 0x6e, 0x6e, 0x65,
  0x73, 0x6f, 0x74, 0x61, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73,
  0x61, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x6d, 0x69,
  0x6e, 0x69, 0x63, 0x61, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x20, 0x6f,
  0x66, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x66,
  0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x30, 0x30, 0x70, 0x78, 0x7c, 0x72, 0x69,
  0x67, 0x68, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x6d, 0x6f,
  0x75, 0x73, 0x65, 0x6f, 0x76, 0x65, 0x72, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x3d, 0x22, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x28,
  0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x69,
  0x6e, 0x75, 0x65, 0x73, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x69, 0x73, 0x63, 0x6f,
  0x62, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68,
  0x6f, 0x75, 0x74, 0x20, 0x61, 0x77, 0x69, 0x74, 0x68, 0x20, 0x73, 0x6f, 0x6d,
  0x65, 0x77, 0x68, 0x6f, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x61, 0x20, 0x66,
  0x6f, 0x72, 0x6d, 0x20, 0x6f, 0x66, 0x61, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20,
  0x6f, 0x66, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x69, 0x74, 0x6b, 0x6e,
  0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x20, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69,
  0x63, 0x65, 0x73, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61,
  0x6e, 0x64, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x6d, 0x65, 0x61, 0x73, 0x75,
  0x72, 0x69, 0x6e, 0x67, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73,
  0x70, 0x61, 0x70, 0x65, 0x72, 0x62, 0x61, 0x63, 0x6b, 0x76, 0x61, 0x6c, 0x75,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x0d, 0x0a, 0x3c, 0x74, 0x69, 0x74, 0x6c, 0x65,
  0x3e, 0x3d, 0x20, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x64, 0x65, 0x74,
  0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x26, 0x71, 0x75, 0x6f, 0x74,
  0x3b, 0x20, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x20, 0x62, 0x79, 0x61, 0x6e,
  0x64, 0x20, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x3c, 0x2f, 0x63, 0x65, 0x6e, 0x74,
  0x65, 0x72, 0x3e, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x74,
  0x68, 0x65, 0x20, 0x74, 0x68, 0x72, 0x65, 0x65, 0x70, 0x6f, 0x77, 0x65, 0x72,
  0x20, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b,
  0x69, 0x6e, 0x6e, 0x65, 0x72, 0x48, 0x54, 0x4d, 0x4c, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x79, 0x3a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
  0x3b, 0x43, 0x68, 0x75, 0x72, 0x63, 0x68, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65,
  0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x76, 0x65, 0x72, 0x79, 0x20, 0x68, 0x69,
  0x67, 0x68, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x2d, 0x68,
  0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x3d, 0x22, 0x2f, 0x63, 0x67, 0x69, 0x2d, 0x62, 0x69, 0x6e, 0x2f, 0x74,
  0x6f, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x61, 0x66, 0x72, 0x69, 0x6b,
  0x61, 0x61, 0x6e, 0x73, 0x65, 0x73, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x74, 0x6f,
  0x66, 0x72, 0x61, 0x6e, 0xc3, 0xa7, 0x61, 0x69, 0x73, 0x6c, 0x61, 0x74, 0x76,
  0x69, 0x65, 0xc5, 0xa1, 0x75, 0x6c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x69, 0xc5,
  0xb3, 0xc4, 0x8c, 0x65, 0xc5, 0xa1, 0x74, 0x69, 0x6e, 0x61, 0xc4, 0x8d, 0x65,
  0xc5, 0xa1, 0x74, 0x69, 0x6e, 0x61, 0xe0, 0xb9, 0x84, 0xe0, 0xb8, 0x97, 0xe0,
  0xb8, 0xa2, 0xe6, 0x97, 0xa5, 0xe6, 0x9c, 0xac, 0xe8, 0xaa, 0x9e, 0xe7, 0xae,
  0x80, 0xe4, 0xbd, 0x93, 0xe5, 0xad, 0x97, 0xe7, 0xb9, 0x81, 0xe9, 0xab, 0x94,
  0xe5, 0xad, 0x97, 0xed, 0x95, 0x9c, 0xea, 0xb5, 0xad, 0xec, 0x96, 0xb4, 0xe4,
  0xb8, 0xba, 0xe4, 0xbb, 0x80, 0xe4, 0xb9, 0x88, 0xe8, 0xae, 0xa1, 0xe7, 0xae,
  0x97, 0xe6, 0x9c, 0xba, 0xe7, 0xac, 0x94, 0xe8, 0xae, 0xb0, 0xe6, 0x9c, 0xac,
  0xe8, 0xa8, 0x8e, 0xe8, 0xab, 0x96, 0xe5, 0x8d, 0x80, 0xe6, 0x9c, 0x8d, 0xe5,
  0x8a, 0xa1, 0xe5, 0x99, 0xa8, 0xe4, 0xba, 0x92, 0xe8, 0x81, 0x94, 0xe7, 0xbd,
  0x91, 0xe6, 0x88, 0xbf, 0xe5, 0x9c, 0xb0, 0xe4, 0xba, 0xa7, 0xe4, 0xbf, 0xb1,
  0xe4, 0xb9, 0x90, 0xe9, 0x83, 0xa8, 0xe5, 0x87, 0xba, 0xe7, 0x89, 0x88, 0xe7,
  0xa4, 0xbe, 0xe6, 0x8e, 0x92, 0xe8, 0xa1, 0x8c, 0xe6, 0xa6, 0x9c, 0xe9, 0x83,
  0xa8, 0xe8, 0x90, 0xbd, 0xe6, 0xa0, 0xbc, 0xe8, 0xbf, 0x9b, 0xe4, 0xb8, 0x80,
  0xe6, 0xad, 0xa5, 0xe6, 0x94, 0xaf, 0xe4, 0xbb, 0x98, 0xe5, 0xae, 0x9d, 0xe9,
  0xaa, 0x8c, 0xe8, 0xaf, 0x81, 0xe7, 0xa0, 0x81, 0xe5, 0xa7, 0x94, 0xe5, 0x91,
  0x98, 0xe4, 0xbc, 0x9a, 0xe6, 0x95, 0xb0, 0xe6, 0x8d, 0xae, 0xe5, 0xba, 0x93,
  0xe6, 0xb6, 0x88, 0xe8, 0xb4, 0xb9, 0xe8, 0x80, 0x85, 0xe5, 0x8a, 0x9e, 0xe5,
  0x85, 0xac, 0xe5, 0xae, 0xa4, 0xe8, 0xae, 0xa8, 0xe8, 0xae, 0xba, 0xe5, 0x8c,
  0xba, 0xe6, 0xb7, 0xb1, 0xe5, 0x9c, 0xb3, 0xe5, 0xb8, 0x82, 0xe6, 0x92, 0xad,
  0xe6, 0x94, 0xbe, 0xe5, 0x99, 0xa8, 0xe5, 0x8c, 0x97, 0xe4, 0xba, 0xac, 0xe5,
  0xb8, 0x82, 0xe5, 0xa4, 0xa7, 0xe5, 0xad, 0xa6, 0xe7, 0x94, 0x9f, 0xe8, 0xb6,
  0x8a, 0xe6, 0x9d, 0xa5, 0xe8, 0xb6, 0x8a, 0xe7, 0xae, 0xa1, 0xe7, 0x90, 0x86,
  0xe5, 0x91, 0x98, 0xe4, 0xbf, 0xa1, 0xe6, 0x81, 0xaf, 0xe7, 0xbd, 0x91, 0x73,
  0x65, 0x72, 0x76, 0x69, 0x63, 0x69, 0x6f, 0x73, 0x61, 0x72, 0x74, 0xc3, 0xad,
  0x63, 0x75, 0x6c, 0x6f, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x61,
  0x62, 0x61, 0x72, 0x63, 0x65, 0x6c, 0x6f, 0x6e, 0x61, 0x63, 0x75, 0x61, 0x6c,
  0x71, 0x75, 0x69, 0x65, 0x72, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x64,
  0x6f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x6f, 0x73, 0x70, 0x6f, 0x6c,
  0xc3, 0xad, 0x74, 0x69, 0x63, 0x61, 0x72, 0x65, 0x73, 0x70, 0x75, 0x65, 0x73,
  0x74, 0x61, 0x77, 0x69, 0x6b, 0x69, 0x70, 0x65, 0x64, 0x69, 0x61, 0x73, 0x69,
  0x67, 0x75, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x62, 0xc3, 0xba, 0x73, 0x71, 0x75,
  0x65, 0x64, 0x61, 0x63, 0x6f, 0x6d, 0x75, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x73,
  0x65, 0x67, 0x75, 0x72, 0x69, 0x64, 0x61, 0x64, 0x70, 0x72, 0x69, 0x6e, 0x63,
  0x69, 0x70, 0x61, 0x6c, 0x70, 0x72, 0x65, 0x67, 0x75, 0x6e, 0x74, 0x61, 0x73,
  0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x69, 0x64, 0x6f, 0x72, 0x65, 0x73, 0x70,
  0x6f, 0x6e, 0x64, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x75, 0x65, 0x6c,
  0x61, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x61, 0x73, 0x64, 0x69, 0x63,
  0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x72, 0x65, 0x6c, 0x61, 0x63, 0x69, 0xc3,
  0xb3, 0x6e, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x73, 0x69,
  0x6d, 0x69, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x79, 0x65, 0x63,
  0x74, 0x6f, 0x73, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x61, 0x73, 0x69,
  0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x6f, 0x61, 0x63, 0x74, 0x69, 0x76,
  0x69, 0x64, 0x61, 0x64, 0x65, 0x6e, 0x63, 0x75, 0x65, 0x6e, 0x74, 0x72, 0x61,
  0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0xc3, 0xad, 0x61, 0x69, 0x6d, 0xc3, 0xa1,
  0x67, 0x65, 0x6e, 0x65, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x61,
  0x72, 0x64, 0x65, 0x73, 0x63, 0x61, 0x72, 0x67, 0x61, 0x72, 0x6e, 0x65, 0x63,
  0x65, 0x73, 0x61, 0x72, 0x69, 0x6f, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x69, 0xc3,
  0xb3, 0x6e, 0x74, 0x65, 0x6c, 0xc3, 0xa9, 0x66, 0x6f, 0x6e, 0x6f, 0x63, 0x6f,
  0x6d, 0x69, 0x73, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x61, 0x6e, 0x63, 0x69, 0x6f,
  0x6e, 0x65, 0x73, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x64, 0x61, 0x64, 0x65,
  0x6e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x72, 0x61, 0x6e, 0xc3, 0xa1, 0x6c,
  0x69, 0x73, 0x69, 0x73, 0x66, 0x61, 0x76, 0x6f, 0x72, 0x69, 0x74, 0x6f, 0x73,
  0x74, 0xc3, 0xa9, 0x72, 0x6d, 0x69, 0x6e, 0x6f, 0x73, 0x70, 0x72, 0x6f, 0x76,
  0x69, 0x6e, 0x63, 0x69, 0x61, 0x65, 0x74, 0x69, 0x71, 0x75, 0x65, 0x74, 0x61,
  0x73, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x73, 0x66, 0x75, 0x6e,
  0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x61,
  0x64, 0x6f, 0x63, 0x61, 0x72, 0xc3, 0xa1, 0x63, 0x74, 0x65, 0x72, 0x70, 0x72,
  0x6f, 0x70, 0x69, 0x65, 0x64, 0x61, 0x64, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
  0x70, 0x69, 0x6f, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x69, 0x64, 0x61, 0x64, 0x6d,
  0x75, 0x6e, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x63, 0x72, 0x65, 0x61, 0x63,
  0x69, 0xc3, 0xb3, 0x6e, 0x64, 0x65, 0x73, 0x63, 0x61, 0x72, 0x67, 0x61, 0x73,
  0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x63, 0x6f, 0x6d, 0x65,
  0x72, 0x63, 0x69, 0x61, 0x6c, 0x6f, 0x70, 0x69, 0x6e, 0x69, 0x6f, 0x6e, 0x65,
  0x73, 0x65, 0x6a, 0x65, 0x72, 0x63, 0x69, 0x63, 0x69, 0x6f, 0x65, 0x64, 0x69,
  0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x61, 0x6c, 0x61, 0x6d, 0x61, 0x6e,
  0x63, 0x61, 0x67, 0x6f, 0x6e, 0x7a, 0xc3, 0xa1, 0x6c, 0x65, 0x7a, 0x64, 0x6f,
  0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x70, 0x65, 0x6c, 0xc3, 0xad, 0x63,
  0x75, 0x6c, 0x61, 0x72, 0x65, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x73, 0x67,
  0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x65, 0x73, 0x74, 0x61, 0x72, 0x72, 0x61,
  0x67, 0x6f, 0x6e, 0x61, 0x70, 0x72, 0xc3, 0xa1, 0x63, 0x74, 0x69, 0x63, 0x61,
  0x6e, 0x6f, 0x76, 0x65, 0x64, 0x61, 0x64, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x70,
  0x75, 0x65, 0x73, 0x74, 0x61, 0x70, 0x61, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x65,
  0x73, 0x74, 0xc3, 0xa9, 0x63, 0x6e, 0x69, 0x63, 0x61, 0x73, 0x6f, 0x62, 0x6a,
  0x65, 0x74, 0x69, 0x76, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
  0x6f, 0x73, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x88,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4,
  0xb5, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0x95, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0x9b, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xad, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x88,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0x64, 0x69, 0x70, 0x6c, 0x6f,
  0x64, 0x6f, 0x63, 0x73, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xaf,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xab, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x94,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0x96, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb5, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xae,
  0xe0, 0xa5, 0x8c, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4,
  0x9c, 0xe0, 0xa5, 0x89, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x97,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xad, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0x97, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0x97,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xae, 0xe0,
  0xa4, 0x96, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xad, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa4, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0x9f, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x85,
  0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x90, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x8a, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0x9a, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x90, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xa6, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9,
  0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x96, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xac, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0x86, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb2,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x89, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xad, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x97, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0x95, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa0, 0xe0, 0xa5,
  0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x81,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xa4, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0x86,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x95, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8c, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0x96, 0xe0, 0xa5,
  0x81, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x80,
  0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x65, 0x78, 0x70,
  0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x3c, 0x2f, 0x74, 0x69, 0x74, 0x6c,
  0x65, 0x3e, 0x0d, 0x0a, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74,
  0x20, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x63, 0x6f,
  0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x76, 0x65, 0x72, 0x79,
  0x74, 0x68, 0x69, 0x6e, 0x67, 0x3c, 0x70, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x62,
  0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x3c, 0x61, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x26, 0x63, 0x6f, 0x70, 0x79, 0x3b, 0x20, 0x32, 0x30, 0x31,
  0x6a, 0x61, 0x76, 0x61, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x63, 0x68, 0x61,
  0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x62, 0x72, 0x65, 0x61, 0x64, 0x63,
  0x72, 0x75, 0x6d, 0x62, 0x74, 0x68, 0x65, 0x6d, 0x73, 0x65, 0x6c, 0x76, 0x65,
  0x73, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x67, 0x6f,
  0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x6c, 0x69, 0x66,
  0x6f, 0x72, 0x6e, 0x69, 0x61, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x69,
  0x65, 0x73, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x4e,
  0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x6e,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x3c, 0x2f, 0x74,
  0x69, 0x74, 0x6c, 0x65, 0x3e, 0x3c, 0x6d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x62,
  0x6f, 0x78, 0x22, 0x20, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71, 0x75, 0x65,
  0x73, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x70,
  0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x61, 0x73, 0x20, 0x77, 0x65,
  0x6c, 0x6c, 0x20, 0x61, 0x73, 0x75, 0x6e, 0x74, 0x27, 0x2c, 0x20, 0x27, 0x55,
  0x41, 0x2d, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x6f,
  0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x65, 0x6c, 0x65,
  0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
  0x74, 0x65, 0x64, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x74, 0x6f, 0x6e,
  0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x20, 0x3d, 0x20,
  0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
  0x73, 0x69, 0x6f, 0x6e, 0x26, 0x6c, 0x74, 0x3b, 0x62, 0x72, 0x26, 0x67, 0x74,
  0x3b, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x70, 0x6f,
  0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x67, 0x63, 0x6f, 0x6c,
  0x6f, 0x72, 0x3d, 0x22, 0x23, 0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
  0x6c, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x70,
  0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6e, 0x65, 0x77, 0x73,
  0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
  0x69, 0x65, 0x73, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x54, 0x65, 0x63,
  0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x50, 0x61, 0x72, 0x6c, 0x69, 0x61,
  0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f,
  0x6e, 0x75, 0x6c, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x2e, 0x69,
  0x6e, 0x64, 0x65, 0x78, 0x4f, 0x66, 0x28, 0x22, 0x63, 0x6f, 0x6e, 0x63, 0x6c,
  0x75, 0x73, 0x69, 0x6f, 0x6e, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x62,
  0x69, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x52, 0x65, 0x76, 0x6f,
  0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
  0x6e, 0x65, 0x72, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x6f, 0x6f, 0x64,
  0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x70, 0x65, 0x72,
  0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x61, 0x63, 0x68, 0x20, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x61, 0x74, 0x6d, 0x6f, 0x73, 0x70, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x6f, 0x6e, 0x66, 0x6f, 0x63, 0x75, 0x73, 0x3d, 0x22, 0x3c, 0x66,
  0x6f, 0x72, 0x6d, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x70, 0x72, 0x6f, 0x63, 0x65,
  0x73, 0x73, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x76, 0x61, 0x6c,
  0x75, 0x65, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
  0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x75, 0x62, 0x73,
  0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x77, 0x65, 0x6c, 0x6c, 0x2d, 0x6b, 0x6e,
  0x6f, 0x77, 0x6e, 0x76, 0x61, 0x72, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x72, 0x65, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x68, 0x65,
  0x6e, 0x6f, 0x6d, 0x65, 0x6e, 0x6f, 0x6e, 0x64, 0x69, 0x73, 0x63, 0x69, 0x70,
  0x6c, 0x69, 0x6e, 0x65, 0x6c, 0x6f, 0x67, 0x6f, 0x2e, 0x70, 0x6e, 0x67, 0x22,
  0x20, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x6f,
  0x75, 0x6e, 0x64, 0x61, 0x72, 0x69, 0x65, 0x73, 0x65, 0x78, 0x70, 0x72, 0x65,
  0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x74, 0x74, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x6f,
  0x75, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x6e, 0x74, 0x65,
  0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x28, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73,
  0x3a, 0x22, 0x20, 0x75, 0x6e, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x28, 0x22,
  0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x20, 0x64, 0x65, 0x6d,
  0x6f, 0x63, 0x72, 0x61, 0x74, 0x69, 0x63, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x22, 0x3e,
  0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x6c, 0x69,
  0x6e, 0x67, 0x75, 0x69, 0x73, 0x74, 0x69, 0x63, 0x70, 0x78, 0x3b, 0x70, 0x61,
  0x64, 0x64, 0x69, 0x6e, 0x67, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f, 0x70,
  0x68, 0x79, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x75,
  0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x66, 0x61, 0x63, 0x69,
  0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
  0x7a, 0x65, 0x64, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
  0x69, 0x66, 0x20, 0x28, 0x74, 0x79, 0x70, 0x65, 0x6f, 0x66, 0x6d, 0x61, 0x69,
  0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x76, 0x6f, 0x63, 0x61, 0x62, 0x75,
  0x6c, 0x61, 0x72, 0x79, 0x68, 0x79, 0x70, 0x6f, 0x74, 0x68, 0x65, 0x73, 0x69,
  0x73, 0x2e, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x28, 0x29, 0x3b, 0x26, 0x61,
  0x6d, 0x70, 0x3b, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x20, 0x74,
  0x68, 0x65, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x22, 0x61, 0x73, 0x73, 0x75,
  0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75,
  0x63, 0x65, 0x64, 0x63, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x73, 0x74, 0x73, 0x65, 0x78, 0x70,
  0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61,
  0x64, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
  0x73, 0x20, 0x6f, 0x6e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x3d, 0x22, 0x63, 0x6f,
  0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x64, 0x65, 0x70, 0x61, 0x72,
  0x74, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x73, 0x6f, 0x6f, 0x6e, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x69,
  0x6e, 0x76, 0x65, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x72, 0x6f, 0x6e,
  0x6f, 0x75, 0x6e, 0x63, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
  0x69, 0x65, 0x64, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
  0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x65, 0x6f,
  0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67,
  0x68, 0x74, 0x3d, 0x22, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d,
  0x22, 0x2e, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x28, 0x2f, 0x64, 0x65,
  0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x63, 0x65, 0x70, 0x75, 0x6e, 0x69, 0x73, 0x68, 0x6d, 0x65,
  0x6e, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x72,
  0x65, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x61, 0x64, 0x61, 0x70,
  0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x77, 0x65, 0x6c, 0x6c, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x64, 0x65, 0x74,
  0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x68, 0x31, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x30, 0x70, 0x78, 0x3b, 0x6d, 0x61, 0x72, 0x67, 0x69,
  0x6e, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x73, 0x74,
  0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x63, 0x65, 0x6c, 0x65, 0x62,
  0x72, 0x61, 0x74, 0x65, 0x64, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65,
  0x6e, 0x74, 0x0a, 0x0a, 0x44, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x64,
  0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x73, 0x61, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c,
  0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64,
  0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x74, 0x74,
  0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20,
  0x69, 0x64, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x77, 0x65, 0x72,
  0x65, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x65,
  0x79, 0x6f, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73,
  0x74, 0x65, 0x72, 0x65, 0x64, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x69,
  0x73, 0x74, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x61,
  0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x6c, 0x61, 0x6e, 0x67,
  0x3d, 0x22, 0x65, 0x6e, 0x22, 0x20, 0x3c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3e, 0x0d, 0x0a, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x3b, 0x20,
  0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x65, 0x78, 0x74,
  0x72, 0x65, 0x6d, 0x65, 0x6c, 0x79, 0x20, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x74,
  0x72, 0x65, 0x61, 0x6d, 0x3c, 0x2f, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e,
  0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x65, 0x6d,
  0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x3c, 0x2f, 0x74, 0x61, 0x62,
  0x6c, 0x65, 0x3e, 0x0d, 0x0a, 0x20, 0x63, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x6e,
  0x3d, 0x22, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x3e, 0x0a, 0x20, 0x20, 0x63,
  0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x62, 0x6f, 0x75,
  0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c, 0x2f, 0x70, 0x3e, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64,
  0x22, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22, 0x65, 0x6e, 0x50, 0x6f, 0x72,
  0x74, 0x75, 0x67, 0x75, 0x65, 0x73, 0x65, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69,
  0x74, 0x75, 0x74, 0x65, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61,
  0x6c, 0x69, 0x6d, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x6d, 0x75,
  0x6c, 0x74, 0x69, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x61, 0x6c, 0x6d, 0x6f, 0x73,
  0x74, 0x20, 0x61, 0x6c, 0x6c, 0x70, 0x78, 0x20, 0x73, 0x6f, 0x6c, 0x69, 0x64,
  0x20, 0x23, 0x61, 0x70, 0x61, 0x72, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x73,
  0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x74, 0x6f, 0x69, 0x6e, 0x20, 0x45,
  0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x69,
  0x7a, 0x65, 0x64, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x20, 0x66, 0x6f, 0x72,
  0x67, 0x75, 0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x6f, 0x72, 0x69,
  0x67, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b,
  0x61, 0x62, 0x6c, 0x65, 0x74, 0x68, 0x65, 0x20, 0x73, 0x65, 0x63, 0x6f, 0x6e,
  0x64, 0x68, 0x32, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x61,
  0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22, 0x28, 0x69, 0x6e, 0x63, 0x6c,
  0x75, 0x64, 0x69, 0x6e, 0x67, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
  0x72, 0x73, 0x70, 0x72, 0x6f, 0x68, 0x69, 0x62, 0x69, 0x74, 0x65, 0x64, 0x3d,
  0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 0x69, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x70, 0x65, 0x72, 0x63, 0x65, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x72, 0x65, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
  0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x78, 0x3b,
  0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73,
  0x73, 0x66, 0x75, 0x6c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72,
  0x73, 0x6d, 0x69, 0x6c, 0x6c, 0x65, 0x6e, 0x6e, 0x69, 0x75, 0x6d, 0x68, 0x69,
  0x73, 0x20, 0x66, 0x61, 0x74, 0x68, 0x65, 0x72, 0x74, 0x68, 0x65, 0x20, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x6e, 0x6f, 0x2d, 0x72, 0x65, 0x70, 0x65, 0x61,
  0x74, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x61, 0x6c, 0x69,
  0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x6f,
  0x75, 0x72, 0x61, 0x67, 0x65, 0x64, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x20,
  0x6f, 0x66, 0x20, 0x75, 0x6e, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c,
  0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x66,
  0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69,
  0x6e, 0x61, 0x74, 0x65, 0x64, 0x69, 0x73, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x65,
  0x72, 0x65, 0x78, 0x70, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x63, 0x61, 0x6c, 0x63, 0x75,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x66, 0x69,
  0x65, 0x64, 0x6c, 0x65, 0x67, 0x69, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x73,
  0x75, 0x62, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x28, 0x30, 0x22, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
  0x65, 0x6c, 0x79, 0x69, 0x6c, 0x6c, 0x75, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65,
  0x66, 0x69, 0x76, 0x65, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x73,
  0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
  0x68, 0x69, 0x6e, 0x67, 0x31, 0x22, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x70, 0x73, 0x79, 0x63, 0x68, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x63, 0x6f,
  0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x75, 0x6d, 0x62, 0x65,
  0x72, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x62, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x20,
  0x6f, 0x66, 0x66, 0x6f, 0x63, 0x75, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x6a,
  0x6f, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75,
  0x73, 0x6c, 0x79, 0x3e, 0x3c, 0x2f, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x3e,
  0x6f, 0x6e, 0x63, 0x65, 0x20, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x62, 0x75, 0x74,
  0x20, 0x72, 0x61, 0x74, 0x68, 0x65, 0x72, 0x69, 0x6d, 0x6d, 0x69, 0x67, 0x72,
  0x61, 0x6e, 0x74, 0x73, 0x6f, 0x66, 0x20, 0x63, 0x6f, 0x75, 0x72, 0x73, 0x65,
  0x2c, 0x61, 0x20, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x6f, 0x66, 0x4c, 0x69,
  0x74, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x55, 0x6e, 0x6c, 0x69, 0x6b,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x26, 0x6e, 0x62, 0x73,
  0x70, 0x3b, 0x0a, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69,
  0x74, 0x20, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x76,
  0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6f, 0x62,
  0x69, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x73, 0x74, 0x61, 0x6e, 0x74,
  0x61, 0x67, 0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x76, 0x65, 0x61, 0x66, 0x74,
  0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61,
  0x72, 0x6c, 0x79, 0x2c, 0x22, 0x20, 0x2f, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76,
  0x3e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x0d, 0x0a,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x76, 0x69, 0x73, 0x69, 0x62,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6f, 0x66, 0x76, 0x6f, 0x6c, 0x75, 0x6e, 0x74, 0x65, 0x65, 0x72, 0x73, 0x61,
  0x74, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x75, 0x6e, 0x64, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x65,
  0x6e, 0x65, 0x64, 0x2a, 0x3c, 0x21, 0x5b, 0x43, 0x44, 0x41, 0x54, 0x41, 0x5b,
  0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x69, 0x6e, 0x20,
  0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61,
  0x74, 0x74, 0x65, 0x72, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x3e, 0x0a, 0x3c,
  0x2f, 0x2e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x66, 0x28, 0x27, 0x69, 0x20,
  0x3d, 0x20, 0x30, 0x3b, 0x20, 0x69, 0x20, 0x3c, 0x64, 0x69, 0x66, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x65, 0x76, 0x6f, 0x74, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x74, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73,
  0x65, 0x61, 0x72, 0x63, 0x68, 0x20, 0x66, 0x6f, 0x72, 0x75, 0x6c, 0x74, 0x69,
  0x6d, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x74, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
  0x73, 0x6f, 0x2d, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x7d, 0x0a, 0x3c,
  0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3e, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6d, 0x70, 0x68, 0x61, 0x73, 0x69, 0x7a, 0x65,
  0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x3c, 0x2f,
  0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x73, 0x75, 0x63, 0x63, 0x65,
  0x73, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x77, 0x69,
  0x74, 0x68, 0x4d, 0x65, 0x61, 0x6e, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x2c, 0x69,
  0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3c, 0x2f, 0x61, 0x3e,
  0x3c, 0x62, 0x72, 0x20, 0x2f, 0x3e, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x63,
  0x6f, 0x6d, 0x65, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x20, 0x6f, 0x66,
  0x54, 0x65, 0x6c, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x66,
  0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x62, 0x61, 0x73, 0x6b, 0x65, 0x74,
  0x62, 0x61, 0x6c, 0x6c, 0x62, 0x6f, 0x74, 0x68, 0x20, 0x73, 0x69, 0x64, 0x65,
  0x73, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x69, 0x6e, 0x67, 0x61, 0x6e,
  0x20, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x3c, 0x69, 0x6d, 0x67, 0x20,
  0x61, 0x6c, 0x74, 0x3d, 0x22, 0x61, 0x64, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x72,
  0x65, 0x73, 0x68, 0x69, 0x73, 0x20, 0x6d, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x6d,
  0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e,
  0x63, 0x69, 0x70, 0x6c, 0x65, 0x73, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75,
  0x6c, 0x61, 0x72, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79,
  0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x64, 0x65, 0x63,
  0x69, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x22, 0x3e, 0x3c, 0x73, 0x74, 0x72,
  0x6f, 0x6e, 0x67, 0x3e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
  0x73, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x64, 0x69,
  0x66, 0x66, 0x69, 0x63, 0x75, 0x6c, 0x74, 0x79, 0x66, 0x61, 0x63, 0x69, 0x6c,
  0x69, 0x74, 0x61, 0x74, 0x65, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x62,
  0x6c, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x2e, 0x63, 0x73, 0x73, 0x22, 0x09,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x6e, 0x6f,
  0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69,
  0x67, 0x68, 0x74, 0x73, 0x69, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x68, 0x61, 0x76, 0x65, 0x62, 0x75, 0x73,
  0x69, 0x6e, 0x65, 0x73, 0x73, 0x65, 0x73, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x72, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x73, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x75, 0x73, 0x65, 0x64, 0x70, 0x65,
  0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x20, 0x4a, 0x61,
  0x6e, 0x75, 0x61, 0x72, 0x79, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x69, 0x73, 0x69,
  0x6e, 0x67, 0x3c, 0x2f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x0a, 0x09, 0x64,
  0x69, 0x70, 0x6c, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d,
  0x69, 0x6e, 0x67, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
  0x6d, 0x61, 0x79, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6e,
  0x63, 0x65, 0x70, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x6f, 0x6e, 0x63, 0x6c, 0x69,
  0x63, 0x6b, 0x3d, 0x22, 0x49, 0x74, 0x20, 0x69, 0x73, 0x20, 0x61, 0x6c, 0x73,
  0x6f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x6d, 0x61,
  0x6b, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x4c, 0x75, 0x78, 0x65, 0x6d,
  0x62, 0x6f, 0x75, 0x72, 0x67, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x61, 0x72, 0x65, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x65,
  0x6e, 0x67, 0x61, 0x67, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x22, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x22, 0x29, 0x3b, 0x62, 0x75, 0x74, 0x20, 0x69, 0x74, 0x20,
  0x77, 0x61, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x6f, 0x6e, 0x69, 0x63,
  0x6f, 0x6e, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x3d, 0x22, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x20, 0x45, 0x6e, 0x64, 0x20, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72,
  0x69, 0x63, 0x61, 0x6c, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x6c,
  0x79, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x6f,
  0x70, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x75, 0x6e, 0x6c, 0x69, 0x6b,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69,
  0x61, 0x6e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x72,
  0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x0a, 0x3c, 0x2f, 0x68,
  0x65, 0x61, 0x64, 0x3e, 0x0d, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
  0x73, 0x65, 0x64, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65,
  0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x41, 0x6c, 0x65,
  0x78, 0x61, 0x6e, 0x64, 0x72, 0x69, 0x61, 0x72, 0x65, 0x74, 0x69, 0x72, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x65,
  0x73, 0x66, 0x6f, 0x75, 0x72, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x0a, 0x0a,
  0x26, 0x6c, 0x74, 0x3b, 0x21, 0x2d, 0x2d, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x65,
  0x61, 0x73, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x68, 0x33, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6f,
  0x72, 0x69, 0x67, 0x69, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x6f, 0x62, 0x6c, 0x69,
  0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x65, 0x64,
  0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x61, 0x64, 0x76,
  0x61, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x73, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6e,
  0x73, 0x3c, 0x62, 0x61, 0x73, 0x65, 0x20, 0x68, 0x72, 0x65, 0x66, 0x72, 0x65,
  0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x6c, 0x79, 0x77, 0x69, 0x6c, 0x6c, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x61, 0x62,
  0x6c, 0x65, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x6e,
  0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x75, 0x6e, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x72, 0x65, 0x76, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x65, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x20, 0x66,
  0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
  0x69, 0x7a, 0x65, 0x64, 0x72, 0x65, 0x66, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74,
  0x6f, 0x74, 0x61, 0x6b, 0x65, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x61, 0x75,
  0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x63, 0x6f, 0x6d, 0x70, 0x72,
  0x6f, 0x6d, 0x69, 0x73, 0x65, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61,
  0x6c, 0x20, 0x72, 0x65, 0x73, 0x74, 0x61, 0x75, 0x72, 0x61, 0x6e, 0x74, 0x74,
  0x77, 0x6f, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x46, 0x65, 0x62, 0x72,
  0x75, 0x61, 0x72, 0x79, 0x20, 0x32, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
  0x20, 0x6f, 0x66, 0x73, 0x77, 0x66, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e,
  0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x6e, 0x65, 0x61,
  0x72, 0x6c, 0x79, 0x20, 0x61, 0x6c, 0x6c, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65,
  0x6e, 0x20, 0x62, 0x79, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77,
  0x73, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x77, 0x69,
  0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x61, 0x6c, 0x66, 0x6c, 0x6f, 0x61, 0x74,
  0x3a, 0x6c, 0x65, 0x66, 0x74, 0x69, 0x73, 0x20, 0x75, 0x73, 0x75, 0x61, 0x6c,
  0x6c, 0x79, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x6e,
  0x65, 0x77, 0x73, 0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x6d, 0x79, 0x73, 0x74,
  0x65, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x44, 0x65, 0x70, 0x61, 0x72, 0x74, 0x6d,
  0x65, 0x6e, 0x74, 0x62, 0x65, 0x73, 0x74, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x70, 0x61, 0x72, 0x6c, 0x69, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x75, 0x70,
  0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e,
  0x69, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x65,
  0x64, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x73, 0x79,
  0x73, 0x74, 0x65, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x68, 0x61, 0x73, 0x20, 0x6c,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x6e,
  0x64, 0x61, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x69,
  0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x63, 0x65, 0x72, 0x65,
  0x6d, 0x6f, 0x6e, 0x69, 0x61, 0x6c, 0x70, 0x72, 0x6f, 0x63, 0x6c, 0x61, 0x69,
  0x6d, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x6c, 0x69, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x53, 0x63, 0x69,
  0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x6e, 0x6f, 0x2d, 0x74, 0x72, 0x61, 0x64, 0x65, 0x6d, 0x61, 0x72, 0x6b,
  0x73, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x77, 0x69,
  0x64, 0x65, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x4c, 0x69, 0x62, 0x65, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x6f, 0x6f, 0x6b, 0x20, 0x70, 0x6c, 0x61,
  0x63, 0x65, 0x64, 0x61, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61,
  0x73, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x61, 0x73, 0x69, 0x6d, 0x70, 0x72,
  0x69, 0x73, 0x6f, 0x6e, 0x65, 0x64, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x0a, 0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c, 0x6d,
  0x4c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x6f, 0x76,
  0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x32, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x61,
  0x6c, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x66, 0x6c,
  0x6f, 0x61, 0x74, 0x3a, 0x20, 0x6c, 0x65, 0x66, 0x44, 0x75, 0x72, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
  0x6e, 0x74, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x64,
  0x65, 0x61, 0x6c, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74,
  0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
  0x6e, 0x63, 0x65, 0x2f, 0x75, 0x6c, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x63, 0x6c, 0x65, 0x61, 0x72, 0x66, 0x69, 0x78, 0x22, 0x3e, 0x74, 0x68, 0x65,
  0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x79,
  0x65, 0x61, 0x72, 0x73, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x77, 0x65, 0x72,
  0x65, 0x6f, 0x76, 0x65, 0x72, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x2c, 0x73, 0x79,
  0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65,
  0x6e, 0x74, 0x22, 0x3e, 0x0a, 0x70, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62,
  0x6c, 0x79, 0x68, 0x69, 0x73, 0x20, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x75,
  0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x75, 0x6e, 0x65, 0x78,
  0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69,
  0x6e, 0x67, 0x20, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x64,
  0x61, 0x20, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x75, 0x6e, 0x64,
  0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x22, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67,
  0x73, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6b, 0x65, 0x6e, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x69, 0x6e, 0x20, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x70, 0x6f,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x73, 0x61, 0x69, 0x64, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x72, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x6f, 0x75,
  0x73, 0x20, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x72, 0x6f, 0x77, 0x73, 0x70, 0x61, 0x6e, 0x3d, 0x22, 0x6f, 0x6e, 0x6c, 0x79,
  0x20, 0x61, 0x20, 0x66, 0x65, 0x77, 0x6d, 0x65, 0x61, 0x6e, 0x74, 0x20, 0x74,
  0x68, 0x61, 0x74, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x3c, 0x66, 0x69,
  0x65, 0x6c, 0x64, 0x73, 0x65, 0x74, 0x3e, 0x41, 0x72, 0x63, 0x68, 0x62, 0x69,
  0x73, 0x68, 0x6f, 0x70, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6e,
  0x6f, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x20, 0x75, 0x73, 0x65, 0x64, 0x61, 0x70,
  0x70, 0x72, 0x6f, 0x61, 0x63, 0x68, 0x65, 0x73, 0x70, 0x72, 0x69, 0x76, 0x69,
  0x6c, 0x65, 0x67, 0x65, 0x73, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x0a, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x20, 0x69, 0x6e, 0x6d,
  0x61, 0x79, 0x20, 0x62, 0x65, 0x20, 0x74, 0x68, 0x65, 0x45, 0x61, 0x73, 0x74,
  0x65, 0x72, 0x20, 0x65, 0x67, 0x67, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69,
  0x73, 0x6d, 0x73, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x62, 0x6c, 0x65,
  0x50, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c,
  0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
  0x65, 0x64, 0x22, 0x3e, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e,
  0x0d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x70, 0x68, 0x70, 0x61, 0x72,
  0x72, 0x69, 0x76, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x2d, 0x6a, 0x73, 0x73, 0x64,
  0x6b, 0x27, 0x29, 0x29, 0x3b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x63,
  0x61, 0x73, 0x75, 0x61, 0x6c, 0x74, 0x69, 0x65, 0x73, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69,
  0x61, 0x6e, 0x73, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20,
  0x61, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x70, 0x72, 0x6f,
  0x63, 0x65, 0x64, 0x75, 0x72, 0x65, 0x73, 0x6d, 0x69, 0x67, 0x68, 0x74, 0x20,
  0x68, 0x61, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x69, 0x74, 0x20, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x50, 0x68,
  0x69, 0x6c, 0x6f, 0x73, 0x6f, 0x70, 0x68, 0x79, 0x66, 0x72, 0x69, 0x65, 0x6e,
  0x64, 0x73, 0x68, 0x69, 0x70, 0x6c, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x6f, 0x67, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x74,
  0x6f, 0x77, 0x61, 0x72, 0x64, 0x20, 0x74, 0x68, 0x65, 0x67, 0x75, 0x61, 0x72,
  0x61, 0x6e, 0x74, 0x65, 0x65, 0x64, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
  0x74, 0x65, 0x64, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x30, 0x30, 0x30,
  0x76, 0x69, 0x64, 0x65, 0x6f, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x63, 0x6f, 0x6d,
  0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x66, 0x6c, 0x65, 0x63,
  0x74, 0x69, 0x6e, 0x67, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x74, 0x68,
  0x65, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x73, 0x61,
  0x6e, 0x73, 0x2d, 0x73, 0x65, 0x72, 0x69, 0x66, 0x6f, 0x6e, 0x6b, 0x65, 0x79,
  0x70, 0x72, 0x65, 0x73, 0x73, 0x3b, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e,
  0x67, 0x3a, 0x48, 0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x75,
  0x6e, 0x64, 0x65, 0x72, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x74, 0x79, 0x70, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x73, 0x72, 0x63, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x76, 0x65, 0x73, 0x69, 0x6e,
  0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64,
  0x20, 0x62, 0x65, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
  0x67, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x73,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x6c, 0x6f, 0x77, 0x65, 0x72,
  0x20, 0x74, 0x68, 0x61, 0x6e, 0x73, 0x68, 0x6f, 0x77, 0x73, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x0a, 0x09, 0x09, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x63, 0x6f, 0x6e, 0x74,
  0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74,
  0x69, 0x65, 0x73, 0x61, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x6f, 0x6d, 0x65, 0x72,
  0x68, 0x65, 0x20, 0x64, 0x69, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x64, 0x75, 0x65,
  0x20, 0x74, 0x6f, 0x20, 0x69, 0x74, 0x73, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x61, 0x6e, 0x20, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
  0x65, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x73, 0x20, 0x74, 0x6f, 0x74, 0x68,
  0x65, 0x20, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x61, 0x74, 0x74, 0x65, 0x6d,
  0x70, 0x74, 0x20, 0x74, 0x6f, 0x54, 0x68, 0x65, 0x72, 0x65, 0x66, 0x6f, 0x72,
  0x65, 0x2c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52,
  0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x6e, 0x77, 0x61, 0x73, 0x20,
  0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x6f,
  0x6e, 0x69, 0x63, 0x6b, 0x69, 0x6c, 0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
  0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x73, 0x70, 0x75, 0x62,
  0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6f,
  0x72, 0x6d, 0x65, 0x72, 0x69, 0x6e, 0x64, 0x69, 0x67, 0x65, 0x6e, 0x6f, 0x75,
  0x73, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x75,
  0x62, 0x73, 0x69, 0x64, 0x69, 0x61, 0x72, 0x79, 0x63, 0x6f, 0x6e, 0x73, 0x70,
  0x69, 0x72, 0x61, 0x63, 0x79, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x20,
  0x6f, 0x66, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x61,
  0x66, 0x66, 0x6f, 0x72, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x75, 0x62, 0x73,
  0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x20,
  0x66, 0x6f, 0x72, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
  0x69, 0x74, 0x65, 0x6d, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x61, 0x62, 0x73,
  0x6f, 0x6c, 0x75, 0x74, 0x65, 0x6c, 0x79, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x73,
  0x65, 0x64, 0x6c, 0x79, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x20,
  0x61, 0x61, 0x74, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x74, 0x72,
  0x61, 0x76, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x65, 0x70, 0x61, 0x72,
  0x61, 0x74, 0x65, 0x6c, 0x79, 0x66, 0x6f, 0x63, 0x75, 0x73, 0x65, 0x73, 0x20,
  0x6f, 0x6e, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x61,
  0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x66, 0x6f, 0x75, 0x6e,
  0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68,
  0x65, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x75, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x73, 0x74, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x6e, 0x6f,
  0x2d, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x28, 0x73, 0x6f, 0x6d, 0x65, 0x74,
  0x69, 0x6d, 0x65, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x61,
  0x6c, 0x69, 0x6e, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x75, 0x6e,
  0x64, 0x65, 0x72, 0x74, 0x61, 0x6b, 0x65, 0x6e, 0x71, 0x75, 0x61, 0x72, 0x74,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70,
  0x6c, 0x65, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x69,
  0x6e, 0x64, 0x65, 0x78, 0x2e, 0x70, 0x68, 0x70, 0x3f, 0x3c, 0x2f, 0x62, 0x75,
  0x74, 0x74, 0x6f, 0x6e, 0x3e, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
  0x61, 0x67, 0x65, 0x62, 0x65, 0x73, 0x74, 0x2d, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x22, 0x20, 0x64,
  0x69, 0x72, 0x3d, 0x22, 0x6c, 0x74, 0x72, 0x4c, 0x69, 0x65, 0x75, 0x74, 0x65,
  0x6e, 0x61, 0x6e, 0x74, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d,
  0x22, 0x74, 0x68, 0x65, 0x79, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x61, 0x62,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x6d, 0x61, 0x64, 0x65, 0x20,
  0x75, 0x70, 0x20, 0x6f, 0x66, 0x6e, 0x6f, 0x74, 0x65, 0x64, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61,
  0x72, 0x67, 0x75, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x74, 0x6f, 0x20, 0x61,
  0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65,
  0x6e, 0x27, 0x73, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x20, 0x6f, 0x66,
  0x66, 0x6f, 0x72, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x62, 0x61, 0x73,
  0x65, 0x64, 0x20, 0x75, 0x70, 0x6f, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65,
  0x67, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x6f,
  0x66, 0x70, 0x61, 0x73, 0x73, 0x65, 0x6e, 0x67, 0x65, 0x72, 0x73, 0x70, 0x6f,
  0x73, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x0a, 0x49, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x74,
  0x68, 0x65, 0x61, 0x66, 0x74, 0x65, 0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x63,
  0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x20, 0x61, 0x63, 0x72, 0x6f,
  0x73, 0x73, 0x20, 0x74, 0x68, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x2e,
  0x63, 0x61, 0x70, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x73, 0x6d, 0x69, 0x6e, 0x20,
  0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x2d,
  0x77, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x65, 0x20, 0x73, 0x79, 0x73, 0x74, 0x65,
  0x6d, 0x53, 0x6f, 0x63, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x70, 0x6f,
  0x6c, 0x69, 0x74, 0x69, 0x63, 0x69, 0x61, 0x6e, 0x64, 0x69, 0x72, 0x65, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x77, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x6e, 0x20,
  0x74, 0x6f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x20,
  0x4e, 0x65, 0x77, 0x20, 0x59, 0x6f, 0x72, 0x6b, 0x20, 0x61, 0x70, 0x61, 0x72,
  0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
  0x75, 0x6e, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x65, 0x68, 0x69, 0x73,
  0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x68, 0x61, 0x64, 0x20, 0x62, 0x65,
  0x65, 0x6e, 0x20, 0x61, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x76,
  0x65, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x64, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74,
  0x74, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x65, 0x6e, 0x74, 0x65,
  0x72, 0x20, 0x66, 0x6f, 0x72, 0x70, 0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x65, 0x6e,
  0x63, 0x65, 0x72, 0x65, 0x61, 0x64, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73,
  0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x69, 0x65, 0x73, 0x62, 0x75, 0x74, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74,
  0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x65,
  0x63, 0x6c, 0x61, 0x69, 0x6d, 0x20, 0x74, 0x68, 0x61, 0x74, 0x6c, 0x61, 0x62,
  0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74,
  0x69, 0x62, 0x6c, 0x65, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x20, 0x6f,
  0x66, 0x2c, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x20, 0x62, 0x65,
  0x67, 0x61, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x75, 0x73, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69,
  0x64, 0x65, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x66,
  0x72, 0x6f, 0x6d, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x2f, 0x22, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x67, 0x65, 0x6f, 0x6c, 0x6f, 0x67, 0x69,
  0x63, 0x61, 0x6c, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x6f, 0x66,
  0x64, 0x65, 0x6c, 0x69, 0x62, 0x65, 0x72, 0x61, 0x74, 0x65, 0x69, 0x6d, 0x70,
  0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x20, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b,
  0x20, 0x76, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x74, 0x6f, 0x70, 0x74, 0x68,
  0x65, 0x20, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x6f, 0x75, 0x74, 0x73, 0x69,
  0x64, 0x65, 0x20, 0x6f, 0x66, 0x6e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61, 0x74,
  0x65, 0x64, 0x68, 0x69, 0x73, 0x20, 0x63, 0x61, 0x72, 0x65, 0x65, 0x72, 0x73,
  0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x64, 0x3d, 0x22,
  0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x77, 0x61, 0x73, 0x20, 0x63, 0x61, 0x6c,
  0x6c, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x75, 0x72, 0x74, 0x68,
  0x72, 0x65, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x74, 0x68,
  0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x70, 0x72, 0x65, 0x76, 0x65, 0x6e,
  0x74, 0x69, 0x6f, 0x6e, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6f,
  0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x61, 0x63, 0x63, 0x75, 0x72,
  0x61, 0x74, 0x65, 0x6c, 0x79, 0x77, 0x65, 0x72, 0x65, 0x20, 0x62, 0x75, 0x69,
  0x6c, 0x74, 0x77, 0x61, 0x73, 0x20, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x61,
  0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x6d, 0x75, 0x63, 0x68,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x44, 0x75, 0x65, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x20, 0x31, 0x30, 0x30,
  0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x4b, 0x69, 0x6e,
  0x67, 0x64, 0x6f, 0x6d, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x65, 0x6e,
  0x74, 0x69, 0x72, 0x65, 0x66, 0x61, 0x6d, 0x6f, 0x75, 0x73, 0x20, 0x66, 0x6f,
  0x72, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x62,
  0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x74, 0x68, 0x65, 0x20, 0x46,
  0x72, 0x65, 0x6e, 0x63, 0x68, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x61,
  0x6e, 0x64, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x64, 0x22, 0x3e, 0x69,
  0x73, 0x20, 0x73, 0x61, 0x69, 0x64, 0x20, 0x74, 0x6f, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x64, 0x75, 0x6d, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e,
  0x61, 0x20, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x2d, 0x3e, 0x0a,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x20, 0x4f, 0x66, 0x66, 0x69, 0x63,
  0x69, 0x61, 0x6c, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x77, 0x69, 0x64, 0x65,
  0x2e, 0x61, 0x72, 0x69, 0x61, 0x2d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x74, 0x68,
  0x65, 0x20, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x74, 0x61, 0x6e, 0x64, 0x20, 0x69,
  0x74, 0x20, 0x77, 0x61, 0x73, 0x64, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65,
  0x3d, 0x22, 0x6c, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x74, 0x62,
  0x65, 0x6e, 0x65, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x61, 0x72, 0x65, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
  0x69, 0x6e, 0x67, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x6c, 0x79,
  0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x6e, 0x77, 0x6f, 0x72,
  0x6b, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x6e, 0x6e, 0x6f, 0x76, 0x61, 0x74, 0x69, 0x76, 0x65, 0x3c, 0x2f,
  0x61, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x73, 0x6f, 0x75, 0x6e, 0x64,
  0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x6f,
  0x72, 0x6d, 0x74, 0x65, 0x6e, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x69,
  0x6e, 0x70, 0x75, 0x74, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x6f, 0x70, 0x65, 0x6e,
  0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
  0x74, 0x65, 0x64, 0x61, 0x64, 0x6f, 0x70, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x65,
  0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x61, 0x6e, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
  0x73, 0x20, 0x6f, 0x66, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x20, 0x6f,
  0x66, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x76, 0x65,
  0x72, 0x79, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x61, 0x75, 0x74, 0x6f, 0x6d,
  0x6f, 0x74, 0x69, 0x76, 0x65, 0x62, 0x79, 0x20, 0x66, 0x61, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x70,
  0x75, 0x72, 0x73, 0x75, 0x69, 0x74, 0x20, 0x6f, 0x66, 0x66, 0x6f, 0x6c, 0x6c,
  0x6f, 0x77, 0x20, 0x74, 0x68, 0x65, 0x62, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x74,
  0x20, 0x74, 0x6f, 0x69, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x61, 0x6e, 0x64,
  0x61, 0x67, 0x72, 0x65, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x63, 0x63,
  0x75, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6d, 0x65, 0x73, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6e,
  0x67, 0x64, 0x69, 0x76, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x68, 0x69,
  0x73, 0x20, 0x6f, 0x72, 0x20, 0x68, 0x65, 0x72, 0x74, 0x72, 0x65, 0x6d, 0x65,
  0x6e, 0x64, 0x6f, 0x75, 0x73, 0x66, 0x72, 0x65, 0x65, 0x64, 0x6f, 0x6d, 0x20,
  0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x30,
  0x20, 0x31, 0x65, 0x6d, 0x20, 0x31, 0x65, 0x6d, 0x3b, 0x42, 0x61, 0x73, 0x6b,
  0x65, 0x74, 0x62, 0x61, 0x6c, 0x6c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x2e,
  0x63, 0x73, 0x73, 0x61, 0x6e, 0x20, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x72,
  0x65, 0x76, 0x65, 0x6e, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x2f, 0x22, 0x20,
  0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x69,
  0x6e, 0x64, 0x65, 0x78, 0x74, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x65, 0x70, 0x69, 0x74, 0x74, 0x73, 0x62, 0x75, 0x72, 0x67, 0x68, 0x63, 0x6f,
  0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0x0d, 0x3c, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x28, 0x66, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x6f,
  0x75, 0x74, 0x68, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x3c,
  0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x0d, 0x0a, 0x20, 0x6f, 0x63, 0x63, 0x61,
  0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65,
  0x20, 0x69, 0x74, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x3e, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x20, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79,
  0x2c, 0x20, 0x62, 0x67, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3d, 0x22, 0x74, 0x61,
  0x62, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x61, 0x73,
  0x74, 0x72, 0x6f, 0x75, 0x73, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
  0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x68, 0x61, 0x73, 0x20, 0x61, 0x3e,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x3c, 0x2f, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3e, 0x0a, 0x3c, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20,
  0x66, 0x6f, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x61, 0x6e, 0x64,
  0x2e, 0x73, 0x72, 0x63, 0x20, 0x3d, 0x20, 0x22, 0x2f, 0x2f, 0x76, 0x69, 0x6f,
  0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x68, 0x69, 0x73, 0x20, 0x70,
  0x6f, 0x69, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x6c,
  0x79, 0x69, 0x73, 0x20, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x72, 0x65,
  0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x64, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e,
  0x64, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xc3, 0xaa, 0x73, 0xd7,
  0xa2, 0xd7, 0x91, 0xd7, 0xa8, 0xd7, 0x99, 0xd7, 0xaa, 0xd9, 0x81, 0xd8, 0xa7,
  0xd8, 0xb1, 0xd8, 0xb3, 0xdb, 0x8c, 0x64, 0x65, 0x73, 0x61, 0x72, 0x72, 0x6f,
  0x6c, 0x6c, 0x6f, 0x63, 0x6f, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x69, 0x6f,
  0x65, 0x64, 0x75, 0x63, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x73, 0x65, 0x70,
  0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
  0x72, 0x61, 0x64, 0x6f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x63, 0x69, 0xc3, 0xb3,
  0x6e, 0x75, 0x62, 0x69, 0x63, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70, 0x75,
  0x62, 0x6c, 0x69, 0x63, 0x69, 0x64, 0x61, 0x64, 0x72, 0x65, 0x73, 0x70, 0x75,
  0x65, 0x73, 0x74, 0x61, 0x73, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x61, 0x64,
  0x6f, 0x73, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x65, 0x72,
  0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x64, 0x6f, 0x73, 0x61, 0x72, 0x74, 0xc3,
  0xad, 0x63, 0x75, 0x6c, 0x6f, 0x73, 0x64, 0x69, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x74, 0x65, 0x73, 0x73, 0x69, 0x67, 0x75, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x73,
  0x72, 0x65, 0x70, 0xc3, 0xba, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x69, 0x74,
  0x75, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74,
  0x65, 0x72, 0x69, 0x6f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x69, 0x64, 0x61,
  0x64, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x6f, 0x66, 0x6f,
  0x72, 0x6d, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70, 0x6f, 0x62, 0x6c, 0x61,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e,
  0x74, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x61,
  0x63, 0x63, 0x65, 0x73, 0x6f, 0x72, 0x69, 0x6f, 0x73, 0x74, 0x65, 0x63, 0x68,
  0x6e, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61,
  0x6c, 0x65, 0x73, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0xc3, 0xad, 0x61,
  0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x65, 0x73, 0x64, 0x69, 0x73,
  0x70, 0x6f, 0x6e, 0x69, 0x62, 0x6c, 0x65, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c,
  0x69, 0x64, 0x61, 0x64, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69,
  0x61, 0x76, 0x61, 0x6c, 0x6c, 0x61, 0x64, 0x6f, 0x6c, 0x69, 0x64, 0x62, 0x69,
  0x62, 0x6c, 0x69, 0x6f, 0x74, 0x65, 0x63, 0x61, 0x72, 0x65, 0x6c, 0x61, 0x63,
  0x69, 0x6f, 0x6e, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72,
  0x69, 0x6f, 0x70, 0x6f, 0x6c, 0xc3, 0xad, 0x74, 0x69, 0x63, 0x61, 0x73, 0x61,
  0x6e, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x72, 0x65, 0x73, 0x64, 0x6f, 0x63, 0x75,
  0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x73, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c,
  0x65, 0x7a, 0x61, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x65, 0x73,
  0x64, 0x69, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x65, 0x63, 0x6f,
  0x6e, 0xc3, 0xb3, 0x6d, 0x69, 0x63, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70,
  0x6f, 0x72, 0x74, 0x65, 0x72, 0x6f, 0x64, 0x72, 0xc3, 0xad, 0x67, 0x75, 0x65,
  0x7a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x72, 0x65, 0x6e,
  0x63, 0x75, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x63, 0x75,
  0x73, 0x69, 0xc3, 0xb3, 0x6e, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
  0x72, 0x61, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x66,
  0x72, 0x65, 0x63, 0x75, 0x65, 0x6e, 0x74, 0x65, 0x73, 0x70, 0x65, 0x72, 0x6d,
  0x61, 0x6e, 0x65, 0x6e, 0x74, 0x65, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x6d, 0x65,
  0x6e, 0x74, 0x65, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd0, 0xb1, 0xd1, 0x83, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xbc, 0xd0,
  0xbe, 0xd0, 0xb6, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb2, 0xd1, 0x80, 0xd0, 0xb5,
  0xd0, 0xbc, 0xd1, 0x8f, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xb6, 0xd0,
  0xb5, 0xd1, 0x87, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xb1,
  0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0xbe, 0xd1, 0x87, 0xd0,
  0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb3,
  0xd0, 0xbe, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0,
  0xbf, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb2, 0xd1, 0x81,
  0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xb9, 0xd1,
  0x82, 0xd0, 0xb5, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb7,
  0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb3, 0xd1, 0x83, 0xd1, 0x82, 0xd1, 0x81, 0xd0,
  0xb0, 0xd0, 0xb9, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xb6, 0xd0, 0xb8, 0xd0, 0xb7,
  0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xb6, 0xd0, 0xb4, 0xd1,
  0x83, 0xd0, 0xb1, 0xd1, 0x83, 0xd0, 0xb4, 0xd1, 0x83, 0xd1, 0x82, 0xd0, 0x9f,
  0xd0, 0xbe, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb7, 0xd0, 0xb4, 0xd0,
  0xb5, 0xd1, 0x81, 0xd1, 0x8c, 0xd0, 0xb2, 0xd0, 0xb8, 0xd0, 0xb4, 0xd0, 0xb5,
  0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb2, 0xd1, 0x8f, 0xd0, 0xb7, 0xd0, 0xb8, 0xd0,
  0xbd, 0xd1, 0x83, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb2,
  0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xb9, 0xd0, 0xbb, 0xd1, 0x8e, 0xd0, 0xb4, 0xd0,
  0xb5, 0xd0, 0xb9, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd0, 0xbc, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0,
  0xb5, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xb9, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe,
  0xd0, 0xb8, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0,
  0xb0, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0, 0xbc,
  0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0,
  0xb5, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb6, 0xd0, 0xb8, 0xd0, 0xb7, 0xd0, 0xbd,
  0xd1, 0x8c, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0,
  0xbb, 0xd1, 0x83, 0xd1, 0x87, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xbf, 0xd0, 0xb5,
  0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x81, 0xd1,
  0x82, 0xd0, 0xb8, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x8c,
  0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbd, 0xd0,
  0xbe, 0xd0, 0xb2, 0xd1, 0x8b, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb0,
  0xd0, 0xb2, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0, 0xbe, 0xd0,
  0xb9, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbc,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb5, 0xd1, 0x87, 0xd0, 0xb8, 0xd1,
  0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x8b,
  0xd0, 0xb5, 0xd1, 0x83, 0xd1, 0x81, 0xd0, 0xbb, 0xd1, 0x83, 0xd0, 0xb3, 0xd0,
  0xbe, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb0,
  0xd0, 0xb7, 0xd0, 0xb0, 0xd0, 0xb4, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba, 0xd0,
  0xbe, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb0,
  0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x87, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0x9f, 0xd0,
  0xbe, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba,
  0xd0, 0xb8, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x8b, 0xd0,
  0xb9, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb8, 0xd1, 0x82, 0xd1, 0x82,
  0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xb8, 0xd1, 0x85, 0xd1, 0x81, 0xd1, 0x80, 0xd0,
  0xb0, 0xd0, 0xb7, 0xd1, 0x83, 0xd0, 0xa1, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xba,
  0xd1, 0x82, 0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xbc, 0xd0,
  0x9a, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xbd,
  0xd0, 0xb8, 0xd0, 0xb3, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0,
  0xb2, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xb9,
  0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb9, 0xd1, 0x82, 0xd0, 0xb8, 0xd1, 0x81, 0xd0,
  0xb2, 0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xbc, 0xd1, 0x81, 0xd0, 0xb2, 0xd1, 0x8f,
  0xd0, 0xb7, 0xd1, 0x8c, 0xd0, 0xbb, 0xd1, 0x8e, 0xd0, 0xb1, 0xd0, 0xbe, 0xd0,
  0xb9, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x81,
  0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb8, 0xd0, 0x9a, 0xd1, 0x80, 0xd0,
  0xbe, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xa4, 0xd0, 0xbe, 0xd1, 0x80, 0xd1, 0x83,
  0xd0, 0xbc, 0xd1, 0x80, 0xd1, 0x8b, 0xd0, 0xbd, 0xd0, 0xba, 0xd0, 0xb5, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xbf, 0xd0, 0xbe,
  0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xba, 0xd1, 0x82, 0xd1, 0x8b, 0xd1, 0x81, 0xd1,
  0x8f, 0xd1, 0x87, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x8f, 0xd1, 0x86,
  0xd1, 0x86, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x82, 0xd1, 0x80, 0xd1, 0x82, 0xd1,
  0x80, 0xd1, 0x83, 0xd0, 0xb4, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xbc,
  0xd1, 0x8b, 0xd1, 0x85, 0xd1, 0x80, 0xd1, 0x8b, 0xd0, 0xbd, 0xd0, 0xba, 0xd0,
  0xb0, 0xd0, 0x9d, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x8b, 0xd0, 0xb9, 0xd1, 0x87,
  0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xb0, 0xd1, 0x84, 0xd0, 0xb8, 0xd0, 0xbb, 0xd1, 0x8c,
  0xd0, 0xbc, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x82, 0xd0, 0xb0, 0xd1,
  0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xbc, 0xd0, 0xb5,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xba, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x88, 0xd0, 0xb8, 0xd1, 0x85,
  0xd0, 0xbc, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x83, 0xd1, 0x82, 0xd0, 0xb8, 0xd0,
  0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb5,
  0xd1, 0x8e, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1,
  0x80, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb4, 0xd1, 0x81,
  0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x8d, 0xd1, 0x82, 0xd0,
  0xbe, 0xd0, 0xbc, 0xd1, 0x83, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbd, 0xd1, 0x86,
  0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xba, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0, 0x90, 0xd1, 0x80,
  0xd1, 0x85, 0xd0, 0xb8, 0xd0, 0xb2, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xaa, 0xd8,
  0xaf, 0xd9, 0x89, 0xd8, 0xa5, 0xd8, 0xb1, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb1, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x85, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa8,
  0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x85, 0xd8,
  0xac, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x88, 0xd9, 0x85, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xb5, 0xd9, 0x88, 0xd8, 0xb1, 0xd8, 0xac, 0xd8, 0xaf, 0xd9,
  0x8a, 0xd8, 0xaf, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xb6,
  0xd9, 0x88, 0xd8, 0xa5, 0xd8, 0xb6, 0xd8, 0xa7, 0xd9, 0x81, 0xd8, 0xa9, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x82, 0xd8, 0xb3, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb9, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xaa, 0xd8, 0xad, 0xd9, 0x85, 0xd9,
  0x8a, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x84, 0xd9, 0x81, 0xd8, 0xa7, 0xd8, 0xaa,
  0xd9, 0x85, 0xd9, 0x84, 0xd8, 0xaa, 0xd9, 0x82, 0xd9, 0x89, 0xd8, 0xaa, 0xd8,
  0xb9, 0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb4,
  0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa3, 0xd8, 0xae, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd8, 0xaa, 0xd8, 0xb7, 0xd9, 0x88, 0xd9, 0x8a, 0xd8, 0xb1, 0xd8, 0xb9,
  0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xa5, 0xd8, 0xb1, 0xd9,
  0x81, 0xd8, 0xa7, 0xd9, 0x82, 0xd8, 0xb7, 0xd9, 0x84, 0xd8, 0xa8, 0xd8, 0xa7,
  0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x84, 0xd8, 0xba, 0xd8, 0xa9, 0xd8,
  0xaa, 0xd8, 0xb1, 0xd8, 0xaa, 0xd9, 0x8a, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84,
  0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb4, 0xd9,
  0x8a, 0xd8, 0xae, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xaf, 0xd9, 0x8a,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9,
  0x84, 0xd9, 0x82, 0xd8, 0xb5, 0xd8, 0xb5, 0xd8, 0xa7, 0xd9, 0x81, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x87, 0xd8,
  0xa7, 0xd8, 0xaa, 0xd8, 0xad, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xab, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x84, 0xd9, 0x87, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xb9, 0xd9, 0x85, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa8,
  0xd8, 0xa9, 0xd9, 0x8a, 0xd9, 0x85, 0xd9, 0x83, 0xd9, 0x86, 0xd9, 0x83, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xb7, 0xd9, 0x81, 0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x8a,
  0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x88, 0xd8, 0xa5, 0xd8, 0xaf, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd8, 0xa9, 0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xb1, 0xd9, 0x8a, 0xd8, 0xae,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb5, 0xd8, 0xad, 0xd8, 0xa9, 0xd8, 0xaa, 0xd8,
  0xb3, 0xd8, 0xac, 0xd9, 0x8a, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x88,
  0xd9, 0x82, 0xd8, 0xaa, 0xd8, 0xb9, 0xd9, 0x86, 0xd8, 0xaf, 0xd9, 0x85, 0xd8,
  0xa7, 0xd9, 0x85, 0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xa9, 0xd8, 0xaa,
  0xd8, 0xb5, 0xd9, 0x85, 0xd9, 0x8a, 0xd9, 0x85, 0xd8, 0xa3, 0xd8, 0xb1, 0xd8,
  0xb4, 0xd9, 0x8a, 0xd9, 0x81, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb0, 0xd9, 0x8a,
  0xd9, 0x86, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa8, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8,
  0xa8, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa9, 0xd8, 0xa3, 0xd9, 0x84,
  0xd8, 0xb9, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd9,
  0x81, 0xd8, 0xb1, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd9, 0x83, 0xd9, 0x84,
  0xd8, 0xaa, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x89, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xa3, 0xd9, 0x88, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3,
  0xd9, 0x86, 0xd8, 0xa9, 0xd8, 0xac, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xb9, 0xd8,
  0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb5, 0xd8, 0xad, 0xd9, 0x81, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x86, 0xd9, 0x83, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xae, 0xd8, 0xa7,
  0xd8, 0xb5, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x84, 0xd9, 0x81, 0xd8,
  0xa3, 0xd8, 0xb9, 0xd8, 0xb6, 0xd8, 0xa7, 0xd8, 0xa1, 0xd9, 0x83, 0xd8, 0xaa,
  0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xae, 0xd9,
  0x8a, 0xd8, 0xb1, 0xd8, 0xb1, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8, 0xa6, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x82, 0xd9, 0x84, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xa3, 0xd8, 0xaf, 0xd8, 0xa8, 0xd9, 0x85, 0xd9, 0x82, 0xd8, 0xa7,
  0xd8, 0xb7, 0xd8, 0xb9, 0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xa7, 0xd8, 0xb3, 0xd9,
  0x84, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xb7, 0xd9, 0x82, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xb1, 0xd8, 0xac, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xb4, 0xd8, 0xaa, 0xd8, 0xb1,
  0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x82, 0xd8, 0xaf, 0xd9, 0x85, 0xd9,
  0x8a, 0xd8, 0xb9, 0xd8, 0xb7, 0xd9, 0x8a, 0xd9, 0x83, 0x73, 0x42, 0x79, 0x54,
  0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x28, 0x2e, 0x6a, 0x70, 0x67, 0x22, 0x20,
  0x61, 0x6c, 0x74, 0x3d, 0x22, 0x31, 0x70, 0x78, 0x20, 0x73, 0x6f, 0x6c, 0x69,
  0x64, 0x20, 0x23, 0x2e, 0x67, 0x69, 0x66, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d,
  0x22, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x69,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x70, 0x70,
  0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x20, 0x6f, 0x6e, 0x63,
  0x6c, 0x69, 0x63, 0x6b, 0x3d, 0x22, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69,
  0x73, 0x68, 0x65, 0x64, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69,
  0x6e, 0x67, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22,
  0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x65,
  0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x61, 0x70, 0x70, 0x72,
  0x6f, 0x70, 0x72, 0x69, 0x61, 0x74, 0x65, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6d,
  0x64, 0x61, 0x73, 0x68, 0x3b, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
  0x65, 0x6c, 0x79, 0x3c, 0x2f, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x3c,
  0x2f, 0x72, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74,
  0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x64, 0x65, 0x76,
  0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x70, 0x65,
  0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f,
  0x6c, 0x64, 0x65, 0x72, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
  0x79, 0x3a, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3e,
  0x30, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x65, 0x76,
  0x65, 0x6e, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x72, 0x65, 0x70, 0x6c,
  0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x3c, 0x75, 0x6c, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x69,
  0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x73, 0x70, 0x65, 0x72,
  0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x65, 0x74, 0x54, 0x69,
  0x6d, 0x65, 0x6f, 0x75, 0x74, 0x28, 0x75, 0x72, 0x6c, 0x28, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x6d, 0x61, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x69,
  0x63, 0x73, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x74, 0x6f, 0x70, 0x3a,
  0x65, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x64, 0x65,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x29, 0x20, 0x6e, 0x6f,
  0x2d, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4a, 0x50, 0x47, 0x7c, 0x74, 0x68, 0x75,
  0x6d, 0x62, 0x7c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74,
  0x65, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x66,
  0x6c, 0x6f, 0x61, 0x74, 0x3a, 0x6c, 0x65, 0x66, 0x74, 0x3b, 0x3c, 0x6c, 0x69,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x68, 0x75, 0x6e, 0x64, 0x72,
  0x65, 0x64, 0x73, 0x20, 0x6f, 0x66, 0x0a, 0x0a, 0x48, 0x6f, 0x77, 0x65, 0x76,
  0x65, 0x72, 0x2c, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x3a, 0x62, 0x6f, 0x74, 0x68, 0x3b,
  0x63, 0x6f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x77, 0x69,
  0x74, 0x68, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61, 0x62, 0x65,
  0x6c, 0x20, 0x66, 0x6f, 0x72, 0x3d, 0x22, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x2d, 0x74, 0x6f, 0x70, 0x3a, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c,
  0x61, 0x6e, 0x64, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65,
  0x64, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x79, 0x69,
  0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x26, 0x6c, 0x74,
  0x3b, 0x73, 0x75, 0x70, 0x26, 0x67, 0x74, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x72,
  0x6f, 0x76, 0x65, 0x72, 0x73, 0x79, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c,
  0x61, 0x6e, 0x64, 0x73, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x6d, 0x61, 0x78, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x3d, 0x22,
  0x73, 0x77, 0x69, 0x74, 0x7a, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x44, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x73, 0x73, 0x65,
  0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x0a, 0x0a, 0x41, 0x6c, 0x74, 0x68,
  0x6f, 0x75, 0x67, 0x68, 0x20, 0x3c, 0x2f, 0x74, 0x65, 0x78, 0x74, 0x61, 0x72,
  0x65, 0x61, 0x3e, 0x74, 0x68, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x62, 0x69, 0x72,
  0x64, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x26,
  0x61, 0x6d, 0x70, 0x3b, 0x6e, 0x64, 0x61, 0x73, 0x68, 0x3b, 0x73, 0x70, 0x65,
  0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x75,
  0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x6c, 0x65, 0x67, 0x69, 0x73, 0x6c, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x6f, 0x6e, 0x69,
  0x63, 0x73, 0x0a, 0x09, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22,
  0x69, 0x6c, 0x6c, 0x75, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x64, 0x65, 0x6e,
  0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x74, 0x65, 0x72, 0x72,
  0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
  0x69, 0x74, 0x69, 0x65, 0x73, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x65, 0x64, 0x36, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d,
  0x22, 0x73, 0x61, 0x6e, 0x73, 0x2d, 0x73, 0x65, 0x72, 0x69, 0x66, 0x3b, 0x63,
  0x61, 0x70, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x69, 0x73,
  0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x69, 0x6e, 0x74, 0x65, 0x72,
  0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67,
  0x20, 0x66, 0x6f, 0x72, 0x69, 0x74, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20,
  0x62, 0x65, 0x41, 0x66, 0x67, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x61, 0x6e,
  0x77, 0x61, 0x73, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x61,
  0x74, 0x68, 0x2e, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x28, 0x73, 0x75, 0x72, 0x72,
  0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x63, 0x61, 0x6e, 0x20, 0x61, 0x6c,
  0x73, 0x6f, 0x20, 0x62, 0x65, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
  0x65, 0x65, 0x6e, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x64, 0x3c,
  0x68, 0x32, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x6f, 0x72,
  0x65, 0x20, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x20, 0x68, 0x61,
  0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x69, 0x6e, 0x76, 0x61, 0x73, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x29, 0x2e, 0x67, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65,
  0x28, 0x29, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
  0x44, 0x65, 0x73, 0x70, 0x69, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x22, 0x3e,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x69, 0x6e, 0x73, 0x70,
  0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x78, 0x61, 0x6d, 0x69, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x3c,
  0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x76, 0x65, 0x72,
  0x73, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x73, 0x74, 0x72,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x20, 0x3d, 0x20, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x20, 0x2e, 0x73,
  0x75, 0x62, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x28, 0x65, 0x61, 0x63, 0x68,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
  0x6d, 0x65, 0x6e, 0x74, 0x73, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74,
  0x69, 0x61, 0x6c, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x64,
  0x75, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6d,
  0x62, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x6f, 0x20, 0x6e, 0x6f,
  0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x4d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x20,
  0x45, 0x61, 0x73, 0x74, 0x3c, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x3c, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x20,
  0x70, 0x65, 0x72, 0x68, 0x61, 0x70, 0x73, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e,
  0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x20, 0x44,
  0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x67,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x66, 0x61, 0x6d,
  0x6f, 0x75, 0x73, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x74,
  0x79, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6c,
  0x69, 0x6d, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x78, 0x63,
  0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x73, 0x6f, 0x76, 0x65, 0x72,
  0x65, 0x69, 0x67, 0x6e, 0x74, 0x79, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x22, 0x3e, 0x0a, 0x3c, 0x74, 0x64, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
  0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x20, 0x74, 0x6f, 0x64, 0x6f,
  0x63, 0x74, 0x72, 0x69, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x6f, 0x63, 0x63, 0x75,
  0x70, 0x69, 0x65, 0x64, 0x20, 0x62, 0x79, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52, 0x65, 0x6e, 0x61, 0x69, 0x73, 0x73, 0x61,
  0x6e, 0x63, 0x65, 0x61, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x66, 0x6f, 0x72, 0x65,
  0x78, 0x70, 0x6c, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63,
  0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x72, 0x65, 0x64, 0x65,
  0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72,
  0x63, 0x3d, 0x22, 0x2f, 0x3c, 0x68, 0x31, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x6d, 0x61, 0x79, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x62, 0x65, 0x73, 0x70,
  0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x3c, 0x2f, 0x66, 0x69,
  0x65, 0x6c, 0x64, 0x73, 0x65, 0x74, 0x3e, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
  0x73, 0x73, 0x69, 0x76, 0x65, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x6f, 0x6e, 0x73,
  0x20, 0x6f, 0x66, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
  0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x65,
  0x20, 0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x2e, 0x70, 0x61, 0x72, 0x65,
  0x6e, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x61, 0x67, 0x72, 0x69, 0x63, 0x75, 0x6c,
  0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x73,
  0x74, 0x6f, 0x77, 0x61, 0x72, 0x64, 0x73, 0x20, 0x74, 0x68, 0x65, 0x4d, 0x6f,
  0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x6e, 0x79,
  0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x28, 0x65, 0x73, 0x70, 0x65, 0x63,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x3c, 0x74, 0x64, 0x20, 0x77, 0x69, 0x64, 0x74,
  0x68, 0x3d, 0x22, 0x3b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x31, 0x30, 0x30,
  0x25, 0x69, 0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x3c,
  0x68, 0x33, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x20, 0x6f, 0x6e,
  0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x3d, 0x22, 0x29, 0x2e, 0x61, 0x64, 0x64,
  0x43, 0x6c, 0x61, 0x73, 0x73, 0x28, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x64, 0x61, 0x75, 0x67, 0x68, 0x74, 0x65, 0x72, 0x20, 0x6f, 0x66,
  0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x62, 0x72,
  0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x0d, 0x0a, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61,
  0x72, 0x67, 0x65, 0x73, 0x74, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74,
  0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x6f, 0x63,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x69, 0x6e, 0x20, 0x6f, 0x72,
  0x64, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x22, 0x3e, 0x0a, 0x3c, 0x68, 0x65, 0x61,
  0x64, 0x3e, 0x0a, 0x3c, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d,
  0x22, 0x31, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x29, 0x3b,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x69, 0x6d, 0x70, 0x6c,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65,
  0x20, 0x73, 0x65, 0x65, 0x6e, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61,
  0x73, 0x20, 0x61, 0x64, 0x65, 0x6d, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x74,
  0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x22, 0x3e, 0x63,
  0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x68, 0x65,
  0x20, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x77, 0x61, 0x73, 0x20, 0x77,
  0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x21, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
  0x61, 0x6e, 0x74, 0x3b, 0x70, 0x78, 0x3b, 0x20, 0x6d, 0x61, 0x72, 0x67, 0x69,
  0x6e, 0x2d, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f,
  0x6d, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x64, 0x75, 0x72, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69, 0x6d, 0x6d, 0x69, 0x67, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x63, 0x61, 0x6c,
  0x6c, 0x65, 0x64, 0x3c, 0x68, 0x34, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x72,
  0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x62, 0x79, 0x67, 0x6f, 0x76,
  0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x6c, 0x6f, 0x63, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x4e, 0x6f, 0x76, 0x65,
  0x6d, 0x62, 0x65, 0x72, 0x77, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x3c, 0x2f, 0x70, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x61, 0x63, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x61,
  0x6c, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x72, 0x73,
  0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7b, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69,
  0x7a, 0x65, 0x3a, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x20, 0x69,
  0x6e, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x65, 0x65,
  0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x6d, 0x6f, 0x73,
  0x74, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x79, 0x77, 0x69, 0x64, 0x65, 0x6c,
  0x79, 0x20, 0x75, 0x73, 0x65, 0x64, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73,
  0x69, 0x6f, 0x6e, 0x73, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x20,
  0x6f, 0x66, 0x20, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
  0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x49, 0x74,
  0x20, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x69, 0x74, 0x20, 0x64,
  0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61,
  0x72, 0x79, 0x20, 0x74, 0x6f, 0x69, 0x6e, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61,
  0x6e, 0x74, 0x73, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x73, 0x63, 0x68, 0x6f, 0x6c, 0x61, 0x72, 0x73, 0x68, 0x69, 0x70, 0x63,
  0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x73,
  0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x20, 0x65,
  0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x72, 0x20,
  0x6d, 0x6f, 0x72, 0x65, 0x70, 0x78, 0x3b, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69,
  0x6e, 0x67, 0x74, 0x68, 0x65, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
  0x61, 0x20, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x61, 0x72,
  0x65, 0x20, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x72, 0x6f, 0x6c, 0x65,
  0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f,
  0x75, 0x73, 0x6c, 0x79, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x73, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x6f,
  0x66, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x63,
  0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x74, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x63, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x0a, 0x20, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64,
  0x3d, 0x22, 0x68, 0x69, 0x67, 0x68, 0x20, 0x73, 0x63, 0x68, 0x6f, 0x6f, 0x6c,
  0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x74, 0x6f, 0x63, 0x6f,
  0x6d, 0x66, 0x6f, 0x72, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6f, 0x70,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x72, 0x65, 0x65, 0x20,
  0x79, 0x65, 0x61, 0x72, 0x73, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x75, 0x6e,
  0x74, 0x72, 0x79, 0x69, 0x6e, 0x20, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72,
  0x79, 0x73, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x77, 0x68, 0x6f, 0x20, 0x70, 0x72, 0x6f,
  0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x62, 0x79, 0x3c, 0x70, 0x61, 0x72, 0x61,
  0x6d, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x69, 0x6e, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x20,
  0x6f, 0x66, 0x61, 0x70, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x6d, 0x65, 0x6e, 0x74,
  0x49, 0x53, 0x4f, 0x2d, 0x38, 0x38, 0x35, 0x39, 0x2d, 0x31, 0x22, 0x77, 0x61,
  0x73, 0x20, 0x62, 0x6f, 0x72, 0x6e, 0x20, 0x69, 0x6e, 0x68, 0x69, 0x73, 0x74,
  0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64,
  0x65, 0x64, 0x20, 0x61, 0x73, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x69, 0x73, 0x20, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f,
  0x6e, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x3a,
  0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x73, 0x69, 0x67,
  0x6e, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6e, 0x74, 0x63, 0x65, 0x6c, 0x65, 0x62,
  0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69,
  0x74, 0x74, 0x65, 0x64, 0x2f, 0x6a, 0x73, 0x2f, 0x6a, 0x71, 0x75, 0x65, 0x72,
  0x79, 0x2e, 0x69, 0x73, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73,
  0x74, 0x68, 0x65, 0x6f, 0x72, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x74,
  0x61, 0x62, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x3d, 0x22, 0x69, 0x74, 0x20, 0x63,
  0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65, 0x3c, 0x6e, 0x6f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0a, 0x68, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x62,
  0x65, 0x65, 0x6e, 0x0d, 0x0a, 0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0d, 0x0a,
  0x3c, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x54, 0x68, 0x65, 0x20, 0x63,
  0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x68, 0x65, 0x20,
  0x68, 0x61, 0x64, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x64, 0x75,
  0x63, 0x65, 0x64, 0x20, 0x62, 0x79, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f,
  0x70, 0x68, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
  0x65, 0x64, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x61, 0x6d, 0x6f, 0x6e, 0x67, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x63, 0x6f,
  0x6d, 0x70, 0x61, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x74, 0x6f, 0x20, 0x73,
  0x61, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
  0x65, 0x72, 0x69, 0x6e, 0x67, 0x61, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72,
  0x65, 0x6e, 0x74, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74,
  0x6f, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x62,
  0x65, 0x6c, 0x69, 0x65, 0x66, 0x20, 0x74, 0x68, 0x61, 0x74, 0x70, 0x68, 0x6f,
  0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74,
  0x69, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
  0x20, 0x6f, 0x66, 0x20, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20,
  0x6f, 0x66, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73, 0x61, 0x72, 0x69, 0x6c, 0x79,
  0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x74, 0x65,
  0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x6c, 0x65, 0x61, 0x76,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x61,
  0x63, 0x75, 0x6c, 0x61, 0x72, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x69, 0x63, 0x69, 0x74,
  0x79, 0x68, 0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x73, 0x74, 0x61, 0x75, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x70, 0x61, 0x72,
  0x74, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x65, 0x6d, 0x70, 0x68, 0x61,
  0x73, 0x69, 0x73, 0x20, 0x6f, 0x6e, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x72, 0x65,
  0x63, 0x65, 0x6e, 0x74, 0x73, 0x68, 0x61, 0x72, 0x65, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x20, 0x73, 0x61, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x66, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x64, 0x65,
  0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x69, 0x74, 0x20, 0x69,
  0x73, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x22, 0x3e, 0x3c, 0x2f, 0x69, 0x66,
  0x72, 0x61, 0x6d, 0x65, 0x3e, 0x61, 0x73, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x73, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x63,
  0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x70, 0x6f, 0x69,
  0x6e, 0x74, 0x65, 0x64, 0x20, 0x6f, 0x75, 0x74, 0x6f, 0x70, 0x70, 0x6f, 0x72,
  0x74, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x76, 0x69, 0x65, 0x77, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x69, 0x6e, 0x67, 0x68, 0x65,
  0x20, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x73, 0x65, 0x74, 0x49,
  0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x70,
  0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x69, 0x6e, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x59,
  0x6f, 0x72, 0x6b, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
  0x20, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x0a,
  0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x69, 0x6e, 0x63,
  0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x3b, 0x3c, 0x2f, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x45,
  0x76, 0x65, 0x6e, 0x74, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x22, 0x5f,
  0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x64, 0x20, 0x6f, 0x75, 0x74, 0x53, 0x6f,
  0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x63, 0x69, 0x65,
  0x6e, 0x63, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69,
  0x6d, 0x65, 0x20, 0x6f, 0x66, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
  0x72, 0x22, 0x3e, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x69, 0x6e,
  0x67, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x68, 0x65, 0x72, 0x4d,
  0x75, 0x63, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x77, 0x72, 0x69,
  0x74, 0x69, 0x6e, 0x67, 0x73, 0x20, 0x6f, 0x66, 0x22, 0x20, 0x68, 0x65, 0x69,
  0x67, 0x68, 0x74, 0x3d, 0x22, 0x32, 0x73, 0x69, 0x7a, 0x65, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x66, 0x20, 0x6d, 0x69, 0x78, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x45, 0x78,
  0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x65, 0x64, 0x75, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74,
  0x69, 0x74, 0x69, 0x76, 0x65, 0x20, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x6d, 0x69,
  0x74, 0x3d, 0x22, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x20, 0x6f,
  0x66, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x69, 0x76, 0x65, 0x2f,
  0x44, 0x54, 0x44, 0x20, 0x58, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x72, 0x65, 0x6c,
  0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x74, 0x65, 0x6e, 0x64, 0x65,
  0x6e, 0x63, 0x79, 0x20, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63,
  0x65, 0x20, 0x6f, 0x66, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x77, 0x6f, 0x75,
  0x6c, 0x64, 0x64, 0x65, 0x73, 0x70, 0x69, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x20, 0x6c, 0x65,
  0x67, 0x69, 0x73, 0x6c, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x69, 0x6e, 0x6e,
  0x65, 0x72, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x41, 0x67, 0x72, 0x69, 0x63, 0x75, 0x6c, 0x74,
  0x75, 0x72, 0x65, 0x77, 0x61, 0x73, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x69,
  0x6e, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x61, 0x63, 0x68, 0x20, 0x74, 0x6f, 0x69,
  0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x79, 0x65, 0x61,
  0x72, 0x73, 0x20, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x2c, 0x73, 0x61, 0x6e, 0x73,
  0x2d, 0x73, 0x65, 0x72, 0x69, 0x66, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
  0x6e, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
  0x63, 0x65, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x73,
  0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x66, 0x6f,
  0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x62, 0x62, 0x72,
  0x65, 0x76, 0x69, 0x61, 0x74, 0x65, 0x64, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72,
  0x20, 0x74, 0x68, 0x61, 0x6e, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c,
  0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x73,
  0x75, 0x70, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x63, 0x6c, 0x61,
  0x69, 0x6d, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x74, 0x74, 0x72, 0x69,
  0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69,
  0x7a, 0x65, 0x3a, 0x31, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20,
  0x6f, 0x66, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x20,
  0x68, 0x69, 0x73, 0x20, 0x62, 0x72, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x61, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x61, 0x6e, 0x6e, 0x69,
  0x76, 0x65, 0x72, 0x73, 0x61, 0x72, 0x79, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x20, 0x75, 0x6c, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x6c, 0x79,
  0x20, 0x69, 0x6e, 0x6e, 0x6f, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x69,
  0x74, 0x20, 0x69, 0x73, 0x20, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x63, 0x61, 0x6e,
  0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x62, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x6f, 0x47, 0x4d, 0x54, 0x53, 0x74,
  0x72, 0x69, 0x6e, 0x67, 0x41, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20,
  0x6f, 0x66, 0x69, 0x6d, 0x67, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x45, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x2c, 0x77, 0x61,
  0x73, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x6f, 0x63, 0x63, 0x75,
  0x72, 0x72, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62,
  0x6f, 0x72, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75,
  0x69, 0x73, 0x68, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x68, 0x65, 0x20, 0x77, 0x61,
  0x73, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x69, 0x6e, 0x67, 0x74,
  0x65, 0x72, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x61, 0x6e,
  0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x72, 0x67, 0x75, 0x65,
  0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x6e, 0x20, 0x41, 0x6d, 0x65, 0x72,
  0x69, 0x63, 0x61, 0x6e, 0x63, 0x6f, 0x6e, 0x71, 0x75, 0x65, 0x73, 0x74, 0x20,
  0x6f, 0x66, 0x77, 0x69, 0x64, 0x65, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x20,
  0x77, 0x65, 0x72, 0x65, 0x20, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x73, 0x63,
  0x72, 0x65, 0x65, 0x6e, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x6e, 0x20, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61,
  0x6e, 0x74, 0x73, 0x61, 0x72, 0x65, 0x20, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65,
  0x64, 0x6c, 0x65, 0x67, 0x69, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x67,
  0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x62, 0x61,
  0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x6d, 0x6f, 0x73, 0x74, 0x20,
  0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x79, 0x65, 0x61, 0x72, 0x73, 0x20, 0x61,
  0x66, 0x74, 0x65, 0x72, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73, 0x20,
  0x6e, 0x6f, 0x74, 0x68, 0x65, 0x20, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74,
  0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x20, 0x74, 0x68,
  0x65, 0x79, 0x20, 0x64, 0x6f, 0x20, 0x6e, 0x6f, 0x74, 0x61, 0x72, 0x67, 0x75,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x68, 0x6f, 0x77, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x70, 0x72, 0x65, 0x64, 0x6f, 0x6d, 0x69, 0x6e,
  0x61, 0x6e, 0x74, 0x74, 0x68, 0x65, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61,
  0x6c, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x63,
  0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x68, 0x6f,
  0x72, 0x74, 0x2d, 0x6c, 0x69, 0x76, 0x65, 0x64, 0x3c, 0x2f, 0x73, 0x70, 0x61,
  0x6e, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x76, 0x65, 0x72, 0x79, 0x20, 0x6c, 0x69, 0x74, 0x74,
  0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x68, 0x61, 0x64, 0x20, 0x61, 0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x69, 0x6e,
  0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x64, 0x63, 0x6f, 0x6d, 0x6d,
  0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x65, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65,
  0x6e, 0x74, 0x2c, 0x3c, 0x2f, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x22,
  0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x33, 0x49, 0x6e, 0x64,
  0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x70, 0x6f, 0x70, 0x75, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x2d, 0x73,
  0x63, 0x61, 0x6c, 0x65, 0x2e, 0x20, 0x41, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67,
  0x68, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65,
  0x64, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x6f,
  0x73, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x73, 0x74, 0x61, 0x72,
  0x74, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x74, 0x77, 0x6f, 0x20, 0x6f, 0x72,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x73, 0x73, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74,
  0x65, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x68,
  0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x3c, 0x2f, 0x6f,
  0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x0d, 0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x69,
  0x6e, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x61,
  0x74, 0x69, 0x6e, 0x67, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x6e, 0x6f, 0x74, 0x20,
  0x62, 0x65, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x65, 0x20, 0x6f, 0x66,
  0x69, 0x6e, 0x20, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x73, 0x69,
  0x74, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x6e, 0x73, 0x75,
  0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x74, 0x6f, 0x20, 0x63, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x20, 0x61, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x73, 0x73, 0x69,
  0x70, 0x70, 0x69, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c,
  0x79, 0x6f, 0x75, 0x74, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x62,
  0x65, 0x74, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x77, 0x68, 0x61,
  0x74, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x77, 0x73, 0x69, 0x74, 0x75, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x3d, 0x22, 0x54, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x68,
  0x65, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6f, 0x66, 0x61, 0x74, 0x6d, 0x6f,
  0x73, 0x70, 0x68, 0x65, 0x72, 0x69, 0x63, 0x69, 0x64, 0x65, 0x6f, 0x6c, 0x6f,
  0x67, 0x69, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
  0x73, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6e,
  0x67, 0x65, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x6d, 0x6e, 0x61, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x70, 0x6c, 0x75,
  0x67, 0x69, 0x6e, 0x73, 0x70, 0x61, 0x67, 0x65, 0x2f, 0x69, 0x6e, 0x64, 0x65,
  0x78, 0x2e, 0x70, 0x68, 0x70, 0x3f, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x65,
  0x64, 0x20, 0x69, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
  0x65, 0x64, 0x48, 0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f,
  0x77, 0x61, 0x73, 0x20, 0x61, 0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x73, 0x74,
  0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x20, 0x66,
  0x61, 0x76, 0x6f, 0x72, 0x20, 0x6f, 0x66, 0x4d, 0x69, 0x6e, 0x69, 0x73, 0x74,
  0x72, 0x79, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x6f, 0x66, 0x66, 0x6f, 0x72, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x69, 0x73, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x3c,
  0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x54, 0x68, 0x69,
  0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72,
  0x69, 0x7a, 0x65, 0x64, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x20,
  0x69, 0x6e, 0x61, 0x72, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x61, 0x6e, 0x64, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6d, 0x61,
  0x64, 0x65, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x65, 0x6d,
  0x73, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x79,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x50, 0x61, 0x6c, 0x65, 0x73, 0x74, 0x69, 0x6e,
  0x69, 0x61, 0x6e, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x20, 0x61, 0x66, 0x74, 0x65,
  0x72, 0x69, 0x74, 0x20, 0x68, 0x61, 0x64, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x6d,
  0x6f, 0x73, 0x74, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x74, 0x6f, 0x20,
  0x72, 0x65, 0x66, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x62, 0x75, 0x74, 0x20, 0x74,
  0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x75,
  0x74, 0x69, 0x76, 0x65, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x69,
  0x6c, 0x79, 0x49, 0x6e, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x2c,
  0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x61,
  0x6b, 0x65, 0x73, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x75, 0x62, 0x64,
  0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x69, 0x74,
  0x6f, 0x72, 0x69, 0x61, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x70, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x65, 0x6e, 0x74, 0x6c,
  0x79, 0x77, 0x61, 0x73, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x6c, 0x79, 0x6f,
  0x75, 0x74, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x73, 0x74, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x20, 0x78, 0x6d, 0x6c, 0x6e, 0x73, 0x3a,
  0x6f, 0x67, 0x3d, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74,
  0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6d, 0x61,
  0x79, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x6d, 0x61, 0x6e, 0x75,
  0x66, 0x61, 0x63, 0x74, 0x75, 0x72, 0x65, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
  0x62, 0x65, 0x69, 0x6e, 0x67, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x66, 0x69, 0x78,
  0x22, 0x3e, 0x0a, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x66, 0x77, 0x61, 0x73, 0x20, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x74,
  0x6f, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6d, 0x65, 0x20, 0x61, 0x62, 0x65, 0x63,
  0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20,
  0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x69, 0x6e, 0x73, 0x70, 0x69, 0x72, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75,
  0x6c, 0x20, 0x61, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x77, 0x68, 0x65, 0x6e,
  0x6d, 0x6f, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x61, 0x6d,
  0x6f, 0x6e, 0x67, 0x73, 0x74, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20, 0x6f,
  0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a,
  0x31, 0x30, 0x30, 0x25, 0x3b, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f,
  0x67, 0x79, 0x2c, 0x77, 0x61, 0x73, 0x20, 0x61, 0x64, 0x6f, 0x70, 0x74, 0x65,
  0x64, 0x74, 0x6f, 0x20, 0x6b, 0x65, 0x65, 0x70, 0x20, 0x74, 0x68, 0x65, 0x73,
  0x65, 0x74, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x6c, 0x69, 0x76,
  0x65, 0x20, 0x62, 0x69, 0x72, 0x74, 0x68, 0x73, 0x69, 0x6e, 0x64, 0x65, 0x78,
  0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
  0x69, 0x63, 0x75, 0x74, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x3b,
  0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x66, 0x6f, 0x72, 0x61, 0x6c,
  0x69, 0x67, 0x6e, 0x3d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x74, 0x68, 0x65, 0x20,
  0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64,
  0x20, 0x74, 0x6f, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x42, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x74,
  0x68, 0x69, 0x73, 0x20, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x71, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69,
  0x6e, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x61, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c,
  0x74, 0x20, 0x6f, 0x66, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x22, 0x20,
  0x2f, 0x3e, 0x69, 0x73, 0x20, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79,
  0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x0d, 0x0a,
  0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0d, 0x0a, 0x43, 0x6f, 0x6e, 0x76,
  0x65, 0x72, 0x73, 0x65, 0x6c, 0x79, 0x2c, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76,
  0x20, 0x69, 0x64, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68,
  0x3d, 0x22, 0x31, 0x69, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x6c,
  0x79, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6d, 0x65, 0x63,
  0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x65,
  0x20, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x63, 0x69, 0x74, 0x69, 0x7a,
  0x65, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63,
  0x69, 0x61, 0x6e, 0x73, 0x72, 0x65, 0x61, 0x63, 0x68, 0x65, 0x64, 0x20, 0x74,
  0x68, 0x65, 0x61, 0x73, 0x20, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x20, 0x61, 0x73,
  0x3a, 0x6e, 0x6f, 0x6e, 0x65, 0x3b, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x3c, 0x74,
  0x61, 0x62, 0x6c, 0x65, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x76, 0x61, 0x6c, 0x69,
  0x64, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
  0x6c, 0x79, 0x20, 0x74, 0x6f, 0x6f, 0x6e, 0x6d, 0x6f, 0x75, 0x73, 0x65, 0x64,
  0x6f, 0x77, 0x6e, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x74, 0x20, 0x69,
  0x73, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x69, 0x74, 0x20, 0x77, 0x61, 0x73, 0x6d,
  0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x72, 0x65, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x61, 0x63, 0x63, 0x6f, 0x6d,
  0x6d, 0x6f, 0x64, 0x61, 0x74, 0x65, 0x61, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x77,
  0x69, 0x74, 0x68, 0x20, 0x49, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61,
  0x74, 0x65, 0x74, 0x68, 0x65, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68,
  0x64, 0x65, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x22, 0x3e, 0x74, 0x68,
  0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x74, 0x68, 0x65, 0x20,
  0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x79, 0x20, 0x61, 0x72, 0x65, 0x61, 0x6e, 0x64, 0x20, 0x66, 0x69, 0x6e, 0x61,
  0x6c, 0x6c, 0x79, 0x61, 0x20, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x0d, 0x0a, 0x09, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x0d,
  0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x66, 0x61, 0x73,
  0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x6d, 0x61, 0x6a, 0x6f, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x77,
  0x68, 0x69, 0x63, 0x68, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x74, 0x6f, 0x20, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e,
  0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x61, 0x77,
  0x61, 0x72, 0x64, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x65, 0x72, 0x22, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x62,
  0x6f, 0x72, 0x64, 0x65, 0x72, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d,
  0x65, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x20, 0x6f, 0x66, 0x74,
  0x68, 0x65, 0x69, 0x72, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x44, 0x75, 0x72,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x69,
  0x6e, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
  0x65, 0x20, 0x6f, 0x66, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28,
  0x29, 0x7b, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x20,
  0x77, 0x6f, 0x72, 0x6b, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x62, 0x65, 0x67, 0x69,
  0x6e, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75,
  0x65, 0x6e, 0x74, 0x77, 0x61, 0x73, 0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x65,
  0x64, 0x65, 0x71, 0x75, 0x69, 0x6c, 0x69, 0x62, 0x72, 0x69, 0x75, 0x6d, 0x61,
  0x73, 0x73, 0x75, 0x6d, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x73, 0x20,
  0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x62, 0x79, 0x6e, 0x65, 0x65, 0x64, 0x73,
  0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e,
  0x61, 0x74, 0x65, 0x73, 0x74, 0x68, 0x65, 0x20, 0x76, 0x61, 0x72, 0x69, 0x6f,
  0x75, 0x73, 0x61, 0x72, 0x65, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66,
  0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x61,
  0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x69,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
  0x69, 0x65, 0x73, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x65, 0x64, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73,
  0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6f, 0x66, 0x70, 0x6f, 0x73,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x70, 0x72, 0x65, 0x73, 0x65,
  0x6e, 0x74, 0x2d, 0x64, 0x61, 0x79, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73,
  0x61, 0x6c, 0x6c, 0x79, 0x74, 0x6f, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x74,
  0x68, 0x65, 0x62, 0x75, 0x74, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61, 0x64,
  0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x74,
  0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x69, 0x73, 0x20, 0x63,
  0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x6c, 0x79, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
  0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x74,
  0x68, 0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x6d, 0x61, 0x64,
  0x65, 0x77, 0x61, 0x73, 0x20, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x77,
  0x68, 0x69, 0x63, 0x68, 0x20, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x62, 0x75, 0x74,
  0x20, 0x64, 0x69, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x4d, 0x6f, 0x75,
  0x73, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x61, 0x73, 0x20, 0x70, 0x6f, 0x73, 0x73,
  0x69, 0x62, 0x6c, 0x65, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x63, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x20, 0x66, 0x72, 0x6f, 0x6d,
  0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x61, 0x64,
  0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x66, 0x6f, 0x72, 0x20,
  0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
  0x65, 0x72, 0x72, 0x65, 0x64, 0x61, 0x20, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64,
  0x20, 0x6f, 0x66, 0x61, 0x72, 0x65, 0x20, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x74,
  0x6f, 0x68, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x69, 0x74, 0x73,
  0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x68, 0x61, 0x76, 0x65, 0x6d, 0x75, 0x63,
  0x68, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x72, 0x0a, 0x09, 0x3c, 0x2f, 0x73,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x61, 0x64, 0x6f, 0x70, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x65, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x20,
  0x6f, 0x66, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x77, 0x61,
  0x73, 0x20, 0x62, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x63, 0x68, 0x69, 0x6c,
  0x64, 0x72, 0x65, 0x6e, 0x20, 0x6f, 0x66, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61,
  0x6d, 0x6d, 0x69, 0x6e, 0x67, 0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x61, 0x6e, 0x6d, 0x61, 0x6e, 0x75, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x73, 0x77, 0x61, 0x72, 0x20, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x73, 0x74, 0x62,
  0x79, 0x20, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x61, 0x6e, 0x64,
  0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x73, 0x69, 0x6d, 0x69, 0x6c,
  0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x6f, 0x70, 0x72, 0x69, 0x65,
  0x74, 0x61, 0x72, 0x79, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69,
  0x6e, 0x67, 0x70, 0x72, 0x65, 0x73, 0x74, 0x69, 0x67, 0x69, 0x6f, 0x75, 0x73,
  0x67, 0x72, 0x61, 0x6d, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x65, 0x78,
  0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x74, 0x6f, 0x20, 0x6d,
  0x61, 0x6b, 0x65, 0x20, 0x74, 0x68, 0x65, 0x49, 0x74, 0x20, 0x77, 0x61, 0x73,
  0x20, 0x61, 0x6c, 0x73, 0x6f, 0x69, 0x73, 0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64,
  0x20, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x6f, 0x72,
  0x73, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x55, 0x2e, 0x53, 0x2e, 0x72,
  0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x62, 0x72, 0x6f,
  0x75, 0x67, 0x68, 0x74, 0x20, 0x74, 0x68, 0x65, 0x63, 0x61, 0x6c, 0x63, 0x75,
  0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x61, 0x6c, 0x6c, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72,
  0x61, 0x6c, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79,
  0x69, 0x6e, 0x20, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x20, 0x6f, 0x66, 0x72, 0x65,
  0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x72, 0x65, 0x73, 0x69,
  0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x6f,
  0x6d, 0x65, 0x20, 0x6f, 0x66, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74,
  0x6f, 0x31, 0x73, 0x74, 0x20, 0x45, 0x61, 0x72, 0x6c, 0x20, 0x6f, 0x66, 0x63,
  0x75, 0x6c, 0x74, 0x75, 0x72, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x70, 0x72, 0x69,
  0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x6c, 0x79, 0x3c, 0x2f, 0x74, 0x69, 0x74,
  0x6c, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x74, 0x68, 0x65, 0x79, 0x20, 0x63, 0x61,
  0x6e, 0x20, 0x62, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x74, 0x6f, 0x20, 0x74,
  0x68, 0x65, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x68, 0x69, 0x73,
  0x65, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x20, 0x74, 0x6f, 0x61, 0x72,
  0x65, 0x20, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x66, 0x6f, 0x72, 0x6d,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x64, 0x64, 0x46, 0x61, 0x76,
  0x6f, 0x72, 0x69, 0x74, 0x65, 0x63, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x6e, 0x73,
  0x68, 0x69, 0x70, 0x70, 0x61, 0x72, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
  0x65, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x69,
  0x6e, 0x20, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x65, 0x74, 0x6f, 0x20,
  0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x26, 0x61, 0x6d, 0x70, 0x3b,
  0x6d, 0x69, 0x6e, 0x75, 0x73, 0x3b, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73,
  0x74, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65,
  0x61, 0x6e, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x66, 0x75,
  0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x70, 0x6c, 0x61, 0x79,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22,
  0x30, 0x22, 0x20, 0x69, 0x6e, 0x20, 0x68, 0x69, 0x73, 0x20, 0x62, 0x6f, 0x6f,
  0x6b, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x61, 0x66,
  0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x20, 0x74, 0x68, 0x65, 0x63, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65,
  0x6e, 0x63, 0x65, 0x20, 0x69, 0x6e, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c,
  0x2f, 0x74, 0x64, 0x3e, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69,
  0x73, 0x74, 0x74, 0x68, 0x65, 0x20, 0x69, 0x64, 0x65, 0x61, 0x20, 0x6f, 0x66,
  0x61, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x77, 0x65,
  0x72, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x62, 0x74, 0x6e, 0x64, 0x61, 0x79, 0x73, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x73, 0x68, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x20, 0x69, 0x6e, 0x69,
  0x6e, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x75, 0x72,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x68,
  0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x4c, 0x6f, 0x72, 0x64, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c,
  0x6c, 0x79, 0x68, 0x61, 0x73, 0x20, 0x69, 0x74, 0x73, 0x20, 0x6f, 0x77, 0x6e,
  0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x70,
  0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x73, 0x6f, 0x6d, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x61, 0x63, 0x68, 0x20, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x2c, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
  0x20, 0x6f, 0x66, 0x61, 0x6e, 0x64, 0x20, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73,
  0x65, 0x61, 0x6e, 0x64, 0x20, 0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x61,
  0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x72, 0x65, 0x63,
  0x6f, 0x72, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x62, 0x6c, 0x61, 0x63, 0x6b,
  0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x6d, 0x61, 0x79, 0x20, 0x69, 0x6e, 0x63,
  0x6c, 0x75, 0x64, 0x65, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64,
  0x27, 0x73, 0x63, 0x61, 0x6e, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x74, 0x6f,
  0x72, 0x65, 0x66, 0x65, 0x72, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x67, 0x6f, 0x76, 0x65,
  0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x77, 0x69, 0x6e, 0x6e, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x74, 0x6f, 0x6e, 0x2c, 0x74,
  0x68, 0x65, 0x20, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x63, 0x69, 0x74,
  0x79, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x3e, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x72, 0x65, 0x66, 0x6c, 0x65, 0x63, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x74, 0x65, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x6d, 0x6f, 0x72, 0x65,
  0x72, 0x61, 0x64, 0x69, 0x6f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x72, 0x65,
  0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x77, 0x69, 0x74, 0x68,
  0x6f, 0x75, 0x74, 0x20, 0x61, 0x6e, 0x79, 0x68, 0x69, 0x73, 0x20, 0x66, 0x61,
  0x74, 0x68, 0x65, 0x72, 0x2c, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x63, 0x6f,
  0x75, 0x6c, 0x64, 0x63, 0x6f, 0x70, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x74, 0x6f, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x61,
  0x20, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x61, 0x63, 0x63,
  0x6f, 0x75, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x73, 0x74,
  0x69, 0x74, 0x75, 0x74, 0x65, 0x73, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x64, 0x20,
  0x77, 0x69, 0x74, 0x68, 0x65, 0x72, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c,
  0x69, 0x3e, 0x6f, 0x66, 0x20, 0x68, 0x69, 0x73, 0x20, 0x6c, 0x69, 0x66, 0x65,
  0x61, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x65, 0x64, 0x63, 0x6c,
  0x69, 0x65, 0x6e, 0x74, 0x57, 0x69, 0x64, 0x74, 0x68, 0x70, 0x72, 0x65, 0x76,
  0x65, 0x6e, 0x74, 0x20, 0x74, 0x68, 0x65, 0x4c, 0x65, 0x67, 0x69, 0x73, 0x6c,
  0x61, 0x74, 0x69, 0x76, 0x65, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x74, 0x6c, 0x79, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x69,
  0x6e, 0x68, 0x61, 0x73, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x66,
  0x6f, 0x72, 0x20, 0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x74, 0x65, 0x78,
  0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x66, 0x6f, 0x75, 0x6e, 0x64,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x69, 0x73, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x66,
  0x6f, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65,
  0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x70, 0x6c,
  0x61, 0x63, 0x65, 0x20, 0x77, 0x68, 0x65, 0x72, 0x65, 0x77, 0x68, 0x65, 0x72,
  0x65, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x3e, 0x20, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x6d, 0x73, 0x65, 0x6c, 0x76, 0x65, 0x73,
  0x2c, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x68, 0x65, 0x74,
  0x68, 0x61, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x74, 0x72, 0x61,
  0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x72, 0x6f, 0x6c, 0x65, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x20, 0x61, 0x20, 0x72, 0x65,
  0x73, 0x75, 0x6c, 0x74, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x68, 0x69,
  0x6c, 0x64, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x77, 0x65, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x53, 0x6f,
  0x6d, 0x65, 0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x70, 0x72, 0x6f, 0x64,
  0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x73, 0x69, 0x64, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x65, 0x77, 0x73, 0x6c, 0x65, 0x74, 0x74,
  0x65, 0x72, 0x73, 0x75, 0x73, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68,
  0x65, 0x64, 0x6f, 0x77, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x61,
  0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x6c, 0x69, 0x76,
  0x65, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x61, 0x74, 0x74, 0x65, 0x6d,
  0x70, 0x74, 0x73, 0x20, 0x74, 0x6f, 0x6f, 0x75, 0x74, 0x73, 0x69, 0x64, 0x65,
  0x20, 0x74, 0x68, 0x65, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x69,
  0x65, 0x73, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x69, 0x6e,
  0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x61, 0x74,
  0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x69, 0x6e, 0x61, 0x70, 0x70, 0x72,
  0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75,
  0x67, 0x68, 0x20, 0x69, 0x74, 0x77, 0x61, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74,
  0x20, 0x6f, 0x66, 0x61, 0x6e, 0x64, 0x20, 0x76, 0x61, 0x72, 0x69, 0x6f, 0x75,
  0x73, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6f, 0x72, 0x20, 0x6f, 0x66, 0x74,
  0x68, 0x65, 0x20, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x74, 0x75, 0x72,
  0x6e, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x3e, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x74, 0x68, 0x65, 0x20, 0x65, 0x63, 0x6f,
  0x6e, 0x6f, 0x6d, 0x79, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f,
  0x73, 0x74, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x77, 0x69, 0x64, 0x65, 0x6c, 0x79,
  0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x61, 0x6e,
  0x64, 0x20, 0x70, 0x65, 0x72, 0x68, 0x61, 0x70, 0x73, 0x72, 0x69, 0x73, 0x65,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x73,
  0x20, 0x77, 0x68, 0x65, 0x6e, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x77, 0x68,
  0x69, 0x63, 0x68, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x2e, 0x74, 0x68, 0x65, 0x20, 0x77, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x74,
  0x68, 0x65, 0x6f, 0x72, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x73, 0x20,
  0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20, 0x63,
  0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x68, 0x65, 0x73, 0x65, 0x65, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c,
  0x62, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x6d, 0x61,
  0x6e, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x68, 0x69, 0x73, 0x61, 0x72, 0x65, 0x61,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x74, 0x68, 0x65, 0x20, 0x57, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x54,
  0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x65, 0x78, 0x74,
  0x65, 0x6e, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x53, 0x74, 0x61, 0x74, 0x69,
  0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x63, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x6e,
  0x3d, 0x32, 0x20, 0x7c, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x20, 0x73, 0x74, 0x6f,
  0x72, 0x79, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f,
  0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x63, 0x72,
  0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x70, 0x6f,
  0x72, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x61, 0x20, 0x43, 0x68, 0x72, 0x69,
  0x73, 0x74, 0x69, 0x61, 0x6e, 0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x74, 0x6f, 0x69, 0x73, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
  0x6f, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x54,
  0x68, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x6d, 0x65, 0x72,
  0x63, 0x68, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x65, 0x66, 0x6f, 0x72, 0x20, 0x6d,
  0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x6e, 0x6f, 0x20, 0x65, 0x76, 0x69, 0x64,
  0x65, 0x6e, 0x63, 0x65, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20,
  0x6f, 0x66, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x69, 0x6e,
  0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x63, 0x6f,
  0x6d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x73, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72,
  0x6f, 0x63, 0x65, 0x73, 0x73, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x20,
  0x74, 0x68, 0x65, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65,
  0x2c, 0x69, 0x73, 0x20, 0x61, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x74,
  0x68, 0x65, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x74, 0x68, 0x65,
  0x20, 0x61, 0x6e, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x70, 0x72, 0x6f, 0x62, 0x6c,
  0x65, 0x6d, 0x73, 0x20, 0x69, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x64, 0x65, 0x66, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x61, 0x20, 0x66, 0x65, 0x77, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x6d, 0x75,
  0x63, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20,
  0x77, 0x6f, 0x72, 0x6b, 0x20, 0x6f, 0x66, 0x43, 0x61, 0x6c, 0x69, 0x66, 0x6f,
  0x72, 0x6e, 0x69, 0x61, 0x2c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x20, 0x61,
  0x73, 0x20, 0x61, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
  0x2e, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x6d,
  0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x69, 0x6e, 0x09, 0x09, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x69, 0x74, 0x22, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
  0x65, 0x20, 0x6f, 0x66, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x79, 0x20, 0x61,
  0x72, 0x65, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20, 0x69, 0x6e,
  0x69, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78,
  0x70, 0x6c, 0x61, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x64, 0x69, 0x76, 0x3e,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x09, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22,
  0x2f, 0x77, 0x61, 0x73, 0x20, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x68, 0x61, 0x76, 0x65, 0x63, 0x6f, 0x6e,
  0x74, 0x69, 0x6e, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x77, 0x61, 0x73, 0x20, 0x73,
  0x65, 0x65, 0x6e, 0x20, 0x61, 0x73, 0x61, 0x6e, 0x64, 0x20, 0x72, 0x65, 0x6c,
  0x61, 0x74, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20, 0x72, 0x6f, 0x6c, 0x65, 0x20,
  0x6f, 0x66, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x73, 0x74, 0x65, 0x61,
  0x63, 0x68, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6e, 0x73,
  0x74, 0x61, 0x6e, 0x74, 0x69, 0x6e, 0x65, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65,
  0x20, 0x66, 0x72, 0x6f, 0x6d, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x73,
  0x20, 0x6f, 0x66, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
  0x6e, 0x77, 0x61, 0x73, 0x20, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x61,
  0x20, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x61, 0x75, 0x6e, 0x63,
  0x68, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x65,
  0x73, 0x74, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65,
  0x61, 0x6e, 0x64, 0x20, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x62, 0x65,
  0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x74, 0x77, 0x6f, 0x69, 0x73, 0x20, 0x61,
  0x6c, 0x73, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73,
  0x68, 0x20, 0x61, 0x6e, 0x64, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x2c, 0x74, 0x68, 0x61, 0x74, 0x20, 0x69, 0x74, 0x20, 0x77, 0x61,
  0x73, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x74,
  0x68, 0x65, 0x6d, 0x73, 0x65, 0x6c, 0x76, 0x65, 0x73, 0x2e, 0x71, 0x75, 0x61,
  0x6e, 0x74, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x72, 0x61, 0x6e, 0x73, 0x70,
  0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d,
  0x65, 0x20, 0x61, 0x73, 0x74, 0x6f, 0x20, 0x6a, 0x6f, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x20, 0x61, 0x6e, 0x64,
  0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x54, 0x68,
  0x69, 0x73, 0x20, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x61, 0x20, 0x73, 0x74,
  0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61,
  0x73, 0x74, 0x20, 0x74, 0x6f, 0x6c, 0x61, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65,
  0x78, 0x4f, 0x66, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x68, 0x69,
  0x73, 0x69, 0x73, 0x20, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x74,
  0x68, 0x65, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x20, 0x69, 0x73, 0x69, 0x73, 0x20,
  0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x65,
  0x63, 0x74, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x67, 0x3c, 0x2f, 0x61, 0x3e, 0x3c,
  0x2f, 0x6c, 0x69, 0x3e, 0x54, 0x68, 0x65, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65,
  0x6e, 0x74, 0x74, 0x68, 0x65, 0x20, 0x73, 0x69, 0x74, 0x65, 0x20, 0x6f, 0x66,
  0x73, 0x75, 0x62, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x65, 0x78,
  0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2c, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x57, 0x65, 0x73, 0x74, 0x74, 0x68, 0x65, 0x79, 0x20, 0x73,
  0x68, 0x6f, 0x75, 0x6c, 0x64, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0xc4, 0x8d,
  0x69, 0x6e, 0x61, 0x63, 0x6f, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x69, 0x6f,
  0x73, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x64, 0x61, 0x64, 0x63,
  0x6f, 0x6e, 0x64, 0x69, 0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x61, 0x63, 0x74,
  0x69, 0x76, 0x69, 0x64, 0x61, 0x64, 0x65, 0x73, 0x65, 0x78, 0x70, 0x65, 0x72,
  0x69, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x65, 0x63, 0x6e, 0x6f, 0x6c, 0x6f,
  0x67, 0xc3, 0xad, 0x61, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x63, 0x69, 0xc3,
  0xb3, 0x6e, 0x70, 0x75, 0x6e, 0x74, 0x75, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e,
  0x61, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f,
  0x6e, 0x74, 0x72, 0x61, 0x73, 0x65, 0xc3, 0xb1, 0x61, 0x63, 0x61, 0x74, 0x65,
  0x67, 0x6f, 0x72, 0xc3, 0xad, 0x61, 0x73, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
  0x72, 0x61, 0x72, 0x73, 0x65, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x74, 0x72, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x65, 0x6e, 0x74,
  0x6f, 0x72, 0x65, 0x67, 0xc3, 0xad, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x73,
  0x65, 0x63, 0x72, 0x65, 0x74, 0x61, 0x72, 0xc3, 0xad, 0x61, 0x70, 0x72, 0x69,
  0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x74, 0x65,
  0x63, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61,
  0x6e, 0x74, 0x65, 0x73, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63,
  0x69, 0x61, 0x70, 0x6f, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x64, 0x61, 0x64,
  0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x61, 0x6e, 0x74, 0x65, 0x63, 0x72,
  0x65, 0x63, 0x69, 0x6d, 0x69, 0x65, 0x6e, 0x74, 0x6f, 0x6e, 0x65, 0x63, 0x65,
  0x73, 0x69, 0x64, 0x61, 0x64, 0x65, 0x73, 0x73, 0x75, 0x73, 0x63, 0x72, 0x69,
  0x62, 0x69, 0x72, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x63, 0x69,
  0xc3, 0xb3, 0x6e, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x6e, 0x69, 0x62, 0x6c, 0x65,
  0x73, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x65,
  0x73, 0x74, 0x75, 0x64, 0x69, 0x61, 0x6e, 0x74, 0x65, 0x73, 0x72, 0x65, 0x73,
  0x70, 0x6f, 0x6e, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x72, 0x65, 0x73, 0x6f, 0x6c,
  0x75, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x67, 0x75, 0x61, 0x64, 0x61, 0x6c, 0x61,
  0x6a, 0x61, 0x72, 0x61, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x64,
  0x6f, 0x73, 0x6f, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x6e, 0x69, 0x64, 0x61, 0x64,
  0x63, 0x6f, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x61, 0x6c, 0x65, 0x73, 0x66, 0x6f,
  0x74, 0x6f, 0x67, 0x72, 0x61, 0x66, 0xc3, 0xad, 0x61, 0x61, 0x75, 0x74, 0x6f,
  0x72, 0x69, 0x64, 0x61, 0x64, 0x65, 0x73, 0x69, 0x6e, 0x67, 0x65, 0x6e, 0x69,
  0x65, 0x72, 0xc3, 0xad, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x76, 0x69, 0x73, 0x69,
  0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x65, 0x6e, 0x63, 0x69,
  0x61, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x65,
  0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x63, 0x69, 0x64, 0x6f, 0x73, 0x69, 0x6d,
  0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x61, 0x63, 0x74, 0x75, 0x61,
  0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x76, 0x65, 0x67, 0x61, 0x63,
  0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x69, 0x64,
  0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x2d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x3a, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x3a,
  0x22, 0x20, 0x3a, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x61,
  0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6c, 0x69,
  0x6e, 0x6b, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x73, 0x70, 0x65,
  0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x2f, 0x2f, 0x3c, 0x21,
  0x5b, 0x43, 0x44, 0x41, 0x54, 0x41, 0x5b, 0x0a, 0x4f, 0x72, 0x67, 0x61, 0x6e,
  0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69,
  0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x30, 0x70, 0x78, 0x3b, 0x20, 0x68, 0x65,
  0x69, 0x67, 0x68, 0x74, 0x3a, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x68, 0x69, 0x70, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2d, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x3c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x20, 0x66, 0x6f, 0x72, 0x3d,
  0x22, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x3c, 0x2f, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x2f,
  0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x77, 0x69,
  0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x28, 0x20, 0x21, 0x69,
  0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x3b, 0x61, 0x70, 0x70, 0x6c,
  0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x70,
  0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
  0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x73, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x3c, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x22, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x75, 0x61, 0x6c,
  0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x6c, 0x65, 0x66, 0x74, 0x3a, 0x31,
  0x38, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x61, 0x6e,
  0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x6e, 0x73,
  0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x62, 0x62, 0x72,
  0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3c, 0x69, 0x6d, 0x67, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
  0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x7a,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x31, 0x39, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74,
  0x75, 0x72, 0x65, 0x69, 0x6e, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74,
  0x65, 0x64, 0x32, 0x30, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72,
  0x79, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x22, 0x3e,
  0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x79, 0x2f,
  0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x6e, 0x6f,
  0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x27, 0x75, 0x6e,
  0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x27, 0x29, 0x46, 0x75, 0x72, 0x74,
  0x68, 0x65, 0x72, 0x6d, 0x6f, 0x72, 0x65, 0x2c, 0x62, 0x65, 0x6c, 0x69, 0x65,
  0x76, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x6e, 0x6e, 0x65, 0x72, 0x48,
  0x54, 0x4d, 0x4c, 0x20, 0x3d, 0x20, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x64, 0x72, 0x61, 0x6d, 0x61, 0x74, 0x69, 0x63,
  0x61, 0x6c, 0x6c, 0x79, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x6f, 0x6e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x68, 0x65, 0x61, 0x64, 0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72,
  0x73, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61,
  0x75, 0x6e, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x50,
  0x65, 0x6e, 0x6e, 0x73, 0x79, 0x6c, 0x76, 0x61, 0x6e, 0x69, 0x61, 0x41, 0x73,
  0x20, 0x61, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2c, 0x3c, 0x68, 0x74,
  0x6d, 0x6c, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22, 0x26, 0x6c, 0x74, 0x3b,
  0x2f, 0x73, 0x75, 0x70, 0x26, 0x67, 0x74, 0x3b, 0x64, 0x65, 0x61, 0x6c, 0x69,
  0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x70, 0x68, 0x69, 0x6c, 0x61, 0x64,
  0x65, 0x6c, 0x70, 0x68, 0x69, 0x61, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x29, 0x3b, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x0a, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2d, 0x74,
  0x6f, 0x70, 0x3a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
  0x61, 0x6c, 0x67, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x65, 0x73, 0x70,
  0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3d, 0x66,
  0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x7b, 0x73, 0x75, 0x62,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x6c, 0x2e, 0x64, 0x74,
  0x64, 0x22, 0x3e, 0x0d, 0x0a, 0x3c, 0x68, 0x74, 0x67, 0x65, 0x6f, 0x67, 0x72,
  0x61, 0x70, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x69,
  0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x27, 0x2c, 0x20, 0x66, 0x75, 0x6e, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x28, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x61, 0x67, 0x72, 0x69, 0x63, 0x75, 0x6c, 0x74, 0x75,
  0x72, 0x61, 0x6c, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x20, 0x31,
  0x61, 0x20, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x45, 0x6e,
  0x63, 0x79, 0x63, 0x6c, 0x6f, 0x70, 0x65, 0x64, 0x69, 0x61, 0x69, 0x66, 0x72,
  0x61, 0x6d, 0x65, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x64, 0x65, 0x6d, 0x6f,
  0x6e, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x69, 0x74, 0x69, 0x65, 0x73, 0x44, 0x65, 0x6d, 0x6f, 0x67, 0x72, 0x61,
  0x70, 0x68, 0x69, 0x63, 0x73, 0x29, 0x3b, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x3c, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x6f, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x20,
  0x6f, 0x66, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x6c, 0x79,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x45,
  0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x20, 0x28, 0x55, 0x53, 0x29, 0x61, 0x70,
  0x70, 0x65, 0x6e, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x28, 0x74, 0x72, 0x61,
  0x6e, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x20, 0x48,
  0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x6c,
  0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x20, 0x74, 0x61, 0x62, 0x69,
  0x6e, 0x64, 0x65, 0x78, 0x3d, 0x22, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x3a, 0x72,
  0x69, 0x67, 0x68, 0x74, 0x3b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x77, 0x65,
  0x61, 0x6c, 0x74, 0x68, 0x72, 0x61, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x20, 0x66,
  0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x74,
  0x68, 0x65, 0x61, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x6e,
  0x65, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x65, 0x6e, 0x63, 0x79, 0x63, 0x6c, 0x6f, 0x70, 0x65, 0x64, 0x69, 0x61, 0x3b,
  0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x31, 0x6a, 0x75,
  0x72, 0x69, 0x73, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x74, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x3e, 0x3c, 0x61,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x49, 0x6e, 0x20, 0x61, 0x64,
  0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x20,
  0x77, 0x69, 0x74, 0x68, 0x69, 0x73, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
  0x6c, 0x6c, 0x79, 0x72, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
  0x3d, 0x22, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6e,
  0x67, 0x26, 0x6c, 0x74, 0x3b, 0x6d, 0x61, 0x74, 0x68, 0x26, 0x67, 0x74, 0x3b,
  0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f,
  0x63, 0x63, 0x61, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x3c, 0x69,
  0x6d, 0x67, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x6e, 0x61, 0x76,
  0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x63, 0x6f, 0x6d, 0x70,
  0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x68, 0x61, 0x6d, 0x70,
  0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x3d,
  0x22, 0x61, 0x6c, 0x6c, 0x22, 0x20, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
  0x65, 0x20, 0x74, 0x6f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x74, 0x72,
  0x75, 0x65, 0x3b, 0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x2f, 0x2f, 0x45, 0x4e,
  0x22, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
  0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x64, 0x69,
  0x66, 0x66, 0x69, 0x63, 0x75, 0x6c, 0x74, 0x69, 0x65, 0x73, 0x43, 0x68, 0x61,
  0x6d, 0x70, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x63, 0x61, 0x70, 0x61,
  0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x3c, 0x21, 0x5b, 0x65, 0x6e,
  0x64, 0x69, 0x66, 0x5d, 0x2d, 0x2d, 0x3e, 0x7d, 0x0a, 0x3c, 0x2f, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69,
  0x61, 0x6e, 0x69, 0x74, 0x79, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d,
  0x70, 0x6c, 0x65, 0x2c, 0x50, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x77, 0x61, 0x73, 0x20, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64,
  0x28, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x28, 0x75, 0x6e,
  0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x74, 0x68, 0x65,
  0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x2f, 0x69, 0x6e, 0x64, 0x65,
  0x78, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
  0x68, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x2f, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x6f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73,
  0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x47,
  0x75, 0x69, 0x64, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x76,
  0x65, 0x72, 0x77, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6e, 0x67, 0x61, 0x67, 0x61,
  0x69, 0x6e, 0x73, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x63,
  0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x65, 0x64, 0x2c, 0x0a, 0x2e, 0x6e, 0x6f,
  0x6e, 0x74, 0x6f, 0x75, 0x63, 0x68, 0x20, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x2f, 0x61, 0x3e, 0x0a, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x66, 0x20, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x2e, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3a, 0x20, 0x31,
  0x70, 0x78, 0x20, 0x7b, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69, 0x7a, 0x65,
  0x3a, 0x31, 0x74, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f,
  0x66, 0x30, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x31,
  0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
  0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x69,
  0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x67, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x61, 0x63, 0x68, 0x69,
  0x65, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x65, 0x73, 0x74, 0x61, 0x62,
  0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x4a, 0x61, 0x76, 0x61, 0x53, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x74, 0x68,
  0x65, 0x6c, 0x65, 0x73, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x6e, 0x63, 0x65, 0x42, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74,
  0x69, 0x6e, 0x67, 0x3e, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x2f, 0x74,
  0x64, 0x3e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x22, 0x3e,
  0x0a, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x61,
  0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x73, 0x72,
  0x63, 0x3d, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x6e, 0x61, 0x76,
  0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x20, 0x68, 0x61, 0x6c, 0x66,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x75, 0x62, 0x73, 0x74,
  0x61, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x20, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x74, 0x61,
  0x67, 0x65, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
  0x79, 0x20, 0x6f, 0x66, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x6d, 0x65, 0x6e, 0x74,
  0x61, 0x6c, 0x20, 0x6d, 0x65, 0x74, 0x72, 0x6f, 0x70, 0x6f, 0x6c, 0x69, 0x74,
  0x61, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x69, 0x74,
  0x65, 0x22, 0x20, 0x78, 0x6d, 0x6c, 0x3a, 0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22,
  0x64, 0x65, 0x6c, 0x69, 0x62, 0x65, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x61,
  0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x76,
  0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x70, 0x72, 0x65,
  0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6d, 0x70, 0x72,
  0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x62, 0x65, 0x67, 0x69, 0x6e,
  0x6e, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x4a, 0x65, 0x73, 0x75, 0x73, 0x20,
  0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x64, 0x69, 0x73, 0x61, 0x67, 0x72, 0x65, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67,
  0x6e, 0x3a, 0x72, 0x2c, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x28, 0x29, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x69, 0x65,
  0x73, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e,
  0x69, 0x73, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x61,
  0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x73,
  0x20, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x6d, 0x61, 0x6e, 0x79,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6c, 0x6f, 0x77, 0x3a,
  0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x3b, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x69, 0x6e, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
  0x65, 0x20, 0x6f, 0x66, 0x61, 0x6c, 0x6c, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x20,
  0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
  0x65, 0x74, 0x09, 0x3c, 0x75, 0x6c, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x68, 0x6f, 0x6f, 0x64, 0x61,
  0x72, 0x6d, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x73, 0x72, 0x65,
  0x64, 0x75, 0x63, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e,
  0x74, 0x69, 0x6e, 0x75, 0x65, 0x73, 0x20, 0x74, 0x6f, 0x4e, 0x6f, 0x6e, 0x65,
  0x74, 0x68, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x2c, 0x74, 0x65, 0x6d, 0x70, 0x65,
  0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x0a, 0x09, 0x09, 0x3c, 0x61, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
  0x20, 0x6f, 0x66, 0x20, 0x69, 0x73, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20,
  0x74, 0x68, 0x65, 0x28, 0x73, 0x65, 0x65, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x77,
  0x29, 0x2e, 0x22, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x73, 0x65, 0x61, 0x72, 0x63,
  0x68, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
  0x69, 0x73, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x74,
  0x68, 0x65, 0x20, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x09, 0x09,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x0a, 0x09, 0x09,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x61, 0x63, 0x63, 0x65,
  0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x68, 0x72, 0x6f, 0x75,
  0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x48, 0x61, 0x6c, 0x6c, 0x20, 0x6f,
  0x66, 0x20, 0x46, 0x61, 0x6d, 0x65, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x73, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x65, 0x72, 0x65,
  0x6e, 0x63, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x74, 0x65, 0x78,
  0x74, 0x2f, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x79, 0x65, 0x61, 0x72,
  0x73, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64,
  0x76, 0x65, 0x72, 0x79, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x7b,
  0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x3a, 0x74, 0x72,
  0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x73, 0x6f, 0x6d,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x6e,
  0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x65, 0x78, 0x70, 0x6c, 0x6f,
  0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65,
  0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x69, 0x74,
  0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x20, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
  0x79, 0x20, 0x6f, 0x66, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x6e, 0x74, 0x20, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74, 0x75, 0x72,
  0x65, 0x64, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x3e, 0x3c, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c,
  0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x62,
  0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x68, 0x61,
  0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x6e, 0x65, 0x69,
  0x67, 0x68, 0x62, 0x6f, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x77, 0x69, 0x74, 0x68,
  0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x64, 0x64, 0x65, 0x64,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x09, 0x3c, 0x6c, 0x69, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x76, 0x69, 0x65, 0x74, 0x20, 0x55,
  0x6e, 0x69, 0x6f, 0x6e, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
  0x67, 0x65, 0x64, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x63, 0x61, 0x6e, 0x20,
  0x62, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68,
  0x65, 0x61, 0x74, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f,
  0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x64,
  0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6e,
  0x20, 0x66, 0x61, 0x63, 0x74, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x6c, 0x69,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x61, 0x69, 0x6d, 0x70, 0x6c,
  0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x75, 0x69, 0x74, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x75, 0x63, 0x68, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6e, 0x69, 0x7a,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e,
  0x74, 0x69, 0x61, 0x6c, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x42, 0x75, 0x62,
  0x62, 0x6c, 0x65, 0x20, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x73, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64,
  0x72, 0x65, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d,
  0x6f, 0x72, 0x65, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x69, 0x6e,
  0x20, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x74,
  0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x72, 0x63, 0x3d,
  0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x70, 0x78, 0x3b, 0x20, 0x68,
  0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63,
  0x74, 0x75, 0x72, 0x65, 0x72, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x20, 0x72, 0x69,
  0x67, 0x68, 0x74, 0x73, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x2f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
  0x74, 0x79, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x61,
  0x6c, 0x6f, 0x75, 0x74, 0x73, 0x69, 0x64, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x61, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x61, 0x6c, 0x68,
  0x75, 0x6d, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x73, 0x6e, 0x61,
  0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x72, 0x65,
  0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x69, 0x6e, 0x61, 0x72, 0x65, 0x20,
  0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x73, 0x6d, 0x61, 0x6c, 0x6c,
  0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x70, 0x65, 0x72, 0x73,
  0x6f, 0x6e, 0x20, 0x77, 0x68, 0x6f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x61, 0x72, 0x67, 0x75, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x6e, 0x6f, 0x77, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x20, 0x61, 0x73, 0x49, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x61, 0x72,
  0x6c, 0x79, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
  0x65, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d,
  0x53, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x61, 0x76, 0x69, 0x61, 0x6e, 0x3c,
  0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x63, 0x6f,
  0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20,
  0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20,
  0x4e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x69, 0x64, 0x3d, 0x22, 0x70, 0x61, 0x67, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
  0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73,
  0x69, 0x6f, 0x6e, 0x65, 0x64, 0x61, 0x6e, 0x61, 0x6c, 0x6f, 0x67, 0x6f, 0x75,
  0x73, 0x20, 0x74, 0x6f, 0x61, 0x72, 0x65, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69,
  0x72, 0x65, 0x64, 0x2f, 0x75, 0x6c, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76,
  0x3e, 0x0a, 0x77, 0x61, 0x73, 0x20, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f,
  0x6e, 0x61, 0x6e, 0x64, 0x20, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x61,
  0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x74,
  0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x22, 0x20, 0x77, 0x61,
  0x73, 0x20, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x64, 0x6e, 0x6f, 0x20,
  0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x72, 0x65, 0x73, 0x70,
  0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x63, 0x6f, 0x6e, 0x74, 0x69,
  0x6e, 0x75, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x3e, 0x0d, 0x0a, 0x3c, 0x68, 0x65,
  0x61, 0x64, 0x3e, 0x0d, 0x0a, 0x3c, 0x77, 0x65, 0x72, 0x65, 0x20, 0x63, 0x72,
  0x65, 0x61, 0x74, 0x65, 0x64, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x67, 0x65, 0x6e,
  0x65, 0x72, 0x61, 0x6c, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x69, 0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6d, 0x70, 0x65, 0x72, 0x69, 0x61, 0x6c,
  0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x69, 0x6e,
  0x63, 0x6c, 0x75, 0x64, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6e,
  0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64,
  0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x20, 0x69, 0x6e,
  0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x65, 0x78, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76,
  0x65, 0x6c, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
  0x3a, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a,
  0x20, 0x69, 0x74, 0x73, 0x20, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
  0x69, 0x6e, 0x74, 0x6f, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x74,
  0x68, 0x69, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x61, 0x6e,
  0x20, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x68, 0x6f, 0x77,
  0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x79,
  0x20, 0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x72, 0x65, 0x6a, 0x65, 0x63,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63,
  0x69, 0x73, 0x6d, 0x20, 0x6f, 0x66, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20,
  0x77, 0x68, 0x69, 0x63, 0x68, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x6c, 0x79,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x73, 0x20, 0x61, 0x72, 0x74, 0x69,
  0x63, 0x6c, 0x65, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28,
  0x29, 0x7b, 0x49, 0x74, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62,
  0x65, 0x61, 0x6e, 0x20, 0x61, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x61, 0x63, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x6c, 0x79, 0x64,
  0x69, 0x66, 0x66, 0x65, 0x72, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x41, 0x72,
  0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x62, 0x65, 0x74,
  0x74, 0x65, 0x72, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x61, 0x72, 0x72, 0x61,
  0x6e, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x69, 0x6e, 0x66, 0x6c, 0x75,
  0x65, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x6e, 0x61, 0x74, 0x74, 0x65, 0x6e, 0x64,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x63,
  0x61, 0x6c, 0x20, 0x74, 0x6f, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x73, 0x73, 0x20, 0x74, 0x68, 0x72, 0x6f,
  0x75, 0x67, 0x68, 0x78, 0x6d, 0x6c, 0x22, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65,
  0x3d, 0x22, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x62, 0x6f, 0x6c, 0x64,
  0x3b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
  0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x6e, 0x6f, 0x6e, 0x65, 0x72,
  0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x69,
  0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x2f, 0x69, 0x68, 0x74, 0x74,
  0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x57, 0x6f, 0x72, 0x6c,
  0x64, 0x20, 0x57, 0x61, 0x72, 0x20, 0x49, 0x49, 0x74, 0x65, 0x73, 0x74, 0x69,
  0x6d, 0x6f, 0x6e, 0x69, 0x61, 0x6c, 0x73, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e,
  0x65, 0x64, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x73, 0x20, 0x6f, 0x66,
  0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x79,
  0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x62, 0x79, 0x74,
  0x68, 0x65, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
  0x6e, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e,
  0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x66, 0x65,
  0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x20,
  0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x73, 0x73, 0x22, 0x20, 0x6d,
  0x65, 0x64, 0x69, 0x61, 0x3d, 0x22, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
  0x65, 0x20, 0x6f, 0x6e, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x20, 0x62, 0x65, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x22, 0x77, 0x61, 0x73, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61,
  0x73, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x69, 0x65, 0x73, 0x20, 0x6f, 0x66,
  0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x63,
  0x6f, 0x6d, 0x70, 0x72, 0x69, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x73, 0x75,
  0x70, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x68, 0x61, 0x6e,
  0x64, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x75, 0x70,
  0x6c, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
  0x63, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x3a, 0x6e, 0x6f, 0x6e, 0x65, 0x3b, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d,
  0x61, 0x6e, 0x63, 0x65, 0x73, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x62,
  0x65, 0x69, 0x6e, 0x67, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x20, 0x62, 0x65, 0x63,
  0x61, 0x6d, 0x65, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65,
  0x64, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x66,
  0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74, 0x3e,
  0x3c, 0x6c, 0x69, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x65, 0x76,
  0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x65, 0x78, 0x70,
  0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x76, 0x69,
  0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x61,
  0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20,
  0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x49, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x61, 0x20, 0x77, 0x69, 0x64, 0x65, 0x20, 0x72, 0x61,
  0x6e, 0x67, 0x65, 0x6f, 0x6e, 0x20, 0x62, 0x65, 0x68, 0x61, 0x6c, 0x66, 0x20,
  0x6f, 0x66, 0x76, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x74, 0x6f, 0x70,
  0x22, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x6c, 0x65, 0x20, 0x6f, 0x66,
  0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x2c, 0x3c,
  0x2f, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x73, 0x61,
  0x69, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x68, 0x61, 0x76, 0x65, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x77, 0x68, 0x69, 0x6c,
  0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x68, 0x79, 0x70, 0x6f, 0x74,
  0x68, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73,
  0x6f, 0x70, 0x68, 0x65, 0x72, 0x73, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
  0x64, 0x20, 0x69, 0x6e, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64,
  0x20, 0x62, 0x79, 0x69, 0x6e, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20,
  0x74, 0x6f, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65,
  0x6e, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x74,
  0x68, 0x65, 0x20, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
  0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x72, 0x65, 0x6a,
  0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x6d, 0x70, 0x6c,
  0x69, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x6e, 0x76, 0x65, 0x6e,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74,
  0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x77, 0x61, 0x73, 0x20, 0x70, 0x72, 0x6f,
  0x62, 0x61, 0x62, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x62, 0x65, 0x74,
  0x77, 0x65, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x6f, 0x72,
  0x20, 0x6f, 0x66, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x65, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x4f, 0x63, 0x65, 0x61, 0x6e,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6c, 0x61, 0x73, 0x74, 0x77,
  0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x27, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x79, 0x65, 0x61,
  0x72, 0x73, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x54, 0x68, 0x69, 0x73,
  0x20, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x63, 0x72, 0x65,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x73, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x74, 0x72, 0x65,
  0x6d, 0x65, 0x6c, 0x79, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a,
  0x0a, 0x61, 0x6e, 0x20, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x20, 0x74, 0x6f,
  0x69, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x73, 0x70,
  0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x3e, 0x73, 0x75, 0x66,
  0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x74, 0x68, 0x65, 0x20,
  0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x61, 0x6e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
  0x72, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x54,
  0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x64, 0x69, 0x64, 0x20, 0x6e, 0x6f, 0x74,
  0x20, 0x68, 0x61, 0x76, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x74, 0x6c, 0x79, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e,
  0x65, 0x78, 0x74, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x20, 0x61, 0x6e,
  0x64, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68, 0x65,
  0x61, 0x72, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x61,
  0x6e, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e,
  0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x67, 0x69, 0x76,
  0x65, 0x6e, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74, 0x61, 0x74,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74, 0x65, 0x78, 0x70, 0x65, 0x6e,
  0x64, 0x69, 0x74, 0x75, 0x72, 0x65, 0x73, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e,
  0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x0a, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62,
  0x61, 0x73, 0x69, 0x73, 0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69,
  0x6e, 0x67, 0x3d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74,
  0x6f, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
  0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x61,
  0x73, 0x73, 0x61, 0x73, 0x73, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x73, 0x22,
  0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x61, 0x75, 0x74,
  0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x6e, 0x6f, 0x72, 0x74,
  0x68, 0x77, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x3c, 0x2f, 0x64, 0x69, 0x76,
  0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x22, 0x3e, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0d, 0x0a, 0x20, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x74,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74,
  0x79, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x69, 0x74, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20,
  0x62, 0x65, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
  0x73, 0x20, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x6c, 0x65, 0x66, 0x74,
  0x74, 0x68, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x73, 0x74, 0x73,
  0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x73, 0x75,
  0x70, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x64, 0x65, 0x70,
  0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x6e, 0x69, 0x73, 0x20, 0x6d,
  0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x77, 0x61, 0x73, 0x20, 0x69, 0x6e,
  0x76, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61,
  0x6e, 0x79, 0x69, 0x6e, 0x67, 0x68, 0x69, 0x73, 0x20, 0x70, 0x65, 0x72, 0x73,
  0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
  0x20, 0x61, 0x74, 0x73, 0x74, 0x75, 0x64, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x48, 0x75, 0x6d, 0x61, 0x6e, 0x20, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x74,
  0x65, 0x72, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73,
  0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x72, 0x65, 0x73,
  0x65, 0x61, 0x72, 0x63, 0x68, 0x20, 0x61, 0x6e, 0x64, 0x73, 0x75, 0x63, 0x63,
  0x65, 0x65, 0x64, 0x65, 0x64, 0x20, 0x62, 0x79, 0x64, 0x65, 0x66, 0x65, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x64, 0x20, 0x66, 0x72,
  0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x62, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65,
  0x79, 0x20, 0x61, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x65,
  0x72, 0x20, 0x6f, 0x66, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x79, 0x65, 0x61, 0x72, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x61,
  0x67, 0x65, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x75, 0x64, 0x79, 0x20, 0x6f,
  0x66, 0x3c, 0x75, 0x6c, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73,
  0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x77,
  0x68, 0x65, 0x72, 0x65, 0x20, 0x68, 0x65, 0x20, 0x77, 0x61, 0x73, 0x3c, 0x6c,
  0x69, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x66, 0x74, 0x68, 0x65,
  0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x68, 0x65, 0x20, 0x70, 0x75,
  0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73,
  0x73, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x65, 0x72, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x77, 0x65, 0x69, 0x67,
  0x68, 0x74, 0x3a, 0x74, 0x65, 0x72, 0x72, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x20,
  0x6f, 0x66, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
  0x3e, 0x52, 0x6f, 0x6d, 0x61, 0x6e, 0x20, 0x45, 0x6d, 0x70, 0x69, 0x72, 0x65,
  0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x49,
  0x6e, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x73, 0x74, 0x2c, 0x68, 0x6f,
  0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x20,
  0x74, 0x79, 0x70, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x61, 0x6e, 0x64, 0x20,
  0x68, 0x69, 0x73, 0x20, 0x77, 0x69, 0x66, 0x65, 0x28, 0x61, 0x6c, 0x73, 0x6f,
  0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x3e, 0x3c, 0x75, 0x6c, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
  0x76, 0x65, 0x6c, 0x79, 0x20, 0x65, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x20,
  0x69, 0x6e, 0x74, 0x6f, 0x73, 0x65, 0x65, 0x6d, 0x20, 0x74, 0x6f, 0x20, 0x68,
  0x61, 0x76, 0x65, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x6e,
  0x6f, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x63, 0x65, 0x6c, 0x6c, 0x65, 0x6e, 0x74,
  0x61, 0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x64,
  0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x20, 0x62, 0x79, 0x49, 0x6e,
  0x20, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x65, 0x2c, 0x62, 0x72, 0x6f,
  0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x63, 0x68, 0x61, 0x72,
  0x67, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x72, 0x65, 0x66, 0x6c, 0x65,
  0x63, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x6d, 0x69, 0x6c, 0x69, 0x74, 0x61, 0x72,
  0x79, 0x20, 0x61, 0x6e, 0x64, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70,
  0x6f, 0x69, 0x6e, 0x74, 0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x61,
  0x6c, 0x6c, 0x79, 0x73, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69,
  0x6e, 0x67, 0x61, 0x72, 0x65, 0x20, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x6c,
  0x79, 0x76, 0x69, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x76, 0x65, 0x72,
  0x28, 0x29, 0x3b, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x63,
  0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x6c, 0x79, 0x72, 0x65,
  0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x65, 0x76, 0x6f,
  0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x6e, 0x20, 0x65,
  0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6e, 0x6f, 0x72, 0x74, 0x68,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x77, 0x61, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72,
  0x77, 0x69, 0x73, 0x65, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x6d,
  0x20, 0x6f, 0x66, 0x68, 0x61, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65,
  0x65, 0x6e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
  0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x69,
  0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x64, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74,
  0x65, 0x72, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x68, 0x65, 0x20,
  0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x63, 0x6f, 0x6e, 0x73, 0x69,
  0x73, 0x74, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x61, 0x72, 0x65, 0x20, 0x6b, 0x6e,
  0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x65,
  0x6c, 0x64, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x69, 0x73, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x20, 0x6f, 0x66, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x20,
  0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x20, 0x74, 0x68,
  0x65, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x20, 0x6f, 0x66,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x64,
  0x75, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x69, 0x72, 0x61, 0x72,
  0x65, 0x20, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x63, 0x6f, 0x72,
  0x70, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x77, 0x61, 0x73, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x6e, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x70,
  0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72,
  0x65, 0x6e, 0x74, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20, 0x66, 0x6f,
  0x72, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x20, 0x6f, 0x66,
  0x61, 0x6e, 0x64, 0x20, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x79, 0x73,
  0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x69, 0x7a, 0x65, 0x64, 0x72, 0x65,
  0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x65, 0x78, 0x74, 0x77, 0x61, 0x73,
  0x20, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x72, 0x65, 0x63, 0x65,
  0x69, 0x76, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x73, 0x75, 0x6d,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x72, 0x65, 0x61, 0x73, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x69,
  0x6c, 0x79, 0x20, 0x69, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x73, 0x69,
  0x73, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x65,
  0x6e, 0x73, 0x65, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x20, 0x66,
  0x6f, 0x72, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x61, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x74, 0x77, 0x6f,
  0x77, 0x61, 0x73, 0x20, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x65, 0x64, 0x63,
  0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x53, 0x65,
  0x63, 0x72, 0x65, 0x74, 0x61, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x61, 0x70, 0x70,
  0x65, 0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x6d, 0x61, 0x72, 0x67,
  0x69, 0x6e, 0x2d, 0x74, 0x6f, 0x70, 0x3a, 0x31, 0x2f, 0x5e, 0x5c, 0x73, 0x2b,
  0x7c, 0x5c, 0x73, 0x2b, 0x24, 0x2f, 0x67, 0x65, 0x29, 0x7b, 0x74, 0x68, 0x72,
  0x6f, 0x77, 0x20, 0x65, 0x7d, 0x3b, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x61,
  0x72, 0x74, 0x20, 0x6f, 0x66, 0x74, 0x77, 0x6f, 0x20, 0x73, 0x65, 0x70, 0x61,
  0x72, 0x61, 0x74, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x20,
  0x61, 0x6e, 0x64, 0x77, 0x68, 0x6f, 0x20, 0x68, 0x61, 0x64, 0x20, 0x62, 0x65,
  0x65, 0x6e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x66, 0x64, 0x65, 0x61, 0x74, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x72, 0x65, 0x61, 0x6c, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x09,
  0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x70, 0x72,
  0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65,
  0x20, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6d, 0x70,
  0x65, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x67, 0x6c, 0x69,
  0x73, 0x68, 0x20, 0x28, 0x55, 0x4b, 0x29, 0x65, 0x6e, 0x67, 0x6c, 0x69, 0x73,
  0x68, 0x20, 0x28, 0x55, 0x53, 0x29, 0xd0, 0x9c, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0,
  0xb3, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xa1, 0xd1, 0x80, 0xd0, 0xbf, 0xd1, 0x81,
  0xd0, 0xba, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x80, 0xd0, 0xbf, 0xd1, 0x81, 0xd0,
  0xba, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x80, 0xd0, 0xbf, 0xd1, 0x81, 0xd0, 0xba,
  0xd0, 0xbe, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa8, 0xd9, 0x8a, 0xd8,
  0xa9, 0xe6, 0xad, 0xa3, 0xe9, 0xab, 0x94, 0xe4, 0xb8, 0xad, 0xe6, 0x96, 0x87,
  0xe7, 0xae, 0x80, 0xe4, 0xbd, 0x93, 0xe4, 0xb8, 0xad, 0xe6, 0x96, 0x87, 0xe7,
  0xb9, 0x81, 0xe4, 0xbd, 0x93, 0xe4, 0xb8, 0xad, 0xe6, 0x96, 0x87, 0xe6, 0x9c,
  0x89, 0xe9, 0x99, 0x90, 0xe5, 0x85, 0xac, 0xe5, 0x8f, 0xb8, 0xe4, 0xba, 0xba,
  0xe6, 0xb0, 0x91, 0xe6, 0x94, 0xbf, 0xe5, 0xba, 0x9c, 0xe9, 0x98, 0xbf, 0xe9,
  0x87, 0x8c, 0xe5, 0xb7, 0xb4, 0xe5, 0xb7, 0xb4, 0xe7, 0xa4, 0xbe, 0xe4, 0xbc,
  0x9a, 0xe4, 0xb8, 0xbb, 0xe4, 0xb9, 0x89, 0xe6, 0x93, 0x8d, 0xe4, 0xbd, 0x9c,
  0xe7, 0xb3, 0xbb, 0xe7, 0xbb, 0x9f, 0xe6, 0x94, 0xbf, 0xe7, 0xad, 0x96, 0xe6,
  0xb3, 0x95, 0xe8, 0xa7, 0x84, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x63,
  0x69, 0xc3, 0xb3, 0x6e, 0x68, 0x65, 0x72, 0x72, 0x61, 0x6d, 0x69, 0x65, 0x6e,
  0x74, 0x61, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0xc3, 0xb3, 0x6e, 0x69,
  0x63, 0x6f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x63, 0x69, 0xc3, 0xb3,
  0x6e, 0x63, 0x6c, 0x61, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x64, 0x6f, 0x73,
  0x63, 0x6f, 0x6e, 0x6f, 0x63, 0x69, 0x6d, 0x69, 0x65, 0x6e, 0x74, 0x6f, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x72, 0x65,
  0x6c, 0x61, 0x63, 0x69, 0x6f, 0x6e, 0x61, 0x64, 0x61, 0x73, 0x69, 0x6e, 0x66,
  0x6f, 0x72, 0x6d, 0xc3, 0xa1, 0x74, 0x69, 0x63, 0x61, 0x72, 0x65, 0x6c, 0x61,
  0x63, 0x69, 0x6f, 0x6e, 0x61, 0x64, 0x6f, 0x73, 0x64, 0x65, 0x70, 0x61, 0x72,
  0x74, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x74, 0x72, 0x61, 0x62, 0x61, 0x6a,
  0x61, 0x64, 0x6f, 0x72, 0x65, 0x73, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x61,
  0x6d, 0x65, 0x6e, 0x74, 0x65, 0x61, 0x79, 0x75, 0x6e, 0x74, 0x61, 0x6d, 0x69,
  0x65, 0x6e, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x63, 0x61, 0x64, 0x6f, 0x4c, 0x69,
  0x62, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0xc3, 0xa1, 0x63, 0x74, 0x65, 0x6e,
  0x6f, 0x73, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x63, 0x69, 0x6f, 0x6e, 0x65,
  0x73, 0x63, 0x75, 0x6d, 0x70, 0x6c, 0x69, 0x6d, 0x69, 0x65, 0x6e, 0x74, 0x6f,
  0x72, 0x65, 0x73, 0x74, 0x61, 0x75, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x73, 0x64,
  0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f,
  0x6e, 0x73, 0x65, 0x63, 0x75, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x65, 0x6c, 0x65,
  0x63, 0x74, 0x72, 0xc3, 0xb3, 0x6e, 0x69, 0x63, 0x61, 0x61, 0x70, 0x6c, 0x69,
  0x63, 0x61, 0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x64, 0x65, 0x73, 0x63, 0x6f,
  0x6e, 0x65, 0x63, 0x74, 0x61, 0x64, 0x6f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
  0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x72, 0x65, 0x61, 0x6c, 0x69, 0x7a, 0x61,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x63,
  0x69, 0xc3, 0xb3, 0x6e, 0x65, 0x6e, 0x63, 0x69, 0x63, 0x6c, 0x6f, 0x70, 0x65,
  0x64, 0x69, 0x61, 0x65, 0x6e, 0x66, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x61, 0x64,
  0x65, 0x73, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x6f,
  0x73, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x73,
  0x69, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70,
  0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x73, 0x75,
  0x62, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x61, 0xd1, 0x82, 0xd0,
  0xbe, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xa0, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x81, 0xd0, 0xb8, 0xd0, 0xb8, 0xd1, 0x80, 0xd0, 0xb0, 0xd0,
  0xb1, 0xd0, 0xbe, 0xd1, 0x82, 0xd1, 0x8b, 0xd0, 0xb1, 0xd0, 0xbe, 0xd0, 0xbb,
  0xd1, 0x8c, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xb5,
  0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb3, 0xd0,
  0xb8, 0xd1, 0x85, 0xd1, 0x81, 0xd0, 0xbb, 0xd1, 0x83, 0xd1, 0x87, 0xd0, 0xb0,
  0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xb9, 0xd1, 0x87, 0xd0, 0xb0, 0xd1,
  0x81, 0xd0, 0xb2, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb0,
  0xd0, 0xa0, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x81, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0,
  0x9c, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xb4,
  0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb3, 0xd0, 0xb8, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0,
  0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xbe,
  0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0,
  0xbd, 0xd0, 0xbd, 0xd1, 0x8b, 0xd1, 0x85, 0xd0, 0xb4, 0xd0, 0xbe, 0xd0, 0xbb,
  0xd0, 0xb6, 0xd0, 0xbd, 0xd1, 0x8b, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0,
  0xbd, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0x9c, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xba,
  0xd0, 0xb2, 0xd1, 0x8b, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb1, 0xd0, 0xbb, 0xd0,
  0xb5, 0xd0, 0xb9, 0xd0, 0x9c, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb2,
  0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbd, 0xd1,
  0x8b, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe,
  0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb5, 0xd0,
  0xb4, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xb6, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x83,
  0xd1, 0x81, 0xd0, 0xbb, 0xd1, 0x83, 0xd0, 0xb3, 0xd0, 0xb8, 0xd1, 0x82, 0xd0,
  0xb5, 0xd0, 0xbf, 0xd0, 0xb5, 0xd1, 0x80, 0xd1, 0x8c, 0xd0, 0x9e, 0xd0, 0xb4,
  0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1,
  0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x83, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb1,
  0xd0, 0xbe, 0xd1, 0x82, 0xd1, 0x83, 0xd0, 0xb0, 0xd0, 0xbf, 0xd1, 0x80, 0xd0,
  0xb5, 0xd0, 0xbb, 0xd1, 0x8f, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xb1,
  0xd1, 0x89, 0xd0, 0xb5, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0,
  0xb3, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xb3,
  0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb0, 0xd1, 0x82, 0xd1, 0x8c, 0xd0,
  0xb8, 0xd0, 0xb4, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb9,
  0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1,
  0x85, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd1, 0x88, 0xd0, 0xbe, 0xd0, 0xbf,
  0xd1, 0x80, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xb2, 0xd1, 0x81, 0xd1,
  0x81, 0xd1, 0x8b, 0xd0, 0xbb, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xb0,
  0xd0, 0xb6, 0xd0, 0xb4, 0xd1, 0x8b, 0xd0, 0xb9, 0xd0, 0xb2, 0xd0, 0xbb, 0xd0,
  0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xb3, 0xd1, 0x80, 0xd1, 0x83,
  0xd0, 0xbf, 0xd0, 0xbf, 0xd1, 0x8b, 0xd0, 0xb2, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0,
  0xb0, 0xd0, 0xbb, 0xd0, 0xbf, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb2, 0xd1, 0x8b,
  0xd0, 0xb9, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb0, 0xd1, 0x82, 0xd1,
  0x8c, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 0xd0, 0xb3, 0xd0, 0xb8,
  0xd0, 0xbf, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0,
  0xb1, 0xd0, 0xb8, 0xd0, 0xb7, 0xd0, 0xbd, 0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xbe,
  0xd1, 0x81, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xbe, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x82, 0xd0, 0xba, 0xd1, 0x83,
  0xd0, 0xbf, 0xd0, 0xb8, 0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xb4, 0xd0, 0xbe, 0xd0,
  0xbb, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbc,
  0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x85, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x87, 0xd0,
  0xb0, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xa0, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xa2, 0xd0, 0xbe, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0,
  0xba, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x81, 0xd0, 0xb5,
  0xd0, 0xbc, 0xd0, 0xb2, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0,
  0xb9, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x87, 0xd0, 0xb0, 0xd0, 0xbb, 0xd0, 0xb0,
  0xd1, 0x81, 0xd0, 0xbf, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xba, 0xd1,
  0x81, 0xd0, 0xbb, 0xd1, 0x83, 0xd0, 0xb6, 0xd0, 0xb1, 0xd1, 0x8b, 0xd1, 0x81,
  0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xbf, 0xd0,
  0xb5, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0,
  0xbc, 0xd0, 0xbe, 0xd1, 0x89, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xb9,
  0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x87, 0xd0,
  0xb5, 0xd0, 0xbc, 0xd1, 0x83, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbe,
  0xd1, 0x89, 0xd1, 0x8c, 0xd0, 0xb4, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xb6, 0xd0,
  0xbd, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x81, 0xd1, 0x8b, 0xd0, 0xbb, 0xd0, 0xba,
  0xd0, 0xb8, 0xd0, 0xb1, 0xd1, 0x8b, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0,
  0xbe, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xbd, 0xd1, 0x8b, 0xd0, 0xb5,
  0xd0, 0xbc, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb8, 0xd0, 0xb5, 0xd0,
  0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xba, 0xd1, 0x82, 0xd0, 0xa1,
  0xd0, 0xb5, 0xd0, 0xb9, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xbc, 0xd0,
  0xbe, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xb0,
  0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0,
  0xbb, 0xd0, 0xb0, 0xd0, 0xb9, 0xd0, 0xbd, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1, 0x80,
  0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x80, 0xd1,
  0x81, 0xd0, 0xb8, 0xd1, 0x8f, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0,
  0xd0, 0xbd, 0xd0, 0xb5, 0xd1, 0x84, 0xd0, 0xb8, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0,
  0xbc, 0xd1, 0x8b, 0xd1, 0x83, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbd,
  0xd1, 0x8f, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0, 0xbd, 0xd1, 0x8b, 0xd1,
  0x85, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x82, 0xd1, 0x8c,
  0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd1, 0x8e, 0xd1,
  0x8f, 0xd0, 0xbd, 0xd0, 0xb2, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x8f, 0xd0, 0xbc,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xbd, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb8, 0xd1, 0x85, 0xd0, 0xb4, 0xd0, 0xb0,
  0xd0, 0xbd, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0, 0xb7, 0xd0, 0xbd, 0xd0,
  0xb0, 0xd1, 0x87, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xbb,
  0xd1, 0x8c, 0xd0, 0xb7, 0xd1, 0x8f, 0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd1,
  0x83, 0xd0, 0xbc, 0xd0, 0xb0, 0xd0, 0xa2, 0xd0, 0xb5, 0xd0, 0xbf, 0xd0, 0xb5,
  0xd1, 0x80, 0xd1, 0x8c, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x8f, 0xd1,
  0x86, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0, 0xb0, 0xd1, 0x89, 0xd0, 0xb8, 0xd1, 0x82,
  0xd1, 0x8b, 0xd0, 0x9b, 0xd1, 0x83, 0xd1, 0x87, 0xd1, 0x88, 0xd0, 0xb8, 0xd0,
  0xb5, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0x85, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x85, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0x95, 0xe0, 0xa5,
  0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb2, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4,
  0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xae, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5,
  0x8b, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb9, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x87, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0x9f, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xad, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x86, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x81, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x98, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x9f,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0x85, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0x85, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xae, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0x9d, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xa1, 0xe0,
  0xa4, 0xbc, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9f,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x95, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb5,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5,
  0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0x97, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xa0,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x95, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb7, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb5,
  0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8b, 0xe0,
  0xa4, 0x9c, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb9, 0xe0,
  0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x89, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x82, 0xe0, 0xa4,
  0x9a, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4,
  0x9c, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x98, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0x9a, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x97, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x87, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xb9,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa1, 0xe0,
  0xa4, 0xbc, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x98, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0,
  0xa4, 0x9a, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5,
  0x80, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbc, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x9c, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x9f, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x96, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbc,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5,
  0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb2,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x96, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x85, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x88, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xab, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0x9c, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0xa4, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb5, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5,
  0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x8b, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xac,
  0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x9c, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xac,
  0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x8c, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb9, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x82, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa5, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xd8, 0xaa, 0xd8, 0xb3, 0xd8,
  0xaa, 0xd8, 0xb7, 0xd9, 0x8a, 0xd8, 0xb9, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7,
  0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xa9, 0xd8, 0xa8, 0xd9, 0x88, 0xd8, 0xa7, 0xd8,
  0xb3, 0xd8, 0xb7, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb5, 0xd9, 0x81,
  0xd8, 0xad, 0xd8, 0xa9, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xb6, 0xd9,
  0x8a, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xae, 0xd8, 0xa7, 0xd8, 0xb5,
  0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb2, 0xd9, 0x8a, 0xd8,
  0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa9,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa8, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xaf, 0xd9, 0x88, 0xd8, 0xaf, 0xd8, 0xa8,
  0xd8, 0xb1, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xac, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaf, 0xd9, 0x88, 0xd9, 0x84, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x85, 0xd9, 0x88, 0xd9, 0x82, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9,
  0xd8, 0xb1, 0xd8, 0xa8, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd8,
  0xb1, 0xd9, 0x8a, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd9, 0x88,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb0, 0xd9, 0x87, 0xd8,
  0xa7, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xad, 0xd9, 0x8a, 0xd8, 0xa7,
  0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xad, 0xd9, 0x82, 0xd9, 0x88, 0xd9,
  0x82, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd8, 0xb1, 0xd9, 0x8a, 0xd9, 0x85,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x82, 0xd9,
  0x85, 0xd8, 0xad, 0xd9, 0x81, 0xd9, 0x88, 0xd8, 0xb8, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xab, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 0x8a, 0xd9, 0x85, 0xd8,
  0xb4, 0xd8, 0xa7, 0xd9, 0x87, 0xd8, 0xaf, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84,
  0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xa3, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x82, 0xd8, 0xb1, 0xd8, 0xa2, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb4,
  0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xad, 0xd9,
  0x88, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd8, 0xaf,
  0xd9, 0x8a, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8, 0xb3, 0xd8,
  0xb1, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x88,
  0xd9, 0x85, 0xd9, 0x85, 0xd8, 0xac, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xb9, 0xd8,
  0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xad, 0xd9, 0x85, 0xd9, 0x86,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x86, 0xd9, 0x82, 0xd8, 0xa7, 0xd8, 0xb7, 0xd9,
  0x81, 0xd9, 0x84, 0xd8, 0xb3, 0xd8, 0xb7, 0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x88, 0xd9, 0x8a, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaf, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xb1,
  0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa, 0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xb1, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xb6, 0xd8, 0xaa, 0xd8, 0xad, 0xd9, 0x8a,
  0xd8, 0xa7, 0xd8, 0xaa, 0xd9, 0x8a, 0xd8, 0xa8, 0xd8, 0xaa, 0xd9, 0x88, 0xd9,
  0x82, 0xd9, 0x8a, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd9, 0x88,
  0xd9, 0x84, 0xd9, 0x89, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa8, 0xd8, 0xb1, 0xd9,
  0x8a, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x84, 0xd8, 0xa7,
  0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8,
  0xb7, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb4, 0xd8, 0xae, 0xd8, 0xb5, 0xd9, 0x8a,
  0xd8, 0xb3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xab, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xab, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xb5, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xad, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xab, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb2, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xae, 0xd9, 0x84, 0xd9, 0x8a, 0xd8, 0xac, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac,
  0xd9, 0x85, 0xd9, 0x8a, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8,
  0xa7, 0xd9, 0x85, 0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd9, 0x85,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8,
  0xb9, 0xd8, 0xa9, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd9, 0x87, 0xd8, 0xaf,
  0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xa6, 0xd9, 0x8a, 0xd8,
  0xb3, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaf, 0xd8, 0xae, 0xd9, 0x88, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xaf, 0xd9, 0x88, 0xd8, 0xb1, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaf, 0xd8, 0xb1, 0xd9, 0x88, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8, 0xb3,
  0xd8, 0xaa, 0xd8, 0xba, 0xd8, 0xb1, 0xd9, 0x82, 0xd8, 0xaa, 0xd8, 0xb5, 0xd8,
  0xa7, 0xd9, 0x85, 0xd9, 0x8a, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa8,
  0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8,
  0xb8, 0xd9, 0x8a, 0xd9, 0x85, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x74, 0x61, 0x69,
  0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61,
  0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x3d, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x28, 0x29, 0x2e, 0x6a, 0x70, 0x67, 0x22, 0x20, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x20, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3d, 0x22, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x4d, 0x61, 0x74, 0x68, 0x2e, 0x72, 0x61, 0x6e,
  0x64, 0x6f, 0x6d, 0x28, 0x29, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6d, 0x70, 0x6f,
  0x72, 0x61, 0x72, 0x79, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x53,
  0x74, 0x61, 0x74, 0x65, 0x73, 0x63, 0x69, 0x72, 0x63, 0x75, 0x6d, 0x73, 0x74,
  0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x43,
  0x68, 0x69, 0x6c, 0x64, 0x28, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x22, 0x3e, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x22, 0x2f, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75,
  0x69, 0x73, 0x68, 0x65, 0x64, 0x74, 0x68, 0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64,
  0x73, 0x20, 0x6f, 0x66, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x22, 0x3e, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x2e,
  0x69, 0x63, 0x6f, 0x22, 0x20, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x72,
  0x69, 0x67, 0x68, 0x74, 0x3a, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x61, 0x73, 0x73, 0x61, 0x63, 0x68, 0x75,
  0x73, 0x65, 0x74, 0x74, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x3d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x6b, 0x6e, 0x6f,
  0x77, 0x6e, 0x20, 0x61, 0x73, 0x70, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75,
  0x6e, 0x64, 0x3a, 0x23, 0x66, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2d,
  0x6c, 0x65, 0x66, 0x74, 0x3a, 0x46, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d,
  0x70, 0x6c, 0x65, 0x2c, 0x20, 0x6d, 0x69, 0x73, 0x63, 0x65, 0x6c, 0x6c, 0x61,
  0x6e, 0x65, 0x6f, 0x75, 0x73, 0x26, 0x6c, 0x74, 0x3b, 0x2f, 0x6d, 0x61, 0x74,
  0x68, 0x26, 0x67, 0x74, 0x3b, 0x70, 0x73, 0x79, 0x63, 0x68, 0x6f, 0x6c, 0x6f,
  0x67, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69,
  0x63, 0x75, 0x6c, 0x61, 0x72, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6d, 0x65, 0x74,
  0x68, 0x6f, 0x64, 0x3d, 0x22, 0x61, 0x73, 0x20, 0x6f, 0x70, 0x70, 0x6f, 0x73,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x53, 0x75, 0x70, 0x72, 0x65, 0x6d, 0x65, 0x20,
  0x43, 0x6f, 0x75, 0x72, 0x74, 0x6f, 0x63, 0x63, 0x61, 0x73, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x6c, 0x79, 0x20, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x6c, 0x79, 0x2c, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x20, 0x41, 0x6d,
  0x65, 0x72, 0x69, 0x63, 0x61, 0x70, 0x78, 0x3b, 0x62, 0x61, 0x63, 0x6b, 0x67,
  0x72, 0x6f, 0x75, 0x6e, 0x64, 0x6f, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x6e,
  0x69, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x74, 0x61, 0x69,
  0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x74, 0x6f, 0x4c, 0x6f, 0x77, 0x65, 0x72,
  0x43, 0x61, 0x73, 0x65, 0x28, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74,
  0x75, 0x72, 0x69, 0x6e, 0x67, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x46, 0x6f, 0x72, 0x20, 0x69, 0x6e, 0x73, 0x74,
  0x61, 0x6e, 0x63, 0x65, 0x2c, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x69,
  0x6e, 0x67, 0x20, 0x6f, 0x66, 0x22, 0x20, 0x6d, 0x61, 0x78, 0x6c, 0x65, 0x6e,
  0x67, 0x74, 0x68, 0x3d, 0x22, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x66,
  0x61, 0x6c, 0x73, 0x65, 0x3b, 0x63, 0x6f, 0x6e, 0x73, 0x63, 0x69, 0x6f, 0x75,
  0x73, 0x6e, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x64, 0x69, 0x74, 0x65, 0x72, 0x72,
  0x61, 0x6e, 0x65, 0x61, 0x6e, 0x65, 0x78, 0x74, 0x72, 0x61, 0x6f, 0x72, 0x64,
  0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x73, 0x73, 0x61, 0x73, 0x73, 0x69, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x73, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x74, 0x6c, 0x79, 0x20, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x75, 0x6d, 0x62,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x72, 0x69, 0x67,
  0x69, 0x6e, 0x61, 0x6c, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x68, 0x65,
  0x6e, 0x73, 0x69, 0x76, 0x65, 0x72, 0x65, 0x66, 0x65, 0x72, 0x73, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f, 0x75, 0x6c, 0x3e, 0x0a, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f, 0x70,
  0x68, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x2e, 0x68, 0x72, 0x65, 0x66, 0x77, 0x61, 0x73, 0x20, 0x70, 0x75, 0x62, 0x6c,
  0x69, 0x73, 0x68, 0x65, 0x64, 0x53, 0x61, 0x6e, 0x20, 0x46, 0x72, 0x61, 0x6e,
  0x63, 0x69, 0x73, 0x63, 0x6f, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x28, 0x29, 0x7b, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d,
  0x22, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x6f, 0x70, 0x68, 0x69, 0x73, 0x74, 0x69,
  0x63, 0x61, 0x74, 0x65, 0x64, 0x6d, 0x61, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x20, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0d, 0x0a,
  0x3c, 0x62, 0x6f, 0x64, 0x79, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x73,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x68, 0x69, 0x70, 0x73, 0x6d, 0x61, 0x79, 0x20, 0x68, 0x61, 0x76, 0x65,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x28, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61,
  0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x54, 0x68, 0x69, 0x73, 0x20, 0x61, 0x72, 0x74,
  0x69, 0x63, 0x6c, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20,
  0x63, 0x61, 0x73, 0x65, 0x73, 0x70, 0x61, 0x72, 0x74, 0x73, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x47, 0x72, 0x65, 0x61, 0x74, 0x20, 0x42, 0x72,
  0x69, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64,
  0x64, 0x69, 0x6e, 0x67, 0x3d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65,
  0x6e, 0x74, 0x20, 0x74, 0x6f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
  0x64, 0x65, 0x72, 0x3d, 0x22, 0x3b, 0x20, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73,
  0x69, 0x7a, 0x65, 0x3a, 0x20, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x75, 0x66, 0x66, 0x65, 0x72, 0x65, 0x64,
  0x20, 0x66, 0x72, 0x6f, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x22, 0x2f, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x28, 0x29, 0x20, 0x7b, 0x61, 0x72, 0x65, 0x20, 0x61, 0x76, 0x61, 0x69,
  0x6c, 0x61, 0x62, 0x6c, 0x65, 0x0a, 0x09, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20,
  0x72, 0x65, 0x6c, 0x3d, 0x22, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x27, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22, 0x22,
  0x20, 0x2f, 0x3e, 0x3c, 0x2f, 0x61, 0x72, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x65,
  0x72, 0x61, 0x6c, 0x6c, 0x79, 0x68, 0x61, 0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x70, 0x6f, 0x70,
  0x75, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f,
  0x6e, 0x64, 0x69, 0x6e, 0x67, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x3a, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x73, 0x70,
  0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x2e, 0x67, 0x69, 0x66, 0x22, 0x20, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3d, 0x22, 0x3c, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x20,
  0x73, 0x72, 0x63, 0x3d, 0x22, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2d, 0x62,
  0x6c, 0x6f, 0x63, 0x6b, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68, 0x65, 0x72,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d,
  0x61, 0x74, 0x65, 0x6c, 0x79, 0x70, 0x61, 0x72, 0x6c, 0x69, 0x61, 0x6d, 0x65,
  0x6e, 0x74, 0x61, 0x72, 0x79, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x61, 0x6e, 0x64,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a,
  0x6e, 0x6f, 0x6e, 0x65, 0x3b, 0x74, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x70, 0x72, 0x65, 0x64, 0x6f, 0x6d, 0x69, 0x6e,
  0x61, 0x6e, 0x74, 0x6c, 0x79, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x7c, 0x26,
  0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x2f,
  0x73, 0x70, 0x61, 0x6e, 0x3e, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x70, 0x61,
  0x63, 0x69, 0x6e, 0x67, 0x3d, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x6f, 0x72, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x61, 0x6c, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
  0x3d, 0x22, 0x6f, 0x67, 0x3a, 0x2f, 0x78, 0x2d, 0x73, 0x68, 0x6f, 0x63, 0x6b,
  0x77, 0x61, 0x76, 0x65, 0x2d, 0x64, 0x65, 0x6d, 0x6f, 0x6e, 0x73, 0x74, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x75, 0x6e, 0x64,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x4e, 0x65, 0x76, 0x65, 0x72, 0x74, 0x68, 0x65,
  0x6c, 0x65, 0x73, 0x73, 0x2c, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x66, 0x69, 0x72, 0x73, 0x74, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72,
  0x61, 0x62, 0x6c, 0x65, 0x20, 0x41, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6e,
  0x6f, 0x74, 0x20, 0x62, 0x65, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x72, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79, 0x20,
  0x61, 0x66, 0x74, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x20, 0x69, 0x6e, 0x73, 0x74,
  0x61, 0x6e, 0x63, 0x65, 0x2c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
  0x64, 0x20, 0x61, 0x73, 0x20, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c,
  0x62, 0x6f, 0x64, 0x79, 0x20, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x69,
  0x6e, 0x67, 0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x61, 0x63, 0x74,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x76,
  0x69, 0x64, 0x75, 0x61, 0x6c, 0x64, 0x69, 0x66, 0x66, 0x69, 0x63, 0x75, 0x6c,
  0x74, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x6f, 0x66,
  0x20, 0x76, 0x69, 0x65, 0x77, 0x68, 0x6f, 0x6d, 0x6f, 0x73, 0x65, 0x78, 0x75,
  0x61, 0x6c, 0x69, 0x74, 0x79, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x6e,
  0x63, 0x65, 0x20, 0x6f, 0x66, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74,
  0x75, 0x72, 0x65, 0x72, 0x73, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x6c, 0x79,
  0x20, 0x75, 0x73, 0x65, 0x64, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e,
  0x63, 0x65, 0x20, 0x6f, 0x66, 0x64, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75,
  0x6e, 0x64, 0x3a, 0x20, 0x23, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66,
  0x69, 0x63, 0x61, 0x6e, 0x74, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x3d, 0x22, 0x30, 0x22, 0x3e, 0x72, 0x65, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x72, 0x79, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x6c,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69,
  0x64, 0x65, 0x72, 0x65, 0x64, 0x77, 0x61, 0x73, 0x20, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x6f, 0x2d, 0x45, 0x75, 0x72,
  0x6f, 0x70, 0x65, 0x61, 0x6e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
  0x6c, 0x65, 0x20, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
  0x74, 0x73, 0x20, 0x6f, 0x66, 0x61, 0x72, 0x65, 0x20, 0x73, 0x6f, 0x6d, 0x65,
  0x74, 0x69, 0x6d, 0x65, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x72, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x4e, 0x65, 0x77, 0x20, 0x59, 0x6f, 0x72, 0x6b,
  0x20, 0x43, 0x69, 0x74, 0x79, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x73,
  0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x63, 0x6f, 0x75, 0x72, 0x73, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x74,
  0x69, 0x63, 0x69, 0x61, 0x6e, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65,
  0x6e, 0x64, 0x20, 0x6f, 0x66, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65,
  0x6e, 0x64, 0x20, 0x6f, 0x66, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x3d, 0x22, 0x30, 0x22, 0x20, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f,
  0x67, 0x69, 0x63, 0x61, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43,
  0x6c, 0x61, 0x73, 0x73, 0x28, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x49, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20, 0x61, 0x20, 0x73,
  0x69, 0x6e, 0x67, 0x6c, 0x65, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
  0x76, 0x65, 0x6c, 0x79, 0x2e, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x66, 0x6f, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x6c, 0x6f, 0x63, 0x61, 0x74,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x77, 0x68, 0x69, 0x63, 0x68, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73,
  0x20, 0x61, 0x6c, 0x73, 0x6f, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x61, 0x6e,
  0x63, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6e, 0x64,
  0x61, 0x73, 0x68, 0x3b, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
  0x73, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
  0x65, 0x6e, 0x74, 0x6c, 0x79, 0x65, 0x71, 0x75, 0x69, 0x70, 0x70, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74,
  0x20, 0x68, 0x61, 0x76, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x68, 0x72,
  0x65, 0x66, 0x3d, 0x22, 0x2f, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61,
  0x67, 0x65, 0x20, 0x6f, 0x66, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x54, 0x68, 0x65, 0x73, 0x65, 0x20, 0x69, 0x6e,
  0x63, 0x6c, 0x75, 0x64, 0x65, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x6c, 0x65,
  0x73, 0x73, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65,
  0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x20,
  0x74, 0x69, 0x6d, 0x65, 0x73, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
  0x74, 0x20, 0x74, 0x68, 0x65, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x69, 0x6c,
  0x69, 0x74, 0x69, 0x65, 0x73, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
  0x67, 0x65, 0x20, 0x6f, 0x66, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20, 0x61, 0x74, 0x74, 0x65, 0x6d,
  0x70, 0x74, 0x20, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6a,
  0x71, 0x75, 0x65, 0x72, 0x79, 0x74, 0x77, 0x6f, 0x20, 0x64, 0x69, 0x66, 0x66,
  0x65, 0x72, 0x65, 0x6e, 0x74, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73,
  0x68, 0x6d, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x22, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
  0x65, 0x20, 0x66, 0x6f, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x69, 0x64, 0x65, 0x20, 0x72, 0x61, 0x6e,
  0x67, 0x65, 0x20, 0x6f, 0x66, 0x09, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6d,
  0x6d, 0x6f, 0x6e, 0x6c, 0x79, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x73, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x69, 0x74, 0x79, 0x77, 0x61, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x65, 0x64, 0x20, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6d, 0x64,
  0x61, 0x73, 0x68, 0x3b, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x63, 0x68, 0x61, 0x72,
  0x61, 0x63, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x66, 0x61, 0x63, 0x74, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70,
  0x6c, 0x65, 0x20, 0x6f, 0x66, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x6e, 0x74, 0x6c, 0x79, 0x6f, 0x6e, 0x6d, 0x6f, 0x75, 0x73, 0x65, 0x6f,
  0x76, 0x65, 0x72, 0x3d, 0x22, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x79, 0x20, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x20, 0x3d, 0x20,
  0x74, 0x72, 0x75, 0x65, 0x3b, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x73,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x73, 0x65, 0x65, 0x6d, 0x73, 0x20, 0x74, 0x6f,
  0x20, 0x68, 0x61, 0x76, 0x65, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x75,
  0x6c, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x61, 0x72,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x70, 0x6f, 0x73, 0x73, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x28, 0x29, 0x20, 0x7b, 0x74, 0x6f, 0x6f, 0x6b, 0x20, 0x70, 0x6c, 0x61,
  0x63, 0x65, 0x20, 0x69, 0x6e, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x6f, 0x6d, 0x65,
  0x74, 0x69, 0x6d, 0x65, 0x73, 0x73, 0x75, 0x62, 0x73, 0x74, 0x61, 0x6e, 0x74,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x2f,
  0x73, 0x70, 0x61, 0x6e, 0x3e, 0x69, 0x73, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e,
  0x20, 0x75, 0x73, 0x65, 0x64, 0x69, 0x6e, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x74,
  0x74, 0x65, 0x6d, 0x70, 0x74, 0x67, 0x72, 0x65, 0x61, 0x74, 0x20, 0x64, 0x65,
  0x61, 0x6c, 0x20, 0x6f, 0x66, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x6c, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66,
  0x75, 0x6c, 0x6c, 0x79, 0x20, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x6c,
  0x79, 0x20, 0x61, 0x6c, 0x6c, 0x32, 0x30, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x2c, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x73, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73, 0x61, 0x72,
  0x79, 0x20, 0x74, 0x6f, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20,
  0x69, 0x74, 0x20, 0x69, 0x73, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61,
  0x72, 0x79, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x6c, 0x6c,
  0x6f, 0x77, 0x69, 0x6e, 0x67, 0x6d, 0x61, 0x79, 0x20, 0x72, 0x65, 0x66, 0x65,
  0x72, 0x20, 0x74, 0x6f, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x74, 0x6c, 0x79, 0x2c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x61, 0x74, 0x20, 0x77, 0x6f, 0x75,
  0x6c, 0x64, 0x20, 0x62, 0x65, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x27, 0x73, 0x20,
  0x66, 0x69, 0x72, 0x73, 0x74, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
  0x65, 0x64, 0x20, 0x61, 0x73, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x28, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75,
  0x6c, 0x61, 0x72, 0x6c, 0x79, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x6c,
  0x65, 0x66, 0x74, 0x22, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x63, 0x6f, 0x6d,
  0x6d, 0x6f, 0x6e, 0x6c, 0x79, 0x62, 0x61, 0x73, 0x69, 0x73, 0x20, 0x66, 0x6f,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x69,
  0x74, 0x79, 0x20, 0x6f, 0x66, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x64, 0x75, 0x63,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x6a, 0x75, 0x72, 0x69, 0x73, 0x64, 0x69, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x6e, 0x6d, 0x6f, 0x75, 0x73, 0x65,
  0x6f, 0x75, 0x74, 0x3d, 0x22, 0x4e, 0x65, 0x77, 0x20, 0x54, 0x65, 0x73, 0x74,
  0x61, 0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c,
  0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x55,
  0x6e, 0x69, 0x74, 0x65, 0x64, 0x66, 0x69, 0x6c, 0x6d, 0x20, 0x64, 0x69, 0x72,
  0x65, 0x63, 0x74, 0x6f, 0x72, 0x2d, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x2e,
  0x64, 0x74, 0x64, 0x22, 0x3e, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e,
  0x20, 0x75, 0x73, 0x65, 0x64, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x74, 0x68, 0x69, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x20,
  0x6f, 0x74, 0x68, 0x65, 0x72, 0x62, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x61, 0x72, 0x65, 0x75, 0x6e, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64,
  0x65, 0x6e, 0x74, 0x65, 0x64, 0x69, 0x73, 0x20, 0x73, 0x69, 0x6d, 0x69, 0x6c,
  0x61, 0x72, 0x20, 0x74, 0x6f, 0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
  0x6c, 0x79, 0x20, 0x69, 0x6e, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20,
  0x62, 0x6f, 0x6c, 0x64, 0x3b, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x09, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x72, 0x65, 0x20, 0x74, 0x79, 0x70, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x6e, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70,
  0x6c, 0x65, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x69,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x72, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x61, 0x6e, 0x20, 0x61, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x65, 0x6c, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73, 0x61, 0x72,
  0x79, 0x20, 0x66, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61,
  0x6c, 0x20, 0x61, 0x6e, 0x64, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x6e,
  0x62, 0x73, 0x70, 0x3b, 0x3c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
  0x65, 0x73, 0x20, 0x74, 0x6f, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65,
  0x20, 0x79, 0x65, 0x61, 0x72, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x68, 0x61, 0x76, 0x65, 0x20, 0x6e, 0x6f, 0x74,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x20,
  0x79, 0x65, 0x61, 0x72, 0x73, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x74, 0x6f, 0x09, 0x09, 0x3c, 0x75, 0x6c, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x31, 0x39, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x2c, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x65, 0x72, 0x73, 0x74, 0x68, 0x61, 0x74, 0x20, 0x68, 0x65, 0x20,
  0x77, 0x6f, 0x75, 0x6c, 0x64, 0x61, 0x6e, 0x64, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x69, 0x6e, 0x75, 0x65, 0x64, 0x6f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e,
  0x65, 0x64, 0x20, 0x61, 0x73, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x61, 0x6d, 0x6f, 0x75,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x74, 0x69, 0x61, 0x74, 0x65, 0x62, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x20,
  0x61, 0x62, 0x6f, 0x75, 0x74, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x6c,
  0x65, 0x66, 0x74, 0x3a, 0x20, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x20,
  0x6f, 0x66, 0x20, 0x61, 0x73, 0x53, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x73, 0x65, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x72, 0x65, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x61, 0x73, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x63, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x64,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x20, 0x70, 0x61,
  0x72, 0x74, 0x20, 0x6f, 0x66, 0x49, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74,
  0x65, 0x20, 0x66, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x20, 0x73, 0x6f, 0x2d, 0x63,
  0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x73, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6e, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
  0x63, 0x61, 0x73, 0x65, 0x2c, 0x77, 0x61, 0x73, 0x20, 0x61, 0x70, 0x70, 0x6f,
  0x69, 0x6e, 0x74, 0x65, 0x64, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x74, 0x68, 0x69, 0x73, 0x44, 0x65, 0x70, 0x61, 0x72, 0x74, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x6d, 0x61,
  0x69, 0x6e, 0x69, 0x6e, 0x67, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x20, 0x6f,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c,
  0x61, 0x72, 0x6c, 0x79, 0x20, 0x64, 0x65, 0x61, 0x6c, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x61, 0x6c, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x61,
  0x6c, 0x77, 0x61, 0x79, 0x73, 0x61, 0x72, 0x65, 0x20, 0x63, 0x75, 0x72, 0x72,
  0x65, 0x6e, 0x74, 0x6c, 0x79, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f, 0x70,
  0x68, 0x79, 0x20, 0x6f, 0x66, 0x66, 0x6f, 0x72, 0x20, 0x6d, 0x6f, 0x72, 0x65,
  0x20, 0x74, 0x68, 0x61, 0x6e, 0x63, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x7a, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69,
  0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64,
  0x49, 0x6e, 0x64, 0x65, 0x78, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x65, 0x73, 0x75,
  0x6c, 0x74, 0x20, 0x69, 0x6e, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d,
  0x22, 0x22, 0x20, 0x2f, 0x3e, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x20, 0x2f, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x4d, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x73, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x55,
  0x6e, 0x69, 0x74, 0x65, 0x64, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x6d, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x74,
  0x72, 0x61, 0x63, 0x65, 0x64, 0x69, 0x73, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x6f,
  0x6e, 0x65, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x66, 0x72, 0x65, 0x71, 0x75,
  0x65, 0x6e, 0x74, 0x6c, 0x79, 0x6c, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x65, 0x74, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x72, 0x79, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x69, 0x6e, 0x69, 0x73, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72,
  0x6d, 0x69, 0x6e, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x69,
  0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65,
  0x6e, 0x74, 0x20, 0x74, 0x6f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x20, 0x73, 0x74,
  0x6f, 0x72, 0x69, 0x65, 0x73, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x61, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x68,
  0x65, 0x74, 0x68, 0x65, 0x72, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x66, 0x6f,
  0x72, 0x20, 0x69, 0x74, 0x73, 0x77, 0x61, 0x73, 0x20, 0x69, 0x6e, 0x69, 0x74,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a,
  0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x65, 0x78,
  0x61, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x69, 0x6e,
  0x63, 0x69, 0x70, 0x61, 0x6c, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x73,
  0x20, 0x6f, 0x66, 0x20, 0x61, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
  0x65, 0x64, 0x20, 0x61, 0x73, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x61, 0x20, 0x73, 0x75, 0x62, 0x73, 0x74, 0x61,
  0x6e, 0x74, 0x69, 0x61, 0x6c, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72,
  0x75, 0x63, 0x74, 0x65, 0x64, 0x68, 0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x20,
  0x73, 0x74, 0x61, 0x74, 0x65, 0x72, 0x65, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
  0x63, 0x65, 0x20, 0x74, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x67, 0x72, 0x61,
  0x64, 0x75, 0x61, 0x74, 0x65, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72,
  0x65, 0x20, 0x74, 0x77, 0x6f, 0x67, 0x72, 0x61, 0x76, 0x69, 0x74, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x72, 0x65, 0x20, 0x64, 0x65, 0x73, 0x63,
  0x72, 0x69, 0x62, 0x65, 0x64, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x20, 0x61,
  0x73, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x68,
  0x65, 0x61, 0x64, 0x65, 0x72, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x6d, 0x65, 0x6e,
  0x74, 0x61, 0x6c, 0x6c, 0x79, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x6f, 0x74, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x77, 0x61, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x63,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
  0x76, 0x65, 0x6c, 0x79, 0x2c, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x6f, 0x6c, 0x69,
  0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6f,
  0x72, 0x74, 0x20, 0x6f, 0x66, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x32, 0x30, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x75, 0x62, 0x6c,
  0x69, 0x73, 0x68, 0x65, 0x64, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x68, 0x61, 0x72,
  0x74, 0x62, 0x65, 0x61, 0x74, 0x74, 0x6f, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72,
  0x73, 0x74, 0x61, 0x6e, 0x64, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x73,
  0x74, 0x61, 0x74, 0x65, 0x73, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x6c, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x68, 0x61,
  0x6c, 0x66, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65,
  0x73, 0x20, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63,
  0x74, 0x75, 0x72, 0x61, 0x6c, 0x62, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69,
  0x64, 0x65, 0x72, 0x65, 0x64, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65,
  0x72, 0x69, 0x7a, 0x65, 0x64, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x49, 0x6e, 0x74,
  0x65, 0x72, 0x76, 0x61, 0x6c, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
  0x61, 0x74, 0x69, 0x76, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x77, 0x61, 0x73, 0x20, 0x73, 0x75, 0x63, 0x63,
  0x65, 0x65, 0x64, 0x65, 0x64, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x61, 0x72, 0x65, 0x61, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x71,
  0x75, 0x65, 0x6e, 0x63, 0x65, 0x74, 0x68, 0x65, 0x20, 0x50, 0x72, 0x65, 0x73,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x69, 0x6e, 0x63,
  0x6c, 0x75, 0x64, 0x65, 0x64, 0x66, 0x72, 0x65, 0x65, 0x20, 0x73, 0x6f, 0x66,
  0x74, 0x77, 0x61, 0x72, 0x65, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x77, 0x61, 0x73, 0x20, 0x64, 0x65, 0x73, 0x74,
  0x72, 0x6f, 0x79, 0x65, 0x64, 0x61, 0x77, 0x61, 0x79, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x20, 0x74, 0x68, 0x65, 0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x74, 0x68, 0x65, 0x79, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
  0x20, 0x62, 0x79, 0x20, 0x61, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x70, 0x6f, 0x77,
  0x65, 0x72, 0x66, 0x75, 0x6c, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x20, 0x61, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69,
  0x74, 0x79, 0x20, 0x6f, 0x66, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x6d, 0x61, 0x6e, 0x79, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x65, 0x73,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x73, 0x6f, 0x6d, 0x65, 0x69, 0x73, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x67,
  0x68, 0x74, 0x20, 0x74, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x65, 0x6e, 0x64, 0x77, 0x61, 0x73, 0x20, 0x61, 0x6e, 0x6e, 0x6f,
  0x75, 0x6e, 0x63, 0x65, 0x64, 0x61, 0x72, 0x65, 0x20, 0x69, 0x6d, 0x70, 0x6f,
  0x72, 0x74, 0x61, 0x6e, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x69, 0x6e, 0x63,
  0x6c, 0x75, 0x64, 0x65, 0x73, 0x3e, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x74, 0x68, 0x65, 0x20, 0x63, 0x65, 0x6e, 0x74,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x44, 0x4f, 0x20, 0x4e, 0x4f, 0x54, 0x20,
  0x41, 0x4c, 0x54, 0x45, 0x52, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
  0x72, 0x65, 0x66, 0x65, 0x72, 0x74, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x2f, 0x3f,
  0x73, 0x6f, 0x72, 0x74, 0x3d, 0x74, 0x68, 0x61, 0x74, 0x20, 0x68, 0x61, 0x64,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x73, 0x69,
  0x73, 0x20, 0x66, 0x6f, 0x72, 0x68, 0x61, 0x73, 0x20, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x65, 0x64, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73,
  0x75, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x61, 0x74,
  0x69, 0x76, 0x65, 0x6c, 0x79, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x20,
  0x74, 0x68, 0x6f, 0x73, 0x65, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x75,
  0x6c, 0x74, 0x69, 0x6e, 0x67, 0x69, 0x73, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x73,
  0x73, 0x69, 0x62, 0x6c, 0x65, 0x76, 0x61, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x20,
  0x6f, 0x74, 0x68, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66,
  0x72, 0x69, 0x63, 0x61, 0x6e, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x73, 0x61, 0x6d, 0x65, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
  0x65, 0x6e, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68,
  0x20, 0x63, 0x61, 0x73, 0x65, 0x3b, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61,
  0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
  0x65, 0x20, 0x61, 0x6e, 0x64, 0x3b, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72,
  0x6f, 0x75, 0x6e, 0x64, 0x3a, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20,
  0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d,
  0x61, 0x72, 0x67, 0x69, 0x6e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x62, 0x61, 0x68, 0x61, 0x73, 0x61, 0x20, 0x4d,
  0x65, 0x6c, 0x61, 0x79, 0x75, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x62, 0x6f,
  0x6b, 0x6d, 0xc3, 0xa5, 0x6c, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x6e, 0x79,
  0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0xc5, 0xa1,
  0xc4, 0x8d, 0x69, 0x6e, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x63,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x63, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x22, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x69,
  0x67, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
  0x4e, 0x61, 0x6d, 0x65, 0x27, 0x2c, 0x20, 0x27, 0x61, 0x64, 0x6d, 0x69, 0x6e,
  0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x69, 0x6d, 0x75,
  0x6c, 0x74, 0x61, 0x6e, 0x65, 0x6f, 0x75, 0x73, 0x6c, 0x79, 0x74, 0x72, 0x61,
  0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
  0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x6d,
  0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x3a,
  0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
  0x79, 0x3c, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d, 0x2d, 0x2d, 0x3e,
  0x0a, 0x3c, 0x2f, 0x3e, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x22, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
  0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x2d,
  0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x3a, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64,
  0x3e, 0x0a, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x3d, 0x68, 0x74, 0x74, 0x70,
  0x25, 0x33, 0x41, 0x25, 0x32, 0x46, 0x25, 0x32, 0x46, 0x3c, 0x66, 0x6f, 0x72,
  0x6d, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x6d, 0x65, 0x74,
  0x68, 0x6f, 0x64, 0x3d, 0x22, 0x70, 0x6f, 0x73, 0x74, 0x22, 0x20, 0x2f, 0x66,
  0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x2e, 0x69, 0x63, 0x6f, 0x22, 0x20, 0x7d,
  0x29, 0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a,
  0x2e, 0x73, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
  0x28, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x3d, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x41, 0x72, 0x72, 0x61, 0x79,
  0x28, 0x29, 0x3b, 0x3c, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d, 0x2d,
  0x2d, 0x3e, 0x0d, 0x0a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x62,
  0x6c, 0x6f, 0x63, 0x6b, 0x3b, 0x55, 0x6e, 0x66, 0x6f, 0x72, 0x74, 0x75, 0x6e,
  0x61, 0x74, 0x65, 0x6c, 0x79, 0x2c, 0x22, 0x3e, 0x26, 0x6e, 0x62, 0x73, 0x70,
  0x3b, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x2f, 0x66, 0x61, 0x76, 0x69, 0x63,
  0x6f, 0x6e, 0x2e, 0x69, 0x63, 0x6f, 0x22, 0x3e, 0x3d, 0x27, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x27, 0x20, 0x69, 0x64, 0x65, 0x6e,
  0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x66,
  0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x3c, 0x6c,
  0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x61,
  0x6e, 0x20, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65,
  0x61, 0x73, 0x20, 0x61, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x20, 0x6f,
  0x66, 0x70, 0x74, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x0a, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x73, 0x75, 0x62, 0x6d, 0x69,
  0x74, 0x22, 0x20, 0x0a, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x28, 0x29, 0x20, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x61, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
  0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x73,
  0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x2e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x20, 0x41, 0x63, 0x63,
  0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x68, 0x69, 0x64,
  0x64, 0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x6c,
  0x6f, 0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x64,
  0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x62, 0x6f, 0x64, 0x79, 0x2e,
  0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x6c, 0x79,
  0x20, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x70, 0x6f, 0x73, 0x74, 0x22, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x3d, 0x22, 0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x2d, 0x2d, 0x3c, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69,
  0x66, 0x5d, 0x2d, 0x2d, 0x3e, 0x50, 0x72, 0x69, 0x6d, 0x65, 0x20, 0x4d, 0x69,
  0x6e, 0x69, 0x73, 0x74, 0x65, 0x72, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
  0x65, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x3c, 0x2f, 0x61, 0x3e, 0x20, 0x3c,
  0x61, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x74, 0x68, 0x65, 0x20, 0x68,
  0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x6f, 0x6e, 0x6d,
  0x6f, 0x75, 0x73, 0x65, 0x6f, 0x76, 0x65, 0x72, 0x3d, 0x22, 0x74, 0x68, 0x65,
  0x20, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x68, 0x72,
  0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
  0x61, 0x73, 0x20, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79,
  0x77, 0x61, 0x73, 0x20, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
  0x64, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74,
  0x69, 0x76, 0x65, 0x61, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64,
  0x65, 0x72, 0x65, 0x64, 0x3c, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d,
  0x2d, 0x2d, 0x3e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x73, 0x20,
  0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73,
  0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x6e, 0x20, 0x63, 0x6f, 0x6e,
  0x74, 0x72, 0x61, 0x73, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6c, 0x61, 0x63,
  0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x63, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x63, 0x6f,
  0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x2d,
  0x3a, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x20,
  0x7b, 0x42, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x2d, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x2e, 0x64, 0x74, 0x64,
  0x22, 0x3e, 0x0a, 0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x61, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x2f, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x61,
  0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x73, 0x29, 0x3b,
  0x20, 0x6a, 0x73, 0x2e, 0x69, 0x64, 0x20, 0x3d, 0x20, 0x69, 0x64, 0x22, 0x20,
  0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x30, 0x25, 0x22, 0x72,
  0x65, 0x67, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x52, 0x6f, 0x6d, 0x61, 0x6e, 0x20, 0x43, 0x61, 0x74, 0x68, 0x6f, 0x6c, 0x69,
  0x63, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
  0x6e, 0x74, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x2e, 0x67, 0x69, 0x66, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74,
  0x68, 0x3d, 0x22, 0x31, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x69, 0x6e, 0x67, 0x20, 0x64, 0x69, 0x73, 0x63, 0x72, 0x69, 0x6d, 0x69,
  0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x61, 0x65, 0x6f,
  0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x70, 0x72, 0x69, 0x6d, 0x65, 0x20,
  0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6a, 0x73, 0x22, 0x3e,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x63, 0x6f, 0x6d, 0x62,
  0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x6d, 0x61,
  0x72, 0x67, 0x69, 0x6e, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x63, 0x72,
  0x65, 0x61, 0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x28, 0x77,
  0x2e, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x28,
  0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72,
  0x3e, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
  0x2f, 0x61, 0x49, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c,
  0x61, 0x72, 0x2c, 0x20, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x6c, 0x65,
  0x66, 0x74, 0x22, 0x20, 0x43, 0x7a, 0x65, 0x63, 0x68, 0x20, 0x52, 0x65, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x63, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b,
  0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70,
  0x6f, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x6c, 0x75,
  0x64, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x2e, 0x68, 0x74, 0x6d, 0x6c,
  0x22, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22, 0x28, 0x66, 0x75, 0x6e,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x29, 0x20, 0x7b, 0x63, 0x6f, 0x6d,
  0x65, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x61, 0x70,
  0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x3c,
  0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73,
  0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62,
  0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x28, 0x27, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x27, 0x3c, 0x2f, 0x61, 0x3e, 0x0a, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x0a,
  0x3c, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x74, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x28, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x6b,
  0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x09, 0x3c, 0x6c, 0x69, 0x3e, 0x3c,
  0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x3e, 0x3c, 0x69, 0x6e, 0x70,
  0x75, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x73, 0x65, 0x70, 0x61,
  0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x72, 0x65, 0x66,
  0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x73, 0x20, 0x76,
  0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x74, 0x6f, 0x70, 0x22, 0x3e, 0x66,
  0x6f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f,
  0x20, 0x63, 0x61, 0x72, 0x62, 0x6f, 0x6e, 0x20, 0x64, 0x69, 0x6f, 0x78, 0x69,
  0x64, 0x65, 0x0a, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73, 0x65, 0x61,
  0x72, 0x63, 0x68, 0x2d, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x6f, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x6e,
  0x69, 0x74, 0x79, 0x20, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64,
  0x3e, 0x0d, 0x0a, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x3d, 0x22, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x54, 0x69, 0xe1, 0xba,
  0xbf, 0x6e, 0x67, 0x20, 0x56, 0x69, 0xe1, 0xbb, 0x87, 0x74, 0x63, 0x68, 0x61,
  0x6e, 0x67, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x2d, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x30,
  0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x20,
  0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x3c, 0x77, 0x61, 0x73, 0x20, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
  0x65, 0x64, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78,
  0x74, 0x22, 0x20, 0x29, 0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x3e, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x61, 0x72, 0x74, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x6f, 0x66, 0x20, 0x65, 0x63, 0x63, 0x6c, 0x65, 0x73, 0x69, 0x61,
  0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x68,
  0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
  0x69, 0x6e, 0x67, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x3c, 0x2f, 0x62, 0x6f, 0x64,
  0x79, 0x3e, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x68, 0x61, 0x73, 0x20,
  0x6e, 0x65, 0x76, 0x65, 0x72, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x74, 0x68, 0x65,
  0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x69, 0x6e,
  0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x74, 0x6f, 0x61,
  0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x20,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x69, 0x77, 0x61, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72,
  0x65, 0x64, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x22, 0x20, 0x2f, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x65,
  0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74,
  0x2d, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x74, 0x6f, 0x20, 0x62, 0x65,
  0x20, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x65, 0x64, 0x6d, 0x65, 0x6d, 0x62,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x64,
  0x64, 0x69, 0x6e, 0x67, 0x2d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x74, 0x72,
  0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69,
  0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x77, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x6f, 0x72, 0x20, 0x6e,
  0x6f, 0x74, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x61,
  0x6c, 0x73, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20,
  0x6d, 0x61, 0x6e, 0x79, 0x61, 0x20, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x20, 0x6e,
  0x75, 0x6d, 0x62, 0x65, 0x72, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x70, 0x61,
  0x72, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x6d, 0x70, 0x6f, 0x73, 0x73, 0x69,
  0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x6c, 0x6f, 0x63, 0x61, 0x74,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x2e, 0x20, 0x48, 0x6f,
  0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x64,
  0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x41, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x62,
  0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x74, 0x73,
  0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x74, 0x68,
  0x65, 0x3c, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x3d, 0x22, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x70, 0x6f,
  0x73, 0x74, 0x22, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x70, 0x6f, 0x73, 0x73,
  0x69, 0x62, 0x6c, 0x65, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x6c, 0x69, 0x6b, 0x65,
  0x6c, 0x79, 0x20, 0x74, 0x6f, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x65,
  0x61, 0x73, 0x65, 0x20, 0x69, 0x6e, 0x68, 0x61, 0x76, 0x65, 0x20, 0x61, 0x6c,
  0x73, 0x6f, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73,
  0x70, 0x6f, 0x6e, 0x64, 0x73, 0x20, 0x74, 0x6f, 0x61, 0x6e, 0x6e, 0x6f, 0x75,
  0x6e, 0x63, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x67,
  0x6e, 0x3d, 0x22, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3e, 0x6d, 0x61, 0x6e,
  0x79, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x66, 0x6f,
  0x72, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x65,
  0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x69, 0x74, 0x20, 0x77, 0x61,
  0x73, 0x70, 0x74, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x0d, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x74, 0x6f,
  0x70, 0x22, 0x20, 0x69, 0x6e, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x6e, 0x74,
  0x73, 0x20, 0x6f, 0x66, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x20, 0x79, 0x65, 0x61, 0x72, 0x0d, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x6f, 0x6e,
  0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
  0x76, 0x65, 0x72, 0x73, 0x69, 0x61, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x63, 0x65,
  0x72, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x61, 0x72, 0x67, 0x75,
  0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x67, 0x6f, 0x76,
  0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x61, 0x20,
  0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x6f, 0x74,
  0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x63, 0x6f, 0x6c, 0x6f,
  0x72, 0x3a, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68,
  0x65, 0x72, 0x65, 0x62, 0x65, 0x73, 0x74, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x20, 0x66, 0x6f, 0x72, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68,
  0x61, 0x6e, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x63,
  0x69, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x64, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x20, 0x3c,
  0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x45, 0x6e,
  0x74, 0x65, 0x72, 0x74, 0x61, 0x69, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x61,
  0x77, 0x61, 0x79, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x3b, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x72, 0x69, 0x67, 0x68, 0x74,
  0x3a, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20,
  0x6f, 0x66, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20,
  0x77, 0x69, 0x74, 0x68, 0x61, 0x6e, 0x64, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x20,
  0x6f, 0x74, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x69, 0x74, 0x20, 0x69, 0x73, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69,
  0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x3c, 0x73, 0x70, 0x61, 0x6e,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x64, 0x65, 0x73, 0x63, 0x65,
  0x6e, 0x64, 0x61, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x3c, 0x73, 0x70, 0x61,
  0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x20, 0x61, 0x6c,
  0x69, 0x67, 0x6e, 0x3d, 0x22, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3c, 0x2f,
  0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x61,
  0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x68, 0x61, 0x73, 0x20, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x20, 0x62, 0x65, 0x65,
  0x6e, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x61, 0x6e, 0x20, 0x55, 0x6e, 0x69,
  0x6f, 0x6e, 0x72, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x63, 0x65, 0x6e, 0x74,
  0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x64, 0x69, 0x66, 0x66, 0x69,
  0x63, 0x75, 0x6c, 0x74, 0x56, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x65, 0x73,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x20,
  0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x69,
  0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x66, 0x6f, 0x6e, 0x74, 0x2d,
  0x73, 0x69, 0x7a, 0x65, 0x3a, 0x31, 0x31, 0x70, 0x78, 0x65, 0x78, 0x70, 0x6c,
  0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65,
  0x20, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x20, 0x6f, 0x66, 0x77, 0x72,
  0x69, 0x74, 0x74, 0x65, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x09,
  0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x69, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x72, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20,
  0x74, 0x6f, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x67, 0x72, 0x6f, 0x75,
  0x6e, 0x64, 0x73, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x73, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x69,
  0x64, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x70, 0x70,
  0x6f, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x69, 0x6e,
  0x70, 0x75, 0x74, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x73,
  0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x74, 0x28,
  0x4d, 0x61, 0x74, 0x68, 0x2e, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x28, 0x29,
  0x6d, 0x6f, 0x73, 0x74, 0x20, 0x70, 0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x65, 0x6e,
  0x74, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x6e, 0x6f,
  0x70, 0x6c, 0x65, 0x77, 0x65, 0x72, 0x65, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69,
  0x73, 0x68, 0x65, 0x64, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x73, 0x65, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x31, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67,
  0x68, 0x74, 0x3d, 0x22, 0x31, 0x22, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x69,
  0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x77, 0x68, 0x69, 0x63, 0x68,
  0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x68, 0x61, 0x64, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x64, 0x65, 0x73,
  0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x74, 0x68,
  0x65, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x0a,
  0x09, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x6f,
  0x66, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x20, 0x75, 0x73,
  0x65, 0x64, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x68,
  0x61, 0x76, 0x65, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x63, 0x6c, 0x65, 0x61, 0x72, 0x3a, 0x62, 0x0d, 0x0a, 0x3c, 0x2f, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x3c, 0x77, 0x61, 0x73, 0x20, 0x66,
  0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x69, 0x6e, 0x74, 0x65,
  0x72, 0x76, 0x69, 0x65, 0x77, 0x20, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x69, 0x64,
  0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x63, 0x61,
  0x70, 0x69, 0x74, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x0d,
  0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73,
  0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x78, 0x4d, 0x4c, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75,
  0x65, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x75, 0x62, 0x73, 0x65, 0x71,
  0x75, 0x65, 0x6e, 0x74, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, 0x6c, 0x61,
  0x72, 0x67, 0x65, 0x73, 0x74, 0x76, 0x65, 0x72, 0x79, 0x20, 0x69, 0x6d, 0x70,
  0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x70, 0x70, 0x6c, 0x69,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x66, 0x6f, 0x72, 0x65,
  0x69, 0x67, 0x6e, 0x20, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x73, 0x65,
  0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x65, 0x73,
  0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x69,
  0x73, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x49, 0x6e, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74,
  0x6f, 0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x69, 0x73, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x20, 0x61, 0x66,
  0x74, 0x65, 0x72, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73,
  0x65, 0x6e, 0x74, 0x65, 0x64, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x65, 0x66,
  0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72,
  0x20, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x20, 0x72,
  0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x3c, 0x73, 0x70,
  0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x70, 0x65,
  0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x28,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x20, 0x7b, 0x0d,
  0x69, 0x66, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x69,
  0x66, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x6c, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20,
  0x77, 0x69, 0x74, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4e, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x68,
  0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x61, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x79, 0x70, 0x65, 0x22, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x41, 0x73, 0x73, 0x6f, 0x63,
  0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x0a, 0x3c, 0x2f, 0x68,
  0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x6c, 0x6f, 0x63,
  0x61, 0x74, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73,
  0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x28,
  0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
  0x63, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x74, 0x68, 0x65, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75,
  0x61, 0x6c, 0x61, 0x6d, 0x6f, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d,
  0x6f, 0x73, 0x74, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x2f, 0x3e, 0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20,
  0x72, 0x65, 0x6c, 0x3d, 0x22, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20,
  0x66, 0x61, 0x6c, 0x73, 0x65, 0x3b, 0x74, 0x68, 0x65, 0x20, 0x70, 0x75, 0x72,
  0x70, 0x6f, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x61, 0x62,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x74, 0x6f, 0x3b, 0x63, 0x6f, 0x6c, 0x6f,
  0x72, 0x3a, 0x23, 0x66, 0x66, 0x66, 0x7d, 0x0a, 0x2e, 0x0a, 0x3c, 0x73, 0x70,
  0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x74, 0x68, 0x65,
  0x20, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x6f, 0x66, 0x64, 0x65,
  0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x3e,
  0x0d, 0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22,
  0x63, 0x6c, 0x61, 0x69, 0x6d, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68,
  0x65, 0x68, 0x61, 0x76, 0x65, 0x20, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
  0x65, 0x64, 0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x77, 0x69, 0x64, 0x74,
  0x68, 0x3d, 0x22, 0x63, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x64, 0x69, 0x73, 0x74, 0x69,
  0x6e, 0x67, 0x75, 0x69, 0x73, 0x68, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x62, 0x74, 0x61, 0x6b, 0x65, 0x73, 0x20,
  0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x69, 0x6e, 0x75, 0x6e, 0x64, 0x65, 0x72,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x3e, 0x3c, 0x21,
  0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d, 0x2d, 0x2d, 0x3e, 0x0a, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x69,
  0x6e, 0x73, 0x74, 0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20, 0x74, 0x68,
  0x65, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x20,
  0x6f, 0x66, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x65, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
  0x73, 0x20, 0x69, 0x6e, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
  0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x77, 0x61, 0x73, 0x20, 0x65, 0x76,
  0x65, 0x6e, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x74, 0x68, 0x72, 0x6f, 0x75,
  0x67, 0x68, 0x6f, 0x75, 0x74, 0x20, 0x68, 0x69, 0x73, 0x74, 0x68, 0x65, 0x20,
  0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x6f, 0x6d,
  0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x70,
  0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x73,
  0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6e, 0x74, 0x6c, 0x79, 0x20,
  0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x0d,
  0x0a, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x61,
  0x6c, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x20,
  0x74, 0x68, 0x65, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x6c,
  0x79, 0x20, 0x66, 0x6f, 0x72, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61,
  0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x65, 0x73, 0x73, 0x65,
  0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x77, 0x65, 0x72, 0x65, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x69, 0x73, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x73, 0x74, 0x68, 0x61, 0x76, 0x65,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x22, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x69, 0x6e,
  0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x64, 0x20, 0x61, 0x73, 0x73,
  0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, 0x68, 0x61, 0x6c, 0x66, 0x20, 0x6f, 0x66,
  0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x6e, 0x6f, 0x22,
  0x20, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20,
  0x6f, 0x66, 0x49, 0x49, 0x2c, 0x20, 0x48, 0x6f, 0x6c, 0x79, 0x20, 0x52, 0x6f,
  0x6d, 0x61, 0x6e, 0x69, 0x73, 0x20, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x69,
  0x72, 0x20, 0x6f, 0x77, 0x6e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x20,
  0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x74, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x64,
  0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x65, 0x20, 0x6f,
  0x66, 0x74, 0x65, 0x6e, 0x20, 0x75, 0x73, 0x65, 0x64, 0x74, 0x6f, 0x20, 0x65,
  0x6e, 0x73, 0x75, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x67, 0x72,
  0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x63, 0x6f,
  0x6e, 0x74, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x61,
  0x72, 0x65, 0x20, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x6c, 0x79,
  0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x6e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x20, 0x69, 0x73, 0x20, 0x74,
  0x68, 0x65, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x69,
  0x6e, 0x20, 0x61, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c,
  0x2f, 0x75, 0x6c, 0x3e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x66,
  0x6f, 0x6f, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x20, 0x65, 0x73, 0x70, 0x65,
  0x63, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x62,
  0x75, 0x74, 0x74, 0x6f, 0x6e, 0x22, 0x20, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e,
  0x3e, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x77, 0x68, 0x69, 0x63, 0x68,
  0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x3e, 0x0a, 0x3c, 0x6d,
  0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x63, 0x6f, 0x6e,
  0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x63, 0x61,
  0x72, 0x72, 0x69, 0x65, 0x64, 0x20, 0x6f, 0x75, 0x74, 0x20, 0x62, 0x79, 0x48,
  0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73,
  0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f,
  0x66, 0x69, 0x6e, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x74, 0x6f, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x63, 0x61, 0x70, 0x69, 0x74, 0x61,
  0x6c, 0x20, 0x6f, 0x66, 0x77, 0x61, 0x73, 0x20, 0x6f, 0x66, 0x66, 0x69, 0x63,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x68, 0x61,
  0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x48, 0x69, 0x73,
  0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e,
  0x61, 0x74, 0x69, 0x76, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x69, 0x66, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x74, 0x6f, 0x20, 0x73,
  0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x67,
  0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x20,
  0x20, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x74, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x68,
  0x69, 0x73, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x77,
  0x69, 0x74, 0x68, 0x74, 0x68, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x69, 0x74, 0x79, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x78, 0x74, 0x20, 0x6f, 0x66, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x70, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20,
  0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x71, 0x22, 0x09, 0x09, 0x3c, 0x64, 0x69,
  0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x20,
  0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x72, 0x65, 0x70,
  0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x6d, 0x61,
  0x74, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x69, 0x61, 0x6e, 0x73, 0x65,
  0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65,
  0x6e, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x63, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x68, 0x65, 0x61,
  0x64, 0x65, 0x72, 0x69, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75,
  0x6c, 0x61, 0x72, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x74, 0x6f, 0x29, 0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f,
  0x70, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x6f,
  0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69, 0x74, 0x69, 0xe1, 0xba, 0xbf,
  0x6e, 0x67, 0x20, 0x56, 0x69, 0xe1, 0xbb, 0x87, 0x74, 0xd0, 0xa0, 0xd1, 0x83,
  0xd1, 0x81, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xb9, 0xd1, 0x80, 0xd1,
  0x83, 0xd1, 0x81, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xb9, 0x69, 0x6e,
  0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70,
  0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e,
  0xd0, 0xba, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd1, 0x8b, 0xd0,
  0xb5, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0, 0xbb, 0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82,
  0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd1,
  0x8b, 0xd0, 0xb9, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xb2,
  0xd0, 0xb5, 0xd0, 0xba, 0xd1, 0x81, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x82, 0xd0,
  0xb5, 0xd0, 0xbc, 0xd1, 0x8b, 0xd0, 0x9d, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xbe, 0xd1, 0x82, 0xd0,
  0xbe, 0xd1, 0x80, 0xd1, 0x8b, 0xd1, 0x85, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0, 0xbb,
  0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xb2, 0xd1, 0x80, 0xd0,
  0xb5, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb0, 0xd1, 0x8f, 0xd1, 0x81, 0xd0,
  0xb5, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd1, 0x8f, 0xd1, 0x81,
  0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x82, 0xd1, 0x8c, 0xd0,
  0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8,
  0xd0, 0xa3, 0xd0, 0xba, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1,
  0x8b, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd1, 0x81,
  0xd1, 0x8b, 0xd0, 0xba, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0,
  0xbe, 0xd0, 0xb9, 0xd1, 0x81, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb0,
  0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbe, 0xd1,
  0x89, 0xd1, 0x8c, 0xd1, 0x8e, 0xd1, 0x81, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x80, 0xd0,
  0xb0, 0xd0, 0xb7, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe,
  0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xbd, 0xd1, 0x8b, 0xd1, 0x83, 0xd1, 0x87, 0xd0,
  0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb5,
  0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb5, 0xd0, 0x93, 0xd0,
  0xbb, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x8f, 0xd0, 0xb8,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xb8, 0xd1,
  0x81, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xb0,
  0xd1, 0x80, 0xd0, 0xb5, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1,
  0x8f, 0xd0, 0xa1, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x82,
  0xd1, 0x8c, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0,
  0xbc, 0xd1, 0x83, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x83,
  0xd0, 0xb5, 0xd1, 0x82, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0,
  0xb0, 0xd1, 0x82, 0xd1, 0x8c, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xb0,
  0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0,
  0xb5, 0xd1, 0x87, 0xd0, 0xbd, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb5, 0xd1, 0x88,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb5, 0xd0, 0xba, 0xd0, 0xbe, 0xd1,
  0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xbe, 0xd1, 0x80,
  0xd0, 0xb3, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xba, 0xd0,
  0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xa0,
  0xd0, 0xb5, 0xd0, 0xba, 0xd0, 0xbb, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xb0, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xaf, 0xd9, 0x89,
  0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8,
  0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xb6, 0xd9, 0x88,
  0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa8, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9,
  0x85, 0xd8, 0xac, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xa7,
  0xd9, 0x82, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xb3, 0xd8,
  0xa7, 0xd8, 0xa6, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8, 0xb1,
  0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8,
  0xb9, 0xd8, 0xb6, 0xd8, 0xa7, 0xd8, 0xa1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1,
  0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xb6, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xaa, 0xd8, 0xb5, 0xd9, 0x85, 0xd9, 0x8a, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xa7, 0xd8, 0xb9, 0xd8, 0xb6, 0xd8, 0xa7, 0xd8, 0xa1, 0xd8, 0xa7, 0xd9,
  0x84, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xa6, 0xd8, 0xac, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xa3, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd8, 0xb3, 0xd8, 0xac, 0xd9, 0x8a, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd9, 0x82, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9,
  0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb6, 0xd8, 0xba, 0xd8, 0xb7, 0xd8, 0xa7,
  0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x8a, 0xd8, 0xaf, 0xd9,
  0x8a, 0xd9, 0x88, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd8, 0xb1, 0xd8, 0xad,
  0xd9, 0x8a, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd8, 0xaf, 0xd9,
  0x8a, 0xd8, 0xaf, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd8, 0xb9,
  0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8,
  0xae, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7,
  0xd9, 0x81, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xa3, 0xd9, 0x81, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xb1, 0xd9, 0x8a, 0xd8, 0xae, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaa, 0xd9, 0x82, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xae, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xb7, 0xd8, 0xb1,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xac, 0xd8, 0xaa, 0xd9, 0x85, 0xd8,
  0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x83, 0xd9, 0x88,
  0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8,
  0xad, 0xd8, 0xa9, 0xd8, 0xb9, 0xd8, 0xa8, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84,
  0xd9, 0x84, 0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd8, 0xb1, 0xd8,
  0xa8, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd9, 0x88,
  0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xb7, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8,
  0xaf, 0xd8, 0xa8, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7,
  0xd8, 0xae, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xaa, 0xd8, 0xad, 0xd8, 0xaf, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xa7, 0xd8, 0xba, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 0x8a, 0x63, 0x75, 0x72,
  0x73, 0x6f, 0x72, 0x3a, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x3b, 0x3c,
  0x2f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61,
  0x20, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x22, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
  0x2e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x2f, 0x61,
  0x3e, 0x20, 0x7c, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22,
  0x3c, 0x21, 0x64, 0x6f, 0x63, 0x74, 0x79, 0x70, 0x65, 0x20, 0x68, 0x74, 0x6d,
  0x6c, 0x3e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x3d, 0x22, 0x73, 0x63, 0x72, 0x65,
  0x65, 0x6e, 0x22, 0x20, 0x3c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x66, 0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e,
  0x2e, 0x69, 0x63, 0x6f, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x09, 0x09, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x68, 0x61,
  0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22,
  0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x67, 0x65, 0x74, 0x22,
  0x20, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f, 0x68, 0x74, 0x6d,
  0x6c, 0x3e, 0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x63, 0x75, 0x74, 0x20, 0x69,
  0x63, 0x6f, 0x6e, 0x22, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
  0x2e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x28, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e,
  0x67, 0x2d, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x3a, 0x72, 0x65, 0x70, 0x72,
  0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x73, 0x75,
  0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22,
  0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
  0x22, 0x20, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x6f, 0x75, 0x74, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x66,
  0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20, 0x3c, 0x64, 0x69, 0x76,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73, 0x75, 0x62, 0x6d, 0x69,
  0x74, 0x22, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6f, 0x6e, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20,
  0x76, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x74, 0x6f, 0x70, 0x22, 0x3e,
  0x3c, 0x77, 0x61, 0x73, 0x20, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73,
  0x68, 0x65, 0x64, 0x29, 0x3b, 0x0d, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x66,
  0x61, 0x6c, 0x73, 0x65, 0x3b, 0x22, 0x3e, 0x29, 0x2e, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x2e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x65, 0x63, 0x61,
  0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x6f,
  0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
  0x3c, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
  0x22, 0x2f, 0x7d, 0x62, 0x6f, 0x64, 0x79, 0x7b, 0x6d, 0x61, 0x72, 0x67, 0x69,
  0x6e, 0x3a, 0x30, 0x3b, 0x45, 0x6e, 0x63, 0x79, 0x63, 0x6c, 0x6f, 0x70, 0x65,
  0x64, 0x69, 0x61, 0x20, 0x6f, 0x66, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x2e, 0x63, 0x72, 0x65, 0x61,
  0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x28, 0x6e, 0x61, 0x6d,
  0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a,
  0x0a, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x20, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x22, 0x3e, 0x3c, 0x69, 0x6e, 0x70,
  0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x70, 0x6f, 0x72, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x73,
  0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74,
  0x72, 0x69, 0x65, 0x73, 0x22, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e,
  0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x49, 0x6e, 0x20, 0x6f, 0x74,
  0x68, 0x65, 0x72, 0x20, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x2c, 0x64, 0x69, 0x73,
  0x70, 0x6c, 0x61, 0x79, 0x3a, 0x20, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x3b, 0x63,
  0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x2f, 0x3e, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x73, 0x20, 0x77, 0x65, 0x6c, 0x6c, 0x20,
  0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x65, 0x63,
  0x65, 0x6e, 0x74, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x0d, 0x0a, 0x09, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x09, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a,
  0x69, 0x6e, 0x73, 0x70, 0x69, 0x72, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c,
  0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20,
  0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x20, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x3a, 0x2e, 0x6a, 0x73,
  0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x20,
  0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
  0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62,
  0x65, 0x65, 0x6e, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x20, 0x6c, 0x61, 0x6e,
  0x67, 0x75, 0x61, 0x67, 0x65, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e,
  0x69, 0x73, 0x74, 0x20, 0x50, 0x61, 0x72, 0x74, 0x79, 0x63, 0x6f, 0x6e, 0x73,
  0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c, 0x6c,
  0x20, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x3d, 0x22, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x69, 0x74,
  0x79, 0x20, 0x6f, 0x66, 0x22, 0x20, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22,
  0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x20,
  0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x4f, 0x72, 0x74,
  0x68, 0x6f, 0x64, 0x6f, 0x78, 0x20, 0x43, 0x68, 0x75, 0x72, 0x63, 0x68, 0x73,
  0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x2f, 0x3e, 0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c,
  0x3d, 0x22, 0x73, 0x77, 0x61, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x20, 0x68, 0x69,
  0x73, 0x20, 0x64, 0x65, 0x61, 0x74, 0x68, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x0a,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x63, 0x6f,
  0x6d, 0x70, 0x61, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65,
  0x70, 0x6f, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c,
  0x61, 0x6e, 0x64, 0x73, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20,
  0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f,
  0x75, 0x6e, 0x64, 0x3a, 0x75, 0x72, 0x6c, 0x28, 0x61, 0x72, 0x67, 0x75, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x73, 0x63, 0x72,
  0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x6e, 0x6f, 0x22, 0x20, 0x69,
  0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
  0x65, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63,
  0x61, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
  0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x68, 0x65, 0x20, 0x74, 0x72,
  0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x66, 0x72,
  0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x20, 0x75, 0x73, 0x65, 0x64,
  0x61, 0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x76, 0x65, 0x72, 0x79, 0x20, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61,
  0x72, 0x20, 0x74, 0x6f, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x61, 0x6c, 0x69, 0x67, 0x6e,
  0x3d, 0x22, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x3e, 0x77, 0x6f, 0x75,
  0x6c, 0x64, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x69,
  0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x3d, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66,
  0x6f, 0x72, 0x6d, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x64,
  0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x6e, 0x61,
  0x6d, 0x65, 0x64, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65,
  0x49, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x74, 0x6f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x20, 0x6f, 0x6e, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x77,
  0x69, 0x64, 0x74, 0x68, 0x3a, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63,
  0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x73,
  0x74, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x20, 0x69,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x6e,
  0x64, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x54, 0x68, 0x69, 0x73, 0x20, 0x6d, 0x65, 0x61,
  0x6e, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x77, 0x61, 0x73, 0x20,
  0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x62, 0x79, 0x61, 0x6e,
  0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x69, 0x6e, 0x73, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66,
  0x6f, 0x72, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x65, 0x64, 0x20, 0x61, 0x73,
  0x20, 0x74, 0x68, 0x65, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x73, 0x75, 0x63, 0x63,
  0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61,
  0x73, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x61, 0x20, 0x63, 0x6f, 0x6d,
  0x70, 0x72, 0x65, 0x68, 0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x48, 0x69, 0x73,
  0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77,
  0x65, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65,
  0x64, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x61, 0x72, 0x65, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x55, 0x6e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
  0x64, 0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x3e, 0x0a, 0x09, 0x3c, 0x64, 0x69,
  0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x73,
  0x69, 0x73, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74,
  0x6f, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
  0x79, 0x20, 0x6f, 0x66, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x20, 0x74,
  0x6f, 0x20, 0x68, 0x61, 0x76, 0x65, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x6f,
  0x6d, 0x61, 0x67, 0x6e, 0x65, 0x74, 0x69, 0x63, 0x65, 0x6e, 0x61, 0x62, 0x6c,
  0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x28, 0x66, 0x75, 0x6e,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x49,
  0x74, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e,
  0x74, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29,
  0x7b, 0x76, 0x61, 0x72, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x20, 0x61, 0x20, 0x72,
  0x65, 0x73, 0x75, 0x6c, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x46, 0x6f,
  0x72, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x20, 0x69, 0x6e,
  0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x70, 0x6f, 0x73, 0x74,
  0x22, 0x20, 0x77, 0x61, 0x73, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6d, 0x64, 0x61, 0x73,
  0x68, 0x3b, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x61, 0x70, 0x70,
  0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6a, 0x73, 0x22, 0x3e, 0x3c,
  0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x75, 0x6c, 0x3e,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x61,
  0x66, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x61, 0x74,
  0x68, 0x77, 0x69, 0x74, 0x68, 0x20, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74,
  0x20, 0x74, 0x6f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x70, 0x61, 0x64,
  0x64, 0x69, 0x6e, 0x67, 0x3a, 0x69, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69,
  0x63, 0x75, 0x6c, 0x61, 0x72, 0x6c, 0x79, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
  0x79, 0x3a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x3b, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x69, 0x73,
  0x20, 0x64, 0x69, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f,
  0xe4, 0xb8, 0xad, 0xe6, 0x96, 0x87, 0x20, 0x28, 0xe7, 0xae, 0x80, 0xe4, 0xbd,
  0x93, 0x29, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x61, 0x62, 0x69, 0x6c,
  0x69, 0x64, 0x61, 0x64, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72,
  0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
  0x63, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x65, 0x73, 0x63, 0x6f, 0x72, 0x72, 0x65,
  0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x65, 0x6e, 0x74, 0x65, 0xe0, 0xa4, 0x89,
  0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb5, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0,
  0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa5, 0x81, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0x96, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xad, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4,
  0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa3, 0xe0,
  0xa4, 0xac, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0,
  0xa5, 0x89, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb9,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0,
  0xa5, 0x83, 0xe0, 0xa4, 0xb7, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa0, 0xe0, 0xa4,
  0xac, 0xe0, 0xa4, 0xa2, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xaa, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xab, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5,
  0x8c, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xae, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xaa, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4,
  0xac, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9b,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xb6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0x89,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xae, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0x88, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa2, 0xe0, 0xa4,
  0xbc, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xab, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xae, 0xe0, 0xa4,
  0xae, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x96, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf,
  0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0x9a, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9b, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x9b, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4,
  0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x8f, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0x98,
  0xe0, 0xa4, 0xa3, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa7, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb7, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5,
  0x80, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x81, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4,
  0xae, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x83, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0x98, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb5,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xae, 0xe0,
  0xa5, 0x88, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xa4, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0,
  0xa5, 0x87, 0x72, 0x73, 0x73, 0x2b, 0x78, 0x6d, 0x6c, 0x22, 0x20, 0x74, 0x69,
  0x74, 0x6c, 0x65, 0x3d, 0x22, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x22, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x74, 0x69, 0x74, 0x6c, 0x65,
  0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x61, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x74, 0x69, 0x6d,
  0x65, 0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x3e, 0x0a, 0x3c, 0x22, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d,
  0x22, 0x70, 0x6f, 0x73, 0x74, 0x22, 0x20, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e,
  0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x76, 0x65, 0x72,
  0x74, 0x69, 0x63, 0x61, 0x6c, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x74,
  0x2f, 0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x6e, 0x2e, 0x6a,
  0x73, 0x22, 0x3e, 0x2e, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x28, 0x66, 0x75, 0x6e,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d,
  0x22, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2d, 0x7d, 0x29, 0x28, 0x29,
  0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c,
  0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x29, 0x3b, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72,
  0x6e, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x3b, 0x74, 0x65, 0x78, 0x74, 0x2d,
  0x64, 0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x73,
  0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x6e, 0x6f, 0x22,
  0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x2d, 0x63, 0x6f, 0x6c, 0x6c, 0x61,
  0x70, 0x73, 0x65, 0x3a, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65,
  0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x42, 0x61, 0x68, 0x61, 0x73, 0x61,
  0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x45, 0x6e, 0x67,
  0x6c, 0x69, 0x73, 0x68, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
  0x3c, 0x74, 0x65, 0x78, 0x74, 0x20, 0x78, 0x6d, 0x6c, 0x3a, 0x73, 0x70, 0x61,
  0x63, 0x65, 0x3d, 0x2e, 0x67, 0x69, 0x66, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64,
  0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e,
  0x0a, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0a, 0x6f, 0x76, 0x65, 0x72,
  0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x3b, 0x69,
  0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x61, 0x64, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x73,
  0x74, 0x65, 0x6e, 0x65, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69,
  0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x73, 0x2e, 0x6a, 0x73, 0x22,
  0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x2f, 0x66,
  0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x2e, 0x69, 0x63, 0x6f, 0x22, 0x20, 0x2f,
  0x3e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x73, 0x79,
  0x73, 0x74, 0x65, 0x6d, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x31, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x3e, 0x53, 0x74, 0x61,
  0x74, 0x65, 0x20, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79,
  0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x6c, 0x65,
  0x66, 0x74, 0x3b, 0x0a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
  0x77, 0x72, 0x69, 0x74, 0x65, 0x28, 0x2c, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75,
  0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x72, 0x6f, 0x75,
  0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x29,
  0x3b, 0x0d, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d,
  0x0a, 0x3c, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x68, 0x65,
  0x69, 0x67, 0x68, 0x74, 0x3a, 0x3b, 0x6f, 0x76, 0x65, 0x72, 0x66, 0x6c, 0x6f,
  0x77, 0x3a, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x6d, 0x6f, 0x72, 0x65, 0x20,
  0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6e,
  0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61,
  0x6c, 0x61, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65,
  0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x0a, 0x09, 0x09, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a,
  0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x20, 0x6e, 0x6f, 0x6e, 0x65,
  0x3b, 0x22, 0x3e, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b,
  0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x0a, 0x20, 0x20, 0x28, 0x66, 0x75, 0x6e,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x20, 0x7b, 0x74, 0x68, 0x65, 0x20,
  0x31, 0x35, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x2e,
  0x70, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
  0x74, 0x28, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65,
  0x72, 0x20, 0x6f, 0x66, 0x20, 0x42, 0x79, 0x7a, 0x61, 0x6e, 0x74, 0x69, 0x6e,
  0x65, 0x20, 0x45, 0x6d, 0x70, 0x69, 0x72, 0x65, 0x2e, 0x6a, 0x70, 0x67, 0x7c,
  0x74, 0x68, 0x75, 0x6d, 0x62, 0x7c, 0x6c, 0x65, 0x66, 0x74, 0x7c, 0x76, 0x61,
  0x73, 0x74, 0x20, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20, 0x6f,
  0x66, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x20, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x63,
  0x65, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x3e, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x69, 0x74, 0x79, 0x20, 0x50, 0x72, 0x65, 0x73, 0x73, 0x64, 0x6f, 0x6d,
  0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65,
  0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6c, 0x64, 0x20,
  0x57, 0x61, 0x72, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x74, 0x68, 0x65, 0x20,
  0x72, 0x65, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63,
  0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x6e, 0x6f, 0x66, 0x6f, 0x6c,
  0x6c, 0x6f, 0x77, 0x22, 0x3e, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x73, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x72, 0x61, 0x74, 0x68, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x20,
  0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x66, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x77, 0x69, 0x64, 0x74, 0x68,
  0x3a, 0x31, 0x30, 0x30, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x2d, 0x73,
  0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
  0x65, 0x72, 0x20, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x62, 0x6f, 0x72,
  0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22,
  0x74, 0x68, 0x65, 0x20, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65,
  0x20, 0x6f, 0x66, 0x44, 0x65, 0x6d, 0x6f, 0x63, 0x72, 0x61, 0x74, 0x69, 0x63,
  0x20, 0x50, 0x61, 0x72, 0x74, 0x79, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x46, 0x6f, 0x72, 0x20,
  0x74, 0x68, 0x69, 0x73, 0x20, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2c, 0x2e,
  0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e,
  0x0a, 0x09, 0x73, 0x42, 0x79, 0x54, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x28,
  0x73, 0x29, 0x5b, 0x30, 0x5d, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x3c, 0x2e, 0x6a, 0x73, 0x22, 0x3e,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x6c, 0x69,
  0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x69, 0x63, 0x6f, 0x6e, 0x22,
  0x20, 0x27, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x27, 0x27, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x27, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
  0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c, 0x2f, 0x61,
  0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x2f, 0x70, 0x61, 0x67, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x70, 0x61, 0x67,
  0x65, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x62, 0x61, 0x68, 0x61,
  0x73, 0x61, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x65,
  0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x20, 0x28, 0x73, 0x69, 0x6d, 0x70, 0x6c,
  0x65, 0x29, 0xce, 0x95, 0xce, 0xbb, 0xce, 0xbb, 0xce, 0xb7, 0xce, 0xbd, 0xce,
  0xb9, 0xce, 0xba, 0xce, 0xac, 0xd1, 0x85, 0xd1, 0x80, 0xd0, 0xb2, 0xd0, 0xb0,
  0xd1, 0x82, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xbe, 0xd0,
  0xbc, 0xd0, 0xbf, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb8, 0xd1, 0x8f,
  0xd0, 0xb2, 0xd0, 0xbb, 0xd1, 0x8f, 0xd0, 0xb5, 0xd1, 0x82, 0xd1, 0x81, 0xd1,
  0x8f, 0xd0, 0x94, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xb8,
  0xd1, 0x82, 0xd1, 0x8c, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0,
  0xb2, 0xd0, 0xb5, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb7,
  0xd0, 0xb2, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0x98, 0xd0,
  0xbd, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xb5, 0xd1, 0x82,
  0xd0, 0x9e, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb8, 0xd1,
  0x82, 0xd1, 0x8c, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb8,
  0xd0, 0xbc, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x82, 0xd0,
  0xb5, 0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xba, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1,
  0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x86,
  0xd1, 0x8b, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x81, 0xd1,
  0x82, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x83, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xbe,
  0xd0, 0xb2, 0xd0, 0xb8, 0xd1, 0x8f, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80, 0xd0,
  0xbe, 0xd0, 0xb1, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xbc, 0xd1, 0x8b, 0xd0, 0xbf,
  0xd0, 0xbe, 0xd0, 0xbb, 0xd1, 0x83, 0xd1, 0x87, 0xd0, 0xb8, 0xd1, 0x82, 0xd1,
  0x8c, 0xd1, 0x8f, 0xd0, 0xb2, 0xd0, 0xbb, 0xd1, 0x8f, 0xd1, 0x8e, 0xd1, 0x82,
  0xd1, 0x81, 0xd1, 0x8f, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb8, 0xd0, 0xb1, 0xd0,
  0xbe, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbc,
  0xd0, 0xbf, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0xb2, 0xd0,
  0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb5,
  0xd1, 0x81, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x81, 0xd1, 0x82, 0xd0,
  0xb2, 0xd0, 0xb0, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xa7,
  0xd8, 0xb6, 0xd9, 0x8a, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8,
  0xa6, 0xd9, 0x8a, 0xd8, 0xb3, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x86, 0xd8, 0xaa, 0xd9, 0x82, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa,
  0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x83,
  0xd8, 0xaa, 0xd9, 0x88, 0xd8, 0xa8, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xb3, 0xd8, 0xb9, 0xd9, 0x88, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd8, 0xad, 0xd8, 0xb5, 0xd8, 0xa7, 0xd8, 0xa6, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8,
  0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85,
  0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb5, 0xd9, 0x88, 0xd8,
  0xaa, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7,
  0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xb1, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaa, 0xd8, 0xb5, 0xd8, 0xa7, 0xd9, 0x85, 0xd9, 0x8a, 0xd9, 0x85,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa5, 0xd8, 0xb3, 0xd9, 0x84, 0xd8, 0xa7, 0xd9,
  0x85, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7,
  0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8,
  0xb1, 0xd8, 0xa6, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xaa, 0x72, 0x6f, 0x62, 0x6f,
  0x74, 0x73, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x66, 0x6f, 0x6f, 0x74,
  0x65, 0x72, 0x22, 0x3e, 0x74, 0x68, 0x65, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x65,
  0x64, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x3c, 0x69, 0x6d, 0x67, 0x20,
  0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x2e,
  0x6a, 0x70, 0x67, 0x7c, 0x72, 0x69, 0x67, 0x68, 0x74, 0x7c, 0x74, 0x68, 0x75,
  0x6d, 0x62, 0x7c, 0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x3c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x66, 0x72,
  0x61, 0x6d, 0x65, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22,
  0x20, 0x73, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20,
  0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x66, 0x6f, 0x6e,
  0x74, 0x2d, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x62, 0x6f, 0x6c, 0x64,
  0x3b, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x67,
  0x69, 0x6e, 0x3a, 0x30, 0x3b, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a,
  0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x6e, 0x6f, 0x66, 0x6f, 0x6c, 0x6c,
  0x6f, 0x77, 0x22, 0x20, 0x50, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x77, 0x65, 0x6e, 0x74,
  0x69, 0x65, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x65,
  0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x2f, 0x70,
  0x61, 0x67, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20, 0x45,
  0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x72, 0x61, 0x2e, 0x61, 0x73, 0x79, 0x6e,
  0x63, 0x20, 0x3d, 0x20, 0x74, 0x72, 0x75, 0x65, 0x3b, 0x0d, 0x0a, 0x69, 0x6e,
  0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x62, 0x6f,
  0x75, 0x74, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x68, 0x65,
  0x61, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x22, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x3c, 0x61, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
  0x2f, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x63, 0x6f, 0x6e,
  0x74, 0x65, 0x6e, 0x74, 0x22, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x3c, 0x64, 0x65, 0x72, 0x69,
  0x76, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x27, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x0a, 0x3c, 0x2f, 0x62, 0x6f,
  0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0a, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69,
  0x7a, 0x65, 0x3a, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x6c, 0x61, 0x6e,
  0x67, 0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x41, 0x72, 0x69, 0x61, 0x6c, 0x2c,
  0x20, 0x48, 0x65, 0x6c, 0x76, 0x65, 0x74, 0x69, 0x63, 0x61, 0x2c, 0x3c, 0x2f,
  0x61, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x73,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63,
  0x61, 0x6c, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x65, 0x73, 0x74, 0x64, 0x3e,
  0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x3c, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e,
  0x3c, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x77, 0x77, 0x77, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
  0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x6c, 0x3d,
  0x22, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20,
  0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x77, 0x72, 0x69, 0x74,
  0x65, 0x28, 0x27, 0x3c, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x22,
  0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x3e, 0x0a, 0x62, 0x65, 0x67, 0x69, 0x6e,
  0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72,
  0x65, 0x76, 0x65, 0x61, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
  0x74, 0x68, 0x65, 0x74, 0x65, 0x6c, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d,
  0x22, 0x6e, 0x6f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x22, 0x3e, 0x20, 0x74,
  0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b,
  0x22, 0x3e, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x68, 0x74, 0x74, 0x70, 0x25, 0x33, 0x41,
  0x25, 0x32, 0x46, 0x25, 0x32, 0x46, 0x77, 0x77, 0x77, 0x2e, 0x6d, 0x61, 0x6e,
  0x69, 0x66, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f,
  0x66, 0x50, 0x72, 0x69, 0x6d, 0x65, 0x20, 0x4d, 0x69, 0x6e, 0x69, 0x73, 0x74,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x66, 0x69, 0x78, 0x22, 0x3e,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x0d, 0x0a, 0x0d, 0x0a, 0x74, 0x68, 0x72, 0x65, 0x65, 0x2d, 0x64, 0x69, 0x6d,
  0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43, 0x68, 0x75, 0x72, 0x63,
  0x68, 0x20, 0x6f, 0x66, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x61, 0x6e, 0x64, 0x6f,
  0x66, 0x20, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x20, 0x43, 0x61, 0x72, 0x6f, 0x6c,
  0x69, 0x6e, 0x61, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x20, 0x6b, 0x69, 0x6c,
  0x6f, 0x6d, 0x65, 0x74, 0x72, 0x65, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x45, 0x76,
  0x65, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x64, 0x69,
  0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74,
  0x68, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x6b, 0x6e,
  0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x74, 0x69,
  0x63, 0x20, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x64, 0x65, 0x63,
  0x6c, 0x61, 0x72, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68,
  0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x20, 0x74, 0x68, 0x65, 0x42, 0x65, 0x6e, 0x6a, 0x61, 0x6d, 0x69, 0x6e,
  0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x6c, 0x69, 0x6e, 0x72, 0x6f, 0x6c, 0x65,
  0x2d, 0x70, 0x6c, 0x61, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x67, 0x61, 0x6d, 0x65,
  0x74, 0x68, 0x65, 0x20, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74,
  0x79, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x57, 0x65, 0x73, 0x74, 0x65, 0x72,
  0x6e, 0x20, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x70, 0x65, 0x72, 0x73, 0x6f,
  0x6e, 0x61, 0x6c, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x50,
  0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x47, 0x75, 0x74, 0x65, 0x6e, 0x62,
  0x65, 0x72, 0x67, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x6c, 0x65, 0x73, 0x73,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65,
  0x65, 0x6e, 0x20, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x74, 0x6f,
  0x67, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74,
  0x68, 0x65, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c, 0x6c, 0x69, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x6e, 0x20, 0x73, 0x6f, 0x6d, 0x65,
  0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x6d, 0x69, 0x6e,
  0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c,
  0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3c, 0x69, 0x6d, 0x67,
  0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x20, 0x74, 0x68, 0x65, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x20, 0x72,
  0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x63,
  0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65,
  0x72, 0x65, 0x64, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x75, 0x6d, 0x20, 0x6d, 0x65,
  0x63, 0x68, 0x61, 0x6e, 0x69, 0x63, 0x73, 0x4e, 0x65, 0x76, 0x65, 0x72, 0x74,
  0x68, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x69,
  0x6c, 0x6c, 0x69, 0x6f, 0x6e, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x20, 0x61,
  0x67, 0x6f, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0d, 0x0a, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0d, 0xce, 0x95, 0xce, 0xbb, 0xce, 0xbb, 0xce,
  0xb7, 0xce, 0xbd, 0xce, 0xb9, 0xce, 0xba, 0xce, 0xac, 0x0a, 0x74, 0x61, 0x6b,
  0x65, 0x20, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x20, 0x6f,
  0x66, 0x61, 0x6e, 0x64, 0x2c, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x6f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x4d, 0x69, 0x63, 0x72,
  0x6f, 0x73, 0x6f, 0x66, 0x74, 0x20, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73,
  0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x64, 0x69, 0x76, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
  0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
  0x74, 0x68, 0x65, 0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x65, 0x78,
  0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x73, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64, 0x73, 0x73, 0x65,
  0x76, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65,
  0x6e, 0x74, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x77, 0x6f, 0x72, 0x6c, 0x64, 0x2e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x69, 0x6e,
  0x67, 0x20, 0x6d, 0x69, 0x6c, 0x69, 0x74, 0x61, 0x72, 0x79, 0x69, 0x73, 0x6f,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68,
  0x65, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x4f, 0x6c, 0x64, 0x20,
  0x54, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x66, 0x72, 0x69,
  0x63, 0x61, 0x6e, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x73,
  0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f,
  0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x6f,
  0x70, 0x6f, 0x6c, 0x69, 0x74, 0x61, 0x6e, 0x20, 0x61, 0x72, 0x65, 0x61, 0x6d,
  0x61, 0x6b, 0x65, 0x73, 0x20, 0x69, 0x74, 0x20, 0x70, 0x6f, 0x73, 0x73, 0x69,
  0x62, 0x6c, 0x65, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x72, 0x67, 0x75, 0x61, 0x62,
  0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22,
  0x3e, 0x0a, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x3d,
  0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x2f, 0x3e,
  0x0a, 0x63, 0x6f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x20, 0x74, 0x68, 0x65, 0x74, 0x77, 0x6f, 0x2d, 0x74, 0x68, 0x69, 0x72,
  0x64, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x44, 0x75, 0x72, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x2c,
  0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65,
  0x72, 0x69, 0x6f, 0x64, 0x61, 0x6e, 0x6e, 0x6f, 0x75, 0x6e, 0x63, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x69,
  0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61,
  0x6e, 0x64, 0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x72, 0x65, 0x63, 0x65, 0x6e,
  0x74, 0x6c, 0x79, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x64, 0x20, 0x74,
  0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x63, 0x69,
  0x6f, 0x75, 0x73, 0x6e, 0x65, 0x73, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x66, 0x6f,
  0x72, 0x6d, 0x65, 0x72, 0x6c, 0x79, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20,
  0x61, 0x73, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x61,
  0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x6f, 0x63, 0x63,
  0x61, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x75, 0x73, 0x65,
  0x64, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x61, 0x62, 0x73,
  0x6f, 0x6c, 0x75, 0x74, 0x65, 0x3b, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65,
  0x74, 0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x20, 0x70, 0x6f,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x3b, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e,
  0x3a, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x78, 0x2f, 0x6c,
  0x69, 0x62, 0x73, 0x2f, 0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x31, 0x2e,
  0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x63, 0x6f,
  0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x61, 0x70,
  0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x67,
  0x75, 0x61, 0x67, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
  0x3d, 0x22, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70, 0x2d,
  0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63,
  0x79, 0x20, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3c, 0x2f, 0x61, 0x3e, 0x65,
  0x28, 0x22, 0x25, 0x33, 0x43, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x27, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d,
  0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x3e, 0x4f, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x68, 0x61, 0x6e, 0x64,
  0x2c, 0x2e, 0x6a, 0x70, 0x67, 0x7c, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x7c, 0x72,
  0x69, 0x67, 0x68, 0x74, 0x7c, 0x32, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6c, 0x6f,
  0x61, 0x74, 0x3a, 0x6e, 0x69, 0x6e, 0x65, 0x74, 0x65, 0x65, 0x6e, 0x74, 0x68,
  0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x3c, 0x2f, 0x62, 0x6f, 0x64,
  0x79, 0x3e, 0x0d, 0x0a, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0d, 0x0a,
  0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x73, 0x3b, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c,
  0x69, 0x67, 0x6e, 0x3a, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x6f, 0x6e,
  0x74, 0x2d, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x62, 0x6f, 0x6c,
  0x64, 0x3b, 0x20, 0x41, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72,
  0x65, 0x6e, 0x63, 0x65, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x22,
  0x20, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d,
  0x22, 0x30, 0x22, 0x20, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x69, 0x6e, 0x6b,
  0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x34, 0x2f, 0x6c, 0x6f, 0x6f, 0x73, 0x65, 0x2e,
  0x64, 0x74, 0x64, 0x22, 0x3e, 0x0a, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x69, 0x73, 0x20, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x3c, 0x2f,
  0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x3c, 0x2f, 0x74, 0x61, 0x62,
  0x6c, 0x65, 0x3e, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x6c, 0x79, 0x20, 0x72, 0x65,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x66, 0x6f, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x74, 0x69, 0x6d, 0x65,
  0x3b, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a,
  0x62, 0x6f, 0x6c, 0x64, 0x3b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20, 0x3c, 0x73, 0x70,
  0x61, 0x6e, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6f, 0x6e,
  0x74, 0x2d, 0x6f, 0x6e, 0x72, 0x65, 0x61, 0x64, 0x79, 0x73, 0x74, 0x61, 0x74,
  0x65, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x09, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x64,
  0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6c, 0x6f, 0x63, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d,
  0x70, 0x6c, 0x65, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x20, 0x77, 0x69,
  0x64, 0x65, 0x20, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66,
  0x20, 0x3c, 0x21, 0x44, 0x4f, 0x43, 0x54, 0x59, 0x50, 0x45, 0x20, 0x68, 0x74,
  0x6d, 0x6c, 0x3e, 0x0d, 0x0a, 0x3c, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26,
  0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x22, 0x3e,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6c, 0x6f,
  0x61, 0x74, 0x3a, 0x6c, 0x65, 0x66, 0x74, 0x3b, 0x63, 0x6f, 0x6e, 0x63, 0x65,
  0x72, 0x6e, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65,
  0x3d, 0x68, 0x74, 0x74, 0x70, 0x25, 0x33, 0x41, 0x25, 0x32, 0x46, 0x25, 0x32,
  0x46, 0x77, 0x77, 0x77, 0x2e, 0x69, 0x6e, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c,
  0x61, 0x72, 0x20, 0x63, 0x75, 0x6c, 0x74, 0x75, 0x72, 0x65, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20,
  0x2f, 0x3e, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x70, 0x6f, 0x73, 0x73, 0x69,
  0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x48, 0x61, 0x72, 0x76, 0x61, 0x72,
  0x64, 0x20, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x74,
  0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x2f, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x69, 0x6e, 0x20,
  0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x4f, 0x78, 0x66, 0x6f,
  0x72, 0x64, 0x20, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79,
  0x20, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x6b, 0x65, 0x79, 0x77, 0x6f,
  0x72, 0x64, 0x73, 0x22, 0x20, 0x63, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x74, 0x68,
  0x65, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b, 0x69, 0x6e, 0x67,
  0x64, 0x6f, 0x6d, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x67, 0x6f,
  0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e,
  0x20, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x64, 0x69,
  0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x68, 0x65, 0x61, 0x64,
  0x65, 0x72, 0x2e, 0x6d, 0x69, 0x6e, 0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x64, 0x65, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73,
  0x6c, 0x69, 0x67, 0x68, 0x74, 0x6c, 0x79, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64,
  0x61, 0x6e, 0x63, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x74, 0x65, 0x6c, 0x65,
  0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79,
  0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x61, 0x66, 0x74, 0x65, 0x72, 0x65, 0x73,
  0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x61, 0x6e, 0x20, 0x63,
  0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x48, 0x6f, 0x77, 0x65, 0x76,
  0x65, 0x72, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65,
  0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x73,
  0x74, 0x61, 0x74, 0x69, 0x63, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x22, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
  0x77, 0x2e, 0x61, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x20, 0x6e, 0x75, 0x6d,
  0x62, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x54, 0x65, 0x6c, 0x65, 0x63, 0x6f,
  0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
  0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x6e, 0x6f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x22, 0x20, 0x74, 0x48, 0x6f, 0x6c, 0x79, 0x20, 0x52, 0x6f, 0x6d, 0x61,
  0x6e, 0x20, 0x45, 0x6d, 0x70, 0x65, 0x72, 0x6f, 0x72, 0x61, 0x6c, 0x6d, 0x6f,
  0x73, 0x74, 0x20, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x6c,
  0x79, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22,
  0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x61,
  0x72, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x63, 0x75,
  0x6c, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x43, 0x49, 0x41, 0x20, 0x57, 0x6f, 0x72, 0x6c, 0x64, 0x20,
  0x46, 0x61, 0x63, 0x74, 0x62, 0x6f, 0x6f, 0x6b, 0x74, 0x68, 0x65, 0x20, 0x6d,
  0x6f, 0x73, 0x74, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74,
  0x61, 0x6e, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x72, 0x79, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62,
  0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x3c, 0x6c, 0x69,
  0x3e, 0x3c, 0x65, 0x6d, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d,
  0x22, 0x2f, 0x74, 0x68, 0x65, 0x20, 0x41, 0x74, 0x6c, 0x61, 0x6e, 0x74, 0x69,
  0x63, 0x20, 0x4f, 0x63, 0x65, 0x61, 0x6e, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
  0x6c, 0x79, 0x20, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x2c, 0x73,
  0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65,
  0x20, 0x74, 0x68, 0x65, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74,
  0x20, 0x74, 0x79, 0x70, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20,
  0x4f, 0x74, 0x74, 0x6f, 0x6d, 0x61, 0x6e, 0x20, 0x45, 0x6d, 0x70, 0x69, 0x72,
  0x65, 0x3e, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x41, 0x6e, 0x20, 0x49, 0x6e, 0x74, 0x72,
  0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x63, 0x6f,
  0x6e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65,
  0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73,
  0x69, 0x6e, 0x64, 0x69, 0x67, 0x65, 0x6e, 0x6f, 0x75, 0x73, 0x20, 0x70, 0x65,
  0x6f, 0x70, 0x6c, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x65, 0x64, 0x69,
  0x6e, 0x67, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e, 0x66,
  0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x20, 0x68, 0x61,
  0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x64,
  0x69, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20, 0x74,
  0x68, 0x72, 0x65, 0x65, 0x61, 0x64, 0x6a, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x20,
  0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x69, 0x73, 0x20, 0x72,
  0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f,
  0x72, 0x64, 0x69, 0x73, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f,
  0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x77, 0x69,
  0x64, 0x65, 0x6c, 0x79, 0x20, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x65, 0x64,
  0x20, 0x61, 0x73, 0x68, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6d,
  0x70, 0x6f, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x66, 0x6f, 0x75, 0x6e, 0x64,
  0x69, 0x6e, 0x67, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f, 0x66,
  0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x65, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x63, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x6c,
  0x79, 0x20, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x74, 0x68, 0x65,
  0x20, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20,
  0x6f, 0x66, 0x61, 0x72, 0x65, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x61, 0x76,
  0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20,
  0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x72,
  0x65, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72,
  0x61, 0x6c, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x69, 0x73, 0x20, 0x61,
  0x6c, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x65, 0x6e, 0x74, 0x69, 0x72, 0x65, 0x6c,
  0x79, 0x70, 0x61, 0x73, 0x73, 0x65, 0x73, 0x20, 0x74, 0x68, 0x72, 0x6f, 0x75,
  0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65,
  0x6e, 0x20, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x63, 0x6f,
  0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x76, 0x69,
  0x64, 0x65, 0x6f, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x69, 0x63, 0x20, 0x6c,
  0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x20, 0x61, 0x63, 0x63, 0x6f,
  0x72, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x20, 0x74, 0x68, 0x65, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79, 0x20,
  0x61, 0x66, 0x74, 0x65, 0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
  0x77, 0x2e, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x20,
  0x6f, 0x66, 0x20, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73, 0x65,
  0x61, 0x72, 0x63, 0x68, 0x7c, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x49, 0x6e, 0x20, 0x70,
  0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x2c, 0x20, 0x74, 0x68,
  0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x6f,
  0x74, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x6f, 0x72, 0x20, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x20, 0x73, 0x75, 0x62, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x74, 0x68,
  0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x79, 0x65,
  0x61, 0x72, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f, 0x64, 0x69, 0x76,
  0x3e, 0x0d, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x69, 0x6e, 0x64, 0x65,
  0x78, 0x2e, 0x70, 0x68, 0x70, 0x77, 0x61, 0x73, 0x20, 0x65, 0x73, 0x74, 0x61,
  0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x6d, 0x69, 0x6e,
  0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x65,
  0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x61, 0x20, 0x73, 0x74, 0x72, 0x6f,
  0x6e, 0x67, 0x20, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d,
  0x74, 0x6f, 0x70, 0x3a, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x67, 0x72, 0x61, 0x64,
  0x75, 0x61, 0x74, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68,
  0x65, 0x54, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6c,
  0x79, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x28, 0x22, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x29, 0x3b, 0x48, 0x6f,
  0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x6c, 0x65, 0x66, 0x74, 0x3b,
  0x20, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x6c, 0x65, 0x66, 0x74, 0x3a,
  0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x67,
  0x61, 0x69, 0x6e, 0x73, 0x74, 0x30, 0x3b, 0x20, 0x76, 0x65, 0x72, 0x74, 0x69,
  0x63, 0x61, 0x6c, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x55, 0x6e, 0x66,
  0x6f, 0x72, 0x74, 0x75, 0x6e, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x2c, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65,
  0x2f, 0x78, 0x2d, 0x69, 0x63, 0x6f, 0x6e, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x66,
  0x69, 0x78, 0x22, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x09, 0x09, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x09, 0x09, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x0a, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x70,
  0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0xd0, 0x91, 0xd1, 0x8a, 0xd0, 0xbb, 0xd0,
  0xb3, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xb1,
  0xd1, 0x8a, 0xd0, 0xbb, 0xd0, 0xb3, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x81, 0xd0,
  0xba, 0xd0, 0xb8, 0xd0, 0xa4, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x80,
  0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xb5, 0xd1,
  0x81, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0, 0xba, 0xd0, 0xbe,
  0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x89, 0xd0, 0xb5, 0xd0,
  0xbd, 0xd0, 0xb8, 0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xb1,
  0xd1, 0x89, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0xbf, 0xd1,
  0x80, 0xd0, 0xbe, 0xd0, 0xb3, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xbc,
  0xd1, 0x8b, 0xd0, 0x9e, 0xd1, 0x82, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb0, 0xd0,
  0xb2, 0xd0, 0xb8, 0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xb1, 0xd0, 0xb5, 0xd1, 0x81,
  0xd0, 0xbf, 0xd0, 0xbb, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0,
  0xbc, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xb0,
  0xd0, 0xbb, 0xd1, 0x8b, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xb7, 0xd0, 0xb2, 0xd0,
  0xbe, 0xd0, 0xbb, 0xd1, 0x8f, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xbf, 0xd0, 0xbe,
  0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0,
  0xb5, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x87,
  0xd0, 0xbd, 0xd1, 0x8b, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd0,
  0xb4, 0xd1, 0x83, 0xd0, 0xba, 0xd1, 0x86, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xbf,
  0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb3, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0,
  0xbc, 0xd0, 0xb0, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x8c, 0xd1, 0x8e, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1,
  0x85, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb8, 0xd1, 0x82, 0xd1, 0x81, 0xd1, 0x8f,
  0xd0, 0xb8, 0xd0, 0xb7, 0xd0, 0xb1, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0,
  0xbd, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb5,
  0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0xb8, 0xd0,
  0xb7, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8,
  0xd1, 0x8f, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0,
  0xbe, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0x90, 0xd0, 0xbb, 0xd0, 0xb5,
  0xd0, 0xba, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb4, 0xd1, 0x80, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xaa, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa1, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xa1, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9a,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa0, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x9a, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0x85, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0x91, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xab, 0xe0, 0xa4,
  0xbc, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xb6,
  0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xaf, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xa6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0x89, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x9a, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa0, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa1, 0xe0,
  0xa4, 0xbc, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x85, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xa3, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa5,
  0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0,
  0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x9a, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0x9a, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x89, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xa7, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0x89, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa7, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xa1, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x86,
  0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x8f, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0x96, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x81,
  0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xac, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x96, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5,
  0x81, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xa5, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5,
  0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb0, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85,
  0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xa8, 0xd9, 0x8a, 0xd9, 0x88,
  0xd8, 0xaa, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb4, 0xd8,
  0xa7, 0xd9, 0x87, 0xd8, 0xaf, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xb9, 0xd8, 0xaf,
  0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb2, 0xd9, 0x88, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd8, 0xb9, 0xd8, 0xaf, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1,
  0xd8, 0xaf, 0xd9, 0x88, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa5, 0xd8,
  0xb3, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x85, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x88, 0xd8, 0xaa, 0xd9, 0x88, 0xd8, 0xb4, 0xd9,
  0x88, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb3, 0xd8, 0xa7,
  0xd8, 0xa8, 0xd9, 0x82, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x88, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xaa,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb3, 0xd9, 0x84, 0xd8, 0xb3, 0xd9,
  0x84, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd8, 0xb1,
  0xd8, 0xa7, 0xd9, 0x81, 0xd9, 0x8a, 0xd9, 0x83, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xa7, 0xd8, 0xb3, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x85, 0xd9, 0x8a,
  0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xb5, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xaa, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72,
  0x64, 0x73, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22,
  0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x31, 0x39, 0x39, 0x39, 0x2f, 0x78,
  0x68, 0x74, 0x6d, 0x6c, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x74, 0x61, 0x72, 0x67,
  0x65, 0x74, 0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x20, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61,
  0x72, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x3e, 0x3c, 0x74, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69,
  0x6e, 0x67, 0x3d, 0x22, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
  0x65, 0x74, 0x65, 0x3d, 0x22, 0x6f, 0x66, 0x66, 0x22, 0x20, 0x74, 0x65, 0x78,
  0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x20, 0x63, 0x65, 0x6e, 0x74,
  0x65, 0x72, 0x3b, 0x74, 0x6f, 0x20, 0x6c, 0x61, 0x73, 0x74, 0x20, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x62, 0x79, 0x20, 0x62, 0x61, 0x63, 0x6b,
  0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a,
  0x20, 0x23, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64,
  0x3d, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x23, 0x22, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x22, 0x3e, 0x3c, 0x69, 0x6d, 0x67,
  0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x2f,
  0x2f, 0x45, 0x4e, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0x77, 0x77, 0x2e, 0x77, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x55, 0x52,
  0x49, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x28, 0x22, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x64, 0x6f, 0x63,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x28, 0x27,
  0x3c, 0x73, 0x63, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20,
  0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x3b, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72,
  0x67, 0x69, 0x6e, 0x2d, 0x74, 0x6f, 0x70, 0x3a, 0x2e, 0x6d, 0x69, 0x6e, 0x2e,
  0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e,
  0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67,
  0x2f, 0x31, 0x39, 0x39, 0x39, 0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x20,
  0x0a, 0x0d, 0x0a, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0d, 0x0a, 0x3c,
  0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x2f,
  0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x22, 0x5f, 0x62, 0x6c,
  0x61, 0x6e, 0x6b, 0x22, 0x3e, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x68, 0x72,
  0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x65, 0x6e,
  0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x75, 0x74, 0x66, 0x2d, 0x38,
  0x22, 0x3f, 0x3e, 0x0a, 0x77, 0x2e, 0x61, 0x64, 0x64, 0x45, 0x76, 0x65, 0x6e,
  0x74, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x3f, 0x61, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77,
  0x77, 0x77, 0x2e, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x20, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x3d, 0x22, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e,
  0x64, 0x3a, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f,
  0x63, 0x73, 0x73, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x6d, 0x65, 0x74, 0x61, 0x20,
  0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x3d, 0x22, 0x6f, 0x67, 0x3a,
  0x74, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a,
  0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65,
  0x65, 0x74, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x68,
  0x74, 0x6d, 0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d,
  0x75, 0x74, 0x66, 0x2d, 0x38, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69,
  0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x74, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30,
  0x30, 0x25, 0x22, 0x20, 0x49, 0x6e, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
  0x73, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x49, 0x74, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72,
  0x74, 0x61, 0x6e, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0a, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x20, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6f, 0x6e, 0x74,
  0x2d, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x31, 0x3e, 0x3c, 0x2f, 0x73, 0x70, 0x61,
  0x6e, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x69, 0x64, 0x3d, 0x67, 0x62,
  0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x43, 0x6f,
  0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72,
  0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x69, 0x6d, 0x45,
  0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x61, 0x64, 0x65, 0x6d, 0x79, 0x20,
  0x6f, 0x66, 0x20, 0x53, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x64, 0x69,
  0x76, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x70,
  0x6c, 0x61, 0x79, 0x3a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x2e, 0x67, 0x65,
  0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x79, 0x49, 0x64, 0x28,
  0x69, 0x64, 0x29, 0x69, 0x6e, 0x20, 0x63, 0x6f, 0x6e, 0x6a, 0x75, 0x6e, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x45, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x28, 0x27, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x27, 0x29,
  0x3b, 0x20, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x70, 0x72, 0x6f, 0x70, 0x65,
  0x72, 0x74, 0x79, 0x3d, 0x22, 0x6f, 0x67, 0x3a, 0xd0, 0x91, 0xd1, 0x8a, 0xd0,
  0xbb, 0xd0, 0xb3, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8,
  0x0a, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x3e, 0x50, 0x72, 0x69, 0x76, 0x61,
  0x63, 0x79, 0x20, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3c, 0x2f, 0x61, 0x3e,
  0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
  0x69, 0x6e, 0x67, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x3d, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x6d, 0x61,
  0x72, 0x67, 0x69, 0x6e, 0x3a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x3e, 0x3c,
  0x69, 0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x69, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x3a, 0x72, 0x65, 0x66,
  0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x73, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x20, 0x70, 0x6f, 0x70, 0x75,
  0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x57,
  0x61, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x74, 0x6f, 0x6e, 0x2c, 0x20, 0x44, 0x2e,
  0x43, 0x2e, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62, 0x61, 0x63,
  0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x61, 0x6d, 0x6f, 0x6e, 0x67,
  0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
  0x2c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
  0x69, 0x70, 0x61, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65,
  0x74, 0x68, 0x65, 0x20, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
  0x69, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x66,
  0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x63, 0x68, 0x61, 0x72,
  0x61, 0x63, 0x74, 0x65, 0x72, 0x20, 0x4f, 0x78, 0x66, 0x6f, 0x72, 0x64, 0x20,
  0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x20, 0x6d, 0x69,
  0x73, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x6f, 0x66, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65,
  0x2c, 0x20, 0x68, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x2f, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x62, 0x69, 0x61, 0x20, 0x55,
  0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x65, 0x78, 0x70, 0x61,
  0x6e, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75,
  0x64, 0x65, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x72, 0x65, 0x66,
  0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x69, 0x6e, 0x64, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68,
  0x65, 0x68, 0x61, 0x76, 0x65, 0x20, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x66, 0x66, 0x69, 0x6c, 0x69,
  0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65,
  0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x62,
  0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20,
  0x6f, 0x66, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x3e,
  0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x3c, 0x2f, 0x74,
  0x61, 0x62, 0x6c, 0x65, 0x3e, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
  0x20, 0x6f, 0x66, 0x20, 0x49, 0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x0a, 0x3c,
  0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x63, 0x6f, 0x6e,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x4f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x77,
  0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x61, 0x64,
  0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x61, 0x72,
  0x6f, 0x75, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6d, 0x70, 0x6c, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x64, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x64, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61,
  0x6c, 0x20, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x6f, 0x66,
  0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61,
  0x73, 0x69, 0x6e, 0x67, 0x6c, 0x79, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x4e,
  0x6f, 0x74, 0x65, 0x2c, 0x20, 0x68, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x20,
  0x74, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x63, 0x61,
  0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x61, 0x6e, 0x63,
  0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x72,
  0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x20, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x66, 0x75, 0x72, 0x74, 0x68, 0x65, 0x72, 0x20, 0x64, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x75, 0x6e, 0x64, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x69, 0x73, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x63, 0x6f,
  0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x68, 0x69, 0x73, 0x20, 0x79,
  0x6f, 0x75, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x62, 0x72, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x3c, 0x2f,
  0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70,
  0x2d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x58, 0x2d, 0x55, 0x41, 0x2d,
  0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x70, 0x72, 0x6f, 0x70,
  0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x6f, 0x66, 0x20, 0x42, 0x72, 0x69, 0x74,
  0x69, 0x73, 0x68, 0x20, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x62, 0x69, 0x61, 0x68,
  0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x63, 0x72, 0x69, 0x74, 0x69,
  0x63, 0x69, 0x7a, 0x65, 0x64, 0x28, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x71, 0x75,
  0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x74,
  0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x30, 0x22, 0x20,
  0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3d, 0x22,
  0x30, 0x22, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64, 0x73, 0x20,
  0x6f, 0x66, 0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x72, 0x65, 0x64, 0x69,
  0x72, 0x65, 0x63, 0x74, 0x73, 0x20, 0x68, 0x65, 0x72, 0x65, 0x2e, 0x20, 0x46,
  0x6f, 0x72, 0x68, 0x61, 0x76, 0x65, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72,
  0x65, 0x6e, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x25, 0x33, 0x45, 0x25, 0x33,
  0x43, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x25, 0x33, 0x45, 0x22, 0x29,
  0x29, 0x3b, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x3c, 0x6c, 0x69, 0x3e,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22,
  0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x74, 0x65, 0x78,
  0x74, 0x2d, 0x64, 0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
  0x6e, 0x6f, 0x6e, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x64, 0x69,
  0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x20, 0x6e, 0x6f, 0x6e, 0x65, 0x3c, 0x6d,
  0x65, 0x74, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70, 0x2d, 0x65, 0x71, 0x75, 0x69,
  0x76, 0x3d, 0x22, 0x58, 0x2d, 0x6e, 0x65, 0x77, 0x20, 0x44, 0x61, 0x74, 0x65,
  0x28, 0x29, 0x2e, 0x67, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x28, 0x29, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x78,
  0x2d, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e,
  0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x6a, 0x61, 0x76,
  0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
  0x2e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x68, 0x72, 0x65,
  0x66, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x6a, 0x61, 0x76,
  0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x74, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x68, 0x6f, 0x72, 0x74,
  0x63, 0x75, 0x74, 0x20, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x74, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x2f, 0x61, 0x3e, 0x20, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x20,
  0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72,
  0x65, 0x6e, 0x63, 0x79, 0x3d, 0x22, 0x58, 0x2d, 0x55, 0x41, 0x2d, 0x43, 0x6f,
  0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e,
  0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x20,
  0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x20, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c, 0x2f, 0x75,
  0x6c, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x61, 0x73, 0x73, 0x6f, 0x63,
  0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x69, 0x6e, 0x67,
  0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3c, 0x2f, 0x61, 0x3e,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c,
  0x6c, 0x69, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x66, 0x6f, 0x72,
  0x6d, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x22, 0x71, 0x22, 0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x77,
  0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x30, 0x25, 0x22, 0x20, 0x62,
  0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x70, 0x6f, 0x73,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65,
  0x72, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
  0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x63, 0x75, 0x74,
  0x20, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x20, 0x68, 0x36, 0x3e, 0x3c, 0x75, 0x6c,
  0x3e, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d,
  0x22, 0x20, 0x20, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70,
  0x2d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x63, 0x73, 0x73, 0x22, 0x20,
  0x6d, 0x65, 0x64, 0x69, 0x61, 0x3d, 0x22, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e,
  0x22, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x6c, 0x65,
  0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x22, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x2f, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62,
  0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x68, 0x74, 0x6d,
  0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x75, 0x74,
  0x66, 0x2d, 0x38, 0x22, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x74, 0x72, 0x61,
  0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x3d, 0x22, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x74, 0x65, 0x0d, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20,
  0x68, 0x74, 0x74, 0x70, 0x2d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x3e,
  0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c,
  0x6c, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x3e,
  0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x69,
  0x6d, 0x65, 0x73, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x68,
  0x65, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x6e, 0x65, 0x63,
  0x65, 0x73, 0x73, 0x61, 0x72, 0x69, 0x6c, 0x79, 0x46, 0x6f, 0x72, 0x20, 0x6d,
  0x6f, 0x72, 0x65, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x67, 0x69,
  0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x20, 0x3c, 0x21, 0x44, 0x4f,
  0x43, 0x54, 0x59, 0x50, 0x45, 0x20, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x3c, 0x68,
  0x74, 0x6d, 0x6c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72,
  0x6c, 0x79, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x3a, 0x76, 0x6f, 0x69, 0x64, 0x28, 0x30, 0x29, 0x3b, 0x22, 0x65, 0x66,
  0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x65, 0x74, 0x65, 0x3d, 0x22, 0x6f, 0x66, 0x66, 0x22, 0x20, 0x67,
  0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x73,
  0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x3e, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74,
  0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20,
  0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a,
  0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67,
  0x68, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c,
  0x64, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x20, 0x6d, 0x69, 0x73, 0x63, 0x6f,
  0x6e, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x73, 0x73, 0x6f, 0x63,
  0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74,
  0x68, 0x65, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x64, 0x75, 0x72, 0x69,
  0x6e, 0x67, 0x20, 0x68, 0x69, 0x73, 0x20, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69,
  0x6d, 0x65, 0x2c, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x78, 0x2d, 0x69, 0x63,
  0x6f, 0x6e, 0x22, 0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61,
  0x73, 0x69, 0x6e, 0x67, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x64, 0x69,
  0x70, 0x6c, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x20, 0x72, 0x65, 0x6c, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x65,
  0x6e, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x6d,
  0x65, 0x74, 0x61, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x22,
  0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x20, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74,
  0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20,
  0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x63, 0x6c,
  0x75, 0x64, 0x65, 0x20, 0x74, 0x68, 0x65, 0x22, 0x3e, 0x3c, 0x69, 0x6d, 0x67,
  0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x69, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x65,
  0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x20,
  0x6f, 0x66, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x64, 0x69,
  0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x26, 0x61, 0x6d, 0x70,
  0x3b, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6e, 0x62,
  0x73, 0x70, 0x3b, 0x74, 0x6f, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
  0x6e, 0x65, 0x20, 0x77, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x71, 0x75, 0x69,
  0x74, 0x65, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x64, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x64, 0x69,
  0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x63,
  0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65,
  0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x77, 0x69, 0x64, 0x65, 0x6c, 0x79, 0x20,
  0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x77, 0x61, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x77, 0x69, 0x74, 0x68, 0x20, 0x76,
  0x61, 0x72, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65,
  0x73, 0x68, 0x61, 0x76, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x28, 0x64, 0x6f, 0x63, 0x75,
  0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x69,
  0x6e, 0x67, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x69, 0x67,
  0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
  0x70, 0x65, 0x64, 0x65, 0x74, 0x61, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65,
  0x74, 0x3d, 0x22, 0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x3e, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22,
  0x20, 0x2f, 0x3e, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
  0x67, 0x65, 0x61, 0x62, 0x6c, 0x79, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6d, 0x6f,
  0x72, 0x65, 0x20, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x6c, 0x79, 0x20, 0x72, 0x65,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x61,
  0x6e, 0x64, 0x20, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x74,
  0x68, 0x61, 0x74, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6f, 0x74, 0x68,
  0x65, 0x72, 0x77, 0x69, 0x73, 0x65, 0x70, 0x65, 0x72, 0x70, 0x65, 0x6e, 0x64,
  0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65,
  0x73, 0x74, 0x79, 0x6c, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x22, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x20, 0x72, 0x65, 0x73,
  0x69, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x64, 0x65, 0x76, 0x65, 0x6c,
  0x6f, 0x70, 0x69, 0x6e, 0x67, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69,
  0x65, 0x73, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x20, 0x70, 0x72,
  0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x69, 0x6e, 0x67, 0x65, 0x63, 0x6f, 0x6e,
  0x6f, 0x6d, 0x69, 0x63, 0x20, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d,
  0x65, 0x6e, 0x74, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x66, 0x6f, 0x72,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x6e, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61,
  0x6c, 0x20, 0x6f, 0x63, 0x63, 0x61, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x6f,
  0x72, 0x74, 0x75, 0x67, 0x75, 0xc3, 0xaa, 0x73, 0x20, 0x28, 0x45, 0x75, 0x72,
  0x6f, 0x70, 0x65, 0x75, 0x29, 0xd0, 0xa3, 0xd0, 0xba, 0xd1, 0x80, 0xd0, 0xb0,
  0xd1, 0x97, 0xd0, 0xbd, 0xd1, 0x81, 0xd1, 0x8c, 0xd0, 0xba, 0xd0, 0xb0, 0xd1,
  0x83, 0xd0, 0xba, 0xd1, 0x80, 0xd0, 0xb0, 0xd1, 0x97, 0xd0, 0xbd, 0xd1, 0x81,
  0xd1, 0x8c, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xa0, 0xd0, 0xbe, 0xd1, 0x81, 0xd1,
  0x81, 0xd0, 0xb8, 0xd0, 0xb9, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb9,
  0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb8, 0xd0,
  0xb0, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x84,
  0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd0,
  0xb8, 0xd1, 0x83, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xbb,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0,
  0xbe, 0xd0, 0xb1, 0xd1, 0x85, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb8, 0xd0, 0xbc,
  0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd0,
  0xbc, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0x98, 0xd0, 0xbd,
  0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x86, 0xd0,
  0xb8, 0xd1, 0x8f, 0xd0, 0xa0, 0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xbf, 0xd1, 0x83,
  0xd0, 0xb1, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xba, 0xd0,
  0xbe, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x82,
  0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x84, 0xd0, 0xbe, 0xd1,
  0x80, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd1, 0x8e, 0xd1, 0x82,
  0xd0, 0xb5, 0xd1, 0x80, 0xd1, 0x80, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xbe, 0xd1,
  0x80, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xb4, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x82,
  0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x87, 0xd0, 0xbd, 0xd0, 0xbe, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xaa, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xac,
  0xd8, 0xaf, 0xd9, 0x88, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd8,
  0xb4, 0xd8, 0xaa, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x82, 0xd8, 0xaa, 0xd8, 0xb1, 0xd8,
  0xa7, 0xd8, 0xad, 0xd8, 0xa7, 0xd8, 0xaa, 0x68, 0x74, 0x6d, 0x6c, 0x3b, 0x20,
  0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x55, 0x54, 0x46, 0x2d, 0x38,
  0x22, 0x20, 0x73, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x28,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x64, 0x69, 0x73,
  0x70, 0x6c, 0x61, 0x79, 0x3a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2d, 0x62,
  0x6c, 0x6f, 0x63, 0x6b, 0x3b, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x20, 0x3d, 0x20, 0x27, 0x74, 0x65, 0x78, 0x74, 0x2f,
  0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x3c, 0x69, 0x6d, 0x67, 0x20,
  0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77,
  0x77, 0x77, 0x2e, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x73, 0x68,
  0x6f, 0x72, 0x74, 0x63, 0x75, 0x74, 0x20, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x22, 0x20, 0x61, 0x75, 0x74, 0x6f, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x3d, 0x22, 0x6f, 0x66, 0x66, 0x22,
  0x20, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x3c, 0x2f, 0x61, 0x3e,
  0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x0a, 0x3c, 0x6c, 0x69, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x63, 0x73, 0x73, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65,
  0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x3c,
  0x66, 0x6f, 0x72, 0x6d, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x22,
  0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73,
  0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x61,
  0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x22, 0x20, 0x0d, 0x0a, 0x3c,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x2f, 0x20, 0x6f, 0x6e, 0x63, 0x6c, 0x69, 0x63, 0x6b,
  0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3a,
  0x28, 0x6e, 0x65, 0x77, 0x20, 0x44, 0x61, 0x74, 0x65, 0x29, 0x2e, 0x67, 0x65,
  0x74, 0x54, 0x69, 0x6d, 0x65, 0x28, 0x29, 0x7d, 0x68, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x3d, 0x22, 0x31, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
  0x31, 0x22, 0x20, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x27, 0x73, 0x20, 0x52,
  0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x6f, 0x66, 0x20, 0x20, 0x3c,
  0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x64, 0x65,
  0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x75, 0x6e, 0x64, 0x65,
  0x72, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69, 0x6e,
  0x67, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x0a, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68,
  0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x23, 0x76, 0x69, 0x65, 0x77, 0x70,
  0x6f, 0x72, 0x74, 0x7b, 0x6d, 0x69, 0x6e, 0x2d, 0x68, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x3a, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x73, 0x72,
  0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x6f, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x3e, 0x3c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x3d, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x72, 0x65,
  0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x73, 0x20,
  0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x0a, 0x3c, 0x6f, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x3c, 0x21, 0x44, 0x4f, 0x43,
  0x54, 0x59, 0x50, 0x45, 0x20, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x5b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x20, 0x41, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x3e, 0x0a,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x61, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0xe0, 0xb8, 0xa0, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0xa9, 0xe0, 0xb8, 0xb2,
  0xe0, 0xb9, 0x84, 0xe0, 0xb8, 0x97, 0xe0, 0xb8, 0xa2, 0xe1, 0x83, 0xa5, 0xe1,
  0x83, 0x90, 0xe1, 0x83, 0xa0, 0xe1, 0x83, 0x97, 0xe1, 0x83, 0xa3, 0xe1, 0x83,
  0x9a, 0xe1, 0x83, 0x98, 0xe6, 0xad, 0xa3, 0xe9, 0xab, 0x94, 0xe4, 0xb8, 0xad,
  0xe6, 0x96, 0x87, 0x20, 0x28, 0xe7, 0xb9, 0x81, 0xe9, 0xab, 0x94, 0x29, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8b, 0xe0,
  0xa4, 0xa1, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb7, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xac, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5,
  0x8d, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa0, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0x9e, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x85, 0xe0,
  0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xad,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0x97, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0x9a, 0xe0,
  0xa4, 0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa4, 0xa3, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa5,
  0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xad, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xab, 0xe0, 0xa4, 0xbc, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xae, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa1, 0x64,
  0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x64, 0x6f, 0x63, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x2e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
  0x70, 0x72, 0x6f, 0x74, 0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x73, 0x42, 0x79, 0x54, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x28,
  0x3c, 0x21, 0x44, 0x4f, 0x43, 0x54, 0x59, 0x50, 0x45, 0x20, 0x68, 0x74, 0x6d,
  0x6c, 0x3e, 0x0a, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x3c, 0x6d, 0x65, 0x74,
  0x61, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x75, 0x74,
  0x66, 0x2d, 0x38, 0x22, 0x3e, 0x3a, 0x75, 0x72, 0x6c, 0x22, 0x20, 0x63, 0x6f,
  0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x2e, 0x63, 0x73, 0x73, 0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74,
  0x2f, 0x63, 0x73, 0x73, 0x22, 0x3e, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x31, 0x39, 0x39, 0x39,
  0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x20, 0x78, 0x6d, 0x6c, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f,
  0x64, 0x3d, 0x22, 0x67, 0x65, 0x74, 0x22, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x3d, 0x22, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22,
  0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x20,
  0x3d, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x65,
  0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x78, 0x2d, 0x69, 0x63, 0x6f, 0x6e,
  0x22, 0x20, 0x2f, 0x3e, 0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69,
  0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x70,
  0x2e, 0x63, 0x73, 0x73, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x3c, 0x2f, 0x61, 0x3e,
  0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
  0x22, 0x31, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x31,
  0x22, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x6e,
  0x6f, 0x6e, 0x65, 0x3b, 0x22, 0x3e, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61,
  0x74, 0x65, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x61, 0x70, 0x70,
  0x6c, 0x69, 0x2d, 0x2f, 0x2f, 0x57, 0x33, 0x43, 0x2f, 0x2f, 0x44, 0x54, 0x44,
  0x20, 0x58, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x31, 0x2e, 0x30, 0x20, 0x65, 0x6c,
  0x6c, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x20,
  0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75,
  0x65, 0x3d, 0x22, 0x2f, 0x61, 0x3e, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c,
  0x73, 0x70, 0x61, 0x6e, 0x20, 0x72, 0x6f, 0x6c, 0x65, 0x3d, 0x22, 0x73, 0x0a,
  0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75,
  0x61, 0x67, 0x65, 0x3d, 0x22, 0x4a, 0x61, 0x76, 0x61, 0x53, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x22, 0x20, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
  0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42,
  0x67, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x70, 0x61,
  0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x6d, 0x65,
  0x64, 0x69, 0x61, 0x3d, 0x22, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x74, 0x65,
  0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x27, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x78, 0x63,
  0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x79, 0x70, 0x65,
  0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x72,
  0x65, 0x6c, 0x3d, 0x22, 0x73, 0x74, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x3d, 0x22, 0x31, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31,
  0x22, 0x20, 0x3d, 0x27, 0x2b, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x55, 0x52,
  0x49, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x28, 0x3c, 0x6c,
  0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x61, 0x6c, 0x74, 0x65,
  0x72, 0x6e, 0x61, 0x74, 0x65, 0x22, 0x20, 0x0a, 0x62, 0x6f, 0x64, 0x79, 0x2c,
  0x20, 0x74, 0x72, 0x2c, 0x20, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x2c, 0x20, 0x74,
  0x65, 0x78, 0x74, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x22, 0x72, 0x6f, 0x62, 0x6f, 0x74, 0x73, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x6d,
  0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x70, 0x6f, 0x73, 0x74, 0x22, 0x20,
  0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x3e, 0x0a, 0x3c, 0x61, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0x77, 0x77, 0x2e, 0x63, 0x73, 0x73, 0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d,
  0x22, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x6c, 0x61, 0x6e, 0x67,
  0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x22, 0x3e, 0x61, 0x72, 0x69, 0x61, 0x2d, 0x68, 0x69, 0x64,
  0x64, 0x65, 0x6e, 0x3d, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x3e, 0xc2, 0xb7,
  0x3c, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x6c, 0x3d, 0x30,
  0x3b, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x0a, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x28, 0x29, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f,
  0x75, 0x6e, 0x64, 0x2d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x3a, 0x20, 0x75, 0x72,
  0x6c, 0x28, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c, 0x6c, 0x69,
  0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x09, 0x09,
  0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22,
  0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x20,
  0x61, 0x72, 0x69, 0x61, 0x2d, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x3d, 0x22,
  0x74, 0x72, 0x75, 0x3e, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d,
  0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x6c,
  0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x2f, 0x6f, 0x70, 0x74, 0x69,
  0x6f, 0x6e, 0x3e, 0x0a, 0x3c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x20, 0x61, 0x72, 0x69, 0x61, 0x2d, 0x68,
  0x69, 0x64, 0x64, 0x65, 0x6e, 0x3d, 0x22, 0x74, 0x72, 0x65, 0x3d, 0x28, 0x6e,
  0x65, 0x77, 0x20, 0x44, 0x61, 0x74, 0x65, 0x29, 0x2e, 0x67, 0x65, 0x74, 0x54,
  0x69, 0x6d, 0x65, 0x28, 0x29, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xc3,
  0xaa, 0x73, 0x20, 0x28, 0x64, 0x6f, 0x20, 0x42, 0x72, 0x61, 0x73, 0x69, 0x6c,
  0x29, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb3, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8,
  0xd0, 0xb7, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xb2, 0xd0,
  0xbe, 0xd0, 0xb7, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x80, 0xd0,
  0xb0, 0xd0, 0xb7, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8,
  0xd1, 0x8f, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xb8, 0xd1, 0x81, 0xd1,
  0x82, 0xd1, 0x80, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xb2,
  0xd0, 0xbe, 0xd0, 0xb7, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0,
  0xbe, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x8f,
  0xd0, 0xb7, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0,
  0xbd, 0xd0, 0xb0, 0x3c, 0x21, 0x44, 0x4f, 0x43, 0x54, 0x59, 0x50, 0x45, 0x20,
  0x68, 0x74, 0x6d, 0x6c, 0x20, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x20, 0x22,
  0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x3c, 0x6d, 0x65,
  0x74, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70, 0x2d, 0x65, 0x71, 0x75, 0x69, 0x76,
  0x3d, 0x22, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x2f, 0x2f, 0x45, 0x4e, 0x22, 0x20, 0x22, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x78, 0x6d, 0x6c,
  0x6e, 0x73, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
  0x77, 0x2d, 0x2f, 0x2f, 0x57, 0x33, 0x43, 0x2f, 0x2f, 0x44, 0x54, 0x44, 0x20,
  0x58, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x31, 0x2e, 0x30, 0x20, 0x54, 0x44, 0x54,
  0x44, 0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x31, 0x2d, 0x74, 0x72, 0x61, 0x6e,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x2f, 0x2f, 0x77, 0x77, 0x77,
  0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x54, 0x52, 0x2f, 0x78, 0x68,
  0x74, 0x6d, 0x6c, 0x31, 0x2f, 0x70, 0x65, 0x20, 0x3d, 0x20, 0x27, 0x74, 0x65,
  0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x27, 0x3b, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x22, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x70,
  0x61, 0x72, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x2e, 0x69, 0x6e, 0x73,
  0x65, 0x72, 0x74, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x3c, 0x69, 0x6e, 0x70,
  0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x68, 0x69, 0x64, 0x64,
  0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61, 0x6a, 0x73, 0x22, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73,
  0x63, 0x72, 0x69, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x29,
  0x2e, 0x72, 0x65, 0x61, 0x64, 0x79, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x69, 0x6d, 0x61,
  0x67, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22,
  0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x55, 0x41, 0x2d, 0x43, 0x6f, 0x6d,
  0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x3d, 0x74, 0x6d, 0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72,
  0x73, 0x65, 0x74, 0x3d, 0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x20, 0x2f, 0x3e,
  0x0a, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73, 0x68,
  0x6f, 0x72, 0x74, 0x63, 0x75, 0x74, 0x20, 0x69, 0x63, 0x6f, 0x6e, 0x3c, 0x6c,
  0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x3d, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
  0x6e, 0x74, 0x2e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x3c, 0x61, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x22,
  0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d,
  0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x65, 0x74,
  0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x69, 0x6e, 0x70, 0x75,
  0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x20,
  0x3d, 0x20, 0x27, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73,
  0x63, 0x72, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x68, 0x74, 0x6d, 0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74,
  0x3d, 0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x20, 0x2f, 0x3e, 0x64, 0x74, 0x64,
  0x22, 0x3e, 0x0a, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x78, 0x6d, 0x6c, 0x6e,
  0x73, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x2d, 0x2f, 0x2f, 0x57, 0x33, 0x43,
  0x2f, 0x2f, 0x44, 0x54, 0x44, 0x20, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x34, 0x2e,
  0x30, 0x31, 0x20, 0x54, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x79, 0x54, 0x61, 0x67,
  0x4e, 0x61, 0x6d, 0x65, 0x28, 0x27, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x27,
  0x29, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x3c, 0x73,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x22, 0x20, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a,
  0x6e, 0x6f, 0x6e, 0x65, 0x3b, 0x22, 0x3e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
  0x6e, 0x74, 0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x42, 0x79, 0x49, 0x64, 0x28, 0x3d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
  0x74, 0x2e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x28, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x74, 0x65,
  0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x27, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x64,
  0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42,
  0x79, 0x54, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x28, 0x73, 0x6e, 0x69, 0x63,
  0x61, 0x6c, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x43, 0x2f, 0x2f, 0x44, 0x54,
  0x44, 0x20, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x34, 0x2e, 0x30, 0x31, 0x20, 0x54,
  0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x3c, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73,
  0x73, 0x22, 0x3e, 0x0a, 0x0a, 0x3c, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73,
  0x22, 0x3e, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x2e, 0x64, 0x74, 0x64, 0x22, 0x3e,
  0x0a, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x78, 0x6d, 0x6c, 0x6e, 0x73, 0x3d,
  0x68, 0x74, 0x74, 0x70, 0x2d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x43,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x64, 0x69,
  0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x70,
  0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x68, 0x74, 0x6d, 0x6c,
  0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x75, 0x74, 0x66,
  0x2d, 0x38, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3d, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x6e, 0x6f, 0x6e,
  0x65, 0x3b, 0x22, 0x3e, 0x3c, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77,
  0x77, 0x77, 0x2e, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x74, 0x65, 0x78,
  0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x27,
  0x3e, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x8f, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbb,
  0xd1, 0x8c, 0xd0, 0xbd, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd1,
  0x81, 0xd0, 0xbe, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x82,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xbf, 0xd1,
  0x80, 0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xb7, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb4,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xb5, 0xd0,
  0xb7, 0xd0, 0xbe, 0xd0, 0xbf, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x81, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xab, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb7, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x89,
  0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x87, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0x9c, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9e, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x88, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe,
]);

// Used by the browser version
exports.init = function() {
  return exports.dictionary;
};


/***/ }),

/***/ 244:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Collection of static dictionary words.
*/

var data = __nccwpck_require__(613);
exports.init = function() {
  exports.dictionary = data.init();
};

exports.offsetsByLength = new Uint32Array([
     0,     0,     0,     0,     0,  4096,  9216, 21504, 35840, 44032,
 53248, 63488, 74752, 87040, 93696, 100864, 104704, 106752, 108928, 113536,
 115968, 118528, 119872, 121280, 122016,
]);

exports.sizeBitsByLength = new Uint8Array([
  0,  0,  0,  0, 10, 10, 11, 11, 10, 10,
 10, 10, 10,  9,  9,  8,  7,  7,  8,  7,
  7,  6,  6,  5,  5,
]);

exports.minDictionaryWordLength = 4;
exports.maxDictionaryWordLength = 24;


/***/ }),

/***/ 343:
/***/ ((__unused_webpack_module, exports) => {

function HuffmanCode(bits, value) {
  this.bits = bits;   /* number of bits used for this symbol */
  this.value = value; /* symbol value or table offset */
}

exports.h = HuffmanCode;

var MAX_LENGTH = 15;

/* Returns reverse(reverse(key, len) + 1, len), where reverse(key, len) is the
   bit-wise reversal of the len least significant bits of key. */
function GetNextKey(key, len) {
  var step = 1 << (len - 1);
  while (key & step) {
    step >>= 1;
  }
  return (key & (step - 1)) + step;
}

/* Stores code in table[0], table[step], table[2*step], ..., table[end] */
/* Assumes that end is an integer multiple of step */
function ReplicateValue(table, i, step, end, code) {
  do {
    end -= step;
    table[i + end] = new HuffmanCode(code.bits, code.value);
  } while (end > 0);
}

/* Returns the table width of the next 2nd level table. count is the histogram
   of bit lengths for the remaining symbols, len is the code length of the next
   processed symbol */
function NextTableBitSize(count, len, root_bits) {
  var left = 1 << (len - root_bits);
  while (len < MAX_LENGTH) {
    left -= count[len];
    if (left <= 0) break;
    ++len;
    left <<= 1;
  }
  return len - root_bits;
}

exports.g = function(root_table, table, root_bits, code_lengths, code_lengths_size) {
  var start_table = table;
  var code;            /* current table entry */
  var len;             /* current code length */
  var symbol;          /* symbol index in original or sorted table */
  var key;             /* reversed prefix code */
  var step;            /* step size to replicate values in current table */
  var low;             /* low bits for current root entry */
  var mask;            /* mask for low bits */
  var table_bits;      /* key length of current table */
  var table_size;      /* size of current table */
  var total_size;      /* sum of root table size and 2nd level table sizes */
  var sorted;          /* symbols sorted by code length */
  var count = new Int32Array(MAX_LENGTH + 1);  /* number of codes of each length */
  var offset = new Int32Array(MAX_LENGTH + 1);  /* offsets in sorted table for each length */

  sorted = new Int32Array(code_lengths_size);

  /* build histogram of code lengths */
  for (symbol = 0; symbol < code_lengths_size; symbol++) {
    count[code_lengths[symbol]]++;
  }

  /* generate offsets into sorted symbol table by code length */
  offset[1] = 0;
  for (len = 1; len < MAX_LENGTH; len++) {
    offset[len + 1] = offset[len] + count[len];
  }

  /* sort symbols by length, by symbol order within each length */
  for (symbol = 0; symbol < code_lengths_size; symbol++) {
    if (code_lengths[symbol] !== 0) {
      sorted[offset[code_lengths[symbol]]++] = symbol;
    }
  }
  
  table_bits = root_bits;
  table_size = 1 << table_bits;
  total_size = table_size;

  /* special case code with only one value */
  if (offset[MAX_LENGTH] === 1) {
    for (key = 0; key < total_size; ++key) {
      root_table[table + key] = new HuffmanCode(0, sorted[0] & 0xffff);
    }
    
    return total_size;
  }

  /* fill in root table */
  key = 0;
  symbol = 0;
  for (len = 1, step = 2; len <= root_bits; ++len, step <<= 1) {
    for (; count[len] > 0; --count[len]) {
      code = new HuffmanCode(len & 0xff, sorted[symbol++] & 0xffff);
      ReplicateValue(root_table, table + key, step, table_size, code);
      key = GetNextKey(key, len);
    }
  }

  /* fill in 2nd level tables and add pointers to root table */
  mask = total_size - 1;
  low = -1;
  for (len = root_bits + 1, step = 2; len <= MAX_LENGTH; ++len, step <<= 1) {
    for (; count[len] > 0; --count[len]) {
      if ((key & mask) !== low) {
        table += table_size;
        table_bits = NextTableBitSize(count, len, root_bits);
        table_size = 1 << table_bits;
        total_size += table_size;
        low = key & mask;
        root_table[start_table + low] = new HuffmanCode((table_bits + root_bits) & 0xff, ((table - start_table) - low) & 0xffff);
      }
      code = new HuffmanCode((len - root_bits) & 0xff, sorted[symbol++] & 0xffff);
      ReplicateValue(root_table, table + (key >> root_bits), step, table_size, code);
      key = GetNextKey(key, len);
    }
  }
  
  return total_size;
}


/***/ }),

/***/ 899:
/***/ ((__unused_webpack_module, exports) => {

/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Lookup tables to map prefix codes to value ranges. This is used during
   decoding of the block lengths, literal insertion lengths and copy lengths.
*/

/* Represents the range of values belonging to a prefix code: */
/* [offset, offset + 2^nbits) */
function PrefixCodeRange(offset, nbits) {
  this.offset = offset;
  this.nbits = nbits;
}

exports.kBlockLengthPrefixCode = [
  new PrefixCodeRange(1, 2), new PrefixCodeRange(5, 2), new PrefixCodeRange(9, 2), new PrefixCodeRange(13, 2),
  new PrefixCodeRange(17, 3), new PrefixCodeRange(25, 3), new PrefixCodeRange(33, 3), new PrefixCodeRange(41, 3),
  new PrefixCodeRange(49, 4), new PrefixCodeRange(65, 4), new PrefixCodeRange(81, 4), new PrefixCodeRange(97, 4),
  new PrefixCodeRange(113, 5), new PrefixCodeRange(145, 5), new PrefixCodeRange(177, 5), new PrefixCodeRange(209, 5),
  new PrefixCodeRange(241, 6), new PrefixCodeRange(305, 6), new PrefixCodeRange(369, 7), new PrefixCodeRange(497, 8),
  new PrefixCodeRange(753, 9), new PrefixCodeRange(1265, 10), new PrefixCodeRange(2289, 11), new PrefixCodeRange(4337, 12),
  new PrefixCodeRange(8433, 13), new PrefixCodeRange(16625, 24)
];

exports.kInsertLengthPrefixCode = [
  new PrefixCodeRange(0, 0), new PrefixCodeRange(1, 0), new PrefixCodeRange(2, 0), new PrefixCodeRange(3, 0),
  new PrefixCodeRange(4, 0), new PrefixCodeRange(5, 0), new PrefixCodeRange(6, 1), new PrefixCodeRange(8, 1),
  new PrefixCodeRange(10, 2), new PrefixCodeRange(14, 2), new PrefixCodeRange(18, 3), new PrefixCodeRange(26, 3),
  new PrefixCodeRange(34, 4), new PrefixCodeRange(50, 4), new PrefixCodeRange(66, 5), new PrefixCodeRange(98, 5),
  new PrefixCodeRange(130, 6), new PrefixCodeRange(194, 7), new PrefixCodeRange(322, 8), new PrefixCodeRange(578, 9),
  new PrefixCodeRange(1090, 10), new PrefixCodeRange(2114, 12), new PrefixCodeRange(6210, 14), new PrefixCodeRange(22594, 24),
];

exports.kCopyLengthPrefixCode = [
  new PrefixCodeRange(2, 0), new PrefixCodeRange(3, 0), new PrefixCodeRange(4, 0), new PrefixCodeRange(5, 0),
  new PrefixCodeRange(6, 0), new PrefixCodeRange(7, 0), new PrefixCodeRange(8, 0), new PrefixCodeRange(9, 0),
  new PrefixCodeRange(10, 1), new PrefixCodeRange(12, 1), new PrefixCodeRange(14, 2), new PrefixCodeRange(18, 2),
  new PrefixCodeRange(22, 3), new PrefixCodeRange(30, 3), new PrefixCodeRange(38, 4), new PrefixCodeRange(54, 4),
  new PrefixCodeRange(70, 5), new PrefixCodeRange(102, 5), new PrefixCodeRange(134, 6), new PrefixCodeRange(198, 7),
  new PrefixCodeRange(326, 8), new PrefixCodeRange(582, 9), new PrefixCodeRange(1094, 10), new PrefixCodeRange(2118, 24),
];

exports.kInsertRangeLut = [
  0, 0, 8, 8, 0, 16, 8, 16, 16,
];

exports.kCopyRangeLut = [
  0, 8, 0, 8, 16, 0, 16, 8, 16,
];


/***/ }),

/***/ 586:
/***/ ((__unused_webpack_module, exports) => {

function BrotliInput(buffer) {
  this.buffer = buffer;
  this.pos = 0;
}

BrotliInput.prototype.read = function(buf, i, count) {
  if (this.pos + count > this.buffer.length) {
    count = this.buffer.length - this.pos;
  }
  
  for (var p = 0; p < count; p++)
    buf[i + p] = this.buffer[this.pos + p];
  
  this.pos += count;
  return count;
}

exports.g = BrotliInput;

function BrotliOutput(buf) {
  this.buffer = buf;
  this.pos = 0;
}

BrotliOutput.prototype.write = function(buf, count) {
  if (this.pos + count > this.buffer.length)
    throw new Error('Output buffer is not large enough');
  
  this.buffer.set(buf.subarray(0, count), this.pos);
  this.pos += count;
  return count;
};

exports.j = BrotliOutput;


/***/ }),

/***/ 253:
/***/ ((__unused_webpack_module, exports, __nccwpck_require__) => {

/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Transformations on dictionary words.
*/

var BrotliDictionary = __nccwpck_require__(244);

var kIdentity       = 0;
var kOmitLast1      = 1;
var kOmitLast2      = 2;
var kOmitLast3      = 3;
var kOmitLast4      = 4;
var kOmitLast5      = 5;
var kOmitLast6      = 6;
var kOmitLast7      = 7;
var kOmitLast8      = 8;
var kOmitLast9      = 9;
var kUppercaseFirst = 10;
var kUppercaseAll   = 11;
var kOmitFirst1     = 12;
var kOmitFirst2     = 13;
var kOmitFirst3     = 14;
var kOmitFirst4     = 15;
var kOmitFirst5     = 16;
var kOmitFirst6     = 17;
var kOmitFirst7     = 18;
var kOmitFirst8     = 19;
var kOmitFirst9     = 20;

function Transform(prefix, transform, suffix) {
  this.prefix = new Uint8Array(prefix.length);
  this.transform = transform;
  this.suffix = new Uint8Array(suffix.length);
  
  for (var i = 0; i < prefix.length; i++)
    this.prefix[i] = prefix.charCodeAt(i);
  
  for (var i = 0; i < suffix.length; i++)
    this.suffix[i] = suffix.charCodeAt(i);
}

var kTransforms = [
     new Transform(         "", kIdentity,       ""           ),
     new Transform(         "", kIdentity,       " "          ),
     new Transform(        " ", kIdentity,       " "          ),
     new Transform(         "", kOmitFirst1,     ""           ),
     new Transform(         "", kUppercaseFirst, " "          ),
     new Transform(         "", kIdentity,       " the "      ),
     new Transform(        " ", kIdentity,       ""           ),
     new Transform(       "s ", kIdentity,       " "          ),
     new Transform(         "", kIdentity,       " of "       ),
     new Transform(         "", kUppercaseFirst, ""           ),
     new Transform(         "", kIdentity,       " and "      ),
     new Transform(         "", kOmitFirst2,     ""           ),
     new Transform(         "", kOmitLast1,      ""           ),
     new Transform(       ", ", kIdentity,       " "          ),
     new Transform(         "", kIdentity,       ", "         ),
     new Transform(        " ", kUppercaseFirst, " "          ),
     new Transform(         "", kIdentity,       " in "       ),
     new Transform(         "", kIdentity,       " to "       ),
     new Transform(       "e ", kIdentity,       " "          ),
     new Transform(         "", kIdentity,       "\""         ),
     new Transform(         "", kIdentity,       "."          ),
     new Transform(         "", kIdentity,       "\">"        ),
     new Transform(         "", kIdentity,       "\n"         ),
     new Transform(         "", kOmitLast3,      ""           ),
     new Transform(         "", kIdentity,       "]"          ),
     new Transform(         "", kIdentity,       " for "      ),
     new Transform(         "", kOmitFirst3,     ""           ),
     new Transform(         "", kOmitLast2,      ""           ),
     new Transform(         "", kIdentity,       " a "        ),
     new Transform(         "", kIdentity,       " that "     ),
     new Transform(        " ", kUppercaseFirst, ""           ),
     new Transform(         "", kIdentity,       ". "         ),
     new Transform(        ".", kIdentity,       ""           ),
     new Transform(        " ", kIdentity,       ", "         ),
     new Transform(         "", kOmitFirst4,     ""           ),
     new Transform(         "", kIdentity,       " with "     ),
     new Transform(         "", kIdentity,       "'"          ),
     new Transform(         "", kIdentity,       " from "     ),
     new Transform(         "", kIdentity,       " by "       ),
     new Transform(         "", kOmitFirst5,     ""           ),
     new Transform(         "", kOmitFirst6,     ""           ),
     new Transform(    " the ", kIdentity,       ""           ),
     new Transform(         "", kOmitLast4,      ""           ),
     new Transform(         "", kIdentity,       ". The "     ),
     new Transform(         "", kUppercaseAll,   ""           ),
     new Transform(         "", kIdentity,       " on "       ),
     new Transform(         "", kIdentity,       " as "       ),
     new Transform(         "", kIdentity,       " is "       ),
     new Transform(         "", kOmitLast7,      ""           ),
     new Transform(         "", kOmitLast1,      "ing "       ),
     new Transform(         "", kIdentity,       "\n\t"       ),
     new Transform(         "", kIdentity,       ":"          ),
     new Transform(        " ", kIdentity,       ". "         ),
     new Transform(         "", kIdentity,       "ed "        ),
     new Transform(         "", kOmitFirst9,     ""           ),
     new Transform(         "", kOmitFirst7,     ""           ),
     new Transform(         "", kOmitLast6,      ""           ),
     new Transform(         "", kIdentity,       "("          ),
     new Transform(         "", kUppercaseFirst, ", "         ),
     new Transform(         "", kOmitLast8,      ""           ),
     new Transform(         "", kIdentity,       " at "       ),
     new Transform(         "", kIdentity,       "ly "        ),
     new Transform(    " the ", kIdentity,       " of "       ),
     new Transform(         "", kOmitLast5,      ""           ),
     new Transform(         "", kOmitLast9,      ""           ),
     new Transform(        " ", kUppercaseFirst, ", "         ),
     new Transform(         "", kUppercaseFirst, "\""         ),
     new Transform(        ".", kIdentity,       "("          ),
     new Transform(         "", kUppercaseAll,   " "          ),
     new Transform(         "", kUppercaseFirst, "\">"        ),
     new Transform(         "", kIdentity,       "=\""        ),
     new Transform(        " ", kIdentity,       "."          ),
     new Transform(    ".com/", kIdentity,       ""           ),
     new Transform(    " the ", kIdentity,       " of the "   ),
     new Transform(         "", kUppercaseFirst, "'"          ),
     new Transform(         "", kIdentity,       ". This "    ),
     new Transform(         "", kIdentity,       ","          ),
     new Transform(        ".", kIdentity,       " "          ),
     new Transform(         "", kUppercaseFirst, "("          ),
     new Transform(         "", kUppercaseFirst, "."          ),
     new Transform(         "", kIdentity,       " not "      ),
     new Transform(        " ", kIdentity,       "=\""        ),
     new Transform(         "", kIdentity,       "er "        ),
     new Transform(        " ", kUppercaseAll,   " "          ),
     new Transform(         "", kIdentity,       "al "        ),
     new Transform(        " ", kUppercaseAll,   ""           ),
     new Transform(         "", kIdentity,       "='"         ),
     new Transform(         "", kUppercaseAll,   "\""         ),
     new Transform(         "", kUppercaseFirst, ". "         ),
     new Transform(        " ", kIdentity,       "("          ),
     new Transform(         "", kIdentity,       "ful "       ),
     new Transform(        " ", kUppercaseFirst, ". "         ),
     new Transform(         "", kIdentity,       "ive "       ),
     new Transform(         "", kIdentity,       "less "      ),
     new Transform(         "", kUppercaseAll,   "'"          ),
     new Transform(         "", kIdentity,       "est "       ),
     new Transform(        " ", kUppercaseFirst, "."          ),
     new Transform(         "", kUppercaseAll,   "\">"        ),
     new Transform(        " ", kIdentity,       "='"         ),
     new Transform(         "", kUppercaseFirst, ","          ),
     new Transform(         "", kIdentity,       "ize "       ),
     new Transform(         "", kUppercaseAll,   "."          ),
     new Transform( "\xc2\xa0", kIdentity,       ""           ),
     new Transform(        " ", kIdentity,       ","          ),
     new Transform(         "", kUppercaseFirst, "=\""        ),
     new Transform(         "", kUppercaseAll,   "=\""        ),
     new Transform(         "", kIdentity,       "ous "       ),
     new Transform(         "", kUppercaseAll,   ", "         ),
     new Transform(         "", kUppercaseFirst, "='"         ),
     new Transform(        " ", kUppercaseFirst, ","          ),
     new Transform(        " ", kUppercaseAll,   "=\""        ),
     new Transform(        " ", kUppercaseAll,   ", "         ),
     new Transform(         "", kUppercaseAll,   ","          ),
     new Transform(         "", kUppercaseAll,   "("          ),
     new Transform(         "", kUppercaseAll,   ". "         ),
     new Transform(        " ", kUppercaseAll,   "."          ),
     new Transform(         "", kUppercaseAll,   "='"         ),
     new Transform(        " ", kUppercaseAll,   ". "         ),
     new Transform(        " ", kUppercaseFirst, "=\""        ),
     new Transform(        " ", kUppercaseAll,   "='"         ),
     new Transform(        " ", kUppercaseFirst, "='"         )
];

exports.kTransforms = kTransforms;
exports.kNumTransforms = kTransforms.length;

function ToUpperCase(p, i) {
  if (p[i] < 0xc0) {
    if (p[i] >= 97 && p[i] <= 122) {
      p[i] ^= 32;
    }
    return 1;
  }
  
  /* An overly simplified uppercasing model for utf-8. */
  if (p[i] < 0xe0) {
    p[i + 1] ^= 32;
    return 2;
  }
  
  /* An arbitrary transform for three byte characters. */
  p[i + 2] ^= 5;
  return 3;
}

exports.transformDictionaryWord = function(dst, idx, word, len, transform) {
  var prefix = kTransforms[transform].prefix;
  var suffix = kTransforms[transform].suffix;
  var t = kTransforms[transform].transform;
  var skip = t < kOmitFirst1 ? 0 : t - (kOmitFirst1 - 1);
  var i = 0;
  var start_idx = idx;
  var uppercase;
  
  if (skip > len) {
    skip = len;
  }
  
  var prefix_pos = 0;
  while (prefix_pos < prefix.length) {
    dst[idx++] = prefix[prefix_pos++];
  }
  
  word += skip;
  len -= skip;
  
  if (t <= kOmitLast9) {
    len -= t;
  }
  
  for (i = 0; i < len; i++) {
    dst[idx++] = BrotliDictionary.dictionary[word + i];
  }
  
  uppercase = idx - len;
  
  if (t === kUppercaseFirst) {
    ToUpperCase(dst, uppercase);
  } else if (t === kUppercaseAll) {
    while (len > 0) {
      var step = ToUpperCase(dst, uppercase);
      uppercase += step;
      len -= step;
    }
  }
  
  var suffix_pos = 0;
  while (suffix_pos < suffix.length) {
    dst[idx++] = suffix[suffix_pos++];
  }
  
  return idx - start_idx;
}


/***/ }),

/***/ 754:
/***/ ((module, __unused_webpack_exports, __nccwpck_require__) => {

module.exports = __nccwpck_require__(328).BrotliDecompressBuffer;


/***/ }),

/***/ 630:
/***/ ((module) => {

var clone = (function() {
'use strict';

function _instanceof(obj, type) {
  return type != null && obj instanceof type;
}

var nativeMap;
try {
  nativeMap = Map;
} catch(_) {
  // maybe a reference error because no `Map`. Give it a dummy value that no
  // value will ever be an instanceof.
  nativeMap = function() {};
}

var nativeSet;
try {
  nativeSet = Set;
} catch(_) {
  nativeSet = function() {};
}

var nativePromise;
try {
  nativePromise = Promise;
} catch(_) {
  nativePromise = function() {};
}

/**
 * Clones (copies) an Object using deep copying.
 *
 * This function supports circular references by default, but if you are certain
 * there are no circular references in your object, you can save some CPU time
 * by calling clone(obj, false).
 *
 * Caution: if `circular` is false and `parent` contains circular references,
 * your program may enter an infinite loop and crash.
 *
 * @param `parent` - the object to be cloned
 * @param `circular` - set to true if the object to be cloned may contain
 *    circular references. (optional - true by default)
 * @param `depth` - set to a number if the object is only to be cloned to
 *    a particular depth. (optional - defaults to Infinity)
 * @param `prototype` - sets the prototype to be used when cloning an object.
 *    (optional - defaults to parent prototype).
 * @param `includeNonEnumerable` - set to true if the non-enumerable properties
 *    should be cloned as well. Non-enumerable properties on the prototype
 *    chain will be ignored. (optional - false by default)
*/
function clone(parent, circular, depth, prototype, includeNonEnumerable) {
  if (typeof circular === 'object') {
    depth = circular.depth;
    prototype = circular.prototype;
    includeNonEnumerable = circular.includeNonEnumerable;
    circular = circular.circular;
  }
  // maintain two arrays for circular references, where corresponding parents
  // and children have the same index
  var allParents = [];
  var allChildren = [];

  var useBuffer = typeof Buffer != 'undefined';

  if (typeof circular == 'undefined')
    circular = true;

  if (typeof depth == 'undefined')
    depth = Infinity;

  // recurse this function so we don't reset allParents and allChildren
  function _clone(parent, depth) {
    // cloning null always returns null
    if (parent === null)
      return null;

    if (depth === 0)
      return parent;

    var child;
    var proto;
    if (typeof parent != 'object') {
      return parent;
    }

    if (_instanceof(parent, nativeMap)) {
      child = new nativeMap();
    } else if (_instanceof(parent, nativeSet)) {
      child = new nativeSet();
    } else if (_instanceof(parent, nativePromise)) {
      child = new nativePromise(function (resolve, reject) {
        parent.then(function(value) {
          resolve(_clone(value, depth - 1));
        }, function(err) {
          reject(_clone(err, depth - 1));
        });
      });
    } else if (clone.__isArray(parent)) {
      child = [];
    } else if (clone.__isRegExp(parent)) {
      child = new RegExp(parent.source, __getRegExpFlags(parent));
      if (parent.lastIndex) child.lastIndex = parent.lastIndex;
    } else if (clone.__isDate(parent)) {
      child = new Date(parent.getTime());
    } else if (useBuffer && Buffer.isBuffer(parent)) {
      if (Buffer.allocUnsafe) {
        // Node.js >= 4.5.0
        child = Buffer.allocUnsafe(parent.length);
      } else {
        // Older Node.js versions
        child = new Buffer(parent.length);
      }
      parent.copy(child);
      return child;
    } else if (_instanceof(parent, Error)) {
      child = Object.create(parent);
    } else {
      if (typeof prototype == 'undefined') {
        proto = Object.getPrototypeOf(parent);
        child = Object.create(proto);
      }
      else {
        child = Object.create(prototype);
        proto = prototype;
      }
    }

    if (circular) {
      var index = allParents.indexOf(parent);

      if (index != -1) {
        return allChildren[index];
      }
      allParents.push(parent);
      allChildren.push(child);
    }

    if (_instanceof(parent, nativeMap)) {
      parent.forEach(function(value, key) {
        var keyChild = _clone(key, depth - 1);
        var valueChild = _clone(value, depth - 1);
        child.set(keyChild, valueChild);
      });
    }
    if (_instanceof(parent, nativeSet)) {
      parent.forEach(function(value) {
        var entryChild = _clone(value, depth - 1);
        child.add(entryChild);
      });
    }

    for (var i in parent) {
      var attrs;
      if (proto) {
        attrs = Object.getOwnPropertyDescriptor(proto, i);
      }

      if (attrs && attrs.set == null) {
        continue;
      }
      child[i] = _clone(parent[i], depth - 1);
    }

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(parent);
      for (var i = 0; i < symbols.length; i++) {
        // Don't need to worry about cloning a symbol because it is a primitive,
        // like a number or string.
        var symbol = symbols[i];
        var descriptor = Object.getOwnPropertyDescriptor(parent, symbol);
        if (descriptor && !descriptor.enumerable && !includeNonEnumerable) {
          continue;
        }
        child[symbol] = _clone(parent[symbol], depth - 1);
        if (!descriptor.enumerable) {
          Object.defineProperty(child, symbol, {
            enumerable: false
          });
        }
      }
    }

    if (includeNonEnumerable) {
      var allPropertyNames = Object.getOwnPropertyNames(parent);
      for (var i = 0; i < allPropertyNames.length; i++) {
        var propertyName = allPropertyNames[i];
        var descriptor = Object.getOwnPropertyDescriptor(parent, propertyName);
        if (descriptor && descriptor.enumerable) {
          continue;
        }
        child[propertyName] = _clone(parent[propertyName], depth - 1);
        Object.defineProperty(child, propertyName, {
          enumerable: false
        });
      }
    }

    return child;
  }

  return _clone(parent, depth);
}

/**
 * Simple flat clone using prototype, accepts only objects, usefull for property
 * override on FLAT configuration object (no nested props).
 *
 * USE WITH CAUTION! This may not behave as you wish if you do not know how this
 * works.
 */
clone.clonePrototype = function clonePrototype(parent) {
  if (parent === null)
    return null;

  var c = function () {};
  c.prototype = parent;
  return new c();
};

// private utility functions

function __objToStr(o) {
  return Object.prototype.toString.call(o);
}
clone.__objToStr = __objToStr;

function __isDate(o) {
  return typeof o === 'object' && __objToStr(o) === '[object Date]';
}
clone.__isDate = __isDate;

function __isArray(o) {
  return typeof o === 'object' && __objToStr(o) === '[object Array]';
}
clone.__isArray = __isArray;

function __isRegExp(o) {
  return typeof o === 'object' && __objToStr(o) === '[object RegExp]';
}
clone.__isRegExp = __isRegExp;

function __getRegExpFlags(re) {
  var flags = '';
  if (re.global) flags += 'g';
  if (re.ignoreCase) flags += 'i';
  if (re.multiline) flags += 'm';
  return flags;
}
clone.__getRegExpFlags = __getRegExpFlags;

return clone;
})();

if ( true && module.exports) {
  module.exports = clone;
}


/***/ }),

/***/ 803:
/***/ ((module) => {

"use strict";


var INITIAL_STATE = 1;
var FAIL_STATE = 0;
/**
 * A StateMachine represents a deterministic finite automaton.
 * It can perform matches over a sequence of values, similar to a regular expression.
 */

class StateMachine {
  constructor(dfa) {
    this.stateTable = dfa.stateTable;
    this.accepting = dfa.accepting;
    this.tags = dfa.tags;
  }
  /**
   * Returns an iterable object that yields pattern matches over the input sequence.
   * Matches are of the form [startIndex, endIndex, tags].
   */


  match(str) {
    var self = this;
    return {
      *[Symbol.iterator]() {
        var state = INITIAL_STATE;
        var startRun = null;
        var lastAccepting = null;
        var lastState = null;

        for (var p = 0; p < str.length; p++) {
          var c = str[p];
          lastState = state;
          state = self.stateTable[state][c];

          if (state === FAIL_STATE) {
            // yield the last match if any
            if (startRun != null && lastAccepting != null && lastAccepting >= startRun) {
              yield [startRun, lastAccepting, self.tags[lastState]];
            } // reset the state as if we started over from the initial state


            state = self.stateTable[INITIAL_STATE][c];
            startRun = null;
          } // start a run if not in the failure state


          if (state !== FAIL_STATE && startRun == null) {
            startRun = p;
          } // if accepting, mark the potential match end


          if (self.accepting[state]) {
            lastAccepting = p;
          } // reset the state to the initial state if we get into the failure state


          if (state === FAIL_STATE) {
            state = INITIAL_STATE;
          }
        } // yield the last match if any


        if (startRun != null && lastAccepting != null && lastAccepting >= startRun) {
          yield [startRun, lastAccepting, self.tags[state]];
        }
      }

    };
  }
  /**
   * For each match over the input sequence, action functions matching
   * the tag definitions in the input pattern are called with the startIndex,
   * endIndex, and sub-match sequence.
   */


  apply(str, actions) {
    for (var [start, end, tags] of this.match(str)) {
      for (var tag of tags) {
        if (typeof actions[tag] === 'function') {
          actions[tag](start, end, str.slice(start, end + 1));
        }
      }
    }
  }

}

module.exports = StateMachine;
//# sourceMappingURL=index.js.map


/***/ }),

/***/ 230:
/***/ ((module) => {

"use strict";


// do not edit .js files directly - edit src/index.jst



module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }



    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 151:
/***/ ((module) => {

var TINF_OK = 0;
var TINF_DATA_ERROR = -3;

function Tree() {
  this.table = new Uint16Array(16);   /* table of code length counts */
  this.trans = new Uint16Array(288);  /* code -> symbol translation table */
}

function Data(source, dest) {
  this.source = source;
  this.sourceIndex = 0;
  this.tag = 0;
  this.bitcount = 0;
  
  this.dest = dest;
  this.destLen = 0;
  
  this.ltree = new Tree();  /* dynamic length/symbol tree */
  this.dtree = new Tree();  /* dynamic distance tree */
}

/* --------------------------------------------------- *
 * -- uninitialized global data (static structures) -- *
 * --------------------------------------------------- */

var sltree = new Tree();
var sdtree = new Tree();

/* extra bits and base tables for length codes */
var length_bits = new Uint8Array(30);
var length_base = new Uint16Array(30);

/* extra bits and base tables for distance codes */
var dist_bits = new Uint8Array(30);
var dist_base = new Uint16Array(30);

/* special ordering of code length codes */
var clcidx = new Uint8Array([
  16, 17, 18, 0, 8, 7, 9, 6,
  10, 5, 11, 4, 12, 3, 13, 2,
  14, 1, 15
]);

/* used by tinf_decode_trees, avoids allocations every call */
var code_tree = new Tree();
var lengths = new Uint8Array(288 + 32);

/* ----------------------- *
 * -- utility functions -- *
 * ----------------------- */

/* build extra bits and base tables */
function tinf_build_bits_base(bits, base, delta, first) {
  var i, sum;

  /* build bits table */
  for (i = 0; i < delta; ++i) bits[i] = 0;
  for (i = 0; i < 30 - delta; ++i) bits[i + delta] = i / delta | 0;

  /* build base table */
  for (sum = first, i = 0; i < 30; ++i) {
    base[i] = sum;
    sum += 1 << bits[i];
  }
}

/* build the fixed huffman trees */
function tinf_build_fixed_trees(lt, dt) {
  var i;

  /* build fixed length tree */
  for (i = 0; i < 7; ++i) lt.table[i] = 0;

  lt.table[7] = 24;
  lt.table[8] = 152;
  lt.table[9] = 112;

  for (i = 0; i < 24; ++i) lt.trans[i] = 256 + i;
  for (i = 0; i < 144; ++i) lt.trans[24 + i] = i;
  for (i = 0; i < 8; ++i) lt.trans[24 + 144 + i] = 280 + i;
  for (i = 0; i < 112; ++i) lt.trans[24 + 144 + 8 + i] = 144 + i;

  /* build fixed distance tree */
  for (i = 0; i < 5; ++i) dt.table[i] = 0;

  dt.table[5] = 32;

  for (i = 0; i < 32; ++i) dt.trans[i] = i;
}

/* given an array of code lengths, build a tree */
var offs = new Uint16Array(16);

function tinf_build_tree(t, lengths, off, num) {
  var i, sum;

  /* clear code length count table */
  for (i = 0; i < 16; ++i) t.table[i] = 0;

  /* scan symbol lengths, and sum code length counts */
  for (i = 0; i < num; ++i) t.table[lengths[off + i]]++;

  t.table[0] = 0;

  /* compute offset table for distribution sort */
  for (sum = 0, i = 0; i < 16; ++i) {
    offs[i] = sum;
    sum += t.table[i];
  }

  /* create code->symbol translation table (symbols sorted by code) */
  for (i = 0; i < num; ++i) {
    if (lengths[off + i]) t.trans[offs[lengths[off + i]]++] = i;
  }
}

/* ---------------------- *
 * -- decode functions -- *
 * ---------------------- */

/* get one bit from source stream */
function tinf_getbit(d) {
  /* check if tag is empty */
  if (!d.bitcount--) {
    /* load next tag */
    d.tag = d.source[d.sourceIndex++];
    d.bitcount = 7;
  }

  /* shift bit out of tag */
  var bit = d.tag & 1;
  d.tag >>>= 1;

  return bit;
}

/* read a num bit value from a stream and add base */
function tinf_read_bits(d, num, base) {
  if (!num)
    return base;

  while (d.bitcount < 24) {
    d.tag |= d.source[d.sourceIndex++] << d.bitcount;
    d.bitcount += 8;
  }

  var val = d.tag & (0xffff >>> (16 - num));
  d.tag >>>= num;
  d.bitcount -= num;
  return val + base;
}

/* given a data stream and a tree, decode a symbol */
function tinf_decode_symbol(d, t) {
  while (d.bitcount < 24) {
    d.tag |= d.source[d.sourceIndex++] << d.bitcount;
    d.bitcount += 8;
  }
  
  var sum = 0, cur = 0, len = 0;
  var tag = d.tag;

  /* get more bits while code value is above sum */
  do {
    cur = 2 * cur + (tag & 1);
    tag >>>= 1;
    ++len;

    sum += t.table[len];
    cur -= t.table[len];
  } while (cur >= 0);
  
  d.tag = tag;
  d.bitcount -= len;

  return t.trans[sum + cur];
}

/* given a data stream, decode dynamic trees from it */
function tinf_decode_trees(d, lt, dt) {
  var hlit, hdist, hclen;
  var i, num, length;

  /* get 5 bits HLIT (257-286) */
  hlit = tinf_read_bits(d, 5, 257);

  /* get 5 bits HDIST (1-32) */
  hdist = tinf_read_bits(d, 5, 1);

  /* get 4 bits HCLEN (4-19) */
  hclen = tinf_read_bits(d, 4, 4);

  for (i = 0; i < 19; ++i) lengths[i] = 0;

  /* read code lengths for code length alphabet */
  for (i = 0; i < hclen; ++i) {
    /* get 3 bits code length (0-7) */
    var clen = tinf_read_bits(d, 3, 0);
    lengths[clcidx[i]] = clen;
  }

  /* build code length tree */
  tinf_build_tree(code_tree, lengths, 0, 19);

  /* decode code lengths for the dynamic trees */
  for (num = 0; num < hlit + hdist;) {
    var sym = tinf_decode_symbol(d, code_tree);

    switch (sym) {
      case 16:
        /* copy previous code length 3-6 times (read 2 bits) */
        var prev = lengths[num - 1];
        for (length = tinf_read_bits(d, 2, 3); length; --length) {
          lengths[num++] = prev;
        }
        break;
      case 17:
        /* repeat code length 0 for 3-10 times (read 3 bits) */
        for (length = tinf_read_bits(d, 3, 3); length; --length) {
          lengths[num++] = 0;
        }
        break;
      case 18:
        /* repeat code length 0 for 11-138 times (read 7 bits) */
        for (length = tinf_read_bits(d, 7, 11); length; --length) {
          lengths[num++] = 0;
        }
        break;
      default:
        /* values 0-15 represent the actual code lengths */
        lengths[num++] = sym;
        break;
    }
  }

  /* build dynamic trees */
  tinf_build_tree(lt, lengths, 0, hlit);
  tinf_build_tree(dt, lengths, hlit, hdist);
}

/* ----------------------------- *
 * -- block inflate functions -- *
 * ----------------------------- */

/* given a stream and two trees, inflate a block of data */
function tinf_inflate_block_data(d, lt, dt) {
  while (1) {
    var sym = tinf_decode_symbol(d, lt);

    /* check for end of block */
    if (sym === 256) {
      return TINF_OK;
    }

    if (sym < 256) {
      d.dest[d.destLen++] = sym;
    } else {
      var length, dist, offs;
      var i;

      sym -= 257;

      /* possibly get more bits from length code */
      length = tinf_read_bits(d, length_bits[sym], length_base[sym]);

      dist = tinf_decode_symbol(d, dt);

      /* possibly get more bits from distance code */
      offs = d.destLen - tinf_read_bits(d, dist_bits[dist], dist_base[dist]);

      /* copy match */
      for (i = offs; i < offs + length; ++i) {
        d.dest[d.destLen++] = d.dest[i];
      }
    }
  }
}

/* inflate an uncompressed block of data */
function tinf_inflate_uncompressed_block(d) {
  var length, invlength;
  var i;
  
  /* unread from bitbuffer */
  while (d.bitcount > 8) {
    d.sourceIndex--;
    d.bitcount -= 8;
  }

  /* get length */
  length = d.source[d.sourceIndex + 1];
  length = 256 * length + d.source[d.sourceIndex];

  /* get one's complement of length */
  invlength = d.source[d.sourceIndex + 3];
  invlength = 256 * invlength + d.source[d.sourceIndex + 2];

  /* check length */
  if (length !== (~invlength & 0x0000ffff))
    return TINF_DATA_ERROR;

  d.sourceIndex += 4;

  /* copy block */
  for (i = length; i; --i)
    d.dest[d.destLen++] = d.source[d.sourceIndex++];

  /* make sure we start next block on a byte boundary */
  d.bitcount = 0;

  return TINF_OK;
}

/* inflate stream from source to dest */
function tinf_uncompress(source, dest) {
  var d = new Data(source, dest);
  var bfinal, btype, res;

  do {
    /* read final block flag */
    bfinal = tinf_getbit(d);

    /* read block type (2 bits) */
    btype = tinf_read_bits(d, 2, 0);

    /* decompress block */
    switch (btype) {
      case 0:
        /* decompress uncompressed block */
        res = tinf_inflate_uncompressed_block(d);
        break;
      case 1:
        /* decompress block with fixed huffman trees */
        res = tinf_inflate_block_data(d, sltree, sdtree);
        break;
      case 2:
        /* decompress block with dynamic huffman trees */
        tinf_decode_trees(d, d.ltree, d.dtree);
        res = tinf_inflate_block_data(d, d.ltree, d.dtree);
        break;
      default:
        res = TINF_DATA_ERROR;
    }

    if (res !== TINF_OK)
      throw new Error('Data error');

  } while (!bfinal);

  if (d.destLen < d.dest.length) {
    if (typeof d.dest.slice === 'function')
      return d.dest.slice(0, d.destLen);
    else
      return d.dest.subarray(0, d.destLen);
  }
  
  return d.dest;
}

/* -------------------- *
 * -- initialization -- *
 * -------------------- */

/* build fixed huffman trees */
tinf_build_fixed_trees(sltree, sdtree);

/* build extra bits and base tables */
tinf_build_bits_base(length_bits, length_base, 4, 3);
tinf_build_bits_base(dist_bits, dist_base, 2, 1);

/* fix a special case */
length_bits[28] = 0;
length_base[28] = 258;

module.exports = tinf_uncompress;


/***/ }),

/***/ 821:
/***/ ((module) => {

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global global, define, System, Reflect, Promise */
var __extends;
var __assign;
var __rest;
var __decorate;
var __param;
var __esDecorate;
var __runInitializers;
var __propKey;
var __setFunctionName;
var __metadata;
var __awaiter;
var __generator;
var __exportStar;
var __values;
var __read;
var __spread;
var __spreadArrays;
var __spreadArray;
var __await;
var __asyncGenerator;
var __asyncDelegator;
var __asyncValues;
var __makeTemplateObject;
var __importStar;
var __importDefault;
var __classPrivateFieldGet;
var __classPrivateFieldSet;
var __classPrivateFieldIn;
var __createBinding;
(function (factory) {
    var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
    if (typeof define === "function" && define.amd) {
        define("tslib", ["exports"], function (exports) { factory(createExporter(root, createExporter(exports))); });
    }
    else if ( true && typeof module.exports === "object") {
        factory(createExporter(root, createExporter(module.exports)));
    }
    else {
        factory(createExporter(root));
    }
    function createExporter(exports, previous) {
        if (exports !== root) {
            if (typeof Object.create === "function") {
                Object.defineProperty(exports, "__esModule", { value: true });
            }
            else {
                exports.__esModule = true;
            }
        }
        return function (id, v) { return exports[id] = previous ? previous(id, v) : v; };
    }
})
(function (exporter) {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };

    __extends = function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };

    __assign = Object.assign || function (t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };

    __rest = function (s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    };

    __decorate = function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };

    __param = function (paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); }
    };

    __esDecorate = function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
        function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
        var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
        var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
        var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
        var _, done = false;
        for (var i = decorators.length - 1; i >= 0; i--) {
            var context = {};
            for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
            for (var p in contextIn.access) context.access[p] = contextIn.access[p];
            context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
            var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
            if (kind === "accessor") {
                if (result === void 0) continue;
                if (result === null || typeof result !== "object") throw new TypeError("Object expected");
                if (_ = accept(result.get)) descriptor.get = _;
                if (_ = accept(result.set)) descriptor.set = _;
                if (_ = accept(result.init)) initializers.unshift(_);
            }
            else if (_ = accept(result)) {
                if (kind === "field") initializers.unshift(_);
                else descriptor[key] = _;
            }
        }
        if (target) Object.defineProperty(target, contextIn.name, descriptor);
        done = true;
    };

    __runInitializers = function (thisArg, initializers, value) {
        var useValue = arguments.length > 2;
        for (var i = 0; i < initializers.length; i++) {
            value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
        }
        return useValue ? value : void 0;
    };

    __propKey = function (x) {
        return typeof x === "symbol" ? x : "".concat(x);
    };

    __setFunctionName = function (f, name, prefix) {
        if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
        return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
    };

    __metadata = function (metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
    };

    __awaiter = function (thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    };

    __generator = function (thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (g && (g = 0, op[0] && (_ = 0)), _) try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    };

    __exportStar = function(m, o) {
        for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
    };

    __createBinding = Object.create ? (function(o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function() { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        o[k2] = m[k];
    });

    __values = function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };

    __read = function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    };

    /** @deprecated */
    __spread = function () {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    };

    /** @deprecated */
    __spreadArrays = function () {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };

    __spreadArray = function (to, from, pack) {
        if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
                if (!ar) ar = Array.prototype.slice.call(from, 0, i);
                ar[i] = from[i];
            }
        }
        return to.concat(ar || Array.prototype.slice.call(from));
    };

    __await = function (v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    };

    __asyncGenerator = function (thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);  }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
    };

    __asyncDelegator = function (o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
    };

    __asyncValues = function (o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
    };

    __makeTemplateObject = function (cooked, raw) {
        if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
        return cooked;
    };

    var __setModuleDefault = Object.create ? (function(o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
        o["default"] = v;
    };

    __importStar = function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };

    __importDefault = function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };

    __classPrivateFieldGet = function (receiver, state, kind, f) {
        if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    };

    __classPrivateFieldSet = function (receiver, state, value, kind, f) {
        if (kind === "m") throw new TypeError("Private method is not writable");
        if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    };

    __classPrivateFieldIn = function (state, receiver) {
        if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
        return typeof state === "function" ? receiver === state : state.has(receiver);
    };

    exporter("__extends", __extends);
    exporter("__assign", __assign);
    exporter("__rest", __rest);
    exporter("__decorate", __decorate);
    exporter("__param", __param);
    exporter("__esDecorate", __esDecorate);
    exporter("__runInitializers", __runInitializers);
    exporter("__propKey", __propKey);
    exporter("__setFunctionName", __setFunctionName);
    exporter("__metadata", __metadata);
    exporter("__awaiter", __awaiter);
    exporter("__generator", __generator);
    exporter("__exportStar", __exportStar);
    exporter("__createBinding", __createBinding);
    exporter("__values", __values);
    exporter("__read", __read);
    exporter("__spread", __spread);
    exporter("__spreadArrays", __spreadArrays);
    exporter("__spreadArray", __spreadArray);
    exporter("__await", __await);
    exporter("__asyncGenerator", __asyncGenerator);
    exporter("__asyncDelegator", __asyncDelegator);
    exporter("__asyncValues", __asyncValues);
    exporter("__makeTemplateObject", __makeTemplateObject);
    exporter("__importStar", __importStar);
    exporter("__importDefault", __importDefault);
    exporter("__classPrivateFieldGet", __classPrivateFieldGet);
    exporter("__classPrivateFieldSet", __classPrivateFieldSet);
    exporter("__classPrivateFieldIn", __classPrivateFieldIn);
});


/***/ }),

/***/ 177:
/***/ ((module, __unused_webpack_exports, __nccwpck_require__) => {

const inflate = __nccwpck_require__(151);
const { swap32LE } = __nccwpck_require__(140);

// Shift size for getting the index-1 table offset.
const SHIFT_1 = 6 + 5;

// Shift size for getting the index-2 table offset.
const SHIFT_2 = 5;

// Difference between the two shift sizes,
// for getting an index-1 offset from an index-2 offset. 6=11-5
const SHIFT_1_2 = SHIFT_1 - SHIFT_2;

// Number of index-1 entries for the BMP. 32=0x20
// This part of the index-1 table is omitted from the serialized form.
const OMITTED_BMP_INDEX_1_LENGTH = 0x10000 >> SHIFT_1;

// Number of entries in an index-2 block. 64=0x40
const INDEX_2_BLOCK_LENGTH = 1 << SHIFT_1_2;

// Mask for getting the lower bits for the in-index-2-block offset. */
const INDEX_2_MASK = INDEX_2_BLOCK_LENGTH - 1;

// Shift size for shifting left the index array values.
// Increases possible data size with 16-bit index values at the cost
// of compactability.
// This requires data blocks to be aligned by DATA_GRANULARITY.
const INDEX_SHIFT = 2;

// Number of entries in a data block. 32=0x20
const DATA_BLOCK_LENGTH = 1 << SHIFT_2;

// Mask for getting the lower bits for the in-data-block offset.
const DATA_MASK = DATA_BLOCK_LENGTH - 1;

// The part of the index-2 table for U+D800..U+DBFF stores values for
// lead surrogate code _units_ not code _points_.
// Values for lead surrogate code _points_ are indexed with this portion of the table.
// Length=32=0x20=0x400>>SHIFT_2. (There are 1024=0x400 lead surrogates.)
const LSCP_INDEX_2_OFFSET = 0x10000 >> SHIFT_2;
const LSCP_INDEX_2_LENGTH = 0x400 >> SHIFT_2;

// Count the lengths of both BMP pieces. 2080=0x820
const INDEX_2_BMP_LENGTH = LSCP_INDEX_2_OFFSET + LSCP_INDEX_2_LENGTH;

// The 2-byte UTF-8 version of the index-2 table follows at offset 2080=0x820.
// Length 32=0x20 for lead bytes C0..DF, regardless of SHIFT_2.
const UTF8_2B_INDEX_2_OFFSET = INDEX_2_BMP_LENGTH;
const UTF8_2B_INDEX_2_LENGTH = 0x800 >> 6;  // U+0800 is the first code point after 2-byte UTF-8

// The index-1 table, only used for supplementary code points, at offset 2112=0x840.
// Variable length, for code points up to highStart, where the last single-value range starts.
// Maximum length 512=0x200=0x100000>>SHIFT_1.
// (For 0x100000 supplementary code points U+10000..U+10ffff.)
//
// The part of the index-2 table for supplementary code points starts
// after this index-1 table.
//
// Both the index-1 table and the following part of the index-2 table
// are omitted completely if there is only BMP data.
const INDEX_1_OFFSET = UTF8_2B_INDEX_2_OFFSET + UTF8_2B_INDEX_2_LENGTH;

// The alignment size of a data block. Also the granularity for compaction.
const DATA_GRANULARITY = 1 << INDEX_SHIFT;

class UnicodeTrie {
  constructor(data) {
    const isBuffer = (typeof data.readUInt32BE === 'function') && (typeof data.slice === 'function');

    if (isBuffer || data instanceof Uint8Array) {
      // read binary format
      let uncompressedLength;
      if (isBuffer) {
        this.highStart = data.readUInt32LE(0);
        this.errorValue = data.readUInt32LE(4);
        uncompressedLength = data.readUInt32LE(8);
        data = data.slice(12);
      } else {
        const view = new DataView(data.buffer);
        this.highStart = view.getUint32(0, true);
        this.errorValue = view.getUint32(4, true);
        uncompressedLength = view.getUint32(8, true);
        data = data.subarray(12);
      }

      // double inflate the actual trie data
      data = inflate(data, new Uint8Array(uncompressedLength));
      data = inflate(data, new Uint8Array(uncompressedLength));

      // swap bytes from little-endian
      swap32LE(data);

      this.data = new Uint32Array(data.buffer);

    } else {
      // pre-parsed data
      ({ data: this.data, highStart: this.highStart, errorValue: this.errorValue } = data);
    }
  }

  get(codePoint) {
    let index;
    if ((codePoint < 0) || (codePoint > 0x10ffff)) {
      return this.errorValue;
    }

    if ((codePoint < 0xd800) || ((codePoint > 0xdbff) && (codePoint <= 0xffff))) {
      // Ordinary BMP code point, excluding leading surrogates.
      // BMP uses a single level lookup.  BMP index starts at offset 0 in the index.
      // data is stored in the index array itself.
      index = (this.data[codePoint >> SHIFT_2] << INDEX_SHIFT) + (codePoint & DATA_MASK);
      return this.data[index];
    }

    if (codePoint <= 0xffff) {
      // Lead Surrogate Code Point.  A Separate index section is stored for
      // lead surrogate code units and code points.
      //   The main index has the code unit data.
      //   For this function, we need the code point data.
      index = (this.data[LSCP_INDEX_2_OFFSET + ((codePoint - 0xd800) >> SHIFT_2)] << INDEX_SHIFT) + (codePoint & DATA_MASK);
      return this.data[index];
    }

    if (codePoint < this.highStart) {
      // Supplemental code point, use two-level lookup.
      index = this.data[(INDEX_1_OFFSET - OMITTED_BMP_INDEX_1_LENGTH) + (codePoint >> SHIFT_1)];
      index = this.data[index + ((codePoint >> SHIFT_2) & INDEX_2_MASK)];
      index = (index << INDEX_SHIFT) + (codePoint & DATA_MASK);
      return this.data[index];
    }

    return this.data[this.data.length - DATA_GRANULARITY];
  }
}

module.exports = UnicodeTrie;

/***/ }),

/***/ 140:
/***/ ((module) => {

const isBigEndian = (new Uint8Array(new Uint32Array([0x12345678]).buffer)[0] === 0x12);

const swap = (b, n, m) => {
  let i = b[n];
  b[n] = b[m];
  b[m] = i;
};

const swap32 = array => {
  const len = array.length;
  for (let i = 0; i < len; i += 4) {
    swap(array, i, i + 3);
    swap(array, i + 1, i + 2);
  }
};

const swap32LE = array => {
  if (isBigEndian) {
    swap32(array);
  }
};

module.exports = {
  swap32LE: swap32LE
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __nccwpck_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		var threw = true;
/******/ 		try {
/******/ 			__webpack_modules__[moduleId](module, module.exports, __nccwpck_require__);
/******/ 			threw = false;
/******/ 		} finally {
/******/ 			if(threw) delete __webpack_module_cache__[moduleId];
/******/ 		}
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__nccwpck_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__nccwpck_require__.o(definition, key) && !__nccwpck_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__nccwpck_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__nccwpck_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat */
/******/ 	
/******/ 	if (typeof __nccwpck_require__ !== 'undefined') __nccwpck_require__.ab = __dirname + "/";
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
// ESM COMPAT FLAG
__nccwpck_require__.r(__webpack_exports__);

// EXPORTS
__nccwpck_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ fontkit)
});

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/DecodeStream.js
// Node back-compat.
const ENCODING_MAPPING = {
  utf16le: 'utf-16le',
  ucs2: 'utf-16le',
  utf16be: 'utf-16be'
}

class DecodeStream {
  constructor(buffer) {
    this.buffer = buffer;
    this.view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    this.pos = 0;
    this.length = this.buffer.length;
  }

  readString(length, encoding = 'ascii') {
    encoding = ENCODING_MAPPING[encoding] || encoding;

    let buf = this.readBuffer(length);
    try {
      let decoder = new TextDecoder(encoding);
      return decoder.decode(buf);
    } catch (err) {
      return buf;
    }
  }

  readBuffer(length) {
    return this.buffer.slice(this.pos, (this.pos += length));
  }

  readUInt24BE() {
    return (this.readUInt16BE() << 8) + this.readUInt8();
  }

  readUInt24LE() {
    return this.readUInt16LE() + (this.readUInt8() << 16);
  }

  readInt24BE() {
    return (this.readInt16BE() << 8) + this.readUInt8();
  }

  readInt24LE() {
    return this.readUInt16LE() + (this.readInt8() << 16);
  }
}

DecodeStream.TYPES = {
  UInt8: 1,
  UInt16: 2,
  UInt24: 3,
  UInt32: 4,
  Int8: 1,
  Int16: 2,
  Int24: 3,
  Int32: 4,
  Float: 4,
  Double: 8
};

for (let key of Object.getOwnPropertyNames(DataView.prototype)) {
  if (key.slice(0, 3) === 'get') {
    let type = key.slice(3).replace('Ui', 'UI');
    if (type === 'Float32') {
      type = 'Float';
    } else if (type === 'Float64') {
      type = 'Double';
    }
    let bytes = DecodeStream.TYPES[type];
    DecodeStream.prototype['read' + type + (bytes === 1 ? '' : 'BE')] = function () {
      const ret = this.view[key](this.pos, false);
      this.pos += bytes;
      return ret;
    };

    if (bytes !== 1) {
      DecodeStream.prototype['read' + type + 'LE'] = function () {
        const ret = this.view[key](this.pos, true);
        this.pos += bytes;
        return ret;
      };
    }
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/EncodeStream.js


const textEncoder = new TextEncoder();
const isBigEndian = new Uint8Array(new Uint16Array([0x1234]).buffer)[0] == 0x12;

class EncodeStream {
  constructor(buffer) {
    this.buffer = buffer;
    this.view = new DataView(this.buffer.buffer, this.buffer.byteOffset, this.buffer.byteLength);
    this.pos = 0;
  }

  writeBuffer(buffer) {
    this.buffer.set(buffer, this.pos);
    this.pos += buffer.length;
  }

  writeString(string, encoding = 'ascii') {
    let buf;
    switch (encoding) {
      case 'utf16le':
      case 'utf16-le':
      case 'ucs2': // node treats this the same as utf16.
        buf = stringToUtf16(string, isBigEndian);
        break;

      case 'utf16be':
      case 'utf16-be':
        buf = stringToUtf16(string, !isBigEndian);
        break;

      case 'utf8':
        buf = textEncoder.encode(string);
        break;

      case 'ascii':
        buf = stringToAscii(string);
        break;

      default:
        throw new Error(`Unsupported encoding: ${encoding}`);
    }

    this.writeBuffer(buf);
  }

  writeUInt24BE(val) {
    this.buffer[this.pos++] = (val >>> 16) & 0xff;
    this.buffer[this.pos++] = (val >>> 8) & 0xff;
    this.buffer[this.pos++] = val & 0xff;
  }

  writeUInt24LE(val) {
    this.buffer[this.pos++] = val & 0xff;
    this.buffer[this.pos++] = (val >>> 8) & 0xff;
    this.buffer[this.pos++] = (val >>> 16) & 0xff;
  }

  writeInt24BE(val) {
    if (val >= 0) {
      this.writeUInt24BE(val);
    } else {
      this.writeUInt24BE(val + 0xffffff + 1);
    }
  }

  writeInt24LE(val) {
    if (val >= 0) {
      this.writeUInt24LE(val);
    } else {
      this.writeUInt24LE(val + 0xffffff + 1);
    }
  }

  fill(val, length) {
    if (length < this.buffer.length) {
      this.buffer.fill(val, this.pos, this.pos + length);
      this.pos += length;
    } else {
      const buf = new Uint8Array(length);
      buf.fill(val);
      this.writeBuffer(buf);
    }
  }
}

function stringToUtf16(string, swap) {
  let buf = new Uint16Array(string.length);
  for (let i = 0; i < string.length; i++) {
    let code = string.charCodeAt(i);
    if (swap) {
      code = (code >> 8) | ((code & 0xff) << 8);
    }
    buf[i] = code;
  }
  return new Uint8Array(buf.buffer);
}

function stringToAscii(string) {
  let buf = new Uint8Array(string.length);
  for (let i = 0; i < string.length; i++) {
    // Match node.js behavior - encoding allows 8-bit rather than 7-bit.
    buf[i] = string.charCodeAt(i);
  }
  return buf;
}

for (let key of Object.getOwnPropertyNames(DataView.prototype)) {
  if (key.slice(0, 3) === 'set') {
    let type = key.slice(3).replace('Ui', 'UI');
    if (type === 'Float32') {
      type = 'Float';
    } else if (type === 'Float64') {
      type = 'Double';
    }
    let bytes = DecodeStream.TYPES[type];
    EncodeStream.prototype['write' + type + (bytes === 1 ? '' : 'BE')] = function (value) {
      this.view[key](this.pos, value, false);
      this.pos += bytes;
    };

    if (bytes !== 1) {
      EncodeStream.prototype['write' + type + 'LE'] = function (value) {
        this.view[key](this.pos, value, true);
        this.pos += bytes;
      };
    }
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Base.js



class Base_Base {
  fromBuffer(buffer) {
    let stream = new DecodeStream(buffer);
    return this.decode(stream);
  }

  toBuffer(value) {
    let size = this.size(value);
    let buffer = new Uint8Array(size);
    let stream = new EncodeStream(buffer);
    this.encode(stream, value);
    return buffer;
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Number.js



class NumberT extends Base_Base {
  constructor(type, endian = 'BE') {
    super();
    this.type = type;
    this.endian = endian;
    this.fn = this.type;
    if (this.type[this.type.length - 1] !== '8') {
      this.fn += this.endian;
    }
  }

  size() {
    return DecodeStream.TYPES[this.type];
  }

  decode(stream) {
    return stream[`read${this.fn}`]();
  }

  encode(stream, val) {
    return stream[`write${this.fn}`](val);
  }
}



const uint8 = new NumberT('UInt8');
const uint16be = new NumberT('UInt16', 'BE');
const uint16 = uint16be;
const uint16le = new NumberT('UInt16', 'LE');
const uint24be = new NumberT('UInt24', 'BE');
const uint24 = uint24be;
const uint24le = new NumberT('UInt24', 'LE');
const uint32be = new NumberT('UInt32', 'BE');
const uint32 = uint32be;
const uint32le = new NumberT('UInt32', 'LE');
const int8 = new NumberT('Int8');
const int16be = new NumberT('Int16', 'BE');
const int16 = int16be;
const int16le = new NumberT('Int16', 'LE');
const int24be = new NumberT('Int24', 'BE');
const int24 = (/* unused pure expression or super */ null && (int24be));
const int24le = new NumberT('Int24', 'LE');
const int32be = new NumberT('Int32', 'BE');
const int32 = int32be;
const int32le = new NumberT('Int32', 'LE');
const floatbe = new NumberT('Float', 'BE');
const Number_float = (/* unused pure expression or super */ null && (floatbe));
const floatle = new NumberT('Float', 'LE');
const doublebe = new NumberT('Double', 'BE');
const Number_double = (/* unused pure expression or super */ null && (doublebe));
const doublele = new NumberT('Double', 'LE');

class Fixed extends NumberT {
  constructor(size, endian, fracBits = size >> 1) {
    super(`Int${size}`, endian);
    this._point = 1 << fracBits;
  }

  decode(stream) {
    return super.decode(stream) / this._point;
  }

  encode(stream, val) {
    return super.encode(stream, (val * this._point) | 0);
  }
}

const fixed16be = new Fixed(16, 'BE');
const fixed16 = fixed16be;
const fixed16le = new Fixed(16, 'LE');
const fixed32be = new Fixed(32, 'BE');
const fixed32 = fixed32be;
const fixed32le = new Fixed(32, 'LE');

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/utils.js


function resolveLength(length, stream, parent) {
  let res;
  if (typeof length === 'number') {
    res = length;

  } else if (typeof length === 'function') {
    res = length.call(parent, parent);

  } else if (parent && (typeof length === 'string')) {
    res = parent[length];

  } else if (stream && length instanceof NumberT) {
    res = length.decode(stream);
  }

  if (isNaN(res)) {
    throw new Error('Not a fixed size');
  }

  return res;
};

class PropertyDescriptor {
  constructor(opts = {}) {
    this.enumerable = true;
    this.configurable = true;

    for (let key in opts) {
      const val = opts[key];
      this[key] = val;
    }
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Array.js




class ArrayT extends Base_Base {
  constructor(type, length, lengthType = 'count') {
    super();
    this.type = type;
    this.length = length;
    this.lengthType = lengthType;
  }

  decode(stream, parent) {
    let length;
    const { pos } = stream;

    const res = [];
    let ctx = parent;

    if (this.length != null) {
      length = resolveLength(this.length, stream, parent);
    }

    if (this.length instanceof NumberT) {
      // define hidden properties
      Object.defineProperties(res, {
        parent:         { value: parent },
        _startOffset:   { value: pos },
        _currentOffset: { value: 0, writable: true },
        _length:        { value: length }
      });

      ctx = res;
    }

    if ((length == null) || (this.lengthType === 'bytes')) {
      const target = (length != null) ?
        stream.pos + length
      : (parent != null ? parent._length : undefined) ?
        parent._startOffset + parent._length
      :
        stream.length;

      while (stream.pos < target) {
        res.push(this.type.decode(stream, ctx));
      }

    } else {
      for (let i = 0, end = length; i < end; i++) {
        res.push(this.type.decode(stream, ctx));
      }
    }

    return res;
  }

  size(array, ctx, includePointers = true) {
    if (!array) {
      return this.type.size(null, ctx) * resolveLength(this.length, null, ctx);
    }

    let size = 0;
    if (this.length instanceof NumberT) {
      size += this.length.size();
      ctx = {parent: ctx, pointerSize: 0};
    }

    for (let item of array) {
      size += this.type.size(item, ctx);
    }

    if (ctx && includePointers && this.length instanceof NumberT) {
      size += ctx.pointerSize;
    }
    
    return size;
  }

  encode(stream, array, parent) {
    let ctx = parent;
    if (this.length instanceof NumberT) {
      ctx = {
        pointers: [],
        startOffset: stream.pos,
        parent
      };

      ctx.pointerOffset = stream.pos + this.size(array, ctx, false);
      this.length.encode(stream, array.length);
    }

    for (let item of array) {
      this.type.encode(stream, item, ctx);
    }

    if (this.length instanceof NumberT) {
      let i = 0;
      while (i < ctx.pointers.length) {
        const ptr = ctx.pointers[i++];
        ptr.type.encode(stream, ptr.val, ptr.parent);
      }
    }
  }
}



;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/LazyArray.js




class LazyArray extends ArrayT {
  decode(stream, parent) {
    const { pos } = stream;
    const length = resolveLength(this.length, stream, parent);

    if (this.length instanceof NumberT) {
      parent = {
        parent,
        _startOffset: pos,
        _currentOffset: 0,
        _length: length
      };
    }

    const res = new LazyArrayValue(this.type, length, stream, parent);

    stream.pos += length * this.type.size(null, parent);
    return res;
  }

  size(val, ctx) {
    if (val instanceof LazyArrayValue) {
      val = val.toArray();
    }

    return super.size(val, ctx);
  }

  encode(stream, val, ctx) {
    if (val instanceof LazyArrayValue) {
      val = val.toArray();
    }

    return super.encode(stream, val, ctx);
  }
}

class LazyArrayValue {
  constructor(type, length, stream, ctx) {
    this.type = type;
    this.length = length;
    this.stream = stream;
    this.ctx = ctx;
    this.base = this.stream.pos;
    this.items = [];
  }

  get(index) {
    if ((index < 0) || (index >= this.length)) {
      return undefined;
    }

    if (this.items[index] == null) {
      const { pos } = this.stream;
      this.stream.pos = this.base + (this.type.size(null, this.ctx) * index);
      this.items[index] = this.type.decode(this.stream, this.ctx);
      this.stream.pos = pos;
    }

    return this.items[index];
  }

  toArray() {
    const result = [];
    for (let i = 0, end = this.length; i < end; i++) {
      result.push(this.get(i));
    }
    return result;
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Bitfield.js


class Bitfield extends Base_Base {
  constructor(type, flags = []) {
    super();
    this.type = type;
    this.flags = flags;
  }

  decode(stream) {
    const val = this.type.decode(stream);

    const res = {};
    for (let i = 0; i < this.flags.length; i++) {
      const flag = this.flags[i];
      if (flag != null) {
        res[flag] = !!(val & (1 << i));
      }
    }

    return res;
  }

  size() {
    return this.type.size();
  }

  encode(stream, keys) {
    let val = 0;
    for (let i = 0; i < this.flags.length; i++) {
      const flag = this.flags[i];
      if (flag != null) {
        if (keys[flag]) { val |= (1 << i); }
      }
    }

    return this.type.encode(stream, val);
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Boolean.js


class BooleanT extends (/* unused pure expression or super */ null && (Base)) {
  constructor(type) {
    super();
    this.type = type;
  }

  decode(stream, parent) {
    return !!this.type.decode(stream, parent);
  }

  size(val, parent) {
    return this.type.size(val, parent);
  }

  encode(stream, val, parent) {
    return this.type.encode(stream, +val, parent);
  }
}



;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Buffer.js




class BufferT extends Base_Base {
  constructor(length) {
    super();
    this.length = length;
  }
  
  decode(stream, parent) {
    const length = resolveLength(this.length, stream, parent);
    return stream.readBuffer(length);
  }

  size(val, parent) {
    if (!val) {
      return resolveLength(this.length, null, parent);
    }

    let len = val.length;
    if (this.length instanceof NumberT) {
      len += this.length.size();
    }

    return len;
  }

  encode(stream, buf, parent) {
    if (this.length instanceof NumberT) {
      this.length.encode(stream, buf.length);
    }

    return stream.writeBuffer(buf);
  }
}



;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Enum.js


class Enum extends (/* unused pure expression or super */ null && (Base)) {
  constructor(type, options = []) {
    super();
    this.type = type;
    this.options = options;
  }
  
  decode(stream) {
    const index = this.type.decode(stream);
    return this.options[index] || index;
  }

  size() {
    return this.type.size();
  }

  encode(stream, val) {
    const index = this.options.indexOf(val);
    if (index === -1) {
      throw new Error(`Unknown option in enum: ${val}`);
    }

    return this.type.encode(stream, index);
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Optional.js


class Optional extends Base_Base {
  constructor(type, condition = true) {
    super();
    this.type = type;
    this.condition = condition;
  }

  decode(stream, parent) {
    let { condition } = this;
    if (typeof condition === 'function') {
      condition = condition.call(parent, parent);
    }

    if (condition) {
      return this.type.decode(stream, parent);
    }
  }

  size(val, parent) {
    let { condition } = this;
    if (typeof condition === 'function') {
      condition = condition.call(parent, parent);
    }

    if (condition) {
      return this.type.size(val, parent);
    } else {
      return 0;
    }
  }

  encode(stream, val, parent) {
    let { condition } = this;
    if (typeof condition === 'function') {
      condition = condition.call(parent, parent);
    }

    if (condition) {
      return this.type.encode(stream, val, parent);
    }
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Reserved.js



class Reserved extends Base_Base {
  constructor(type, count = 1) {
    super();
    this.type = type;
    this.count = count;
  }
  decode(stream, parent) {
    stream.pos += this.size(null, parent);
    return undefined;
  }

  size(data, parent) {
    const count = resolveLength(this.count, null, parent);
    return this.type.size() * count;
  }

  encode(stream, val, parent) {
    return stream.fill(0, this.size(val, parent));
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/String.js




class StringT extends Base_Base {
  constructor(length, encoding = 'ascii') {
    super();
    this.length = length;
    this.encoding = encoding;
  }

  decode(stream, parent) {
    let length, pos;

    if (this.length != null) {
      length = resolveLength(this.length, stream, parent);
    } else {
      let buffer;
      ({buffer, length, pos} = stream);

      while ((pos < length) && (buffer[pos] !== 0x00)) {
        ++pos;
      }

      length = pos - stream.pos;
    }

    let { encoding } = this;
    if (typeof encoding === 'function') {
      encoding = encoding.call(parent, parent) || 'ascii';
    }

    const string = stream.readString(length, encoding);

    if ((this.length == null) && (stream.pos < stream.length)) {
      stream.pos++;
    }

    return string;
  }

  size(val, parent) {
    // Use the defined value if no value was given
    if (!val) {
      return resolveLength(this.length, null, parent);
    }

    let { encoding } = this;
    if (typeof encoding === 'function') {
      encoding = encoding.call(parent != null ? parent.val : undefined, parent != null ? parent.val : undefined) || 'ascii';
    }

    if (encoding === 'utf16be') {
      encoding = 'utf16le';
    }

    let size = byteLength(val, encoding);
    if (this.length instanceof NumberT) {
      size += this.length.size();
    }

    if ((this.length == null)) {
      size++;
    }

    return size;
  }

  encode(stream, val, parent) {
    let { encoding } = this;
    if (typeof encoding === 'function') {
      encoding = encoding.call(parent != null ? parent.val : undefined, parent != null ? parent.val : undefined) || 'ascii';
    }

    if (this.length instanceof NumberT) {
      this.length.encode(stream, byteLength(val, encoding));
    }

    stream.writeString(val, encoding);

    if ((this.length == null)) {
      return stream.writeUInt8(0x00);
    }
  }
}

function byteLength(string, encoding) {
  switch (encoding) {
    case 'ascii':
      return string.length;
    case 'utf8':
      let len = 0;
      for (let i = 0; i < string.length; i++) {
        let c = string.charCodeAt(i);

        if (c >= 0xd800 && c <= 0xdbff && i < string.length - 1) {
          let c2 = string.charCodeAt(++i);
          if ((c2 & 0xfc00) === 0xdc00) {
            c = ((c & 0x3ff) << 10) + (c2 & 0x3ff) + 0x10000;
          } else {
            // unmatched surrogate.
            i--;
          }
        }

        if ((c & 0xffffff80) === 0) {
          len++;
        } else if ((c & 0xfffff800) === 0) {
          len += 2;
        } else if ((c & 0xffff0000) === 0) {
          len += 3;
        } else if ((c & 0xffe00000) === 0) {
          len += 4;
        }
      }
      return len;
    case 'utf16le':
    case 'utf16-le':
    case 'utf16be':
    case 'utf16-be':
    case 'ucs2':
      return string.length * 2;
    default:
      throw new Error('Unknown encoding ' + encoding);
  }
}



;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Struct.js



class Struct extends Base_Base {
  constructor(fields = {}) {
    super();
    this.fields = fields;
  }

  decode(stream, parent, length = 0) {
    const res = this._setup(stream, parent, length);
    this._parseFields(stream, res, this.fields);

    if (this.process != null) {
      this.process.call(res, stream);
    }
    return res;
  }

  _setup(stream, parent, length) {
    const res = {};

    // define hidden properties
    Object.defineProperties(res, {
      parent:         { value: parent },
      _startOffset:   { value: stream.pos },
      _currentOffset: { value: 0, writable: true },
      _length:        { value: length }
    });

    return res;
  }

  _parseFields(stream, res, fields) {
    for (let key in fields) {
      var val;
      const type = fields[key];
      if (typeof type === 'function') {
        val = type.call(res, res);
      } else {
        val = type.decode(stream, res);
      }

      if (val !== undefined) {
        if (val instanceof PropertyDescriptor) {
          Object.defineProperty(res, key, val);
        } else {
          res[key] = val;
        }
      }

      res._currentOffset = stream.pos - res._startOffset;
    }

  }

  size(val, parent, includePointers = true) {
    if (val == null) { val = {}; }
    const ctx = {
      parent,
      val,
      pointerSize: 0
    };

    if (this.preEncode != null) {
      this.preEncode.call(val);
    }

    let size = 0;
    for (let key in this.fields) {
      const type = this.fields[key];
      if (type.size != null) {
        size += type.size(val[key], ctx);
      }
    }

    if (includePointers) {
      size += ctx.pointerSize;
    }

    return size;
  }

  encode(stream, val, parent) {
    let type;
    if (this.preEncode != null) {
      this.preEncode.call(val, stream);
    }

    const ctx = {
      pointers: [],
      startOffset: stream.pos,
      parent,
      val,
      pointerSize: 0
    };

    ctx.pointerOffset = stream.pos + this.size(val, ctx, false);

    for (let key in this.fields) {
      type = this.fields[key];
      if (type.encode != null) {
        type.encode(stream, val[key], ctx);
      }
    }

    let i = 0;
    while (i < ctx.pointers.length) {
      const ptr = ctx.pointers[i++];
      ptr.type.encode(stream, ptr.val, ptr.parent);
    }
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/VersionedStruct.js


const getPath = (object, pathArray) => {
  return pathArray.reduce((prevObj, key) => prevObj && prevObj[key], object);
};

class VersionedStruct extends Struct {
  constructor(type, versions = {}) {
    super();
    this.type = type;
    this.versions = versions;
    if (typeof type === 'string') {
      this.versionPath = type.split('.');
    }
  }

  decode(stream, parent, length = 0) {
    const res = this._setup(stream, parent, length);

    if (typeof this.type === 'string') {
      res.version = getPath(parent, this.versionPath);
    } else {
      res.version = this.type.decode(stream);
    }

    if (this.versions.header) {
      this._parseFields(stream, res, this.versions.header);
    }

    const fields = this.versions[res.version];
    if ((fields == null)) {
      throw new Error(`Unknown version ${res.version}`);
    }

    if (fields instanceof VersionedStruct) {
      return fields.decode(stream, parent);
    }

    this._parseFields(stream, res, fields);

    if (this.process != null) {
      this.process.call(res, stream);
    }
    return res;
  }

  size(val, parent, includePointers = true) {
    let key, type;
    if (!val) {
      throw new Error('Not a fixed size');
    }

    if (this.preEncode != null) {
      this.preEncode.call(val);
    }

    const ctx = {
      parent,
      val,
      pointerSize: 0
    };

    let size = 0;
    if (typeof this.type !== 'string') {
      size += this.type.size(val.version, ctx);
    }

    if (this.versions.header) {
      for (key in this.versions.header) {
        type = this.versions.header[key];
        if (type.size != null) {
          size += type.size(val[key], ctx);
        }
      }
    }

    const fields = this.versions[val.version];
    if ((fields == null)) {
      throw new Error(`Unknown version ${val.version}`);
    }

    for (key in fields) {
      type = fields[key];
      if (type.size != null) {
        size += type.size(val[key], ctx);
      }
    }

    if (includePointers) {
      size += ctx.pointerSize;
    }

    return size;
  }

  encode(stream, val, parent) {
    let key, type;
    if (this.preEncode != null) {
      this.preEncode.call(val, stream);
    }

    const ctx = {
      pointers: [],
      startOffset: stream.pos,
      parent,
      val,
      pointerSize: 0
    };

    ctx.pointerOffset = stream.pos + this.size(val, ctx, false);

    if (typeof this.type !== 'string') {
      this.type.encode(stream, val.version);
    }

    if (this.versions.header) {
      for (key in this.versions.header) {
        type = this.versions.header[key];
        if (type.encode != null) {
          type.encode(stream, val[key], ctx);
        }
      }
    }

    const fields = this.versions[val.version];
    for (key in fields) {
      type = fields[key];
      if (type.encode != null) {
        type.encode(stream, val[key], ctx);
      }
    }

    let i = 0;
    while (i < ctx.pointers.length) {
      const ptr = ctx.pointers[i++];
      ptr.type.encode(stream, ptr.val, ptr.parent);
    }
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/src/Pointer.js



class Pointer extends Base_Base {
  constructor(offsetType, type, options = {}) {
    super();
    this.offsetType = offsetType;
    this.type = type;
    this.options = options;
    if (this.type === 'void') { this.type = null; }
    if (this.options.type == null) { this.options.type = 'local'; }
    if (this.options.allowNull == null) { this.options.allowNull = true; }
    if (this.options.nullValue == null) { this.options.nullValue = 0; }
    if (this.options.lazy == null) { this.options.lazy = false; }
    if (this.options.relativeTo) {
      if (typeof this.options.relativeTo !== 'function') {
        throw new Error('relativeTo option must be a function');
      }
      this.relativeToGetter = options.relativeTo;
    }
  }

  decode(stream, ctx) {
    const offset = this.offsetType.decode(stream, ctx);

    // handle NULL pointers
    if ((offset === this.options.nullValue) && this.options.allowNull) {
      return null;
    }

    let relative;
    switch (this.options.type) {
      case 'local':     relative = ctx._startOffset; break;
      case 'immediate': relative = stream.pos - this.offsetType.size(); break;
      case 'parent':    relative = ctx.parent._startOffset; break;
      default:
        var c = ctx;
        while (c.parent) {
          c = c.parent;
        }

        relative = c._startOffset || 0;
    }

    if (this.options.relativeTo) {
      relative += this.relativeToGetter(ctx);
    }

    const ptr = offset + relative;

    if (this.type != null) {
      let val = null;
      const decodeValue = () => {
        if (val != null) { return val; }

        const { pos } = stream;
        stream.pos = ptr;
        val = this.type.decode(stream, ctx);
        stream.pos = pos;
        return val;
      };

      // If this is a lazy pointer, define a getter to decode only when needed.
      // This obviously only works when the pointer is contained by a Struct.
      if (this.options.lazy) {
        return new PropertyDescriptor({
          get: decodeValue});
      }

      return decodeValue();
    } else {
      return ptr;
    }
  }

  size(val, ctx) {
    const parent = ctx;
    switch (this.options.type) {
      case 'local': case 'immediate':
        break;
      case 'parent':
        ctx = ctx.parent;
        break;
      default: // global
        while (ctx.parent) {
          ctx = ctx.parent;
        }
    }

    let { type } = this;
    if (type == null) {
      if (!(val instanceof VoidPointer)) {
        throw new Error("Must be a VoidPointer");
      }

      ({ type } = val);
      val = val.value;
    }

    if (val && ctx) {
      // Must be written as two separate lines rather than += in case `type.size` mutates ctx.pointerSize.
      let size = type.size(val, parent);
      ctx.pointerSize += size;
    }

    return this.offsetType.size();
  }

  encode(stream, val, ctx) {
    let relative;
    const parent = ctx;
    if ((val == null)) {
      this.offsetType.encode(stream, this.options.nullValue);
      return;
    }

    switch (this.options.type) {
      case 'local':
        relative = ctx.startOffset;
        break;
      case 'immediate':
        relative = stream.pos + this.offsetType.size(val, parent);
        break;
      case 'parent':
        ctx = ctx.parent;
        relative = ctx.startOffset;
        break;
      default: // global
        relative = 0;
        while (ctx.parent) {
          ctx = ctx.parent;
        }
    }

    if (this.options.relativeTo) {
      relative += this.relativeToGetter(parent.val);
    }

    this.offsetType.encode(stream, ctx.pointerOffset - relative);

    let { type } = this;
    if (type == null) {
      if (!(val instanceof VoidPointer)) {
        throw new Error("Must be a VoidPointer");
      }

      ({ type } = val);
      val = val.value;
    }

    ctx.pointers.push({
      type,
      val,
      parent
    });

    return ctx.pointerOffset += type.size(val, parent);
  }
}

// A pointer whose type is determined at decode time
class VoidPointer {
  constructor(type, value) {
    this.type = type;
    this.value = value;
  }
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/restructure@3.0.0/node_modules/restructure/index.js


















;// CONCATENATED MODULE: external "fs"
const external_fs_namespaceObject = require("fs");
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@swc+helpers@0.4.14/node_modules/@swc/helpers/src/_define_property.mjs
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

// EXTERNAL MODULE: ../../node_modules/.pnpm/tslib@2.5.3/node_modules/tslib/tslib.js
var tslib_tslib = __nccwpck_require__(821);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/tslib@2.5.3/node_modules/tslib/modules/index.js

const {
    __extends,
    __assign,
    __rest,
    __decorate,
    __param,
    __esDecorate,
    __runInitializers,
    __propKey,
    __setFunctionName,
    __metadata,
    __awaiter,
    __generator,
    __exportStar,
    __createBinding,
    __values,
    __read,
    __spread,
    __spreadArrays,
    __spreadArray,
    __await,
    __asyncGenerator,
    __asyncDelegator,
    __asyncValues,
    __makeTemplateObject,
    __importStar,
    __importDefault,
    __classPrivateFieldGet,
    __classPrivateFieldSet,
    __classPrivateFieldIn,
} = tslib_tslib;

/* harmony default export */ const modules = ((/* unused pure expression or super */ null && (tslib)));

// EXTERNAL MODULE: ../../node_modules/.pnpm/fast-deep-equal@3.1.3/node_modules/fast-deep-equal/index.js
var fast_deep_equal = __nccwpck_require__(230);
// EXTERNAL MODULE: ../../node_modules/.pnpm/base64-js@1.5.1/node_modules/base64-js/index.js
var base64_js = __nccwpck_require__(675);
// EXTERNAL MODULE: ../../node_modules/.pnpm/unicode-trie@2.0.0/node_modules/unicode-trie/index.js
var unicode_trie = __nccwpck_require__(177);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/unicode-properties@1.4.1/node_modules/unicode-properties/dist/module.mjs



function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}


var $f4087201da764553$exports = {};
$f4087201da764553$exports = JSON.parse('{"categories":["Cc","Zs","Po","Sc","Ps","Pe","Sm","Pd","Nd","Lu","Sk","Pc","Ll","So","Lo","Pi","Cf","No","Pf","Lt","Lm","Mn","Me","Mc","Nl","Zl","Zp","Cs","Co"],"combiningClasses":["Not_Reordered","Above","Above_Right","Below","Attached_Above_Right","Attached_Below","Overlay","Iota_Subscript","Double_Below","Double_Above","Below_Right","Above_Left","CCC10","CCC11","CCC12","CCC13","CCC14","CCC15","CCC16","CCC17","CCC18","CCC19","CCC20","CCC21","CCC22","CCC23","CCC24","CCC25","CCC30","CCC31","CCC32","CCC27","CCC28","CCC29","CCC33","CCC34","CCC35","CCC36","Nukta","Virama","CCC84","CCC91","CCC103","CCC107","CCC118","CCC122","CCC129","CCC130","CCC132","Attached_Above","Below_Left","Left","Kana_Voicing","CCC26","Right"],"scripts":["Common","Latin","Bopomofo","Inherited","Greek","Coptic","Cyrillic","Armenian","Hebrew","Arabic","Syriac","Thaana","Nko","Samaritan","Mandaic","Devanagari","Bengali","Gurmukhi","Gujarati","Oriya","Tamil","Telugu","Kannada","Malayalam","Sinhala","Thai","Lao","Tibetan","Myanmar","Georgian","Hangul","Ethiopic","Cherokee","Canadian_Aboriginal","Ogham","Runic","Tagalog","Hanunoo","Buhid","Tagbanwa","Khmer","Mongolian","Limbu","Tai_Le","New_Tai_Lue","Buginese","Tai_Tham","Balinese","Sundanese","Batak","Lepcha","Ol_Chiki","Braille","Glagolitic","Tifinagh","Han","Hiragana","Katakana","Yi","Lisu","Vai","Bamum","Syloti_Nagri","Phags_Pa","Saurashtra","Kayah_Li","Rejang","Javanese","Cham","Tai_Viet","Meetei_Mayek","null","Linear_B","Lycian","Carian","Old_Italic","Gothic","Old_Permic","Ugaritic","Old_Persian","Deseret","Shavian","Osmanya","Osage","Elbasan","Caucasian_Albanian","Linear_A","Cypriot","Imperial_Aramaic","Palmyrene","Nabataean","Hatran","Phoenician","Lydian","Meroitic_Hieroglyphs","Meroitic_Cursive","Kharoshthi","Old_South_Arabian","Old_North_Arabian","Manichaean","Avestan","Inscriptional_Parthian","Inscriptional_Pahlavi","Psalter_Pahlavi","Old_Turkic","Old_Hungarian","Hanifi_Rohingya","Old_Sogdian","Sogdian","Elymaic","Brahmi","Kaithi","Sora_Sompeng","Chakma","Mahajani","Sharada","Khojki","Multani","Khudawadi","Grantha","Newa","Tirhuta","Siddham","Modi","Takri","Ahom","Dogra","Warang_Citi","Nandinagari","Zanabazar_Square","Soyombo","Pau_Cin_Hau","Bhaiksuki","Marchen","Masaram_Gondi","Gunjala_Gondi","Makasar","Cuneiform","Egyptian_Hieroglyphs","Anatolian_Hieroglyphs","Mro","Bassa_Vah","Pahawh_Hmong","Medefaidrin","Miao","Tangut","Nushu","Duployan","SignWriting","Nyiakeng_Puachue_Hmong","Wancho","Mende_Kikakui","Adlam"],"eaw":["N","Na","A","W","H","F"]}');


const $747425b437e121da$var$trie = new (0, unicode_trie)((0, base64_js).toByteArray("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"));
const $747425b437e121da$var$log2 = Math.log2 || ((n)=>Math.log(n) / Math.LN2);
const $747425b437e121da$var$bits = (n)=>$747425b437e121da$var$log2(n) + 1 | 0;
// compute the number of bits stored for each field
const $747425b437e121da$var$CATEGORY_BITS = $747425b437e121da$var$bits((0, (/*@__PURE__*/$parcel$interopDefault($f4087201da764553$exports))).categories.length - 1);
const $747425b437e121da$var$COMBINING_BITS = $747425b437e121da$var$bits((0, (/*@__PURE__*/$parcel$interopDefault($f4087201da764553$exports))).combiningClasses.length - 1);
const $747425b437e121da$var$SCRIPT_BITS = $747425b437e121da$var$bits((0, (/*@__PURE__*/$parcel$interopDefault($f4087201da764553$exports))).scripts.length - 1);
const $747425b437e121da$var$EAW_BITS = $747425b437e121da$var$bits((0, (/*@__PURE__*/$parcel$interopDefault($f4087201da764553$exports))).eaw.length - 1);
const $747425b437e121da$var$NUMBER_BITS = 10;
// compute shift and mask values for each field
const $747425b437e121da$var$CATEGORY_SHIFT = $747425b437e121da$var$COMBINING_BITS + $747425b437e121da$var$SCRIPT_BITS + $747425b437e121da$var$EAW_BITS + $747425b437e121da$var$NUMBER_BITS;
const $747425b437e121da$var$COMBINING_SHIFT = $747425b437e121da$var$SCRIPT_BITS + $747425b437e121da$var$EAW_BITS + $747425b437e121da$var$NUMBER_BITS;
const $747425b437e121da$var$SCRIPT_SHIFT = $747425b437e121da$var$EAW_BITS + $747425b437e121da$var$NUMBER_BITS;
const $747425b437e121da$var$EAW_SHIFT = $747425b437e121da$var$NUMBER_BITS;
const $747425b437e121da$var$CATEGORY_MASK = (1 << $747425b437e121da$var$CATEGORY_BITS) - 1;
const $747425b437e121da$var$COMBINING_MASK = (1 << $747425b437e121da$var$COMBINING_BITS) - 1;
const $747425b437e121da$var$SCRIPT_MASK = (1 << $747425b437e121da$var$SCRIPT_BITS) - 1;
const $747425b437e121da$var$EAW_MASK = (1 << $747425b437e121da$var$EAW_BITS) - 1;
const $747425b437e121da$var$NUMBER_MASK = (1 << $747425b437e121da$var$NUMBER_BITS) - 1;
function $747425b437e121da$export$410364bbb673ddbc(codePoint) {
    const val = $747425b437e121da$var$trie.get(codePoint);
    return (0, (/*@__PURE__*/$parcel$interopDefault($f4087201da764553$exports))).categories[val >> $747425b437e121da$var$CATEGORY_SHIFT & $747425b437e121da$var$CATEGORY_MASK];
}
function $747425b437e121da$export$c03b919c6651ed55(codePoint) {
    const val = $747425b437e121da$var$trie.get(codePoint);
    return (0, (/*@__PURE__*/$parcel$interopDefault($f4087201da764553$exports))).combiningClasses[val >> $747425b437e121da$var$COMBINING_SHIFT & $747425b437e121da$var$COMBINING_MASK];
}
function $747425b437e121da$export$941569448d136665(codePoint) {
    const val = $747425b437e121da$var$trie.get(codePoint);
    return (0, (/*@__PURE__*/$parcel$interopDefault($f4087201da764553$exports))).scripts[val >> $747425b437e121da$var$SCRIPT_SHIFT & $747425b437e121da$var$SCRIPT_MASK];
}
function $747425b437e121da$export$92f6187db8ca6d26(codePoint) {
    const val = $747425b437e121da$var$trie.get(codePoint);
    return (0, (/*@__PURE__*/$parcel$interopDefault($f4087201da764553$exports))).eaw[val >> $747425b437e121da$var$EAW_SHIFT & $747425b437e121da$var$EAW_MASK];
}
function $747425b437e121da$export$7d1258ebb7625a0d(codePoint) {
    let val = $747425b437e121da$var$trie.get(codePoint);
    let num = val & $747425b437e121da$var$NUMBER_MASK;
    if (num === 0) return null;
    else if (num <= 50) return num - 1;
    else if (num < 0x1e0) {
        const numerator = (num >> 4) - 12;
        const denominator = (num & 0xf) + 1;
        return numerator / denominator;
    } else if (num < 0x300) {
        val = (num >> 5) - 14;
        let exp = (num & 0x1f) + 2;
        while(exp > 0){
            val *= 10;
            exp--;
        }
        return val;
    } else {
        val = (num >> 2) - 0xbf;
        let exp = (num & 3) + 1;
        while(exp > 0){
            val *= 60;
            exp--;
        }
        return val;
    }
}
function $747425b437e121da$export$52c8ea63abd07594(codePoint) {
    const category = $747425b437e121da$export$410364bbb673ddbc(codePoint);
    return category === "Lu" || category === "Ll" || category === "Lt" || category === "Lm" || category === "Lo" || category === "Nl";
}
function $747425b437e121da$export$727d9dbc4fbb948f(codePoint) {
    return $747425b437e121da$export$410364bbb673ddbc(codePoint) === "Nd";
}
function $747425b437e121da$export$a5b49f4dc6a07d2c(codePoint) {
    const category = $747425b437e121da$export$410364bbb673ddbc(codePoint);
    return category === "Pc" || category === "Pd" || category === "Pe" || category === "Pf" || category === "Pi" || category === "Po" || category === "Ps";
}
function $747425b437e121da$export$7b6804e8df61fcf5(codePoint) {
    return $747425b437e121da$export$410364bbb673ddbc(codePoint) === "Ll";
}
function $747425b437e121da$export$aebd617640818cda(codePoint) {
    return $747425b437e121da$export$410364bbb673ddbc(codePoint) === "Lu";
}
function $747425b437e121da$export$de8b4ee23b2cf823(codePoint) {
    return $747425b437e121da$export$410364bbb673ddbc(codePoint) === "Lt";
}
function $747425b437e121da$export$3c52dd84024ae72c(codePoint) {
    const category = $747425b437e121da$export$410364bbb673ddbc(codePoint);
    return category === "Zs" || category === "Zl" || category === "Zp";
}
function $747425b437e121da$export$a11bdcffe109e74b(codePoint) {
    const category = $747425b437e121da$export$410364bbb673ddbc(codePoint);
    return category === "Nd" || category === "No" || category === "Nl" || category === "Lu" || category === "Ll" || category === "Lt" || category === "Lm" || category === "Lo" || category === "Me" || category === "Mc";
}
function $747425b437e121da$export$e33ad6871e762338(codePoint) {
    const category = $747425b437e121da$export$410364bbb673ddbc(codePoint);
    return category === "Mn" || category === "Me" || category === "Mc";
}
var // Backwards compatibility.
$747425b437e121da$export$2e2bcd8739ae039 = {
    getCategory: $747425b437e121da$export$410364bbb673ddbc,
    getCombiningClass: $747425b437e121da$export$c03b919c6651ed55,
    getScript: $747425b437e121da$export$941569448d136665,
    getEastAsianWidth: $747425b437e121da$export$92f6187db8ca6d26,
    getNumericValue: $747425b437e121da$export$7d1258ebb7625a0d,
    isAlphabetic: $747425b437e121da$export$52c8ea63abd07594,
    isDigit: $747425b437e121da$export$727d9dbc4fbb948f,
    isPunctuation: $747425b437e121da$export$a5b49f4dc6a07d2c,
    isLowerCase: $747425b437e121da$export$7b6804e8df61fcf5,
    isUpperCase: $747425b437e121da$export$aebd617640818cda,
    isTitleCase: $747425b437e121da$export$de8b4ee23b2cf823,
    isWhiteSpace: $747425b437e121da$export$3c52dd84024ae72c,
    isBaseForm: $747425b437e121da$export$a11bdcffe109e74b,
    isMark: $747425b437e121da$export$e33ad6871e762338
};



//# sourceMappingURL=module.mjs.map

// EXTERNAL MODULE: ../../node_modules/.pnpm/dfa@1.2.0/node_modules/dfa/index.js
var dfa = __nccwpck_require__(803);
// EXTERNAL MODULE: ../../node_modules/.pnpm/clone@2.1.2/node_modules/clone/clone.js
var clone = __nccwpck_require__(630);
// EXTERNAL MODULE: ../../node_modules/.pnpm/tiny-inflate@1.0.3/node_modules/tiny-inflate/index.js
var tiny_inflate = __nccwpck_require__(151);
// EXTERNAL MODULE: ../../node_modules/.pnpm/brotli@1.3.3/node_modules/brotli/decompress.js
var decompress = __nccwpck_require__(754);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/fontkit@2.0.2/node_modules/fontkit/dist/module.mjs












function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}
function module_$parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
var $d636bc798e7178db$exports = {};

$parcel$export($d636bc798e7178db$exports, "logErrors", () => $d636bc798e7178db$export$bd5c5d8b8dcafd78);
$parcel$export($d636bc798e7178db$exports, "registerFormat", () => $d636bc798e7178db$export$36b2f24e97d43be);
$parcel$export($d636bc798e7178db$exports, "create", () => $d636bc798e7178db$export$185802fd694ee1f5);
$parcel$export($d636bc798e7178db$exports, "defaultLanguage", () => $d636bc798e7178db$export$42940898df819940);
$parcel$export($d636bc798e7178db$exports, "setDefaultLanguage", () => $d636bc798e7178db$export$5157e7780d44cc36);

let $d636bc798e7178db$export$bd5c5d8b8dcafd78 = false;
let $d636bc798e7178db$var$formats = [];
function $d636bc798e7178db$export$36b2f24e97d43be(format) {
    $d636bc798e7178db$var$formats.push(format);
}
function $d636bc798e7178db$export$185802fd694ee1f5(buffer, postscriptName) {
    for(let i = 0; i < $d636bc798e7178db$var$formats.length; i++){
        let format = $d636bc798e7178db$var$formats[i];
        if (format.probe(buffer)) {
            let font = new format(new (0, DecodeStream)(buffer));
            if (postscriptName) return font.getFont(postscriptName);
            return font;
        }
    }
    throw new Error("Unknown font format");
}
let $d636bc798e7178db$export$42940898df819940 = "en";
function $d636bc798e7178db$export$5157e7780d44cc36(lang = "en") {
    $d636bc798e7178db$export$42940898df819940 = lang;
}


var $b422b1e013cd6010$exports = {};

$parcel$export($b422b1e013cd6010$exports, "openSync", () => $b422b1e013cd6010$export$fa5499edb1ab414a);
$parcel$export($b422b1e013cd6010$exports, "open", () => $b422b1e013cd6010$export$3ce6949f20cea765);


function $b422b1e013cd6010$export$fa5499edb1ab414a(filename, postscriptName) {
    let buffer = (0, external_fs_namespaceObject).readFileSync(filename);
    return (0, $d636bc798e7178db$export$185802fd694ee1f5)(buffer, postscriptName);
}
async function $b422b1e013cd6010$export$3ce6949f20cea765(filename, postscriptName, callback) {
    if (typeof postscriptName === "function") {
        callback = postscriptName;
        postscriptName = null;
    }
    let buffer = await (0, external_fs_namespaceObject).promises.readFile(filename);
    return (0, $d636bc798e7178db$export$185802fd694ee1f5)(buffer, postscriptName);
}





function $e71565f2ce09cb6b$export$69a3209f1a06c04d(target, key1, descriptor) {
    if (descriptor.get) {
        let get = descriptor.get;
        descriptor.get = function() {
            let value = get.call(this);
            Object.defineProperty(this, key1, {
                value: value
            });
            return value;
        };
    } else if (typeof descriptor.value === "function") {
        let fn = descriptor.value;
        return {
            get () {
                let cache1 = new Map;
                function memoized(...args) {
                    let key = args.length > 0 ? args[0] : "value";
                    if (cache1.has(key)) return cache1.get(key);
                    let result = fn.apply(this, args);
                    cache1.set(key, result);
                    return result;
                }
                Object.defineProperty(this, key1, {
                    value: memoized
                });
                return memoized;
            }
        };
    }
}





let $26a62205ad06574e$var$SubHeader = new Struct({
    firstCode: uint16,
    entryCount: uint16,
    idDelta: int16,
    idRangeOffset: uint16
});
let $26a62205ad06574e$var$CmapGroup = new Struct({
    startCharCode: uint32,
    endCharCode: uint32,
    glyphID: uint32
});
let $26a62205ad06574e$var$UnicodeValueRange = new Struct({
    startUnicodeValue: uint24,
    additionalCount: uint8
});
let $26a62205ad06574e$var$UVSMapping = new Struct({
    unicodeValue: uint24,
    glyphID: uint16
});
let $26a62205ad06574e$var$DefaultUVS = new ArrayT($26a62205ad06574e$var$UnicodeValueRange, uint32);
let $26a62205ad06574e$var$NonDefaultUVS = new ArrayT($26a62205ad06574e$var$UVSMapping, uint32);
let $26a62205ad06574e$var$VarSelectorRecord = new Struct({
    varSelector: uint24,
    defaultUVS: new Pointer(uint32, $26a62205ad06574e$var$DefaultUVS, {
        type: "parent"
    }),
    nonDefaultUVS: new Pointer(uint32, $26a62205ad06574e$var$NonDefaultUVS, {
        type: "parent"
    })
});
let $26a62205ad06574e$var$CmapSubtable = new VersionedStruct(uint16, {
    0: {
        length: uint16,
        language: uint16,
        codeMap: new LazyArray(uint8, 256)
    },
    2: {
        length: uint16,
        language: uint16,
        subHeaderKeys: new ArrayT(uint16, 256),
        subHeaderCount: (t)=>Math.max.apply(Math, t.subHeaderKeys),
        subHeaders: new LazyArray($26a62205ad06574e$var$SubHeader, "subHeaderCount"),
        glyphIndexArray: new LazyArray(uint16, "subHeaderCount")
    },
    4: {
        length: uint16,
        language: uint16,
        segCountX2: uint16,
        segCount: (t)=>t.segCountX2 >> 1,
        searchRange: uint16,
        entrySelector: uint16,
        rangeShift: uint16,
        endCode: new LazyArray(uint16, "segCount"),
        reservedPad: new Reserved(uint16),
        startCode: new LazyArray(uint16, "segCount"),
        idDelta: new LazyArray(int16, "segCount"),
        idRangeOffset: new LazyArray(uint16, "segCount"),
        glyphIndexArray: new LazyArray(uint16, (t)=>(t.length - t._currentOffset) / 2)
    },
    6: {
        length: uint16,
        language: uint16,
        firstCode: uint16,
        entryCount: uint16,
        glyphIndices: new LazyArray(uint16, "entryCount")
    },
    8: {
        reserved: new Reserved(uint16),
        length: uint32,
        language: uint16,
        is32: new LazyArray(uint8, 8192),
        nGroups: uint32,
        groups: new LazyArray($26a62205ad06574e$var$CmapGroup, "nGroups")
    },
    10: {
        reserved: new Reserved(uint16),
        length: uint32,
        language: uint32,
        firstCode: uint32,
        entryCount: uint32,
        glyphIndices: new LazyArray(uint16, "numChars")
    },
    12: {
        reserved: new Reserved(uint16),
        length: uint32,
        language: uint32,
        nGroups: uint32,
        groups: new LazyArray($26a62205ad06574e$var$CmapGroup, "nGroups")
    },
    13: {
        reserved: new Reserved(uint16),
        length: uint32,
        language: uint32,
        nGroups: uint32,
        groups: new LazyArray($26a62205ad06574e$var$CmapGroup, "nGroups")
    },
    14: {
        length: uint32,
        numRecords: uint32,
        varSelectors: new LazyArray($26a62205ad06574e$var$VarSelectorRecord, "numRecords")
    }
});
let $26a62205ad06574e$var$CmapEntry = new Struct({
    platformID: uint16,
    encodingID: uint16,
    table: new Pointer(uint32, $26a62205ad06574e$var$CmapSubtable, {
        type: "parent",
        lazy: true
    })
});
var // character to glyph mapping
$26a62205ad06574e$export$2e2bcd8739ae039 = new Struct({
    version: uint16,
    numSubtables: uint16,
    tables: new ArrayT($26a62205ad06574e$var$CmapEntry, "numSubtables")
});



var // font header
$f2612a29f92ac062$export$2e2bcd8739ae039 = new Struct({
    version: int32,
    revision: int32,
    checkSumAdjustment: uint32,
    magicNumber: uint32,
    flags: uint16,
    unitsPerEm: uint16,
    created: new ArrayT(int32, 2),
    modified: new ArrayT(int32, 2),
    xMin: int16,
    yMin: int16,
    xMax: int16,
    yMax: int16,
    macStyle: new Bitfield(uint16, [
        "bold",
        "italic",
        "underline",
        "outline",
        "shadow",
        "condensed",
        "extended"
    ]),
    lowestRecPPEM: uint16,
    fontDirectionHint: int16,
    indexToLocFormat: int16,
    glyphDataFormat: int16 // 0 for current format
});



var // horizontal header
$2c179dd593583073$export$2e2bcd8739ae039 = new Struct({
    version: int32,
    ascent: int16,
    descent: int16,
    lineGap: int16,
    advanceWidthMax: uint16,
    minLeftSideBearing: int16,
    minRightSideBearing: int16,
    xMaxExtent: int16,
    caretSlopeRise: int16,
    caretSlopeRun: int16,
    caretOffset: int16,
    reserved: new Reserved(int16, 4),
    metricDataFormat: int16,
    numberOfMetrics: uint16 // Number of advance widths in 'hmtx' table
});



let $bdc9060542264b85$var$HmtxEntry = new Struct({
    advance: uint16,
    bearing: int16
});
var $bdc9060542264b85$export$2e2bcd8739ae039 = new Struct({
    metrics: new LazyArray($bdc9060542264b85$var$HmtxEntry, (t)=>t.parent.hhea.numberOfMetrics),
    bearings: new LazyArray(int16, (t)=>t.parent.maxp.numGlyphs - t.parent.hhea.numberOfMetrics)
});



var // maxiumum profile
$dbf51cb3d3fe409d$export$2e2bcd8739ae039 = new Struct({
    version: int32,
    numGlyphs: uint16,
    maxPoints: uint16,
    maxContours: uint16,
    maxComponentPoints: uint16,
    maxComponentContours: uint16,
    maxZones: uint16,
    maxTwilightPoints: uint16,
    maxStorage: uint16,
    maxFunctionDefs: uint16,
    maxInstructionDefs: uint16,
    maxStackElements: uint16,
    maxSizeOfInstructions: uint16,
    maxComponentElements: uint16,
    maxComponentDepth: uint16 // Maximum levels of recursion; 1 for simple components
});



function $e449ad78d50845fe$export$badc544e0651b6b1(platformID, encodingID, languageID = 0) {
    if (platformID === 1 && $e449ad78d50845fe$export$479e671907f486d1[languageID]) return $e449ad78d50845fe$export$479e671907f486d1[languageID];
    return $e449ad78d50845fe$export$6fef87b7618bdf0b[platformID][encodingID];
}
const $e449ad78d50845fe$var$SINGLE_BYTE_ENCODINGS = new Set([
    "x-mac-roman",
    "x-mac-cyrillic",
    "iso-8859-6",
    "iso-8859-8"
]);
const $e449ad78d50845fe$var$MAC_ENCODINGS = {
    "x-mac-croatian": "\xc4\xc5\xc7\xc9\xd1\xd6\xdc\xe1\xe0\xe2\xe4\xe3\xe5\xe7\xe9\xe8\xea\xeb\xed\xec\xee\xef\xf1\xf3\xf2\xf4\xf6\xf5\xfa\xf9\xfb\xfc\u2020\xb0\xa2\xa3\xa7\u2022\xb6\xdf\xae\u0160\u2122\xb4\xa8\u2260\u017D\xd8\u221E\xb1\u2264\u2265\u2206\xb5\u2202\u2211\u220F\u0161\u222B\xaa\xba\u03A9\u017E\xf8\xbf\xa1\xac\u221A\u0192\u2248\u0106\xab\u010C\u2026 \xc0\xc3\xd5\u0152\u0153\u0110\u2014\u201C\u201D\u2018\u2019\xf7\u25CA\uF8FF\xa9\u2044\u20AC\u2039\u203A\xc6\xbb\u2013\xb7\u201A\u201E\u2030\xc2\u0107\xc1\u010D\xc8\xcd\xce\xcf\xcc\xd3\xd4\u0111\xd2\xda\xdb\xd9\u0131\u02C6\u02DC\xaf\u03C0\xcb\u02DA\xb8\xca\xe6\u02C7",
    "x-mac-gaelic": "\xc4\xc5\xc7\xc9\xd1\xd6\xdc\xe1\xe0\xe2\xe4\xe3\xe5\xe7\xe9\xe8\xea\xeb\xed\xec\xee\xef\xf1\xf3\xf2\xf4\xf6\xf5\xfa\xf9\xfb\xfc\u2020\xb0\xa2\xa3\xa7\u2022\xb6\xdf\xae\xa9\u2122\xb4\xa8\u2260\xc6\xd8\u1E02\xb1\u2264\u2265\u1E03\u010A\u010B\u1E0A\u1E0B\u1E1E\u1E1F\u0120\u0121\u1E40\xe6\xf8\u1E41\u1E56\u1E57\u027C\u0192\u017F\u1E60\xab\xbb\u2026 \xc0\xc3\xd5\u0152\u0153\u2013\u2014\u201C\u201D\u2018\u2019\u1E61\u1E9B\xff\u0178\u1E6A\u20AC\u2039\u203A\u0176\u0177\u1E6B\xb7\u1EF2\u1EF3\u204A\xc2\xca\xc1\xcb\xc8\xcd\xce\xcf\xcc\xd3\xd4\u2663\xd2\xda\xdb\xd9\u0131\xdd\xfd\u0174\u0175\u1E84\u1E85\u1E80\u1E81\u1E82\u1E83",
    "x-mac-greek": "\xc4\xb9\xb2\xc9\xb3\xd6\xdc\u0385\xe0\xe2\xe4\u0384\xa8\xe7\xe9\xe8\xea\xeb\xa3\u2122\xee\xef\u2022\xbd\u2030\xf4\xf6\xa6\u20AC\xf9\xfb\xfc\u2020\u0393\u0394\u0398\u039B\u039E\u03A0\xdf\xae\xa9\u03A3\u03AA\xa7\u2260\xb0\xb7\u0391\xb1\u2264\u2265\xa5\u0392\u0395\u0396\u0397\u0399\u039A\u039C\u03A6\u03AB\u03A8\u03A9\u03AC\u039D\xac\u039F\u03A1\u2248\u03A4\xab\xbb\u2026 \u03A5\u03A7\u0386\u0388\u0153\u2013\u2015\u201C\u201D\u2018\u2019\xf7\u0389\u038A\u038C\u038E\u03AD\u03AE\u03AF\u03CC\u038F\u03CD\u03B1\u03B2\u03C8\u03B4\u03B5\u03C6\u03B3\u03B7\u03B9\u03BE\u03BA\u03BB\u03BC\u03BD\u03BF\u03C0\u03CE\u03C1\u03C3\u03C4\u03B8\u03C9\u03C2\u03C7\u03C5\u03B6\u03CA\u03CB\u0390\u03B0\xad",
    "x-mac-icelandic": "\xc4\xc5\xc7\xc9\xd1\xd6\xdc\xe1\xe0\xe2\xe4\xe3\xe5\xe7\xe9\xe8\xea\xeb\xed\xec\xee\xef\xf1\xf3\xf2\xf4\xf6\xf5\xfa\xf9\xfb\xfc\xdd\xb0\xa2\xa3\xa7\u2022\xb6\xdf\xae\xa9\u2122\xb4\xa8\u2260\xc6\xd8\u221E\xb1\u2264\u2265\xa5\xb5\u2202\u2211\u220F\u03C0\u222B\xaa\xba\u03A9\xe6\xf8\xbf\xa1\xac\u221A\u0192\u2248\u2206\xab\xbb\u2026 \xc0\xc3\xd5\u0152\u0153\u2013\u2014\u201C\u201D\u2018\u2019\xf7\u25CA\xff\u0178\u2044\u20AC\xd0\xf0\xde\xfe\xfd\xb7\u201A\u201E\u2030\xc2\xca\xc1\xcb\xc8\xcd\xce\xcf\xcc\xd3\xd4\uF8FF\xd2\xda\xdb\xd9\u0131\u02C6\u02DC\xaf\u02D8\u02D9\u02DA\xb8\u02DD\u02DB\u02C7",
    "x-mac-inuit": "\u1403\u1404\u1405\u1406\u140A\u140B\u1431\u1432\u1433\u1434\u1438\u1439\u1449\u144E\u144F\u1450\u1451\u1455\u1456\u1466\u146D\u146E\u146F\u1470\u1472\u1473\u1483\u148B\u148C\u148D\u148E\u1490\u1491\xb0\u14A1\u14A5\u14A6\u2022\xb6\u14A7\xae\xa9\u2122\u14A8\u14AA\u14AB\u14BB\u14C2\u14C3\u14C4\u14C5\u14C7\u14C8\u14D0\u14EF\u14F0\u14F1\u14F2\u14F4\u14F5\u1505\u14D5\u14D6\u14D7\u14D8\u14DA\u14DB\u14EA\u1528\u1529\u152A\u152B\u152D\u2026 \u152E\u153E\u1555\u1556\u1557\u2013\u2014\u201C\u201D\u2018\u2019\u1558\u1559\u155A\u155D\u1546\u1547\u1548\u1549\u154B\u154C\u1550\u157F\u1580\u1581\u1582\u1583\u1584\u1585\u158F\u1590\u1591\u1592\u1593\u1594\u1595\u1671\u1672\u1673\u1674\u1675\u1676\u1596\u15A0\u15A1\u15A2\u15A3\u15A4\u15A5\u15A6\u157C\u0141\u0142",
    "x-mac-ce": "\xc4\u0100\u0101\xc9\u0104\xd6\xdc\xe1\u0105\u010C\xe4\u010D\u0106\u0107\xe9\u0179\u017A\u010E\xed\u010F\u0112\u0113\u0116\xf3\u0117\xf4\xf6\xf5\xfa\u011A\u011B\xfc\u2020\xb0\u0118\xa3\xa7\u2022\xb6\xdf\xae\xa9\u2122\u0119\xa8\u2260\u0123\u012E\u012F\u012A\u2264\u2265\u012B\u0136\u2202\u2211\u0142\u013B\u013C\u013D\u013E\u0139\u013A\u0145\u0146\u0143\xac\u221A\u0144\u0147\u2206\xab\xbb\u2026 \u0148\u0150\xd5\u0151\u014C\u2013\u2014\u201C\u201D\u2018\u2019\xf7\u25CA\u014D\u0154\u0155\u0158\u2039\u203A\u0159\u0156\u0157\u0160\u201A\u201E\u0161\u015A\u015B\xc1\u0164\u0165\xcd\u017D\u017E\u016A\xd3\xd4\u016B\u016E\xda\u016F\u0170\u0171\u0172\u0173\xdd\xfd\u0137\u017B\u0141\u017C\u0122\u02C7",
    "x-mac-romanian": "\xc4\xc5\xc7\xc9\xd1\xd6\xdc\xe1\xe0\xe2\xe4\xe3\xe5\xe7\xe9\xe8\xea\xeb\xed\xec\xee\xef\xf1\xf3\xf2\xf4\xf6\xf5\xfa\xf9\xfb\xfc\u2020\xb0\xa2\xa3\xa7\u2022\xb6\xdf\xae\xa9\u2122\xb4\xa8\u2260\u0102\u0218\u221E\xb1\u2264\u2265\xa5\xb5\u2202\u2211\u220F\u03C0\u222B\xaa\xba\u03A9\u0103\u0219\xbf\xa1\xac\u221A\u0192\u2248\u2206\xab\xbb\u2026 \xc0\xc3\xd5\u0152\u0153\u2013\u2014\u201C\u201D\u2018\u2019\xf7\u25CA\xff\u0178\u2044\u20AC\u2039\u203A\u021A\u021B\u2021\xb7\u201A\u201E\u2030\xc2\xca\xc1\xcb\xc8\xcd\xce\xcf\xcc\xd3\xd4\uF8FF\xd2\xda\xdb\xd9\u0131\u02C6\u02DC\xaf\u02D8\u02D9\u02DA\xb8\u02DD\u02DB\u02C7",
    "x-mac-turkish": "\xc4\xc5\xc7\xc9\xd1\xd6\xdc\xe1\xe0\xe2\xe4\xe3\xe5\xe7\xe9\xe8\xea\xeb\xed\xec\xee\xef\xf1\xf3\xf2\xf4\xf6\xf5\xfa\xf9\xfb\xfc\u2020\xb0\xa2\xa3\xa7\u2022\xb6\xdf\xae\xa9\u2122\xb4\xa8\u2260\xc6\xd8\u221E\xb1\u2264\u2265\xa5\xb5\u2202\u2211\u220F\u03C0\u222B\xaa\xba\u03A9\xe6\xf8\xbf\xa1\xac\u221A\u0192\u2248\u2206\xab\xbb\u2026 \xc0\xc3\xd5\u0152\u0153\u2013\u2014\u201C\u201D\u2018\u2019\xf7\u25CA\xff\u0178\u011E\u011F\u0130\u0131\u015E\u015F\u2021\xb7\u201A\u201E\u2030\xc2\xca\xc1\xcb\xc8\xcd\xce\xcf\xcc\xd3\xd4\uF8FF\xd2\xda\xdb\xd9\uF8A0\u02C6\u02DC\xaf\u02D8\u02D9\u02DA\xb8\u02DD\u02DB\u02C7"
};
const $e449ad78d50845fe$var$encodingCache = new Map();
function $e449ad78d50845fe$export$1dceb3c14ed68bee(encoding) {
    let cached = $e449ad78d50845fe$var$encodingCache.get(encoding);
    if (cached) return cached;
    // These encodings aren't supported by TextDecoder.
    let mapping = $e449ad78d50845fe$var$MAC_ENCODINGS[encoding];
    if (mapping) {
        let res = new Map();
        for(let i = 0; i < mapping.length; i++)res.set(mapping.charCodeAt(i), 0x80 + i);
        $e449ad78d50845fe$var$encodingCache.set(encoding, res);
        return res;
    }
    // Only single byte encodings can be mapped 1:1.
    if ($e449ad78d50845fe$var$SINGLE_BYTE_ENCODINGS.has(encoding)) {
        // TextEncoder only supports utf8, whereas TextDecoder supports legacy encodings.
        // Use this to create a mapping of code points.
        let decoder = new TextDecoder(encoding);
        let mapping = new Uint8Array(0x80);
        for(let i = 0; i < 0x80; i++)mapping[i] = 0x80 + i;
        let res = new Map();
        let s = decoder.decode(mapping);
        for(let i1 = 0; i1 < 0x80; i1++)res.set(s.charCodeAt(i1), 0x80 + i1);
        $e449ad78d50845fe$var$encodingCache.set(encoding, res);
        return res;
    }
}
const $e449ad78d50845fe$export$6fef87b7618bdf0b = [
    // unicode
    [
        "utf16be",
        "utf16be",
        "utf16be",
        "utf16be",
        "utf16be",
        "utf16be"
    ],
    // macintosh
    // Mappings available at http://unicode.org/Public/MAPPINGS/VENDORS/APPLE/
    // 0	Roman                 17	Malayalam
    // 1	Japanese	            18	Sinhalese
    // 2	Traditional Chinese	  19	Burmese
    // 3	Korean	              20	Khmer
    // 4	Arabic	              21	Thai
    // 5	Hebrew	              22	Laotian
    // 6	Greek	                23	Georgian
    // 7	Russian	              24	Armenian
    // 8	RSymbol	              25	Simplified Chinese
    // 9	Devanagari	          26	Tibetan
    // 10	Gurmukhi	            27	Mongolian
    // 11	Gujarati	            28	Geez
    // 12	Oriya	                29	Slavic
    // 13	Bengali	              30	Vietnamese
    // 14	Tamil	                31	Sindhi
    // 15	Telugu	              32	(Uninterpreted)
    // 16	Kannada
    [
        "x-mac-roman",
        "shift-jis",
        "big5",
        "euc-kr",
        "iso-8859-6",
        "iso-8859-8",
        "x-mac-greek",
        "x-mac-cyrillic",
        "x-mac-symbol",
        "x-mac-devanagari",
        "x-mac-gurmukhi",
        "x-mac-gujarati",
        "Oriya",
        "Bengali",
        "Tamil",
        "Telugu",
        "Kannada",
        "Malayalam",
        "Sinhalese",
        "Burmese",
        "Khmer",
        "iso-8859-11",
        "Laotian",
        "Georgian",
        "Armenian",
        "hz-gb-2312",
        "Tibetan",
        "Mongolian",
        "Geez",
        "x-mac-ce",
        "Vietnamese",
        "Sindhi"
    ],
    // ISO (deprecated)
    [
        "ascii"
    ],
    // windows
    // Docs here: http://msdn.microsoft.com/en-us/library/system.text.encoding(v=vs.110).aspx
    [
        "symbol",
        "utf16be",
        "shift-jis",
        "gb18030",
        "big5",
        "x-cp20949",
        "johab",
        null,
        null,
        null,
        "utf16be"
    ]
];
const $e449ad78d50845fe$export$479e671907f486d1 = {
    15: "x-mac-icelandic",
    17: "x-mac-turkish",
    18: "x-mac-croatian",
    24: "x-mac-ce",
    25: "x-mac-ce",
    26: "x-mac-ce",
    27: "x-mac-ce",
    28: "x-mac-ce",
    30: "x-mac-icelandic",
    37: "x-mac-romanian",
    38: "x-mac-ce",
    39: "x-mac-ce",
    40: "x-mac-ce",
    143: "x-mac-inuit",
    146: "x-mac-gaelic"
};
const $e449ad78d50845fe$export$2092376fd002e13 = [
    // unicode
    [],
    {
        0: "en",
        30: "fo",
        60: "ks",
        90: "rw",
        1: "fr",
        31: "fa",
        61: "ku",
        91: "rn",
        2: "de",
        32: "ru",
        62: "sd",
        92: "ny",
        3: "it",
        33: "zh",
        63: "bo",
        93: "mg",
        4: "nl",
        34: "nl-BE",
        64: "ne",
        94: "eo",
        5: "sv",
        35: "ga",
        65: "sa",
        128: "cy",
        6: "es",
        36: "sq",
        66: "mr",
        129: "eu",
        7: "da",
        37: "ro",
        67: "bn",
        130: "ca",
        8: "pt",
        38: "cz",
        68: "as",
        131: "la",
        9: "no",
        39: "sk",
        69: "gu",
        132: "qu",
        10: "he",
        40: "si",
        70: "pa",
        133: "gn",
        11: "ja",
        41: "yi",
        71: "or",
        134: "ay",
        12: "ar",
        42: "sr",
        72: "ml",
        135: "tt",
        13: "fi",
        43: "mk",
        73: "kn",
        136: "ug",
        14: "el",
        44: "bg",
        74: "ta",
        137: "dz",
        15: "is",
        45: "uk",
        75: "te",
        138: "jv",
        16: "mt",
        46: "be",
        76: "si",
        139: "su",
        17: "tr",
        47: "uz",
        77: "my",
        140: "gl",
        18: "hr",
        48: "kk",
        78: "km",
        141: "af",
        19: "zh-Hant",
        49: "az-Cyrl",
        79: "lo",
        142: "br",
        20: "ur",
        50: "az-Arab",
        80: "vi",
        143: "iu",
        21: "hi",
        51: "hy",
        81: "id",
        144: "gd",
        22: "th",
        52: "ka",
        82: "tl",
        145: "gv",
        23: "ko",
        53: "mo",
        83: "ms",
        146: "ga",
        24: "lt",
        54: "ky",
        84: "ms-Arab",
        147: "to",
        25: "pl",
        55: "tg",
        85: "am",
        148: "el-polyton",
        26: "hu",
        56: "tk",
        86: "ti",
        149: "kl",
        27: "es",
        57: "mn-CN",
        87: "om",
        150: "az",
        28: "lv",
        58: "mn",
        88: "so",
        151: "nn",
        29: "se",
        59: "ps",
        89: "sw"
    },
    // ISO (deprecated)
    [],
    {
        0x0436: "af",
        0x4009: "en-IN",
        0x0487: "rw",
        0x0432: "tn",
        0x041C: "sq",
        0x1809: "en-IE",
        0x0441: "sw",
        0x045B: "si",
        0x0484: "gsw",
        0x2009: "en-JM",
        0x0457: "kok",
        0x041B: "sk",
        0x045E: "am",
        0x4409: "en-MY",
        0x0412: "ko",
        0x0424: "sl",
        0x1401: "ar-DZ",
        0x1409: "en-NZ",
        0x0440: "ky",
        0x2C0A: "es-AR",
        0x3C01: "ar-BH",
        0x3409: "en-PH",
        0x0454: "lo",
        0x400A: "es-BO",
        0x0C01: "ar",
        0x4809: "en-SG",
        0x0426: "lv",
        0x340A: "es-CL",
        0x0801: "ar-IQ",
        0x1C09: "en-ZA",
        0x0427: "lt",
        0x240A: "es-CO",
        0x2C01: "ar-JO",
        0x2C09: "en-TT",
        0x082E: "dsb",
        0x140A: "es-CR",
        0x3401: "ar-KW",
        0x0809: "en-GB",
        0x046E: "lb",
        0x1C0A: "es-DO",
        0x3001: "ar-LB",
        0x0409: "en",
        0x042F: "mk",
        0x300A: "es-EC",
        0x1001: "ar-LY",
        0x3009: "en-ZW",
        0x083E: "ms-BN",
        0x440A: "es-SV",
        0x1801: "ary",
        0x0425: "et",
        0x043E: "ms",
        0x100A: "es-GT",
        0x2001: "ar-OM",
        0x0438: "fo",
        0x044C: "ml",
        0x480A: "es-HN",
        0x4001: "ar-QA",
        0x0464: "fil",
        0x043A: "mt",
        0x080A: "es-MX",
        0x0401: "ar-SA",
        0x040B: "fi",
        0x0481: "mi",
        0x4C0A: "es-NI",
        0x2801: "ar-SY",
        0x080C: "fr-BE",
        0x047A: "arn",
        0x180A: "es-PA",
        0x1C01: "aeb",
        0x0C0C: "fr-CA",
        0x044E: "mr",
        0x3C0A: "es-PY",
        0x3801: "ar-AE",
        0x040C: "fr",
        0x047C: "moh",
        0x280A: "es-PE",
        0x2401: "ar-YE",
        0x140C: "fr-LU",
        0x0450: "mn",
        0x500A: "es-PR",
        0x042B: "hy",
        0x180C: "fr-MC",
        0x0850: "mn-CN",
        0x0C0A: "es",
        0x044D: "as",
        0x100C: "fr-CH",
        0x0461: "ne",
        0x040A: "es",
        0x082C: "az-Cyrl",
        0x0462: "fy",
        0x0414: "nb",
        0x540A: "es-US",
        0x042C: "az",
        0x0456: "gl",
        0x0814: "nn",
        0x380A: "es-UY",
        0x046D: "ba",
        0x0437: "ka",
        0x0482: "oc",
        0x200A: "es-VE",
        0x042D: "eu",
        0x0C07: "de-AT",
        0x0448: "or",
        0x081D: "sv-FI",
        0x0423: "be",
        0x0407: "de",
        0x0463: "ps",
        0x041D: "sv",
        0x0845: "bn",
        0x1407: "de-LI",
        0x0415: "pl",
        0x045A: "syr",
        0x0445: "bn-IN",
        0x1007: "de-LU",
        0x0416: "pt",
        0x0428: "tg",
        0x201A: "bs-Cyrl",
        0x0807: "de-CH",
        0x0816: "pt-PT",
        0x085F: "tzm",
        0x141A: "bs",
        0x0408: "el",
        0x0446: "pa",
        0x0449: "ta",
        0x047E: "br",
        0x046F: "kl",
        0x046B: "qu-BO",
        0x0444: "tt",
        0x0402: "bg",
        0x0447: "gu",
        0x086B: "qu-EC",
        0x044A: "te",
        0x0403: "ca",
        0x0468: "ha",
        0x0C6B: "qu",
        0x041E: "th",
        0x0C04: "zh-HK",
        0x040D: "he",
        0x0418: "ro",
        0x0451: "bo",
        0x1404: "zh-MO",
        0x0439: "hi",
        0x0417: "rm",
        0x041F: "tr",
        0x0804: "zh",
        0x040E: "hu",
        0x0419: "ru",
        0x0442: "tk",
        0x1004: "zh-SG",
        0x040F: "is",
        0x243B: "smn",
        0x0480: "ug",
        0x0404: "zh-TW",
        0x0470: "ig",
        0x103B: "smj-NO",
        0x0422: "uk",
        0x0483: "co",
        0x0421: "id",
        0x143B: "smj",
        0x042E: "hsb",
        0x041A: "hr",
        0x045D: "iu",
        0x0C3B: "se-FI",
        0x0420: "ur",
        0x101A: "hr-BA",
        0x085D: "iu-Latn",
        0x043B: "se",
        0x0843: "uz-Cyrl",
        0x0405: "cs",
        0x083C: "ga",
        0x083B: "se-SE",
        0x0443: "uz",
        0x0406: "da",
        0x0434: "xh",
        0x203B: "sms",
        0x042A: "vi",
        0x048C: "prs",
        0x0435: "zu",
        0x183B: "sma-NO",
        0x0452: "cy",
        0x0465: "dv",
        0x0410: "it",
        0x1C3B: "sms",
        0x0488: "wo",
        0x0813: "nl-BE",
        0x0810: "it-CH",
        0x044F: "sa",
        0x0485: "sah",
        0x0413: "nl",
        0x0411: "ja",
        0x1C1A: "sr-Cyrl-BA",
        0x0478: "ii",
        0x0C09: "en-AU",
        0x044B: "kn",
        0x0C1A: "sr",
        0x046A: "yo",
        0x2809: "en-BZ",
        0x043F: "kk",
        0x181A: "sr-Latn-BA",
        0x1009: "en-CA",
        0x0453: "km",
        0x081A: "sr-Latn",
        0x2409: "en-029",
        0x0486: "quc",
        0x046C: "nso"
    }
];


let $2bcf221753ec8e32$var$NameRecord = new Struct({
    platformID: uint16,
    encodingID: uint16,
    languageID: uint16,
    nameID: uint16,
    length: uint16,
    string: new Pointer(uint16, new StringT("length", (t)=>(0, $e449ad78d50845fe$export$badc544e0651b6b1)(t.platformID, t.encodingID, t.languageID)), {
        type: "parent",
        relativeTo: (ctx)=>ctx.parent.stringOffset,
        allowNull: false
    })
});
let $2bcf221753ec8e32$var$LangTagRecord = new Struct({
    length: uint16,
    tag: new Pointer(uint16, new StringT("length", "utf16be"), {
        type: "parent",
        relativeTo: (ctx)=>ctx.stringOffset
    })
});
var $2bcf221753ec8e32$var$NameTable = new VersionedStruct(uint16, {
    0: {
        count: uint16,
        stringOffset: uint16,
        records: new ArrayT($2bcf221753ec8e32$var$NameRecord, "count")
    },
    1: {
        count: uint16,
        stringOffset: uint16,
        records: new ArrayT($2bcf221753ec8e32$var$NameRecord, "count"),
        langTagCount: uint16,
        langTags: new ArrayT($2bcf221753ec8e32$var$LangTagRecord, "langTagCount")
    }
});
var $2bcf221753ec8e32$export$2e2bcd8739ae039 = $2bcf221753ec8e32$var$NameTable;
const $2bcf221753ec8e32$var$NAMES = [
    "copyright",
    "fontFamily",
    "fontSubfamily",
    "uniqueSubfamily",
    "fullName",
    "version",
    "postscriptName",
    "trademark",
    "manufacturer",
    "designer",
    "description",
    "vendorURL",
    "designerURL",
    "license",
    "licenseURL",
    null,
    "preferredFamily",
    "preferredSubfamily",
    "compatibleFull",
    "sampleText",
    "postscriptCIDFontName",
    "wwsFamilyName",
    "wwsSubfamilyName"
];
$2bcf221753ec8e32$var$NameTable.process = function(stream) {
    var records = {};
    for (let record of this.records){
        // find out what language this is for
        let language = (0, $e449ad78d50845fe$export$2092376fd002e13)[record.platformID][record.languageID];
        if (language == null && this.langTags != null && record.languageID >= 0x8000) language = this.langTags[record.languageID - 0x8000].tag;
        if (language == null) language = record.platformID + "-" + record.languageID;
        // if the nameID is >= 256, it is a font feature record (AAT)
        let key = record.nameID >= 256 ? "fontFeatures" : $2bcf221753ec8e32$var$NAMES[record.nameID] || record.nameID;
        if (records[key] == null) records[key] = {};
        let obj = records[key];
        if (record.nameID >= 256) obj = obj[record.nameID] || (obj[record.nameID] = {});
        if (typeof record.string === "string" || typeof obj[language] !== "string") obj[language] = record.string;
    }
    this.records = records;
};
$2bcf221753ec8e32$var$NameTable.preEncode = function() {
    if (Array.isArray(this.records)) return;
    this.version = 0;
    let records = [];
    for(let key in this.records){
        let val = this.records[key];
        if (key === "fontFeatures") continue;
        records.push({
            platformID: 3,
            encodingID: 1,
            languageID: 0x409,
            nameID: $2bcf221753ec8e32$var$NAMES.indexOf(key),
            length: val.en.length * 2,
            string: val.en
        });
        if (key === "postscriptName") records.push({
            platformID: 1,
            encodingID: 0,
            languageID: 0,
            nameID: $2bcf221753ec8e32$var$NAMES.indexOf(key),
            length: val.en.length,
            string: val.en
        });
    }
    this.records = records;
    this.count = records.length;
    this.stringOffset = $2bcf221753ec8e32$var$NameTable.size(this, null, false);
};



var $84b272aa31b70606$var$OS2 = new VersionedStruct(uint16, {
    header: {
        xAvgCharWidth: int16,
        usWeightClass: uint16,
        usWidthClass: uint16,
        fsType: new Bitfield(uint16, [
            null,
            "noEmbedding",
            "viewOnly",
            "editable",
            null,
            null,
            null,
            null,
            "noSubsetting",
            "bitmapOnly"
        ]),
        ySubscriptXSize: int16,
        ySubscriptYSize: int16,
        ySubscriptXOffset: int16,
        ySubscriptYOffset: int16,
        ySuperscriptXSize: int16,
        ySuperscriptYSize: int16,
        ySuperscriptXOffset: int16,
        ySuperscriptYOffset: int16,
        yStrikeoutSize: int16,
        yStrikeoutPosition: int16,
        sFamilyClass: int16,
        panose: new ArrayT(uint8, 10),
        ulCharRange: new ArrayT(uint32, 4),
        vendorID: new StringT(4),
        fsSelection: new Bitfield(uint16, [
            "italic",
            "underscore",
            "negative",
            "outlined",
            "strikeout",
            "bold",
            "regular",
            "useTypoMetrics",
            "wws",
            "oblique"
        ]),
        usFirstCharIndex: uint16,
        usLastCharIndex: uint16 // The maximum Unicode index in this font
    },
    // The Apple version of this table ends here, but the Microsoft one continues on...
    0: {},
    1: {
        typoAscender: int16,
        typoDescender: int16,
        typoLineGap: int16,
        winAscent: uint16,
        winDescent: uint16,
        codePageRange: new ArrayT(uint32, 2)
    },
    2: {
        // these should be common with version 1 somehow
        typoAscender: int16,
        typoDescender: int16,
        typoLineGap: int16,
        winAscent: uint16,
        winDescent: uint16,
        codePageRange: new ArrayT(uint32, 2),
        xHeight: int16,
        capHeight: int16,
        defaultChar: uint16,
        breakChar: uint16,
        maxContent: uint16
    },
    5: {
        typoAscender: int16,
        typoDescender: int16,
        typoLineGap: int16,
        winAscent: uint16,
        winDescent: uint16,
        codePageRange: new ArrayT(uint32, 2),
        xHeight: int16,
        capHeight: int16,
        defaultChar: uint16,
        breakChar: uint16,
        maxContent: uint16,
        usLowerOpticalPointSize: uint16,
        usUpperOpticalPointSize: uint16
    }
});
let $84b272aa31b70606$var$versions = $84b272aa31b70606$var$OS2.versions;
$84b272aa31b70606$var$versions[3] = $84b272aa31b70606$var$versions[4] = $84b272aa31b70606$var$versions[2];
var $84b272aa31b70606$export$2e2bcd8739ae039 = $84b272aa31b70606$var$OS2;



var // PostScript information
$32d9e2eb9565d93c$export$2e2bcd8739ae039 = new VersionedStruct(fixed32, {
    header: {
        italicAngle: fixed32,
        underlinePosition: int16,
        underlineThickness: int16,
        isFixedPitch: uint32,
        minMemType42: uint32,
        maxMemType42: uint32,
        minMemType1: uint32,
        maxMemType1: uint32 // Maximum memory usage when a TrueType font is downloaded as a Type 1 font
    },
    1: {},
    2: {
        numberOfGlyphs: uint16,
        glyphNameIndex: new ArrayT(uint16, "numberOfGlyphs"),
        names: new ArrayT(new StringT(uint8))
    },
    2.5: {
        numberOfGlyphs: uint16,
        offsets: new ArrayT(uint8, "numberOfGlyphs")
    },
    3: {},
    4: {
        map: new ArrayT(uint32, (t)=>t.parent.maxp.numGlyphs)
    }
});



var // An array of predefined values accessible by instructions
$5202bd9d9ad8eaac$export$2e2bcd8739ae039 = new Struct({
    controlValues: new ArrayT(int16)
});



var // A list of instructions that are executed once when a font is first used.
// These instructions are known as the font program. The main use of this table
// is for the definition of functions that are used in many different glyph programs.
$5c0f37ca5ffb1850$export$2e2bcd8739ae039 = new Struct({
    instructions: new ArrayT(uint8)
});



let $2b2b260902b1c57e$var$loca = new VersionedStruct("head.indexToLocFormat", {
    0: {
        offsets: new ArrayT(uint16)
    },
    1: {
        offsets: new ArrayT(uint32)
    }
});
$2b2b260902b1c57e$var$loca.process = function() {
    if (this.version === 0 && !this._processed) {
        for(let i = 0; i < this.offsets.length; i++)this.offsets[i] <<= 1;
        this._processed = true;
    }
};
$2b2b260902b1c57e$var$loca.preEncode = function() {
    if (this.version === 0 && this._processed !== false) {
        for(let i = 0; i < this.offsets.length; i++)this.offsets[i] >>>= 1;
        this._processed = false;
    }
};
var $2b2b260902b1c57e$export$2e2bcd8739ae039 = $2b2b260902b1c57e$var$loca;



var // Set of instructions executed whenever the point size or font transformation change
$7afb878c7bea4f66$export$2e2bcd8739ae039 = new Struct({
    controlValueProgram: new ArrayT(uint8)
});



var // only used for encoding
$6c92b6371bce8bd9$export$2e2bcd8739ae039 = new ArrayT(new BufferT);




class $43e9821ef3717eec$export$2e2bcd8739ae039 {
    getCFFVersion(ctx) {
        while(ctx && !ctx.hdrSize)ctx = ctx.parent;
        return ctx ? ctx.version : -1;
    }
    decode(stream, parent) {
        let version = this.getCFFVersion(parent);
        let count = version >= 2 ? stream.readUInt32BE() : stream.readUInt16BE();
        if (count === 0) return [];
        let offSize = stream.readUInt8();
        let offsetType;
        if (offSize === 1) offsetType = uint8;
        else if (offSize === 2) offsetType = uint16;
        else if (offSize === 3) offsetType = uint24;
        else if (offSize === 4) offsetType = uint32;
        else throw new Error(`Bad offset size in CFFIndex: ${offSize} ${stream.pos}`);
        let ret = [];
        let startPos = stream.pos + (count + 1) * offSize - 1;
        let start = offsetType.decode(stream);
        for(let i = 0; i < count; i++){
            let end = offsetType.decode(stream);
            if (this.type != null) {
                let pos = stream.pos;
                stream.pos = startPos + start;
                parent.length = end - start;
                ret.push(this.type.decode(stream, parent));
                stream.pos = pos;
            } else ret.push({
                offset: startPos + start,
                length: end - start
            });
            start = end;
        }
        stream.pos = startPos + start;
        return ret;
    }
    size(arr, parent) {
        let size = 2;
        if (arr.length === 0) return size;
        let type = this.type || new BufferT;
        // find maximum offset to detminine offset type
        let offset = 1;
        for(let i = 0; i < arr.length; i++){
            let item = arr[i];
            offset += type.size(item, parent);
        }
        let offsetType;
        if (offset <= 0xff) offsetType = uint8;
        else if (offset <= 0xffff) offsetType = uint16;
        else if (offset <= 0xffffff) offsetType = uint24;
        else if (offset <= 0xffffffff) offsetType = uint32;
        else throw new Error("Bad offset in CFFIndex");
        size += 1 + offsetType.size() * (arr.length + 1);
        size += offset - 1;
        return size;
    }
    encode(stream, arr, parent) {
        stream.writeUInt16BE(arr.length);
        if (arr.length === 0) return;
        let type = this.type || new BufferT;
        // find maximum offset to detminine offset type
        let sizes = [];
        let offset = 1;
        for (let item of arr){
            let s = type.size(item, parent);
            sizes.push(s);
            offset += s;
        }
        let offsetType;
        if (offset <= 0xff) offsetType = uint8;
        else if (offset <= 0xffff) offsetType = uint16;
        else if (offset <= 0xffffff) offsetType = uint24;
        else if (offset <= 0xffffffff) offsetType = uint32;
        else throw new Error("Bad offset in CFFIndex");
        // write offset size
        stream.writeUInt8(offsetType.size());
        // write elements
        offset = 1;
        offsetType.encode(stream, offset);
        for (let size of sizes){
            offset += size;
            offsetType.encode(stream, offset);
        }
        for (let item1 of arr)type.encode(stream, item1, parent);
        return;
    }
    constructor(type){
        this.type = type;
    }
}






const $c2d28e92708f99da$var$FLOAT_EOF = 0xf;
const $c2d28e92708f99da$var$FLOAT_LOOKUP = [
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    ".",
    "E",
    "E-",
    null,
    "-"
];
const $c2d28e92708f99da$var$FLOAT_ENCODE_LOOKUP = {
    ".": 10,
    "E": 11,
    "E-": 12,
    "-": 14
};
class $c2d28e92708f99da$export$2e2bcd8739ae039 {
    static decode(stream, value) {
        if (32 <= value && value <= 246) return value - 139;
        if (247 <= value && value <= 250) return (value - 247) * 256 + stream.readUInt8() + 108;
        if (251 <= value && value <= 254) return -(value - 251) * 256 - stream.readUInt8() - 108;
        if (value === 28) return stream.readInt16BE();
        if (value === 29) return stream.readInt32BE();
        if (value === 30) {
            let str = "";
            while(true){
                let b = stream.readUInt8();
                let n1 = b >> 4;
                if (n1 === $c2d28e92708f99da$var$FLOAT_EOF) break;
                str += $c2d28e92708f99da$var$FLOAT_LOOKUP[n1];
                let n2 = b & 15;
                if (n2 === $c2d28e92708f99da$var$FLOAT_EOF) break;
                str += $c2d28e92708f99da$var$FLOAT_LOOKUP[n2];
            }
            return parseFloat(str);
        }
        return null;
    }
    static size(value) {
        // if the value needs to be forced to the largest size (32 bit)
        // e.g. for unknown pointers, set to 32768
        if (value.forceLarge) value = 32768;
        if ((value | 0) !== value) {
            let str = "" + value;
            return 1 + Math.ceil((str.length + 1) / 2);
        } else if (-107 <= value && value <= 107) return 1;
        else if (108 <= value && value <= 1131 || -1131 <= value && value <= -108) return 2;
        else if (-32768 <= value && value <= 32767) return 3;
        else return 5;
    }
    static encode(stream, value) {
        // if the value needs to be forced to the largest size (32 bit)
        // e.g. for unknown pointers, save the old value and set to 32768
        let val = Number(value);
        if (value.forceLarge) {
            stream.writeUInt8(29);
            return stream.writeInt32BE(val);
        } else if ((val | 0) !== val) {
            stream.writeUInt8(30);
            let str = "" + val;
            for(let i = 0; i < str.length; i += 2){
                let c1 = str[i];
                let n1 = $c2d28e92708f99da$var$FLOAT_ENCODE_LOOKUP[c1] || +c1;
                if (i === str.length - 1) var n2 = $c2d28e92708f99da$var$FLOAT_EOF;
                else {
                    let c2 = str[i + 1];
                    var n2 = $c2d28e92708f99da$var$FLOAT_ENCODE_LOOKUP[c2] || +c2;
                }
                stream.writeUInt8(n1 << 4 | n2 & 15);
            }
            if (n2 !== $c2d28e92708f99da$var$FLOAT_EOF) return stream.writeUInt8($c2d28e92708f99da$var$FLOAT_EOF << 4);
        } else if (-107 <= val && val <= 107) return stream.writeUInt8(val + 139);
        else if (108 <= val && val <= 1131) {
            val -= 108;
            stream.writeUInt8((val >> 8) + 247);
            return stream.writeUInt8(val & 0xff);
        } else if (-1131 <= val && val <= -108) {
            val = -val - 108;
            stream.writeUInt8((val >> 8) + 251);
            return stream.writeUInt8(val & 0xff);
        } else if (-32768 <= val && val <= 32767) {
            stream.writeUInt8(28);
            return stream.writeInt16BE(val);
        } else {
            stream.writeUInt8(29);
            return stream.writeInt32BE(val);
        }
    }
}



class $61aa549f16d58b9b$export$2e2bcd8739ae039 {
    decodeOperands(type, stream, ret, operands) {
        if (Array.isArray(type)) return operands.map((op, i)=>this.decodeOperands(type[i], stream, ret, [
                op
            ]));
        else if (type.decode != null) return type.decode(stream, ret, operands);
        else switch(type){
            case "number":
            case "offset":
            case "sid":
                return operands[0];
            case "boolean":
                return !!operands[0];
            default:
                return operands;
        }
    }
    encodeOperands(type, stream, ctx, operands) {
        if (Array.isArray(type)) return operands.map((op, i)=>this.encodeOperands(type[i], stream, ctx, op)[0]);
        else if (type.encode != null) return type.encode(stream, operands, ctx);
        else if (typeof operands === "number") return [
            operands
        ];
        else if (typeof operands === "boolean") return [
            +operands
        ];
        else if (Array.isArray(operands)) return operands;
        else return [
            operands
        ];
    }
    decode(stream, parent) {
        let end = stream.pos + parent.length;
        let ret = {};
        let operands = [];
        // define hidden properties
        Object.defineProperties(ret, {
            parent: {
                value: parent
            },
            _startOffset: {
                value: stream.pos
            }
        });
        // fill in defaults
        for(let key in this.fields){
            let field = this.fields[key];
            ret[field[1]] = field[3];
        }
        while(stream.pos < end){
            let b = stream.readUInt8();
            if (b < 28) {
                if (b === 12) b = b << 8 | stream.readUInt8();
                let field = this.fields[b];
                if (!field) throw new Error(`Unknown operator ${b}`);
                let val = this.decodeOperands(field[2], stream, ret, operands);
                if (val != null) {
                    if (val instanceof (0, PropertyDescriptor)) Object.defineProperty(ret, field[1], val);
                    else ret[field[1]] = val;
                }
                operands = [];
            } else operands.push((0, $c2d28e92708f99da$export$2e2bcd8739ae039).decode(stream, b));
        }
        return ret;
    }
    size(dict, parent, includePointers = true) {
        let ctx = {
            parent: parent,
            val: dict,
            pointerSize: 0,
            startOffset: parent.startOffset || 0
        };
        let len = 0;
        for(let k in this.fields){
            let field = this.fields[k];
            let val = dict[field[1]];
            if (val == null || (0, fast_deep_equal)(val, field[3])) continue;
            let operands = this.encodeOperands(field[2], null, ctx, val);
            for (let op of operands)len += (0, $c2d28e92708f99da$export$2e2bcd8739ae039).size(op);
            let key = Array.isArray(field[0]) ? field[0] : [
                field[0]
            ];
            len += key.length;
        }
        if (includePointers) len += ctx.pointerSize;
        return len;
    }
    encode(stream, dict, parent) {
        let ctx = {
            pointers: [],
            startOffset: stream.pos,
            parent: parent,
            val: dict,
            pointerSize: 0
        };
        ctx.pointerOffset = stream.pos + this.size(dict, ctx, false);
        for (let field of this.ops){
            let val = dict[field[1]];
            if (val == null || (0, fast_deep_equal)(val, field[3])) continue;
            let operands = this.encodeOperands(field[2], stream, ctx, val);
            for (let op of operands)(0, $c2d28e92708f99da$export$2e2bcd8739ae039).encode(stream, op);
            let key = Array.isArray(field[0]) ? field[0] : [
                field[0]
            ];
            for (let op1 of key)stream.writeUInt8(op1);
        }
        let i = 0;
        while(i < ctx.pointers.length){
            let ptr = ctx.pointers[i++];
            ptr.type.encode(stream, ptr.val, ptr.parent);
        }
        return;
    }
    constructor(ops = []){
        this.ops = ops;
        this.fields = {};
        for (let field of ops){
            let key = Array.isArray(field[0]) ? field[0][0] << 8 | field[0][1] : field[0];
            this.fields[key] = field;
        }
    }
}




class $0e34a43d05bde82c$export$2e2bcd8739ae039 extends Pointer {
    decode(stream, parent, operands) {
        this.offsetType = {
            decode: ()=>operands[0]
        };
        return super.decode(stream, parent, operands);
    }
    encode(stream, value, ctx) {
        if (!stream) {
            // compute the size (so ctx.pointerSize is correct)
            this.offsetType = {
                size: ()=>0
            };
            this.size(value, ctx);
            return [
                new $0e34a43d05bde82c$var$Ptr(0)
            ];
        }
        let ptr = null;
        this.offsetType = {
            encode: (stream, val)=>ptr = val
        };
        super.encode(stream, value, ctx);
        return [
            new $0e34a43d05bde82c$var$Ptr(ptr)
        ];
    }
    constructor(type, options = {}){
        if (options.type == null) options.type = "global";
        super(null, type, options);
    }
}
class $0e34a43d05bde82c$var$Ptr {
    valueOf() {
        return this.val;
    }
    constructor(val){
        this.val = val;
        this.forceLarge = true;
    }
}





class $6d59db2e29cc77b3$var$CFFBlendOp {
    static decode(stream, parent, operands) {
        let numBlends = operands.pop();
        // TODO: actually blend. For now just consume the deltas
        // since we don't use any of the values anyway.
        while(operands.length > numBlends)operands.pop();
    }
}
var $6d59db2e29cc77b3$export$2e2bcd8739ae039 = new (0, $61aa549f16d58b9b$export$2e2bcd8739ae039)([
    // key       name                    type                                          default
    [
        6,
        "BlueValues",
        "delta",
        null
    ],
    [
        7,
        "OtherBlues",
        "delta",
        null
    ],
    [
        8,
        "FamilyBlues",
        "delta",
        null
    ],
    [
        9,
        "FamilyOtherBlues",
        "delta",
        null
    ],
    [
        [
            12,
            9
        ],
        "BlueScale",
        "number",
        0.039625
    ],
    [
        [
            12,
            10
        ],
        "BlueShift",
        "number",
        7
    ],
    [
        [
            12,
            11
        ],
        "BlueFuzz",
        "number",
        1
    ],
    [
        10,
        "StdHW",
        "number",
        null
    ],
    [
        11,
        "StdVW",
        "number",
        null
    ],
    [
        [
            12,
            12
        ],
        "StemSnapH",
        "delta",
        null
    ],
    [
        [
            12,
            13
        ],
        "StemSnapV",
        "delta",
        null
    ],
    [
        [
            12,
            14
        ],
        "ForceBold",
        "boolean",
        false
    ],
    [
        [
            12,
            17
        ],
        "LanguageGroup",
        "number",
        0
    ],
    [
        [
            12,
            18
        ],
        "ExpansionFactor",
        "number",
        0.06
    ],
    [
        [
            12,
            19
        ],
        "initialRandomSeed",
        "number",
        0
    ],
    [
        20,
        "defaultWidthX",
        "number",
        0
    ],
    [
        21,
        "nominalWidthX",
        "number",
        0
    ],
    [
        22,
        "vsindex",
        "number",
        0
    ],
    [
        23,
        "blend",
        $6d59db2e29cc77b3$var$CFFBlendOp,
        null
    ],
    [
        19,
        "Subrs",
        new (0, $0e34a43d05bde82c$export$2e2bcd8739ae039)(new (0, $43e9821ef3717eec$export$2e2bcd8739ae039), {
            type: "local"
        }),
        null
    ]
]);


var // Automatically generated from Appendix A of the CFF specification; do
// not edit. Length should be 391.
$229224aec43783c5$export$2e2bcd8739ae039 = [
    ".notdef",
    "space",
    "exclam",
    "quotedbl",
    "numbersign",
    "dollar",
    "percent",
    "ampersand",
    "quoteright",
    "parenleft",
    "parenright",
    "asterisk",
    "plus",
    "comma",
    "hyphen",
    "period",
    "slash",
    "zero",
    "one",
    "two",
    "three",
    "four",
    "five",
    "six",
    "seven",
    "eight",
    "nine",
    "colon",
    "semicolon",
    "less",
    "equal",
    "greater",
    "question",
    "at",
    "A",
    "B",
    "C",
    "D",
    "E",
    "F",
    "G",
    "H",
    "I",
    "J",
    "K",
    "L",
    "M",
    "N",
    "O",
    "P",
    "Q",
    "R",
    "S",
    "T",
    "U",
    "V",
    "W",
    "X",
    "Y",
    "Z",
    "bracketleft",
    "backslash",
    "bracketright",
    "asciicircum",
    "underscore",
    "quoteleft",
    "a",
    "b",
    "c",
    "d",
    "e",
    "f",
    "g",
    "h",
    "i",
    "j",
    "k",
    "l",
    "m",
    "n",
    "o",
    "p",
    "q",
    "r",
    "s",
    "t",
    "u",
    "v",
    "w",
    "x",
    "y",
    "z",
    "braceleft",
    "bar",
    "braceright",
    "asciitilde",
    "exclamdown",
    "cent",
    "sterling",
    "fraction",
    "yen",
    "florin",
    "section",
    "currency",
    "quotesingle",
    "quotedblleft",
    "guillemotleft",
    "guilsinglleft",
    "guilsinglright",
    "fi",
    "fl",
    "endash",
    "dagger",
    "daggerdbl",
    "periodcentered",
    "paragraph",
    "bullet",
    "quotesinglbase",
    "quotedblbase",
    "quotedblright",
    "guillemotright",
    "ellipsis",
    "perthousand",
    "questiondown",
    "grave",
    "acute",
    "circumflex",
    "tilde",
    "macron",
    "breve",
    "dotaccent",
    "dieresis",
    "ring",
    "cedilla",
    "hungarumlaut",
    "ogonek",
    "caron",
    "emdash",
    "AE",
    "ordfeminine",
    "Lslash",
    "Oslash",
    "OE",
    "ordmasculine",
    "ae",
    "dotlessi",
    "lslash",
    "oslash",
    "oe",
    "germandbls",
    "onesuperior",
    "logicalnot",
    "mu",
    "trademark",
    "Eth",
    "onehalf",
    "plusminus",
    "Thorn",
    "onequarter",
    "divide",
    "brokenbar",
    "degree",
    "thorn",
    "threequarters",
    "twosuperior",
    "registered",
    "minus",
    "eth",
    "multiply",
    "threesuperior",
    "copyright",
    "Aacute",
    "Acircumflex",
    "Adieresis",
    "Agrave",
    "Aring",
    "Atilde",
    "Ccedilla",
    "Eacute",
    "Ecircumflex",
    "Edieresis",
    "Egrave",
    "Iacute",
    "Icircumflex",
    "Idieresis",
    "Igrave",
    "Ntilde",
    "Oacute",
    "Ocircumflex",
    "Odieresis",
    "Ograve",
    "Otilde",
    "Scaron",
    "Uacute",
    "Ucircumflex",
    "Udieresis",
    "Ugrave",
    "Yacute",
    "Ydieresis",
    "Zcaron",
    "aacute",
    "acircumflex",
    "adieresis",
    "agrave",
    "aring",
    "atilde",
    "ccedilla",
    "eacute",
    "ecircumflex",
    "edieresis",
    "egrave",
    "iacute",
    "icircumflex",
    "idieresis",
    "igrave",
    "ntilde",
    "oacute",
    "ocircumflex",
    "odieresis",
    "ograve",
    "otilde",
    "scaron",
    "uacute",
    "ucircumflex",
    "udieresis",
    "ugrave",
    "yacute",
    "ydieresis",
    "zcaron",
    "exclamsmall",
    "Hungarumlautsmall",
    "dollaroldstyle",
    "dollarsuperior",
    "ampersandsmall",
    "Acutesmall",
    "parenleftsuperior",
    "parenrightsuperior",
    "twodotenleader",
    "onedotenleader",
    "zerooldstyle",
    "oneoldstyle",
    "twooldstyle",
    "threeoldstyle",
    "fouroldstyle",
    "fiveoldstyle",
    "sixoldstyle",
    "sevenoldstyle",
    "eightoldstyle",
    "nineoldstyle",
    "commasuperior",
    "threequartersemdash",
    "periodsuperior",
    "questionsmall",
    "asuperior",
    "bsuperior",
    "centsuperior",
    "dsuperior",
    "esuperior",
    "isuperior",
    "lsuperior",
    "msuperior",
    "nsuperior",
    "osuperior",
    "rsuperior",
    "ssuperior",
    "tsuperior",
    "ff",
    "ffi",
    "ffl",
    "parenleftinferior",
    "parenrightinferior",
    "Circumflexsmall",
    "hyphensuperior",
    "Gravesmall",
    "Asmall",
    "Bsmall",
    "Csmall",
    "Dsmall",
    "Esmall",
    "Fsmall",
    "Gsmall",
    "Hsmall",
    "Ismall",
    "Jsmall",
    "Ksmall",
    "Lsmall",
    "Msmall",
    "Nsmall",
    "Osmall",
    "Psmall",
    "Qsmall",
    "Rsmall",
    "Ssmall",
    "Tsmall",
    "Usmall",
    "Vsmall",
    "Wsmall",
    "Xsmall",
    "Ysmall",
    "Zsmall",
    "colonmonetary",
    "onefitted",
    "rupiah",
    "Tildesmall",
    "exclamdownsmall",
    "centoldstyle",
    "Lslashsmall",
    "Scaronsmall",
    "Zcaronsmall",
    "Dieresissmall",
    "Brevesmall",
    "Caronsmall",
    "Dotaccentsmall",
    "Macronsmall",
    "figuredash",
    "hypheninferior",
    "Ogoneksmall",
    "Ringsmall",
    "Cedillasmall",
    "questiondownsmall",
    "oneeighth",
    "threeeighths",
    "fiveeighths",
    "seveneighths",
    "onethird",
    "twothirds",
    "zerosuperior",
    "foursuperior",
    "fivesuperior",
    "sixsuperior",
    "sevensuperior",
    "eightsuperior",
    "ninesuperior",
    "zeroinferior",
    "oneinferior",
    "twoinferior",
    "threeinferior",
    "fourinferior",
    "fiveinferior",
    "sixinferior",
    "seveninferior",
    "eightinferior",
    "nineinferior",
    "centinferior",
    "dollarinferior",
    "periodinferior",
    "commainferior",
    "Agravesmall",
    "Aacutesmall",
    "Acircumflexsmall",
    "Atildesmall",
    "Adieresissmall",
    "Aringsmall",
    "AEsmall",
    "Ccedillasmall",
    "Egravesmall",
    "Eacutesmall",
    "Ecircumflexsmall",
    "Edieresissmall",
    "Igravesmall",
    "Iacutesmall",
    "Icircumflexsmall",
    "Idieresissmall",
    "Ethsmall",
    "Ntildesmall",
    "Ogravesmall",
    "Oacutesmall",
    "Ocircumflexsmall",
    "Otildesmall",
    "Odieresissmall",
    "OEsmall",
    "Oslashsmall",
    "Ugravesmall",
    "Uacutesmall",
    "Ucircumflexsmall",
    "Udieresissmall",
    "Yacutesmall",
    "Thornsmall",
    "Ydieresissmall",
    "001.000",
    "001.001",
    "001.002",
    "001.003",
    "Black",
    "Bold",
    "Book",
    "Light",
    "Medium",
    "Regular",
    "Roman",
    "Semibold"
];


let $bc0433d9b7e41f5f$export$dee0027060fa13bd = [
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "space",
    "exclam",
    "quotedbl",
    "numbersign",
    "dollar",
    "percent",
    "ampersand",
    "quoteright",
    "parenleft",
    "parenright",
    "asterisk",
    "plus",
    "comma",
    "hyphen",
    "period",
    "slash",
    "zero",
    "one",
    "two",
    "three",
    "four",
    "five",
    "six",
    "seven",
    "eight",
    "nine",
    "colon",
    "semicolon",
    "less",
    "equal",
    "greater",
    "question",
    "at",
    "A",
    "B",
    "C",
    "D",
    "E",
    "F",
    "G",
    "H",
    "I",
    "J",
    "K",
    "L",
    "M",
    "N",
    "O",
    "P",
    "Q",
    "R",
    "S",
    "T",
    "U",
    "V",
    "W",
    "X",
    "Y",
    "Z",
    "bracketleft",
    "backslash",
    "bracketright",
    "asciicircum",
    "underscore",
    "quoteleft",
    "a",
    "b",
    "c",
    "d",
    "e",
    "f",
    "g",
    "h",
    "i",
    "j",
    "k",
    "l",
    "m",
    "n",
    "o",
    "p",
    "q",
    "r",
    "s",
    "t",
    "u",
    "v",
    "w",
    "x",
    "y",
    "z",
    "braceleft",
    "bar",
    "braceright",
    "asciitilde",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "exclamdown",
    "cent",
    "sterling",
    "fraction",
    "yen",
    "florin",
    "section",
    "currency",
    "quotesingle",
    "quotedblleft",
    "guillemotleft",
    "guilsinglleft",
    "guilsinglright",
    "fi",
    "fl",
    "",
    "endash",
    "dagger",
    "daggerdbl",
    "periodcentered",
    "",
    "paragraph",
    "bullet",
    "quotesinglbase",
    "quotedblbase",
    "quotedblright",
    "guillemotright",
    "ellipsis",
    "perthousand",
    "",
    "questiondown",
    "",
    "grave",
    "acute",
    "circumflex",
    "tilde",
    "macron",
    "breve",
    "dotaccent",
    "dieresis",
    "",
    "ring",
    "cedilla",
    "",
    "hungarumlaut",
    "ogonek",
    "caron",
    "emdash",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "AE",
    "",
    "ordfeminine",
    "",
    "",
    "",
    "",
    "Lslash",
    "Oslash",
    "OE",
    "ordmasculine",
    "",
    "",
    "",
    "",
    "",
    "ae",
    "",
    "",
    "",
    "dotlessi",
    "",
    "",
    "lslash",
    "oslash",
    "oe",
    "germandbls"
];
let $bc0433d9b7e41f5f$export$4f58f497e14a53c3 = [
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "space",
    "exclamsmall",
    "Hungarumlautsmall",
    "",
    "dollaroldstyle",
    "dollarsuperior",
    "ampersandsmall",
    "Acutesmall",
    "parenleftsuperior",
    "parenrightsuperior",
    "twodotenleader",
    "onedotenleader",
    "comma",
    "hyphen",
    "period",
    "fraction",
    "zerooldstyle",
    "oneoldstyle",
    "twooldstyle",
    "threeoldstyle",
    "fouroldstyle",
    "fiveoldstyle",
    "sixoldstyle",
    "sevenoldstyle",
    "eightoldstyle",
    "nineoldstyle",
    "colon",
    "semicolon",
    "commasuperior",
    "threequartersemdash",
    "periodsuperior",
    "questionsmall",
    "",
    "asuperior",
    "bsuperior",
    "centsuperior",
    "dsuperior",
    "esuperior",
    "",
    "",
    "isuperior",
    "",
    "",
    "lsuperior",
    "msuperior",
    "nsuperior",
    "osuperior",
    "",
    "",
    "rsuperior",
    "ssuperior",
    "tsuperior",
    "",
    "ff",
    "fi",
    "fl",
    "ffi",
    "ffl",
    "parenleftinferior",
    "",
    "parenrightinferior",
    "Circumflexsmall",
    "hyphensuperior",
    "Gravesmall",
    "Asmall",
    "Bsmall",
    "Csmall",
    "Dsmall",
    "Esmall",
    "Fsmall",
    "Gsmall",
    "Hsmall",
    "Ismall",
    "Jsmall",
    "Ksmall",
    "Lsmall",
    "Msmall",
    "Nsmall",
    "Osmall",
    "Psmall",
    "Qsmall",
    "Rsmall",
    "Ssmall",
    "Tsmall",
    "Usmall",
    "Vsmall",
    "Wsmall",
    "Xsmall",
    "Ysmall",
    "Zsmall",
    "colonmonetary",
    "onefitted",
    "rupiah",
    "Tildesmall",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "exclamdownsmall",
    "centoldstyle",
    "Lslashsmall",
    "",
    "",
    "Scaronsmall",
    "Zcaronsmall",
    "Dieresissmall",
    "Brevesmall",
    "Caronsmall",
    "",
    "Dotaccentsmall",
    "",
    "",
    "Macronsmall",
    "",
    "",
    "figuredash",
    "hypheninferior",
    "",
    "",
    "Ogoneksmall",
    "Ringsmall",
    "Cedillasmall",
    "",
    "",
    "",
    "onequarter",
    "onehalf",
    "threequarters",
    "questiondownsmall",
    "oneeighth",
    "threeeighths",
    "fiveeighths",
    "seveneighths",
    "onethird",
    "twothirds",
    "",
    "",
    "zerosuperior",
    "onesuperior",
    "twosuperior",
    "threesuperior",
    "foursuperior",
    "fivesuperior",
    "sixsuperior",
    "sevensuperior",
    "eightsuperior",
    "ninesuperior",
    "zeroinferior",
    "oneinferior",
    "twoinferior",
    "threeinferior",
    "fourinferior",
    "fiveinferior",
    "sixinferior",
    "seveninferior",
    "eightinferior",
    "nineinferior",
    "centinferior",
    "dollarinferior",
    "periodinferior",
    "commainferior",
    "Agravesmall",
    "Aacutesmall",
    "Acircumflexsmall",
    "Atildesmall",
    "Adieresissmall",
    "Aringsmall",
    "AEsmall",
    "Ccedillasmall",
    "Egravesmall",
    "Eacutesmall",
    "Ecircumflexsmall",
    "Edieresissmall",
    "Igravesmall",
    "Iacutesmall",
    "Icircumflexsmall",
    "Idieresissmall",
    "Ethsmall",
    "Ntildesmall",
    "Ogravesmall",
    "Oacutesmall",
    "Ocircumflexsmall",
    "Otildesmall",
    "Odieresissmall",
    "OEsmall",
    "Oslashsmall",
    "Ugravesmall",
    "Uacutesmall",
    "Ucircumflexsmall",
    "Udieresissmall",
    "Yacutesmall",
    "Thornsmall",
    "Ydieresissmall"
];


let $ef658f5c9a1488b2$export$c33b50336c234f16 = [
    ".notdef",
    "space",
    "exclam",
    "quotedbl",
    "numbersign",
    "dollar",
    "percent",
    "ampersand",
    "quoteright",
    "parenleft",
    "parenright",
    "asterisk",
    "plus",
    "comma",
    "hyphen",
    "period",
    "slash",
    "zero",
    "one",
    "two",
    "three",
    "four",
    "five",
    "six",
    "seven",
    "eight",
    "nine",
    "colon",
    "semicolon",
    "less",
    "equal",
    "greater",
    "question",
    "at",
    "A",
    "B",
    "C",
    "D",
    "E",
    "F",
    "G",
    "H",
    "I",
    "J",
    "K",
    "L",
    "M",
    "N",
    "O",
    "P",
    "Q",
    "R",
    "S",
    "T",
    "U",
    "V",
    "W",
    "X",
    "Y",
    "Z",
    "bracketleft",
    "backslash",
    "bracketright",
    "asciicircum",
    "underscore",
    "quoteleft",
    "a",
    "b",
    "c",
    "d",
    "e",
    "f",
    "g",
    "h",
    "i",
    "j",
    "k",
    "l",
    "m",
    "n",
    "o",
    "p",
    "q",
    "r",
    "s",
    "t",
    "u",
    "v",
    "w",
    "x",
    "y",
    "z",
    "braceleft",
    "bar",
    "braceright",
    "asciitilde",
    "exclamdown",
    "cent",
    "sterling",
    "fraction",
    "yen",
    "florin",
    "section",
    "currency",
    "quotesingle",
    "quotedblleft",
    "guillemotleft",
    "guilsinglleft",
    "guilsinglright",
    "fi",
    "fl",
    "endash",
    "dagger",
    "daggerdbl",
    "periodcentered",
    "paragraph",
    "bullet",
    "quotesinglbase",
    "quotedblbase",
    "quotedblright",
    "guillemotright",
    "ellipsis",
    "perthousand",
    "questiondown",
    "grave",
    "acute",
    "circumflex",
    "tilde",
    "macron",
    "breve",
    "dotaccent",
    "dieresis",
    "ring",
    "cedilla",
    "hungarumlaut",
    "ogonek",
    "caron",
    "emdash",
    "AE",
    "ordfeminine",
    "Lslash",
    "Oslash",
    "OE",
    "ordmasculine",
    "ae",
    "dotlessi",
    "lslash",
    "oslash",
    "oe",
    "germandbls",
    "onesuperior",
    "logicalnot",
    "mu",
    "trademark",
    "Eth",
    "onehalf",
    "plusminus",
    "Thorn",
    "onequarter",
    "divide",
    "brokenbar",
    "degree",
    "thorn",
    "threequarters",
    "twosuperior",
    "registered",
    "minus",
    "eth",
    "multiply",
    "threesuperior",
    "copyright",
    "Aacute",
    "Acircumflex",
    "Adieresis",
    "Agrave",
    "Aring",
    "Atilde",
    "Ccedilla",
    "Eacute",
    "Ecircumflex",
    "Edieresis",
    "Egrave",
    "Iacute",
    "Icircumflex",
    "Idieresis",
    "Igrave",
    "Ntilde",
    "Oacute",
    "Ocircumflex",
    "Odieresis",
    "Ograve",
    "Otilde",
    "Scaron",
    "Uacute",
    "Ucircumflex",
    "Udieresis",
    "Ugrave",
    "Yacute",
    "Ydieresis",
    "Zcaron",
    "aacute",
    "acircumflex",
    "adieresis",
    "agrave",
    "aring",
    "atilde",
    "ccedilla",
    "eacute",
    "ecircumflex",
    "edieresis",
    "egrave",
    "iacute",
    "icircumflex",
    "idieresis",
    "igrave",
    "ntilde",
    "oacute",
    "ocircumflex",
    "odieresis",
    "ograve",
    "otilde",
    "scaron",
    "uacute",
    "ucircumflex",
    "udieresis",
    "ugrave",
    "yacute",
    "ydieresis",
    "zcaron"
];
let $ef658f5c9a1488b2$export$3ed0f9e1fee8d489 = [
    ".notdef",
    "space",
    "exclamsmall",
    "Hungarumlautsmall",
    "dollaroldstyle",
    "dollarsuperior",
    "ampersandsmall",
    "Acutesmall",
    "parenleftsuperior",
    "parenrightsuperior",
    "twodotenleader",
    "onedotenleader",
    "comma",
    "hyphen",
    "period",
    "fraction",
    "zerooldstyle",
    "oneoldstyle",
    "twooldstyle",
    "threeoldstyle",
    "fouroldstyle",
    "fiveoldstyle",
    "sixoldstyle",
    "sevenoldstyle",
    "eightoldstyle",
    "nineoldstyle",
    "colon",
    "semicolon",
    "commasuperior",
    "threequartersemdash",
    "periodsuperior",
    "questionsmall",
    "asuperior",
    "bsuperior",
    "centsuperior",
    "dsuperior",
    "esuperior",
    "isuperior",
    "lsuperior",
    "msuperior",
    "nsuperior",
    "osuperior",
    "rsuperior",
    "ssuperior",
    "tsuperior",
    "ff",
    "fi",
    "fl",
    "ffi",
    "ffl",
    "parenleftinferior",
    "parenrightinferior",
    "Circumflexsmall",
    "hyphensuperior",
    "Gravesmall",
    "Asmall",
    "Bsmall",
    "Csmall",
    "Dsmall",
    "Esmall",
    "Fsmall",
    "Gsmall",
    "Hsmall",
    "Ismall",
    "Jsmall",
    "Ksmall",
    "Lsmall",
    "Msmall",
    "Nsmall",
    "Osmall",
    "Psmall",
    "Qsmall",
    "Rsmall",
    "Ssmall",
    "Tsmall",
    "Usmall",
    "Vsmall",
    "Wsmall",
    "Xsmall",
    "Ysmall",
    "Zsmall",
    "colonmonetary",
    "onefitted",
    "rupiah",
    "Tildesmall",
    "exclamdownsmall",
    "centoldstyle",
    "Lslashsmall",
    "Scaronsmall",
    "Zcaronsmall",
    "Dieresissmall",
    "Brevesmall",
    "Caronsmall",
    "Dotaccentsmall",
    "Macronsmall",
    "figuredash",
    "hypheninferior",
    "Ogoneksmall",
    "Ringsmall",
    "Cedillasmall",
    "onequarter",
    "onehalf",
    "threequarters",
    "questiondownsmall",
    "oneeighth",
    "threeeighths",
    "fiveeighths",
    "seveneighths",
    "onethird",
    "twothirds",
    "zerosuperior",
    "onesuperior",
    "twosuperior",
    "threesuperior",
    "foursuperior",
    "fivesuperior",
    "sixsuperior",
    "sevensuperior",
    "eightsuperior",
    "ninesuperior",
    "zeroinferior",
    "oneinferior",
    "twoinferior",
    "threeinferior",
    "fourinferior",
    "fiveinferior",
    "sixinferior",
    "seveninferior",
    "eightinferior",
    "nineinferior",
    "centinferior",
    "dollarinferior",
    "periodinferior",
    "commainferior",
    "Agravesmall",
    "Aacutesmall",
    "Acircumflexsmall",
    "Atildesmall",
    "Adieresissmall",
    "Aringsmall",
    "AEsmall",
    "Ccedillasmall",
    "Egravesmall",
    "Eacutesmall",
    "Ecircumflexsmall",
    "Edieresissmall",
    "Igravesmall",
    "Iacutesmall",
    "Icircumflexsmall",
    "Idieresissmall",
    "Ethsmall",
    "Ntildesmall",
    "Ogravesmall",
    "Oacutesmall",
    "Ocircumflexsmall",
    "Otildesmall",
    "Odieresissmall",
    "OEsmall",
    "Oslashsmall",
    "Ugravesmall",
    "Uacutesmall",
    "Ucircumflexsmall",
    "Udieresissmall",
    "Yacutesmall",
    "Thornsmall",
    "Ydieresissmall"
];
let $ef658f5c9a1488b2$export$dc28be11139d4120 = [
    ".notdef",
    "space",
    "dollaroldstyle",
    "dollarsuperior",
    "parenleftsuperior",
    "parenrightsuperior",
    "twodotenleader",
    "onedotenleader",
    "comma",
    "hyphen",
    "period",
    "fraction",
    "zerooldstyle",
    "oneoldstyle",
    "twooldstyle",
    "threeoldstyle",
    "fouroldstyle",
    "fiveoldstyle",
    "sixoldstyle",
    "sevenoldstyle",
    "eightoldstyle",
    "nineoldstyle",
    "colon",
    "semicolon",
    "commasuperior",
    "threequartersemdash",
    "periodsuperior",
    "asuperior",
    "bsuperior",
    "centsuperior",
    "dsuperior",
    "esuperior",
    "isuperior",
    "lsuperior",
    "msuperior",
    "nsuperior",
    "osuperior",
    "rsuperior",
    "ssuperior",
    "tsuperior",
    "ff",
    "fi",
    "fl",
    "ffi",
    "ffl",
 