-- Create avatars bucket if it does not exist
do $$
begin
  insert into storage.buckets (id, name, public)
  values ('avatars', 'avatars', true)
  on conflict (id) do nothing;
end $$;

-- Allow anyone to read avatar images
do $$
begin
  if not exists (
    select 1
    from pg_policies
    where schemaname = 'storage'
      and tablename = 'objects'
      and policyname = 'Anyone can view avatars'
  ) then
    create policy "Anyone can view avatars"
      on storage.objects for select
      using (bucket_id = 'avatars');
  end if;
end $$;

-- Allow authenticated users to upload/update/delete their own avatar files
do $$
begin
  if not exists (
    select 1
    from pg_policies
    where schemaname = 'storage'
      and tablename = 'objects'
      and policyname = 'Users can upload their own avatars'
  ) then
    create policy "Users can upload their own avatars"
      on storage.objects for insert
      to authenticated
      with check (
        bucket_id = 'avatars'
        and auth.uid() = owner
      );
  end if;
end $$;

do $$
begin
  if not exists (
    select 1
    from pg_policies
    where schemaname = 'storage'
      and tablename = 'objects'
      and policyname = 'Users can update their own avatars'
  ) then
    create policy "Users can update their own avatars"
      on storage.objects for update
      to authenticated
      using (
        bucket_id = 'avatars'
        and auth.uid() = owner
      );
  end if;
end $$;

do $$
begin
  if not exists (
    select 1
    from pg_policies
    where schemaname = 'storage'
      and tablename = 'objects'
      and policyname = 'Users can delete their own avatars'
  ) then
    create policy "Users can delete their own avatars"
      on storage.objects for delete
      to authenticated
      using (
        bucket_id = 'avatars'
        and auth.uid() = owner
      );
  end if;
end $$;
