-- Allow team invitations to find users by email without exposing full profiles
set search_path = public, extensions, pg_temp;

create or replace function find_profile_by_email(search_email text)
returns table (
  id uuid,
  full_name text,
  email text,
  avatar_url text
) as $$
begin
  return query
  select p.id, p.full_name, p.email, p.avatar_url
  from profiles p
  where lower(p.email) = lower(search_email)
  limit 1;
end;
$$ language plpgsql security definer;

grant execute on function find_profile_by_email(text) to authenticated;
