set search_path = public, extensions, pg_temp;

-- Ensure team owners can invite members
alter table if exists team_members enable row level security;

do $$
begin
  if not exists (
    select 1
    from pg_policies
    where schemaname = 'public'
      and tablename = 'team_members'
      and policyname = 'Owners can add team members'
  ) then
    create policy "Owners can add team members" on team_members
      for insert
      to authenticated
      with check (owner_id = auth.uid());
  end if;
end;
$$;