-- Helper function to invite a member with proper auth checks and upsert behavior
create or replace function invite_team_member(invite_email text, invite_role text default 'Colaborador')
returns team_members
language plpgsql
security definer
as $$
declare
  owner uuid;
  target_profile record;
  inserted_row team_members;
begin
  owner := auth.uid();

  if owner is null then
    raise exception using errcode = 'P0001', message = 'NOT_AUTHENTICATED';
  end if;

  select *
  into target_profile
  from find_profile_by_email(invite_email)
  limit 1;

  if target_profile.id is null then
    raise exception using errcode = 'P0001', message = 'PROFILE_NOT_FOUND';
  end if;

 insert into team_members(owner_id, member_id, email, role, status)
  values (
    owner,
    target_profile.id,
    coalesce(target_profile.email, lower(invite_email)),
    invite_role,
    'active'
  )
  on conflict (owner_id, member_id) do update
    set
      role = excluded.role,
      status = 'active',
      email = excluded.email
  returning *
  into inserted_row;

  return inserted_row;
end;
$$;

grant execute on function invite_team_member(text, text) to authenticated;
