-- Add recurrence-related fields to tasks
alter table if exists public.tasks
  add column if not exists recurrence_pattern text,
  add column if not exists recurrence_interval integer,
  add column if not exists recurrence_end_date timestamptz,
  add column if not exists parent_task_id uuid;

-- Add foreign key to self-reference tasks
alter table if exists public.tasks
  add constraint tasks_parent_task_id_fkey foreign key (parent_task_id) references public.tasks(id) on delete set null;

-- Ensure recurrence interval is positive when a pattern exists
alter table if exists public.tasks
  add constraint tasks_recurrence_interval_positive check (
    recurrence_pattern is null or recurrence_interval > 0
  );

-- Helpful index for parent task lookups
create index if not exists idx_tasks_parent_task_id on public.tasks(parent_task_id);
